# dcl_stats_n_plots
> An interactive widget to compute statistics and plot your data


This repository is part of the **DCLwidgets** series. 
These repositories are dedicated to foster the joint development of tools and resources by the [Defense Circuits Lab](https://www.defense-circuits-lab.com/). 
The intended use of each tool may vary greatly from very lab- and/or analysis-specific problems, to tools and resources that may be of use also for other researchers.
The common goal for each repository, however, is to provide the tool as an interactive, userfriendly, and intuitive GUI so that the user needs little to no coding expertise.

List of all repositories of the DCLwidgets series:
- [dcl_stats_n_plots](https://github.com/DSegebarth/dcl_stats_n_plots/): A widget to compute statistics and plot the data with several options to customize the plot
- [DCL_to_NWB](https://github.com/DSegebarth/DCL_to_NWB/): A widget to convert datasets acquired in the DCL into the NWB file format
- [BSc_MS](https://github.com/DSegebarth/BSc_MS/): A widget to annotate the corners of a maze within video files and save the corresponding x- and y-coordinates

---

## About this widget

The purpose of this widget is to make everyday life in the lab a little easier, as it helps you to compute statistical tests and to create
highly customizable plots that visualize your data. The widget also enables you to select exactly which statistical results you would like to annotate within the plots. This way, statistical analysis and visualization of your data is what it should be - simple & fast!

Please get in touch if you have any feedback, questions, or feature requests for us!

---

## How to use

We provide comprehensive tutorials that explain step-by-step how to use dcl_stats_n_plots.

If you would like to use our GUI, please check out our [GUI tutorial](https://dsegebarth.github.io/dcl_stats_n_plots/gui_tutorial.html).

If you would like to use our API instead, you can also find our [API tutorial here](https://dsegebarth.github.io/dcl_stats_n_plots/api_tutorial.html).

If you have access to the local server of the DCL, the entire installation and setup process was already completed for you and you can start using the tool right away. For how to do this, please check out our [tutorial on how to launch the GUI on the DCL server](https://dsegebarth.github.io/dcl_stats_n_plots/dcl_tutorial.html).

If you want to use dcl_stats_n_plots on your local computer, please find our installation guide below.

## Installation

Installation from PyPi:

`pip install dcl-stats-n-plots`

{% include note.html content='Detailed installation guide to come' %}

## Next steps

The next steps include:

* Discuss tests and their use with members of the lab and institute to make sure they follow best practices
* Extend documentation
* Provide detailed installation guide for users that don´t have access to the DCL server or want to use it on their local computer
* implement tests & plots for repeated measurements
* implement 'dashboard' functionalities for selected projects within the [DCL](https://www.defense-circuits-lab.com/) or the [CRC Retune](https://retune.science/)

