# Fix Agent

一个专业的代码缺陷修复协调专家，拥有三个专业子代理团队。

##  特性

- **智能缺陷分析**: 自动识别语法错误、逻辑问题、性能瓶颈和安全隐患
- **精准代码修复**: 基于AI的自动化代码修复方案
- **全面验证机制**: 确保修复有效且无新问题
- **丰富动画效果**: 现代化的CLI交互体验
- **多语言支持**: Python、JavaScript、C/C++、Java等

##  快速安装

```bash
pip install fix-agent
```

##  核心功能

### 专业子代理团队

1. **defect-analyzer** 
   - 语法分析：检查语法错误、类型错误、导入错误
   - 逻辑分析：识别逻辑漏洞、边界条件处理
   - 性能分析：发现性能瓶颈、资源泄漏
   - 安全分析：检查SQL注入、XSS、权限绕过

2. **code-fixer** 
   - 智能修复：基于分析报告自动修复代码
   - 策略优化：选择最佳修复方案
   - 兼容性保证：确保修复不破坏现有功能

3. **fix-validator** 🛡
   - 测试验证：运行单元测试和集成测试
   - 静态分析：验证代码质量标准
   - 安全扫描：确保修复无安全风险

##  使用方法

### 基本命令

```bash
# 启动Fix Agent
fix-agent

# 或者使用别名
fixagent

# 显示帮助
fix-agent help

# 列出可用代理
fix-agent list

# 重置代理状态
fix-agent reset --agent my-agent
```

### 交互式使用

启动后，你可以：
- 直接输入需要分析的代码问题
- 使用 `@文件路径` 引用代码文件
- 使用 `/命令` 执行系统操作
- 使用 `!命令` 执行shell命令



##  开发模式安装

```bash
git clone https://github.com/yourusername/Fix_agent.git
cd Fix_agent
pip install -e .
```

## 系统要求

- Python 3.11+
- 支持的操作系统：Windows、macOS、Linux

##  配置

### 环境变量

```bash
# OpenAI API密钥
export OPENAI_API_KEY=your_openai_key

# Anthropic API密钥
export ANTHROPIC_API_KEY=your_anthropic_key

# Tavily搜索API密钥（可选）
export TAVILY_API_KEY=your_tavily_key
```

### 配置文件

创建 `.env` 文件：

```
OPENAI_API_KEY=your_key_here
ANTHROPIC_API_KEY=your_key_here
TAVILY_API_KEY=your_key_here
```

##  示例

### 分析代码缺陷

```bash
fix-agent
> 请分析这个Python文件的潜在问题 @app.py
```

### 修复特定问题

```bash
fix-agent
> 这个函数有内存泄漏，请帮我修复
```

### 批量代码审查

```bash
fix-agent
> 请审查整个src目录的代码质量
```

##  许可证

MIT License

##  相关链接

- [GitHub仓库](https://github.com/3uyuan1ee/Fix_agent)
- [问题反馈](https://github.com/3uyuan1ee/Fix_agent/issues)
- [更新日志](https://github.com/3uyuan1ee/Fix_agent/blob/main/CHANGELOG.md)