/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.model;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.map.writer.OSMTagMapping;
import org.mapsforge.map.writer.model.EncodingChoice;
import org.mapsforge.map.writer.model.ZoomIntervalConfiguration;

public class MapWriterConfiguration {
    private BoundingBox bboxConfiguration;
    private int bboxEnlargement;
    private String comment;
    private String dataProcessorType;
    private boolean debugStrings;
    private EncodingChoice encodingChoice;
    private int fileSpecificationVersion;
    private boolean labelPosition;
    private LatLong mapStartPosition;
    private int mapStartZoomLevel;
    private File outputFile;
    private boolean polygonClipping;
    private boolean polylabel;
    private List<String> preferredLanguages;
    private boolean progressLogs;
    private double simplification;
    private byte simplificationMaxZoom;
    private boolean skipInvalidRelations;
    private OSMTagMapping tagMapping;
    private boolean tagValues;
    private boolean wayClipping;
    private String writerVersion;
    private ZoomIntervalConfiguration zoomIntervalConfiguration;
    private int threads;

    public void addBboxConfiguration(String bbox) {
        if (bbox != null) {
            this.setBboxConfiguration(BoundingBox.fromString(bbox));
        }
    }

    public void addEncodingChoice(String encoding) {
        if (encoding != null) {
            this.setEncodingChoice(EncodingChoice.fromString(encoding));
        }
    }

    public void addMapStartPosition(String position) {
        if (position != null) {
            this.setMapStartPosition(LatLongUtils.fromString(position));
        }
    }

    public void addMapStartZoom(String zoom) {
        if (zoom != null) {
            try {
                int intZoom = Integer.parseInt(zoom);
                if (intZoom < 0 || intZoom > 21) {
                    throw new IllegalArgumentException("not a valid map start zoom: " + zoom);
                }
                this.setMapStartZoomLevel(intZoom);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not a valid map start zoom: " + zoom, e);
            }
        } else {
            this.setMapStartZoomLevel(-1);
        }
    }

    public void addOutputFile(String file) {
        if (file != null) {
            File f = new File(file);
            if (f.isDirectory()) {
                throw new IllegalArgumentException("output file parameter points to a directory, must be a file");
            }
            if (f.exists() && !f.canWrite()) {
                throw new IllegalArgumentException("output file parameter points to a file we have no write permissions");
            }
            this.setOutputFile(f);
        }
    }

    public void addPreferredLanguages(String preferredLanguages) {
        if (preferredLanguages != null && !preferredLanguages.trim().isEmpty()) {
            this.setPreferredLanguages(Arrays.asList(preferredLanguages.split(",")));
        }
    }

    public void addZoomIntervalConfiguration(String zoomIntervalConfiguaration) {
        if (zoomIntervalConfiguaration != null) {
            this.setZoomIntervalConfiguration(ZoomIntervalConfiguration.fromString(zoomIntervalConfiguaration));
        } else {
            this.setZoomIntervalConfiguration(ZoomIntervalConfiguration.getStandardConfiguration());
        }
    }

    public BoundingBox getBboxConfiguration() {
        return this.bboxConfiguration;
    }

    public int getBboxEnlargement() {
        return this.bboxEnlargement;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDataProcessorType() {
        return this.dataProcessorType;
    }

    public EncodingChoice getEncodingChoice() {
        return this.encodingChoice;
    }

    public int getFileSpecificationVersion() {
        return this.fileSpecificationVersion;
    }

    public LatLong getMapStartPosition() {
        return this.mapStartPosition;
    }

    public int getMapStartZoomLevel() {
        return this.mapStartZoomLevel;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public List<String> getPreferredLanguages() {
        return this.preferredLanguages;
    }

    public double getSimplification() {
        return this.simplification;
    }

    public byte getSimplificationMaxZoom() {
        return this.simplificationMaxZoom;
    }

    public OSMTagMapping getTagMapping() {
        return this.tagMapping;
    }

    public int getThreads() {
        return this.threads;
    }

    public String getWriterVersion() {
        return this.writerVersion;
    }

    public ZoomIntervalConfiguration getZoomIntervalConfiguration() {
        return this.zoomIntervalConfiguration;
    }

    public boolean hasMapStartZoomLevel() {
        return this.getMapStartZoomLevel() >= 0;
    }

    public boolean isDebugStrings() {
        return this.debugStrings;
    }

    public boolean isLabelPosition() {
        return this.labelPosition;
    }

    public boolean isPolygonClipping() {
        return this.polygonClipping;
    }

    public boolean isPolylabel() {
        return this.polylabel;
    }

    public boolean isProgressLogs() {
        return this.progressLogs;
    }

    public boolean isSkipInvalidRelations() {
        return this.skipInvalidRelations;
    }

    public boolean isTagValues() {
        return this.tagValues;
    }

    public boolean isWayClipping() {
        return this.wayClipping;
    }

    public void loadTagMappingFile(String file) {
        if (file != null) {
            File f = new File(file);
            if (!f.exists()) {
                throw new IllegalArgumentException("tag mapping file parameter points to a file that does not exist");
            }
            if (f.isDirectory()) {
                throw new IllegalArgumentException("tag mapping file parameter points to a directory, must be a file");
            }
            if (!f.canRead()) {
                throw new IllegalArgumentException("tag mapping file parameter points to a file we have no read permissions");
            }
            try {
                this.tagMapping = OSMTagMapping.getInstance(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.tagMapping = OSMTagMapping.getInstance();
        }
        this.tagMapping.setTagValues(this.tagValues);
    }

    public void setBboxConfiguration(BoundingBox bboxConfiguration) {
        this.bboxConfiguration = bboxConfiguration;
    }

    public void setBboxEnlargement(int bboxEnlargement) {
        this.bboxEnlargement = bboxEnlargement;
    }

    public void setComment(String comment) {
        if (comment != null && !comment.isEmpty()) {
            this.comment = comment;
        }
    }

    public void setDataProcessorType(String dataProcessorType) {
        this.dataProcessorType = dataProcessorType;
    }

    public void setDebugStrings(boolean debugStrings) {
        this.debugStrings = debugStrings;
    }

    public void setEncodingChoice(EncodingChoice encodingChoice) {
        this.encodingChoice = encodingChoice;
    }

    public void setFileSpecificationVersion(int fileSpecificationVersion) {
        this.fileSpecificationVersion = fileSpecificationVersion;
    }

    public void setLabelPosition(boolean labelPosition) {
        this.labelPosition = labelPosition;
    }

    public void setMapStartPosition(LatLong mapStartPosition) {
        this.mapStartPosition = mapStartPosition;
    }

    public void setMapStartZoomLevel(int mapStartZoomLevel) {
        this.mapStartZoomLevel = mapStartZoomLevel;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setPolygonClipping(boolean polygonClipping) {
        this.polygonClipping = polygonClipping;
    }

    public void setPolylabel(boolean polylabel) {
        this.polylabel = polylabel;
    }

    public void setPreferredLanguages(List<String> preferredLanguages) {
        this.preferredLanguages = preferredLanguages;
    }

    public void setProgressLogs(boolean progressLogs) {
        this.progressLogs = progressLogs;
    }

    public void setSimplification(double simplification) {
        if (simplification < 0.0) {
            throw new RuntimeException("simplification must be >= 0");
        }
        this.simplification = simplification;
    }

    public void setSimplificationMaxZoom(byte simplificationMaxZoom) {
        if (simplificationMaxZoom < 0) {
            throw new RuntimeException("simplificationMaxZoom must be >= 0");
        }
        this.simplificationMaxZoom = simplificationMaxZoom;
    }

    public void setSkipInvalidRelations(boolean skipInvalidRelations) {
        this.skipInvalidRelations = skipInvalidRelations;
    }

    public void setTagValues(boolean tagValues) {
        this.tagValues = tagValues;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setWayClipping(boolean wayClipping) {
        this.wayClipping = wayClipping;
    }

    public void setWriterVersion(String writerVersion) {
        this.writerVersion = writerVersion;
    }

    public void setZoomIntervalConfiguration(ZoomIntervalConfiguration zoomIntervalConfiguration) {
        this.zoomIntervalConfiguration = zoomIntervalConfiguration;
    }

    public void validate() {
        if (this.mapStartPosition != null && this.bboxConfiguration != null && !this.bboxConfiguration.contains(this.mapStartPosition)) {
            throw new IllegalArgumentException("map start position is not valid, must be included in bounding box of the map, bbox: " + this.bboxConfiguration.toString() + " - map start position: " + this.mapStartPosition.toString());
        }
    }
}

