/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.model;

import java.io.Serializable;
import org.mapsforge.core.model.Point;

public class Dimension
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int height;
    public final int width;

    public Dimension(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width must not be negative: " + width);
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must not be negative: " + height);
        }
        this.width = width;
        this.height = height;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Dimension)) {
            return false;
        }
        Dimension other = (Dimension)obj;
        if (this.width != other.width) {
            return false;
        }
        return this.height == other.height;
    }

    public Point getCenter() {
        return new Point((float)this.width / 2.0f, (float)this.height / 2.0f);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("width=");
        stringBuilder.append(this.width);
        stringBuilder.append(", height=");
        stringBuilder.append(this.height);
        return stringBuilder.toString();
    }
}

