/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.mapelements;

import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.Filter;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;

public abstract class MapElementContainer
implements Comparable<MapElementContainer> {
    protected Rectangle boundary;
    protected Rectangle boundaryAbsolute;
    protected Display display;
    protected final int priority;
    protected final Point xy;

    protected MapElementContainer(Point xy, Display display, int priority) {
        this.xy = xy;
        this.display = display;
        this.priority = priority;
    }

    @Override
    public int compareTo(MapElementContainer other) {
        if (this.priority < other.priority) {
            return -1;
        }
        if (this.priority > other.priority) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapElementContainer)) {
            return false;
        }
        MapElementContainer other = (MapElementContainer)obj;
        if (this.priority != other.priority) {
            return false;
        }
        return this.xy.equals(other.xy);
    }

    public abstract void draw(Canvas var1, Point var2, Matrix var3, Filter var4);

    protected Rectangle getBoundaryAbsolute() {
        if (this.boundaryAbsolute == null) {
            this.boundaryAbsolute = this.boundary.shift(this.xy);
        }
        return this.boundaryAbsolute;
    }

    public boolean intersects(Rectangle rectangle) {
        return this.getBoundaryAbsolute().intersects(rectangle);
    }

    public boolean clashesWith(MapElementContainer other) {
        if (Display.ALWAYS == this.display || Display.ALWAYS == other.display) {
            return false;
        }
        return this.getBoundaryAbsolute().intersects(other.getBoundaryAbsolute());
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.xy.hashCode();
        result = 31 * result + this.priority;
        return result;
    }

    public Point getPoint() {
        return this.xy;
    }

    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("xy=");
        stringBuilder.append(this.xy);
        stringBuilder.append(", priority=");
        stringBuilder.append(this.priority);
        return stringBuilder.toString();
    }
}

