/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.collect.Maps;
import com.google.common.collect.RangeMap;
import java.util.EnumMap;
import java.util.HashMap;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.VersionMap;

public class Opcodes {
    public final int api;
    public final int artVersion;
    private final Opcode[] opcodesByValue = new Opcode[256];
    private final EnumMap<Opcode, Short> opcodeValues;
    private final HashMap<String, Opcode> opcodesByName;

    public static Opcodes forApi(int api) {
        return new Opcodes(api, -1);
    }

    public static Opcodes forArtVersion(int artVersion) {
        return new Opcodes(-1, artVersion);
    }

    public static Opcodes forDexVersion(int dexVersion) {
        int api = VersionMap.mapDexVersionToApi(dexVersion);
        if (api == -1) {
            throw new RuntimeException("Unsupported dex version " + dexVersion);
        }
        return new Opcodes(api, -1);
    }

    public static Opcodes getDefault() {
        return Opcodes.forApi(20);
    }

    private Opcodes(int api, int artVersion) {
        if (api >= 21) {
            this.api = api;
            this.artVersion = VersionMap.mapApiToArtVersion(api);
        } else if (artVersion >= 0 && artVersion < 39) {
            this.api = VersionMap.mapArtVersionToApi(artVersion);
            this.artVersion = artVersion;
        } else {
            this.api = api;
            this.artVersion = artVersion;
        }
        this.opcodeValues = new EnumMap(Opcode.class);
        this.opcodesByName = Maps.newHashMap();
        int version = this.isArt() ? this.artVersion : this.api;
        for (Opcode opcode : Opcode.values()) {
            RangeMap<Integer, Short> versionToValueMap = this.isArt() ? opcode.artVersionToValueMap : opcode.apiToValueMap;
            Short opcodeValue = versionToValueMap.get(version);
            if (opcodeValue == null) continue;
            if (!opcode.format.isPayloadFormat) {
                this.opcodesByValue[opcodeValue.shortValue()] = opcode;
            }
            this.opcodeValues.put(opcode, opcodeValue);
            this.opcodesByName.put(opcode.name.toLowerCase(), opcode);
        }
    }

    public Opcode getOpcodeByValue(int opcodeValue) {
        switch (opcodeValue) {
            case 256: {
                return Opcode.PACKED_SWITCH_PAYLOAD;
            }
            case 512: {
                return Opcode.SPARSE_SWITCH_PAYLOAD;
            }
            case 768: {
                return Opcode.ARRAY_PAYLOAD;
            }
        }
        if (opcodeValue >= 0 && opcodeValue < this.opcodesByValue.length) {
            return this.opcodesByValue[opcodeValue];
        }
        return null;
    }

    public Short getOpcodeValue(Opcode opcode) {
        return this.opcodeValues.get((Object)opcode);
    }

    public boolean isArt() {
        return this.artVersion != -1;
    }
}

