# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.document_list_response import DocumentListResponse
from ..types.document_local_ingest_request import DocumentLocalIngestRequest
from ..types.document_lookup_response import DocumentLookupResponse
from ..types.document_response import DocumentResponse
from ..types.ingest_remote_document import IngestRemoteDocument
from ..types.ingest_response import IngestResponse
from ..types.processes_status_response import ProcessesStatusResponse
from ..types.processing_status import ProcessingStatus
from ..types.sort import Sort
from ..types.sort_order import SortOrder
from ..types.website_source import WebsiteSource
from .raw_client import AsyncRawDocumentsClient, RawDocumentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DocumentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDocumentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDocumentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDocumentsClient
        """
        return self._raw_client

    def ingest_remote(
        self,
        *,
        documents: typing.Sequence[IngestRemoteDocument],
        callback_url: typing.Optional[str] = OMIT,
        callback_data: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IngestResponse:
        """
        Ingest documents hosted on public URLs into a GroundX bucket.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        documents : typing.Sequence[IngestRemoteDocument]

        callback_url : typing.Optional[str]
            An endpoint that will receive processing event updates as POST.

        callback_data : typing.Optional[str]
            A string that is returned, along with processing event updates, to the callback URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Documents successfully uploaded

        Examples
        --------
        from groundx import GroundX, IngestRemoteDocument

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.documents.ingest_remote(
            documents=[
                IngestRemoteDocument(
                    bucket_id=1234,
                    file_name="my_file1.txt",
                    file_type="txt",
                    source_url="https://my.source.url.com/file1.txt",
                )
            ],
        )
        """
        _response = self._raw_client.ingest_remote(
            documents=documents, callback_url=callback_url, callback_data=callback_data, request_options=request_options
        )
        return _response.data

    def ingest_local(
        self, *, request: DocumentLocalIngestRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> IngestResponse:
        """
        Upload documents hosted on a local file system into a GroundX bucket.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        request : DocumentLocalIngestRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Documents successfully uploaded

        Examples
        --------
        from groundx import GroundX, IngestLocalDocument, IngestLocalDocumentMetadata

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.documents.ingest_local(
            request=[
                IngestLocalDocument(
                    blob="blob",
                    metadata=IngestLocalDocumentMetadata(
                        bucket_id=1234,
                        file_name="my_file1.txt",
                        file_type="txt",
                    ),
                )
            ],
        )
        """
        _response = self._raw_client.ingest_local(request=request, request_options=request_options)
        return _response.data

    def crawl_website(
        self,
        *,
        websites: typing.Sequence[WebsiteSource],
        callback_url: typing.Optional[str] = OMIT,
        callback_data: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IngestResponse:
        """
        Upload the content of a publicly accessible website for ingestion into a GroundX bucket. This is done by following links within a specified URL, recursively, up to a specified depth or number of pages.

        Note1: This endpoint is currently not supported for on-prem deployments.
        Note2: The `source_url` must include the protocol, http:// or https://.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        websites : typing.Sequence[WebsiteSource]

        callback_url : typing.Optional[str]
            The URL that will receive processing event updates.

        callback_data : typing.Optional[str]
            A string that is returned, along with processing event updates, to the callback URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Website successfully queued

        Examples
        --------
        from groundx import GroundX, WebsiteSource

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.documents.crawl_website(
            websites=[
                WebsiteSource(
                    bucket_id=1234,
                    cap=10,
                    depth=2,
                    search_data={"key": "value"},
                    source_url="https://my.website.com",
                )
            ],
        )
        """
        _response = self._raw_client.crawl_website(
            websites=websites, callback_url=callback_url, callback_data=callback_data, request_options=request_options
        )
        return _response.data

    def list(
        self,
        *,
        n: typing.Optional[int] = None,
        filter: typing.Optional[str] = None,
        sort: typing.Optional[Sort] = None,
        sort_order: typing.Optional[SortOrder] = None,
        status: typing.Optional[ProcessingStatus] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentListResponse:
        """
        lookup all documents across all resources which are currently on GroundX

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned documents. Accepts 1-100 with a default of 20.

        filter : typing.Optional[str]
            Only documents with names that contain the filter string will be returned in the results.

        sort : typing.Optional[Sort]
            The document attribute that will be used to sort the results.

        sort_order : typing.Optional[SortOrder]
            The order in which to sort the results. A value for sort must also be set.

        status : typing.Optional[ProcessingStatus]
            A status filter on the get documents query. If this value is set, then only documents with this status will be returned in the results.

        next_token : typing.Optional[str]
            A token for pagination. If the number of documents for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentListResponse
            Look up success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.documents.list(
            n=1,
            filter="filter",
            sort="name",
            sort_order="asc",
            status="queued",
            next_token="nextToken",
        )
        """
        _response = self._raw_client.list(
            n=n,
            filter=filter,
            sort=sort,
            sort_order=sort_order,
            status=status,
            next_token=next_token,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self,
        *,
        document_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IngestResponse:
        """
        Delete multiple documents hosted on GroundX

        Parameters
        ----------
        document_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of documentIds which correspond to documents ingested by GroundX

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Documents are queued to be deleted

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.documents.delete(
            document_ids="123e4567-e89b-12d3-a456-426614174000,9f7c11a6-24b8-4d52-a9f3-90a7e70a9e49",
        )
        """
        _response = self._raw_client.delete(document_ids=document_ids, request_options=request_options)
        return _response.data

    def get_processing_status_by_id(
        self, process_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> IngestResponse:
        """
        Get the current status of an ingest, initiated with documents.ingest_remote, documents.ingest_local, or documents.crawl_website, by specifying the processId (the processId is included in the response of the documents.ingest functions).

        Parameters
        ----------
        process_id : str
            the processId for the ingest process being checked

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Look up success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.documents.get_processing_status_by_id(
            process_id="processId",
        )
        """
        _response = self._raw_client.get_processing_status_by_id(process_id, request_options=request_options)
        return _response.data

    def lookup(
        self,
        id: int,
        *,
        n: typing.Optional[int] = None,
        filter: typing.Optional[str] = None,
        sort: typing.Optional[Sort] = None,
        sort_order: typing.Optional[SortOrder] = None,
        status: typing.Optional[ProcessingStatus] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentLookupResponse:
        """
        lookup the document(s) associated with a processId, bucketId, or groupId.

        Parameters
        ----------
        id : int
            a processId, bucketId, or groupId

        n : typing.Optional[int]
            The maximum number of returned documents. Accepts 1-100 with a default of 20.

        filter : typing.Optional[str]
            Only documents with names that contain the filter string will be returned in the results.

        sort : typing.Optional[Sort]
            The document attribute that will be used to sort the results.

        sort_order : typing.Optional[SortOrder]
            The order in which to sort the results. A value for sort must also be set.

        status : typing.Optional[ProcessingStatus]
            A status filter on the get documents query. If this value is set, then only documents with this status will be returned in the results.

        next_token : typing.Optional[str]
            A token for pagination. If the number of documents for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentLookupResponse
            Look up success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.documents.lookup(
            id=1,
            n=1,
            filter="filter",
            sort="name",
            sort_order="asc",
            status="queued",
            next_token="nextToken",
        )
        """
        _response = self._raw_client.lookup(
            id,
            n=n,
            filter=filter,
            sort=sort,
            sort_order=sort_order,
            status=status,
            next_token=next_token,
            request_options=request_options,
        )
        return _response.data

    def get(self, document_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DocumentResponse:
        """
        Look up an existing document by documentId.

        Parameters
        ----------
        document_id : str
            The documentId of the document for which GroundX information will be provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentResponse
            Look up success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.documents.get(
            document_id="documentId",
        )
        """
        _response = self._raw_client.get(document_id, request_options=request_options)
        return _response.data

    def delete_by_id(
        self, document_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> IngestResponse:
        """
        Delete a single document hosted on GroundX

        Parameters
        ----------
        document_id : str
            A documentId which correspond to a document ingested by GroundX

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Document successfully deleted

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.documents.delete_by_id(
            document_id="documentId",
        )
        """
        _response = self._raw_client.delete_by_id(document_id, request_options=request_options)
        return _response.data

    def get_processes(
        self,
        *,
        n: typing.Optional[int] = None,
        status: typing.Optional[ProcessingStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProcessesStatusResponse:
        """
        Get a list of ingest process requests, sorted from most recent to least.

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned processes. Accepts 1-100 with a default of 20.

        status : typing.Optional[ProcessingStatus]
            A status filter on the processing status. If this value is set, then only processes with this status will be returned in the results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessesStatusResponse
            Look up success

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.documents.get_processes(
            n=1,
            status="queued",
        )
        """
        _response = self._raw_client.get_processes(n=n, status=status, request_options=request_options)
        return _response.data


class AsyncDocumentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDocumentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDocumentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDocumentsClient
        """
        return self._raw_client

    async def ingest_remote(
        self,
        *,
        documents: typing.Sequence[IngestRemoteDocument],
        callback_url: typing.Optional[str] = OMIT,
        callback_data: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IngestResponse:
        """
        Ingest documents hosted on public URLs into a GroundX bucket.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        documents : typing.Sequence[IngestRemoteDocument]

        callback_url : typing.Optional[str]
            An endpoint that will receive processing event updates as POST.

        callback_data : typing.Optional[str]
            A string that is returned, along with processing event updates, to the callback URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Documents successfully uploaded

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX, IngestRemoteDocument

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.ingest_remote(
                documents=[
                    IngestRemoteDocument(
                        bucket_id=1234,
                        file_name="my_file1.txt",
                        file_type="txt",
                        source_url="https://my.source.url.com/file1.txt",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.ingest_remote(
            documents=documents, callback_url=callback_url, callback_data=callback_data, request_options=request_options
        )
        return _response.data

    async def ingest_local(
        self, *, request: DocumentLocalIngestRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> IngestResponse:
        """
        Upload documents hosted on a local file system into a GroundX bucket.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        request : DocumentLocalIngestRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Documents successfully uploaded

        Examples
        --------
        import asyncio

        from groundx import (
            AsyncGroundX,
            IngestLocalDocument,
            IngestLocalDocumentMetadata,
        )

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.ingest_local(
                request=[
                    IngestLocalDocument(
                        blob="blob",
                        metadata=IngestLocalDocumentMetadata(
                            bucket_id=1234,
                            file_name="my_file1.txt",
                            file_type="txt",
                        ),
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.ingest_local(request=request, request_options=request_options)
        return _response.data

    async def crawl_website(
        self,
        *,
        websites: typing.Sequence[WebsiteSource],
        callback_url: typing.Optional[str] = OMIT,
        callback_data: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IngestResponse:
        """
        Upload the content of a publicly accessible website for ingestion into a GroundX bucket. This is done by following links within a specified URL, recursively, up to a specified depth or number of pages.

        Note1: This endpoint is currently not supported for on-prem deployments.
        Note2: The `source_url` must include the protocol, http:// or https://.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        websites : typing.Sequence[WebsiteSource]

        callback_url : typing.Optional[str]
            The URL that will receive processing event updates.

        callback_data : typing.Optional[str]
            A string that is returned, along with processing event updates, to the callback URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Website successfully queued

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX, WebsiteSource

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.crawl_website(
                websites=[
                    WebsiteSource(
                        bucket_id=1234,
                        cap=10,
                        depth=2,
                        search_data={"key": "value"},
                        source_url="https://my.website.com",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.crawl_website(
            websites=websites, callback_url=callback_url, callback_data=callback_data, request_options=request_options
        )
        return _response.data

    async def list(
        self,
        *,
        n: typing.Optional[int] = None,
        filter: typing.Optional[str] = None,
        sort: typing.Optional[Sort] = None,
        sort_order: typing.Optional[SortOrder] = None,
        status: typing.Optional[ProcessingStatus] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentListResponse:
        """
        lookup all documents across all resources which are currently on GroundX

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned documents. Accepts 1-100 with a default of 20.

        filter : typing.Optional[str]
            Only documents with names that contain the filter string will be returned in the results.

        sort : typing.Optional[Sort]
            The document attribute that will be used to sort the results.

        sort_order : typing.Optional[SortOrder]
            The order in which to sort the results. A value for sort must also be set.

        status : typing.Optional[ProcessingStatus]
            A status filter on the get documents query. If this value is set, then only documents with this status will be returned in the results.

        next_token : typing.Optional[str]
            A token for pagination. If the number of documents for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentListResponse
            Look up success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.list(
                n=1,
                filter="filter",
                sort="name",
                sort_order="asc",
                status="queued",
                next_token="nextToken",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            n=n,
            filter=filter,
            sort=sort,
            sort_order=sort_order,
            status=status,
            next_token=next_token,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self,
        *,
        document_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IngestResponse:
        """
        Delete multiple documents hosted on GroundX

        Parameters
        ----------
        document_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of documentIds which correspond to documents ingested by GroundX

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Documents are queued to be deleted

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.delete(
                document_ids="123e4567-e89b-12d3-a456-426614174000,9f7c11a6-24b8-4d52-a9f3-90a7e70a9e49",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(document_ids=document_ids, request_options=request_options)
        return _response.data

    async def get_processing_status_by_id(
        self, process_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> IngestResponse:
        """
        Get the current status of an ingest, initiated with documents.ingest_remote, documents.ingest_local, or documents.crawl_website, by specifying the processId (the processId is included in the response of the documents.ingest functions).

        Parameters
        ----------
        process_id : str
            the processId for the ingest process being checked

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Look up success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.get_processing_status_by_id(
                process_id="processId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_processing_status_by_id(process_id, request_options=request_options)
        return _response.data

    async def lookup(
        self,
        id: int,
        *,
        n: typing.Optional[int] = None,
        filter: typing.Optional[str] = None,
        sort: typing.Optional[Sort] = None,
        sort_order: typing.Optional[SortOrder] = None,
        status: typing.Optional[ProcessingStatus] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentLookupResponse:
        """
        lookup the document(s) associated with a processId, bucketId, or groupId.

        Parameters
        ----------
        id : int
            a processId, bucketId, or groupId

        n : typing.Optional[int]
            The maximum number of returned documents. Accepts 1-100 with a default of 20.

        filter : typing.Optional[str]
            Only documents with names that contain the filter string will be returned in the results.

        sort : typing.Optional[Sort]
            The document attribute that will be used to sort the results.

        sort_order : typing.Optional[SortOrder]
            The order in which to sort the results. A value for sort must also be set.

        status : typing.Optional[ProcessingStatus]
            A status filter on the get documents query. If this value is set, then only documents with this status will be returned in the results.

        next_token : typing.Optional[str]
            A token for pagination. If the number of documents for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentLookupResponse
            Look up success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.lookup(
                id=1,
                n=1,
                filter="filter",
                sort="name",
                sort_order="asc",
                status="queued",
                next_token="nextToken",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.lookup(
            id,
            n=n,
            filter=filter,
            sort=sort,
            sort_order=sort_order,
            status=status,
            next_token=next_token,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, document_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DocumentResponse:
        """
        Look up an existing document by documentId.

        Parameters
        ----------
        document_id : str
            The documentId of the document for which GroundX information will be provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentResponse
            Look up success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.get(
                document_id="documentId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(document_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, document_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> IngestResponse:
        """
        Delete a single document hosted on GroundX

        Parameters
        ----------
        document_id : str
            A documentId which correspond to a document ingested by GroundX

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IngestResponse
            Document successfully deleted

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.delete_by_id(
                document_id="documentId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(document_id, request_options=request_options)
        return _response.data

    async def get_processes(
        self,
        *,
        n: typing.Optional[int] = None,
        status: typing.Optional[ProcessingStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProcessesStatusResponse:
        """
        Get a list of ingest process requests, sorted from most recent to least.

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned processes. Accepts 1-100 with a default of 20.

        status : typing.Optional[ProcessingStatus]
            A status filter on the processing status. If this value is set, then only processes with this status will be returned in the results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessesStatusResponse
            Look up success

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.documents.get_processes(
                n=1,
                status="queued",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_processes(n=n, status=status, request_options=request_options)
        return _response.data
