# Generated by Django 3.2.8 on 2022-01-11 03:59

from django.db import migrations, models


def change_choice(apps, schema_editor):
    TransmitterEntry = apps.get_model('base', 'TransmitterEntry')
    TransmitterEntry.objects.filter(coordination='IARU Rejected').update(coordination='IARU Declined')


def reverse_choice_change(apps, schema_editor):
    TransmitterEntry = apps.get_model('base', 'TransmitterEntry')
    TransmitterEntry.objects.filter(coordination='IARU Declined').update(coordination='IARU Rejected')


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0048_add_merge_permission'),
    ]

    operations = [
        migrations.AlterField(
            model_name='transmitterentry',
            name='coordination',
            field=models.CharField(blank=True, choices=[('ITU Requested', 'ITU Requested'), ('ITU Rejected', 'ITU Rejected'), ('ITU Coordinated', 'ITU Coordinated'), ('IARU Requested', 'IARU Requested'), ('IARU Declined', 'IARU Declined'), ('IARU Coordinated', 'IARU Coordinated'), ('Uncoordinated', 'Uncoordinated')], default='', help_text='Frequency coordination status for this transmitter', max_length=20),
        ),
        migrations.RunPython(change_choice, reverse_choice_change),
    ]
