import random

import click

from slickml import __version__

_BANNERS = [
    r"""
    ███████╗██╗     ██╗ ██████╗██╗  ██╗███╗   ███╗██╗
    ██╔════╝██║     ██║██╔════╝██║ ██╔╝████╗ ████║██║
    ███████╗██║     ██║██║     █████╔╝ ██╔████╔██║██║
    ╚════██║██║     ██║██║     ██╔═██╗ ██║╚██╔╝██║██║
    ███████║███████╗██║╚██████╗██║  ██╗██║ ╚═╝ ██║███████╗
    ╚══════╝╚══════╝╚═╝ ╚═════╝╚═╝  ╚═╝╚═╝     ╚═╝╚══════╝
    """,
    r"""
    _____ _ _      _    __  __ _
    / ____| (_)    | |  |  \/  | |
    | (___ | |_  ___| | _| \  / | |
    \___ \| | |/ __| |/ / |\/| | |
    ____) | | | (__|   <| |  | | |____
    |_____/|_|_|\___|_|\_\_|  |_|______|
    """,
    r"""
    _____ ___      __   __  _____
    / ___// (_)____/ /__/  |/  / /
    \__ \/ / / ___/ //_/ /|_/ / /
    ___/ / / / /__/ ,< / /  / / /___
    /____/_/_/\___/_/|_/_/  /_/_____/
    """,
    r"""
    ██████  ██▓     ██▓ ▄████▄   ██ ▄█▀ ███▄ ▄███▓ ██▓
    ▒██    ▒ ▓██▒    ▓██▒▒██▀ ▀█   ██▄█▒ ▓██▒▀█▀ ██▒▓██▒
    ░ ▓██▄   ▒██░    ▒██▒▒▓█    ▄ ▓███▄░ ▓██    ▓██░▒██░
    ▒   ██▒▒██░    ░██░▒▓▓▄ ▄██▒▓██ █▄ ▒██    ▒██ ▒██░
    ▒██████▒▒░██████▒░██░▒ ▓███▀ ░▒██▒ █▄▒██▒   ░██▒░██████▒
    ▒ ▒▓▒ ▒ ░░ ▒░▓  ░░▓  ░ ░▒ ▒  ░▒ ▒▒ ▓▒░ ▒░   ░  ░░ ▒░▓  ░
    ░ ░▒  ░ ░░ ░ ▒  ░ ▒ ░  ░  ▒   ░ ░▒ ▒░░  ░      ░░ ░ ▒  ░
    ░  ░  ░    ░ ░    ▒ ░░        ░ ░░ ░ ░      ░     ░ ░
        ░      ░  ░ ░  ░ ░      ░  ░          ░       ░  ░
                        ░
    """,
    r"""
    ▄████████  ▄█        ▄█   ▄████████    ▄█   ▄█▄    ▄▄▄▄███▄▄▄▄    ▄█
    ███    ███ ███       ███  ███    ███   ███ ▄███▀  ▄██▀▀▀███▀▀▀██▄ ███
    ███    █▀  ███       ███▌ ███    █▀    ███▐██▀    ███   ███   ███ ███
    ███        ███       ███▌ ███         ▄█████▀     ███   ███   ███ ███
    ▀███████████ ███       ███▌ ███        ▀▀█████▄     ███   ███   ███ ███
            ███ ███       ███  ███    █▄    ███▐██▄    ███   ███   ███ ███
    ▄█    ███ ███▌    ▄ ███  ███    ███   ███ ▀███▄  ███   ███   ███ ███▌    ▄
    ▄████████▀  █████▄▄██ █▀   ████████▀    ███   ▀█▀   ▀█   ███   █▀  █████▄▄██
                ▀                           ▀                          ▀
    """,
]


@click.group(
    chain=True,
    invoke_without_command=True,
    context_settings={
        "help_option_names": ("-h", "--help"),
    },
)
@click.version_option(
    __version__,
    "--version",
    "-v",
)
def cli() -> None:
    """♡♡♡ Welcome to SlickML CLI ♡♡♡"""
    click.echo(
        click.style(
            text=random.choice(_BANNERS),
            fg="blue",
            bold=True,
        ),
    )


@cli.command()
def version() -> None:
    """Show the version and exit."""
    click.echo(
        click.style(
            text=f"SlickML Version: {__version__}",
            fg="red",
            bold=True,
        ),
    )


if __name__ == "__main__":
    cli()  # pragma: no cover
