# Transform MQL

### Auth setup:
```bash
# Follow the prompts to either eneter api_key or perform MFA
mql setup
```

**NOTE:** All configs including pinned models, api_key, bearer tokens will be stored under the default directory at `~/.transform/config.yml`. If another location is desired, please set an ENV variable at `$TFD_CONFIG_DIR` with the desired path.

### CLI Usage:
```
Usage: mql [OPTIONS] COMMAND [ARGS]...

Options:
  -v, --verbose
  --debug-log-file
  --help            Show this message and exit.
Commands:
  commit-configs         Commit yaml configs found in specified config directory.
  contact                Instructions for how to contact Transform for help.
  drop-cache             Drop the MQL cache.
  drop-materialization   Create a new MQL drop materialization query, polls for completion.
  health-report          Completes a health check on MQL servers.
  identify               Identify the currently authenticated user.
  list-materializations  List the materializations for the Organization with their available metrics and dimensions.
  list-metrics           List the metrics for the Organization with their available dimensions.
  list-queries           Retrieve queries from mql server.
  list-servers           Lists available MQL servers.
  materialize            Create a new MQL materialization query, polls for completion and returns materialized table id.
  pin-model              Pin a model id from configs that are already committed to the MQL Server.
  ping                   Perform basic HTTP health check against configured MQL server.
  query                  Create a new MQL query, polls for completion and assembles a DataFrame from the response.
  setup                  Guides user through CLI setup.
  stream-query-logs      Retrieve queries from mql server.
  unpin-model            Unpin a model id.
  validate-configs       Validate yaml configs found in specified config directory.
  version                Print the current version of the MQL CLI.
```
#### Examples:
```
mql query --metrics messages --dimensions ds --limit 10
mql drop-materialization --materialization-name name --start-time 2021-10-01 --end_time 2021-11-01
```

### Python Library
#### Examples:
```python
# Instantiating the object manually
from transform.mql import MQLClient

mql = MQLClient(api_key: Optional[str], mql_server_url: Optional[str])
df = mql.query(metrics=["messages"], dimensions=["ds"], where="is_thread")
```
```python
# If authentication exists, can be done from any authentication methods above
from transform import mql

df = mql.query(metrics=["messages"], dimensions=["ds"], where="is_thread")
```
#### Functions:
```
MQLClient.query(metrics, dimensions, model_key_id=None, where=None, time_constraint=None, time_granularity=None, 
    order=None, limit=None, cache_mode=None, as_table=None)

MQLClient.create_query(metrics, dimensions, model_key_id=None, where=None, time_constraint=None, time_granularity=None,
    order=None, limit=None, cache_mode=None, as_table=None)

MQLClient.list_queries(active_only, limit=None)

MQLClient.list_metrics(model_key_id=None)

MQLClient.list_servers()

MQLClient.create_materialization(materialization_name, start_time, end_time, model_key_id=None, output_table=None)

MQLClient.materialization(materialization_name, start_time, end_time, model_key_id=None, output_table=None)

MQLClient.drop_materialization(materialization_name, start_time, end_time, model_key_id=None, output_table=None)

MQLClient.commit_configs(config_dir)

MQLClient.validate_configs(config_dir)

MQLClient.health_report()

MQLClient.drop_cache()

MQLClient.identify()

MQLClient.ping()
```