# azapy project
## Financial Portfolio Optimization Algorithms
### An open-source python library for everybody

![TimeSeries](graphics/Portfolio_1.png)

Author: Mircea Marinescu

email: Mircea.Marinescu@outlook.com

[Package documentation](https://azapy.readthedocs.io/en/latest)

Package installation: `pip install azapy`

[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/D1D07G22H)

### Contents
A. Risk-based portfolio optimization algorithms:
  1. mCVaR - mixture CVaR (Conditional Value at Risk)
  2. mSMCR - mixture SMCR (Second Moment Coherent Risk)
  3. mMAD - m-level MAD (Mean Absolute Deviation)
  4. mLSD - m-level LSD (Lower Semi-Deviation)
  5. mBTAD - mixture BTAD (Below Threshold Absolute Deviation)
  6. mBTSD - mixture BTSD (Below Threshold Semi-Deviation)
  7. GINI - Gini index (as in Corrado Gini statistician 1884-1965)
  8. SD - standard deviation
  9. MV - variance (as in mean-variance model)

For each class of portfolio the following optimization strategies are
available:
  1. Minimization of dispersion for targeted expected rate of return value
  2. Maximization of generalized Sharpe ratio
  3. Minimization of inverse of generalized Sharpe ratio
  4. Minimum risk portfolio
  5. Maximization of expected rate of return for a risk vale generated by a
  benchmark portfolio (*e.g.* same risk as equal weighted portfolio)
  6. Maximization of expected rate of returns for fixed
     risk-aversion factor
  7. Maximization of diversification factor for targeted expected rate of return
  value <span style="color:red">(alpha version)</span>
  8. Maximum diversified portfolio <span style="color:red">(alpha version)</span>

B. "Naïve" portfolio strategies:
  1. Constant weighted portfolio. A particular case is equal
     weighted portfolio.
  2. Inverse volatility portfolio (*i.e.* portfolio weights are proportional to
     the inverse of asset volatilities)
  3. Inverse variance portfolio (*i.e.* portfolio weights are proportional to
     the inverse of asset variances)
  4. Inverse drawdown portfolio (*i.e.* portfolio weights are proportional to
     the asset absolute value of maximum drawdowns over a predefined
     historical period)

C. Greedy portfolio optimization strategies:
  1. Kelly's portfolio (as in John Larry Kelly Jr. scientist 1923-1965) -
     maximization of portfolio log returns

Utility functions:
  * Collect historical market data from various providers.
    Supported providers:

    - yahoo.com
    - eodhistoricaldata.com
    - alphavantage.co
    - marketstack.com

  * Generate business calendars. At this point only NYSE business calendar
    is implemented.
  * Generate rebalancing portfolio schedules.
  * Append a cash-like security to an existing market data object.
  * Update market data saved in a directory.
