# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['console_debugger',
 'console_debugger.logic',
 'console_debugger.logic.test',
 'console_debugger.tk_gui']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'console-debugger',
    'version': '0.1.5.3',
    'description': 'Это подключаемая библиотека, для удобного вывода отладочной информации.',
    'long_description': '# Что это?\n\nЭто подключаемая библиотека, для удобного вывода  \nотладочной информации.\n\n---\n\n# Как использовать ?\n\n## 1 Сначала нужно создать экземпляры класса Debugger\n\nМожно вручную указать параметры экземпляра\n\n- `Debug_Name = Debugger(active: bool,,title_name: str, consoleOutput: bool = True, fileConfig: Optional[Dict] = None style_text: Optional[dstyle] = None)`\n\n     - `active` = on/off жизни экземпляра, Если `False` экземпляр \n    будет игнорировать вызов, а также будет добавлен в массив `Debugger.AllCountSleepInstance`.  \n       \n    - `title_name` = Уникальное имя экземпляра которое будет отображаться в выводе.  \n    \n    - `consoleOutput` = on/off отображения в консоль или другие\n    визуальные выходы, **не влияет на запись в файл!**.  \n    \n    - `fileConfig` = Конфигурация записи в файл, входные параметры такие же как и у стандартной функции `open()`  \n        передавать в формате `Dict{"file":"test.log", ... }`. Для удобного формирования параметров можно  \n         пользоваться функцией `dopen()`.  \n    \n    - `style_text` = Стиль отображения текста. Для удобного формирования параметров можно  \n        пользоваться функцией `dstyle`.  \n\n\nИли использовать готовые параметры\n\n- `Debug_Name = Debugger(**dDEBUG)`\n    - dDEBUG\n    - dINFO\n    - dWARNING\n    - dEXCEPTION\n\n## 2 Установить глобальный стиль для всех экземпляров\n\nЭта команда влияет на все экземпляры `Debugger`\n\n- `Debugger.GlobalManager(global_active=None, typePrint: Optional[str] = "grid"):`\n    - `global_active` = Вы можете on/off все экземпляры разом\n    - `typePrint=` = Глобальный стиль отображения данных\n        - `"grid"` = Стиль таблица \n        \n        ![](https://i.imgur.com/Kif40aB.png)\n        \n        - `"tk"` = Будет создан поток и открыто **Tkinter** окно,\n        все записи экземпляров будут направлены в него. [Советы про tkinter](#про-режим-отображения--typeprinttk)\n        \n        ![](https://i.imgur.com/KiRI1MH.png)\n        \n        - `None` = Без стиля \n        \n        ![](https://i.imgur.com/byg84id.png)\n\n## 3 Использовать в коде\n\nВызывать экземпляр напрямую\n\n- `Debug_Name(text,*args, sep=\' \', end=\'\\n\')`\n    - `Debug_Name` = Имя экземпляра `Debugger`\n    - `text` = Строка\n    - `*args, sep=\' \', end=\'\\n\'` = такие же, как и у встроенной функции `print()`\n\nЛибо использовать функцию для однородности\n\n- `printD(Debug_Name, text, *args, sep=\' \', end=\'\\n\')`\n    - `Debug_Name` = Имя экземпляра `Debugger`\n    - `text` = Строка\n    - `*args, sep=\' \', end=\'\\n\'` = такие же, как и у встроенной функции `print()`\n\n---\n\n# Примеры\n\n## Использовать свои стили, вызывать экземпляры напрямую\n\n\nДля наглядности создадим функцию для генерации случайного слово\n```python\nimport random\nimport string             \n# Сгенерировать случайное слово\nrandom_word = lambda: "".join(random.choice(string.ascii_letters) for j in range(random.randint(1, 40)))\n```\n\n```python\nfrom console_debugger import *\n\nDebug = Debugger(True,title_name="[DEBUG]",\n\n                 fileConfig=dopen(file="debug.log",\n                                  mode="a",\n                                  encoding="utf-8"),\n\n                 style_text=dstyle(bg_color="bg_blue",\n                                   len_word=21)\n                 )\nInfo = Debugger(True,title_name="[INFO]",\n\n                fileConfig={"file": "info.log",\n                            "mode": "a", "encoding": "utf-8"},\n                style_text=dstyle(len_word=25),\n\n                consoleOutput=False\n                )\nWarning = Debugger(True,"[WARNING]", style_text=dstyle(len_word=25))\n\nDebugger.GlobalManager(typePrint="grid")\n\nif __name__ == \'__main__\':\n    for i in range(10):\n        Warning(random_word())\n        Debug(random_word())\n        Info(random_word())\n```\n\n## Использовать готовые стили, вызывать `printD`\n\n```python\nfrom console_debugger import *\n\nDebug = Debugger(**dDEBUG)\nInfo = Debugger(**dINFO)\nWarning = Debugger(**dWARNING)\n\nDebugger.GlobalManager(typePrint="grid")\n\nif __name__ == \'__main__\':\n    for i in range(10):\n        printD(Debug, random_word())\n        printD(Warning, random_word())\n        printD(Info, random_word())\n```\n\n## Использовать GUI Tkinter\n```python\nfrom console_debugger import *\n\n\nDebug = Debugger(**dDEBUG)\nInfo = Debugger(**dINFO)\nWarning = Debugger(**dWARNING)\nTEST = Debugger(True,"TEST")\n\nDebugger.GlobalManager(typePrint="tk")\n\n\nfor i in range(10):\n    printD(Debug, random_word())\n    printD(Info, random_word())\n    printD(Warning, random_word())\n    printD(TEST, random_word())\n```\n\n## Использование Глобального режима on/off \nСоздать два режима запуска Debug/Release\n![](https://i.imgur.com/guFWf3O.png)\n\n`main.pyw`\n```python\nimport sys\nfrom console_debugger import Debugger\nfrom app.viwe import Windows # При импорте должны быть созданы все экземпляры\n\nif __name__ == \'__main__\':\n    for param in set(sys.argv):\n        if param == "--d":\n            Debugger.GlobalManager(typePrint="grid") # Задать глобальный стиль всем экземпляром\n            break\n    else:\n        Debugger.GlobalManager(global_active=False) # Если нет параметров отключаем все экземпляры \n    Windows()\n```\nВ других модулях создаем необходимые экземпляры\n```python\nfrom console_debugger import *\nHotKeyD = Debugger(True, "[HotKey]")\nPressKeyD = Debugger(True, "[PressKey]")\nInfoD = Debugger(**dINFO)\nResD = Debugger(True, "[Result]", style_text=dstyle(len_word=25, height=4))\n\nprintD(HotKeyD,"Crtl+c")\n```\n\n## Использование во `Flask`\n\nПоместить `Debugger.GlobalManager` в `@app.before_first_request`\n```python\nfrom console_debugger import *\nfrom flask import * \n\nSECRET_KEY = "123_very_hard_password"\napp = Flask(__name__)\n\n # Экземпляры в глобальной области видимости\ncookDeb = Debugger(True, "[Cook]")\nsessionDeb = Debugger(True, "[Session]")\n\n@app.before_first_request\ndef deb():\n    # Tkinter будет перезапускаться при каждом обновление сервера\n    Debugger.GlobalManager(typePrint="tk")\n\n@app.route("/login", methods=[\'POST\', \'GET\'])\ndef login():\n    global data, cookDeb, sessionDeb\n    cook = "no"\n    ses = "no"\n\n    # Получить куки если есть\n    if request.cookies.get("logged"):\n        cook = request.cookies.get("logged")\n\n    # Получить данные из сессии если есть\n    if "SessioN" in session:\n        ses = session.get("SessioN")\n\n    printD(cookDeb, cook)\n    printD(sessionDeb, ses)\n\n    res = make_response(render_template("login.html", cook=cook, session=ses))\n    res.set_cookie(key="logged", value="yes", max_age=3)\n    session["SessioN"] = "yes"\n    return res\n\nif __name__ == \'__main__\':\n    app.run(debug=True)\n```\n`"login.html"`\n```html\n<script>\n    document.cookie = "ex=1;";\n    if (!document.cookie) {\n        alert("Этот сайт требует включение cookie");\n    }\n</script>\nCook: {{ cook }}\n<p></p>\nSession: {{ session }}\n<form action="/login" method="post" class="form-contact">\n    <p><label>Name </label><input type="text" name="username" value="" required/>\n    <p><label>Passwortitled </label><input type="text" name="password" value="" required/>\n    <p><input type="submit" value="Send"/>\n</form>\n```\n\n\n## Советы\n\n### Про режим отображения  `typePrint="tk"`\n- Tkinter запускается в новом потоке\n- Если нажать на заголовок консоли, то текстовое поле под ним отчистится\n- Если нажать нижнею кнопку `save geometry` то вы\nсохраните положение окна при следующих запусках\n- Если закрыть окно `Tkinter` , до завершения главного потока, то данные будут отправляться в консоль `typePrint=None"`\n- Рекомендую не использовать режим `typePrint="tk"` если вы разрабатываете программу на самом Tkinter,\nтак как могут быть проблемы с путями к файлам. Например не видеть пути к изображениям.\n\n\n### Про доступную информации об экземпляре `Debugger`\n- public set | get:\n    + `consoleOutput` = Вывод в консоль\n    + `style_text` = Стиль отображения текста\n    + `active()` = Включить дебагер\n    + `deactivate()` = Отключить дебагер\n\n- public get:\n    + `title_name` = Уникальное имя дебагера\n    + `fileConfig` = Конфигурация для файла\n    + `AllCountActiveInstance` = Все активные дебагеры\n    + `AllCountSleepInstance` = Все приостановленный дебагиры\n    + `AllUseFileName` = Все используемые имена файлов\n    + `AllInstance` = Все экземпляры дебагеров\n',
    'author': 'Denis Kustov',
    'author_email': 'denis-kustov@rambler.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/denisxab/console_debugger',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
