# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from memsource_cli.models.id_reference import IdReference  # noqa: F401,E501
from memsource_cli.models.project_template_notify_provider_dto import ProjectTemplateNotifyProviderDto  # noqa: F401,E501
from memsource_cli.models.project_template_workflow_settings_assigned_to_dto import ProjectTemplateWorkflowSettingsAssignedToDto  # noqa: F401,E501
from memsource_cli.models.workflow_step_settings_edit_dto import WorkflowStepSettingsEditDto  # noqa: F401,E501


class ProjectTemplateEditDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'template_name': 'str',
        'source_lang': 'str',
        'target_langs': 'list[str]',
        'notify_provider': 'ProjectTemplateNotifyProviderDto',
        'work_flow_settings': 'list[WorkflowStepSettingsEditDto]',
        'client': 'IdReference',
        'business_unit': 'IdReference',
        'domain': 'IdReference',
        'sub_domain': 'IdReference',
        'note': 'str',
        'assigned_to': 'list[ProjectTemplateWorkflowSettingsAssignedToDto]'
    }

    attribute_map = {
        'name': 'name',
        'template_name': 'templateName',
        'source_lang': 'sourceLang',
        'target_langs': 'targetLangs',
        'notify_provider': 'notifyProvider',
        'work_flow_settings': 'workFlowSettings',
        'client': 'client',
        'business_unit': 'businessUnit',
        'domain': 'domain',
        'sub_domain': 'subDomain',
        'note': 'note',
        'assigned_to': 'assignedTo'
    }

    def __init__(self, name=None, template_name=None, source_lang=None, target_langs=None, notify_provider=None, work_flow_settings=None, client=None, business_unit=None, domain=None, sub_domain=None, note=None, assigned_to=None):  # noqa: E501
        """ProjectTemplateEditDto - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._template_name = None
        self._source_lang = None
        self._target_langs = None
        self._notify_provider = None
        self._work_flow_settings = None
        self._client = None
        self._business_unit = None
        self._domain = None
        self._sub_domain = None
        self._note = None
        self._assigned_to = None
        self.discriminator = None

        if name is not None:
            self.name = name
        self.template_name = template_name
        if source_lang is not None:
            self.source_lang = source_lang
        if target_langs is not None:
            self.target_langs = target_langs
        if notify_provider is not None:
            self.notify_provider = notify_provider
        if work_flow_settings is not None:
            self.work_flow_settings = work_flow_settings
        if client is not None:
            self.client = client
        if business_unit is not None:
            self.business_unit = business_unit
        if domain is not None:
            self.domain = domain
        if sub_domain is not None:
            self.sub_domain = sub_domain
        if note is not None:
            self.note = note
        if assigned_to is not None:
            self.assigned_to = assigned_to

    @property
    def name(self):
        """Gets the name of this ProjectTemplateEditDto.  # noqa: E501


        :return: The name of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProjectTemplateEditDto.


        :param name: The name of this ProjectTemplateEditDto.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if name is not None and len(name) < 0:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `0`")  # noqa: E501

        self._name = name

    @property
    def template_name(self):
        """Gets the template_name of this ProjectTemplateEditDto.  # noqa: E501


        :return: The template_name of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: str
        """
        return self._template_name

    @template_name.setter
    def template_name(self, template_name):
        """Sets the template_name of this ProjectTemplateEditDto.


        :param template_name: The template_name of this ProjectTemplateEditDto.  # noqa: E501
        :type: str
        """
        if template_name is None:
            raise ValueError("Invalid value for `template_name`, must not be `None`")  # noqa: E501
        if template_name is not None and len(template_name) > 255:
            raise ValueError("Invalid value for `template_name`, length must be less than or equal to `255`")  # noqa: E501
        if template_name is not None and len(template_name) < 0:
            raise ValueError("Invalid value for `template_name`, length must be greater than or equal to `0`")  # noqa: E501

        self._template_name = template_name

    @property
    def source_lang(self):
        """Gets the source_lang of this ProjectTemplateEditDto.  # noqa: E501


        :return: The source_lang of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: str
        """
        return self._source_lang

    @source_lang.setter
    def source_lang(self, source_lang):
        """Sets the source_lang of this ProjectTemplateEditDto.


        :param source_lang: The source_lang of this ProjectTemplateEditDto.  # noqa: E501
        :type: str
        """

        self._source_lang = source_lang

    @property
    def target_langs(self):
        """Gets the target_langs of this ProjectTemplateEditDto.  # noqa: E501


        :return: The target_langs of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._target_langs

    @target_langs.setter
    def target_langs(self, target_langs):
        """Sets the target_langs of this ProjectTemplateEditDto.


        :param target_langs: The target_langs of this ProjectTemplateEditDto.  # noqa: E501
        :type: list[str]
        """

        self._target_langs = target_langs

    @property
    def notify_provider(self):
        """Gets the notify_provider of this ProjectTemplateEditDto.  # noqa: E501

        use to notify assigned providers,         notificationIntervalInMinutes 0 or empty value means immediate notification to all providers  # noqa: E501

        :return: The notify_provider of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: ProjectTemplateNotifyProviderDto
        """
        return self._notify_provider

    @notify_provider.setter
    def notify_provider(self, notify_provider):
        """Sets the notify_provider of this ProjectTemplateEditDto.

        use to notify assigned providers,         notificationIntervalInMinutes 0 or empty value means immediate notification to all providers  # noqa: E501

        :param notify_provider: The notify_provider of this ProjectTemplateEditDto.  # noqa: E501
        :type: ProjectTemplateNotifyProviderDto
        """

        self._notify_provider = notify_provider

    @property
    def work_flow_settings(self):
        """Gets the work_flow_settings of this ProjectTemplateEditDto.  # noqa: E501


        :return: The work_flow_settings of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: list[WorkflowStepSettingsEditDto]
        """
        return self._work_flow_settings

    @work_flow_settings.setter
    def work_flow_settings(self, work_flow_settings):
        """Sets the work_flow_settings of this ProjectTemplateEditDto.


        :param work_flow_settings: The work_flow_settings of this ProjectTemplateEditDto.  # noqa: E501
        :type: list[WorkflowStepSettingsEditDto]
        """

        self._work_flow_settings = work_flow_settings

    @property
    def client(self):
        """Gets the client of this ProjectTemplateEditDto.  # noqa: E501


        :return: The client of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: IdReference
        """
        return self._client

    @client.setter
    def client(self, client):
        """Sets the client of this ProjectTemplateEditDto.


        :param client: The client of this ProjectTemplateEditDto.  # noqa: E501
        :type: IdReference
        """

        self._client = client

    @property
    def business_unit(self):
        """Gets the business_unit of this ProjectTemplateEditDto.  # noqa: E501


        :return: The business_unit of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: IdReference
        """
        return self._business_unit

    @business_unit.setter
    def business_unit(self, business_unit):
        """Sets the business_unit of this ProjectTemplateEditDto.


        :param business_unit: The business_unit of this ProjectTemplateEditDto.  # noqa: E501
        :type: IdReference
        """

        self._business_unit = business_unit

    @property
    def domain(self):
        """Gets the domain of this ProjectTemplateEditDto.  # noqa: E501


        :return: The domain of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: IdReference
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this ProjectTemplateEditDto.


        :param domain: The domain of this ProjectTemplateEditDto.  # noqa: E501
        :type: IdReference
        """

        self._domain = domain

    @property
    def sub_domain(self):
        """Gets the sub_domain of this ProjectTemplateEditDto.  # noqa: E501


        :return: The sub_domain of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: IdReference
        """
        return self._sub_domain

    @sub_domain.setter
    def sub_domain(self, sub_domain):
        """Sets the sub_domain of this ProjectTemplateEditDto.


        :param sub_domain: The sub_domain of this ProjectTemplateEditDto.  # noqa: E501
        :type: IdReference
        """

        self._sub_domain = sub_domain

    @property
    def note(self):
        """Gets the note of this ProjectTemplateEditDto.  # noqa: E501


        :return: The note of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """Sets the note of this ProjectTemplateEditDto.


        :param note: The note of this ProjectTemplateEditDto.  # noqa: E501
        :type: str
        """
        if note is not None and len(note) > 4096:
            raise ValueError("Invalid value for `note`, length must be less than or equal to `4096`")  # noqa: E501
        if note is not None and len(note) < 0:
            raise ValueError("Invalid value for `note`, length must be greater than or equal to `0`")  # noqa: E501

        self._note = note

    @property
    def assigned_to(self):
        """Gets the assigned_to of this ProjectTemplateEditDto.  # noqa: E501

        only use for projects without workflows; otherwise specify in the workflowSettings object  # noqa: E501

        :return: The assigned_to of this ProjectTemplateEditDto.  # noqa: E501
        :rtype: list[ProjectTemplateWorkflowSettingsAssignedToDto]
        """
        return self._assigned_to

    @assigned_to.setter
    def assigned_to(self, assigned_to):
        """Sets the assigned_to of this ProjectTemplateEditDto.

        only use for projects without workflows; otherwise specify in the workflowSettings object  # noqa: E501

        :param assigned_to: The assigned_to of this ProjectTemplateEditDto.  # noqa: E501
        :type: list[ProjectTemplateWorkflowSettingsAssignedToDto]
        """

        self._assigned_to = assigned_to

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProjectTemplateEditDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectTemplateEditDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
