# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from memsource_cli.api_client import ApiClient


class WebhookApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_web_hook(self, **kwargs):  # noqa: E501
        """Create webhook  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_web_hook(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WebHookDto body:
        :return: WebHookDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_web_hook_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_web_hook_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_web_hook_with_http_info(self, **kwargs):  # noqa: E501
        """Create webhook  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_web_hook_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WebHookDto body:
        :return: WebHookDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_web_hook" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/webhooks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebHookDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_web_hook(self, web_hook_id, **kwargs):  # noqa: E501
        """Delete webhook  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_web_hook(web_hook_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int web_hook_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_web_hook_with_http_info(web_hook_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_web_hook_with_http_info(web_hook_id, **kwargs)  # noqa: E501
            return data

    def delete_web_hook_with_http_info(self, web_hook_id, **kwargs):  # noqa: E501
        """Delete webhook  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_web_hook_with_http_info(web_hook_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int web_hook_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['web_hook_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_web_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'web_hook_id' is set
        if ('web_hook_id' not in params or
                params['web_hook_id'] is None):
            raise ValueError("Missing the required parameter `web_hook_id` when calling `delete_web_hook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'web_hook_id' in params:
            path_params['webHookId'] = params['web_hook_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/webhooks/{webHookId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_web_hook(self, web_hook_id, **kwargs):  # noqa: E501
        """Get webhook  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_web_hook(web_hook_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int web_hook_id: (required)
        :return: WebHookDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_web_hook_with_http_info(web_hook_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_web_hook_with_http_info(web_hook_id, **kwargs)  # noqa: E501
            return data

    def get_web_hook_with_http_info(self, web_hook_id, **kwargs):  # noqa: E501
        """Get webhook  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_web_hook_with_http_info(web_hook_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int web_hook_id: (required)
        :return: WebHookDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['web_hook_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_web_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'web_hook_id' is set
        if ('web_hook_id' not in params or
                params['web_hook_id'] is None):
            raise ValueError("Missing the required parameter `web_hook_id` when calling `get_web_hook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'web_hook_id' in params:
            path_params['webHookId'] = params['web_hook_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/webhooks/{webHookId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebHookDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_web_hook_list(self, **kwargs):  # noqa: E501
        """Lists webhooks  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_web_hook_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoWebHookDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_web_hook_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_web_hook_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_web_hook_list_with_http_info(self, **kwargs):  # noqa: E501
        """Lists webhooks  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_web_hook_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoWebHookDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_web_hook_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/webhooks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoWebHookDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_web_hook(self, web_hook_id, **kwargs):  # noqa: E501
        """Edit webhook  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_web_hook(web_hook_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int web_hook_id: (required)
        :param WebHookDto body:
        :return: WebHookDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_web_hook_with_http_info(web_hook_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_web_hook_with_http_info(web_hook_id, **kwargs)  # noqa: E501
            return data

    def update_web_hook_with_http_info(self, web_hook_id, **kwargs):  # noqa: E501
        """Edit webhook  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_web_hook_with_http_info(web_hook_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int web_hook_id: (required)
        :param WebHookDto body:
        :return: WebHookDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['web_hook_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_web_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'web_hook_id' is set
        if ('web_hook_id' not in params or
                params['web_hook_id'] is None):
            raise ValueError("Missing the required parameter `web_hook_id` when calling `update_web_hook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'web_hook_id' in params:
            path_params['webHookId'] = params['web_hook_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/webhooks/{webHookId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebHookDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
