# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from memsource_cli.api_client import ApiClient


class PriceListApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_language_pair(self, price_list_id, **kwargs):  # noqa: E501
        """Add language pairs  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_language_pair(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param TranslationPriceSetCreateDto body:
        :return: TranslationPriceSetListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_language_pair_with_http_info(price_list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_language_pair_with_http_info(price_list_id, **kwargs)  # noqa: E501
            return data

    def create_language_pair_with_http_info(self, price_list_id, **kwargs):  # noqa: E501
        """Add language pairs  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_language_pair_with_http_info(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param TranslationPriceSetCreateDto body:
        :return: TranslationPriceSetListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_language_pair" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `create_language_pair`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists/{priceListId}/priceSets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TranslationPriceSetListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_price_list(self, **kwargs):  # noqa: E501
        """Create price list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_price_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TranslationPriceListCreateDto body:
        :return: TranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_price_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_price_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_price_list_with_http_info(self, **kwargs):  # noqa: E501
        """Create price list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_price_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TranslationPriceListCreateDto body:
        :return: TranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_price_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TranslationPriceListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_language_pair(self, price_list_id, source_language, target_language, **kwargs):  # noqa: E501
        """Remove language pair  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_language_pair(price_list_id, source_language, target_language, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param str source_language: (required)
        :param str target_language: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_language_pair_with_http_info(price_list_id, source_language, target_language, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_language_pair_with_http_info(price_list_id, source_language, target_language, **kwargs)  # noqa: E501
            return data

    def delete_language_pair_with_http_info(self, price_list_id, source_language, target_language, **kwargs):  # noqa: E501
        """Remove language pair  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_language_pair_with_http_info(price_list_id, source_language, target_language, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param str source_language: (required)
        :param str target_language: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id', 'source_language', 'target_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_language_pair" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `delete_language_pair`")  # noqa: E501
        # verify the required parameter 'source_language' is set
        if ('source_language' not in params or
                params['source_language'] is None):
            raise ValueError("Missing the required parameter `source_language` when calling `delete_language_pair`")  # noqa: E501
        # verify the required parameter 'target_language' is set
        if ('target_language' not in params or
                params['target_language'] is None):
            raise ValueError("Missing the required parameter `target_language` when calling `delete_language_pair`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501
        if 'source_language' in params:
            path_params['sourceLanguage'] = params['source_language']  # noqa: E501
        if 'target_language' in params:
            path_params['targetLanguage'] = params['target_language']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists/{priceListId}/priceSets/{sourceLanguage}/{targetLanguage}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_language_pairs(self, price_list_id, **kwargs):  # noqa: E501
        """Remove language pairs  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_language_pairs(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param TranslationPriceSetBulkDeleteDto body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_language_pairs_with_http_info(price_list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_language_pairs_with_http_info(price_list_id, **kwargs)  # noqa: E501
            return data

    def delete_language_pairs_with_http_info(self, price_list_id, **kwargs):  # noqa: E501
        """Remove language pairs  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_language_pairs_with_http_info(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param TranslationPriceSetBulkDeleteDto body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_language_pairs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `delete_language_pairs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists/{priceListId}/priceSets', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_price_list(self, price_list_id, **kwargs):  # noqa: E501
        """Delete price list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_price_list(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_price_list_with_http_info(price_list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_price_list_with_http_info(price_list_id, **kwargs)  # noqa: E501
            return data

    def delete_price_list_with_http_info(self, price_list_id, **kwargs):  # noqa: E501
        """Delete price list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_price_list_with_http_info(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_price_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `delete_price_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists/{priceListId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_of_price_list(self, **kwargs):  # noqa: E501
        """List price lists  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_of_price_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoTranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_of_price_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_list_of_price_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_list_of_price_list_with_http_info(self, **kwargs):  # noqa: E501
        """List price lists  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_of_price_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :return: PageDtoTranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_of_price_list" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_number' in params and params['page_number'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_number` when calling `get_list_of_price_list`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 50:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_list_of_price_list`, must be a value less than or equal to `50`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_list_of_price_list`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoTranslationPriceListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_price_list(self, price_list_id, **kwargs):  # noqa: E501
        """Get price list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_price_list(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :return: TranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_price_list_with_http_info(price_list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_price_list_with_http_info(price_list_id, **kwargs)  # noqa: E501
            return data

    def get_price_list_with_http_info(self, price_list_id, **kwargs):  # noqa: E501
        """Get price list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_price_list_with_http_info(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :return: TranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_price_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `get_price_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists/{priceListId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TranslationPriceListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_prices_with_workflow_steps(self, price_list_id, **kwargs):  # noqa: E501
        """List price sets  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_prices_with_workflow_steps(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :param list[str] source_languages:
        :param list[str] target_languages:
        :return: PageDtoTranslationPriceSetDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_prices_with_workflow_steps_with_http_info(price_list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_prices_with_workflow_steps_with_http_info(price_list_id, **kwargs)  # noqa: E501
            return data

    def get_prices_with_workflow_steps_with_http_info(self, price_list_id, **kwargs):  # noqa: E501
        """List price sets  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_prices_with_workflow_steps_with_http_info(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :param list[str] source_languages:
        :param list[str] target_languages:
        :return: PageDtoTranslationPriceSetDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id', 'page_number', 'page_size', 'source_languages', 'target_languages']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_prices_with_workflow_steps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `get_prices_with_workflow_steps`")  # noqa: E501

        if 'page_number' in params and params['page_number'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_number` when calling `get_prices_with_workflow_steps`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 50:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_prices_with_workflow_steps`, must be a value less than or equal to `50`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_prices_with_workflow_steps`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'source_languages' in params:
            query_params.append(('sourceLanguages', params['source_languages']))  # noqa: E501
            collection_formats['sourceLanguages'] = 'multi'  # noqa: E501
        if 'target_languages' in params:
            query_params.append(('targetLanguages', params['target_languages']))  # noqa: E501
            collection_formats['targetLanguages'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists/{priceListId}/priceSets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoTranslationPriceSetDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_minimum_price_for_set(self, price_list_id, **kwargs):  # noqa: E501
        """Edit minimum prices  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_minimum_price_for_set(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param TranslationPriceSetBulkMinimumPricesDto body:
        :return: TranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_minimum_price_for_set_with_http_info(price_list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_minimum_price_for_set_with_http_info(price_list_id, **kwargs)  # noqa: E501
            return data

    def set_minimum_price_for_set_with_http_info(self, price_list_id, **kwargs):  # noqa: E501
        """Edit minimum prices  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_minimum_price_for_set_with_http_info(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param TranslationPriceSetBulkMinimumPricesDto body:
        :return: TranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_minimum_price_for_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `set_minimum_price_for_set`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists/{priceListId}/priceSets/minimumPrices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TranslationPriceListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_prices(self, price_list_id, **kwargs):  # noqa: E501
        """Edit prices  # noqa: E501

        If object contains only price, all languages and workflow steps will be updated  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_prices(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param TranslationPriceSetBulkPricesDto body:
        :return: TranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_prices_with_http_info(price_list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_prices_with_http_info(price_list_id, **kwargs)  # noqa: E501
            return data

    def set_prices_with_http_info(self, price_list_id, **kwargs):  # noqa: E501
        """Edit prices  # noqa: E501

        If object contains only price, all languages and workflow steps will be updated  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_prices_with_http_info(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param TranslationPriceSetBulkPricesDto body:
        :return: TranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_prices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `set_prices`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists/{priceListId}/priceSets/prices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TranslationPriceListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_price_list(self, price_list_id, **kwargs):  # noqa: E501
        """Update price list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_price_list(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param TranslationPriceListCreateDto body:
        :return: TranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_price_list_with_http_info(price_list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_price_list_with_http_info(price_list_id, **kwargs)  # noqa: E501
            return data

    def update_price_list_with_http_info(self, price_list_id, **kwargs):  # noqa: E501
        """Update price list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_price_list_with_http_info(price_list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int price_list_id: (required)
        :param TranslationPriceListCreateDto body:
        :return: TranslationPriceListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['price_list_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_price_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'price_list_id' is set
        if ('price_list_id' not in params or
                params['price_list_id'] is None):
            raise ValueError("Missing the required parameter `price_list_id` when calling `update_price_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'price_list_id' in params:
            path_params['priceListId'] = params['price_list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/priceLists/{priceListId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TranslationPriceListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
