# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from memsource_cli.api_client import ApiClient


class FileApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_url_file(self, body, content_disposition, **kwargs):  # noqa: E501
        """Upload file  # noqa: E501

        Accepts multipart/form-data, application/octet-stream or application/json.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_url_file(body, content_disposition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoteUploadedFileDto body: file (required)
        :param str content_disposition: must match pattern `filename\\*=UTF-8''(.+)` (required)
        :return: UploadedFileDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_url_file_with_http_info(body, content_disposition, **kwargs)  # noqa: E501
        else:
            (data) = self.create_url_file_with_http_info(body, content_disposition, **kwargs)  # noqa: E501
            return data

    def create_url_file_with_http_info(self, body, content_disposition, **kwargs):  # noqa: E501
        """Upload file  # noqa: E501

        Accepts multipart/form-data, application/octet-stream or application/json.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_url_file_with_http_info(body, content_disposition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoteUploadedFileDto body: file (required)
        :param str content_disposition: must match pattern `filename\\*=UTF-8''(.+)` (required)
        :return: UploadedFileDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'content_disposition']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_url_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_url_file`")  # noqa: E501
        # verify the required parameter 'content_disposition' is set
        if ('content_disposition' not in params or
                params['content_disposition'] is None):
            raise ValueError("Missing the required parameter `content_disposition` when calling `create_url_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'content_disposition' in params:
            header_params['Content-Disposition'] = params['content_disposition']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/octet-stream', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UploadedFileDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deletes_file(self, file_uid, **kwargs):  # noqa: E501
        """Delete file  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deletes_file(file_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_uid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.deletes_file_with_http_info(file_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.deletes_file_with_http_info(file_uid, **kwargs)  # noqa: E501
            return data

    def deletes_file_with_http_info(self, file_uid, **kwargs):  # noqa: E501
        """Delete file  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deletes_file_with_http_info(file_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_uid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletes_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_uid' is set
        if ('file_uid' not in params or
                params['file_uid'] is None):
            raise ValueError("Missing the required parameter `file_uid` when calling `deletes_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_uid' in params:
            path_params['fileUid'] = params['file_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/files/{fileUid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_json(self, file_uid, **kwargs):  # noqa: E501
        """Get file  # noqa: E501

        Get uploaded file as <b>octet-stream</b> or as <b>json</b> based on 'Accept' header  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_json(file_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_uid: (required)
        :return: UploadedFileDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_json_with_http_info(file_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_json_with_http_info(file_uid, **kwargs)  # noqa: E501
            return data

    def get_file_json_with_http_info(self, file_uid, **kwargs):  # noqa: E501
        """Get file  # noqa: E501

        Get uploaded file as <b>octet-stream</b> or as <b>json</b> based on 'Accept' header  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_json_with_http_info(file_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_uid: (required)
        :return: UploadedFileDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_uid' is set
        if ('file_uid' not in params or
                params['file_uid'] is None):
            raise ValueError("Missing the required parameter `file_uid` when calling `get_file_json`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_uid' in params:
            path_params['fileUid'] = params['file_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/files/{fileUid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UploadedFileDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_files(self, **kwargs):  # noqa: E501
        """List files  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_files(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :param str name:
        :param list[str] types:
        :param int created_by:
        :param int bigger_than: Size in bytes
        :return: PageDtoUploadedFileDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_files_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_files_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_files_with_http_info(self, **kwargs):  # noqa: E501
        """List files  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_number: Page number, starting with 0, default 0
        :param int page_size: Page size, accepts values between 1 and 50, default 50
        :param str name:
        :param list[str] types:
        :param int created_by:
        :param int bigger_than: Size in bytes
        :return: PageDtoUploadedFileDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'name', 'types', 'created_by', 'bigger_than']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_files" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_number' in params and params['page_number'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_number` when calling `get_files`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 50:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_files`, must be a value less than or equal to `50`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_files`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'types' in params:
            query_params.append(('types', params['types']))  # noqa: E501
            collection_formats['types'] = 'multi'  # noqa: E501
        if 'created_by' in params:
            query_params.append(('createdBy', params['created_by']))  # noqa: E501
        if 'bigger_than' in params:
            query_params.append(('biggerThan', params['bigger_than']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDtoUploadedFileDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
