# coding: utf-8

"""
    Memsource REST API

    Welcome to Memsource's API documentation. To view our legacy APIs please [visit our documentation](https://wiki.memsource.com/wiki/Memsource_API) and for more information about our new APIs, [visit our blog](https://www.memsource.com/blog/2017/10/24/introducing-rest-apis-qa-with-the-memsource-api-team/).    If you have any questions, please contact [Memsource Support](<mailto:support@memsource.com>).  # noqa: E501

    OpenAPI spec version: Latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from memsource_cli.api_client import ApiClient


class ConversationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_lqa_comment(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Add LQA comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_lqa_comment(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param AddCommentDto body:
        :return: LQAConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_lqa_comment_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_lqa_comment_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
            return data

    def add_lqa_comment_with_http_info(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Add LQA comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_lqa_comment_with_http_info(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param AddCommentDto body:
        :return: LQAConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_lqa_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `add_lqa_comment`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `add_lqa_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/lqas/{conversationId}/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LQAConversationDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_plain_comment(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Add plain comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_plain_comment(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param AddCommentDto body:
        :return: PlainConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_plain_comment_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_plain_comment_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
            return data

    def add_plain_comment_with_http_info(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Add plain comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_plain_comment_with_http_info(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param AddCommentDto body:
        :return: PlainConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_plain_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `add_plain_comment`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `add_plain_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/plains/{conversationId}/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PlainConversationDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_lqa_conversation(self, job_uid, **kwargs):  # noqa: E501
        """Create LQA conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_lqa_conversation(job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param CreateLQAConversationDto body:
        :return: LQAConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_lqa_conversation_with_http_info(job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.create_lqa_conversation_with_http_info(job_uid, **kwargs)  # noqa: E501
            return data

    def create_lqa_conversation_with_http_info(self, job_uid, **kwargs):  # noqa: E501
        """Create LQA conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_lqa_conversation_with_http_info(job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param CreateLQAConversationDto body:
        :return: LQAConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_lqa_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `create_lqa_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/lqas', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LQAConversationDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_segment_target_conversation(self, job_uid, **kwargs):  # noqa: E501
        """Create plain conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_segment_target_conversation(job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param CreatePlainConversationDto body:
        :return: PlainConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_segment_target_conversation_with_http_info(job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.create_segment_target_conversation_with_http_info(job_uid, **kwargs)  # noqa: E501
            return data

    def create_segment_target_conversation_with_http_info(self, job_uid, **kwargs):  # noqa: E501
        """Create plain conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_segment_target_conversation_with_http_info(job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param CreatePlainConversationDto body:
        :return: PlainConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_segment_target_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `create_segment_target_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/plains', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PlainConversationDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_lqa_comment(self, job_uid, conversation_id, comment_id, **kwargs):  # noqa: E501
        """Delete LQA comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_lqa_comment(job_uid, conversation_id, comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param str comment_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_lqa_comment_with_http_info(job_uid, conversation_id, comment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_lqa_comment_with_http_info(job_uid, conversation_id, comment_id, **kwargs)  # noqa: E501
            return data

    def delete_lqa_comment_with_http_info(self, job_uid, conversation_id, comment_id, **kwargs):  # noqa: E501
        """Delete LQA comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_lqa_comment_with_http_info(job_uid, conversation_id, comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param str comment_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id', 'comment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_lqa_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `delete_lqa_comment`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `delete_lqa_comment`")  # noqa: E501
        # verify the required parameter 'comment_id' is set
        if ('comment_id' not in params or
                params['comment_id'] is None):
            raise ValueError("Missing the required parameter `comment_id` when calling `delete_lqa_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501
        if 'comment_id' in params:
            path_params['commentId'] = params['comment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/lqas/{conversationId}/comments/{commentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_lqa_conversation(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Delete conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_lqa_conversation(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_lqa_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_lqa_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
            return data

    def delete_lqa_conversation_with_http_info(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Delete conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_lqa_conversation_with_http_info(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_lqa_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `delete_lqa_conversation`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `delete_lqa_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/lqas/{conversationId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_plain_comment(self, job_uid, conversation_id, comment_id, **kwargs):  # noqa: E501
        """Delete plain comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plain_comment(job_uid, conversation_id, comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param str comment_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_plain_comment_with_http_info(job_uid, conversation_id, comment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_plain_comment_with_http_info(job_uid, conversation_id, comment_id, **kwargs)  # noqa: E501
            return data

    def delete_plain_comment_with_http_info(self, job_uid, conversation_id, comment_id, **kwargs):  # noqa: E501
        """Delete plain comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plain_comment_with_http_info(job_uid, conversation_id, comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param str comment_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id', 'comment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_plain_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `delete_plain_comment`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `delete_plain_comment`")  # noqa: E501
        # verify the required parameter 'comment_id' is set
        if ('comment_id' not in params or
                params['comment_id'] is None):
            raise ValueError("Missing the required parameter `comment_id` when calling `delete_plain_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501
        if 'comment_id' in params:
            path_params['commentId'] = params['comment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/plains/{conversationId}/comments/{commentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_plain_conversation(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Delete plain conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plain_conversation(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_plain_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_plain_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
            return data

    def delete_plain_conversation_with_http_info(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Delete plain conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_plain_conversation_with_http_info(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_plain_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `delete_plain_conversation`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `delete_plain_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/plains/{conversationId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_conversations(self, **kwargs):  # noqa: E501
        """Find all conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_conversations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FindConversationsDto body:
        :return: ConversationListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_conversations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.find_conversations_with_http_info(**kwargs)  # noqa: E501
            return data

    def find_conversations_with_http_info(self, **kwargs):  # noqa: E501
        """Find all conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_conversations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FindConversationsDto body:
        :return: ConversationListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_conversations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/conversations/find', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_lqa_conversation(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Get LQA conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lqa_conversation(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :return: LQAConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_lqa_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_lqa_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
            return data

    def get_lqa_conversation_with_http_info(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Get LQA conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lqa_conversation_with_http_info(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :return: LQAConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lqa_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `get_lqa_conversation`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_lqa_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/lqas/{conversationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LQAConversationDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_plain_conversation(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Get plain conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plain_conversation(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :return: PlainConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_plain_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_plain_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
            return data

    def get_plain_conversation_with_http_info(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Get plain conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plain_conversation_with_http_info(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :return: PlainConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plain_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `get_plain_conversation`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_plain_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/plains/{conversationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PlainConversationDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_all_conversations(self, job_uid, **kwargs):  # noqa: E501
        """List all conversations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_conversations(job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param bool include_deleted:
        :param str since:
        :return: ConversationListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_all_conversations_with_http_info(job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_all_conversations_with_http_info(job_uid, **kwargs)  # noqa: E501
            return data

    def list_all_conversations_with_http_info(self, job_uid, **kwargs):  # noqa: E501
        """List all conversations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_conversations_with_http_info(job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param bool include_deleted:
        :param str since:
        :return: ConversationListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'include_deleted', 'since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_conversations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `list_all_conversations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []
        if 'include_deleted' in params:
            query_params.append(('includeDeleted', params['include_deleted']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConversationListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_lqa_conversations(self, job_uid, **kwargs):  # noqa: E501
        """List LQA conversations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_lqa_conversations(job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param bool include_deleted:
        :param str since:
        :return: LQAConversationsListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_lqa_conversations_with_http_info(job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_lqa_conversations_with_http_info(job_uid, **kwargs)  # noqa: E501
            return data

    def list_lqa_conversations_with_http_info(self, job_uid, **kwargs):  # noqa: E501
        """List LQA conversations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_lqa_conversations_with_http_info(job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param bool include_deleted:
        :param str since:
        :return: LQAConversationsListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'include_deleted', 'since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_lqa_conversations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `list_lqa_conversations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []
        if 'include_deleted' in params:
            query_params.append(('includeDeleted', params['include_deleted']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/lqas', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LQAConversationsListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_plain_conversations(self, job_uid, **kwargs):  # noqa: E501
        """List plain conversations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plain_conversations(job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param bool include_deleted:
        :param str since:
        :return: PlainConversationsListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_plain_conversations_with_http_info(job_uid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_plain_conversations_with_http_info(job_uid, **kwargs)  # noqa: E501
            return data

    def list_plain_conversations_with_http_info(self, job_uid, **kwargs):  # noqa: E501
        """List plain conversations  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_plain_conversations_with_http_info(job_uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param bool include_deleted:
        :param str since:
        :return: PlainConversationsListDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'include_deleted', 'since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_plain_conversations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `list_plain_conversations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501

        query_params = []
        if 'include_deleted' in params:
            query_params.append(('includeDeleted', params['include_deleted']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/plains', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PlainConversationsListDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_lqa_comment(self, job_uid, conversation_id, comment_id, **kwargs):  # noqa: E501
        """Edit LQA comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_lqa_comment(job_uid, conversation_id, comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param str comment_id: (required)
        :param AddCommentDto body:
        :return: LQAConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_lqa_comment_with_http_info(job_uid, conversation_id, comment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_lqa_comment_with_http_info(job_uid, conversation_id, comment_id, **kwargs)  # noqa: E501
            return data

    def update_lqa_comment_with_http_info(self, job_uid, conversation_id, comment_id, **kwargs):  # noqa: E501
        """Edit LQA comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_lqa_comment_with_http_info(job_uid, conversation_id, comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param str comment_id: (required)
        :param AddCommentDto body:
        :return: LQAConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id', 'comment_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_lqa_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `update_lqa_comment`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `update_lqa_comment`")  # noqa: E501
        # verify the required parameter 'comment_id' is set
        if ('comment_id' not in params or
                params['comment_id'] is None):
            raise ValueError("Missing the required parameter `comment_id` when calling `update_lqa_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501
        if 'comment_id' in params:
            path_params['commentId'] = params['comment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/lqas/{conversationId}/comments/{commentId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LQAConversationDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_lqa_conversation(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Edit LQA conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_lqa_conversation(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param EditLQAConversationDto body:
        :return: LQAConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_lqa_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_lqa_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
            return data

    def update_lqa_conversation_with_http_info(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Edit LQA conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_lqa_conversation_with_http_info(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param EditLQAConversationDto body:
        :return: LQAConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_lqa_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `update_lqa_conversation`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `update_lqa_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/lqas/{conversationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LQAConversationDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_plain_comment(self, job_uid, conversation_id, comment_id, **kwargs):  # noqa: E501
        """Edit plain comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plain_comment(job_uid, conversation_id, comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param str comment_id: (required)
        :param AddCommentDto body:
        :return: PlainConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_plain_comment_with_http_info(job_uid, conversation_id, comment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_plain_comment_with_http_info(job_uid, conversation_id, comment_id, **kwargs)  # noqa: E501
            return data

    def update_plain_comment_with_http_info(self, job_uid, conversation_id, comment_id, **kwargs):  # noqa: E501
        """Edit plain comment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plain_comment_with_http_info(job_uid, conversation_id, comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param str comment_id: (required)
        :param AddCommentDto body:
        :return: PlainConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id', 'comment_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_plain_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `update_plain_comment`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `update_plain_comment`")  # noqa: E501
        # verify the required parameter 'comment_id' is set
        if ('comment_id' not in params or
                params['comment_id'] is None):
            raise ValueError("Missing the required parameter `comment_id` when calling `update_plain_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501
        if 'comment_id' in params:
            path_params['commentId'] = params['comment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/plains/{conversationId}/comments/{commentId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PlainConversationDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_plain_conversation(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Edit plain conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plain_conversation(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param EditPlainConversationDto body:
        :return: PlainConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_plain_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_plain_conversation_with_http_info(job_uid, conversation_id, **kwargs)  # noqa: E501
            return data

    def update_plain_conversation_with_http_info(self, job_uid, conversation_id, **kwargs):  # noqa: E501
        """Edit plain conversation  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_plain_conversation_with_http_info(job_uid, conversation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_uid: (required)
        :param str conversation_id: (required)
        :param EditPlainConversationDto body:
        :return: PlainConversationDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_uid', 'conversation_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_plain_conversation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_uid' is set
        if ('job_uid' not in params or
                params['job_uid'] is None):
            raise ValueError("Missing the required parameter `job_uid` when calling `update_plain_conversation`")  # noqa: E501
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params or
                params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `update_plain_conversation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_uid' in params:
            path_params['jobUid'] = params['job_uid']  # noqa: E501
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api2/v1/jobs/{jobUid}/conversations/plains/{conversationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PlainConversationDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
