import { aws_eks, aws_rds } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { DnsProps } from '../../interfaces/dns-props';
export interface KongCPProps {
    readonly cluster: aws_eks.Cluster;
    readonly rds: aws_rds.DatabaseInstance;
    readonly namespace: string;
    readonly license_secret_name: string;
    readonly endpoints: DnsProps;
    readonly HelmOptions?: aws_eks.HelmChartOptions;
}
export declare class KongControlPlaneEKS extends Construct {
    private helmOptions;
    constructor(scope: Construct, id: string, props: KongCPProps);
}
