"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
const index_1 = require("./resources/eks/helm-charts/kong/index");
class KongEks extends constructs_1.Construct {
    // public endpoints: DnsProps;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        // this.endpoints = {
        //   adminDns: `admin.${props.hostedZoneName}:443`,
        //   clusterDns: `cluster.${props.hostedZoneName}:443`,
        //   telemetryDns: `telemetry.${props.hostedZoneName}:443`,
        //   managerDns: `manager.${props.hostedZoneName}:443`,
        // };
        const control_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'CPSecretsKey', {
            enableKeyRotation: true,
        });
        this.controlPlane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps.eksClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
            albController: {
                version: aws_cdk_lib_1.aws_eks.AlbControllerVersion.V2_4_1,
            },
        });
        const cp_nodegroup = this.controlPlane.addNodegroupCapacity('CpASG', props.controlPlaneNodeProps);
        cp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        // });
        new kong_core.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        const kong_rds_instance = new kong_core.RdsStack(this, 'KongRds', {
            ...props.rdsProps,
            vpc: this.controlPlane.vpc,
        });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: this.controlPlane,
        });
        new kong_core.ExternalDns(kong_pre_requisites_nested_stack, 'ExtDns', {
            cluster: this.controlPlane,
            hostedZoneName: props.dnsProps.hostedZoneName,
        });
        const aws_acm_pca = new kong_core.AcmPca(kong_pre_requisites_nested_stack, 'KongCpCa', {
            // hostedZoneName: props.dnsProps.hostedZoneName,
            // vpc: this.controlPlane.vpc,
            // dnsNames: [
            //   props.dnsProps.adminDns,
            //   props.dnsProps.clusterDns,
            //   props.dnsProps.telemetryDns,
            //   props.dnsProps.managerDns,
            //   props.dnsProps.hostedZoneName,
            // ],
            subjectRootCa: {
                organization: 'Amazon',
            },
            subjectSubCa: {
                organization: 'AWS',
            },
        });
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'KongCpCertManager', {
            cluster: this.controlPlane,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            privateCaArn: aws_acm_pca.privateCaArn,
            email: props.emailForCertRenewal,
            hostedZoneName: props.dnsProps.hostedZoneName,
        });
        this.privateCaArn = aws_acm_pca.privateCaArn;
        const kong_control_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongCpNestedStack');
        new index_1.KongControlPlaneEKS(kong_control_plane_nested_stack, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            // nodegroup: cp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            // cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            // clusterIssuerName: kong_core.Tls.KONG_ACME_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            // hostedZoneName: props.dnsProps.hostedZoneName,
            HelmOptions: props.controlPlaneClusterProps.kongHelmOptions,
            endpoints: props.dnsProps,
        });
        kong_control_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack, kong_rds_instance);
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryNestedStack');
        const telemetry_stack = new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.controlPlaneClusterProps.kongTelemetryOptions.createPrometheusWorkspace,
            cluster: this.controlPlane,
            namespace: kong_core.Namespace.TELEMETRY,
        });
        this.prometheusEndpoint = telemetry_stack.prometheusEndpoint;
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "3.0.0-dev.26" };
//# sourceMappingURL=data:application/json;base64,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