"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEcs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ecs = require("aws-cdk-lib/aws-ecs");
// import { PostgresEngineVersion } from 'aws-cdk-lib/aws-rds';
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
//import * as kong_core from 'kong-core';
// import { RdsDatabaseProps } from './kong-eks';
const index_1 = require("./resources/ecs/index");
class KongEcs extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        //Create the Kong CP ECS Cluster
        const cluster = new ecs.Cluster(this, 'KongCPCluster', props.clusterProps);
        this.controlPlane = cluster;
        //Create the RDS Instance for KongCP
        const rds = new kong_core.RdsStack(this, 'KongCPRds', {
            ...props.rdsProps,
            vpc: this.controlPlane.vpc,
        });
        //Create the NLB for KongCP Admin
        const nlbAdmin = new kong_core.NlbStack(this, 'KongCPAlb', {
            vpc: this.controlPlane.vpc,
            name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_ADMIN_LB_SUFFIX,
            internetFacing: props.internetFacing ?? false,
        });
        //Create the NLB for KongCP Manager
        let nlbManager;
        if (props.kongFeaturesProps.kongManagerProps.enabled) {
            nlbManager = new kong_core.NlbStack(this, 'KongCPManagerAlb', {
                vpc: this.controlPlane.vpc,
                name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_MANAGER_LB_SUFFIX,
                internetFacing: props.internetFacing ?? false,
            });
        }
        //Create the NLB for KongCP DevPortal
        let nlbDevPortal;
        if (props.kongFeaturesProps.devPortalProps.enabled) {
            nlbDevPortal = new kong_core.NlbStack(this, 'KongCPDevPortalAlb', {
                vpc: this.controlPlane.vpc,
                name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_DEVPORTAL_LB_SUFFIX,
                internetFacing: props.internetFacing ?? false,
            });
        }
        const tld = props.hostedZoneName;
        this.clusterDns = 'cluster.' + tld + ':' + (props.kongFeaturesProps.clusterProps.port ?? 8005);
        this.telemetryDns = 'telemetry.' + tld + ':' + (props.kongFeaturesProps.clusterTelemetryProps.port ?? 8006);
        const private_ca = new kong_core.AcmPca(this, 'KongPCA', {
            subjectRootCa: {
                organization: 'Amazon',
            },
            subjectSubCa: {
                organization: 'AWS',
            },
        });
        this.privateCaArn = private_ca.privateCaArn;
        const kongCPCertificates = new kong_core.Certificates(this, 'KongCPCertificate', {
            topLevelDomain: tld,
            privateCaArn: private_ca.privateCaArn,
            dnsNames: [
                tld,
                'admin.' + tld,
                'cluster.' + tld,
                'telemetry.' + tld,
                'manager.' + tld,
            ],
        });
        kongCPCertificates.node.addDependency(private_ca);
        // const hosted_zone = aws_route53.HostedZone.fromLookup(this, 'HZ', {
        //   domainName: props.hostedZoneName,
        // });
        new index_1.KongControlPlaneECS(this, 'KongCP', {
            cluster: cluster,
            rds: rds.kongPostgresSql,
            adminNlb: nlbAdmin.kongNlb,
            managerNlb: nlbManager ? nlbManager.kongNlb : undefined,
            devPortalNlb: nlbDevPortal ? nlbDevPortal.kongNlb : undefined,
            image: props.image ?? 'docker.io/kong/kong-gateway:2.8.1.0-alpine',
            licenseSecret: props.licenseSecret ?? undefined,
            kongFeaturesProps: {
                adminProps: {
                    httpPort: props.kongFeaturesProps.adminProps.httpPort ?? 8001,
                    httpsPort: props.kongFeaturesProps.adminProps.httpsPort ?? 8444,
                    enableHttp: props.kongFeaturesProps.adminProps.enableHttp ?? true,
                },
                kongManagerProps: {
                    enabled: props.kongFeaturesProps.kongManagerProps.enabled ?? true,
                    enableHttp: props.kongFeaturesProps.kongManagerProps.enableHttp ?? true,
                    httpPort: props.kongFeaturesProps.kongManagerProps.httpPort ?? 8002,
                    httpsPort: props.kongFeaturesProps.kongManagerProps.httpsPort ?? 8445,
                },
                devPortalProps: {
                    enabled: props.kongFeaturesProps.devPortalProps.enabled ?? true,
                },
                clusterProps: {
                    enabled: props.kongFeaturesProps.clusterProps.enabled ?? true,
                    port: props.kongFeaturesProps.clusterProps.port ?? 8005,
                },
                clusterTelemetryProps: {
                    enabled: props.kongFeaturesProps.clusterTelemetryProps.enabled ?? true,
                    port: props.kongFeaturesProps.clusterTelemetryProps.port ?? 8006,
                },
                kongBootstrapMigration: props.kongFeaturesProps.kongBootstrapMigration ?? true,
            },
            kongTaskProps: props.kongTaskProps,
            certificates: kongCPCertificates,
            hostedZoneName: props.hostedZoneName,
            desiredCount: props.desiredCount,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'KongAdminLBDNSName', {
            value: nlbAdmin.kongNlb.loadBalancerDnsName,
            exportName: 'KongAdminLBDNSName',
        });
        if (nlbManager) {
            new aws_cdk_lib_1.CfnOutput(this, 'KongManagerLBBDNSName', {
                value: nlbManager.kongNlb.loadBalancerDnsName,
                exportName: 'KongManagerLBBDNSName',
            });
        }
        if (nlbDevPortal) {
            new aws_cdk_lib_1.CfnOutput(this, 'KongDevPortalLBBDNSName', {
                value: nlbDevPortal.kongNlb.loadBalancerDnsName,
                exportName: 'KongDevPortalLBBDNSName',
            });
        }
    }
}
exports.KongEcs = KongEcs;
_a = JSII_RTTI_SYMBOL_1;
KongEcs[_a] = { fqn: "kong-control-plane.KongEcs", version: "3.0.0-dev.26" };
//# sourceMappingURL=data:application/json;base64,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