"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const utils_1 = require("./private/utils");
const virtual_router_1 = require("./virtual-router");
/**
 * Route represents a new or existing route attached to a VirtualRouter and Mesh
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html
 */
class Route extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.routeName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_RouteProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Route);
            }
            throw error;
        }
        this.virtualRouter = props.virtualRouter;
        const spec = props.routeSpec.bind(this);
        const route = new appmesh_generated_1.CfnRoute(this, 'Resource', {
            routeName: this.physicalName,
            meshName: this.virtualRouter.mesh.meshName,
            meshOwner: utils_1.renderMeshOwner(this.env.account, this.virtualRouter.mesh.env.account),
            virtualRouterName: this.virtualRouter.virtualRouterName,
            spec: {
                tcpRoute: spec.tcpRouteSpec,
                httpRoute: spec.httpRouteSpec,
                http2Route: spec.http2RouteSpec,
                grpcRoute: spec.grpcRouteSpec,
                priority: spec.priority,
            },
        });
        this.routeName = this.getResourceNameAttribute(route.attrRouteName);
        this.routeArn = this.getResourceArnAttribute(route.ref, {
            service: 'appmesh',
            resource: `mesh/${props.mesh.meshName}/virtualRouter/${props.virtualRouter.virtualRouterName}/route`,
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing Route given an ARN
     */
    static fromRouteArn(scope, id, routeArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.routeArn = routeArn;
                this.virtualRouter = virtual_router_1.VirtualRouter.fromVirtualRouterArn(this, 'VirtualRouter', routeArn);
                this.routeName = cdk.Fn.select(4, cdk.Fn.split('/', cdk.Stack.of(scope).splitArn(routeArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName));
            }
        }(scope, id);
    }
    /**
     * Import an existing Route given attributes
     */
    static fromRouteAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_RouteAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromRouteAttributes);
            }
            throw error;
        }
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.routeName = attrs.routeName;
                this.virtualRouter = attrs.virtualRouter;
                this.routeArn = cdk.Stack.of(this).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.virtualRouter.mesh.meshName}/virtualRouter/${attrs.virtualRouter.virtualRouterName}/route`,
                    resourceName: this.routeName,
                });
            }
        }(scope, id);
    }
}
exports.Route = Route;
_a = JSII_RTTI_SYMBOL_1;
Route[_a] = { fqn: "@aws-cdk/aws-appmesh.Route", version: "1.186.0" };
//# sourceMappingURL=data:application/json;base64,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