# pretix Matrix inviter

This is a plugin for [pretix](https://github.com/pretix/pretix).

Invite pretix participants to a Matrix Room or Space.

## Installation

Activate the virtual environment for your pretix installation and run

    pip install pretix-matrix-inviter

## Configuration

Each event can enable this plugin in Settings > Plugins > Features.

Once the plugin is enabled you can configure it in Settings > Matrix inviter.
You will need an access token of a user that can invite new users to your
Matrix room or space, the address of the server said inviting user is on, and
the ID or an alias of the Matrix room or space your participants should be
invited to.

## Development setup

1. Make sure that you have a working [pretix development
   setup](https://docs.pretix.eu/en/latest/development/setup.html).
2. Clone this repository.
3. Activate the virtual environment you use for pretix development.
4. Execute `python setup.py develop` within this directory to register
   this application with pretix's plugin registry.
5. Execute `make` within this directory to compile translations.
6. Restart your local pretix server. You can now use the plugin from
   this repository for your events by enabling it in the 'plugins' tab
   in the settings.

This plugin has CI set up to enforce a few code style rules. To check
locally, you need these packages installed:

    pip install flake8 isort black

To check your plugin for rule violations, run:

    black --check .
    isort -c .
    flake8 .

You can auto-fix some of these issues by running:

    isort .
    black .

To automatically check for these issues before you commit, you can run
`.install-hooks`.

## License

Copyright 2022-2023 Felix Schäfer

Released under the terms of the MIT License
