#######################################################
#
# Emergency.py
# Python implementation of the Class Emergency
# Generated by Enterprise Architect
# Created on:      13-Apr-2020 4:40:22 PM
# Original author: Corvo
#
#######################################################
from .model_constants import EmergencyVariables as vars
from FreeTAKServer.components.core.abstract_component.cot_node import CoTNode
from FreeTAKServer.components.core.abstract_component.cot_property import CoTProperty


class emergency(CoTNode):
    """An Emergency beacon the is continually send to all the connected clients until
    deactivated from the original creator
    """

    def __init__(self, configuration, model):
        super().__init__(self.__class__.__name__, configuration, model)
        self.cot_attributes["type"] = None
        self.cot_attributes["alert"] = None
        # if true the Emergency beacon is canceled
        self.cot_attributes["cancel"] = None
        self.cot_attributes["INTAG"] = None

    @CoTProperty
    def type(self):
        return self.cot_attributes.get("type", None)

    @type.setter
    def type(self, type=None):
        self.cot_attributes["type"] = type

    @CoTProperty
    def Alert(self):
        return self.cot_attributes.get("alert", None)

    @Alert.setter
    def Alert(self, alert=None):
        self.cot_attributes["alert"] = alert

    @CoTProperty
    def cancel(self):
        return self.cot_attributes.get("cancel", None)

    @cancel.setter
    def cancel(self, cancel=None):
        self.cot_attributes["cancel"] = cancel

    @CoTProperty
    def INTAG(self):
        return self.cot_attributes.get("INTAG", None)

    @INTAG.setter
    def INTAG(self, INTAG=None):
        self.cot_attributes["INTAG"] = INTAG
