from .WBits import WBits
from .event import Event

def _format_str_type(x):
    if isinstance(x, str):
       x = str(x).replace('"', '\\"')
       x = "\"" + x + "\""
    return x

class Driver(WBits):
    def __init__(self, index = 1):
        WBits.__init__(self)
        self.index = index

    def set_onboard_rgb(self, rgb):
        command = 'driver{}.set_onboard_rgb({})'.format(self.index, rgb)
        self._set_command(command)

    
    def set_motor_a(self, speed, time = None, block = None):
        """
        设置电机A转动

        :param speed: 转速：-100~100  符号表示转动方向，绝对值为转动速度
        :param time: 变速时间，从当前转速转变到设置转速用到的时间，单位 s  默认值为0.01
        :param block: 阻塞参数：  False：不阻塞 True：阻塞
        """

        
        args = []
        args.append(str(speed))
        if time != None:
            args.append(str(time))
        if block != None:
            args.append(str(block))
        command = 'driver{}.set_motor_a({})'.format(self.index, ",".join(args))
        self._set_command(command)

    
    def stop_motor_a(self):
        """
        电机A停止转动

        """

        command = 'driver{}.stop_motor_a()'.format(self.index)
        self._set_command(command)

    
    def set_motor_b(self, speed, time = None, block = None):
        """
        设置电机B转动

        :param speed: 转速：-100~100  符号表示转动方向，绝对值为转动速度
        :param time: 变速时间，从当前转速转变到设置转速用到的时间，单位 s  默认值为0.01
        :param block: 阻塞参数：  False: 不阻塞 True: 阻塞
        """

        
        args = []
        args.append(str(speed))
        if time != None:
            args.append(str(time))
        if block != None:
            args.append(str(block))
        command = 'driver{}.set_motor_b({})'.format(self.index, ",".join(args))
        self._set_command(command)

    
    def stop_motor_b(self):
        """
        电机B停止转动

        """

        command = 'driver{}.stop_motor_b()'.format(self.index)
        self._set_command(command)

    
    def set_servo1(self, angle):
        """
        设置舵机1转动到指定角度使用此函数后舵机1将拥有维持角度的扭矩，施加外力改变舵机1的角度会很困难

        :param angle: 角度：0~180
        """

        
        args = []
        args.append(str(angle))
        command = 'driver{}.set_servo1({})'.format(self.index, ",".join(args))
        self._set_command(command)

    
    def stop_servo1(self):
        """
        使用此函数后舵机1将失去维持角度的扭矩，施加外力可以轻松改变舵机1的角度

        """

        command = 'driver{}.stop_servo1()'.format(self.index)
        self._set_command(command)

    
    def set_servo2(self, angle):
        """
        设置舵机2转动到指定角度使用此函数后舵机2将拥有维持角度的扭矩，施加外力改变舵机2的角度会很困难

        :param angle: 角度：0~180
        """

        
        args = []
        args.append(str(angle))
        command = 'driver{}.set_servo2({})'.format(self.index, ",".join(args))
        self._set_command(command)

    
    def stop_servo2(self):
        """
        使用此函数后舵机2将失去维持角度的扭矩，施加外力可以轻松改变舵机2的角度

        """

        command = 'driver{}.stop_servo2()'.format(self.index)
        self._set_command(command)

    

    

    