# service-allocation

**service-allocation** is a simple utility that generates a CSV file containing
the services (LXD, Bare-metal) allocation from an Charmed OpenStack Cloud.

## Installation

    $ pip install service-allocation

<!-- Comming Soon
    $ sudo snap install service-allocation --classic

-->
## Usage

    $ juju status --format yaml > status.yaml
    $ service-allocation ./status.yaml > allocation.csv

Import the resulting csv file into a spreadsheet


## Imported spreadsheet sample

After importing the csv file into a spreadsheet you'll get a table like the following:

| Host            | Baremetal                   | Container                                                                                                                                                                                                                                                                               |
| --              | ---                         | ---                                                                                                                                                                                                                                                                                     |
| nagios-1        | nagios/0                    |                                                                                                                                                                                                                                                                                         |
| grafana-1       | grafana/0                   |                                                                                                                                                                                                                                                                                         |
| landscapeha-1   | landscape-haproxy/0         |                                                                                                                                                                                                                                                                                         |
| landscapesql-1  | landscape-postgresql/0      |                                                                                                                                                                                                                                                                                         |
| landscapeamqp-1 | landscape-rabbitmq-server/0 |                                                                                                                                                                                                                                                                                         |
| elastic-2       | elasticsearch/0             |                                                                                                                                                                                                                                                                                         |
| landscape-3     | landscape-server/0          |                                                                                                                                                                                                                                                                                         |
| landscapeamqp-3 | landscape-rabbitmq-server/1 |                                                                                                                                                                                                                                                                                         |
| landscapesql-2  | landscape-postgresql/1      |                                                                                                                                                                                                                                                                                         |
| prometheus-3    | prometheus/0                |                                                                                                                                                                                                                                                                                         |
| graylog-2       | graylog/0                   | graylog-mongodb/0                                                                                                                                                                                                                                                                       |
| landscape-1     | landscape-server/1          |                                                                                                                                                                                                                                                                                         |
| landscapeamqp-2 | landscape-rabbitmq-server/2 |                                                                                                                                                                                                                                                                                         |
| elastic-3       | elasticsearch/1             |                                                                                                                                                                                                                                                                                         |
| landscape-2     | landscape-server/2          |                                                                                                                                                                                                                                                                                         |
| elastic-1       | elasticsearch/2             |                                                                                                                                                                                                                                                                                         |
| graylog-1       | graylog/1                   | graylog-mongodb/1                                                                                                                                                                                                                                                                       |
| graylog-3       | graylog/2                   | graylog-mongodb/2                                                                                                                                                                                                                                                                       |
| controller1     | ubuntu-controllers-stub/0   | aodh/0 ceilometer/0 ceph-mon/0 cinder/0 designate/0 memcached/0 glance/0 gnocchi/0 heat/0 keystone/0 mysql/0 neutron-api/0 nova-cloud-controller/0 openstack-dashboard/0 rabbitmq-server/0 ceph-radosgw/3                                                              |
| controller2     | ubuntu-controllers-stub/1   | aodh/1 ceilometer/1 ceph-mon/1 ceph-radosgw/1 cinder/1 designate/1 memcached/1 glance/1 gnocchi/1 heat/1 keystone/1 mysql/1 neutron-api/1 nova-cloud-controller/1 openstack-dashboard/1 prometheus-ceph-exporter/0 prometheus-openstack-exporter/0 rabbitmq-server/1 |
| controller3     | ubuntu-controllers-stub/2   | aodh/2 ceilometer/2 ceph-mon/2 ceph-radosgw/2 cinder/2 designate/2 glance/2 gnocchi/2 heat/2 keystone/2 mysql/2 neutron-api/2 nova-cloud-controller/2 openstack-dashboard/2 openstack-service-checks/0 rabbitmq-server/2                                               |
| compute1        | nova-compute-kvm/0          |                                                                                                                                                                                                                                                                                         |
| compute2        | nova-compute-kvm/1          |                                                                                                                                                                                                                                                                                         |
| compute3        | nova-compute-kvm/2          |                                                                                                                                                                                                                                                                                         |
| compute4        | nova-compute-kvm/3          |                                                                                                                                                                                                                                                                                         |
| compute5        | nova-compute-kvm/4          |                                                                                                                                                                                                                                                                                         |
| compute6        | nova-compute-kvm/5          |                                                                                                                                                                                                                                                                                         |
| compute7        | nova-compute-kvm/6          |                                                                                                                                                                                                                                                                                         |
| compute8        | nova-compute-kvm/7          |                                                                                                                                                                                                                                                                                         |
| compute9        | nova-compute-kvm/8          |                                                                                                                                                                                                                                                                                         |
| compute10       | nova-compute-kvm/9          |                                                                                                                                                                                                                                                                                         |
| compute11       | nova-compute-kvm/10         |                                                                                                                                                                                                                                                                                         |
| compute12       | nova-compute-kvm/11         |                                                                                                                                                                                                                                                                                         |
| storage1        | ceph-osd/0                  |                                                                                                                                                                                                                                                                                         |
| storage2        | ceph-osd/1                  |                                                                                                                                                                                                                                                                                         |
| storage3        | ceph-osd/2                  |                                                                                                                                                                                                                                                                                         |
