# gcandle 轻量极速的本地量化交易框架

目前针对A股。

## 可以做什么
使用本框架可以轻松开发出你自己的量化模型。设计良好的API可以让你专注于交易模型的开发，最大限度减小无关的工作量。请看示例项目。
本框架包含数据下载，指标开发，策略回测分析的完整功能。实盘交易暂不包含，本地实盘可以参考easytrader等方案，但量化交易的核心，应该是策略模型。
有了模型，还怕没办法交易么？至于在线方案，我本人是不放心策略安全的。
用本框架开发的模型，可以把选出的股票用其他任何实盘方案实现交易，同时模型却是绝对安全的，因为你对交易软件的输入只会是你模型的结果。

## 轻量
代码优雅紧凑，可以轻松看完全部代码，也可轻易扩展功能。

## 极速
速度为什么重要，因为策略需要不停的调试。
首先数据在本地。在线方案要做一个复杂的策略模型，对全市场进行扫描计算，几乎是不可能完成的任务，时间太长。
本框架封装了多进程的指标计算，根据主要指标对全市场数据过滤后，保存基本的股票池和策略关心的指标。
这个基本股票池及预计算的指标很重要，因为这之后你应该进入一个调试指标组合及参数优化的循环中，有了这个基础，几年的全市场扫描回测只需要几十秒。你调试策略的速度会大大提高。
当然前提是你的电脑不能太差，对单核cpu就没什么用了。
顺便说下硬件配置推荐：

cpu 8核8线程。对计算密集的应用，主要看核心数，多一倍的线程数没用。
内存至少16G，推荐32G，有钱可以64G。
硬盘：如果要做分钟级的策略，至少准备1T的吧，日线级有个500G应该够了。并不是k线数据本身有这么大，而是考虑你的整个系统占用。我现在是1T SSD+3T机械硬盘。
mongodb的存储管理没精通，但目前掌握的是，如果创建了一个很大的集合，drop它之后存储空间仍然没释放，要想减小存储空间占用，就要做一次database repair，repair过程会临时占用大量磁盘空间，所以当mongodb占了你的一半磁盘，你想缩减空间的时候就很麻烦了。

## 为什么做这个框架
因为找不到满足我需求的框架，即上述两个条件都满足的。

## 开始使用
OS: Linux. Windows还没测试，应该是可以，但是有可能你需要自行解决一些小问题。

Python： 3.6.8以上。推荐使用anaconda创建虚拟python环境。请参考 [官方网站](https://www.anaconda.com/products/individual)

Mongodb：4.0.20以上。推荐一个客户端程序 [Robo 3T](https://robomongo.org/)

以上都装好了，你可以有两种方法使用gcandle。
1. 用pip安装。这种方式会把gcandle的包安装到python环境的site-packages目录下。

$ pip install gcandle

2. 直接clone本仓库代码，然后在代码根目录运行

$ ./install-dev.sh 

这个命令会用开发方式安装本项目，意思是并不会真正把代码打包放到site-packages下，而是创建一个链接，指向本项目的代码根目录。
好处是，你可以随时修改本项目的代码，在客户端项目中，修改实时生效。

以上都搞定，clone这个 [示例](https://github.com/yangchanghua/gcandle_client) 项目，然后尝试跑通，基本就明白怎么用了。
