# EPIK8s Chart for {{ beamline }}

This documentation is automatically generated by *epik8s-tools* ({{version}}).

## Table of Contents
- [Beamline](#beamline)
{% if nfsMounts %}
- [NFS Mounts](#nfs-mounts)
{%- endif %}
- [IO Controllers (IOCS)](#iocs)
- [EPIK8s Services](#services)
- [Application](#applications)



## Beamline

**BEAMLINE**: `{{ beamline }}`

**BEAMLINE URL**: `{{ giturl }}`

**BEAMLINE REV**: `{{ gitrev }}`

**Services DNS**: `{{ epik8namespace }}`

**Namespace**: `{{ namespace }}`

**EPIK8s charts default revision**: `{{targetRevision}}`

**CA Gateway**: `{{cagatewayip}}`

**PVA Gateway**: `{{pvagatewayip}}`



{% if nfsMounts %}
---

## NFS Mounts

| Name               | Server                 | Src                                      | Dst                    |
|--------------------|------------------------|------------------------------------------|------------------------|
{%- for nfs in nfsMounts %}
| {{ nfs.name.ljust(18)}} | {{ nfs.server.ljust(22) }} | {{ nfs.path.ljust(40)}} | {{ nfs.mountPath.ljust(22) }} |
{%- endfor%}

---

{% endif %}


## IOCs

| Name             | Type       | Group      | Prefix                   |Template      |Description                                         |
|------------------|------------|------------|--------------------------|--------------|---------------------------------------------------|
{%- for ioc in iocs %}
{%- set opiurl = "-" %}
{%- set opimain = "-" %}
{%- set ctx_macro = "-" %}
{%- set template = "-" %}

{%- if ioc.opi %}
{%- set opiurl = ioc.opinfo.url %}
{%- set opimain = ioc.opinfo.main %}
{%- set ctx_macro = ioc.opinfo.macroinfo %}
{%- endif %}
{%- if ioc.template %}
{%- set template = ioc.template %}
{%- elif ioc.iocdir %}
{%- set template = ioc.iocdir %}
{%- endif %}

{%- set name=ioc.name.ljust(16) %}
|  [{{name}}](#{{ioc.name | lower}}) | {{ (ioc.devtype | default("uknown")).ljust(10) }} | {{ (ioc.devgroup | default("uknown")).ljust(10)}} | {{ (ioc.iocprefix ~":"~ ioc.iocroot).ljust(24) }} | {{ template.ljust(12)}} | {{ (ioc.asset | string).ljust(50)}} |
{%- endfor %}
---

---
{%- for ioc in iocs %}
### {{ioc.name}}

{%- if ioc.iocparam %}

#### IOC Params

| Name             | Value                            |
|------------------|----------------------------------|

{%- for p in ioc.iocparam %}
| {{ (p.name|string).ljust(16)}} | {{ (p.value| string).ljust(32) }} |
{%- endfor %}

---
{%- endif %}

{%- if ioc.iocinit %}
#### Common initializations

| Name             | Value                             | 
|------------------|-----------------------------------|
{%- for p in ioc.iocinit %}
| {{ (p.name|string).ljust(16)}} | {{ (p.value| string).ljust(32) }} |
{%- endfor %}
{%- endif %}

{%- if ioc.devices %}
#### Devices

| Name             | Type         | PV device prefix                 | Description                                         |
|------------------|--------------|----------------------------------|----------------------------------------------------|

{%- for dev in ioc.devices %}
{%- set devtype = ioc.devtype %}
{%- set asset = ioc.asset %}

{%- if dev.devtype %}
{%- set devtype = dev.devtype %}
{%- endif %}
{%- if dev.asset %}
{%- set asset = dev.asset %}
{%- endif %}
| {{ (dev.name|string).ljust(16)}} | {{ (devtype | string).ljust(12) }} | {{ (ioc.iocprefix ~":"~ dev.name).ljust(32) }} | {{ (asset | string).ljust(50)}} |
{%- endfor %}
{%- endif %}

{%- for dev in ioc.devices %}
{%- if dev.iocinit %}

#### ***{{dev.name}}*** initializations


| Name                              | Value                             |
|-----------------------------------|-----------------------------------|
{%- for p in dev.iocinit %}
| {{ (p.name|string).ljust(33)}} | {{ (p.value|string).ljust(33)}}|
{%- endfor %}
{%- endif %}
{%- endfor %}

---
{%- endfor %}

---

---

## Services
| Name             | URL                            | Balancer      | Chart                          |Description                                         |
|------------------|--------------------------------|---------------|--------------------------------|----------------------------------------------------|
{%- for service, details in services.items() %}
{%- set loadb = "-" %}
{%- set ingress = "-" %}
{%- if details.loadbalancer %}
{%- set loadb = details.loadbalancer %}
{%- endif %}
{%- if details.enable_ingress %}
{%- set ingress = "http://"~beamline~"-"~service~"."~epik8namespace %}
{%- endif %}
| {{ service.ljust(16)}} | {{ ingress.ljust(30) }} | {{ loadb.ljust(10)}} | {{ details.charturl.ljust(30) }} | {{ (details.asset | string).ljust(50)}} |
{%- endfor %}

---
{%- if applications %}
## Applications
| Name             | App Repo                       | Image                          |Description                                         |
|------------------|--------------------------------|--------------------------------|----------------------------------------------------|
{%- for app in applications %}
  {%- set repoapp = "-" %}
  {%- if app.gitRepoApp %}
    {%- set repoapp = app.gitRepoApp.url %}
  {%- endif %}
  | {{ app.name.ljust(16)}} | {{ repoapp.ljust(30) }} | {{ app.image.repository.ljust(30)}} | {{ (app.asset | string).ljust(50)}} |
{%- endfor %}
{%- endif %}
## Phoebus Settings
You can find phoebus settings for epik8s `{{ beamline }}` in **opi/settings.ini**


