"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrModifyInstanceGroupByName = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
const cluster_utils_1 = require("./private/cluster-utils");
/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 */
class EmrModifyInstanceGroupByName extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByNameProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EmrModifyInstanceGroupByName);
            }
            throw error;
        }
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: [
                    'elasticmapreduce:ModifyInstanceGroups',
                    'elasticmapreduce:ListInstanceGroups',
                ],
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'elasticmapreduce',
                        resource: 'cluster',
                        resourceName: '*',
                    }),
                ],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('elasticmapreduce', 'modifyInstanceGroupByName', sfn.IntegrationPattern.REQUEST_RESPONSE),
            Parameters: sfn.FieldUtils.renderObject({
                ClusterId: this.props.clusterId,
                InstanceGroupName: this.props.instanceGroupName,
                InstanceGroup: cluster_utils_1.InstanceGroupModifyConfigPropertyToJson(this.props.instanceGroup),
            }),
        };
    }
}
exports.EmrModifyInstanceGroupByName = EmrModifyInstanceGroupByName;
_a = JSII_RTTI_SYMBOL_1;
EmrModifyInstanceGroupByName[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EmrModifyInstanceGroupByName", version: "1.183.0" };
//# sourceMappingURL=data:application/json;base64,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