"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpMethods = exports.EksCall = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sfn = require("@aws-cdk/aws-stepfunctions");
const task_utils_1 = require("../private/task-utils");
/**
 * Call a EKS endpoint as a Task
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-eks.html
 */
class EksCall extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EksCallProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EksCall);
            }
            throw error;
        }
        this.integrationPattern = props.integrationPattern ?? sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EksCall.SUPPORTED_INTEGRATION_PATTERNS);
        try {
            this.clusterEndpoint = this.props.cluster.clusterEndpoint;
        }
        catch (e) {
            throw new Error('The "clusterEndpoint" property must be specified when using an imported Cluster.');
        }
        try {
            this.clusterCertificateAuthorityData = this.props.cluster.clusterCertificateAuthorityData;
        }
        catch (e) {
            throw new Error('The "clusterCertificateAuthorityData" property must be specified when using an imported Cluster.');
        }
    }
    /**
     * Provides the EKS Call service integration task configuration
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('eks', 'call', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                ClusterName: this.props.cluster.clusterName,
                CertificateAuthority: this.clusterCertificateAuthorityData,
                Endpoint: this.clusterEndpoint,
                Method: this.props.httpMethod,
                Path: this.props.httpPath,
                QueryParameters: this.props.queryParameters,
                RequestBody: this.props.requestBody?.value,
            }),
        };
    }
}
exports.EksCall = EksCall;
_a = JSII_RTTI_SYMBOL_1;
EksCall[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EksCall", version: "1.183.0" };
EksCall.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
];
/**
 * Method type of a EKS call
 */
var HttpMethods;
(function (HttpMethods) {
    /**
     * Retrieve data from a server at the specified resource
     */
    HttpMethods["GET"] = "GET";
    /**
     * Send data to the API endpoint to create or update a resource
     */
    HttpMethods["POST"] = "POST";
    /**
     * Send data to the API endpoint to update or create a resource
     */
    HttpMethods["PUT"] = "PUT";
    /**
     * Delete the resource at the specified endpoint
     */
    HttpMethods["DELETE"] = "DELETE";
    /**
     * Apply partial modifications to the resource
     */
    HttpMethods["PATCH"] = "PATCH";
    /**
     * Retrieve data from a server at the specified resource without the response body
     */
    HttpMethods["HEAD"] = "HEAD";
})(HttpMethods = exports.HttpMethods || (exports.HttpMethods = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FsbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNhbGwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBRUEsa0RBQWtEO0FBRWxELHNEQUF5RjtBQW9DekY7Ozs7R0FJRztBQUNILE1BQWEsT0FBUSxTQUFRLEdBQUcsQ0FBQyxhQUFhO0lBaUI1QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFtQixLQUFtQjtRQUM1RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQURpQyxVQUFLLEdBQUwsS0FBSyxDQUFjOzs7Ozs7K0NBakJuRSxPQUFPOzs7O1FBbUJoQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQztRQUU5RixxQ0FBd0IsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLEVBQUUsT0FBTyxDQUFDLDhCQUE4QixDQUFDLENBQUM7UUFFMUYsSUFBSTtZQUNGLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDO1NBQzNEO1FBQUMsT0FBTyxDQUFDLEVBQUU7WUFDVixNQUFNLElBQUksS0FBSyxDQUFDLGtGQUFrRixDQUFDLENBQUM7U0FDckc7UUFFRCxJQUFJO1lBQ0YsSUFBSSxDQUFDLCtCQUErQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLCtCQUErQixDQUFDO1NBQzNGO1FBQUMsT0FBTyxDQUFDLEVBQUU7WUFDVixNQUFNLElBQUksS0FBSyxDQUFDLGtHQUFrRyxDQUFDLENBQUM7U0FDckg7S0FDRjtJQUVEOzs7T0FHRztJQUNPLFdBQVc7UUFDbkIsT0FBTztZQUNMLFFBQVEsRUFBRSxtQ0FBc0IsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztZQUN4RSxVQUFVLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7Z0JBQ3RDLFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxXQUFXO2dCQUMzQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsK0JBQStCO2dCQUMxRCxRQUFRLEVBQUUsSUFBSSxDQUFDLGVBQWU7Z0JBQzlCLE1BQU0sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVU7Z0JBQzdCLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7Z0JBQ3pCLGVBQWUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWU7Z0JBQzNDLFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsRUFBRSxLQUFLO2FBQzNDLENBQUM7U0FDSCxDQUFDO0tBQ0g7O0FBckRILDBCQXNEQzs7O0FBcER5QixzQ0FBOEIsR0FBNkI7SUFDakYsR0FBRyxDQUFDLGtCQUFrQixDQUFDLGdCQUFnQjtDQUN4QyxDQUFDO0FBb0RKOztHQUVHO0FBQ0gsSUFBWSxXQThCWDtBQTlCRCxXQUFZLFdBQVc7SUFDckI7O09BRUc7SUFDSCwwQkFBVyxDQUFBO0lBRVg7O09BRUc7SUFDSCw0QkFBYSxDQUFBO0lBRWI7O09BRUc7SUFDSCwwQkFBVyxDQUFBO0lBRVg7O09BRUc7SUFDSCxnQ0FBaUIsQ0FBQTtJQUVqQjs7T0FFRztJQUNILDhCQUFlLENBQUE7SUFFZjs7T0FFRztJQUNILDRCQUFhLENBQUE7QUFDZixDQUFDLEVBOUJXLFdBQVcsR0FBWCxtQkFBVyxLQUFYLG1CQUFXLFFBOEJ0QiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVrcyBmcm9tICdAYXdzLWNkay9hd3MtZWtzJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCAqIGFzIHNmbiBmcm9tICdAYXdzLWNkay9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IGludGVncmF0aW9uUmVzb3VyY2VBcm4sIHZhbGlkYXRlUGF0dGVyblN1cHBvcnRlZCB9IGZyb20gJy4uL3ByaXZhdGUvdGFzay11dGlscyc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgY2FsbGluZyBhIEVLUyBlbmRwb2ludCB3aXRoIEVrc0NhbGxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFa3NDYWxsUHJvcHMgZXh0ZW5kcyBzZm4uVGFza1N0YXRlQmFzZVByb3BzIHtcblxuICAvKipcbiAgICogVGhlIEVLUyBjbHVzdGVyXG4gICAqL1xuICByZWFkb25seSBjbHVzdGVyOiBla3MuSUNsdXN0ZXI7XG5cbiAgLyoqXG4gICAqIEhUVFAgbWV0aG9kIChcIkdFVFwiLCBcIlBPU1RcIiwgXCJQVVRcIiwgLi4uKSBwYXJ0IG9mIEhUVFAgcmVxdWVzdFxuICAgKi9cbiAgcmVhZG9ubHkgaHR0cE1ldGhvZDogSHR0cE1ldGhvZHM7XG5cbiAgLyoqXG4gICAqIEhUVFAgcGF0aCBvZiB0aGUgS3ViZXJuZXRlcyBSRVNUIEFQSSBvcGVyYXRpb25cbiAgICogRm9yIGV4YW1wbGU6IC9hcGkvdjEvbmFtZXNwYWNlcy9kZWZhdWx0L3BvZHNcbiAgICovXG4gIHJlYWRvbmx5IGh0dHBQYXRoOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFF1ZXJ5IFBhcmFtZXRlcnMgcGFydCBvZiBIVFRQIHJlcXVlc3RcbiAgICogQGRlZmF1bHQgLSBubyBxdWVyeSBwYXJhbWV0ZXJzXG4gICAqL1xuICByZWFkb25seSBxdWVyeVBhcmFtZXRlcnM/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZ1tdIH07XG5cbiAgLyoqXG4gICAqIFJlcXVlc3QgYm9keSBwYXJ0IG9mIEhUVFAgcmVxdWVzdFxuICAgKiBAZGVmYXVsdCAtIE5vIHJlcXVlc3QgYm9keVxuICAgKi9cbiAgcmVhZG9ubHkgcmVxdWVzdEJvZHk/OiBzZm4uVGFza0lucHV0O1xufVxuXG4vKipcbiAqIENhbGwgYSBFS1MgZW5kcG9pbnQgYXMgYSBUYXNrXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc3RlcC1mdW5jdGlvbnMvbGF0ZXN0L2RnL2Nvbm5lY3QtZWtzLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIEVrc0NhbGwgZXh0ZW5kcyBzZm4uVGFza1N0YXRlQmFzZSB7XG5cbiAgcHJpdmF0ZSBzdGF0aWMgcmVhZG9ubHkgU1VQUE9SVEVEX0lOVEVHUkFUSU9OX1BBVFRFUk5TOiBzZm4uSW50ZWdyYXRpb25QYXR0ZXJuW10gPSBbXG4gICAgc2ZuLkludGVncmF0aW9uUGF0dGVybi5SRVFVRVNUX1JFU1BPTlNFLFxuICBdO1xuXG4gIC8qKiBObyBwb2xpY2llcyBhcmUgcmVxdWlyZWQgZHVlIHRvIGVrczpjYWxsIGlzIGFuIEh0dHAgc2VydmljZSBpbnRlZ3JhdGlvbiBhbmQgZG9lcyBub3QgY2FsbCBhbmQgRUtTIEFQSSBkaXJlY3RseVxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zdGVwLWZ1bmN0aW9ucy9sYXRlc3QvZGcvY29ubmVjdC1la3MuaHRtbCNjb25uZWN0LWVrcy1wZXJtaXNzaW9uc1xuICAgKi9cbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHRhc2tNZXRyaWNzPzogc2ZuLlRhc2tNZXRyaWNzQ29uZmlnO1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgdGFza1BvbGljaWVzPzogaWFtLlBvbGljeVN0YXRlbWVudFtdO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgaW50ZWdyYXRpb25QYXR0ZXJuOiBzZm4uSW50ZWdyYXRpb25QYXR0ZXJuO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgY2x1c3RlckVuZHBvaW50OiBzdHJpbmc7XG4gIHByaXZhdGUgcmVhZG9ubHkgY2x1c3RlckNlcnRpZmljYXRlQXV0aG9yaXR5RGF0YTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IEVrc0NhbGxQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuICAgIHRoaXMuaW50ZWdyYXRpb25QYXR0ZXJuID0gcHJvcHMuaW50ZWdyYXRpb25QYXR0ZXJuID8/IHNmbi5JbnRlZ3JhdGlvblBhdHRlcm4uUkVRVUVTVF9SRVNQT05TRTtcblxuICAgIHZhbGlkYXRlUGF0dGVyblN1cHBvcnRlZCh0aGlzLmludGVncmF0aW9uUGF0dGVybiwgRWtzQ2FsbC5TVVBQT1JURURfSU5URUdSQVRJT05fUEFUVEVSTlMpO1xuXG4gICAgdHJ5IHtcbiAgICAgIHRoaXMuY2x1c3RlckVuZHBvaW50ID0gdGhpcy5wcm9wcy5jbHVzdGVyLmNsdXN0ZXJFbmRwb2ludDtcbiAgICB9IGNhdGNoIChlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1RoZSBcImNsdXN0ZXJFbmRwb2ludFwiIHByb3BlcnR5IG11c3QgYmUgc3BlY2lmaWVkIHdoZW4gdXNpbmcgYW4gaW1wb3J0ZWQgQ2x1c3Rlci4nKTtcbiAgICB9XG5cbiAgICB0cnkge1xuICAgICAgdGhpcy5jbHVzdGVyQ2VydGlmaWNhdGVBdXRob3JpdHlEYXRhID0gdGhpcy5wcm9wcy5jbHVzdGVyLmNsdXN0ZXJDZXJ0aWZpY2F0ZUF1dGhvcml0eURhdGE7XG4gICAgfSBjYXRjaCAoZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdUaGUgXCJjbHVzdGVyQ2VydGlmaWNhdGVBdXRob3JpdHlEYXRhXCIgcHJvcGVydHkgbXVzdCBiZSBzcGVjaWZpZWQgd2hlbiB1c2luZyBhbiBpbXBvcnRlZCBDbHVzdGVyLicpO1xuICAgIH1cbiAgfVxuXG4gIC8qKlxuICAgKiBQcm92aWRlcyB0aGUgRUtTIENhbGwgc2VydmljZSBpbnRlZ3JhdGlvbiB0YXNrIGNvbmZpZ3VyYXRpb25cbiAgICogQGludGVybmFsXG4gICAqL1xuICBwcm90ZWN0ZWQgX3JlbmRlclRhc2soKTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgUmVzb3VyY2U6IGludGVncmF0aW9uUmVzb3VyY2VBcm4oJ2VrcycsICdjYWxsJywgdGhpcy5pbnRlZ3JhdGlvblBhdHRlcm4pLFxuICAgICAgUGFyYW1ldGVyczogc2ZuLkZpZWxkVXRpbHMucmVuZGVyT2JqZWN0KHtcbiAgICAgICAgQ2x1c3Rlck5hbWU6IHRoaXMucHJvcHMuY2x1c3Rlci5jbHVzdGVyTmFtZSxcbiAgICAgICAgQ2VydGlmaWNhdGVBdXRob3JpdHk6IHRoaXMuY2x1c3RlckNlcnRpZmljYXRlQXV0aG9yaXR5RGF0YSxcbiAgICAgICAgRW5kcG9pbnQ6IHRoaXMuY2x1c3RlckVuZHBvaW50LFxuICAgICAgICBNZXRob2Q6IHRoaXMucHJvcHMuaHR0cE1ldGhvZCxcbiAgICAgICAgUGF0aDogdGhpcy5wcm9wcy5odHRwUGF0aCxcbiAgICAgICAgUXVlcnlQYXJhbWV0ZXJzOiB0aGlzLnByb3BzLnF1ZXJ5UGFyYW1ldGVycyxcbiAgICAgICAgUmVxdWVzdEJvZHk6IHRoaXMucHJvcHMucmVxdWVzdEJvZHk/LnZhbHVlLFxuICAgICAgfSksXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIE1ldGhvZCB0eXBlIG9mIGEgRUtTIGNhbGxcbiAqL1xuZXhwb3J0IGVudW0gSHR0cE1ldGhvZHMge1xuICAvKipcbiAgICogUmV0cmlldmUgZGF0YSBmcm9tIGEgc2VydmVyIGF0IHRoZSBzcGVjaWZpZWQgcmVzb3VyY2VcbiAgICovXG4gIEdFVCA9ICdHRVQnLFxuXG4gIC8qKlxuICAgKiBTZW5kIGRhdGEgdG8gdGhlIEFQSSBlbmRwb2ludCB0byBjcmVhdGUgb3IgdXBkYXRlIGEgcmVzb3VyY2VcbiAgICovXG4gIFBPU1QgPSAnUE9TVCcsXG5cbiAgLyoqXG4gICAqIFNlbmQgZGF0YSB0byB0aGUgQVBJIGVuZHBvaW50IHRvIHVwZGF0ZSBvciBjcmVhdGUgYSByZXNvdXJjZVxuICAgKi9cbiAgUFVUID0gJ1BVVCcsXG5cbiAgLyoqXG4gICAqIERlbGV0ZSB0aGUgcmVzb3VyY2UgYXQgdGhlIHNwZWNpZmllZCBlbmRwb2ludFxuICAgKi9cbiAgREVMRVRFID0gJ0RFTEVURScsXG5cbiAgLyoqXG4gICAqIEFwcGx5IHBhcnRpYWwgbW9kaWZpY2F0aW9ucyB0byB0aGUgcmVzb3VyY2VcbiAgICovXG4gIFBBVENIID0gJ1BBVENIJyxcblxuICAvKipcbiAgICogUmV0cmlldmUgZGF0YSBmcm9tIGEgc2VydmVyIGF0IHRoZSBzcGVjaWZpZWQgcmVzb3VyY2Ugd2l0aG91dCB0aGUgcmVzcG9uc2UgYm9keVxuICAgKi9cbiAgSEVBRCA9ICdIRUFEJ1xufSJdfQ==