import pytest


@pytest.mark.parametrize(
    "string,lemma",
    [
        ("trčao", "trčati"),
        ("adekvatnim", "adekvatan"),
        ("dekontaminacijama", "dekontaminacija"),
        ("filologovih", "filologov"),
        ("je", "biti"),
        ("se", "sebe"),
    ],
)
def test_hr_lemmatizer_lookup_assigns(hr_nlp, string, lemma):
    tokens = hr_nlp(string)
    assert tokens[0].lemma_ == lemma
