# This is an auto-generated Django model module.
# You'll have to do the following manually to clean this up:
#   * Rearrange models' order
#   * Make sure each model has one field with primary_key=True
#   * Make sure each ForeignKey and OneToOneField has `on_delete` set to the desired behavior
#   * Remove `managed = False` lines if you wish to allow Django to create, modify, and delete the table
# Feel free to rename the models, but don't rename db_table values or field names.
import string
from oasis.lib import managers
from oasis.lib.choices import CustomerType
from zibanu.django.db import models


class Account(models.Model):
    # Set default db
    use_db = "oasis"
    # Set default manager

    # Fields
    companyid = models.IntegerField(primary_key=True)
    plan = models.IntegerField()
    accountid = models.BigIntegerField()
    accountname = models.CharField(max_length=100, blank=True, null=True)
    level = models.IntegerField(blank=True, null=True)
    parent = models.BigIntegerField(blank=True, null=True)
    nature = models.CharField(max_length=1, blank=True, null=True)
    impute = models.BooleanField(blank=True, null=True)
    client = models.BooleanField(blank=True, null=True)
    costcenter = models.BooleanField(blank=True, null=True)
    business = models.BooleanField(blank=True, null=True)
    project = models.BooleanField(blank=True, null=True)
    type = models.CharField(max_length=1, blank=True, null=True)
    retention = models.BooleanField(blank=True, null=True)
    percentageretention = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    reference = models.BooleanField(blank=True, null=True)
    adjustment = models.BooleanField(blank=True, null=True)
    adjustmentaccount1 = models.BigIntegerField(blank=True, null=True)
    adjustmentaccount2 = models.BigIntegerField(blank=True, null=True)
    repetitive = models.BooleanField(blank=True, null=True)
    repetitiveaccount1 = models.BigIntegerField(blank=True, null=True)
    repetitiveaccount2 = models.BigIntegerField(blank=True, null=True)
    status = models.CharField(max_length=1, blank=True, null=True)
    utility = models.BooleanField(blank=True, null=True)
    module = models.CharField(max_length=1, blank=True, null=True)
    currency = models.CharField(max_length=1, blank=True, null=True)
    currencyid = models.IntegerField(blank=True, null=True)
    baseretention = models.BooleanField(blank=True, null=True)
    percentagebudget = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    oldcode = models.CharField(max_length=20, blank=True, null=True)
    budget = models.BooleanField(blank=True, null=True)
    budgetcontrol = models.BooleanField(blank=True, null=True)
    order = models.BigIntegerField(blank=True, null=True)
    alternatecode = models.CharField(max_length=20, blank=True, null=True)
    expenseobjectid = models.IntegerField(blank=True, null=True)
    entryid = models.IntegerField(blank=True, null=True)
    ordinary = models.CharField(max_length=1, blank=True, null=True)
    accountname1 = models.CharField(max_length=100, blank=True, null=True)
    abc = models.CharField(max_length=1, blank=True, null=True)
    bookid = models.IntegerField(blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    product = models.BooleanField(blank=True, null=True)
    codeid = models.CharField(max_length=3, blank=True, null=True)
    tax = models.CharField(max_length=1, blank=True, null=True)
    businessid = models.IntegerField(blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)
    taxtypeid = models.IntegerField(blank=True, null=True)
    quantitytype = models.CharField(max_length=1, blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'account'
        unique_together = (('companyid', 'plan', 'accountid'),)


class TypeClient(models.Model):
    # Set default db
    use_db = "oasis"
    # Set default manager
    objects = managers.OasisTypeClient()
    # Fields list
    companyid = models.IntegerField(primary_key=True)
    typeclientid = models.CharField(max_length=1)
    typeclientname = models.CharField(max_length=100, blank=True, null=True)
    taxentity = models.IntegerField(blank=True, null=True)
    typedocumentid = models.CharField(max_length=2, blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)
    typeclient = models.CharField(max_length=1, blank=True, null=True)
    typeexternal = models.CharField(max_length=10, blank=True, null=True)
    typeclient1 = models.CharField(max_length=1, blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'typeclient'
        unique_together = (('companyid', 'typeclientid'),)


class Classification(models.Model):
    # Set default database
    use_db = "oasis"
    # Set fields
    companyid = models.IntegerField(primary_key=True)
    classificationid = models.BigIntegerField()
    classificationname = models.CharField(max_length=100, blank=True, null=True)
    level = models.IntegerField(blank=True, null=True)
    parent = models.BigIntegerField(blank=True, null=True)
    taxtypeid = models.IntegerField(blank=True, null=True)
    groupid = models.IntegerField(blank=True, null=True)
    tax = models.BooleanField(blank=True, null=True)
    taxpercentage = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    taxcapitalized = models.BooleanField(blank=True, null=True)
    depreciation = models.CharField(max_length=2, blank=True, null=True)
    minimum = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    maximum = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    lifespan = models.IntegerField(blank=True, null=True)
    locationid = models.IntegerField(blank=True, null=True)
    rent = models.IntegerField(blank=True, null=True)
    businessid = models.IntegerField(blank=True, null=True)
    impute = models.BooleanField(blank=True, null=True)
    accountdevolution = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    budget = models.BooleanField(blank=True, null=True)
    budgetquantity = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    budgetvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    positiontariff = models.CharField(max_length=20, blank=True, null=True)
    bonus = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    bonus1 = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    bonus2 = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    prefix = models.CharField(max_length=1, blank=True, null=True)
    inventory = models.CharField(max_length=1, blank=True, null=True)
    blight = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    blightcost = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    adjustmentcostvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    manpower = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    indirect = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    changeprice = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    expenseobjectid = models.IntegerField(blank=True, null=True)
    costcenterid = models.IntegerField(blank=True, null=True)
    oldcode = models.CharField(max_length=20, blank=True, null=True)
    adjustmentcost = models.CharField(max_length=1, blank=True, null=True)
    guarantee = models.IntegerField(blank=True, null=True)
    guaranteevalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    grouporder = models.IntegerField(blank=True, null=True)
    typeasset = models.CharField(max_length=2, blank=True, null=True)
    costmethod = models.CharField(max_length=1, blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    finite = models.BooleanField(blank=True, null=True)
    depreciate = models.BooleanField(blank=True, null=True)
    expiration = models.IntegerField(blank=True, null=True)
    type = models.CharField(max_length=1, blank=True, null=True)
    ambulatory = models.BooleanField(blank=True, null=True)
    hospitable = models.BooleanField(blank=True, null=True)
    mobile = models.BooleanField(blank=True, null=True)
    domicile = models.BooleanField(blank=True, null=True)
    other = models.BooleanField(blank=True, null=True)
    gender = models.CharField(max_length=1, blank=True, null=True)
    groupageid = models.IntegerField(blank=True, null=True)
    cr = models.BooleanField(blank=True, null=True)
    ir = models.BooleanField(blank=True, null=True)
    low = models.BooleanField(blank=True, null=True)
    medium = models.BooleanField(blank=True, null=True)
    high = models.BooleanField(blank=True, null=True)
    factor = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    recuperation = models.BooleanField(blank=True, null=True)
    pyp = models.BooleanField(blank=True, null=True)
    urgency = models.BooleanField(blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)
    flatratecost = models.BooleanField(blank=True, null=True)
    judgment = models.IntegerField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'classification'
        unique_together = (('companyid', 'classificationid'),)


class OasisCompany(models.Model):
    # Set default db
    use_db = "oasis"
    # Set default manager
    objects = managers.OasisCompany()

    companyid = models.IntegerField(primary_key=True)
    companyname = models.CharField(max_length=100)
    companycode = models.CharField(max_length=30)
    countryid = models.IntegerField()
    clientid = models.BigIntegerField()
    liquidation = models.CharField(max_length=1, blank=True, null=True)
    retentioninvoice = models.BooleanField(blank=True, null=True)
    languageid = models.IntegerField(blank=True, null=True)
    address = models.CharField(max_length=100, blank=True, null=True)
    address1 = models.CharField(max_length=100, blank=True, null=True)
    phone = models.CharField(max_length=100, blank=True, null=True)
    city = models.CharField(max_length=100, blank=True, null=True)
    state = models.CharField(max_length=100, blank=True, null=True)
    rounding = models.BooleanField(blank=True, null=True)
    typerounding = models.CharField(max_length=1, blank=True, null=True)
    partialdispatch = models.BooleanField(blank=True, null=True)
    typeprice = models.CharField(max_length=1, blank=True, null=True)
    validatecredit = models.BooleanField(blank=True, null=True)
    discountorder = models.BooleanField(blank=True, null=True)
    discountvolume = models.BooleanField(blank=True, null=True)
    discountlocation = models.BooleanField(blank=True, null=True)
    discountpromptpayment = models.BooleanField(blank=True, null=True)
    creditunit = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    local_check = models.BooleanField(blank=True, null=True, db_column="check")
    local_delay = models.BooleanField(blank=True, null=True, db_column="delay")
    limit = models.BooleanField(blank=True, null=True)
    interest = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    delayinterest = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    sanctioncheck = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    suspensionrate = models.CharField(max_length=1, blank=True, null=True)
    legalrate = models.CharField(max_length=1, blank=True, null=True)
    fiscalperiod = models.IntegerField(blank=True, null=True)
    physical = models.CharField(max_length=1, blank=True, null=True)
    transit = models.BooleanField(blank=True, null=True)
    costmethod = models.CharField(max_length=1, blank=True, null=True)
    costsystem = models.CharField(max_length=1, blank=True, null=True)
    costmodel = models.CharField(max_length=1, blank=True, null=True)
    periodconsumption = models.IntegerField(blank=True, null=True)
    coststore = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    costpurchase = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    receipttolerance = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    margin = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    quotation = models.IntegerField(blank=True, null=True)
    transporter = models.BooleanField(blank=True, null=True)
    risckentity = models.BigIntegerField(blank=True, null=True)
    compensationentity = models.BigIntegerField(blank=True, null=True)
    autoliquidation = models.CharField(max_length=1, blank=True, null=True)
    paymentlocationid = models.IntegerField(blank=True, null=True)
    associatequota = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    locationjournalid = models.IntegerField(blank=True, null=True)
    creditretention = models.BooleanField(blank=True, null=True)
    validatecreditremission = models.BooleanField(blank=True, null=True)
    dispatch = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    approveorder = models.BooleanField(blank=True, null=True)
    budgetquantity = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    budgetvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    changepriceinvoiceorder = models.BooleanField(blank=True, null=True)
    factoradd = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    factorsubstraction = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    supercode = models.CharField(max_length=6, blank=True, null=True)
    pricetypefrequent = models.IntegerField(blank=True, null=True)
    exchangeratevalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    exchangerate = models.BooleanField(blank=True, null=True)
    pricemaximum = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    extcode = models.CharField(max_length=13, blank=True, null=True)
    associateinterest = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    loaninteres = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    programproduction = models.CharField(max_length=1, blank=True, null=True)
    planproduction = models.CharField(max_length=1, blank=True, null=True)
    estandarproduction = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    premiumsupervisor = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    premiumoperator = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    premiumattendant = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    premiumsupervisorsupport = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    premiumassistant = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    attendantid = models.BigIntegerField(blank=True, null=True)
    supervisorsupport = models.BigIntegerField(blank=True, null=True)
    attendantmix = models.BigIntegerField(blank=True, null=True)
    periodsrotation = models.IntegerField(blank=True, null=True)
    cashpaymentid = models.IntegerField(blank=True, null=True)
    dynamicweight = models.BooleanField(blank=True, null=True)
    accountpayroll = models.CharField(max_length=1, blank=True, null=True)
    costproduction = models.CharField(max_length=1, blank=True, null=True)
    methodcommision = models.CharField(max_length=1, blank=True, null=True)
    security = models.BigIntegerField(blank=True, null=True)
    assetorder = models.BooleanField(blank=True, null=True)
    pricefreight = models.BooleanField(blank=True, null=True)
    picking = models.BooleanField(blank=True, null=True)
    localizationabc = models.BooleanField(blank=True, null=True)
    mobile = models.BooleanField(blank=True, null=True)
    receivelocalization = models.CharField(max_length=20, blank=True, null=True)
    dispatchlocalization = models.CharField(max_length=20, blank=True, null=True)
    packinglocalization = models.CharField(max_length=20, blank=True, null=True)
    accounttax = models.BooleanField(blank=True, null=True)
    accounttaxpurchase = models.BooleanField(blank=True, null=True)
    efficiency = models.BooleanField(blank=True, null=True)
    approvedispatch = models.BooleanField(blank=True, null=True)
    matrixid = models.IntegerField(blank=True, null=True)
    generateprice = models.BooleanField(blank=True, null=True)
    comissionsales = models.BooleanField(blank=True, null=True)
    comissioncollection = models.BooleanField(blank=True, null=True)
    comissionbudget = models.BooleanField(blank=True, null=True)
    rolereceivablesid = models.IntegerField(blank=True, null=True)
    rolecommercialid = models.IntegerField(blank=True, null=True)
    validatecommercial = models.BooleanField(blank=True, null=True)
    methodpromptpayment = models.IntegerField(blank=True, null=True)
    discount = models.IntegerField(blank=True, null=True)
    multicompanydistribution = models.BooleanField(blank=True, null=True)
    pricetypedistributor = models.CharField(max_length=1, blank=True, null=True)
    roleproductionid = models.IntegerField(blank=True, null=True)
    taxpurchase = models.CharField(max_length=1, blank=True, null=True)
    taxsales = models.CharField(max_length=1, blank=True, null=True)
    typeproduction = models.CharField(max_length=1, blank=True, null=True)
    presentation = models.BooleanField(blank=True, null=True)
    dispatchcontrol = models.BooleanField(blank=True, null=True)
    bicurrency = models.BooleanField(blank=True, null=True)
    accounttaxexpense = models.BooleanField(blank=True, null=True)
    typecontract = models.CharField(max_length=1, blank=True, null=True)
    quotamoderator = models.BooleanField(blank=True, null=True)
    bondrepurchase = models.BooleanField(blank=True, null=True)
    costcenterinvoice = models.BooleanField(blank=True, null=True)
    projectinvoice = models.BooleanField(blank=True, null=True)
    validateexpirationinvoice = models.BooleanField(blank=True, null=True)
    email = models.CharField(max_length=100, blank=True, null=True)
    validateretentionorder = models.BooleanField(blank=True, null=True)
    initialcash = models.CharField(max_length=20, blank=True, null=True)
    changecash = models.CharField(max_length=20, blank=True, null=True)
    type = models.CharField(max_length=20, blank=True, null=True)
    initialdate = models.CharField(max_length=20, blank=True, null=True)
    finaldate = models.CharField(max_length=20, blank=True, null=True)
    documentrole = models.BooleanField(blank=True, null=True)
    template = models.BooleanField(blank=True, null=True)
    demo = models.BooleanField(blank=True, null=True)
    created = models.DateField(blank=True, null=True)
    createdby = models.IntegerField(blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    industryid = models.IntegerField(blank=True, null=True)
    initial = models.DateField(blank=True, null=True)
    smtpserver = models.CharField(max_length=100, blank=True, null=True)
    port = models.CharField(max_length=100, blank=True, null=True)
    emailoutput = models.CharField(max_length=100, blank=True, null=True)
    passwordoutput = models.CharField(max_length=100, blank=True, null=True)
    roundingcycle = models.CharField(max_length=1, blank=True, null=True)
    health = models.CharField(max_length=1, blank=True, null=True)
    activity = models.CharField(max_length=4000, blank=True, null=True)
    image = models.BinaryField(blank=True, null=True)
    timezoneid = models.IntegerField(blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)
    certicatessl = models.BooleanField(blank=True, null=True)
    syncpublicationid = models.IntegerField(blank=True, null=True)
    synclocationid = models.IntegerField(blank=True, null=True)
    paymentmethod = models.CharField(max_length=1, blank=True, null=True)
    paymentcode = models.CharField(max_length=100, blank=True, null=True)
    payuapilogin = models.CharField(max_length=100, blank=True, null=True)
    payuapikey = models.CharField(max_length=300, blank=True, null=True)
    paymentaccount = models.CharField(max_length=100, blank=True, null=True)
    psetargeturl = models.CharField(max_length=500, blank=True, null=True)
    esignature = models.CharField(max_length=100, blank=True, null=True)
    esignaturegoodthru = models.DateField(blank=True, null=True)
    esignaturepassword = models.CharField(max_length=100, blank=True, null=True)
    ebillproduction = models.BooleanField(blank=True, null=True)
    ebill = models.BooleanField(blank=True, null=True)
    sendebill = models.CharField(max_length=1, blank=True, null=True)
    hoursbyday = models.IntegerField(blank=True, null=True)
    ebilladjunct = models.BooleanField(blank=True, null=True)
    companyidcentral = models.IntegerField(blank=True, null=True)
    paymentmethodcredit = models.CharField(max_length=1, blank=True, null=True)
    emailing = models.CharField(max_length=1, blank=True, null=True)
    userimap = models.CharField(max_length=20, blank=True, null=True)
    passwordimap = models.CharField(max_length=20, blank=True, null=True)
    configimap = models.CharField(max_length=1000, blank=True, null=True)
    testid = models.CharField(max_length=100, blank=True, null=True)
    databaseid = models.IntegerField(blank=True, null=True)
    bienabled = models.BooleanField(blank=True, null=True)
    emailoutputfe = models.CharField(max_length=100, blank=True, null=True)
    passwordoutputfe = models.CharField(max_length=100, blank=True, null=True)
    supercodec = models.CharField(max_length=6, blank=True, null=True)
    masterclientid = models.BigIntegerField(blank=True, null=True)
    budgetcostcenter = models.BooleanField(blank=True, null=True)
    budgetperiod = models.BooleanField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'company'


class GeographicLocation(models.Model):
    """
    Model representation of Geographic location table
    Database: OASIS4
    Table: Geographiclocation
    """
    # Set default db
    use_db = "oasis"
    # Set default manager
    objects = managers.OasisGeographicLocation()
    # Set fields
    companyid = models.IntegerField(primary_key=True)
    geographiclocationid = models.IntegerField()
    geographiclocationname = models.CharField(max_length=100, blank=True, null=True)
    parent = models.IntegerField(blank=True, null=True)
    locationid = models.IntegerField(blank=True, null=True)
    population = models.IntegerField(blank=True, null=True)
    countryid = models.IntegerField(blank=True, null=True)
    type = models.CharField(max_length=1, blank=True, null=True)
    exempt = models.BooleanField(blank=True, null=True)
    alternatecode = models.IntegerField(blank=True, null=True)
    groupid = models.IntegerField(blank=True, null=True)
    iatacode = models.CharField(max_length=3, blank=True, null=True)
    clientid = models.BigIntegerField(blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    typeupc = models.CharField(max_length=30, blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)
    phonecode = models.CharField(max_length=10, blank=True, null=True)
    latitude = models.CharField(max_length=30, blank=True, null=True)
    longitude = models.CharField(max_length=30, blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'geographiclocation'
        unique_together = (('companyid', 'geographiclocationid'),)


class Client(models.Model):
    """
    Model representation of Client table
    Database: OASIS4
    Table: Client
    """
    # Set default manager
    objects = managers.OasisClient()
    # Set default db
    use_db = "oasis"
    # Set fields
    companyid = models.OneToOneField('GeographicLocation', models.DO_NOTHING, db_column='companyid', primary_key=True,
                                     related_name="clients")
    clientid = models.BigIntegerField()
    clientname = models.CharField(max_length=100, blank=True, null=True)
    clienttype = models.CharField(max_length=1, blank=True, null=True)
    clientcode = models.CharField(max_length=20, blank=True, null=True)
    national = models.BooleanField(blank=True, null=True)
    representative = models.CharField(max_length=100, blank=True, null=True)
    address = models.CharField(max_length=100, blank=True, null=True)
    phone = models.CharField(max_length=30, blank=True, null=True)
    celphone = models.CharField(max_length=30, blank=True, null=True)
    fax = models.CharField(max_length=30, blank=True, null=True)
    zipcode = models.CharField(max_length=20, blank=True, null=True)
    email = models.CharField(max_length=200, blank=True, null=True)
    geographiclocationid = models.IntegerField(db_column='geographiclocationid', blank=True, null=True)
    checkdigit = models.IntegerField(blank=True, null=True)
    groupid = models.IntegerField(blank=True, null=True)
    vendorid = models.BigIntegerField(blank=True, null=True)
    locationid = models.IntegerField(blank=True, null=True)
    discount = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    conditionpaymentid = models.IntegerField(blank=True, null=True)
    pricetypeid = models.IntegerField(blank=True, null=True)
    tax = models.BooleanField(blank=True, null=True)
    client_class = models.CharField(db_column='class', max_length=1, blank=True,
                                    null=True)  # Field renamed because it was a Python reserved word.
    segmentid = models.IntegerField(blank=True, null=True)
    remissioninvoice = models.CharField(max_length=1, blank=True, null=True)
    deliverybill = models.CharField(max_length=1, blank=True, null=True)
    deliverybilldirectionid = models.IntegerField(blank=True, null=True)
    deliverystatement = models.CharField(max_length=1, blank=True, null=True)
    deliverystatementdirectionid = models.IntegerField(blank=True, null=True)
    customer = models.BooleanField(blank=True, null=True)
    taxtypeid = models.IntegerField(blank=True, null=True)
    userid = models.IntegerField(blank=True, null=True)
    alternatecode = models.CharField(max_length=15, blank=True, null=True)
    matrixid = models.BigIntegerField(blank=True, null=True)
    limit = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    lastpurchase = models.DateField(blank=True, null=True)
    specialityid = models.IntegerField(blank=True, null=True)
    programid = models.IntegerField(blank=True, null=True)
    purchasepaymentconditionid = models.IntegerField(blank=True, null=True)
    purchasediscount = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    taxprice = models.CharField(max_length=1, blank=True, null=True)
    supplier = models.BooleanField(blank=True, null=True)
    salescontact = models.CharField(max_length=100, blank=True, null=True)
    paymentcontact = models.CharField(max_length=100, blank=True, null=True)
    purchasecontact = models.CharField(max_length=100, blank=True, null=True)
    entrydate = models.DateField(blank=True, null=True)
    retirementdate = models.DateField(blank=True, null=True)
    paymentformid = models.IntegerField(blank=True, null=True)
    area = models.CharField(max_length=1, blank=True, null=True)
    bankaccount = models.CharField(max_length=20, blank=True, null=True)
    socialinsurance = models.CharField(max_length=20, blank=True, null=True)
    medicalinsurance = models.CharField(max_length=20, blank=True, null=True)
    turnid = models.IntegerField(blank=True, null=True)
    employee = models.BooleanField(blank=True, null=True)
    vendor = models.BooleanField(blank=True, null=True)
    shareholder = models.BooleanField(blank=True, null=True)
    partner = models.BooleanField(blank=True, null=True)
    state = models.CharField(max_length=1, blank=True, null=True)
    industrialactivity = models.IntegerField(blank=True, null=True)
    industrialtax = models.BooleanField(blank=True, null=True)
    retention = models.BooleanField(blank=True, null=True)
    deductibleretention = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    birthdate = models.DateField(blank=True, null=True)
    birthlocationid = models.IntegerField(blank=True, null=True)
    civilstatus = models.CharField(max_length=1, blank=True, null=True)
    education = models.CharField(max_length=1, blank=True, null=True)
    professionid = models.IntegerField(blank=True, null=True)
    currentcompany = models.CharField(max_length=40, blank=True, null=True)
    currentcompanycode = models.CharField(max_length=20, blank=True, null=True)
    ingress = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    entrycompanydate = models.DateField(blank=True, null=True)
    house = models.CharField(max_length=1, blank=True, null=True)
    housevalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    car = models.CharField(max_length=1, blank=True, null=True)
    carvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    spouse = models.CharField(max_length=100, blank=True, null=True)
    spousecode = models.CharField(max_length=20, blank=True, null=True)
    child = models.IntegerField(blank=True, null=True)
    distributortax = models.CharField(max_length=1, blank=True, null=True)
    firstlastname = models.CharField(max_length=20, blank=True, null=True)
    secondlastname = models.CharField(max_length=30, blank=True, null=True)
    firstfirstname = models.CharField(max_length=20, blank=True, null=True)
    secondfirstname = models.CharField(max_length=30, blank=True, null=True)
    sex = models.CharField(max_length=1, blank=True, null=True)
    additionalupc = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    specialrate = models.DecimalField(max_digits=6, decimal_places=4, blank=True, null=True)
    beneficiaryid = models.BigIntegerField(blank=True, null=True)
    bankid = models.IntegerField(blank=True, null=True)
    governmental = models.BooleanField(blank=True, null=True)
    abbreviation = models.CharField(max_length=60, blank=True, null=True)
    bankaccounttype = models.CharField(max_length=1, blank=True, null=True)
    delaytolerance = models.IntegerField(blank=True, null=True)
    partialdispatch = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    partialdispatchproduct = models.BooleanField(blank=True, null=True)
    separation = models.CharField(max_length=1, blank=True, null=True)
    billing = models.CharField(max_length=1, blank=True, null=True)
    currencyid = models.IntegerField(blank=True, null=True)
    languageid = models.IntegerField(blank=True, null=True)
    zoneid = models.IntegerField(blank=True, null=True)
    tagid = models.IntegerField(blank=True, null=True)
    incoterms = models.CharField(max_length=3, blank=True, null=True)
    abc = models.CharField(max_length=1, blank=True, null=True)
    quotacollection = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    quotatype = models.CharField(max_length=1, blank=True, null=True)
    bond = models.CharField(max_length=1, blank=True, null=True)
    quotavalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    qualification = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    collectorid = models.BigIntegerField(blank=True, null=True)
    authorizedid = models.BigIntegerField(blank=True, null=True)
    conditiondirection = models.BooleanField(blank=True, null=True)
    channelid = models.IntegerField(blank=True, null=True)
    supervisorid = models.IntegerField(blank=True, null=True)
    priority = models.IntegerField(blank=True, null=True)
    promptpaymentid = models.IntegerField(blank=True, null=True)
    rotation = models.IntegerField(blank=True, null=True)
    dispatchminimun = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    plan = models.IntegerField(blank=True, null=True)
    creditdata = models.CharField(max_length=1, blank=True, null=True)
    declarant = models.BooleanField(blank=True, null=True)
    replication = models.CharField(max_length=30, blank=True, null=True)
    beneficiary = models.BooleanField(blank=True, null=True)
    contracttype = models.CharField(max_length=1, blank=True, null=True)
    contractdate = models.DateField(blank=True, null=True)
    frequent = models.BooleanField(blank=True, null=True)
    educationaldegree = models.CharField(max_length=2, blank=True, null=True)
    occupation = models.CharField(max_length=1, blank=True, null=True)
    occupied = models.CharField(max_length=1, blank=True, null=True)
    occupiedcode = models.IntegerField(blank=True, null=True)
    lastdate = models.DateField(blank=True, null=True)
    lastproduct = models.IntegerField(blank=True, null=True)
    lastlocation = models.IntegerField(blank=True, null=True)
    healthfee = models.IntegerField(blank=True, null=True)
    affiliate = models.BooleanField(blank=True, null=True)
    neighborhoodid = models.IntegerField(blank=True, null=True)
    oldentity = models.CharField(max_length=12, blank=True, null=True)
    asuranceaffiliationdate = models.DateField(blank=True, null=True)
    disability = models.CharField(max_length=1, blank=True, null=True)
    ethnicgroup = models.CharField(max_length=2, blank=True, null=True)
    totalpoints = models.IntegerField(blank=True, null=True)
    family = models.CharField(max_length=1, blank=True, null=True)
    sisbenfile = models.IntegerField(blank=True, null=True)
    sisbennucleus = models.IntegerField(blank=True, null=True)
    sisbennumber = models.IntegerField(blank=True, null=True)
    sisbendate = models.DateField(blank=True, null=True)
    sisbenlevel = models.IntegerField(blank=True, null=True)
    sisbenpoints = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    affiliatetype = models.CharField(max_length=1, blank=True, null=True)
    matrixclienttype = models.CharField(max_length=1, blank=True, null=True)
    populationgroup = models.CharField(max_length=2, blank=True, null=True)
    affiliatestatus = models.CharField(max_length=1, blank=True, null=True)
    locality = models.CharField(max_length=40, blank=True, null=True)
    zone = models.CharField(max_length=1, blank=True, null=True)
    highcost = models.BooleanField(blank=True, null=True)
    authorizationlevel = models.IntegerField(blank=True, null=True)
    credit = models.BooleanField(blank=True, null=True)
    documentlocationid = models.IntegerField(blank=True, null=True)
    retentionvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    food = models.CharField(max_length=2, blank=True, null=True)
    foodprime = models.CharField(max_length=1, blank=True, null=True)
    foodprimeextra = models.CharField(max_length=1, blank=True, null=True)
    clock = models.BooleanField(blank=True, null=True)
    employeestate = models.CharField(max_length=1, blank=True, null=True)
    positionid = models.IntegerField(blank=True, null=True)
    height = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    weight = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    rh = models.CharField(max_length=3, blank=True, null=True)
    laborlocationid = models.IntegerField(blank=True, null=True)
    time = models.IntegerField(blank=True, null=True)
    paymentlocationid = models.IntegerField(blank=True, null=True)
    expeditiondocumentdate = models.DateField(blank=True, null=True)
    expirationdocumentdate = models.DateField(blank=True, null=True)
    expirationdocument = models.CharField(max_length=10, blank=True, null=True)
    expirationentity = models.CharField(max_length=1, blank=True, null=True)
    duplicateentity = models.CharField(max_length=10, blank=True, null=True)
    motive = models.CharField(max_length=3, blank=True, null=True)
    revised = models.DateField(blank=True, null=True)
    idunumber = models.CharField(max_length=15, blank=True, null=True)
    land = models.CharField(max_length=60, blank=True, null=True)
    farm = models.CharField(max_length=60, blank=True, null=True)
    ciiuid = models.IntegerField(blank=True, null=True)
    replydays = models.IntegerField(blank=True, null=True)
    voucherinitial = models.DateField(blank=True, null=True)
    voucherfinal = models.DateField(blank=True, null=True)
    vouchercomply = models.CharField(max_length=1, blank=True, null=True)
    fiscaldocument = models.CharField(max_length=3, blank=True, null=True)
    image = models.BinaryField(blank=True, null=True)
    individual = models.CharField(max_length=1, blank=True, null=True)
    paymentdays = models.IntegerField(blank=True, null=True)
    birthday = models.DateField(blank=True, null=True)
    marked = models.BooleanField(blank=True, null=True)
    voucher = models.CharField(max_length=3, blank=True, null=True)
    costcenterid = models.IntegerField(blank=True, null=True)
    coffeelimit = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    coffeelimitused = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    signature = models.BinaryField(blank=True, null=True)
    partnerstate = models.CharField(max_length=1, blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    typedocumentid = models.CharField(max_length=2, blank=True, null=True)
    headid = models.BigIntegerField(blank=True, null=True)
    kinshipid = models.IntegerField(blank=True, null=True)
    grouppopulationid = models.IntegerField(blank=True, null=True)
    condition = models.CharField(max_length=1, blank=True, null=True)
    affiliation = models.DateField(blank=True, null=True)
    consecutive = models.CharField(max_length=20, blank=True, null=True)
    stateaffiliate = models.CharField(max_length=2, blank=True, null=True)
    activationdate = models.DateField(blank=True, null=True)
    suspensiondate = models.DateField(blank=True, null=True)
    report = models.CharField(max_length=2, blank=True, null=True)
    neighborhood = models.CharField(max_length=30, blank=True, null=True)
    datereport = models.DateField(blank=True, null=True)
    translation = models.CharField(max_length=2, blank=True, null=True)
    epsidanterior = models.IntegerField(blank=True, null=True)
    epsidcross = models.IntegerField(blank=True, null=True)
    ingressvalidity = models.CharField(max_length=1, blank=True, null=True)
    registerduria = models.CharField(max_length=10, blank=True, null=True)
    epsidscross = models.IntegerField(blank=True, null=True)
    locationidcross = models.IntegerField(blank=True, null=True)
    resolution = models.CharField(max_length=20, blank=True, null=True)
    core = models.CharField(max_length=1, blank=True, null=True)
    home = models.CharField(max_length=2, blank=True, null=True)
    bdua = models.CharField(max_length=2, blank=True, null=True)
    locationidcross1 = models.IntegerField(blank=True, null=True)
    datepoll = models.DateField(blank=True, null=True)
    datechangestate = models.DateField(blank=True, null=True)
    type = models.CharField(max_length=1, blank=True, null=True)
    gloss = models.CharField(max_length=10, blank=True, null=True)
    statecross = models.CharField(max_length=2, blank=True, null=True)
    groupinadequate = models.BooleanField(blank=True, null=True)
    cellular = models.CharField(max_length=20, blank=True, null=True)
    cellular2 = models.CharField(max_length=20, blank=True, null=True)
    charingress = models.CharField(max_length=1, blank=True, null=True)
    evolution = models.IntegerField(blank=True, null=True)
    numberbirth = models.IntegerField(blank=True, null=True)
    coverdate = models.DateField(blank=True, null=True)
    validatebdua = models.BooleanField(blank=True, null=True)
    glossbdua = models.CharField(max_length=400, blank=True, null=True)
    statebdua = models.CharField(max_length=2, blank=True, null=True)
    criterionvalidate = models.IntegerField(blank=True, null=True)
    biometria = models.BooleanField(blank=True, null=True)
    groupageid = models.IntegerField(blank=True, null=True)
    upc = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    portability = models.BooleanField(blank=True, null=True)
    regimen = models.CharField(max_length=1, blank=True, null=True)
    levelemployery = models.IntegerField(blank=True, null=True)
    typeemployery = models.IntegerField(blank=True, null=True)
    sisbenmethodology = models.IntegerField(blank=True, null=True)
    alfanet = models.BigIntegerField(blank=True, null=True)
    geographiclocationidactual = models.IntegerField(blank=True, null=True)
    multiaffiliatecross = models.CharField(max_length=1, blank=True, null=True)
    kinshipemployery = models.CharField(max_length=2, blank=True, null=True)
    actuaphone = models.BooleanField(blank=True, null=True)
    actuaaddress = models.BooleanField(blank=True, null=True)
    statetenebit = models.CharField(max_length=1, blank=True, null=True)
    fum = models.DateField(blank=True, null=True)
    pertaintenebit = models.BooleanField(blank=True, null=True)
    numberidinform = models.IntegerField(blank=True, null=True)
    clientidant = models.BigIntegerField(blank=True, null=True)
    upcadditional = models.BooleanField(blank=True, null=True)
    initiationupcadditional = models.DateField(blank=True, null=True)
    employerid = models.BigIntegerField(blank=True, null=True)
    formpaymentid = models.IntegerField(blank=True, null=True)
    scene = models.IntegerField(blank=True, null=True)
    locationaccessid = models.IntegerField(blank=True, null=True)
    compromisetext = models.CharField(max_length=4000, blank=True, null=True)
    dispatchtext = models.CharField(max_length=4000, blank=True, null=True)
    processbiometric = models.IntegerField(blank=True, null=True)
    fingerright = models.IntegerField(blank=True, null=True)
    fingerprintr1 = models.BinaryField(blank=True, null=True)
    fingerprintr2 = models.BinaryField(blank=True, null=True)
    fingerleft = models.IntegerField(blank=True, null=True)
    fingerprintl1 = models.BinaryField(blank=True, null=True)
    fingerprintl2 = models.BinaryField(blank=True, null=True)
    imagedocument = models.BinaryField(blank=True, null=True)
    datebiometric = models.DateField(blank=True, null=True)
    typeprocessbiometric = models.IntegerField(blank=True, null=True)
    imagedocument1 = models.BinaryField(blank=True, null=True)
    institutional = models.BooleanField(blank=True, null=True)
    levelcontributory = models.IntegerField(blank=True, null=True)
    typecontributory = models.IntegerField(blank=True, null=True)
    typeeducationid = models.IntegerField(blank=True, null=True)
    epsid = models.BigIntegerField(blank=True, null=True)
    eps = models.BooleanField(blank=True, null=True)
    pension = models.BooleanField(blank=True, null=True)
    funeralsecure = models.BooleanField(blank=True, null=True)
    phonecompany = models.CharField(max_length=40, blank=True, null=True)
    egress = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    stratum = models.CharField(max_length=1, blank=True, null=True)
    assets = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    passives = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    patrimony = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)
    typemediaid = models.IntegerField(blank=True, null=True)
    projectid = models.IntegerField(blank=True, null=True)
    genreid = models.IntegerField(blank=True, null=True)
    automaticpayment = models.BooleanField(blank=True, null=True)
    associateentrydate = models.DateField(blank=True, null=True)
    associateretirementdate = models.DateField(blank=True, null=True)
    cardreference = models.CharField(max_length=30, blank=True, null=True)
    pep = models.BooleanField(blank=True, null=True)
    observation = models.CharField(max_length=4000, blank=True, null=True)
    risk = models.CharField(max_length=1, blank=True, null=True)
    typemedicineid = models.IntegerField(blank=True, null=True)
    commercialregistration = models.CharField(max_length=25, blank=True, null=True)
    contractor = models.BooleanField(blank=True, null=True)
    liquidatorbase = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    salary = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    typereference = models.CharField(max_length=5, blank=True, null=True)
    network = models.BooleanField(blank=True, null=True)
    isebill = models.BooleanField(blank=True, null=True)
    lastsale = models.DateField(blank=True, null=True)
    typecontactid = models.IntegerField(blank=True, null=True)
    habeasdata = models.BooleanField(blank=True, null=True)
    coffeefreight = models.CharField(max_length=1, blank=True, null=True)
    ean = models.BigIntegerField(blank=True, null=True)
    typeemployee = models.CharField(max_length=3, blank=True, null=True)
    formliquidationid = models.IntegerField(blank=True, null=True)
    timezone = models.CharField(max_length=30, blank=True, null=True)
    populationgroupmethodology = models.CharField(max_length=2, blank=True, null=True)
    subgroupsisbeniv = models.CharField(max_length=3, blank=True, null=True)
    dispersion = models.CharField(max_length=2, blank=True, null=True)
    solidaritycontribution = models.BooleanField(blank=True, null=True)

    @property
    def is_valid(self):
        return self._is_valid

    @is_valid.setter
    def is_valid(self, value: bool):
        self._is_valid = value

    @property
    def customer_type(self) -> int:
        """
        Property that represent a valid customer type
        :return:
        """
        customer_type = 0
        if self.partner == 1:
            customer_type = CustomerType.PARTNER
        elif self.customer == 1 or self.supplier == 1:
            customer_type = CustomerType.CUSTOMER
        return customer_type

    @property
    def first_name(self):
        if self.firstfirstname is not None and len(self.firstlastname) > 0:
            first_name = self.firstfirstname.strip()
            if self.secondfirstname is not None:
                first_name += " " + self.secondfirstname.strip()
            first_name = string.capwords(first_name)
        else:
            first_name = self.clientname.upper()
        return first_name

    @property
    def last_name(self):
        last_name = self.firstlastname.strip()
        if self.secondlastname is not None and len(self.secondlastname) > 0:
            last_name += " " + self.secondlastname.strip().capitalize()
        return string.capwords(last_name)

    @property
    def location(self):
        try:
            qs_location = GeographicLocation.objects.get_by_pk(self.geographiclocationid)
            location = qs_location.first().geographiclocationname
        except Exception as exc:
            location = ""
        finally:
            return location

    @property
    def main_email(self):
        if ";" in self.email:
            customer_email = self.email.split(";")[0].strip().lower()
        else:
            customer_email = self.email.strip().lower()
        return customer_email

    class Meta:
        managed = False
        db_table = 'client'
        unique_together = (('companyid', 'clientid'),)


class Discount(models.Model):
    """
    Model representation of Discoun table
    Database: OASIS4
    Table: Discount
    """
    # Set default manager
    objects = managers.OasisDiscount()
    # Set default database
    use_db = "oasis"
    # Set fields
    companyid = models.IntegerField(primary_key=True)
    discountid = models.IntegerField()
    discountname = models.CharField(max_length=100, blank=True, null=True)
    typediscountid = models.IntegerField(blank=True, null=True)
    locationid = models.IntegerField(blank=True, null=True)
    geographiclocationid = models.IntegerField(blank=True, null=True)
    clientid = models.BigIntegerField(blank=True, null=True)
    directionid = models.IntegerField(blank=True, null=True)
    segmentid = models.IntegerField()
    abcclient = models.CharField(max_length=1)
    vendorid = models.BigIntegerField(blank=True, null=True)
    dateinitial = models.DateTimeField(blank=True, null=True)
    datefinal = models.DateTimeField(blank=True, null=True)
    typeapplies = models.CharField(max_length=1, blank=True, null=True)
    typepriceid = models.IntegerField(blank=True, null=True)
    currencyid = models.IntegerField(blank=True, null=True)
    exchangerate = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    businessid = models.IntegerField(blank=True, null=True)
    classificationid = models.IntegerField(blank=True, null=True)
    productid = models.BigIntegerField(blank=True, null=True)
    brandid = models.IntegerField(blank=True, null=True)
    lineid = models.IntegerField(blank=True, null=True)
    abcproduct = models.CharField(max_length=1)
    price = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    discountpercentage = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    expirationinitial = models.DateField(blank=True, null=True)
    expirationfinal = models.DateField(blank=True, null=True)
    value = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    bondpercentage = models.FloatField(blank=True, null=True)
    bondvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    image = models.BinaryField(blank=True, null=True)
    format = models.IntegerField(blank=True, null=True)
    tariff = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    tariffsubstraction = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    cost = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    typecampaign = models.CharField(max_length=1, blank=True, null=True)
    state = models.CharField(max_length=1, blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    description = models.CharField(max_length=4000, blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)
    documentid = models.CharField(max_length=3, blank=True, null=True)
    numberid = models.IntegerField(blank=True, null=True)
    codeexternal = models.CharField(max_length=10, blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'discount'
        unique_together = (('companyid', 'discountid'),)


class OasisProduct(models.Model):
    """
    Model representation of Product table
    Database: OASIS4
    """
    # Set default manager
    objects = managers.OasisProduct()
    # Set default database
    use_db = "oasis"
    # Set fields
    companyid = models.OneToOneField(Classification, models.DO_NOTHING, db_column='companyid', primary_key=True,
                                     related_name="company_products")
    productid = models.BigIntegerField()
    productname = models.CharField(max_length=1000, blank=True, null=True)
    classificationid = models.IntegerField(blank=True, null=True)
    service = models.BooleanField(blank=True, null=True)
    inventory = models.CharField(max_length=1, blank=True, null=True)
    price = models.CharField(max_length=1, blank=True, null=True)
    individual = models.BooleanField(blank=True, null=True)
    ingress = models.DateField(blank=True, null=True)
    discount = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    measureunitid = models.IntegerField(blank=True, null=True)
    taxtypeid = models.IntegerField(blank=True, null=True)
    groupid = models.IntegerField(blank=True, null=True)
    tax = models.BooleanField(blank=True, null=True)
    taxpercentage = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    unitalternate = models.IntegerField(blank=True, null=True)
    factorconversion = models.FloatField(blank=True, null=True)
    depreciation = models.CharField(max_length=2, blank=True, null=True)
    lifespan = models.IntegerField(blank=True, null=True)
    taxcapitalized = models.BooleanField(blank=True, null=True)
    substitute = models.BigIntegerField(blank=True, null=True)
    locationid = models.IntegerField(blank=True, null=True)
    localizationid = models.CharField(max_length=20, blank=True, null=True)
    clientid = models.BigIntegerField(blank=True, null=True)
    oldcode = models.CharField(max_length=100, blank=True, null=True)
    balance = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    inventoried = models.BooleanField(blank=True, null=True)
    random = models.BigIntegerField(blank=True, null=True)
    cycle = models.IntegerField(blank=True, null=True)
    characteristic = models.BooleanField(blank=True, null=True)
    characteristicid = models.IntegerField(blank=True, null=True)
    presentation = models.BooleanField(blank=True, null=True)
    presentationvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    expiration = models.BooleanField(blank=True, null=True)
    control = models.BooleanField(blank=True, null=True)
    lot = models.BooleanField(blank=True, null=True)
    minimum = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    standard = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    maximum = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    dynamic = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    costproduction = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    averageactual = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    averageanterior = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    logo = models.IntegerField(blank=True, null=True)
    level = models.IntegerField(blank=True, null=True)
    abcnumber = models.IntegerField(blank=True, null=True)
    production = models.BooleanField(blank=True, null=True)
    state = models.CharField(max_length=1, blank=True, null=True)
    rent = models.IntegerField(blank=True, null=True)
    surtax = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    surtaxcapitalized = models.BooleanField(blank=True, null=True)
    taxica = models.IntegerField(blank=True, null=True)
    taxicap = models.IntegerField(blank=True, null=True)
    taxdistributor = models.BooleanField(blank=True, null=True)
    unitpurchase = models.IntegerField(blank=True, null=True)
    unitsale = models.IntegerField(blank=True, null=True)
    ean = models.BigIntegerField(blank=True, null=True)
    generic = models.BooleanField(blank=True, null=True)
    genericid = models.BigIntegerField(blank=True, null=True)
    colorid = models.IntegerField(blank=True, null=True)
    sizeid = models.IntegerField(blank=True, null=True)
    genreid = models.IntegerField(blank=True, null=True)
    materialid = models.IntegerField(blank=True, null=True)
    gammaid = models.IntegerField(blank=True, null=True)
    quality = models.BooleanField(blank=True, null=True)
    origin = models.CharField(max_length=1, blank=True, null=True)
    height = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    length = models.DecimalField(db_column="long", max_digits=19, decimal_places=4, blank=True, null=True)
    width = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    weight = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    volume = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    stock = models.BooleanField(blank=True, null=True)
    budget = models.BooleanField(blank=True, null=True)
    tolerancebudget = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    budgetorder = models.BooleanField(blank=True, null=True)
    planexportation = models.IntegerField(blank=True, null=True)
    positiontariff = models.CharField(max_length=20, blank=True, null=True)
    packing = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    box = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    businessid = models.IntegerField(blank=True, null=True)
    combo = models.BooleanField(blank=True, null=True)
    initials = models.CharField(max_length=50, blank=True, null=True)
    daysdose = models.IntegerField(blank=True, null=True)
    special = models.BooleanField(blank=True, null=True)
    checked = models.BooleanField(blank=True, null=True)
    pos = models.BooleanField(blank=True, null=True)
    recovery = models.BooleanField(blank=True, null=True)
    depth = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    designid = models.IntegerField(blank=True, null=True)
    brandid = models.IntegerField(blank=True, null=True)
    functionid = models.IntegerField(blank=True, null=True)
    collectionid = models.IntegerField(blank=True, null=True)
    codealternate = models.CharField(max_length=20, blank=True, null=True)
    lineid = models.IntegerField(blank=True, null=True)
    importation = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    materialraw = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    materialrawind = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    manpower = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    manpowerind = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    direct = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    indirect = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    sex = models.CharField(max_length=1, blank=True, null=True)
    ageinitial = models.IntegerField(blank=True, null=True)
    agefinal = models.IntegerField(blank=True, null=True)
    rangeage = models.CharField(max_length=1, blank=True, null=True)
    levelattention = models.IntegerField(blank=True, null=True)
    levelcomplexity = models.IntegerField(blank=True, null=True)
    gruousurgical = models.IntegerField(blank=True, null=True)
    type = models.CharField(max_length=3, blank=True, null=True)
    quantity = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    quantitymaximum = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    elaborated = models.BigIntegerField(blank=True, null=True)
    revised = models.BigIntegerField(blank=True, null=True)
    approved = models.BigIntegerField(blank=True, null=True)
    tokendate = models.DateField(blank=True, null=True)
    producname1 = models.CharField(max_length=100, blank=True, null=True)
    productiondate = models.DateField(blank=True, null=True)
    countryid = models.IntegerField(blank=True, null=True)
    costdate = models.DateField(blank=True, null=True)
    costproductiondate = models.DateField(blank=True, null=True)
    lastpurchase = models.DateField(blank=True, null=True)
    lastsupplier = models.BigIntegerField(blank=True, null=True)
    lastprice = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    coststandard = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    activityica = models.IntegerField(blank=True, null=True)
    eanchar = models.CharField(max_length=30, blank=True, null=True)
    tariffhealth = models.IntegerField(blank=True, null=True)
    finance = models.BooleanField(blank=True, null=True)
    abc = models.CharField(max_length=1, blank=True, null=True)
    capacity = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    localization2 = models.CharField(max_length=20, blank=True, null=True)
    descriptiontariff = models.CharField(max_length=50, blank=True, null=True)
    margin = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    additionalprice1 = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    additionalprice2 = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    taxvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    marginminimum = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    marginmaximum = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    fund = models.IntegerField(blank=True, null=True)
    factor = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    sourceid = models.IntegerField(blank=True, null=True)
    entryid = models.BigIntegerField(blank=True, null=True)
    expenseobjectid = models.IntegerField(blank=True, null=True)
    returnable = models.BooleanField(blank=True, null=True)
    growth = models.IntegerField(blank=True, null=True)
    marked = models.BooleanField(blank=True, null=True)
    invimadate = models.DateField(blank=True, null=True)
    bpmdate = models.DateField(blank=True, null=True)
    namegeneric = models.CharField(max_length=100, blank=True, null=True)
    namecommercial = models.CharField(max_length=100, blank=True, null=True)
    field1 = models.CharField(max_length=10, blank=True, null=True)
    field2 = models.CharField(max_length=10, blank=True, null=True)
    field3 = models.CharField(max_length=10, blank=True, null=True)
    emission = models.DateField(blank=True, null=True)
    expirationdate = models.DateField(blank=True, null=True)
    interestrate = models.DateField(blank=True, null=True)
    periodicity = models.CharField(max_length=2, blank=True, null=True)
    lastcoupondate = models.DateField(blank=True, null=True)
    currencyid = models.IntegerField(blank=True, null=True)
    performance = models.CharField(max_length=1, blank=True, null=True)
    consignment = models.BooleanField(blank=True, null=True)
    serial = models.BooleanField(blank=True, null=True)
    requireean128 = models.BooleanField(blank=True, null=True)
    ean128 = models.CharField(max_length=128, blank=True, null=True)
    costcenterid = models.IntegerField(blank=True, null=True)
    projectid = models.IntegerField(blank=True, null=True)
    costcenterid1 = models.IntegerField(blank=True, null=True)
    seal = models.IntegerField(blank=True, null=True)
    bonus = models.BooleanField(blank=True, null=True)
    image = models.BinaryField(blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    valuenominal = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    class_field = models.CharField(db_column='class', max_length=1, blank=True,
                                   null=True)  # Field renamed because it was a Python reserved word.
    codeinvima = models.CharField(max_length=20, blank=True, null=True)
    partial = models.BooleanField(blank=True, null=True)
    groupsurgicalid = models.IntegerField(blank=True, null=True)
    copayment = models.BooleanField(blank=True, null=True)
    parturition = models.BooleanField(blank=True, null=True)
    highcost = models.IntegerField(blank=True, null=True)
    upc = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    grouppharmacologicalid = models.IntegerField(blank=True, null=True)
    principleactiveid = models.IntegerField(blank=True, null=True)
    formpharmaceuticalid = models.IntegerField(blank=True, null=True)
    concentrationid = models.IntegerField(blank=True, null=True)
    homologous = models.BooleanField(blank=True, null=True)
    concentration = models.CharField(max_length=100, blank=True, null=True)
    codehomologous = models.CharField(max_length=100, blank=True, null=True)
    cups = models.BooleanField(blank=True, null=True)
    levelauthorization = models.IntegerField(blank=True, null=True)
    classificationidalternate = models.BigIntegerField(blank=True, null=True)
    automatic = models.BooleanField(blank=True, null=True)
    quantitytime = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    nounification = models.BooleanField(blank=True, null=True)
    quantitymonth = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    quantityyear = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    valueminimum = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    valuemaximum = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    quotamoderator = models.BooleanField(blank=True, null=True)
    highcostcontrib = models.IntegerField(blank=True, null=True)
    capitated = models.BooleanField(blank=True, null=True)
    print = models.BooleanField(blank=True, null=True)
    atcpos = models.CharField(max_length=20, blank=True, null=True)
    typegeneric = models.CharField(max_length=20, blank=True, null=True)
    health = models.BooleanField(blank=True, null=True)
    description = models.CharField(max_length=4000, blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)
    codeium = models.CharField(max_length=30, blank=True, null=True)
    codeium1 = models.CharField(max_length=30, blank=True, null=True)
    codeium2 = models.CharField(max_length=30, blank=True, null=True)
    coldchain = models.BooleanField(blank=True, null=True)
    regulated = models.BooleanField(blank=True, null=True)
    valuerecovery = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    temperature = models.BooleanField(blank=True, null=True)
    judgment = models.IntegerField(blank=True, null=True)
    diagnostic = models.IntegerField(blank=True, null=True)
    retentionbyproduct = models.BooleanField(blank=True, null=True)
    coffeefreight = models.CharField(max_length=1, blank=True, null=True)
    combomodel = models.CharField(max_length=1, blank=True, null=True)
    productcurve = models.BooleanField(blank=True, null=True)
    coverid = models.IntegerField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = "product"
        unique_together = (("companyid", "productid"),)


class Periods(models.Model):
    # Set default db
    use_db = "oasis"
    # Set default manager
    objects = managers.Periods()

    # Fields definition
    companyid = models.IntegerField(primary_key=True)
    year = models.IntegerField()
    period = models.IntegerField()
    initial = models.DateField(blank=True, null=True, db_column='"Initial"')
    final = models.DateField(blank=True, null=True)
    open = models.BooleanField(blank=True, null=True)
    plan = models.IntegerField()
    weeks = models.IntegerField(blank=True, null=True)
    fiscalperiod = models.IntegerField(blank=True, null=True)
    fiscalyear = models.IntegerField(blank=True, null=True)
    inflation = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    interes = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    budgetperiod = models.IntegerField(blank=True, null=True)
    budgetyear = models.IntegerField(blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'periods'
        unique_together = (('companyid', 'year', 'period'),)


class Cycle(models.Model):
    # Set default db
    use_db = "oasis"
    # Set default Manager
    objects = managers.Cycle()
    # Field list

    companyid = models.IntegerField(primary_key=True)
    type = models.CharField(max_length=1)
    cycle = models.IntegerField(db_column='"Number"')
    year = models.IntegerField()
    period = models.IntegerField()
    periodyear = models.IntegerField()
    updated = models.DateField(blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'cycle'
        unique_together = (('companyid', 'type', 'cycle', 'year', 'period', 'periodyear'),)


class Location(models.Model):
    # Default db
    use_db = "oasis"
    # Default manager
    objects = managers.OasisLocation()
    # Fields list
    companyid = models.IntegerField(primary_key=True)
    locationid = models.IntegerField()
    locationname = models.CharField(max_length=100)
    level = models.IntegerField(blank=True, null=True, db_column='"Level"')
    parent = models.IntegerField(blank=True, null=True)
    geographiclocationid = models.IntegerField(blank=True, null=True)
    address = models.CharField(max_length=100, blank=True, null=True)
    phone = models.CharField(max_length=40, blank=True, null=True)
    fax = models.CharField(max_length=40, blank=True, null=True)
    groupid = models.IntegerField(blank=True, null=True)
    costcenterid = models.IntegerField(blank=True, null=True)
    impute = models.BooleanField(blank=True, null=True)
    costcenter = models.BooleanField(blank=True, null=True)
    pointofsalesid = models.IntegerField(blank=True, null=True)
    pricetypeid = models.IntegerField(blank=True, null=True)
    pointofsales = models.BooleanField(blank=True, null=True)
    warehouseid = models.IntegerField(blank=True, null=True)
    warehouse = models.BooleanField(blank=True, null=True)
    cashid = models.IntegerField(blank=True, null=True)
    bankaccount = models.CharField(max_length=20, blank=True, null=True)
    bankid = models.IntegerField(blank=True, null=True)
    currencyid = models.IntegerField(blank=True, null=True)
    minimun = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    maximun = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    lastdeposit = models.IntegerField(blank=True, null=True)
    lastcheck = models.IntegerField(blank=True, null=True)
    undelivered = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    cashstatus = models.CharField(max_length=1, blank=True, null=True)
    cash = models.BooleanField(blank=True, null=True)
    responsibleid = models.BigIntegerField(blank=True, null=True)
    assets = models.BooleanField(blank=True, null=True)
    expensetype = models.CharField(max_length=3, blank=True, null=True)
    risk = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    type = models.CharField(max_length=1, blank=True, null=True)
    prefix = models.CharField(max_length=10, blank=True, null=True)
    businessid = models.IntegerField(blank=True, null=True)
    opening = models.DateField(blank=True, null=True)
    closing = models.DateField(blank=True, null=True)
    employees = models.IntegerField(blank=True, null=True)
    area = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    abc = models.CharField(max_length=1, blank=True, null=True)
    clientid = models.BigIntegerField(blank=True, null=True)
    loan = models.BooleanField(blank=True, null=True)
    zone = models.BooleanField(blank=True, null=True)
    branch = models.IntegerField(blank=True, null=True)
    formatbill = models.IntegerField(blank=True, null=True)
    orderbudget = models.CharField(max_length=1, blank=True, null=True)
    packing = models.BooleanField(blank=True, null=True)
    production = models.BooleanField(blank=True, null=True)
    channel = models.BooleanField(blank=True, null=True)
    budgetquantity = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    budgetvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    replication = models.CharField(max_length=30, blank=True, null=True)
    pos = models.BooleanField(blank=True, null=True)
    remote = models.BooleanField(blank=True, null=True)
    channelid = models.IntegerField(blank=True, null=True)
    restriction = models.CharField(max_length=1, blank=True, null=True)
    authorizationlevel = models.IntegerField(blank=True, null=True)
    subsidyoffer = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    conciliation = models.DateField(blank=True, null=True)
    egressformat = models.IntegerField(blank=True, null=True)
    rate = models.CharField(max_length=1, blank=True, null=True)
    entryid = models.IntegerField(blank=True, null=True)
    payroll = models.BooleanField(blank=True, null=True)
    electronic = models.IntegerField(blank=True, null=True)
    generateprice = models.BooleanField(blank=True, null=True)
    automaticconversion = models.BooleanField(blank=True, null=True)
    approvesorder = models.BooleanField(blank=True, null=True)
    wms = models.BooleanField(blank=True, null=True)
    warehousetype = models.CharField(max_length=1, blank=True, null=True)
    fund = models.IntegerField(blank=True, null=True)
    inventorystatus = models.CharField(max_length=1, blank=True, null=True)
    separate = models.BooleanField(blank=True, null=True)
    freeze = models.BooleanField(blank=True, null=True)
    voucher = models.CharField(max_length=3, blank=True, null=True)
    alternatecode = models.CharField(max_length=20, blank=True, null=True)
    clientips = models.BigIntegerField(blank=True, null=True)
    clienteps = models.BigIntegerField(blank=True, null=True)
    clientuser = models.BigIntegerField(blank=True, null=True)
    syncronizationup = models.DateField(blank=True, null=True)
    syncronizationdwm = models.DateField(blank=True, null=True)
    transference = models.CharField(max_length=1, blank=True, null=True)
    dispatchtype = models.CharField(max_length=1, blank=True, null=True)
    activity = models.IntegerField(blank=True, null=True)
    activitysecondary = models.CharField(max_length=30, blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    marketing = models.CharField(max_length=4000, blank=True, null=True)
    resolution = models.CharField(max_length=4000, blank=True, null=True)
    bankaccounttype = models.CharField(max_length=1, blank=True, null=True)
    sourceid = models.IntegerField(blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)
    typepricedepend = models.CharField(max_length=1, blank=True, null=True)
    classificationid = models.BigIntegerField(blank=True, null=True)
    confirmprinted = models.BooleanField(blank=True, null=True)
    dataphone = models.CharField(max_length=1, blank=True, null=True)
    characteristic = models.CharField(max_length=1, blank=True, null=True)
    characteristic1 = models.CharField(max_length=1, blank=True, null=True)
    marketplace = models.BooleanField(blank=True, null=True)
    ecommerce = models.BooleanField(blank=True, null=True)
    onlygenericattributes = models.BooleanField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'location'
        unique_together = (('companyid', 'locationid'),)


class AssociateBalance(models.Model):
    # Set default db
    use_db = "oasis"
    # Set default manager
    objects = managers.AssociateBalance()
    # Field list
    companyid = models.IntegerField(primary_key=True)
    period = models.IntegerField()
    year = models.IntegerField()
    clientid = models.BigIntegerField()
    contributionvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    contributionyearvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    contributiontotalvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    salesvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    receivablesexpiredvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    otherexpiredvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    anticipationexpiredvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    contribution = models.BooleanField(blank=True, null=True)
    contributionyear = models.BooleanField(blank=True, null=True)
    sales = models.BooleanField(blank=True, null=True)
    receivablesexpired = models.BooleanField(blank=True, null=True)
    otherexpired = models.BooleanField(blank=True, null=True)
    anticipationexpired = models.BooleanField(blank=True, null=True)
    able = models.BooleanField(blank=True, null=True)
    cosigner = models.BooleanField(blank=True, null=True)
    purchasefuture = models.BooleanField(blank=True, null=True)
    kiloscoffeegreen = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    almondsound = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    almonddefect = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    areacoffeetotal = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    areacoffeeproductive = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    contributionbalance = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    assembly = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    revaluation = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    solidarity = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    contributionbalancepay = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    observation = models.CharField(max_length=4000, blank=True, null=True)
    billing = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'associatebalance'
        unique_together = (('companyid', 'period', 'year', 'clientid'),)


class Operation(models.Model):
    # Default db
    use_db = "oasis"
    # Default Manager
    objects = managers.Operation()
    # Field list definition
    companyid = models.IntegerField(db_column='companyid', primary_key=True)
    documentid = models.CharField(max_length=3)
    numberid = models.IntegerField()
    locationid = models.IntegerField(db_column='locationid')
    date = models.DateField(blank=True, null=True, db_column='"Date"')
    hour = models.DateField(blank=True, null=True)
    clientid = models.BigIntegerField(blank=True, null=True)
    directionid = models.IntegerField(blank=True, null=True)
    vendorid = models.BigIntegerField(blank=True, null=True)
    conceptid = models.CharField(max_length=3, blank=True, null=True)
    motiveid = models.IntegerField(blank=True, null=True)
    conditionpaymentid = models.IntegerField(blank=True, null=True)
    typepriceid = models.IntegerField(blank=True, null=True)
    discountpercentage = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    discountpercentage2 = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    promptpaymentid = models.IntegerField(blank=True, null=True)
    promptpayment = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    pricetax = models.CharField(max_length=1, blank=True, null=True)
    quantity = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    weight = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    volume = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    brute = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    discount = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    subtotal = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    tax = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    taxsale = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    imco = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    total = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    retention = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    retentiontaxsale = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    retentionica = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    retentioncre = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    net = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    payment = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    change = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    paid = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    totalcost = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    totalsupplier = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    adjustment = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    documentid1 = models.CharField(max_length=3, blank=True, null=True)
    numberid1 = models.IntegerField(blank=True, null=True)
    numberid2 = models.IntegerField(blank=True, null=True)
    numberid3 = models.IntegerField(blank=True, null=True)
    cashid = models.IntegerField(blank=True, null=True)
    warehouseid = models.IntegerField(blank=True, null=True)
    invstate = models.BooleanField(blank=True, null=True)
    inventory = models.BooleanField(blank=True, null=True)
    destinylocationid = models.IntegerField(blank=True, null=True)
    box = models.IntegerField(blank=True, null=True)
    formpaymentid = models.IntegerField(blank=True, null=True)
    confirmdate = models.DateField(blank=True, null=True)
    confirmhour = models.DateField(blank=True, null=True)
    printdate = models.DateField(blank=True, null=True)
    printhour = models.DateField(blank=True, null=True)
    prefix = models.CharField(max_length=10, blank=True, null=True)
    currencyid = models.IntegerField(blank=True, null=True)
    exchangerate = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    saledate = models.DateField(blank=True, null=True)
    quota = models.BooleanField(blank=True, null=True)
    bond = models.BooleanField(blank=True, null=True)
    quotavalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    zoneid = models.IntegerField(blank=True, null=True)
    origin = models.BooleanField(blank=True, null=True)
    totaltranscription = models.IntegerField(blank=True, null=True)
    transcription = models.IntegerField(blank=True, null=True)
    bondvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    bondtax = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    turnid = models.IntegerField(blank=True, null=True)
    freight = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    secure = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    pointsadd = models.IntegerField(blank=True, null=True)
    pointsrest = models.IntegerField(blank=True, null=True)
    vehicleid = models.CharField(max_length=10, blank=True, null=True)
    businessid = models.IntegerField(blank=True, null=True)
    projectid = models.IntegerField(blank=True, null=True)
    affiliateid = models.BigIntegerField(blank=True, null=True)
    documentlocationid = models.IntegerField(blank=True, null=True)
    international = models.BooleanField(blank=True, null=True)
    typedocument = models.CharField(max_length=3, blank=True, null=True)
    documentaffiliate = models.CharField(max_length=20, blank=True, null=True)
    fiscalvoucher = models.CharField(max_length=100, blank=True, null=True)
    billerid = models.BigIntegerField(blank=True, null=True)
    recipe = models.IntegerField(blank=True, null=True)
    formuladate = models.DateField(blank=True, null=True)
    freightnumber = models.IntegerField(blank=True, null=True)
    freightcost = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    routeid = models.IntegerField(blank=True, null=True)
    transporterid = models.BigIntegerField(blank=True, null=True)
    timedelivery = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    printedletter = models.BooleanField(blank=True, null=True)
    statewms = models.CharField(max_length=1, blank=True, null=True)
    numberidpre = models.IntegerField(blank=True, null=True)
    locationidpre = models.IntegerField(blank=True, null=True)
    turnsale = models.IntegerField(blank=True, null=True)
    island = models.IntegerField(blank=True, null=True)
    repetitive = models.BooleanField(blank=True, null=True)
    periods = models.IntegerField(blank=True, null=True)
    executed = models.IntegerField(blank=True, null=True)
    quotacopayment = models.BooleanField(blank=True, null=True)
    tariff = models.CharField(max_length=1, blank=True, null=True)
    copaymentpercentage = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    quotacopaymentdiscriminate = models.BooleanField(blank=True, null=True)
    diagnosticid = models.CharField(max_length=9, blank=True, null=True)
    doctorid = models.BigIntegerField(db_column='doctorid', blank=True, null=True)
    passyear = models.BooleanField(blank=True, null=True)
    changeyear = models.BooleanField(blank=True, null=True)
    synchronized = models.BooleanField(blank=True, null=True)
    codeaccumulate = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    reference1 = models.CharField(max_length=50, blank=True, null=True)
    reference2 = models.CharField(max_length=50, blank=True, null=True)
    domicile = models.BooleanField(blank=True, null=True)
    responsibleid = models.BigIntegerField(blank=True, null=True)
    quotationid = models.IntegerField(blank=True, null=True)
    orderid = models.IntegerField(blank=True, null=True)
    contractid = models.IntegerField(blank=True, null=True)
    contractlocationid = models.IntegerField(blank=True, null=True)
    invoiceid = models.IntegerField(blank=True, null=True)
    locationuseid = models.IntegerField(blank=True, null=True)
    initialdate = models.DateField(blank=True, null=True)
    finaldate = models.DateField(blank=True, null=True)
    plancontract = models.IntegerField(blank=True, null=True)
    policy = models.CharField(max_length=10, blank=True, null=True)
    copayment = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    commission = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    receipt = models.IntegerField(blank=True, null=True)
    highcost = models.BooleanField(blank=True, null=True)
    health = models.BooleanField(blank=True, null=True)
    contractcapited = models.IntegerField(blank=True, null=True)
    sinister = models.IntegerField(blank=True, null=True)
    invoicedate = models.DateField(blank=True, null=True)
    retainpayment = models.BooleanField(blank=True, null=True)
    invoicechar = models.CharField(max_length=15, blank=True, null=True)
    checknumber = models.IntegerField(blank=True, null=True)
    fund = models.IntegerField(blank=True, null=True)
    doclocationid = models.IntegerField(blank=True, null=True)
    retentionif = models.BooleanField(blank=True, null=True)
    reconciled = models.BooleanField(blank=True, null=True)
    reconcileddate = models.DateField(blank=True, null=True)
    anticipation = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    anticipationnumberid = models.IntegerField(blank=True, null=True)
    basepromptpayment = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    pricegenerate = models.BooleanField(blank=True, null=True)
    typeliquidation = models.CharField(max_length=1, blank=True, null=True)
    expensevalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    agreement = models.IntegerField(blank=True, null=True)
    agreementlocationid = models.IntegerField(blank=True, null=True)
    provenance = models.CharField(max_length=80, blank=True, null=True)
    program = models.IntegerField(blank=True, null=True)
    basekilo = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    check_operation = models.BooleanField(blank=True, null=True, db_column='"Check"')
    weightbrute = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    destare = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    weightnet = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    amortize = models.IntegerField(blank=True, null=True)
    seal = models.IntegerField(blank=True, null=True)
    reference = models.CharField(max_length=20, blank=True, null=True)
    credit = models.CharField(max_length=1, blank=True, null=True)
    packing = models.BooleanField(blank=True, null=True)
    lotid = models.CharField(max_length=20, blank=True, null=True)
    documentexpense = models.IntegerField(blank=True, null=True)
    costcenterid = models.IntegerField(blank=True, null=True)
    received = models.BooleanField(blank=True, null=True)
    backorder = models.BooleanField(blank=True, null=True)
    translationdirect = models.BooleanField(blank=True, null=True)
    deliverydate = models.DateField(blank=True, null=True)
    payfreight = models.BooleanField(blank=True, null=True)
    deliverydatemax = models.DateField(blank=True, null=True)
    priority = models.IntegerField(blank=True, null=True)
    consolidated = models.BooleanField(blank=True, null=True)
    dispatch = models.BooleanField(blank=True, null=True)
    dispatchpercentage = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    dispatchvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    separatevalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    separate = models.BooleanField(blank=True, null=True)
    liberation = models.BigIntegerField(blank=True, null=True)
    commercial = models.CharField(max_length=1, blank=True, null=True)
    liberationcommercial = models.BigIntegerField(blank=True, null=True)
    sfa = models.BooleanField(blank=True, null=True)
    consignment = models.BooleanField(blank=True, null=True)
    billingdate = models.DateField(blank=True, null=True)
    fattenig = models.BooleanField(blank=True, null=True)
    picking = models.BooleanField(blank=True, null=True)
    edi = models.BooleanField(blank=True, null=True)
    surety = models.BooleanField(blank=True, null=True)
    suretyexecute = models.BooleanField(blank=True, null=True)
    suretyvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    prorogation = models.DateField(blank=True, null=True)
    daysdelivery = models.IntegerField(blank=True, null=True)
    daysdeliverychar = models.CharField(max_length=100, blank=True, null=True)
    transact = models.DateField(blank=True, null=True)
    budgeting = models.BooleanField(blank=True, null=True)
    entryid = models.BigIntegerField(blank=True, null=True)
    devolutiondate = models.DateField(blank=True, null=True)
    typedelivery = models.CharField(max_length=1, blank=True, null=True)
    bankid = models.IntegerField(blank=True, null=True)
    lettercredit = models.CharField(max_length=20, blank=True, null=True)
    estimated = models.BooleanField(blank=True, null=True)
    verbalacceptance = models.BooleanField(blank=True, null=True)
    authorizeexpense = models.BigIntegerField(blank=True, null=True)
    surveyorid = models.BigIntegerField(blank=True, null=True)
    approves = models.BooleanField(blank=True, null=True)
    accumulate = models.BooleanField(blank=True, null=True)
    approbationdate = models.DateField(blank=True, null=True)
    approbacionby = models.BigIntegerField(blank=True, null=True)
    themeid = models.IntegerField(blank=True, null=True)
    formstart = models.IntegerField(blank=True, null=True)
    applicantid = models.BigIntegerField(blank=True, null=True)
    userid = models.IntegerField(blank=True, null=True)
    incoterms = models.CharField(max_length=3, blank=True, null=True)
    employeeid = models.BigIntegerField(blank=True, null=True)
    guarantee = models.DateField(blank=True, null=True)
    representativeid = models.BigIntegerField(blank=True, null=True)
    purchaseorder = models.CharField(max_length=20, blank=True, null=True)
    periodtype = models.CharField(max_length=1, blank=True, null=True)
    duration = models.IntegerField(blank=True, null=True)
    template = models.IntegerField(blank=True, null=True)
    upc = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    upcpercentage = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    upcaffiliate = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    costadministration = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    sanction = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    otherif = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    coverage = models.CharField(max_length=100, blank=True, null=True)
    assurerid = models.BigIntegerField(blank=True, null=True)
    assured = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    validitypolicy = models.DateField(blank=True, null=True)
    delivery = models.DateField(blank=True, null=True)
    lastinvoice = models.DateField(blank=True, null=True)
    nextinvoice = models.DateField(blank=True, null=True)
    validatesaffiliate = models.BooleanField(blank=True, null=True)
    typecontract = models.CharField(max_length=1, blank=True, null=True)
    cyclebilling = models.CharField(max_length=1, blank=True, null=True)
    renovation = models.CharField(max_length=1, blank=True, null=True)
    increment = models.CharField(max_length=1, blank=True, null=True, db_column='"Increment"')
    incrementvalue = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    renews = models.CharField(max_length=1, blank=True, null=True)
    currency = models.CharField(max_length=1, blank=True, null=True)
    formalitycontract = models.CharField(max_length=1, blank=True, null=True)
    affiliates = models.IntegerField(blank=True, null=True)
    tariffupc = models.IntegerField(blank=True, null=True)
    requirement = models.BigIntegerField(blank=True, null=True)
    forminitiation = models.IntegerField(blank=True, null=True)
    expenseresponsibleid = models.BigIntegerField(blank=True, null=True)
    subscription = models.DateField(blank=True, null=True)
    printed = models.BooleanField(blank=True, null=True)
    mark = models.BooleanField(blank=True, null=True)
    status = models.CharField(max_length=1, blank=True, null=True)
    state = models.CharField(max_length=1, blank=True, null=True)
    updated = models.DateField(blank=True, null=True)
    locationid1 = models.IntegerField(blank=True, null=True)
    contactid = models.BigIntegerField(blank=True, null=True)
    typecontractid = models.IntegerField(blank=True, null=True)
    typetransportid = models.IntegerField(blank=True, null=True)
    countryoriginid = models.IntegerField(blank=True, null=True)
    expiration = models.DateField(blank=True, null=True)
    numbercontract = models.IntegerField(blank=True, null=True)
    locationidcontract = models.IntegerField(blank=True, null=True)
    classificationid = models.BigIntegerField(blank=True, null=True)
    type = models.CharField(max_length=1, blank=True, null=True)
    attention = models.BooleanField(blank=True, null=True)
    responsableid = models.BigIntegerField(blank=True, null=True)
    providerid = models.BigIntegerField(blank=True, null=True)
    diagnostic = models.CharField(max_length=9, blank=True, null=True)
    diagnostic1 = models.CharField(max_length=9, blank=True, null=True)
    diagnostic2 = models.CharField(max_length=9, blank=True, null=True)
    diagnostic3 = models.CharField(max_length=9, blank=True, null=True)
    impute = models.CharField(max_length=1, blank=True, null=True)
    valueimpute = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    class_field = models.CharField(db_column='class', max_length=1, blank=True, null=True)  # Field renamed because it was a Python reserved word.
    programid = models.IntegerField(blank=True, null=True)
    typesolicitude = models.CharField(max_length=1, blank=True, null=True)
    locationsolicitude = models.CharField(max_length=1, blank=True, null=True)
    servicesolicitude = models.CharField(max_length=40, blank=True, null=True)
    numbersolicitude = models.IntegerField(blank=True, null=True)
    datesolicitude = models.DateField(blank=True, null=True)
    hoursolicitude = models.DateField(blank=True, null=True)
    dateacttutelage = models.DateField(blank=True, null=True)
    authorizationmanual = models.BigIntegerField(blank=True, null=True)
    copaymentmanual = models.IntegerField(blank=True, null=True)
    justificationid = models.IntegerField(blank=True, null=True)
    alternatetiveid1 = models.IntegerField(blank=True, null=True)
    alternatetiveid2 = models.IntegerField(blank=True, null=True)
    alternatetiveid3 = models.IntegerField(blank=True, null=True)
    alternatetiveid4 = models.IntegerField(blank=True, null=True)
    modalitycon = models.CharField(max_length=2, blank=True, null=True)
    sinisterid = models.IntegerField(blank=True, null=True)
    typeorigin = models.CharField(max_length=1, blank=True, null=True)
    typepriority = models.CharField(max_length=1, blank=True, null=True)
    formpost = models.CharField(max_length=1, blank=True, null=True)
    shipping = models.DateField(blank=True, null=True)
    shippingentity = models.DateField(blank=True, null=True)
    bill = models.CharField(max_length=17, blank=True, null=True)
    web = models.CharField(max_length=1, blank=True, null=True)
    stateaffiliate = models.CharField(max_length=2, blank=True, null=True)
    typedoctorid = models.IntegerField(blank=True, null=True)
    contractgloss = models.IntegerField(blank=True, null=True)
    typeaffdoctorid = models.IntegerField(blank=True, null=True)
    docdoctor = models.BigIntegerField(blank=True, null=True)
    typedocumentiddoctor = models.CharField(max_length=2, blank=True, null=True)
    statebdua = models.CharField(max_length=2, blank=True, null=True)
    levelsisben = models.IntegerField(blank=True, null=True)
    numbersolicitudeoasis = models.BigIntegerField(blank=True, null=True)
    anticipate = models.BooleanField(blank=True, null=True)
    dateorder = models.DateField(blank=True, null=True)
    filingorder = models.DateField(blank=True, null=True)
    regimen = models.CharField(max_length=1, blank=True, null=True)
    levelcontributory = models.IntegerField(blank=True, null=True)
    concurrence = models.BooleanField(blank=True, null=True)
    filing = models.DateField(blank=True, null=True)
    locationprovider = models.IntegerField(blank=True, null=True)
    confirmby = models.BigIntegerField(blank=True, null=True)
    age = models.CharField(max_length=30, blank=True, null=True)
    dateprovision = models.DateField(blank=True, null=True)
    valuebill = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    geographiclocationid = models.IntegerField(blank=True, null=True)
    ingress = models.DateField(blank=True, null=True)
    originattention = models.CharField(max_length=1, blank=True, null=True)
    typeservice = models.CharField(max_length=1, blank=True, null=True)
    priorityattention = models.CharField(max_length=1, blank=True, null=True)
    typelocationaffiliate = models.CharField(max_length=1, blank=True, null=True)
    codeservice = models.IntegerField(blank=True, null=True)
    subspeciality = models.IntegerField(blank=True, null=True)
    numberbed = models.CharField(max_length=20, blank=True, null=True)
    justificationclinic = models.CharField(max_length=1000, blank=True, null=True)
    documentapplicantid = models.BigIntegerField(blank=True, null=True)
    nameapplicantid = models.CharField(max_length=200, blank=True, null=True)
    phone = models.CharField(max_length=100, blank=True, null=True)
    placeactivity = models.CharField(max_length=500, blank=True, null=True)
    source = models.CharField(max_length=1, blank=True, null=True)
    motive = models.CharField(max_length=1000, blank=True, null=True)
    typeuser = models.CharField(max_length=1, blank=True, null=True)
    notification = models.DateField(blank=True, null=True)
    automatic = models.BooleanField(blank=True, null=True)
    doctor = models.CharField(max_length=100, blank=True, null=True)
    placedoctor = models.CharField(max_length=100, blank=True, null=True)
    motiveannulationid = models.IntegerField(blank=True, null=True)
    sonof = models.BooleanField(blank=True, null=True)
    year = models.IntegerField(blank=True, null=True)
    filed = models.DateField(blank=True, null=True)
    record = models.CharField(max_length=20, blank=True, null=True)
    history = models.CharField(max_length=20, blank=True, null=True)
    ambit = models.CharField(max_length=1, blank=True, null=True)
    objective = models.CharField(max_length=1, blank=True, null=True)
    negation = models.IntegerField(blank=True, null=True)
    locationnegation = models.IntegerField(blank=True, null=True)
    specialidadid = models.IntegerField(blank=True, null=True)
    letterentity = models.BooleanField(blank=True, null=True)
    alfanet = models.BigIntegerField(blank=True, null=True)
    datealfanet = models.DateField(blank=True, null=True)
    datemeeting = models.DateField(blank=True, null=True)
    presolicitude = models.IntegerField(blank=True, null=True)
    locationpresolicitude = models.IntegerField(blank=True, null=True)
    clientideps = models.BigIntegerField(blank=True, null=True)
    clientidips = models.BigIntegerField(blank=True, null=True)
    clientiduser = models.BigIntegerField(blank=True, null=True)
    accepted = models.BooleanField(blank=True, null=True)
    docdocumentid = models.IntegerField(blank=True, null=True)
    meeting = models.IntegerField(blank=True, null=True)
    assessorid = models.BigIntegerField(blank=True, null=True)
    clientidsolicitude = models.BigIntegerField(blank=True, null=True)
    ambitsolicitude = models.CharField(max_length=1, blank=True, null=True)
    numberapprobation = models.IntegerField(blank=True, null=True)
    recovery = models.CharField(max_length=20, blank=True, null=True)
    actioning = models.CharField(max_length=100, blank=True, null=True)
    actioned = models.CharField(max_length=1, blank=True, null=True)
    impugn = models.CharField(max_length=1, blank=True, null=True)
    judgedid = models.IntegerField(blank=True, null=True)
    file = models.IntegerField(blank=True, null=True, db_column='"File"')
    judgement = models.DateField(blank=True, null=True)
    integral = models.BooleanField(blank=True, null=True)
    ctc = models.BooleanField(blank=True, null=True)
    pretensionid = models.IntegerField(blank=True, null=True)
    typedocumentidactioning = models.CharField(max_length=2, blank=True, null=True)
    docactioning = models.CharField(max_length=20, blank=True, null=True)
    nameactioning = models.CharField(max_length=100, blank=True, null=True)
    revoked = models.BooleanField(blank=True, null=True)
    provisional = models.BooleanField(blank=True, null=True)
    deliverysuccessive = models.BooleanField(blank=True, null=True)
    pos = models.BooleanField(blank=True, null=True)
    days = models.IntegerField(blank=True, null=True)
    docnegation = models.CharField(max_length=2, blank=True, null=True)
    dateauto = models.DateField(blank=True, null=True)
    numberjudgement = models.BigIntegerField(blank=True, null=True)
    datesinister = models.DateField(blank=True, null=True)
    policyid = models.IntegerField(blank=True, null=True)
    aviso = models.BooleanField(blank=True, null=True)
    dateaviso = models.DateField(blank=True, null=True)
    numberaviso = models.IntegerField(blank=True, null=True)
    bills = models.IntegerField(blank=True, null=True)
    stateevent = models.CharField(max_length=2, blank=True, null=True)
    deductible = models.BooleanField(blank=True, null=True)
    gloss = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    notapplicable = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    glosssure = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    recovered = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    valuedeductible = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    recover = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    datereport = models.DateField(blank=True, null=True)
    datebirth = models.DateField(blank=True, null=True)
    viaingress = models.CharField(max_length=1, blank=True, null=True)
    houringress = models.DateField(blank=True, null=True)
    parturitioncaesarean = models.BooleanField(blank=True, null=True)
    documentbill = models.CharField(max_length=3, blank=True, null=True)
    numberbill = models.IntegerField(blank=True, null=True)
    locationbill = models.IntegerField(blank=True, null=True)
    quantitydays = models.IntegerField(blank=True, null=True)
    egress = models.DateField(blank=True, null=True)
    typedocumentidresponsable = models.CharField(max_length=2, blank=True, null=True)
    documentidresponsable = models.CharField(max_length=20, blank=True, null=True)
    nameresponsable = models.CharField(max_length=200, blank=True, null=True)
    addressresponsable = models.CharField(max_length=100, blank=True, null=True)
    phoneresponsable = models.CharField(max_length=30, blank=True, null=True)
    geolocationidresponsable = models.IntegerField(blank=True, null=True)
    nameprofessional = models.CharField(max_length=20, blank=True, null=True)
    cellularprofessional = models.CharField(max_length=20, blank=True, null=True)
    phoneprofessional = models.CharField(max_length=20, blank=True, null=True)
    serviceorigin = models.BigIntegerField(blank=True, null=True)
    servicesolicited = models.BigIntegerField(blank=True, null=True)
    typeambulance = models.CharField(max_length=1, blank=True, null=True)
    typetranslation = models.CharField(max_length=1, blank=True, null=True)
    dateambulance = models.DateField(blank=True, null=True)
    dateclose = models.DateField(blank=True, null=True)
    hourclose = models.DateField(blank=True, null=True)
    numberattention = models.IntegerField(blank=True, null=True)
    triage = models.CharField(max_length=1, blank=True, null=True)
    remission = models.BooleanField(blank=True, null=True)
    nameips = models.CharField(max_length=60, blank=True, null=True)
    codehabipsremission = models.CharField(max_length=12, blank=True, null=True)
    locationipsremission = models.IntegerField(blank=True, null=True)
    destination = models.CharField(max_length=2, blank=True, null=True)
    nameinformant = models.CharField(max_length=40, blank=True, null=True)
    placeinformant = models.CharField(max_length=50, blank=True, null=True)
    phoneinformant = models.CharField(max_length=30, blank=True, null=True)
    cellularinformant = models.CharField(max_length=30, blank=True, null=True)
    registerby = models.BigIntegerField(blank=True, null=True)
    nameregister = models.CharField(max_length=40, blank=True, null=True)
    docnumberid = models.BigIntegerField(blank=True, null=True)
    markpre = models.CharField(max_length=1, blank=True, null=True)
    analysis = models.CharField(max_length=4000, blank=True, null=True)
    approbation = models.CharField(max_length=4000, blank=True, null=True)
    description = models.CharField(max_length=4000, blank=True, null=True)
    justification = models.CharField(max_length=4000, blank=True, null=True)
    observation = models.CharField(max_length=4000, blank=True, null=True)
    resume = models.CharField(max_length=4000, blank=True, null=True)
    textapplicant = models.CharField(max_length=4000, blank=True, null=True)
    textapprobation = models.CharField(max_length=4000, blank=True, null=True)
    formula = models.CharField(max_length=20, blank=True, null=True)
    remissioninvoice = models.CharField(max_length=1, blank=True, null=True)
    typedocumentid = models.CharField(max_length=2, blank=True, null=True)
    clientcode = models.CharField(max_length=20, blank=True, null=True)
    firstlastname = models.CharField(max_length=40, blank=True, null=True)
    secondlastname = models.CharField(max_length=30, blank=True, null=True)
    firstfirstname = models.CharField(max_length=40, blank=True, null=True)
    secondfirstname = models.CharField(max_length=30, blank=True, null=True)
    birthdate = models.DateField(blank=True, null=True)
    finaldate1 = models.DateField(blank=True, null=True)
    upcaffiliate1 = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    affiliates1 = models.IntegerField(blank=True, null=True)
    total1 = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    bl = models.CharField(max_length=50, blank=True, null=True)
    containers = models.IntegerField(blank=True, null=True)
    countrydestinyid = models.IntegerField(blank=True, null=True)
    countrypurchaseid = models.IntegerField(blank=True, null=True)
    countryshipmentid = models.IntegerField(blank=True, null=True)
    customsid = models.IntegerField(blank=True, null=True)
    datearrival = models.DateField(blank=True, null=True)
    datebl = models.DateField(blank=True, null=True)
    incotermsid = models.CharField(max_length=3, blank=True, null=True)
    lines = models.IntegerField(blank=True, null=True)
    packages = models.IntegerField(blank=True, null=True)
    portdestiny = models.CharField(max_length=50, blank=True, null=True)
    portshipment = models.CharField(max_length=50, blank=True, null=True)
    vessel = models.CharField(max_length=50, blank=True, null=True)
    equipmentid = models.CharField(max_length=20, blank=True, null=True)
    conductorid = models.BigIntegerField(blank=True, null=True)
    assistantid = models.BigIntegerField(blank=True, null=True)
    guide = models.BigIntegerField(blank=True, null=True)
    weighttare = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    weightloaded = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    counterinitial = models.IntegerField(blank=True, null=True)
    counterfinal = models.IntegerField(blank=True, null=True)
    counter = models.IntegerField(blank=True, null=True)
    stop = models.BooleanField(blank=True, null=True)
    failureid = models.IntegerField(blank=True, null=True)
    causeid = models.IntegerField(blank=True, null=True)
    actionid = models.IntegerField(blank=True, null=True)
    subject = models.CharField(max_length=4000, blank=True, null=True)
    time = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    daterequired = models.DateField(blank=True, null=True)
    hourrequired = models.DateField(blank=True, null=True)
    billto = models.CharField(max_length=1, blank=True, null=True)
    qualification = models.CharField(max_length=1, blank=True, null=True)
    typeoperationid = models.IntegerField(blank=True, null=True)
    lineid = models.IntegerField(blank=True, null=True)
    initialhour = models.DateField(blank=True, null=True)
    finalhour = models.DateField(blank=True, null=True)
    turn = models.IntegerField(blank=True, null=True)
    packingwms = models.BooleanField(blank=True, null=True)
    contractdocumentid = models.CharField(max_length=3, blank=True, null=True)
    priority1 = models.IntegerField(blank=True, null=True)
    sourceid = models.IntegerField(blank=True, null=True)
    dateincapacity = models.DateField(blank=True, null=True)
    dateparturition = models.DateField(blank=True, null=True)
    parturitionmultiple = models.BooleanField(blank=True, null=True)
    weeks = models.IntegerField(blank=True, null=True)
    dateaccident = models.DateField(blank=True, null=True)
    isprorogation = models.BooleanField(blank=True, null=True)
    overlap = models.BooleanField(blank=True, null=True)
    hospitalization = models.BooleanField(blank=True, null=True)
    requirements = models.BooleanField(blank=True, null=True)
    dayspayment = models.IntegerField(blank=True, null=True)
    datepayment = models.DateField(blank=True, null=True)
    sample = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    drift1 = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    drift2 = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    almondsan = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    gramspasilla = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    gramsbroca = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    productid = models.BigIntegerField(blank=True, null=True)
    associate = models.BooleanField(blank=True, null=True)
    quantity1 = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    resourceid = models.BigIntegerField(blank=True, null=True)
    updatedby = models.IntegerField(blank=True, null=True)
    quantityslime = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    paymentid = models.BigIntegerField(blank=True, null=True)
    localizationid = models.CharField(max_length=20, blank=True, null=True)
    xml = models.BinaryField(blank=True, null=True)
    xmlname = models.CharField(max_length=100, blank=True, null=True)
    status1 = models.CharField(max_length=1, blank=True, null=True)
    presales = models.BigIntegerField(blank=True, null=True)
    documentidbudget = models.CharField(max_length=3, blank=True, null=True)
    numberidbudget = models.IntegerField(blank=True, null=True)
    locationidbudget = models.IntegerField(blank=True, null=True)
    budgetyearpass = models.BooleanField(blank=True, null=True)
    budgetyearchanged = models.BooleanField(blank=True, null=True)
    overexecuted = models.CharField(max_length=1, blank=True, null=True)
    contractidfiled = models.BigIntegerField(blank=True, null=True)
    docdocumentcid = models.CharField(max_length=3, blank=True, null=True)
    approbationreceivablehourlocal = models.DateField(blank=True, null=True)
    approbationcomercialhourlocal = models.DateField(blank=True, null=True)
    productid1 = models.BigIntegerField(blank=True, null=True)
    productid2 = models.BigIntegerField(blank=True, null=True)
    productid3 = models.BigIntegerField(blank=True, null=True)
    emailprofessional = models.CharField(max_length=50, blank=True, null=True)
    modetranslation = models.CharField(max_length=1, blank=True, null=True)
    public = models.BooleanField(blank=True, null=True, db_column='"Public"')
    sequestration = models.BooleanField(blank=True, null=True)
    translape = models.BooleanField(blank=True, null=True)
    daysprorogation = models.IntegerField(blank=True, null=True)
    cashonly = models.BooleanField(blank=True, null=True)
    transporterfreight = models.DecimalField(max_digits=19, decimal_places=4, blank=True, null=True)
    license = models.IntegerField(blank=True, null=True)
    cdp = models.IntegerField(blank=True, null=True)
    planningweek = models.IntegerField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'operation'
        unique_together = (('companyid', 'documentid', 'numberid', 'locationid'),)
