# Generated by Django 4.1.7 on 2023-03-04 03:34

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import oasis.coffee_offers.lib.validators.date_validators
import oasis.coffee_offers.lib.validators.oasis_statuses


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('oasis', '0010_operation'),
    ]

    operations = [
        migrations.CreateModel(
            name='Offer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='Modified at')),
                ('contract', models.IntegerField(verbose_name='Contract No')),
                ('kg_offered', models.DecimalField(decimal_places=2, max_digits=9, verbose_name='Kg Offered')),
                ('kg_received', models.DecimalField(decimal_places=2, default=0, max_digits=9, verbose_name='Kg Received')),
                ('status', models.IntegerField(choices=[(0, 'New'), (1, 'Approved'), (2, 'Signed'), (3, 'Partial'), (4, 'Finished'), (9, 'Rejected')], default=0, verbose_name='Status')),
                ('delivery_date', models.DateField(validators=[oasis.coffee_offers.lib.validators.date_validators.greater_than_today], verbose_name='Delivery Date')),
            ],
        ),
        migrations.CreateModel(
            name='StateMachine',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('state', models.IntegerField(choices=[(0, 'New'), (1, 'Approved'), (2, 'Signed'), (3, 'Partial'), (4, 'Finished'), (9, 'Rejected')], default=0, verbose_name='State')),
                ('from_state', models.IntegerField(blank=True, choices=[(0, 'New'), (1, 'Approved'), (2, 'Signed'), (3, 'Partial'), (4, 'Finished'), (9, 'Rejected')], null=True, verbose_name='From State')),
                ('oasis_state', models.CharField(max_length=1, verbose_name='Oasis State')),
                ('oasis_status', models.CharField(max_length=1, validators=[oasis.coffee_offers.lib.validators.oasis_statuses.validate_oasis_statuses], verbose_name='Oasis Status')),
                ('notify_user', models.BooleanField(default=True, verbose_name='Notify User')),
                ('notify_coffee_area', models.BooleanField(default=False, verbose_name='Notify Coffee Area')),
                ('notify_legal_area', models.BooleanField(default=False, verbose_name='Notify Legal Area')),
            ],
        ),
        migrations.AddConstraint(
            model_name='statemachine',
            constraint=models.UniqueConstraint(fields=('state', 'from_state'), name='UNQ_CoffeeOffer_StateMachine'),
        ),
        migrations.AddField(
            model_name='offer',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='oasis.product', verbose_name='Product'),
        ),
        migrations.AddField(
            model_name='offer',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='offers', related_query_name='user', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='offer',
            name='warehouse',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_query_name='warehouses', to='oasis.coffeewarehouse', verbose_name='Warehouse'),
        ),
        migrations.AddConstraint(
            model_name='offer',
            constraint=models.UniqueConstraint(fields=('contract',), name='UNQ_Offer_Contract'),
        ),
    ]
