# Generated by Django 4.1.7 on 2023-02-23 14:51

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('oasis', '0007_cycle'),
    ]

    operations = [
        migrations.CreateModel(
            name='Location',
            fields=[
                ('companyid', models.IntegerField(primary_key=True, serialize=False)),
                ('locationid', models.IntegerField()),
                ('locationname', models.CharField(max_length=100)),
                ('level', models.IntegerField(blank=True, db_column='Level', null=True)),
                ('parent', models.IntegerField(blank=True, null=True)),
                ('geographiclocationid', models.IntegerField(blank=True, null=True)),
                ('address', models.CharField(blank=True, max_length=100, null=True)),
                ('phone', models.CharField(blank=True, max_length=40, null=True)),
                ('fax', models.CharField(blank=True, max_length=40, null=True)),
                ('groupid', models.IntegerField(blank=True, null=True)),
                ('costcenterid', models.IntegerField(blank=True, null=True)),
                ('impute', models.BooleanField(blank=True, null=True)),
                ('costcenter', models.BooleanField(blank=True, null=True)),
                ('pointofsalesid', models.IntegerField(blank=True, null=True)),
                ('pricetypeid', models.IntegerField(blank=True, null=True)),
                ('pointofsales', models.BooleanField(blank=True, null=True)),
                ('warehouseid', models.IntegerField(blank=True, null=True)),
                ('warehouse', models.BooleanField(blank=True, null=True)),
                ('cashid', models.IntegerField(blank=True, null=True)),
                ('bankaccount', models.CharField(blank=True, max_length=20, null=True)),
                ('bankid', models.IntegerField(blank=True, null=True)),
                ('currencyid', models.IntegerField(blank=True, null=True)),
                ('minimun', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('maximun', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('lastdeposit', models.IntegerField(blank=True, null=True)),
                ('lastcheck', models.IntegerField(blank=True, null=True)),
                ('undelivered', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('cashstatus', models.CharField(blank=True, max_length=1, null=True)),
                ('cash', models.BooleanField(blank=True, null=True)),
                ('responsibleid', models.BigIntegerField(blank=True, null=True)),
                ('assets', models.BooleanField(blank=True, null=True)),
                ('expensetype', models.CharField(blank=True, max_length=3, null=True)),
                ('risk', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('type', models.CharField(blank=True, max_length=1, null=True)),
                ('prefix', models.CharField(blank=True, max_length=10, null=True)),
                ('businessid', models.IntegerField(blank=True, null=True)),
                ('opening', models.DateField(blank=True, null=True)),
                ('closing', models.DateField(blank=True, null=True)),
                ('employees', models.IntegerField(blank=True, null=True)),
                ('area', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('abc', models.CharField(blank=True, max_length=1, null=True)),
                ('clientid', models.BigIntegerField(blank=True, null=True)),
                ('loan', models.BooleanField(blank=True, null=True)),
                ('zone', models.BooleanField(blank=True, null=True)),
                ('branch', models.IntegerField(blank=True, null=True)),
                ('formatbill', models.IntegerField(blank=True, null=True)),
                ('orderbudget', models.CharField(blank=True, max_length=1, null=True)),
                ('packing', models.BooleanField(blank=True, null=True)),
                ('production', models.BooleanField(blank=True, null=True)),
                ('channel', models.BooleanField(blank=True, null=True)),
                ('budgetquantity', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('budgetvalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('replication', models.CharField(blank=True, max_length=30, null=True)),
                ('pos', models.BooleanField(blank=True, null=True)),
                ('remote', models.BooleanField(blank=True, null=True)),
                ('channelid', models.IntegerField(blank=True, null=True)),
                ('restriction', models.CharField(blank=True, max_length=1, null=True)),
                ('authorizationlevel', models.IntegerField(blank=True, null=True)),
                ('subsidyoffer', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('conciliation', models.DateField(blank=True, null=True)),
                ('egressformat', models.IntegerField(blank=True, null=True)),
                ('rate', models.CharField(blank=True, max_length=1, null=True)),
                ('entryid', models.IntegerField(blank=True, null=True)),
                ('payroll', models.BooleanField(blank=True, null=True)),
                ('electronic', models.IntegerField(blank=True, null=True)),
                ('generateprice', models.BooleanField(blank=True, null=True)),
                ('automaticconversion', models.BooleanField(blank=True, null=True)),
                ('approvesorder', models.BooleanField(blank=True, null=True)),
                ('wms', models.BooleanField(blank=True, null=True)),
                ('warehousetype', models.CharField(blank=True, max_length=1, null=True)),
                ('fund', models.IntegerField(blank=True, null=True)),
                ('inventorystatus', models.CharField(blank=True, max_length=1, null=True)),
                ('separate', models.BooleanField(blank=True, null=True)),
                ('freeze', models.BooleanField(blank=True, null=True)),
                ('voucher', models.CharField(blank=True, max_length=3, null=True)),
                ('alternatecode', models.CharField(blank=True, max_length=20, null=True)),
                ('clientips', models.BigIntegerField(blank=True, null=True)),
                ('clienteps', models.BigIntegerField(blank=True, null=True)),
                ('clientuser', models.BigIntegerField(blank=True, null=True)),
                ('syncronizationup', models.DateField(blank=True, null=True)),
                ('syncronizationdwm', models.DateField(blank=True, null=True)),
                ('transference', models.CharField(blank=True, max_length=1, null=True)),
                ('dispatchtype', models.CharField(blank=True, max_length=1, null=True)),
                ('activity', models.IntegerField(blank=True, null=True)),
                ('activitysecondary', models.CharField(blank=True, max_length=30, null=True)),
                ('updated', models.DateField(blank=True, null=True)),
                ('marketing', models.CharField(blank=True, max_length=4000, null=True)),
                ('resolution', models.CharField(blank=True, max_length=4000, null=True)),
                ('bankaccounttype', models.CharField(blank=True, max_length=1, null=True)),
                ('sourceid', models.IntegerField(blank=True, null=True)),
                ('updatedby', models.IntegerField(blank=True, null=True)),
                ('typepricedepend', models.CharField(blank=True, max_length=1, null=True)),
                ('classificationid', models.BigIntegerField(blank=True, null=True)),
                ('confirmprinted', models.BooleanField(blank=True, null=True)),
                ('dataphone', models.CharField(blank=True, max_length=1, null=True)),
                ('characteristic', models.CharField(blank=True, max_length=1, null=True)),
                ('characteristic1', models.CharField(blank=True, max_length=1, null=True)),
                ('marketplace', models.BooleanField(blank=True, null=True)),
                ('ecommerce', models.BooleanField(blank=True, null=True)),
                ('onlygenericattributes', models.BooleanField(blank=True, null=True)),
            ],
            options={
                'db_table': 'location',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='CoffeeWareHouse',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('location_id', models.IntegerField(verbose_name='Location ID')),
                ('location_name', models.CharField(max_length=150, verbose_name='Location Name')),
            ],
        ),
        migrations.AddIndex(
            model_name='coffeewarehouse',
            index=models.Index(fields=['location_name'], name='IDX_coffee_ware_house_location'),
        ),
        migrations.AddConstraint(
            model_name='coffeewarehouse',
            constraint=models.UniqueConstraint(fields=('location_id',), name='UNQ_coffee_ware_house_location_id'),
        ),
    ]
