(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["compareRuns"],{

/***/ "./node_modules/3d-view/view.js":
/*!**************************************!*\
  !*** ./node_modules/3d-view/view.js ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = createViewController\n\nvar createTurntable = __webpack_require__(/*! turntable-camera-controller */ \"./node_modules/turntable-camera-controller/turntable.js\")\nvar createOrbit     = __webpack_require__(/*! orbit-camera-controller */ \"./node_modules/orbit-camera-controller/orbit.js\")\nvar createMatrix    = __webpack_require__(/*! matrix-camera-controller */ \"./node_modules/matrix-camera-controller/matrix.js\")\n\nfunction ViewController(controllers, mode) {\n  this._controllerNames = Object.keys(controllers)\n  this._controllerList = this._controllerNames.map(function(n) {\n    return controllers[n]\n  })\n  this._mode   = mode\n  this._active = controllers[mode]\n  if(!this._active) {\n    this._mode   = 'turntable'\n    this._active = controllers.turntable\n  }\n  this.modes = this._controllerNames\n  this.computedMatrix = this._active.computedMatrix\n  this.computedEye    = this._active.computedEye\n  this.computedUp     = this._active.computedUp\n  this.computedCenter = this._active.computedCenter\n  this.computedRadius = this._active.computedRadius\n}\n\nvar proto = ViewController.prototype\n\nvar COMMON_METHODS = [\n  ['flush', 1],\n  ['idle', 1],\n  ['lookAt', 4],\n  ['rotate', 4],\n  ['pan', 4],\n  ['translate', 4],\n  ['setMatrix', 2],\n  ['setDistanceLimits', 2],\n  ['setDistance', 2]\n]\n\nCOMMON_METHODS.forEach(function(method) {\n  var name = method[0]\n  var argNames = []\n  for(var i=0; i<method[1]; ++i) {\n    argNames.push('a'+i)\n  }\n  var code = 'var cc=this._controllerList;for(var i=0;i<cc.length;++i){cc[i].'+method[0]+'('+argNames.join()+')}'\n  proto[name] = Function.apply(null, argNames.concat(code))\n})\n\nproto.recalcMatrix = function(t) {\n  this._active.recalcMatrix(t)\n}\n\nproto.getDistance = function(t) {\n  return this._active.getDistance(t)\n}\nproto.getDistanceLimits = function(out) {\n  return this._active.getDistanceLimits(out)\n}\n\nproto.lastT = function() {\n  return this._active.lastT()\n}\n\nproto.setMode = function(mode) {\n  if(mode === this._mode) {\n    return\n  }\n  var idx = this._controllerNames.indexOf(mode)\n  if(idx < 0) {\n    return\n  }\n  var prev  = this._active\n  var next  = this._controllerList[idx]\n  var lastT = Math.max(prev.lastT(), next.lastT())\n\n  prev.recalcMatrix(lastT)\n  next.setMatrix(lastT, prev.computedMatrix)\n  \n  this._active = next\n  this._mode   = mode\n\n  //Update matrix properties\n  this.computedMatrix = this._active.computedMatrix\n  this.computedEye    = this._active.computedEye\n  this.computedUp     = this._active.computedUp\n  this.computedCenter = this._active.computedCenter\n  this.computedRadius = this._active.computedRadius\n}\n\nproto.getMode = function() {\n  return this._mode\n}\n\nfunction createViewController(options) {\n  options = options || {}\n\n  var eye       = options.eye    || [0,0,1]\n  var center    = options.center || [0,0,0]\n  var up        = options.up     || [0,1,0]\n  var limits    = options.distanceLimits || [0, Infinity]\n  var mode      = options.mode   || 'turntable'\n\n  var turntable = createTurntable()\n  var orbit     = createOrbit()\n  var matrix    = createMatrix()\n\n  turntable.setDistanceLimits(limits[0], limits[1])\n  turntable.lookAt(0, eye, center, up)\n  orbit.setDistanceLimits(limits[0], limits[1])\n  orbit.lookAt(0, eye, center, up)\n  matrix.setDistanceLimits(limits[0], limits[1])\n  matrix.lookAt(0, eye, center, up)\n\n  return new ViewController({\n    turntable: turntable,\n    orbit: orbit,\n    matrix: matrix\n  }, mode)\n}\n\n//# sourceURL=webpack:///./node_modules/3d-view/view.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/dist/d3-sankey-circular.es.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/dist/d3-sankey-circular.es.js ***!
  \*******************************************************************************/
/*! exports provided: sankeyCircular, sankeyCenter, sankeyLeft, sankeyRight, sankeyJustify */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sankeyCircular\", function() { return sankeyCircular; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sankeyCenter\", function() { return center; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sankeyLeft\", function() { return left; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sankeyRight\", function() { return right; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sankeyJustify\", function() { return justify; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/index.js\");\n/* harmony import */ var d3_collection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-collection */ \"./node_modules/d3-collection/src/index.js\");\n/* harmony import */ var d3_shape__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-shape */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/index.js\");\n/* harmony import */ var elementary_circuits_directed_graph__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! elementary-circuits-directed-graph */ \"./node_modules/elementary-circuits-directed-graph/johnson.js\");\n/* harmony import */ var elementary_circuits_directed_graph__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(elementary_circuits_directed_graph__WEBPACK_IMPORTED_MODULE_3__);\n\n\n\n\n\n// For a given link, return the target node's depth\nfunction targetDepth(d) {\n  return d.target.depth;\n}\n\n// The depth of a node when the nodeAlign (align) is set to 'left'\nfunction left(node) {\n  return node.depth;\n}\n\n// The depth of a node when the nodeAlign (align) is set to 'right'\nfunction right(node, n) {\n  return n - 1 - node.height;\n}\n\n// The depth of a node when the nodeAlign (align) is set to 'justify'\nfunction justify(node, n) {\n  return node.sourceLinks.length ? node.depth : n - 1;\n}\n\n// The depth of a node when the nodeAlign (align) is set to 'center'\nfunction center(node) {\n  return node.targetLinks.length ? node.depth : node.sourceLinks.length ? Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"min\"])(node.sourceLinks, targetDepth) - 1 : 0;\n}\n\n// returns a function, using the parameter given to the sankey setting\nfunction constant(x) {\n  return function () {\n    return x;\n  };\n}\n\nvar _typeof = typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\" ? function (obj) {\n  return typeof obj;\n} : function (obj) {\n  return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj;\n};\n\n/// https://github.com/tomshanley/d3-sankeyCircular-circular\n\n// sort links' breadth (ie top to bottom in a column), based on their source nodes' breadths\nfunction ascendingSourceBreadth(a, b) {\n  return ascendingBreadth(a.source, b.source) || a.index - b.index;\n}\n\n// sort links' breadth (ie top to bottom in a column), based on their target nodes' breadths\nfunction ascendingTargetBreadth(a, b) {\n  return ascendingBreadth(a.target, b.target) || a.index - b.index;\n}\n\n// sort nodes' breadth (ie top to bottom in a column)\n// if both nodes have circular links, or both don't have circular links, then sort by the top (y0) of the node\n// else push nodes that have top circular links to the top, and nodes that have bottom circular links to the bottom\nfunction ascendingBreadth(a, b) {\n  if (a.partOfCycle === b.partOfCycle) {\n    return a.y0 - b.y0;\n  } else {\n    if (a.circularLinkType === 'top' || b.circularLinkType === 'bottom') {\n      return -1;\n    } else {\n      return 1;\n    }\n  }\n}\n\n// return the value of a node or link\nfunction value(d) {\n  return d.value;\n}\n\n// return the vertical center of a node\nfunction nodeCenter(node) {\n  return (node.y0 + node.y1) / 2;\n}\n\n// return the vertical center of a link's source node\nfunction linkSourceCenter(link) {\n  return nodeCenter(link.source);\n}\n\n// return the vertical center of a link's target node\nfunction linkTargetCenter(link) {\n  return nodeCenter(link.target);\n}\n\n// Return the default value for ID for node, d.index\nfunction defaultId(d) {\n  return d.index;\n}\n\n// Return the default object the graph's nodes, graph.nodes\nfunction defaultNodes(graph) {\n  return graph.nodes;\n}\n\n// Return the default object the graph's nodes, graph.links\nfunction defaultLinks(graph) {\n  return graph.links;\n}\n\n// Return the node from the collection that matches the provided ID, or throw an error if no match\nfunction find(nodeById, id) {\n  var node = nodeById.get(id);\n  if (!node) throw new Error('missing: ' + id);\n  return node;\n}\n\nfunction getNodeID(node, id) {\n  return id(node);\n}\n\n// The main sankeyCircular functions\n\n// Some constants for circular link calculations\nvar verticalMargin = 25;\nvar baseRadius = 10;\nvar scale = 0.3; //Possibly let user control this, although anything over 0.5 starts to get too cramped\n\nfunction sankeyCircular () {\n  // Set the default values\n  var x0 = 0,\n      y0 = 0,\n      x1 = 1,\n      y1 = 1,\n      // extent\n  dx = 24,\n      // nodeWidth\n  py,\n      // nodePadding, for vertical postioning\n  id = defaultId,\n      align = justify,\n      nodes = defaultNodes,\n      links = defaultLinks,\n      iterations = 32,\n      circularLinkGap = 2,\n      paddingRatio,\n      sortNodes = null;\n\n  function sankeyCircular() {\n    var graph = {\n      nodes: nodes.apply(null, arguments),\n      links: links.apply(null, arguments)\n\n      // Process the graph's nodes and links, setting their positions\n\n      // 1.  Associate the nodes with their respective links, and vice versa\n    };computeNodeLinks(graph);\n\n    // 2.  Determine which links result in a circular path in the graph\n    identifyCircles(graph, id, sortNodes);\n\n    // 4. Calculate the nodes' values, based on the values of the incoming and outgoing links\n    computeNodeValues(graph);\n\n    // 5.  Calculate the nodes' depth based on the incoming and outgoing links\n    //     Sets the nodes':\n    //     - depth:  the depth in the graph\n    //     - column: the depth (0, 1, 2, etc), as is relates to visual position from left to right\n    //     - x0, x1: the x coordinates, as is relates to visual position from left to right\n    computeNodeDepths(graph);\n\n    // 3.  Determine how the circular links will be drawn,\n    //     either travelling back above the main chart (\"top\")\n    //     or below the main chart (\"bottom\")\n    selectCircularLinkTypes(graph, id);\n\n    // 6.  Calculate the nodes' and links' vertical position within their respective column\n    //     Also readjusts sankeyCircular size if circular links are needed, and node x's\n    computeNodeBreadths(graph, iterations, id);\n    computeLinkBreadths(graph);\n\n    // 7.  Sort links per node, based on the links' source/target nodes' breadths\n    // 8.  Adjust nodes that overlap links that span 2+ columns\n    var linkSortingIterations = 4; //Possibly let user control this number, like the iterations over node placement\n    for (var iteration = 0; iteration < linkSortingIterations; iteration++) {\n\n      sortSourceLinks(graph, y1, id);\n      sortTargetLinks(graph, y1, id);\n      resolveNodeLinkOverlaps(graph, y0, y1, id);\n      sortSourceLinks(graph, y1, id);\n      sortTargetLinks(graph, y1, id);\n    }\n\n    // 8.1  Adjust node and link positions back to fill height of chart area if compressed\n    fillHeight(graph, y0, y1);\n\n    // 9. Calculate visually appealling path for the circular paths, and create the \"d\" string\n    addCircularPathData(graph, circularLinkGap, y1, id);\n\n    return graph;\n  } // end of sankeyCircular function\n\n\n  // Set the sankeyCircular parameters\n  // nodeID, nodeAlign, nodeWidth, nodePadding, nodes, links, size, extent, iterations, nodePaddingRatio, circularLinkGap\n  sankeyCircular.nodeId = function (_) {\n    return arguments.length ? (id = typeof _ === 'function' ? _ : constant(_), sankeyCircular) : id;\n  };\n\n  sankeyCircular.nodeAlign = function (_) {\n    return arguments.length ? (align = typeof _ === 'function' ? _ : constant(_), sankeyCircular) : align;\n  };\n\n  sankeyCircular.nodeWidth = function (_) {\n    return arguments.length ? (dx = +_, sankeyCircular) : dx;\n  };\n\n  sankeyCircular.nodePadding = function (_) {\n    return arguments.length ? (py = +_, sankeyCircular) : py;\n  };\n\n  sankeyCircular.nodes = function (_) {\n    return arguments.length ? (nodes = typeof _ === 'function' ? _ : constant(_), sankeyCircular) : nodes;\n  };\n\n  sankeyCircular.links = function (_) {\n    return arguments.length ? (links = typeof _ === 'function' ? _ : constant(_), sankeyCircular) : links;\n  };\n\n  sankeyCircular.size = function (_) {\n    return arguments.length ? (x0 = y0 = 0, x1 = +_[0], y1 = +_[1], sankeyCircular) : [x1 - x0, y1 - y0];\n  };\n\n  sankeyCircular.extent = function (_) {\n    return arguments.length ? (x0 = +_[0][0], x1 = +_[1][0], y0 = +_[0][1], y1 = +_[1][1], sankeyCircular) : [[x0, y0], [x1, y1]];\n  };\n\n  sankeyCircular.iterations = function (_) {\n    return arguments.length ? (iterations = +_, sankeyCircular) : iterations;\n  };\n\n  sankeyCircular.circularLinkGap = function (_) {\n    return arguments.length ? (circularLinkGap = +_, sankeyCircular) : circularLinkGap;\n  };\n\n  sankeyCircular.nodePaddingRatio = function (_) {\n    return arguments.length ? (paddingRatio = +_, sankeyCircular) : paddingRatio;\n  };\n\n  sankeyCircular.sortNodes = function (_) {\n    return arguments.length ? (sortNodes = _, sankeyCircular) : sortNodes;\n  };\n\n  sankeyCircular.update = function (graph) {\n    // 5.  Calculate the nodes' depth based on the incoming and outgoing links\n    //     Sets the nodes':\n    //     - depth:  the depth in the graph\n    //     - column: the depth (0, 1, 2, etc), as is relates to visual position from left to right\n    //     - x0, x1: the x coordinates, as is relates to visual position from left to right\n    // computeNodeDepths(graph)\n\n    // 3.  Determine how the circular links will be drawn,\n    //     either travelling back above the main chart (\"top\")\n    //     or below the main chart (\"bottom\")\n    selectCircularLinkTypes(graph, id);\n\n    // 6.  Calculate the nodes' and links' vertical position within their respective column\n    //     Also readjusts sankeyCircular size if circular links are needed, and node x's\n    // computeNodeBreadths(graph, iterations, id)\n    computeLinkBreadths(graph);\n\n    // Force position of circular link type based on position\n    graph.links.forEach(function (link) {\n      if (link.circular) {\n        link.circularLinkType = link.y0 + link.y1 < y1 ? 'top' : 'bottom';\n\n        link.source.circularLinkType = link.circularLinkType;\n        link.target.circularLinkType = link.circularLinkType;\n      }\n    });\n\n    sortSourceLinks(graph, y1, id, false); // Sort links but do not move nodes\n    sortTargetLinks(graph, y1, id);\n\n    // 7.  Sort links per node, based on the links' source/target nodes' breadths\n    // 8.  Adjust nodes that overlap links that span 2+ columns\n    // var linkSortingIterations = 4; //Possibly let user control this number, like the iterations over node placement\n    // for (var iteration = 0; iteration < linkSortingIterations; iteration++) {\n    //\n    //   sortSourceLinks(graph, y1, id)\n    //   sortTargetLinks(graph, y1, id)\n    //   resolveNodeLinkOverlaps(graph, y0, y1, id)\n    //   sortSourceLinks(graph, y1, id)\n    //   sortTargetLinks(graph, y1, id)\n    //\n    // }\n\n    // 8.1  Adjust node and link positions back to fill height of chart area if compressed\n    // fillHeight(graph, y0, y1)\n\n    // 9. Calculate visually appealling path for the circular paths, and create the \"d\" string\n    addCircularPathData(graph, circularLinkGap, y1, id);\n    return graph;\n  };\n\n  // Populate the sourceLinks and targetLinks for each node.\n  // Also, if the source and target are not objects, assume they are indices.\n  function computeNodeLinks(graph) {\n    graph.nodes.forEach(function (node, i) {\n      node.index = i;\n      node.sourceLinks = [];\n      node.targetLinks = [];\n    });\n    var nodeById = Object(d3_collection__WEBPACK_IMPORTED_MODULE_1__[\"map\"])(graph.nodes, id);\n    graph.links.forEach(function (link, i) {\n      link.index = i;\n      var source = link.source;\n      var target = link.target;\n      if ((typeof source === \"undefined\" ? \"undefined\" : _typeof(source)) !== 'object') {\n        source = link.source = find(nodeById, source);\n      }\n      if ((typeof target === \"undefined\" ? \"undefined\" : _typeof(target)) !== 'object') {\n        target = link.target = find(nodeById, target);\n      }\n      source.sourceLinks.push(link);\n      target.targetLinks.push(link);\n    });\n    return graph;\n  }\n\n  // Compute the value (size) and cycleness of each node by summing the associated links.\n  function computeNodeValues(graph) {\n    graph.nodes.forEach(function (node) {\n      node.partOfCycle = false;\n      node.value = Math.max(Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"sum\"])(node.sourceLinks, value), Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"sum\"])(node.targetLinks, value));\n      node.sourceLinks.forEach(function (link) {\n        if (link.circular) {\n          node.partOfCycle = true;\n          node.circularLinkType = link.circularLinkType;\n        }\n      });\n      node.targetLinks.forEach(function (link) {\n        if (link.circular) {\n          node.partOfCycle = true;\n          node.circularLinkType = link.circularLinkType;\n        }\n      });\n    });\n  }\n\n  function getCircleMargins(graph) {\n    var totalTopLinksWidth = 0,\n        totalBottomLinksWidth = 0,\n        totalRightLinksWidth = 0,\n        totalLeftLinksWidth = 0;\n\n    var maxColumn = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"max\"])(graph.nodes, function (node) {\n      return node.column;\n    });\n\n    graph.links.forEach(function (link) {\n      if (link.circular) {\n        if (link.circularLinkType == 'top') {\n          totalTopLinksWidth = totalTopLinksWidth + link.width;\n        } else {\n          totalBottomLinksWidth = totalBottomLinksWidth + link.width;\n        }\n\n        if (link.target.column == 0) {\n          totalLeftLinksWidth = totalLeftLinksWidth + link.width;\n        }\n\n        if (link.source.column == maxColumn) {\n          totalRightLinksWidth = totalRightLinksWidth + link.width;\n        }\n      }\n    });\n\n    //account for radius of curves and padding between links\n    totalTopLinksWidth = totalTopLinksWidth > 0 ? totalTopLinksWidth + verticalMargin + baseRadius : totalTopLinksWidth;\n    totalBottomLinksWidth = totalBottomLinksWidth > 0 ? totalBottomLinksWidth + verticalMargin + baseRadius : totalBottomLinksWidth;\n    totalRightLinksWidth = totalRightLinksWidth > 0 ? totalRightLinksWidth + verticalMargin + baseRadius : totalRightLinksWidth;\n    totalLeftLinksWidth = totalLeftLinksWidth > 0 ? totalLeftLinksWidth + verticalMargin + baseRadius : totalLeftLinksWidth;\n\n    return { \"top\": totalTopLinksWidth, \"bottom\": totalBottomLinksWidth, \"left\": totalLeftLinksWidth, \"right\": totalRightLinksWidth };\n  }\n\n  // Update the x0, y0, x1 and y1 for the sankeyCircular, to allow space for any circular links\n  function scaleSankeySize(graph, margin) {\n\n    var maxColumn = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"max\"])(graph.nodes, function (node) {\n      return node.column;\n    });\n\n    var currentWidth = x1 - x0;\n    var currentHeight = y1 - y0;\n\n    var newWidth = currentWidth + margin.right + margin.left;\n    var newHeight = currentHeight + margin.top + margin.bottom;\n\n    var scaleX = currentWidth / newWidth;\n    var scaleY = currentHeight / newHeight;\n\n    x0 = x0 * scaleX + margin.left;\n    x1 = margin.right == 0 ? x1 : x1 * scaleX;\n    y0 = y0 * scaleY + margin.top;\n    y1 = y1 * scaleY;\n\n    graph.nodes.forEach(function (node) {\n      node.x0 = x0 + node.column * ((x1 - x0 - dx) / maxColumn);\n      node.x1 = node.x0 + dx;\n    });\n\n    return scaleY;\n  }\n\n  // Iteratively assign the depth for each node.\n  // Nodes are assigned the maximum depth of incoming neighbors plus one;\n  // nodes with no incoming links are assigned depth zero, while\n  // nodes with no outgoing links are assigned the maximum depth.\n  function computeNodeDepths(graph) {\n    var nodes, next, x;\n\n    for (nodes = graph.nodes, next = [], x = 0; nodes.length; ++x, nodes = next, next = []) {\n      nodes.forEach(function (node) {\n        node.depth = x;\n        node.sourceLinks.forEach(function (link) {\n          if (next.indexOf(link.target) < 0 && !link.circular) {\n            next.push(link.target);\n          }\n        });\n      });\n    }\n\n    for (nodes = graph.nodes, next = [], x = 0; nodes.length; ++x, nodes = next, next = []) {\n      nodes.forEach(function (node) {\n        node.height = x;\n        node.targetLinks.forEach(function (link) {\n          if (next.indexOf(link.source) < 0 && !link.circular) {\n            next.push(link.source);\n          }\n        });\n      });\n    }\n\n    // assign column numbers, and get max value\n    graph.nodes.forEach(function (node) {\n      node.column = Math.floor(align.call(null, node, x));\n    });\n  }\n\n  // Assign nodes' breadths, and then shift nodes that overlap (resolveCollisions)\n  function computeNodeBreadths(graph, iterations, id) {\n    var columns = Object(d3_collection__WEBPACK_IMPORTED_MODULE_1__[\"nest\"])().key(function (d) {\n      return d.column;\n    }).sortKeys(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"ascending\"]).entries(graph.nodes).map(function (d) {\n      return d.values;\n    });\n\n    initializeNodeBreadth(id);\n    resolveCollisions();\n\n    for (var alpha = 1, n = iterations; n > 0; --n) {\n      relaxLeftAndRight(alpha *= 0.99, id);\n      resolveCollisions();\n    }\n\n    function initializeNodeBreadth(id) {\n\n      //override py if nodePadding has been set\n      if (paddingRatio) {\n        var padding = Infinity;\n        columns.forEach(function (nodes) {\n          var thisPadding = y1 * paddingRatio / (nodes.length + 1);\n          padding = thisPadding < padding ? thisPadding : padding;\n        });\n        py = padding;\n      }\n\n      var ky = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"min\"])(columns, function (nodes) {\n        return (y1 - y0 - (nodes.length - 1) * py) / Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"sum\"])(nodes, value);\n      });\n\n      //calculate the widths of the links\n      ky = ky * scale;\n\n      graph.links.forEach(function (link) {\n        link.width = link.value * ky;\n      });\n\n      //determine how much to scale down the chart, based on circular links\n      var margin = getCircleMargins(graph);\n      var ratio = scaleSankeySize(graph, margin);\n\n      //re-calculate widths\n      ky = ky * ratio;\n\n      graph.links.forEach(function (link) {\n        link.width = link.value * ky;\n      });\n\n      columns.forEach(function (nodes) {\n        var nodesLength = nodes.length;\n        nodes.forEach(function (node, i) {\n          if (node.depth == columns.length - 1 && nodesLength == 1) {\n            node.y0 = y1 / 2 - node.value * ky;\n            node.y1 = node.y0 + node.value * ky;\n          } else if (node.depth == 0 && nodesLength == 1) {\n            node.y0 = y1 / 2 - node.value * ky;\n            node.y1 = node.y0 + node.value * ky;\n          } else if (node.partOfCycle) {\n            if (numberOfNonSelfLinkingCycles(node, id) == 0) {\n              node.y0 = y1 / 2 + i;\n              node.y1 = node.y0 + node.value * ky;\n            } else if (node.circularLinkType == 'top') {\n              node.y0 = y0 + i;\n              node.y1 = node.y0 + node.value * ky;\n            } else {\n              node.y0 = y1 - node.value * ky - i;\n              node.y1 = node.y0 + node.value * ky;\n            }\n          } else {\n            if (margin.top == 0 || margin.bottom == 0) {\n              node.y0 = (y1 - y0) / nodesLength * i;\n              node.y1 = node.y0 + node.value * ky;\n            } else {\n              node.y0 = (y1 - y0) / 2 - nodesLength / 2 + i;\n              node.y1 = node.y0 + node.value * ky;\n            }\n          }\n        });\n      });\n    }\n\n    // For each node in each column, check the node's vertical position in relation to its targets and sources vertical position\n    // and shift up/down to be closer to the vertical middle of those targets and sources\n    function relaxLeftAndRight(alpha, id) {\n      var columnsLength = columns.length;\n\n      columns.forEach(function (nodes) {\n        var n = nodes.length;\n        var depth = nodes[0].depth;\n\n        nodes.forEach(function (node) {\n          // check the node is not an orphan\n          var nodeHeight;\n          if (node.sourceLinks.length || node.targetLinks.length) {\n            if (node.partOfCycle && numberOfNonSelfLinkingCycles(node, id) > 0) ; else if (depth == 0 && n == 1) {\n              nodeHeight = node.y1 - node.y0;\n\n              node.y0 = y1 / 2 - nodeHeight / 2;\n              node.y1 = y1 / 2 + nodeHeight / 2;\n            } else if (depth == columnsLength - 1 && n == 1) {\n              nodeHeight = node.y1 - node.y0;\n\n              node.y0 = y1 / 2 - nodeHeight / 2;\n              node.y1 = y1 / 2 + nodeHeight / 2;\n            } else {\n              var avg = 0;\n\n              var avgTargetY = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"mean\"])(node.sourceLinks, linkTargetCenter);\n              var avgSourceY = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"mean\"])(node.targetLinks, linkSourceCenter);\n\n              if (avgTargetY && avgSourceY) {\n                avg = (avgTargetY + avgSourceY) / 2;\n              } else {\n                avg = avgTargetY || avgSourceY;\n              }\n\n              var dy = (avg - nodeCenter(node)) * alpha;\n              // positive if it node needs to move down\n              node.y0 += dy;\n              node.y1 += dy;\n            }\n          }\n        });\n      });\n    }\n\n    // For each column, check if nodes are overlapping, and if so, shift up/down\n    function resolveCollisions() {\n      columns.forEach(function (nodes) {\n        var node,\n            dy,\n            y = y0,\n            n = nodes.length,\n            i;\n\n        // Push any overlapping nodes down.\n        nodes.sort(ascendingBreadth);\n\n        for (i = 0; i < n; ++i) {\n          node = nodes[i];\n          dy = y - node.y0;\n\n          if (dy > 0) {\n            node.y0 += dy;\n            node.y1 += dy;\n          }\n          y = node.y1 + py;\n        }\n\n        // If the bottommost node goes outside the bounds, push it back up.\n        dy = y - py - y1;\n        if (dy > 0) {\n          y = node.y0 -= dy, node.y1 -= dy;\n\n          // Push any overlapping nodes back up.\n          for (i = n - 2; i >= 0; --i) {\n            node = nodes[i];\n            dy = node.y1 + py - y;\n            if (dy > 0) node.y0 -= dy, node.y1 -= dy;\n            y = node.y0;\n          }\n        }\n      });\n    }\n  }\n\n  // Assign the links y0 and y1 based on source/target nodes position,\n  // plus the link's relative position to other links to the same node\n  function computeLinkBreadths(graph) {\n    graph.nodes.forEach(function (node) {\n      node.sourceLinks.sort(ascendingTargetBreadth);\n      node.targetLinks.sort(ascendingSourceBreadth);\n    });\n    graph.nodes.forEach(function (node) {\n      var y0 = node.y0;\n      var y1 = y0;\n\n      // start from the bottom of the node for cycle links\n      var y0cycle = node.y1;\n      var y1cycle = y0cycle;\n\n      node.sourceLinks.forEach(function (link) {\n        if (link.circular) {\n          link.y0 = y0cycle - link.width / 2;\n          y0cycle = y0cycle - link.width;\n        } else {\n          link.y0 = y0 + link.width / 2;\n          y0 += link.width;\n        }\n      });\n      node.targetLinks.forEach(function (link) {\n        if (link.circular) {\n          link.y1 = y1cycle - link.width / 2;\n          y1cycle = y1cycle - link.width;\n        } else {\n          link.y1 = y1 + link.width / 2;\n          y1 += link.width;\n        }\n      });\n    });\n  }\n\n  return sankeyCircular;\n}\n\n/// /////////////////////////////////////////////////////////////////////////////////\n// Cycle functions\n// portion of code to detect circular links based on Colin Fergus' bl.ock https://gist.github.com/cfergus/3956043\n\n// Identify circles in the link objects\nfunction identifyCircles(graph, id, sortNodes) {\n  var circularLinkID = 0;\n  if (sortNodes === null) {\n\n    // Building adjacency graph\n    var adjList = [];\n    for (var i = 0; i < graph.links.length; i++) {\n      var link = graph.links[i];\n      var source = link.source.index;\n      var target = link.target.index;\n      if (!adjList[source]) adjList[source] = [];\n      if (!adjList[target]) adjList[target] = [];\n\n      // Add links if not already in set\n      if (adjList[source].indexOf(target) === -1) adjList[source].push(target);\n    }\n\n    // Find all elementary circuits\n    var cycles = elementary_circuits_directed_graph__WEBPACK_IMPORTED_MODULE_3___default()(adjList);\n\n    // Sort by circuits length\n    cycles.sort(function (a, b) {\n      return a.length - b.length;\n    });\n\n    var circularLinks = {};\n    for (i = 0; i < cycles.length; i++) {\n      var cycle = cycles[i];\n      var last = cycle.slice(-2);\n      if (!circularLinks[last[0]]) circularLinks[last[0]] = {};\n      circularLinks[last[0]][last[1]] = true;\n    }\n\n    graph.links.forEach(function (link) {\n      var target = link.target.index;\n      var source = link.source.index;\n      // If self-linking or a back-edge\n      if (target === source || circularLinks[source] && circularLinks[source][target]) {\n        link.circular = true;\n        link.circularLinkID = circularLinkID;\n        circularLinkID = circularLinkID + 1;\n      } else {\n        link.circular = false;\n      }\n    });\n  } else {\n    graph.links.forEach(function (link) {\n      if (link.source[sortNodes] < link.target[sortNodes]) {\n        link.circular = false;\n      } else {\n        link.circular = true;\n        link.circularLinkID = circularLinkID;\n        circularLinkID = circularLinkID + 1;\n      }\n    });\n  }\n}\n\n// Assign a circular link type (top or bottom), based on:\n// - if the source/target node already has circular links, then use the same type\n// - if not, choose the type with fewer links\nfunction selectCircularLinkTypes(graph, id) {\n  var numberOfTops = 0;\n  var numberOfBottoms = 0;\n  graph.links.forEach(function (link) {\n    if (link.circular) {\n      // if either souce or target has type already use that\n      if (link.source.circularLinkType || link.target.circularLinkType) {\n        // default to source type if available\n        link.circularLinkType = link.source.circularLinkType ? link.source.circularLinkType : link.target.circularLinkType;\n      } else {\n        link.circularLinkType = numberOfTops < numberOfBottoms ? 'top' : 'bottom';\n      }\n\n      if (link.circularLinkType == 'top') {\n        numberOfTops = numberOfTops + 1;\n      } else {\n        numberOfBottoms = numberOfBottoms + 1;\n      }\n\n      graph.nodes.forEach(function (node) {\n        if (getNodeID(node, id) == getNodeID(link.source, id) || getNodeID(node, id) == getNodeID(link.target, id)) {\n          node.circularLinkType = link.circularLinkType;\n        }\n      });\n    }\n  });\n\n  //correct self-linking links to be same direction as node\n  graph.links.forEach(function (link) {\n    if (link.circular) {\n      //if both source and target node are same type, then link should have same type\n      if (link.source.circularLinkType == link.target.circularLinkType) {\n        link.circularLinkType = link.source.circularLinkType;\n      }\n      //if link is selflinking, then link should have same type as node\n      if (selfLinking(link, id)) {\n        link.circularLinkType = link.source.circularLinkType;\n      }\n    }\n  });\n}\n\n// Return the angle between a straight line between the source and target of the link, and the vertical plane of the node\nfunction linkAngle(link) {\n  var adjacent = Math.abs(link.y1 - link.y0);\n  var opposite = Math.abs(link.target.x0 - link.source.x1);\n\n  return Math.atan(opposite / adjacent);\n}\n\n// Check if two circular links potentially overlap\nfunction circularLinksCross(link1, link2) {\n  if (link1.source.column < link2.target.column) {\n    return false;\n  } else if (link1.target.column > link2.source.column) {\n    return false;\n  } else {\n    return true;\n  }\n}\n\n// Return the number of circular links for node, not including self linking links\nfunction numberOfNonSelfLinkingCycles(node, id) {\n  var sourceCount = 0;\n  node.sourceLinks.forEach(function (l) {\n    sourceCount = l.circular && !selfLinking(l, id) ? sourceCount + 1 : sourceCount;\n  });\n\n  var targetCount = 0;\n  node.targetLinks.forEach(function (l) {\n    targetCount = l.circular && !selfLinking(l, id) ? targetCount + 1 : targetCount;\n  });\n\n  return sourceCount + targetCount;\n}\n\n// Check if a circular link is the only circular link for both its source and target node\nfunction onlyCircularLink(link) {\n  var nodeSourceLinks = link.source.sourceLinks;\n  var sourceCount = 0;\n  nodeSourceLinks.forEach(function (l) {\n    sourceCount = l.circular ? sourceCount + 1 : sourceCount;\n  });\n\n  var nodeTargetLinks = link.target.targetLinks;\n  var targetCount = 0;\n  nodeTargetLinks.forEach(function (l) {\n    targetCount = l.circular ? targetCount + 1 : targetCount;\n  });\n\n  if (sourceCount > 1 || targetCount > 1) {\n    return false;\n  } else {\n    return true;\n  }\n}\n\n// creates vertical buffer values per set of top/bottom links\nfunction calcVerticalBuffer(links, circularLinkGap, id) {\n  links.sort(sortLinkColumnAscending);\n  links.forEach(function (link, i) {\n    var buffer = 0;\n\n    if (selfLinking(link, id) && onlyCircularLink(link)) {\n      link.circularPathData.verticalBuffer = buffer + link.width / 2;\n    } else {\n      var j = 0;\n      for (j; j < i; j++) {\n        if (circularLinksCross(links[i], links[j])) {\n          var bufferOverThisLink = links[j].circularPathData.verticalBuffer + links[j].width / 2 + circularLinkGap;\n          buffer = bufferOverThisLink > buffer ? bufferOverThisLink : buffer;\n        }\n      }\n\n      link.circularPathData.verticalBuffer = buffer + link.width / 2;\n    }\n  });\n\n  return links;\n}\n\n// calculate the optimum path for a link to reduce overlaps\nfunction addCircularPathData(graph, circularLinkGap, y1, id) {\n  //var baseRadius = 10\n  var buffer = 5;\n  //var verticalMargin = 25\n\n  var minY = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"min\"])(graph.links, function (link) {\n    return link.source.y0;\n  });\n\n  // create object for circular Path Data\n  graph.links.forEach(function (link) {\n    if (link.circular) {\n      link.circularPathData = {};\n    }\n  });\n\n  // calc vertical offsets per top/bottom links\n  var topLinks = graph.links.filter(function (l) {\n    return l.circularLinkType == 'top';\n  });\n  /* topLinks = */calcVerticalBuffer(topLinks, circularLinkGap, id);\n\n  var bottomLinks = graph.links.filter(function (l) {\n    return l.circularLinkType == 'bottom';\n  });\n  /* bottomLinks = */calcVerticalBuffer(bottomLinks, circularLinkGap, id);\n\n  // add the base data for each link\n  graph.links.forEach(function (link) {\n    if (link.circular) {\n      link.circularPathData.arcRadius = link.width + baseRadius;\n      link.circularPathData.leftNodeBuffer = buffer;\n      link.circularPathData.rightNodeBuffer = buffer;\n      link.circularPathData.sourceWidth = link.source.x1 - link.source.x0;\n      link.circularPathData.sourceX = link.source.x0 + link.circularPathData.sourceWidth;\n      link.circularPathData.targetX = link.target.x0;\n      link.circularPathData.sourceY = link.y0;\n      link.circularPathData.targetY = link.y1;\n\n      // for self linking paths, and that the only circular link in/out of that node\n      if (selfLinking(link, id) && onlyCircularLink(link)) {\n        link.circularPathData.leftSmallArcRadius = baseRadius + link.width / 2;\n        link.circularPathData.leftLargeArcRadius = baseRadius + link.width / 2;\n        link.circularPathData.rightSmallArcRadius = baseRadius + link.width / 2;\n        link.circularPathData.rightLargeArcRadius = baseRadius + link.width / 2;\n\n        if (link.circularLinkType == 'bottom') {\n          link.circularPathData.verticalFullExtent = link.source.y1 + verticalMargin + link.circularPathData.verticalBuffer;\n          link.circularPathData.verticalLeftInnerExtent = link.circularPathData.verticalFullExtent - link.circularPathData.leftLargeArcRadius;\n          link.circularPathData.verticalRightInnerExtent = link.circularPathData.verticalFullExtent - link.circularPathData.rightLargeArcRadius;\n        } else {\n          // top links\n          link.circularPathData.verticalFullExtent = link.source.y0 - verticalMargin - link.circularPathData.verticalBuffer;\n          link.circularPathData.verticalLeftInnerExtent = link.circularPathData.verticalFullExtent + link.circularPathData.leftLargeArcRadius;\n          link.circularPathData.verticalRightInnerExtent = link.circularPathData.verticalFullExtent + link.circularPathData.rightLargeArcRadius;\n        }\n      } else {\n        // else calculate normally\n        // add left extent coordinates, based on links with same source column and circularLink type\n        var thisColumn = link.source.column;\n        var thisCircularLinkType = link.circularLinkType;\n        var sameColumnLinks = graph.links.filter(function (l) {\n          return l.source.column == thisColumn && l.circularLinkType == thisCircularLinkType;\n        });\n\n        if (link.circularLinkType == 'bottom') {\n          sameColumnLinks.sort(sortLinkSourceYDescending);\n        } else {\n          sameColumnLinks.sort(sortLinkSourceYAscending);\n        }\n\n        var radiusOffset = 0;\n        sameColumnLinks.forEach(function (l, i) {\n          if (l.circularLinkID == link.circularLinkID) {\n            link.circularPathData.leftSmallArcRadius = baseRadius + link.width / 2 + radiusOffset;\n            link.circularPathData.leftLargeArcRadius = baseRadius + link.width / 2 + i * circularLinkGap + radiusOffset;\n          }\n          radiusOffset = radiusOffset + l.width;\n        });\n\n        // add right extent coordinates, based on links with same target column and circularLink type\n        thisColumn = link.target.column;\n        sameColumnLinks = graph.links.filter(function (l) {\n          return l.target.column == thisColumn && l.circularLinkType == thisCircularLinkType;\n        });\n        if (link.circularLinkType == 'bottom') {\n          sameColumnLinks.sort(sortLinkTargetYDescending);\n        } else {\n          sameColumnLinks.sort(sortLinkTargetYAscending);\n        }\n\n        radiusOffset = 0;\n        sameColumnLinks.forEach(function (l, i) {\n          if (l.circularLinkID == link.circularLinkID) {\n            link.circularPathData.rightSmallArcRadius = baseRadius + link.width / 2 + radiusOffset;\n            link.circularPathData.rightLargeArcRadius = baseRadius + link.width / 2 + i * circularLinkGap + radiusOffset;\n          }\n          radiusOffset = radiusOffset + l.width;\n        });\n\n        // bottom links\n        if (link.circularLinkType == 'bottom') {\n          link.circularPathData.verticalFullExtent = Math.max(y1, link.source.y1, link.target.y1) + verticalMargin + link.circularPathData.verticalBuffer;\n          link.circularPathData.verticalLeftInnerExtent = link.circularPathData.verticalFullExtent - link.circularPathData.leftLargeArcRadius;\n          link.circularPathData.verticalRightInnerExtent = link.circularPathData.verticalFullExtent - link.circularPathData.rightLargeArcRadius;\n        } else {\n          // top links\n          link.circularPathData.verticalFullExtent = minY - verticalMargin - link.circularPathData.verticalBuffer;\n          link.circularPathData.verticalLeftInnerExtent = link.circularPathData.verticalFullExtent + link.circularPathData.leftLargeArcRadius;\n          link.circularPathData.verticalRightInnerExtent = link.circularPathData.verticalFullExtent + link.circularPathData.rightLargeArcRadius;\n        }\n      }\n\n      // all links\n      link.circularPathData.leftInnerExtent = link.circularPathData.sourceX + link.circularPathData.leftNodeBuffer;\n      link.circularPathData.rightInnerExtent = link.circularPathData.targetX - link.circularPathData.rightNodeBuffer;\n      link.circularPathData.leftFullExtent = link.circularPathData.sourceX + link.circularPathData.leftLargeArcRadius + link.circularPathData.leftNodeBuffer;\n      link.circularPathData.rightFullExtent = link.circularPathData.targetX - link.circularPathData.rightLargeArcRadius - link.circularPathData.rightNodeBuffer;\n    }\n\n    if (link.circular) {\n      link.path = createCircularPathString(link);\n    } else {\n      var normalPath = Object(d3_shape__WEBPACK_IMPORTED_MODULE_2__[\"linkHorizontal\"])().source(function (d) {\n        var x = d.source.x0 + (d.source.x1 - d.source.x0);\n        var y = d.y0;\n        return [x, y];\n      }).target(function (d) {\n        var x = d.target.x0;\n        var y = d.y1;\n        return [x, y];\n      });\n      link.path = normalPath(link);\n    }\n  });\n}\n\n// create a d path using the addCircularPathData\nfunction createCircularPathString(link) {\n  var pathString = '';\n  // 'pathData' is assigned a value but never used\n  // var pathData = {}\n\n  if (link.circularLinkType == 'top') {\n    pathString =\n    // start at the right of the source node\n    'M' + link.circularPathData.sourceX + ' ' + link.circularPathData.sourceY + ' ' +\n    // line right to buffer point\n    'L' + link.circularPathData.leftInnerExtent + ' ' + link.circularPathData.sourceY + ' ' +\n    // Arc around: Centre of arc X and  //Centre of arc Y\n    'A' + link.circularPathData.leftLargeArcRadius + ' ' + link.circularPathData.leftSmallArcRadius + ' 0 0 0 ' +\n    // End of arc X //End of arc Y\n    link.circularPathData.leftFullExtent + ' ' + (link.circularPathData.sourceY - link.circularPathData.leftSmallArcRadius) + ' ' + // End of arc X\n    // line up to buffer point\n    'L' + link.circularPathData.leftFullExtent + ' ' + link.circularPathData.verticalLeftInnerExtent + ' ' +\n    // Arc around: Centre of arc X and  //Centre of arc Y\n    'A' + link.circularPathData.leftLargeArcRadius + ' ' + link.circularPathData.leftLargeArcRadius + ' 0 0 0 ' +\n    // End of arc X //End of arc Y\n    link.circularPathData.leftInnerExtent + ' ' + link.circularPathData.verticalFullExtent + ' ' + // End of arc X\n    // line left to buffer point\n    'L' + link.circularPathData.rightInnerExtent + ' ' + link.circularPathData.verticalFullExtent + ' ' +\n    // Arc around: Centre of arc X and  //Centre of arc Y\n    'A' + link.circularPathData.rightLargeArcRadius + ' ' + link.circularPathData.rightLargeArcRadius + ' 0 0 0 ' +\n    // End of arc X //End of arc Y\n    link.circularPathData.rightFullExtent + ' ' + link.circularPathData.verticalRightInnerExtent + ' ' + // End of arc X\n    // line down\n    'L' + link.circularPathData.rightFullExtent + ' ' + (link.circularPathData.targetY - link.circularPathData.rightSmallArcRadius) + ' ' +\n    // Arc around: Centre of arc X and  //Centre of arc Y\n    'A' + link.circularPathData.rightLargeArcRadius + ' ' + link.circularPathData.rightSmallArcRadius + ' 0 0 0 ' +\n    // End of arc X //End of arc Y\n    link.circularPathData.rightInnerExtent + ' ' + link.circularPathData.targetY + ' ' + // End of arc X\n    // line to end\n    'L' + link.circularPathData.targetX + ' ' + link.circularPathData.targetY;\n  } else {\n    // bottom path\n    pathString =\n    // start at the right of the source node\n    'M' + link.circularPathData.sourceX + ' ' + link.circularPathData.sourceY + ' ' +\n    // line right to buffer point\n    'L' + link.circularPathData.leftInnerExtent + ' ' + link.circularPathData.sourceY + ' ' +\n    // Arc around: Centre of arc X and  //Centre of arc Y\n    'A' + link.circularPathData.leftLargeArcRadius + ' ' + link.circularPathData.leftSmallArcRadius + ' 0 0 1 ' +\n    // End of arc X //End of arc Y\n    link.circularPathData.leftFullExtent + ' ' + (link.circularPathData.sourceY + link.circularPathData.leftSmallArcRadius) + ' ' + // End of arc X\n    // line down to buffer point\n    'L' + link.circularPathData.leftFullExtent + ' ' + link.circularPathData.verticalLeftInnerExtent + ' ' +\n    // Arc around: Centre of arc X and  //Centre of arc Y\n    'A' + link.circularPathData.leftLargeArcRadius + ' ' + link.circularPathData.leftLargeArcRadius + ' 0 0 1 ' +\n    // End of arc X //End of arc Y\n    link.circularPathData.leftInnerExtent + ' ' + link.circularPathData.verticalFullExtent + ' ' + // End of arc X\n    // line left to buffer point\n    'L' + link.circularPathData.rightInnerExtent + ' ' + link.circularPathData.verticalFullExtent + ' ' +\n    // Arc around: Centre of arc X and  //Centre of arc Y\n    'A' + link.circularPathData.rightLargeArcRadius + ' ' + link.circularPathData.rightLargeArcRadius + ' 0 0 1 ' +\n    // End of arc X //End of arc Y\n    link.circularPathData.rightFullExtent + ' ' + link.circularPathData.verticalRightInnerExtent + ' ' + // End of arc X\n    // line up\n    'L' + link.circularPathData.rightFullExtent + ' ' + (link.circularPathData.targetY + link.circularPathData.rightSmallArcRadius) + ' ' +\n    // Arc around: Centre of arc X and  //Centre of arc Y\n    'A' + link.circularPathData.rightLargeArcRadius + ' ' + link.circularPathData.rightSmallArcRadius + ' 0 0 1 ' +\n    // End of arc X //End of arc Y\n    link.circularPathData.rightInnerExtent + ' ' + link.circularPathData.targetY + ' ' + // End of arc X\n    // line to end\n    'L' + link.circularPathData.targetX + ' ' + link.circularPathData.targetY;\n  }\n\n  return pathString;\n}\n\n// sort links based on the distance between the source and tartget node columns\n// if the same, then use Y position of the source node\nfunction sortLinkColumnAscending(link1, link2) {\n  if (linkColumnDistance(link1) == linkColumnDistance(link2)) {\n    return link1.circularLinkType == 'bottom' ? sortLinkSourceYDescending(link1, link2) : sortLinkSourceYAscending(link1, link2);\n  } else {\n    return linkColumnDistance(link2) - linkColumnDistance(link1);\n  }\n}\n\n// sort ascending links by their source vertical position, y0\nfunction sortLinkSourceYAscending(link1, link2) {\n  return link1.y0 - link2.y0;\n}\n\n// sort descending links by their source vertical position, y0\nfunction sortLinkSourceYDescending(link1, link2) {\n  return link2.y0 - link1.y0;\n}\n\n// sort ascending links by their target vertical position, y1\nfunction sortLinkTargetYAscending(link1, link2) {\n  return link1.y1 - link2.y1;\n}\n\n// sort descending links by their target vertical position, y1\nfunction sortLinkTargetYDescending(link1, link2) {\n  return link2.y1 - link1.y1;\n}\n\n// return the distance between the link's target and source node, in terms of the nodes' column\nfunction linkColumnDistance(link) {\n  return link.target.column - link.source.column;\n}\n\n// return the distance between the link's target and source node, in terms of the nodes' X coordinate\nfunction linkXLength(link) {\n  return link.target.x0 - link.source.x1;\n}\n\n// Return the Y coordinate on the longerLink path * which is perpendicular shorterLink's source.\n// * approx, based on a straight line from target to source, when in fact the path is a bezier\nfunction linkPerpendicularYToLinkSource(longerLink, shorterLink) {\n  // get the angle for the longer link\n  var angle = linkAngle(longerLink);\n\n  // get the adjacent length to the other link's x position\n  var heightFromY1ToPependicular = linkXLength(shorterLink) / Math.tan(angle);\n\n  // add or subtract from longer link1's original y1, depending on the slope\n  var yPerpendicular = incline(longerLink) == 'up' ? longerLink.y1 + heightFromY1ToPependicular : longerLink.y1 - heightFromY1ToPependicular;\n\n  return yPerpendicular;\n}\n\n// Return the Y coordinate on the longerLink path * which is perpendicular shorterLink's source.\n// * approx, based on a straight line from target to source, when in fact the path is a bezier\nfunction linkPerpendicularYToLinkTarget(longerLink, shorterLink) {\n  // get the angle for the longer link\n  var angle = linkAngle(longerLink);\n\n  // get the adjacent length to the other link's x position\n  var heightFromY1ToPependicular = linkXLength(shorterLink) / Math.tan(angle);\n\n  // add or subtract from longer link's original y1, depending on the slope\n  var yPerpendicular = incline(longerLink) == 'up' ? longerLink.y1 - heightFromY1ToPependicular : longerLink.y1 + heightFromY1ToPependicular;\n\n  return yPerpendicular;\n}\n\n// Move any nodes that overlap links which span 2+ columns\nfunction resolveNodeLinkOverlaps(graph, y0, y1, id) {\n\n  graph.links.forEach(function (link) {\n    if (link.circular) {\n      return;\n    }\n\n    if (link.target.column - link.source.column > 1) {\n      var columnToTest = link.source.column + 1;\n      var maxColumnToTest = link.target.column - 1;\n\n      var i = 1;\n      var numberOfColumnsToTest = maxColumnToTest - columnToTest + 1;\n\n      for (i = 1; columnToTest <= maxColumnToTest; columnToTest++, i++) {\n        graph.nodes.forEach(function (node) {\n          if (node.column == columnToTest) {\n            var t = i / (numberOfColumnsToTest + 1);\n\n            // Find all the points of a cubic bezier curve in javascript\n            // https://stackoverflow.com/questions/15397596/find-all-the-points-of-a-cubic-bezier-curve-in-javascript\n\n            var B0_t = Math.pow(1 - t, 3);\n            var B1_t = 3 * t * Math.pow(1 - t, 2);\n            var B2_t = 3 * Math.pow(t, 2) * (1 - t);\n            var B3_t = Math.pow(t, 3);\n\n            var py_t = B0_t * link.y0 + B1_t * link.y0 + B2_t * link.y1 + B3_t * link.y1;\n\n            var linkY0AtColumn = py_t - link.width / 2;\n            var linkY1AtColumn = py_t + link.width / 2;\n            var dy;\n\n            // If top of link overlaps node, push node up\n            if (linkY0AtColumn > node.y0 && linkY0AtColumn < node.y1) {\n\n              dy = node.y1 - linkY0AtColumn + 10;\n              dy = node.circularLinkType == 'bottom' ? dy : -dy;\n\n              node = adjustNodeHeight(node, dy, y0, y1);\n\n              // check if other nodes need to move up too\n              graph.nodes.forEach(function (otherNode) {\n                // don't need to check itself or nodes at different columns\n                if (getNodeID(otherNode, id) == getNodeID(node, id) || otherNode.column != node.column) {\n                  return;\n                }\n                if (nodesOverlap(node, otherNode)) {\n                  adjustNodeHeight(otherNode, dy, y0, y1);\n                }\n              });\n            } else if (linkY1AtColumn > node.y0 && linkY1AtColumn < node.y1) {\n              // If bottom of link overlaps node, push node down\n              dy = linkY1AtColumn - node.y0 + 10;\n\n              node = adjustNodeHeight(node, dy, y0, y1);\n\n              // check if other nodes need to move down too\n              graph.nodes.forEach(function (otherNode) {\n                // don't need to check itself or nodes at different columns\n                if (getNodeID(otherNode, id) == getNodeID(node, id) || otherNode.column != node.column) {\n                  return;\n                }\n                if (otherNode.y0 < node.y1 && otherNode.y1 > node.y1) {\n                  adjustNodeHeight(otherNode, dy, y0, y1);\n                }\n              });\n            } else if (linkY0AtColumn < node.y0 && linkY1AtColumn > node.y1) {\n              // if link completely overlaps node\n              dy = linkY1AtColumn - node.y0 + 10;\n\n              node = adjustNodeHeight(node, dy, y0, y1);\n\n              graph.nodes.forEach(function (otherNode) {\n                // don't need to check itself or nodes at different columns\n                if (getNodeID(otherNode, id) == getNodeID(node, id) || otherNode.column != node.column) {\n                  return;\n                }\n                if (otherNode.y0 < node.y1 && otherNode.y1 > node.y1) {\n                  adjustNodeHeight(otherNode, dy, y0, y1);\n                }\n              });\n            }\n          }\n        });\n      }\n    }\n  });\n}\n\n// check if two nodes overlap\nfunction nodesOverlap(nodeA, nodeB) {\n  // test if nodeA top partially overlaps nodeB\n  if (nodeA.y0 > nodeB.y0 && nodeA.y0 < nodeB.y1) {\n    return true;\n  } else if (nodeA.y1 > nodeB.y0 && nodeA.y1 < nodeB.y1) {\n    // test if nodeA bottom partially overlaps nodeB\n    return true;\n  } else if (nodeA.y0 < nodeB.y0 && nodeA.y1 > nodeB.y1) {\n    // test if nodeA covers nodeB\n    return true;\n  } else {\n    return false;\n  }\n}\n\n// update a node, and its associated links, vertical positions (y0, y1)\nfunction adjustNodeHeight(node, dy, sankeyY0, sankeyY1) {\n  if (node.y0 + dy >= sankeyY0 && node.y1 + dy <= sankeyY1) {\n    node.y0 = node.y0 + dy;\n    node.y1 = node.y1 + dy;\n\n    node.targetLinks.forEach(function (l) {\n      l.y1 = l.y1 + dy;\n    });\n\n    node.sourceLinks.forEach(function (l) {\n      l.y0 = l.y0 + dy;\n    });\n  }\n  return node;\n}\n\n// sort and set the links' y0 for each node\nfunction sortSourceLinks(graph, y1, id, moveNodes) {\n  graph.nodes.forEach(function (node) {\n    // move any nodes up which are off the bottom\n    if (moveNodes && node.y + (node.y1 - node.y0) > y1) {\n      node.y = node.y - (node.y + (node.y1 - node.y0) - y1);\n    }\n\n    var nodesSourceLinks = graph.links.filter(function (l) {\n      return getNodeID(l.source, id) == getNodeID(node, id);\n    });\n\n    var nodeSourceLinksLength = nodesSourceLinks.length;\n\n    // if more than 1 link then sort\n    if (nodeSourceLinksLength > 1) {\n      nodesSourceLinks.sort(function (link1, link2) {\n        // if both are not circular...\n        if (!link1.circular && !link2.circular) {\n          // if the target nodes are the same column, then sort by the link's target y\n          if (link1.target.column == link2.target.column) {\n            return link1.y1 - link2.y1;\n          } else if (!sameInclines(link1, link2)) {\n            // if the links slope in different directions, then sort by the link's target y\n            return link1.y1 - link2.y1;\n\n            // if the links slope in same directions, then sort by any overlap\n          } else {\n            if (link1.target.column > link2.target.column) {\n              var link2Adj = linkPerpendicularYToLinkTarget(link2, link1);\n              return link1.y1 - link2Adj;\n            }\n            if (link2.target.column > link1.target.column) {\n              var link1Adj = linkPerpendicularYToLinkTarget(link1, link2);\n              return link1Adj - link2.y1;\n            }\n          }\n        }\n\n        // if only one is circular, the move top links up, or bottom links down\n        if (link1.circular && !link2.circular) {\n          return link1.circularLinkType == 'top' ? -1 : 1;\n        } else if (link2.circular && !link1.circular) {\n          return link2.circularLinkType == 'top' ? 1 : -1;\n        }\n\n        // if both links are circular...\n        if (link1.circular && link2.circular) {\n          // ...and they both loop the same way (both top)\n          if (link1.circularLinkType === link2.circularLinkType && link1.circularLinkType == 'top') {\n            // ...and they both connect to a target with same column, then sort by the target's y\n            if (link1.target.column === link2.target.column) {\n              return link1.target.y1 - link2.target.y1;\n            } else {\n              // ...and they connect to different column targets, then sort by how far back they\n              return link2.target.column - link1.target.column;\n            }\n          } else if (link1.circularLinkType === link2.circularLinkType && link1.circularLinkType == 'bottom') {\n            // ...and they both loop the same way (both bottom)\n            // ...and they both connect to a target with same column, then sort by the target's y\n            if (link1.target.column === link2.target.column) {\n              return link2.target.y1 - link1.target.y1;\n            } else {\n              // ...and they connect to different column targets, then sort by how far back they\n              return link1.target.column - link2.target.column;\n            }\n          } else {\n            // ...and they loop around different ways, the move top up and bottom down\n            return link1.circularLinkType == 'top' ? -1 : 1;\n          }\n        }\n      });\n    }\n\n    // update y0 for links\n    var ySourceOffset = node.y0;\n\n    nodesSourceLinks.forEach(function (link) {\n      link.y0 = ySourceOffset + link.width / 2;\n      ySourceOffset = ySourceOffset + link.width;\n    });\n\n    // correct any circular bottom links so they are at the bottom of the node\n    nodesSourceLinks.forEach(function (link, i) {\n      if (link.circularLinkType == 'bottom') {\n        var j = i + 1;\n        var offsetFromBottom = 0;\n        // sum the widths of any links that are below this link\n        for (j; j < nodeSourceLinksLength; j++) {\n          offsetFromBottom = offsetFromBottom + nodesSourceLinks[j].width;\n        }\n        link.y0 = node.y1 - offsetFromBottom - link.width / 2;\n      }\n    });\n  });\n}\n\n// sort and set the links' y1 for each node\nfunction sortTargetLinks(graph, y1, id) {\n  graph.nodes.forEach(function (node) {\n    var nodesTargetLinks = graph.links.filter(function (l) {\n      return getNodeID(l.target, id) == getNodeID(node, id);\n    });\n\n    var nodesTargetLinksLength = nodesTargetLinks.length;\n\n    if (nodesTargetLinksLength > 1) {\n      nodesTargetLinks.sort(function (link1, link2) {\n        // if both are not circular, the base on the source y position\n        if (!link1.circular && !link2.circular) {\n          if (link1.source.column == link2.source.column) {\n            return link1.y0 - link2.y0;\n          } else if (!sameInclines(link1, link2)) {\n            return link1.y0 - link2.y0;\n          } else {\n            // get the angle of the link to the further source node (ie the smaller column)\n            if (link2.source.column < link1.source.column) {\n              var link2Adj = linkPerpendicularYToLinkSource(link2, link1);\n\n              return link1.y0 - link2Adj;\n            }\n            if (link1.source.column < link2.source.column) {\n              var link1Adj = linkPerpendicularYToLinkSource(link1, link2);\n\n              return link1Adj - link2.y0;\n            }\n          }\n        }\n\n        // if only one is circular, the move top links up, or bottom links down\n        if (link1.circular && !link2.circular) {\n          return link1.circularLinkType == 'top' ? -1 : 1;\n        } else if (link2.circular && !link1.circular) {\n          return link2.circularLinkType == 'top' ? 1 : -1;\n        }\n\n        // if both links are circular...\n        if (link1.circular && link2.circular) {\n          // ...and they both loop the same way (both top)\n          if (link1.circularLinkType === link2.circularLinkType && link1.circularLinkType == 'top') {\n            // ...and they both connect to a target with same column, then sort by the target's y\n            if (link1.source.column === link2.source.column) {\n              return link1.source.y1 - link2.source.y1;\n            } else {\n              // ...and they connect to different column targets, then sort by how far back they\n              return link1.source.column - link2.source.column;\n            }\n          } else if (link1.circularLinkType === link2.circularLinkType && link1.circularLinkType == 'bottom') {\n            // ...and they both loop the same way (both bottom)\n            // ...and they both connect to a target with same column, then sort by the target's y\n            if (link1.source.column === link2.source.column) {\n              return link1.source.y1 - link2.source.y1;\n            } else {\n              // ...and they connect to different column targets, then sort by how far back they\n              return link2.source.column - link1.source.column;\n            }\n          } else {\n            // ...and they loop around different ways, the move top up and bottom down\n            return link1.circularLinkType == 'top' ? -1 : 1;\n          }\n        }\n      });\n    }\n\n    // update y1 for links\n    var yTargetOffset = node.y0;\n\n    nodesTargetLinks.forEach(function (link) {\n      link.y1 = yTargetOffset + link.width / 2;\n      yTargetOffset = yTargetOffset + link.width;\n    });\n\n    // correct any circular bottom links so they are at the bottom of the node\n    nodesTargetLinks.forEach(function (link, i) {\n      if (link.circularLinkType == 'bottom') {\n        var j = i + 1;\n        var offsetFromBottom = 0;\n        // sum the widths of any links that are below this link\n        for (j; j < nodesTargetLinksLength; j++) {\n          offsetFromBottom = offsetFromBottom + nodesTargetLinks[j].width;\n        }\n        link.y1 = node.y1 - offsetFromBottom - link.width / 2;\n      }\n    });\n  });\n}\n\n// test if links both slope up, or both slope down\nfunction sameInclines(link1, link2) {\n  return incline(link1) == incline(link2);\n}\n\n// returns the slope of a link, from source to target\n// up => slopes up from source to target\n// down => slopes down from source to target\nfunction incline(link) {\n  return link.y0 - link.y1 > 0 ? 'up' : 'down';\n}\n\n// check if link is self linking, ie links a node to the same node\nfunction selfLinking(link, id) {\n  return getNodeID(link.source, id) == getNodeID(link.target, id);\n}\n\nfunction fillHeight(graph, y0, y1) {\n\n  var nodes = graph.nodes;\n  var links = graph.links;\n\n  var top = false;\n  var bottom = false;\n\n  links.forEach(function (link) {\n    if (link.circularLinkType == \"top\") {\n      top = true;\n    } else if (link.circularLinkType == \"bottom\") {\n      bottom = true;\n    }\n  });\n\n  if (top == false || bottom == false) {\n    var minY0 = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"min\"])(nodes, function (node) {\n      return node.y0;\n    });\n    var maxY1 = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"max\"])(nodes, function (node) {\n      return node.y1;\n    });\n    var currentHeight = maxY1 - minY0;\n    var chartHeight = y1 - y0;\n    var ratio = chartHeight / currentHeight;\n\n    nodes.forEach(function (node) {\n      var nodeHeight = (node.y1 - node.y0) * ratio;\n      node.y0 = (node.y0 - minY0) * ratio;\n      node.y1 = node.y0 + nodeHeight;\n    });\n\n    links.forEach(function (link) {\n      link.y0 = (link.y0 - minY0) * ratio;\n      link.y1 = (link.y1 - minY0) * ratio;\n      link.width = link.width * ratio;\n    });\n  }\n}\n\n\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/dist/d3-sankey-circular.es.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/array.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/array.js ***!
  \************************************************************************************/
/*! exports provided: slice, map */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"slice\", function() { return slice; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"map\", function() { return map; });\nvar array = Array.prototype;\n\nvar slice = array.slice;\nvar map = array.map;\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/array.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ascending.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ascending.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ascending.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisect.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisect.js ***!
  \*************************************************************************************/
/*! exports provided: bisectRight, bisectLeft, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"bisectRight\", function() { return bisectRight; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"bisectLeft\", function() { return bisectLeft; });\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ascending.js\");\n/* harmony import */ var _bisector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bisector */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisector.js\");\n\n\n\nvar ascendingBisect = Object(_bisector__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(_ascending__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\nvar bisectRight = ascendingBisect.right;\nvar bisectLeft = ascendingBisect.left;\n/* harmony default export */ __webpack_exports__[\"default\"] = (bisectRight);\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisect.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisector.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisector.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ascending.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(compare) {\n  if (compare.length === 1) compare = ascendingComparator(compare);\n  return {\n    left: function(a, x, lo, hi) {\n      if (lo == null) lo = 0;\n      if (hi == null) hi = a.length;\n      while (lo < hi) {\n        var mid = lo + hi >>> 1;\n        if (compare(a[mid], x) < 0) lo = mid + 1;\n        else hi = mid;\n      }\n      return lo;\n    },\n    right: function(a, x, lo, hi) {\n      if (lo == null) lo = 0;\n      if (hi == null) hi = a.length;\n      while (lo < hi) {\n        var mid = lo + hi >>> 1;\n        if (compare(a[mid], x) > 0) hi = mid;\n        else lo = mid + 1;\n      }\n      return lo;\n    }\n  };\n});\n\nfunction ascendingComparator(f) {\n  return function(d, x) {\n    return Object(_ascending__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(f(d), x);\n  };\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisector.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/constant.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/constant.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x) {\n  return function() {\n    return x;\n  };\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/constant.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/cross.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/cross.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _pairs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pairs */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/pairs.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values0, values1, reduce) {\n  var n0 = values0.length,\n      n1 = values1.length,\n      values = new Array(n0 * n1),\n      i0,\n      i1,\n      i,\n      value0;\n\n  if (reduce == null) reduce = _pairs__WEBPACK_IMPORTED_MODULE_0__[\"pair\"];\n\n  for (i0 = i = 0; i0 < n0; ++i0) {\n    for (value0 = values0[i0], i1 = 0; i1 < n1; ++i1, ++i) {\n      values[i] = reduce(value0, values1[i1]);\n    }\n  }\n\n  return values;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/cross.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/descending.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/descending.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/descending.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/deviation.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/deviation.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _variance__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./variance */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/variance.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(array, f) {\n  var v = Object(_variance__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(array, f);\n  return v ? Math.sqrt(v) : v;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/deviation.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/extent.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/extent.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      i = -1,\n      value,\n      min,\n      max;\n\n  if (valueof == null) {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = values[i]) != null && value >= value) {\n        min = max = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = values[i]) != null) {\n            if (min > value) min = value;\n            if (max < value) max = value;\n          }\n        }\n      }\n    }\n  }\n\n  else {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = valueof(values[i], i, values)) != null && value >= value) {\n        min = max = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = valueof(values[i], i, values)) != null) {\n            if (min > value) min = value;\n            if (max < value) max = value;\n          }\n        }\n      }\n    }\n  }\n\n  return [min, max];\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/extent.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/histogram.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/histogram.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./array */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/array.js\");\n/* harmony import */ var _bisect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bisect */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisect.js\");\n/* harmony import */ var _constant__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constant */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/constant.js\");\n/* harmony import */ var _extent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./extent */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/extent.js\");\n/* harmony import */ var _identity__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./identity */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/identity.js\");\n/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./range */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/range.js\");\n/* harmony import */ var _ticks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ticks */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ticks.js\");\n/* harmony import */ var _threshold_sturges__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./threshold/sturges */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/sturges.js\");\n\n\n\n\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var value = _identity__WEBPACK_IMPORTED_MODULE_4__[\"default\"],\n      domain = _extent__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n      threshold = _threshold_sturges__WEBPACK_IMPORTED_MODULE_7__[\"default\"];\n\n  function histogram(data) {\n    var i,\n        n = data.length,\n        x,\n        values = new Array(n);\n\n    for (i = 0; i < n; ++i) {\n      values[i] = value(data[i], i, data);\n    }\n\n    var xz = domain(values),\n        x0 = xz[0],\n        x1 = xz[1],\n        tz = threshold(values, x0, x1);\n\n    // Convert number of thresholds into uniform thresholds.\n    if (!Array.isArray(tz)) {\n      tz = Object(_ticks__WEBPACK_IMPORTED_MODULE_6__[\"tickStep\"])(x0, x1, tz);\n      tz = Object(_range__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(Math.ceil(x0 / tz) * tz, x1, tz); // exclusive\n    }\n\n    // Remove any thresholds outside the domain.\n    var m = tz.length;\n    while (tz[0] <= x0) tz.shift(), --m;\n    while (tz[m - 1] > x1) tz.pop(), --m;\n\n    var bins = new Array(m + 1),\n        bin;\n\n    // Initialize bins.\n    for (i = 0; i <= m; ++i) {\n      bin = bins[i] = [];\n      bin.x0 = i > 0 ? tz[i - 1] : x0;\n      bin.x1 = i < m ? tz[i] : x1;\n    }\n\n    // Assign data to bins by value, ignoring any outside the domain.\n    for (i = 0; i < n; ++i) {\n      x = values[i];\n      if (x0 <= x && x <= x1) {\n        bins[Object(_bisect__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(tz, x, 0, m)].push(data[i]);\n      }\n    }\n\n    return bins;\n  }\n\n  histogram.value = function(_) {\n    return arguments.length ? (value = typeof _ === \"function\" ? _ : Object(_constant__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(_), histogram) : value;\n  };\n\n  histogram.domain = function(_) {\n    return arguments.length ? (domain = typeof _ === \"function\" ? _ : Object(_constant__WEBPACK_IMPORTED_MODULE_2__[\"default\"])([_[0], _[1]]), histogram) : domain;\n  };\n\n  histogram.thresholds = function(_) {\n    return arguments.length ? (threshold = typeof _ === \"function\" ? _ : Array.isArray(_) ? Object(_constant__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(_array__WEBPACK_IMPORTED_MODULE_0__[\"slice\"].call(_)) : Object(_constant__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(_), histogram) : threshold;\n  };\n\n  return histogram;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/histogram.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/identity.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/identity.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x) {\n  return x;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/identity.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/index.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/index.js ***!
  \************************************************************************************/
/*! exports provided: bisect, bisectRight, bisectLeft, ascending, bisector, cross, descending, deviation, extent, histogram, thresholdFreedmanDiaconis, thresholdScott, thresholdSturges, max, mean, median, merge, min, pairs, permute, quantile, range, scan, shuffle, sum, ticks, tickIncrement, tickStep, transpose, variance, zip */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _bisect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bisect */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisect.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"bisect\", function() { return _bisect__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"bisectRight\", function() { return _bisect__WEBPACK_IMPORTED_MODULE_0__[\"bisectRight\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"bisectLeft\", function() { return _bisect__WEBPACK_IMPORTED_MODULE_0__[\"bisectLeft\"]; });\n\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ascending */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ascending.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"ascending\", function() { return _ascending__WEBPACK_IMPORTED_MODULE_1__[\"default\"]; });\n\n/* harmony import */ var _bisector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./bisector */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisector.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"bisector\", function() { return _bisector__WEBPACK_IMPORTED_MODULE_2__[\"default\"]; });\n\n/* harmony import */ var _cross__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./cross */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/cross.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"cross\", function() { return _cross__WEBPACK_IMPORTED_MODULE_3__[\"default\"]; });\n\n/* harmony import */ var _descending__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./descending */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/descending.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"descending\", function() { return _descending__WEBPACK_IMPORTED_MODULE_4__[\"default\"]; });\n\n/* harmony import */ var _deviation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./deviation */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/deviation.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"deviation\", function() { return _deviation__WEBPACK_IMPORTED_MODULE_5__[\"default\"]; });\n\n/* harmony import */ var _extent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./extent */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/extent.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"extent\", function() { return _extent__WEBPACK_IMPORTED_MODULE_6__[\"default\"]; });\n\n/* harmony import */ var _histogram__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./histogram */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/histogram.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"histogram\", function() { return _histogram__WEBPACK_IMPORTED_MODULE_7__[\"default\"]; });\n\n/* harmony import */ var _threshold_freedmanDiaconis__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./threshold/freedmanDiaconis */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/freedmanDiaconis.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"thresholdFreedmanDiaconis\", function() { return _threshold_freedmanDiaconis__WEBPACK_IMPORTED_MODULE_8__[\"default\"]; });\n\n/* harmony import */ var _threshold_scott__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./threshold/scott */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/scott.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"thresholdScott\", function() { return _threshold_scott__WEBPACK_IMPORTED_MODULE_9__[\"default\"]; });\n\n/* harmony import */ var _threshold_sturges__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./threshold/sturges */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/sturges.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"thresholdSturges\", function() { return _threshold_sturges__WEBPACK_IMPORTED_MODULE_10__[\"default\"]; });\n\n/* harmony import */ var _max__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./max */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/max.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"max\", function() { return _max__WEBPACK_IMPORTED_MODULE_11__[\"default\"]; });\n\n/* harmony import */ var _mean__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./mean */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/mean.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"mean\", function() { return _mean__WEBPACK_IMPORTED_MODULE_12__[\"default\"]; });\n\n/* harmony import */ var _median__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./median */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/median.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"median\", function() { return _median__WEBPACK_IMPORTED_MODULE_13__[\"default\"]; });\n\n/* harmony import */ var _merge__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./merge */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/merge.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"merge\", function() { return _merge__WEBPACK_IMPORTED_MODULE_14__[\"default\"]; });\n\n/* harmony import */ var _min__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./min */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/min.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"min\", function() { return _min__WEBPACK_IMPORTED_MODULE_15__[\"default\"]; });\n\n/* harmony import */ var _pairs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./pairs */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/pairs.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"pairs\", function() { return _pairs__WEBPACK_IMPORTED_MODULE_16__[\"default\"]; });\n\n/* harmony import */ var _permute__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./permute */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/permute.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"permute\", function() { return _permute__WEBPACK_IMPORTED_MODULE_17__[\"default\"]; });\n\n/* harmony import */ var _quantile__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./quantile */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/quantile.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"quantile\", function() { return _quantile__WEBPACK_IMPORTED_MODULE_18__[\"default\"]; });\n\n/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./range */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/range.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"range\", function() { return _range__WEBPACK_IMPORTED_MODULE_19__[\"default\"]; });\n\n/* harmony import */ var _scan__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./scan */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/scan.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"scan\", function() { return _scan__WEBPACK_IMPORTED_MODULE_20__[\"default\"]; });\n\n/* harmony import */ var _shuffle__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./shuffle */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/shuffle.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"shuffle\", function() { return _shuffle__WEBPACK_IMPORTED_MODULE_21__[\"default\"]; });\n\n/* harmony import */ var _sum__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./sum */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/sum.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"sum\", function() { return _sum__WEBPACK_IMPORTED_MODULE_22__[\"default\"]; });\n\n/* harmony import */ var _ticks__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./ticks */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ticks.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"ticks\", function() { return _ticks__WEBPACK_IMPORTED_MODULE_23__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"tickIncrement\", function() { return _ticks__WEBPACK_IMPORTED_MODULE_23__[\"tickIncrement\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"tickStep\", function() { return _ticks__WEBPACK_IMPORTED_MODULE_23__[\"tickStep\"]; });\n\n/* harmony import */ var _transpose__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./transpose */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/transpose.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"transpose\", function() { return _transpose__WEBPACK_IMPORTED_MODULE_24__[\"default\"]; });\n\n/* harmony import */ var _variance__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./variance */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/variance.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"variance\", function() { return _variance__WEBPACK_IMPORTED_MODULE_25__[\"default\"]; });\n\n/* harmony import */ var _zip__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./zip */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/zip.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"zip\", function() { return _zip__WEBPACK_IMPORTED_MODULE_26__[\"default\"]; });\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/index.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/max.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/max.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      i = -1,\n      value,\n      max;\n\n  if (valueof == null) {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = values[i]) != null && value >= value) {\n        max = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = values[i]) != null && value > max) {\n            max = value;\n          }\n        }\n      }\n    }\n  }\n\n  else {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = valueof(values[i], i, values)) != null && value >= value) {\n        max = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = valueof(values[i], i, values)) != null && value > max) {\n            max = value;\n          }\n        }\n      }\n    }\n  }\n\n  return max;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/max.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/mean.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/mean.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./number */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/number.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      m = n,\n      i = -1,\n      value,\n      sum = 0;\n\n  if (valueof == null) {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(values[i]))) sum += value;\n      else --m;\n    }\n  }\n\n  else {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(valueof(values[i], i, values)))) sum += value;\n      else --m;\n    }\n  }\n\n  if (m) return sum / m;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/mean.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/median.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/median.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ascending.js\");\n/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./number */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/number.js\");\n/* harmony import */ var _quantile__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./quantile */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/quantile.js\");\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      i = -1,\n      value,\n      numbers = [];\n\n  if (valueof == null) {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(values[i]))) {\n        numbers.push(value);\n      }\n    }\n  }\n\n  else {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(valueof(values[i], i, values)))) {\n        numbers.push(value);\n      }\n    }\n  }\n\n  return Object(_quantile__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(numbers.sort(_ascending__WEBPACK_IMPORTED_MODULE_0__[\"default\"]), 0.5);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/median.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/merge.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/merge.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(arrays) {\n  var n = arrays.length,\n      m,\n      i = -1,\n      j = 0,\n      merged,\n      array;\n\n  while (++i < n) j += arrays[i].length;\n  merged = new Array(j);\n\n  while (--n >= 0) {\n    array = arrays[n];\n    m = array.length;\n    while (--m >= 0) {\n      merged[--j] = array[m];\n    }\n  }\n\n  return merged;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/merge.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/min.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/min.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      i = -1,\n      value,\n      min;\n\n  if (valueof == null) {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = values[i]) != null && value >= value) {\n        min = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = values[i]) != null && min > value) {\n            min = value;\n          }\n        }\n      }\n    }\n  }\n\n  else {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = valueof(values[i], i, values)) != null && value >= value) {\n        min = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = valueof(values[i], i, values)) != null && min > value) {\n            min = value;\n          }\n        }\n      }\n    }\n  }\n\n  return min;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/min.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/number.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/number.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x) {\n  return x === null ? NaN : +x;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/number.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/pairs.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/pairs.js ***!
  \************************************************************************************/
/*! exports provided: default, pair */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"pair\", function() { return pair; });\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(array, f) {\n  if (f == null) f = pair;\n  var i = 0, n = array.length - 1, p = array[0], pairs = new Array(n < 0 ? 0 : n);\n  while (i < n) pairs[i] = f(p, p = array[++i]);\n  return pairs;\n});\n\nfunction pair(a, b) {\n  return [a, b];\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/pairs.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/permute.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/permute.js ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(array, indexes) {\n  var i = indexes.length, permutes = new Array(i);\n  while (i--) permutes[i] = array[indexes[i]];\n  return permutes;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/permute.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/quantile.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/quantile.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./number */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/number.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, p, valueof) {\n  if (valueof == null) valueof = _number__WEBPACK_IMPORTED_MODULE_0__[\"default\"];\n  if (!(n = values.length)) return;\n  if ((p = +p) <= 0 || n < 2) return +valueof(values[0], 0, values);\n  if (p >= 1) return +valueof(values[n - 1], n - 1, values);\n  var n,\n      i = (n - 1) * p,\n      i0 = Math.floor(i),\n      value0 = +valueof(values[i0], i0, values),\n      value1 = +valueof(values[i0 + 1], i0 + 1, values);\n  return value0 + (value1 - value0) * (i - i0);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/quantile.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/range.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/range.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(start, stop, step) {\n  start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;\n\n  var i = -1,\n      n = Math.max(0, Math.ceil((stop - start) / step)) | 0,\n      range = new Array(n);\n\n  while (++i < n) {\n    range[i] = start + i * step;\n  }\n\n  return range;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/range.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/scan.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/scan.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ascending.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, compare) {\n  if (!(n = values.length)) return;\n  var n,\n      i = 0,\n      j = 0,\n      xi,\n      xj = values[j];\n\n  if (compare == null) compare = _ascending__WEBPACK_IMPORTED_MODULE_0__[\"default\"];\n\n  while (++i < n) {\n    if (compare(xi = values[i], xj) < 0 || compare(xj, xj) !== 0) {\n      xj = xi, j = i;\n    }\n  }\n\n  if (compare(xj, xj) === 0) return j;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/scan.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/shuffle.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/shuffle.js ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(array, i0, i1) {\n  var m = (i1 == null ? array.length : i1) - (i0 = i0 == null ? 0 : +i0),\n      t,\n      i;\n\n  while (m) {\n    i = Math.random() * m-- | 0;\n    t = array[m + i0];\n    array[m + i0] = array[i + i0];\n    array[i + i0] = t;\n  }\n\n  return array;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/shuffle.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/sum.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/sum.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      i = -1,\n      value,\n      sum = 0;\n\n  if (valueof == null) {\n    while (++i < n) {\n      if (value = +values[i]) sum += value; // Note: zero and null are equivalent.\n    }\n  }\n\n  else {\n    while (++i < n) {\n      if (value = +valueof(values[i], i, values)) sum += value;\n    }\n  }\n\n  return sum;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/sum.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/freedmanDiaconis.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/freedmanDiaconis.js ***!
  \*********************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../array */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/array.js\");\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ascending */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ascending.js\");\n/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../number */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/number.js\");\n/* harmony import */ var _quantile__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../quantile */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/quantile.js\");\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, min, max) {\n  values = _array__WEBPACK_IMPORTED_MODULE_0__[\"map\"].call(values, _number__WEBPACK_IMPORTED_MODULE_2__[\"default\"]).sort(_ascending__WEBPACK_IMPORTED_MODULE_1__[\"default\"]);\n  return Math.ceil((max - min) / (2 * (Object(_quantile__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(values, 0.75) - Object(_quantile__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(values, 0.25)) * Math.pow(values.length, -1 / 3)));\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/freedmanDiaconis.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/scott.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/scott.js ***!
  \**********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _deviation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../deviation */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/deviation.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, min, max) {\n  return Math.ceil((max - min) / (3.5 * Object(_deviation__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(values) * Math.pow(values.length, -1 / 3)));\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/scott.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/sturges.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/sturges.js ***!
  \************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values) {\n  return Math.ceil(Math.log(values.length) / Math.LN2) + 1;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/sturges.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ticks.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ticks.js ***!
  \************************************************************************************/
/*! exports provided: default, tickIncrement, tickStep */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tickIncrement\", function() { return tickIncrement; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tickStep\", function() { return tickStep; });\nvar e10 = Math.sqrt(50),\n    e5 = Math.sqrt(10),\n    e2 = Math.sqrt(2);\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(start, stop, count) {\n  var reverse,\n      i = -1,\n      n,\n      ticks,\n      step;\n\n  stop = +stop, start = +start, count = +count;\n  if (start === stop && count > 0) return [start];\n  if (reverse = stop < start) n = start, start = stop, stop = n;\n  if ((step = tickIncrement(start, stop, count)) === 0 || !isFinite(step)) return [];\n\n  if (step > 0) {\n    start = Math.ceil(start / step);\n    stop = Math.floor(stop / step);\n    ticks = new Array(n = Math.ceil(stop - start + 1));\n    while (++i < n) ticks[i] = (start + i) * step;\n  } else {\n    start = Math.floor(start * step);\n    stop = Math.ceil(stop * step);\n    ticks = new Array(n = Math.ceil(start - stop + 1));\n    while (++i < n) ticks[i] = (start - i) / step;\n  }\n\n  if (reverse) ticks.reverse();\n\n  return ticks;\n});\n\nfunction tickIncrement(start, stop, count) {\n  var step = (stop - start) / Math.max(0, count),\n      power = Math.floor(Math.log(step) / Math.LN10),\n      error = step / Math.pow(10, power);\n  return power >= 0\n      ? (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1) * Math.pow(10, power)\n      : -Math.pow(10, -power) / (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1);\n}\n\nfunction tickStep(start, stop, count) {\n  var step0 = Math.abs(stop - start) / Math.max(0, count),\n      step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),\n      error = step0 / step1;\n  if (error >= e10) step1 *= 10;\n  else if (error >= e5) step1 *= 5;\n  else if (error >= e2) step1 *= 2;\n  return stop < start ? -step1 : step1;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ticks.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/transpose.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/transpose.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _min__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./min */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/min.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(matrix) {\n  if (!(n = matrix.length)) return [];\n  for (var i = -1, m = Object(_min__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(matrix, length), transpose = new Array(m); ++i < m;) {\n    for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n;) {\n      row[j] = matrix[j][i];\n    }\n  }\n  return transpose;\n});\n\nfunction length(d) {\n  return d.length;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/transpose.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/variance.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/variance.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./number */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/number.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      m = 0,\n      i = -1,\n      mean = 0,\n      value,\n      delta,\n      sum = 0;\n\n  if (valueof == null) {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(values[i]))) {\n        delta = value - mean;\n        mean += delta / ++m;\n        sum += delta * (value - mean);\n      }\n    }\n  }\n\n  else {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(valueof(values[i], i, values)))) {\n        delta = value - mean;\n        mean += delta / ++m;\n        sum += delta * (value - mean);\n      }\n    }\n  }\n\n  if (m > 1) return sum / (m - 1);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/variance.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/zip.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/zip.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _transpose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./transpose */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/transpose.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  return Object(_transpose__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(arguments);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/zip.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/index.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/index.js ***!
  \***********************************************************************************/
/*! exports provided: path */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./path.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/path.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"path\", function() { return _path_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/index.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/path.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/path.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar pi = Math.PI,\n    tau = 2 * pi,\n    epsilon = 1e-6,\n    tauEpsilon = tau - epsilon;\n\nfunction Path() {\n  this._x0 = this._y0 = // start of current subpath\n  this._x1 = this._y1 = null; // end of current subpath\n  this._ = \"\";\n}\n\nfunction path() {\n  return new Path;\n}\n\nPath.prototype = path.prototype = {\n  constructor: Path,\n  moveTo: function(x, y) {\n    this._ += \"M\" + (this._x0 = this._x1 = +x) + \",\" + (this._y0 = this._y1 = +y);\n  },\n  closePath: function() {\n    if (this._x1 !== null) {\n      this._x1 = this._x0, this._y1 = this._y0;\n      this._ += \"Z\";\n    }\n  },\n  lineTo: function(x, y) {\n    this._ += \"L\" + (this._x1 = +x) + \",\" + (this._y1 = +y);\n  },\n  quadraticCurveTo: function(x1, y1, x, y) {\n    this._ += \"Q\" + (+x1) + \",\" + (+y1) + \",\" + (this._x1 = +x) + \",\" + (this._y1 = +y);\n  },\n  bezierCurveTo: function(x1, y1, x2, y2, x, y) {\n    this._ += \"C\" + (+x1) + \",\" + (+y1) + \",\" + (+x2) + \",\" + (+y2) + \",\" + (this._x1 = +x) + \",\" + (this._y1 = +y);\n  },\n  arcTo: function(x1, y1, x2, y2, r) {\n    x1 = +x1, y1 = +y1, x2 = +x2, y2 = +y2, r = +r;\n    var x0 = this._x1,\n        y0 = this._y1,\n        x21 = x2 - x1,\n        y21 = y2 - y1,\n        x01 = x0 - x1,\n        y01 = y0 - y1,\n        l01_2 = x01 * x01 + y01 * y01;\n\n    // Is the radius negative? Error.\n    if (r < 0) throw new Error(\"negative radius: \" + r);\n\n    // Is this path empty? Move to (x1,y1).\n    if (this._x1 === null) {\n      this._ += \"M\" + (this._x1 = x1) + \",\" + (this._y1 = y1);\n    }\n\n    // Or, is (x1,y1) coincident with (x0,y0)? Do nothing.\n    else if (!(l01_2 > epsilon));\n\n    // Or, are (x0,y0), (x1,y1) and (x2,y2) collinear?\n    // Equivalently, is (x1,y1) coincident with (x2,y2)?\n    // Or, is the radius zero? Line to (x1,y1).\n    else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon) || !r) {\n      this._ += \"L\" + (this._x1 = x1) + \",\" + (this._y1 = y1);\n    }\n\n    // Otherwise, draw an arc!\n    else {\n      var x20 = x2 - x0,\n          y20 = y2 - y0,\n          l21_2 = x21 * x21 + y21 * y21,\n          l20_2 = x20 * x20 + y20 * y20,\n          l21 = Math.sqrt(l21_2),\n          l01 = Math.sqrt(l01_2),\n          l = r * Math.tan((pi - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2),\n          t01 = l / l01,\n          t21 = l / l21;\n\n      // If the start tangent is not coincident with (x0,y0), line to.\n      if (Math.abs(t01 - 1) > epsilon) {\n        this._ += \"L\" + (x1 + t01 * x01) + \",\" + (y1 + t01 * y01);\n      }\n\n      this._ += \"A\" + r + \",\" + r + \",0,0,\" + (+(y01 * x20 > x01 * y20)) + \",\" + (this._x1 = x1 + t21 * x21) + \",\" + (this._y1 = y1 + t21 * y21);\n    }\n  },\n  arc: function(x, y, r, a0, a1, ccw) {\n    x = +x, y = +y, r = +r, ccw = !!ccw;\n    var dx = r * Math.cos(a0),\n        dy = r * Math.sin(a0),\n        x0 = x + dx,\n        y0 = y + dy,\n        cw = 1 ^ ccw,\n        da = ccw ? a0 - a1 : a1 - a0;\n\n    // Is the radius negative? Error.\n    if (r < 0) throw new Error(\"negative radius: \" + r);\n\n    // Is this path empty? Move to (x0,y0).\n    if (this._x1 === null) {\n      this._ += \"M\" + x0 + \",\" + y0;\n    }\n\n    // Or, is (x0,y0) not coincident with the previous point? Line to (x0,y0).\n    else if (Math.abs(this._x1 - x0) > epsilon || Math.abs(this._y1 - y0) > epsilon) {\n      this._ += \"L\" + x0 + \",\" + y0;\n    }\n\n    // Is this arc empty? We’re done.\n    if (!r) return;\n\n    // Does the angle go the wrong way? Flip the direction.\n    if (da < 0) da = da % tau + tau;\n\n    // Is this a complete circle? Draw two arcs to complete the circle.\n    if (da > tauEpsilon) {\n      this._ += \"A\" + r + \",\" + r + \",0,1,\" + cw + \",\" + (x - dx) + \",\" + (y - dy) + \"A\" + r + \",\" + r + \",0,1,\" + cw + \",\" + (this._x1 = x0) + \",\" + (this._y1 = y0);\n    }\n\n    // Is this arc non-empty? Draw an arc!\n    else if (da > epsilon) {\n      this._ += \"A\" + r + \",\" + r + \",0,\" + (+(da >= pi)) + \",\" + cw + \",\" + (this._x1 = x + r * Math.cos(a1)) + \",\" + (this._y1 = y + r * Math.sin(a1));\n    }\n  },\n  rect: function(x, y, w, h) {\n    this._ += \"M\" + (this._x0 = this._x1 = +x) + \",\" + (this._y0 = this._y1 = +y) + \"h\" + (+w) + \"v\" + (+h) + \"h\" + (-w) + \"Z\";\n  },\n  toString: function() {\n    return this._;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (path);\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/path.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/arc.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/arc.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var d3_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-path */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/index.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./math.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/math.js\");\n\n\n\n\nfunction arcInnerRadius(d) {\n  return d.innerRadius;\n}\n\nfunction arcOuterRadius(d) {\n  return d.outerRadius;\n}\n\nfunction arcStartAngle(d) {\n  return d.startAngle;\n}\n\nfunction arcEndAngle(d) {\n  return d.endAngle;\n}\n\nfunction arcPadAngle(d) {\n  return d && d.padAngle; // Note: optional!\n}\n\nfunction intersect(x0, y0, x1, y1, x2, y2, x3, y3) {\n  var x10 = x1 - x0, y10 = y1 - y0,\n      x32 = x3 - x2, y32 = y3 - y2,\n      t = y32 * x10 - x32 * y10;\n  if (t * t < _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) return;\n  t = (x32 * (y0 - y2) - y32 * (x0 - x2)) / t;\n  return [x0 + t * x10, y0 + t * y10];\n}\n\n// Compute perpendicular offset line of length rc.\n// http://mathworld.wolfram.com/Circle-LineIntersection.html\nfunction cornerTangents(x0, y0, x1, y1, r1, rc, cw) {\n  var x01 = x0 - x1,\n      y01 = y0 - y1,\n      lo = (cw ? rc : -rc) / Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(x01 * x01 + y01 * y01),\n      ox = lo * y01,\n      oy = -lo * x01,\n      x11 = x0 + ox,\n      y11 = y0 + oy,\n      x10 = x1 + ox,\n      y10 = y1 + oy,\n      x00 = (x11 + x10) / 2,\n      y00 = (y11 + y10) / 2,\n      dx = x10 - x11,\n      dy = y10 - y11,\n      d2 = dx * dx + dy * dy,\n      r = r1 - rc,\n      D = x11 * y10 - x10 * y11,\n      d = (dy < 0 ? -1 : 1) * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"max\"])(0, r * r * d2 - D * D)),\n      cx0 = (D * dy - dx * d) / d2,\n      cy0 = (-D * dx - dy * d) / d2,\n      cx1 = (D * dy + dx * d) / d2,\n      cy1 = (-D * dx + dy * d) / d2,\n      dx0 = cx0 - x00,\n      dy0 = cy0 - y00,\n      dx1 = cx1 - x00,\n      dy1 = cy1 - y00;\n\n  // Pick the closer of the two intersection points.\n  // TODO Is there a faster way to determine which intersection to use?\n  if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) cx0 = cx1, cy0 = cy1;\n\n  return {\n    cx: cx0,\n    cy: cy0,\n    x01: -ox,\n    y01: -oy,\n    x11: cx0 * (r1 / r - 1),\n    y11: cy0 * (r1 / r - 1)\n  };\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var innerRadius = arcInnerRadius,\n      outerRadius = arcOuterRadius,\n      cornerRadius = Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(0),\n      padRadius = null,\n      startAngle = arcStartAngle,\n      endAngle = arcEndAngle,\n      padAngle = arcPadAngle,\n      context = null;\n\n  function arc() {\n    var buffer,\n        r,\n        r0 = +innerRadius.apply(this, arguments),\n        r1 = +outerRadius.apply(this, arguments),\n        a0 = startAngle.apply(this, arguments) - _math_js__WEBPACK_IMPORTED_MODULE_2__[\"halfPi\"],\n        a1 = endAngle.apply(this, arguments) - _math_js__WEBPACK_IMPORTED_MODULE_2__[\"halfPi\"],\n        da = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"abs\"])(a1 - a0),\n        cw = a1 > a0;\n\n    if (!context) context = buffer = Object(d3_path__WEBPACK_IMPORTED_MODULE_0__[\"path\"])();\n\n    // Ensure that the outer radius is always larger than the inner radius.\n    if (r1 < r0) r = r1, r1 = r0, r0 = r;\n\n    // Is it a point?\n    if (!(r1 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"])) context.moveTo(0, 0);\n\n    // Or is it a circle or annulus?\n    else if (da > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"tau\"] - _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n      context.moveTo(r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a0), r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a0));\n      context.arc(0, 0, r1, a0, a1, !cw);\n      if (r0 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n        context.moveTo(r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a1), r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a1));\n        context.arc(0, 0, r0, a1, a0, cw);\n      }\n    }\n\n    // Or is it a circular or annular sector?\n    else {\n      var a01 = a0,\n          a11 = a1,\n          a00 = a0,\n          a10 = a1,\n          da0 = da,\n          da1 = da,\n          ap = padAngle.apply(this, arguments) / 2,\n          rp = (ap > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) && (padRadius ? +padRadius.apply(this, arguments) : Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(r0 * r0 + r1 * r1)),\n          rc = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"min\"])(Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"abs\"])(r1 - r0) / 2, +cornerRadius.apply(this, arguments)),\n          rc0 = rc,\n          rc1 = rc,\n          t0,\n          t1;\n\n      // Apply padding? Note that since r1 ≥ r0, da1 ≥ da0.\n      if (rp > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n        var p0 = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"asin\"])(rp / r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(ap)),\n            p1 = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"asin\"])(rp / r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(ap));\n        if ((da0 -= p0 * 2) > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) p0 *= (cw ? 1 : -1), a00 += p0, a10 -= p0;\n        else da0 = 0, a00 = a10 = (a0 + a1) / 2;\n        if ((da1 -= p1 * 2) > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) p1 *= (cw ? 1 : -1), a01 += p1, a11 -= p1;\n        else da1 = 0, a01 = a11 = (a0 + a1) / 2;\n      }\n\n      var x01 = r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a01),\n          y01 = r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a01),\n          x10 = r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a10),\n          y10 = r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a10);\n\n      // Apply rounded corners?\n      if (rc > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n        var x11 = r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a11),\n            y11 = r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a11),\n            x00 = r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a00),\n            y00 = r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a00),\n            oc;\n\n        // Restrict the corner radius according to the sector angle.\n        if (da < _math_js__WEBPACK_IMPORTED_MODULE_2__[\"pi\"] && (oc = intersect(x01, y01, x00, y00, x11, y11, x10, y10))) {\n          var ax = x01 - oc[0],\n              ay = y01 - oc[1],\n              bx = x11 - oc[0],\n              by = y11 - oc[1],\n              kc = 1 / Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"acos\"])((ax * bx + ay * by) / (Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(ax * ax + ay * ay) * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(bx * bx + by * by))) / 2),\n              lc = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(oc[0] * oc[0] + oc[1] * oc[1]);\n          rc0 = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"min\"])(rc, (r0 - lc) / (kc - 1));\n          rc1 = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"min\"])(rc, (r1 - lc) / (kc + 1));\n        }\n      }\n\n      // Is the sector collapsed to a line?\n      if (!(da1 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"])) context.moveTo(x01, y01);\n\n      // Does the sector’s outer ring have rounded corners?\n      else if (rc1 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n        t0 = cornerTangents(x00, y00, x01, y01, r1, rc1, cw);\n        t1 = cornerTangents(x11, y11, x10, y10, r1, rc1, cw);\n\n        context.moveTo(t0.cx + t0.x01, t0.cy + t0.y01);\n\n        // Have the corners merged?\n        if (rc1 < rc) context.arc(t0.cx, t0.cy, rc1, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y01, t0.x01), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y01, t1.x01), !cw);\n\n        // Otherwise, draw the two corners and the ring.\n        else {\n          context.arc(t0.cx, t0.cy, rc1, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y01, t0.x01), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y11, t0.x11), !cw);\n          context.arc(0, 0, r1, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.cy + t0.y11, t0.cx + t0.x11), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.cy + t1.y11, t1.cx + t1.x11), !cw);\n          context.arc(t1.cx, t1.cy, rc1, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y11, t1.x11), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y01, t1.x01), !cw);\n        }\n      }\n\n      // Or is the outer ring just a circular arc?\n      else context.moveTo(x01, y01), context.arc(0, 0, r1, a01, a11, !cw);\n\n      // Is there no inner ring, and it’s a circular sector?\n      // Or perhaps it’s an annular sector collapsed due to padding?\n      if (!(r0 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) || !(da0 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"])) context.lineTo(x10, y10);\n\n      // Does the sector’s inner ring (or point) have rounded corners?\n      else if (rc0 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n        t0 = cornerTangents(x10, y10, x11, y11, r0, -rc0, cw);\n        t1 = cornerTangents(x01, y01, x00, y00, r0, -rc0, cw);\n\n        context.lineTo(t0.cx + t0.x01, t0.cy + t0.y01);\n\n        // Have the corners merged?\n        if (rc0 < rc) context.arc(t0.cx, t0.cy, rc0, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y01, t0.x01), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y01, t1.x01), !cw);\n\n        // Otherwise, draw the two corners and the ring.\n        else {\n          context.arc(t0.cx, t0.cy, rc0, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y01, t0.x01), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y11, t0.x11), !cw);\n          context.arc(0, 0, r0, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.cy + t0.y11, t0.cx + t0.x11), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.cy + t1.y11, t1.cx + t1.x11), cw);\n          context.arc(t1.cx, t1.cy, rc0, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y11, t1.x11), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y01, t1.x01), !cw);\n        }\n      }\n\n      // Or is the inner ring just a circular arc?\n      else context.arc(0, 0, r0, a10, a00, cw);\n    }\n\n    context.closePath();\n\n    if (buffer) return context = null, buffer + \"\" || null;\n  }\n\n  arc.centroid = function() {\n    var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2,\n        a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - _math_js__WEBPACK_IMPORTED_MODULE_2__[\"pi\"] / 2;\n    return [Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a) * r, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a) * r];\n  };\n\n  arc.innerRadius = function(_) {\n    return arguments.length ? (innerRadius = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : innerRadius;\n  };\n\n  arc.outerRadius = function(_) {\n    return arguments.length ? (outerRadius = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : outerRadius;\n  };\n\n  arc.cornerRadius = function(_) {\n    return arguments.length ? (cornerRadius = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : cornerRadius;\n  };\n\n  arc.padRadius = function(_) {\n    return arguments.length ? (padRadius = _ == null ? null : typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : padRadius;\n  };\n\n  arc.startAngle = function(_) {\n    return arguments.length ? (startAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : startAngle;\n  };\n\n  arc.endAngle = function(_) {\n    return arguments.length ? (endAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : endAngle;\n  };\n\n  arc.padAngle = function(_) {\n    return arguments.length ? (padAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : padAngle;\n  };\n\n  arc.context = function(_) {\n    return arguments.length ? ((context = _ == null ? null : _), arc) : context;\n  };\n\n  return arc;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/arc.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/area.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/area.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var d3_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-path */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/index.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _curve_linear_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./curve/linear.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linear.js\");\n/* harmony import */ var _line_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./line.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/line.js\");\n/* harmony import */ var _point_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./point.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/point.js\");\n\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var x0 = _point_js__WEBPACK_IMPORTED_MODULE_4__[\"x\"],\n      x1 = null,\n      y0 = Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(0),\n      y1 = _point_js__WEBPACK_IMPORTED_MODULE_4__[\"y\"],\n      defined = Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(true),\n      context = null,\n      curve = _curve_linear_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n      output = null;\n\n  function area(data) {\n    var i,\n        j,\n        k,\n        n = data.length,\n        d,\n        defined0 = false,\n        buffer,\n        x0z = new Array(n),\n        y0z = new Array(n);\n\n    if (context == null) output = curve(buffer = Object(d3_path__WEBPACK_IMPORTED_MODULE_0__[\"path\"])());\n\n    for (i = 0; i <= n; ++i) {\n      if (!(i < n && defined(d = data[i], i, data)) === defined0) {\n        if (defined0 = !defined0) {\n          j = i;\n          output.areaStart();\n          output.lineStart();\n        } else {\n          output.lineEnd();\n          output.lineStart();\n          for (k = i - 1; k >= j; --k) {\n            output.point(x0z[k], y0z[k]);\n          }\n          output.lineEnd();\n          output.areaEnd();\n        }\n      }\n      if (defined0) {\n        x0z[i] = +x0(d, i, data), y0z[i] = +y0(d, i, data);\n        output.point(x1 ? +x1(d, i, data) : x0z[i], y1 ? +y1(d, i, data) : y0z[i]);\n      }\n    }\n\n    if (buffer) return output = null, buffer + \"\" || null;\n  }\n\n  function arealine() {\n    return Object(_line_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])().defined(defined).curve(curve).context(context);\n  }\n\n  area.x = function(_) {\n    return arguments.length ? (x0 = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), x1 = null, area) : x0;\n  };\n\n  area.x0 = function(_) {\n    return arguments.length ? (x0 = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), area) : x0;\n  };\n\n  area.x1 = function(_) {\n    return arguments.length ? (x1 = _ == null ? null : typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), area) : x1;\n  };\n\n  area.y = function(_) {\n    return arguments.length ? (y0 = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), y1 = null, area) : y0;\n  };\n\n  area.y0 = function(_) {\n    return arguments.length ? (y0 = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), area) : y0;\n  };\n\n  area.y1 = function(_) {\n    return arguments.length ? (y1 = _ == null ? null : typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), area) : y1;\n  };\n\n  area.lineX0 =\n  area.lineY0 = function() {\n    return arealine().x(x0).y(y0);\n  };\n\n  area.lineY1 = function() {\n    return arealine().x(x0).y(y1);\n  };\n\n  area.lineX1 = function() {\n    return arealine().x(x1).y(y0);\n  };\n\n  area.defined = function(_) {\n    return arguments.length ? (defined = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(!!_), area) : defined;\n  };\n\n  area.curve = function(_) {\n    return arguments.length ? (curve = _, context != null && (output = curve(context)), area) : curve;\n  };\n\n  area.context = function(_) {\n    return arguments.length ? (_ == null ? context = output = null : output = curve(context = _), area) : context;\n  };\n\n  return area;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/area.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/areaRadial.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/areaRadial.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _curve_radial_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./curve/radial.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/radial.js\");\n/* harmony import */ var _area_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./area.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/area.js\");\n/* harmony import */ var _lineRadial_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lineRadial.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/lineRadial.js\");\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var a = Object(_area_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])().curve(_curve_radial_js__WEBPACK_IMPORTED_MODULE_0__[\"curveRadialLinear\"]),\n      c = a.curve,\n      x0 = a.lineX0,\n      x1 = a.lineX1,\n      y0 = a.lineY0,\n      y1 = a.lineY1;\n\n  a.angle = a.x, delete a.x;\n  a.startAngle = a.x0, delete a.x0;\n  a.endAngle = a.x1, delete a.x1;\n  a.radius = a.y, delete a.y;\n  a.innerRadius = a.y0, delete a.y0;\n  a.outerRadius = a.y1, delete a.y1;\n  a.lineStartAngle = function() { return Object(_lineRadial_js__WEBPACK_IMPORTED_MODULE_2__[\"lineRadial\"])(x0()); }, delete a.lineX0;\n  a.lineEndAngle = function() { return Object(_lineRadial_js__WEBPACK_IMPORTED_MODULE_2__[\"lineRadial\"])(x1()); }, delete a.lineX1;\n  a.lineInnerRadius = function() { return Object(_lineRadial_js__WEBPACK_IMPORTED_MODULE_2__[\"lineRadial\"])(y0()); }, delete a.lineY0;\n  a.lineOuterRadius = function() { return Object(_lineRadial_js__WEBPACK_IMPORTED_MODULE_2__[\"lineRadial\"])(y1()); }, delete a.lineY1;\n\n  a.curve = function(_) {\n    return arguments.length ? c(Object(_curve_radial_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(_)) : c()._curve;\n  };\n\n  return a;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/areaRadial.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/array.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/array.js ***!
  \************************************************************************************/
/*! exports provided: slice */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"slice\", function() { return slice; });\nvar slice = Array.prototype.slice;\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/array.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x) {\n  return function constant() {\n    return x;\n  };\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basis.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basis.js ***!
  \******************************************************************************************/
/*! exports provided: point, Basis, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"point\", function() { return point; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Basis\", function() { return Basis; });\nfunction point(that, x, y) {\n  that._context.bezierCurveTo(\n    (2 * that._x0 + that._x1) / 3,\n    (2 * that._y0 + that._y1) / 3,\n    (that._x0 + 2 * that._x1) / 3,\n    (that._y0 + 2 * that._y1) / 3,\n    (that._x0 + 4 * that._x1 + x) / 6,\n    (that._y0 + 4 * that._y1 + y) / 6\n  );\n}\n\nfunction Basis(context) {\n  this._context = context;\n}\n\nBasis.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 =\n    this._y0 = this._y1 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 3: point(this, this._x1, this._y1); // proceed\n      case 2: this._context.lineTo(this._x1, this._y1); break;\n    }\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6); // proceed\n      default: point(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = x;\n    this._y0 = this._y1, this._y1 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new Basis(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basis.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basisClosed.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basisClosed.js ***!
  \************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _noop_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../noop.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/noop.js\");\n/* harmony import */ var _basis_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./basis.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basis.js\");\n\n\n\nfunction BasisClosed(context) {\n  this._context = context;\n}\n\nBasisClosed.prototype = {\n  areaStart: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  areaEnd: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 =\n    this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 1: {\n        this._context.moveTo(this._x2, this._y2);\n        this._context.closePath();\n        break;\n      }\n      case 2: {\n        this._context.moveTo((this._x2 + 2 * this._x3) / 3, (this._y2 + 2 * this._y3) / 3);\n        this._context.lineTo((this._x3 + 2 * this._x2) / 3, (this._y3 + 2 * this._y2) / 3);\n        this._context.closePath();\n        break;\n      }\n      case 3: {\n        this.point(this._x2, this._y2);\n        this.point(this._x3, this._y3);\n        this.point(this._x4, this._y4);\n        break;\n      }\n    }\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._x2 = x, this._y2 = y; break;\n      case 1: this._point = 2; this._x3 = x, this._y3 = y; break;\n      case 2: this._point = 3; this._x4 = x, this._y4 = y; this._context.moveTo((this._x0 + 4 * this._x1 + x) / 6, (this._y0 + 4 * this._y1 + y) / 6); break;\n      default: Object(_basis_js__WEBPACK_IMPORTED_MODULE_1__[\"point\"])(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = x;\n    this._y0 = this._y1, this._y1 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new BasisClosed(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basisClosed.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basisOpen.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basisOpen.js ***!
  \**********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _basis_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./basis.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basis.js\");\n\n\nfunction BasisOpen(context) {\n  this._context = context;\n}\n\nBasisOpen.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 =\n    this._y0 = this._y1 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (this._line || (this._line !== 0 && this._point === 3)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; var x0 = (this._x0 + 4 * this._x1 + x) / 6, y0 = (this._y0 + 4 * this._y1 + y) / 6; this._line ? this._context.lineTo(x0, y0) : this._context.moveTo(x0, y0); break;\n      case 3: this._point = 4; // proceed\n      default: Object(_basis_js__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = x;\n    this._y0 = this._y1, this._y1 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new BasisOpen(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basisOpen.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/bundle.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/bundle.js ***!
  \*******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _basis_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./basis.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basis.js\");\n\n\nfunction Bundle(context, beta) {\n  this._basis = new _basis_js__WEBPACK_IMPORTED_MODULE_0__[\"Basis\"](context);\n  this._beta = beta;\n}\n\nBundle.prototype = {\n  lineStart: function() {\n    this._x = [];\n    this._y = [];\n    this._basis.lineStart();\n  },\n  lineEnd: function() {\n    var x = this._x,\n        y = this._y,\n        j = x.length - 1;\n\n    if (j > 0) {\n      var x0 = x[0],\n          y0 = y[0],\n          dx = x[j] - x0,\n          dy = y[j] - y0,\n          i = -1,\n          t;\n\n      while (++i <= j) {\n        t = i / j;\n        this._basis.point(\n          this._beta * x[i] + (1 - this._beta) * (x0 + t * dx),\n          this._beta * y[i] + (1 - this._beta) * (y0 + t * dy)\n        );\n      }\n    }\n\n    this._x = this._y = null;\n    this._basis.lineEnd();\n  },\n  point: function(x, y) {\n    this._x.push(+x);\n    this._y.push(+y);\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(beta) {\n\n  function bundle(context) {\n    return beta === 1 ? new _basis_js__WEBPACK_IMPORTED_MODULE_0__[\"Basis\"](context) : new Bundle(context, beta);\n  }\n\n  bundle.beta = function(beta) {\n    return custom(+beta);\n  };\n\n  return bundle;\n})(0.85));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/bundle.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinal.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinal.js ***!
  \*********************************************************************************************/
/*! exports provided: point, Cardinal, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"point\", function() { return point; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Cardinal\", function() { return Cardinal; });\nfunction point(that, x, y) {\n  that._context.bezierCurveTo(\n    that._x1 + that._k * (that._x2 - that._x0),\n    that._y1 + that._k * (that._y2 - that._y0),\n    that._x2 + that._k * (that._x1 - x),\n    that._y2 + that._k * (that._y1 - y),\n    that._x2,\n    that._y2\n  );\n}\n\nfunction Cardinal(context, tension) {\n  this._context = context;\n  this._k = (1 - tension) / 6;\n}\n\nCardinal.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 =\n    this._y0 = this._y1 = this._y2 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 2: this._context.lineTo(this._x2, this._y2); break;\n      case 3: point(this, this._x1, this._y1); break;\n    }\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; this._x1 = x, this._y1 = y; break;\n      case 2: this._point = 3; // proceed\n      default: point(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(tension) {\n\n  function cardinal(context) {\n    return new Cardinal(context, tension);\n  }\n\n  cardinal.tension = function(tension) {\n    return custom(+tension);\n  };\n\n  return cardinal;\n})(0));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinal.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalClosed.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalClosed.js ***!
  \***************************************************************************************************/
/*! exports provided: CardinalClosed, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"CardinalClosed\", function() { return CardinalClosed; });\n/* harmony import */ var _noop_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../noop.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/noop.js\");\n/* harmony import */ var _cardinal_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cardinal.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinal.js\");\n\n\n\nfunction CardinalClosed(context, tension) {\n  this._context = context;\n  this._k = (1 - tension) / 6;\n}\n\nCardinalClosed.prototype = {\n  areaStart: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  areaEnd: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 =\n    this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 1: {\n        this._context.moveTo(this._x3, this._y3);\n        this._context.closePath();\n        break;\n      }\n      case 2: {\n        this._context.lineTo(this._x3, this._y3);\n        this._context.closePath();\n        break;\n      }\n      case 3: {\n        this.point(this._x3, this._y3);\n        this.point(this._x4, this._y4);\n        this.point(this._x5, this._y5);\n        break;\n      }\n    }\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._x3 = x, this._y3 = y; break;\n      case 1: this._point = 2; this._context.moveTo(this._x4 = x, this._y4 = y); break;\n      case 2: this._point = 3; this._x5 = x, this._y5 = y; break;\n      default: Object(_cardinal_js__WEBPACK_IMPORTED_MODULE_1__[\"point\"])(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(tension) {\n\n  function cardinal(context) {\n    return new CardinalClosed(context, tension);\n  }\n\n  cardinal.tension = function(tension) {\n    return custom(+tension);\n  };\n\n  return cardinal;\n})(0));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalClosed.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalOpen.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalOpen.js ***!
  \*************************************************************************************************/
/*! exports provided: CardinalOpen, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"CardinalOpen\", function() { return CardinalOpen; });\n/* harmony import */ var _cardinal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cardinal.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinal.js\");\n\n\nfunction CardinalOpen(context, tension) {\n  this._context = context;\n  this._k = (1 - tension) / 6;\n}\n\nCardinalOpen.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 =\n    this._y0 = this._y1 = this._y2 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (this._line || (this._line !== 0 && this._point === 3)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2); break;\n      case 3: this._point = 4; // proceed\n      default: Object(_cardinal_js__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(tension) {\n\n  function cardinal(context) {\n    return new CardinalOpen(context, tension);\n  }\n\n  cardinal.tension = function(tension) {\n    return custom(+tension);\n  };\n\n  return cardinal;\n})(0));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalOpen.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRom.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRom.js ***!
  \***********************************************************************************************/
/*! exports provided: point, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"point\", function() { return point; });\n/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../math.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/math.js\");\n/* harmony import */ var _cardinal_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cardinal.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinal.js\");\n\n\n\nfunction point(that, x, y) {\n  var x1 = that._x1,\n      y1 = that._y1,\n      x2 = that._x2,\n      y2 = that._y2;\n\n  if (that._l01_a > _math_js__WEBPACK_IMPORTED_MODULE_0__[\"epsilon\"]) {\n    var a = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a,\n        n = 3 * that._l01_a * (that._l01_a + that._l12_a);\n    x1 = (x1 * a - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n;\n    y1 = (y1 * a - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;\n  }\n\n  if (that._l23_a > _math_js__WEBPACK_IMPORTED_MODULE_0__[\"epsilon\"]) {\n    var b = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a,\n        m = 3 * that._l23_a * (that._l23_a + that._l12_a);\n    x2 = (x2 * b + that._x1 * that._l23_2a - x * that._l12_2a) / m;\n    y2 = (y2 * b + that._y1 * that._l23_2a - y * that._l12_2a) / m;\n  }\n\n  that._context.bezierCurveTo(x1, y1, x2, y2, that._x2, that._y2);\n}\n\nfunction CatmullRom(context, alpha) {\n  this._context = context;\n  this._alpha = alpha;\n}\n\nCatmullRom.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 =\n    this._y0 = this._y1 = this._y2 = NaN;\n    this._l01_a = this._l12_a = this._l23_a =\n    this._l01_2a = this._l12_2a = this._l23_2a =\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 2: this._context.lineTo(this._x2, this._y2); break;\n      case 3: this.point(this._x2, this._y2); break;\n    }\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n\n    if (this._point) {\n      var x23 = this._x2 - x,\n          y23 = this._y2 - y;\n      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));\n    }\n\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; // proceed\n      default: point(this, x, y); break;\n    }\n\n    this._l01_a = this._l12_a, this._l12_a = this._l23_a;\n    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(alpha) {\n\n  function catmullRom(context) {\n    return alpha ? new CatmullRom(context, alpha) : new _cardinal_js__WEBPACK_IMPORTED_MODULE_1__[\"Cardinal\"](context, 0);\n  }\n\n  catmullRom.alpha = function(alpha) {\n    return custom(+alpha);\n  };\n\n  return catmullRom;\n})(0.5));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRom.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRomClosed.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRomClosed.js ***!
  \*****************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _cardinalClosed_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cardinalClosed.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalClosed.js\");\n/* harmony import */ var _noop_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../noop.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/noop.js\");\n/* harmony import */ var _catmullRom_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./catmullRom.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRom.js\");\n\n\n\n\nfunction CatmullRomClosed(context, alpha) {\n  this._context = context;\n  this._alpha = alpha;\n}\n\nCatmullRomClosed.prototype = {\n  areaStart: _noop_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  areaEnd: _noop_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 =\n    this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;\n    this._l01_a = this._l12_a = this._l23_a =\n    this._l01_2a = this._l12_2a = this._l23_2a =\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 1: {\n        this._context.moveTo(this._x3, this._y3);\n        this._context.closePath();\n        break;\n      }\n      case 2: {\n        this._context.lineTo(this._x3, this._y3);\n        this._context.closePath();\n        break;\n      }\n      case 3: {\n        this.point(this._x3, this._y3);\n        this.point(this._x4, this._y4);\n        this.point(this._x5, this._y5);\n        break;\n      }\n    }\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n\n    if (this._point) {\n      var x23 = this._x2 - x,\n          y23 = this._y2 - y;\n      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));\n    }\n\n    switch (this._point) {\n      case 0: this._point = 1; this._x3 = x, this._y3 = y; break;\n      case 1: this._point = 2; this._context.moveTo(this._x4 = x, this._y4 = y); break;\n      case 2: this._point = 3; this._x5 = x, this._y5 = y; break;\n      default: Object(_catmullRom_js__WEBPACK_IMPORTED_MODULE_2__[\"point\"])(this, x, y); break;\n    }\n\n    this._l01_a = this._l12_a, this._l12_a = this._l23_a;\n    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(alpha) {\n\n  function catmullRom(context) {\n    return alpha ? new CatmullRomClosed(context, alpha) : new _cardinalClosed_js__WEBPACK_IMPORTED_MODULE_0__[\"CardinalClosed\"](context, 0);\n  }\n\n  catmullRom.alpha = function(alpha) {\n    return custom(+alpha);\n  };\n\n  return catmullRom;\n})(0.5));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRomClosed.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRomOpen.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRomOpen.js ***!
  \***************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _cardinalOpen_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cardinalOpen.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalOpen.js\");\n/* harmony import */ var _catmullRom_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./catmullRom.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRom.js\");\n\n\n\nfunction CatmullRomOpen(context, alpha) {\n  this._context = context;\n  this._alpha = alpha;\n}\n\nCatmullRomOpen.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 =\n    this._y0 = this._y1 = this._y2 = NaN;\n    this._l01_a = this._l12_a = this._l23_a =\n    this._l01_2a = this._l12_2a = this._l23_2a =\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (this._line || (this._line !== 0 && this._point === 3)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n\n    if (this._point) {\n      var x23 = this._x2 - x,\n          y23 = this._y2 - y;\n      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));\n    }\n\n    switch (this._point) {\n      case 0: this._point = 1; break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2); break;\n      case 3: this._point = 4; // proceed\n      default: Object(_catmullRom_js__WEBPACK_IMPORTED_MODULE_1__[\"point\"])(this, x, y); break;\n    }\n\n    this._l01_a = this._l12_a, this._l12_a = this._l23_a;\n    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(alpha) {\n\n  function catmullRom(context) {\n    return alpha ? new CatmullRomOpen(context, alpha) : new _cardinalOpen_js__WEBPACK_IMPORTED_MODULE_0__[\"CardinalOpen\"](context, 0);\n  }\n\n  catmullRom.alpha = function(alpha) {\n    return custom(+alpha);\n  };\n\n  return catmullRom;\n})(0.5));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRomOpen.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linear.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linear.js ***!
  \*******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction Linear(context) {\n  this._context = context;\n}\n\nLinear.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; // proceed\n      default: this._context.lineTo(x, y); break;\n    }\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new Linear(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linear.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linearClosed.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linearClosed.js ***!
  \*************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _noop_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../noop.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/noop.js\");\n\n\nfunction LinearClosed(context) {\n  this._context = context;\n}\n\nLinearClosed.prototype = {\n  areaStart: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  areaEnd: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  lineStart: function() {\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (this._point) this._context.closePath();\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    if (this._point) this._context.lineTo(x, y);\n    else this._point = 1, this._context.moveTo(x, y);\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new LinearClosed(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linearClosed.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/monotone.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/monotone.js ***!
  \*********************************************************************************************/
/*! exports provided: monotoneX, monotoneY */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"monotoneX\", function() { return monotoneX; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"monotoneY\", function() { return monotoneY; });\nfunction sign(x) {\n  return x < 0 ? -1 : 1;\n}\n\n// Calculate the slopes of the tangents (Hermite-type interpolation) based on\n// the following paper: Steffen, M. 1990. A Simple Method for Monotonic\n// Interpolation in One Dimension. Astronomy and Astrophysics, Vol. 239, NO.\n// NOV(II), P. 443, 1990.\nfunction slope3(that, x2, y2) {\n  var h0 = that._x1 - that._x0,\n      h1 = x2 - that._x1,\n      s0 = (that._y1 - that._y0) / (h0 || h1 < 0 && -0),\n      s1 = (y2 - that._y1) / (h1 || h0 < 0 && -0),\n      p = (s0 * h1 + s1 * h0) / (h0 + h1);\n  return (sign(s0) + sign(s1)) * Math.min(Math.abs(s0), Math.abs(s1), 0.5 * Math.abs(p)) || 0;\n}\n\n// Calculate a one-sided slope.\nfunction slope2(that, t) {\n  var h = that._x1 - that._x0;\n  return h ? (3 * (that._y1 - that._y0) / h - t) / 2 : t;\n}\n\n// According to https://en.wikipedia.org/wiki/Cubic_Hermite_spline#Representations\n// \"you can express cubic Hermite interpolation in terms of cubic Bézier curves\n// with respect to the four values p0, p0 + m0 / 3, p1 - m1 / 3, p1\".\nfunction point(that, t0, t1) {\n  var x0 = that._x0,\n      y0 = that._y0,\n      x1 = that._x1,\n      y1 = that._y1,\n      dx = (x1 - x0) / 3;\n  that._context.bezierCurveTo(x0 + dx, y0 + dx * t0, x1 - dx, y1 - dx * t1, x1, y1);\n}\n\nfunction MonotoneX(context) {\n  this._context = context;\n}\n\nMonotoneX.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 =\n    this._y0 = this._y1 =\n    this._t0 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 2: this._context.lineTo(this._x1, this._y1); break;\n      case 3: point(this, this._t0, slope2(this, this._t0)); break;\n    }\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    var t1 = NaN;\n\n    x = +x, y = +y;\n    if (x === this._x1 && y === this._y1) return; // Ignore coincident points.\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; point(this, slope2(this, t1 = slope3(this, x, y)), t1); break;\n      default: point(this, this._t0, t1 = slope3(this, x, y)); break;\n    }\n\n    this._x0 = this._x1, this._x1 = x;\n    this._y0 = this._y1, this._y1 = y;\n    this._t0 = t1;\n  }\n}\n\nfunction MonotoneY(context) {\n  this._context = new ReflectContext(context);\n}\n\n(MonotoneY.prototype = Object.create(MonotoneX.prototype)).point = function(x, y) {\n  MonotoneX.prototype.point.call(this, y, x);\n};\n\nfunction ReflectContext(context) {\n  this._context = context;\n}\n\nReflectContext.prototype = {\n  moveTo: function(x, y) { this._context.moveTo(y, x); },\n  closePath: function() { this._context.closePath(); },\n  lineTo: function(x, y) { this._context.lineTo(y, x); },\n  bezierCurveTo: function(x1, y1, x2, y2, x, y) { this._context.bezierCurveTo(y1, x1, y2, x2, y, x); }\n};\n\nfunction monotoneX(context) {\n  return new MonotoneX(context);\n}\n\nfunction monotoneY(context) {\n  return new MonotoneY(context);\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/monotone.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/natural.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/natural.js ***!
  \********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction Natural(context) {\n  this._context = context;\n}\n\nNatural.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x = [];\n    this._y = [];\n  },\n  lineEnd: function() {\n    var x = this._x,\n        y = this._y,\n        n = x.length;\n\n    if (n) {\n      this._line ? this._context.lineTo(x[0], y[0]) : this._context.moveTo(x[0], y[0]);\n      if (n === 2) {\n        this._context.lineTo(x[1], y[1]);\n      } else {\n        var px = controlPoints(x),\n            py = controlPoints(y);\n        for (var i0 = 0, i1 = 1; i1 < n; ++i0, ++i1) {\n          this._context.bezierCurveTo(px[0][i0], py[0][i0], px[1][i0], py[1][i0], x[i1], y[i1]);\n        }\n      }\n    }\n\n    if (this._line || (this._line !== 0 && n === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n    this._x = this._y = null;\n  },\n  point: function(x, y) {\n    this._x.push(+x);\n    this._y.push(+y);\n  }\n};\n\n// See https://www.particleincell.com/2012/bezier-splines/ for derivation.\nfunction controlPoints(x) {\n  var i,\n      n = x.length - 1,\n      m,\n      a = new Array(n),\n      b = new Array(n),\n      r = new Array(n);\n  a[0] = 0, b[0] = 2, r[0] = x[0] + 2 * x[1];\n  for (i = 1; i < n - 1; ++i) a[i] = 1, b[i] = 4, r[i] = 4 * x[i] + 2 * x[i + 1];\n  a[n - 1] = 2, b[n - 1] = 7, r[n - 1] = 8 * x[n - 1] + x[n];\n  for (i = 1; i < n; ++i) m = a[i] / b[i - 1], b[i] -= m, r[i] -= m * r[i - 1];\n  a[n - 1] = r[n - 1] / b[n - 1];\n  for (i = n - 2; i >= 0; --i) a[i] = (r[i] - a[i + 1]) / b[i];\n  b[n - 1] = (x[n] + a[n - 1]) / 2;\n  for (i = 0; i < n - 1; ++i) b[i] = 2 * x[i + 1] - a[i + 1];\n  return [a, b];\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new Natural(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/natural.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/radial.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/radial.js ***!
  \*******************************************************************************************/
/*! exports provided: curveRadialLinear, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"curveRadialLinear\", function() { return curveRadialLinear; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return curveRadial; });\n/* harmony import */ var _linear_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./linear.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linear.js\");\n\n\nvar curveRadialLinear = curveRadial(_linear_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\nfunction Radial(curve) {\n  this._curve = curve;\n}\n\nRadial.prototype = {\n  areaStart: function() {\n    this._curve.areaStart();\n  },\n  areaEnd: function() {\n    this._curve.areaEnd();\n  },\n  lineStart: function() {\n    this._curve.lineStart();\n  },\n  lineEnd: function() {\n    this._curve.lineEnd();\n  },\n  point: function(a, r) {\n    this._curve.point(r * Math.sin(a), r * -Math.cos(a));\n  }\n};\n\nfunction curveRadial(curve) {\n\n  function radial(context) {\n    return new Radial(curve(context));\n  }\n\n  radial._curve = curve;\n\n  return radial;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/radial.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/step.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/step.js ***!
  \*****************************************************************************************/
/*! exports provided: default, stepBefore, stepAfter */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"stepBefore\", function() { return stepBefore; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"stepAfter\", function() { return stepAfter; });\nfunction Step(context, t) {\n  this._context = context;\n  this._t = t;\n}\n\nStep.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x = this._y = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (0 < this._t && this._t < 1 && this._point === 2) this._context.lineTo(this._x, this._y);\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    if (this._line >= 0) this._t = 1 - this._t, this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; // proceed\n      default: {\n        if (this._t <= 0) {\n          this._context.lineTo(this._x, y);\n          this._context.lineTo(x, y);\n        } else {\n          var x1 = this._x * (1 - this._t) + x * this._t;\n          this._context.lineTo(x1, this._y);\n          this._context.lineTo(x1, y);\n        }\n        break;\n      }\n    }\n    this._x = x, this._y = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new Step(context, 0.5);\n});\n\nfunction stepBefore(context) {\n  return new Step(context, 0);\n}\n\nfunction stepAfter(context) {\n  return new Step(context, 1);\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/step.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/descending.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/descending.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/descending.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/identity.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/identity.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(d) {\n  return d;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/identity.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/index.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/index.js ***!
  \************************************************************************************/
/*! exports provided: arc, area, line, pie, areaRadial, radialArea, lineRadial, radialLine, pointRadial, linkHorizontal, linkVertical, linkRadial, symbol, symbols, symbolCircle, symbolCross, symbolDiamond, symbolSquare, symbolStar, symbolTriangle, symbolWye, curveBasisClosed, curveBasisOpen, curveBasis, curveBundle, curveCardinalClosed, curveCardinalOpen, curveCardinal, curveCatmullRomClosed, curveCatmullRomOpen, curveCatmullRom, curveLinearClosed, curveLinear, curveMonotoneX, curveMonotoneY, curveNatural, curveStep, curveStepAfter, curveStepBefore, stack, stackOffsetExpand, stackOffsetDiverging, stackOffsetNone, stackOffsetSilhouette, stackOffsetWiggle, stackOrderAppearance, stackOrderAscending, stackOrderDescending, stackOrderInsideOut, stackOrderNone, stackOrderReverse */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _arc_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arc.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/arc.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"arc\", function() { return _arc_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n/* harmony import */ var _area_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./area.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/area.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"area\", function() { return _area_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]; });\n\n/* harmony import */ var _line_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./line.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/line.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"line\", function() { return _line_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]; });\n\n/* harmony import */ var _pie_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pie.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pie.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"pie\", function() { return _pie_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"]; });\n\n/* harmony import */ var _areaRadial_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./areaRadial.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/areaRadial.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"areaRadial\", function() { return _areaRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"radialArea\", function() { return _areaRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]; });\n\n/* harmony import */ var _lineRadial_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./lineRadial.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/lineRadial.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"lineRadial\", function() { return _lineRadial_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"radialLine\", function() { return _lineRadial_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"]; });\n\n/* harmony import */ var _pointRadial_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./pointRadial.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pointRadial.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"pointRadial\", function() { return _pointRadial_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"]; });\n\n/* harmony import */ var _link_index_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./link/index.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/link/index.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"linkHorizontal\", function() { return _link_index_js__WEBPACK_IMPORTED_MODULE_7__[\"linkHorizontal\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"linkVertical\", function() { return _link_index_js__WEBPACK_IMPORTED_MODULE_7__[\"linkVertical\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"linkRadial\", function() { return _link_index_js__WEBPACK_IMPORTED_MODULE_7__[\"linkRadial\"]; });\n\n/* harmony import */ var _symbol_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./symbol.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbol\", function() { return _symbol_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbols\", function() { return _symbol_js__WEBPACK_IMPORTED_MODULE_8__[\"symbols\"]; });\n\n/* harmony import */ var _symbol_circle_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./symbol/circle.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/circle.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolCircle\", function() { return _symbol_circle_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"]; });\n\n/* harmony import */ var _symbol_cross_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./symbol/cross.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/cross.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolCross\", function() { return _symbol_cross_js__WEBPACK_IMPORTED_MODULE_10__[\"default\"]; });\n\n/* harmony import */ var _symbol_diamond_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./symbol/diamond.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/diamond.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolDiamond\", function() { return _symbol_diamond_js__WEBPACK_IMPORTED_MODULE_11__[\"default\"]; });\n\n/* harmony import */ var _symbol_square_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./symbol/square.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/square.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolSquare\", function() { return _symbol_square_js__WEBPACK_IMPORTED_MODULE_12__[\"default\"]; });\n\n/* harmony import */ var _symbol_star_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./symbol/star.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/star.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolStar\", function() { return _symbol_star_js__WEBPACK_IMPORTED_MODULE_13__[\"default\"]; });\n\n/* harmony import */ var _symbol_triangle_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./symbol/triangle.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/triangle.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolTriangle\", function() { return _symbol_triangle_js__WEBPACK_IMPORTED_MODULE_14__[\"default\"]; });\n\n/* harmony import */ var _symbol_wye_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./symbol/wye.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/wye.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolWye\", function() { return _symbol_wye_js__WEBPACK_IMPORTED_MODULE_15__[\"default\"]; });\n\n/* harmony import */ var _curve_basisClosed_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./curve/basisClosed.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basisClosed.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveBasisClosed\", function() { return _curve_basisClosed_js__WEBPACK_IMPORTED_MODULE_16__[\"default\"]; });\n\n/* harmony import */ var _curve_basisOpen_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./curve/basisOpen.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basisOpen.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveBasisOpen\", function() { return _curve_basisOpen_js__WEBPACK_IMPORTED_MODULE_17__[\"default\"]; });\n\n/* harmony import */ var _curve_basis_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./curve/basis.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basis.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveBasis\", function() { return _curve_basis_js__WEBPACK_IMPORTED_MODULE_18__[\"default\"]; });\n\n/* harmony import */ var _curve_bundle_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./curve/bundle.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/bundle.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveBundle\", function() { return _curve_bundle_js__WEBPACK_IMPORTED_MODULE_19__[\"default\"]; });\n\n/* harmony import */ var _curve_cardinalClosed_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./curve/cardinalClosed.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalClosed.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCardinalClosed\", function() { return _curve_cardinalClosed_js__WEBPACK_IMPORTED_MODULE_20__[\"default\"]; });\n\n/* harmony import */ var _curve_cardinalOpen_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./curve/cardinalOpen.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalOpen.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCardinalOpen\", function() { return _curve_cardinalOpen_js__WEBPACK_IMPORTED_MODULE_21__[\"default\"]; });\n\n/* harmony import */ var _curve_cardinal_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./curve/cardinal.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinal.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCardinal\", function() { return _curve_cardinal_js__WEBPACK_IMPORTED_MODULE_22__[\"default\"]; });\n\n/* harmony import */ var _curve_catmullRomClosed_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./curve/catmullRomClosed.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRomClosed.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCatmullRomClosed\", function() { return _curve_catmullRomClosed_js__WEBPACK_IMPORTED_MODULE_23__[\"default\"]; });\n\n/* harmony import */ var _curve_catmullRomOpen_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./curve/catmullRomOpen.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRomOpen.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCatmullRomOpen\", function() { return _curve_catmullRomOpen_js__WEBPACK_IMPORTED_MODULE_24__[\"default\"]; });\n\n/* harmony import */ var _curve_catmullRom_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./curve/catmullRom.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRom.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCatmullRom\", function() { return _curve_catmullRom_js__WEBPACK_IMPORTED_MODULE_25__[\"default\"]; });\n\n/* harmony import */ var _curve_linearClosed_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./curve/linearClosed.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linearClosed.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveLinearClosed\", function() { return _curve_linearClosed_js__WEBPACK_IMPORTED_MODULE_26__[\"default\"]; });\n\n/* harmony import */ var _curve_linear_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./curve/linear.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linear.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveLinear\", function() { return _curve_linear_js__WEBPACK_IMPORTED_MODULE_27__[\"default\"]; });\n\n/* harmony import */ var _curve_monotone_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./curve/monotone.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/monotone.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveMonotoneX\", function() { return _curve_monotone_js__WEBPACK_IMPORTED_MODULE_28__[\"monotoneX\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveMonotoneY\", function() { return _curve_monotone_js__WEBPACK_IMPORTED_MODULE_28__[\"monotoneY\"]; });\n\n/* harmony import */ var _curve_natural_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./curve/natural.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/natural.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveNatural\", function() { return _curve_natural_js__WEBPACK_IMPORTED_MODULE_29__[\"default\"]; });\n\n/* harmony import */ var _curve_step_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./curve/step.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/step.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveStep\", function() { return _curve_step_js__WEBPACK_IMPORTED_MODULE_30__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveStepAfter\", function() { return _curve_step_js__WEBPACK_IMPORTED_MODULE_30__[\"stepAfter\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveStepBefore\", function() { return _curve_step_js__WEBPACK_IMPORTED_MODULE_30__[\"stepBefore\"]; });\n\n/* harmony import */ var _stack_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./stack.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/stack.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stack\", function() { return _stack_js__WEBPACK_IMPORTED_MODULE_31__[\"default\"]; });\n\n/* harmony import */ var _offset_expand_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./offset/expand.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/expand.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOffsetExpand\", function() { return _offset_expand_js__WEBPACK_IMPORTED_MODULE_32__[\"default\"]; });\n\n/* harmony import */ var _offset_diverging_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./offset/diverging.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/diverging.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOffsetDiverging\", function() { return _offset_diverging_js__WEBPACK_IMPORTED_MODULE_33__[\"default\"]; });\n\n/* harmony import */ var _offset_none_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./offset/none.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/none.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOffsetNone\", function() { return _offset_none_js__WEBPACK_IMPORTED_MODULE_34__[\"default\"]; });\n\n/* harmony import */ var _offset_silhouette_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./offset/silhouette.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/silhouette.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOffsetSilhouette\", function() { return _offset_silhouette_js__WEBPACK_IMPORTED_MODULE_35__[\"default\"]; });\n\n/* harmony import */ var _offset_wiggle_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./offset/wiggle.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/wiggle.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOffsetWiggle\", function() { return _offset_wiggle_js__WEBPACK_IMPORTED_MODULE_36__[\"default\"]; });\n\n/* harmony import */ var _order_appearance_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./order/appearance.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/appearance.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderAppearance\", function() { return _order_appearance_js__WEBPACK_IMPORTED_MODULE_37__[\"default\"]; });\n\n/* harmony import */ var _order_ascending_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./order/ascending.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/ascending.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderAscending\", function() { return _order_ascending_js__WEBPACK_IMPORTED_MODULE_38__[\"default\"]; });\n\n/* harmony import */ var _order_descending_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./order/descending.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/descending.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderDescending\", function() { return _order_descending_js__WEBPACK_IMPORTED_MODULE_39__[\"default\"]; });\n\n/* harmony import */ var _order_insideOut_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./order/insideOut.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/insideOut.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderInsideOut\", function() { return _order_insideOut_js__WEBPACK_IMPORTED_MODULE_40__[\"default\"]; });\n\n/* harmony import */ var _order_none_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./order/none.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/none.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderNone\", function() { return _order_none_js__WEBPACK_IMPORTED_MODULE_41__[\"default\"]; });\n\n/* harmony import */ var _order_reverse_js__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./order/reverse.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/reverse.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderReverse\", function() { return _order_reverse_js__WEBPACK_IMPORTED_MODULE_42__[\"default\"]; });\n\n\n\n\n\n // Note: radialArea is deprecated!\n // Note: radialLine is deprecated!\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/index.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/line.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/line.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var d3_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-path */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/index.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _curve_linear_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./curve/linear.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linear.js\");\n/* harmony import */ var _point_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./point.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/point.js\");\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var x = _point_js__WEBPACK_IMPORTED_MODULE_3__[\"x\"],\n      y = _point_js__WEBPACK_IMPORTED_MODULE_3__[\"y\"],\n      defined = Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(true),\n      context = null,\n      curve = _curve_linear_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n      output = null;\n\n  function line(data) {\n    var i,\n        n = data.length,\n        d,\n        defined0 = false,\n        buffer;\n\n    if (context == null) output = curve(buffer = Object(d3_path__WEBPACK_IMPORTED_MODULE_0__[\"path\"])());\n\n    for (i = 0; i <= n; ++i) {\n      if (!(i < n && defined(d = data[i], i, data)) === defined0) {\n        if (defined0 = !defined0) output.lineStart();\n        else output.lineEnd();\n      }\n      if (defined0) output.point(+x(d, i, data), +y(d, i, data));\n    }\n\n    if (buffer) return output = null, buffer + \"\" || null;\n  }\n\n  line.x = function(_) {\n    return arguments.length ? (x = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), line) : x;\n  };\n\n  line.y = function(_) {\n    return arguments.length ? (y = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), line) : y;\n  };\n\n  line.defined = function(_) {\n    return arguments.length ? (defined = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(!!_), line) : defined;\n  };\n\n  line.curve = function(_) {\n    return arguments.length ? (curve = _, context != null && (output = curve(context)), line) : curve;\n  };\n\n  line.context = function(_) {\n    return arguments.length ? (_ == null ? context = output = null : output = curve(context = _), line) : context;\n  };\n\n  return line;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/line.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/lineRadial.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/lineRadial.js ***!
  \*****************************************************************************************/
/*! exports provided: lineRadial, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"lineRadial\", function() { return lineRadial; });\n/* harmony import */ var _curve_radial_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./curve/radial.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/radial.js\");\n/* harmony import */ var _line_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./line.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/line.js\");\n\n\n\nfunction lineRadial(l) {\n  var c = l.curve;\n\n  l.angle = l.x, delete l.x;\n  l.radius = l.y, delete l.y;\n\n  l.curve = function(_) {\n    return arguments.length ? c(Object(_curve_radial_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(_)) : c()._curve;\n  };\n\n  return l;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  return lineRadial(Object(_line_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])().curve(_curve_radial_js__WEBPACK_IMPORTED_MODULE_0__[\"curveRadialLinear\"]));\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/lineRadial.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/link/index.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/link/index.js ***!
  \*****************************************************************************************/
/*! exports provided: linkHorizontal, linkVertical, linkRadial */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"linkHorizontal\", function() { return linkHorizontal; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"linkVertical\", function() { return linkVertical; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"linkRadial\", function() { return linkRadial; });\n/* harmony import */ var d3_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-path */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/index.js\");\n/* harmony import */ var _array_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../array.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/array.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constant.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _point_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../point.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/point.js\");\n/* harmony import */ var _pointRadial_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../pointRadial.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pointRadial.js\");\n\n\n\n\n\n\nfunction linkSource(d) {\n  return d.source;\n}\n\nfunction linkTarget(d) {\n  return d.target;\n}\n\nfunction link(curve) {\n  var source = linkSource,\n      target = linkTarget,\n      x = _point_js__WEBPACK_IMPORTED_MODULE_3__[\"x\"],\n      y = _point_js__WEBPACK_IMPORTED_MODULE_3__[\"y\"],\n      context = null;\n\n  function link() {\n    var buffer, argv = _array_js__WEBPACK_IMPORTED_MODULE_1__[\"slice\"].call(arguments), s = source.apply(this, argv), t = target.apply(this, argv);\n    if (!context) context = buffer = Object(d3_path__WEBPACK_IMPORTED_MODULE_0__[\"path\"])();\n    curve(context, +x.apply(this, (argv[0] = s, argv)), +y.apply(this, argv), +x.apply(this, (argv[0] = t, argv)), +y.apply(this, argv));\n    if (buffer) return context = null, buffer + \"\" || null;\n  }\n\n  link.source = function(_) {\n    return arguments.length ? (source = _, link) : source;\n  };\n\n  link.target = function(_) {\n    return arguments.length ? (target = _, link) : target;\n  };\n\n  link.x = function(_) {\n    return arguments.length ? (x = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(+_), link) : x;\n  };\n\n  link.y = function(_) {\n    return arguments.length ? (y = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(+_), link) : y;\n  };\n\n  link.context = function(_) {\n    return arguments.length ? ((context = _ == null ? null : _), link) : context;\n  };\n\n  return link;\n}\n\nfunction curveHorizontal(context, x0, y0, x1, y1) {\n  context.moveTo(x0, y0);\n  context.bezierCurveTo(x0 = (x0 + x1) / 2, y0, x0, y1, x1, y1);\n}\n\nfunction curveVertical(context, x0, y0, x1, y1) {\n  context.moveTo(x0, y0);\n  context.bezierCurveTo(x0, y0 = (y0 + y1) / 2, x1, y0, x1, y1);\n}\n\nfunction curveRadial(context, x0, y0, x1, y1) {\n  var p0 = Object(_pointRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(x0, y0),\n      p1 = Object(_pointRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(x0, y0 = (y0 + y1) / 2),\n      p2 = Object(_pointRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(x1, y0),\n      p3 = Object(_pointRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(x1, y1);\n  context.moveTo(p0[0], p0[1]);\n  context.bezierCurveTo(p1[0], p1[1], p2[0], p2[1], p3[0], p3[1]);\n}\n\nfunction linkHorizontal() {\n  return link(curveHorizontal);\n}\n\nfunction linkVertical() {\n  return link(curveVertical);\n}\n\nfunction linkRadial() {\n  var l = link(curveRadial);\n  l.angle = l.x, delete l.x;\n  l.radius = l.y, delete l.y;\n  return l;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/link/index.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/math.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/math.js ***!
  \***********************************************************************************/
/*! exports provided: abs, atan2, cos, max, min, sin, sqrt, epsilon, pi, halfPi, tau, acos, asin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"abs\", function() { return abs; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"atan2\", function() { return atan2; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cos\", function() { return cos; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"max\", function() { return max; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"min\", function() { return min; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sin\", function() { return sin; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sqrt\", function() { return sqrt; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"epsilon\", function() { return epsilon; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"pi\", function() { return pi; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"halfPi\", function() { return halfPi; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tau\", function() { return tau; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"acos\", function() { return acos; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"asin\", function() { return asin; });\nvar abs = Math.abs;\nvar atan2 = Math.atan2;\nvar cos = Math.cos;\nvar max = Math.max;\nvar min = Math.min;\nvar sin = Math.sin;\nvar sqrt = Math.sqrt;\n\nvar epsilon = 1e-12;\nvar pi = Math.PI;\nvar halfPi = pi / 2;\nvar tau = 2 * pi;\n\nfunction acos(x) {\n  return x > 1 ? 0 : x < -1 ? pi : Math.acos(x);\n}\n\nfunction asin(x) {\n  return x >= 1 ? halfPi : x <= -1 ? -halfPi : Math.asin(x);\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/math.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/noop.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/noop.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/noop.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/diverging.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/diverging.js ***!
  \***********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series, order) {\n  if (!((n = series.length) > 0)) return;\n  for (var i, j = 0, d, dy, yp, yn, n, m = series[order[0]].length; j < m; ++j) {\n    for (yp = yn = 0, i = 0; i < n; ++i) {\n      if ((dy = (d = series[order[i]][j])[1] - d[0]) > 0) {\n        d[0] = yp, d[1] = yp += dy;\n      } else if (dy < 0) {\n        d[1] = yn, d[0] = yn += dy;\n      } else {\n        d[0] = 0, d[1] = dy;\n      }\n    }\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/diverging.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/expand.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/expand.js ***!
  \********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series, order) {\n  if (!((n = series.length) > 0)) return;\n  for (var i, n, j = 0, m = series[0].length, y; j < m; ++j) {\n    for (y = i = 0; i < n; ++i) y += series[i][j][1] || 0;\n    if (y) for (i = 0; i < n; ++i) series[i][j][1] /= y;\n  }\n  Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series, order);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/expand.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/none.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/none.js ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series, order) {\n  if (!((n = series.length) > 1)) return;\n  for (var i = 1, j, s0, s1 = series[order[0]], n, m = s1.length; i < n; ++i) {\n    s0 = s1, s1 = series[order[i]];\n    for (j = 0; j < m; ++j) {\n      s1[j][1] += s1[j][0] = isNaN(s0[j][1]) ? s0[j][0] : s0[j][1];\n    }\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/none.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/silhouette.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/silhouette.js ***!
  \************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series, order) {\n  if (!((n = series.length) > 0)) return;\n  for (var j = 0, s0 = series[order[0]], n, m = s0.length; j < m; ++j) {\n    for (var i = 0, y = 0; i < n; ++i) y += series[i][j][1] || 0;\n    s0[j][1] += s0[j][0] = -y / 2;\n  }\n  Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series, order);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/silhouette.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/wiggle.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/wiggle.js ***!
  \********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series, order) {\n  if (!((n = series.length) > 0) || !((m = (s0 = series[order[0]]).length) > 0)) return;\n  for (var y = 0, j = 1, s0, m, n; j < m; ++j) {\n    for (var i = 0, s1 = 0, s2 = 0; i < n; ++i) {\n      var si = series[order[i]],\n          sij0 = si[j][1] || 0,\n          sij1 = si[j - 1][1] || 0,\n          s3 = (sij0 - sij1) / 2;\n      for (var k = 0; k < i; ++k) {\n        var sk = series[order[k]],\n            skj0 = sk[j][1] || 0,\n            skj1 = sk[j - 1][1] || 0;\n        s3 += skj0 - skj1;\n      }\n      s1 += sij0, s2 += s3 * sij0;\n    }\n    s0[j - 1][1] += s0[j - 1][0] = y;\n    if (s1) y -= s2 / s1;\n  }\n  s0[j - 1][1] += s0[j - 1][0] = y;\n  Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series, order);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/wiggle.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/appearance.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/appearance.js ***!
  \***********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  var peaks = series.map(peak);\n  return Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series).sort(function(a, b) { return peaks[a] - peaks[b]; });\n});\n\nfunction peak(series) {\n  var i = -1, j = 0, n = series.length, vi, vj = -Infinity;\n  while (++i < n) if ((vi = +series[i][1]) > vj) vj = vi, j = i;\n  return j;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/appearance.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/ascending.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/ascending.js ***!
  \**********************************************************************************************/
/*! exports provided: default, sum */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sum\", function() { return sum; });\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  var sums = series.map(sum);\n  return Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series).sort(function(a, b) { return sums[a] - sums[b]; });\n});\n\nfunction sum(series) {\n  var s = 0, i = -1, n = series.length, v;\n  while (++i < n) if (v = +series[i][1]) s += v;\n  return s;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/ascending.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/descending.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/descending.js ***!
  \***********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ascending_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/ascending.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  return Object(_ascending_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series).reverse();\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/descending.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/insideOut.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/insideOut.js ***!
  \**********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _appearance_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./appearance.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/appearance.js\");\n/* harmony import */ var _ascending_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ascending.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/ascending.js\");\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  var n = series.length,\n      i,\n      j,\n      sums = series.map(_ascending_js__WEBPACK_IMPORTED_MODULE_1__[\"sum\"]),\n      order = Object(_appearance_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series),\n      top = 0,\n      bottom = 0,\n      tops = [],\n      bottoms = [];\n\n  for (i = 0; i < n; ++i) {\n    j = order[i];\n    if (top < bottom) {\n      top += sums[j];\n      tops.push(j);\n    } else {\n      bottom += sums[j];\n      bottoms.push(j);\n    }\n  }\n\n  return bottoms.reverse().concat(tops);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/insideOut.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/none.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/none.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  var n = series.length, o = new Array(n);\n  while (--n >= 0) o[n] = n;\n  return o;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/none.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/reverse.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/reverse.js ***!
  \********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  return Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series).reverse();\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/reverse.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pie.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pie.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _descending_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./descending.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/descending.js\");\n/* harmony import */ var _identity_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./identity.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/identity.js\");\n/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./math.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/math.js\");\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var value = _identity_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n      sortValues = _descending_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n      sort = null,\n      startAngle = Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(0),\n      endAngle = Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(_math_js__WEBPACK_IMPORTED_MODULE_3__[\"tau\"]),\n      padAngle = Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(0);\n\n  function pie(data) {\n    var i,\n        n = data.length,\n        j,\n        k,\n        sum = 0,\n        index = new Array(n),\n        arcs = new Array(n),\n        a0 = +startAngle.apply(this, arguments),\n        da = Math.min(_math_js__WEBPACK_IMPORTED_MODULE_3__[\"tau\"], Math.max(-_math_js__WEBPACK_IMPORTED_MODULE_3__[\"tau\"], endAngle.apply(this, arguments) - a0)),\n        a1,\n        p = Math.min(Math.abs(da) / n, padAngle.apply(this, arguments)),\n        pa = p * (da < 0 ? -1 : 1),\n        v;\n\n    for (i = 0; i < n; ++i) {\n      if ((v = arcs[index[i] = i] = +value(data[i], i, data)) > 0) {\n        sum += v;\n      }\n    }\n\n    // Optionally sort the arcs by previously-computed values or by data.\n    if (sortValues != null) index.sort(function(i, j) { return sortValues(arcs[i], arcs[j]); });\n    else if (sort != null) index.sort(function(i, j) { return sort(data[i], data[j]); });\n\n    // Compute the arcs! They are stored in the original data's order.\n    for (i = 0, k = sum ? (da - n * pa) / sum : 0; i < n; ++i, a0 = a1) {\n      j = index[i], v = arcs[j], a1 = a0 + (v > 0 ? v * k : 0) + pa, arcs[j] = {\n        data: data[j],\n        index: i,\n        value: v,\n        startAngle: a0,\n        endAngle: a1,\n        padAngle: p\n      };\n    }\n\n    return arcs;\n  }\n\n  pie.value = function(_) {\n    return arguments.length ? (value = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(+_), pie) : value;\n  };\n\n  pie.sortValues = function(_) {\n    return arguments.length ? (sortValues = _, sort = null, pie) : sortValues;\n  };\n\n  pie.sort = function(_) {\n    return arguments.length ? (sort = _, sortValues = null, pie) : sort;\n  };\n\n  pie.startAngle = function(_) {\n    return arguments.length ? (startAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(+_), pie) : startAngle;\n  };\n\n  pie.endAngle = function(_) {\n    return arguments.length ? (endAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(+_), pie) : endAngle;\n  };\n\n  pie.padAngle = function(_) {\n    return arguments.length ? (padAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(+_), pie) : padAngle;\n  };\n\n  return pie;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pie.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/point.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/point.js ***!
  \************************************************************************************/
/*! exports provided: x, y */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"x\", function() { return x; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"y\", function() { return y; });\nfunction x(p) {\n  return p[0];\n}\n\nfunction y(p) {\n  return p[1];\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/point.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pointRadial.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pointRadial.js ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x, y) {\n  return [(y = +y) * Math.cos(x -= Math.PI / 2), y * Math.sin(x)];\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pointRadial.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/stack.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/stack.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _array_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./array.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/array.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _offset_none_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./offset/none.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/none.js\");\n/* harmony import */ var _order_none_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./order/none.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/none.js\");\n\n\n\n\n\nfunction stackValue(d, key) {\n  return d[key];\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var keys = Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])([]),\n      order = _order_none_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n      offset = _offset_none_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n      value = stackValue;\n\n  function stack(data) {\n    var kz = keys.apply(this, arguments),\n        i,\n        m = data.length,\n        n = kz.length,\n        sz = new Array(n),\n        oz;\n\n    for (i = 0; i < n; ++i) {\n      for (var ki = kz[i], si = sz[i] = new Array(m), j = 0, sij; j < m; ++j) {\n        si[j] = sij = [0, +value(data[j], ki, j, data)];\n        sij.data = data[j];\n      }\n      si.key = ki;\n    }\n\n    for (i = 0, oz = order(sz); i < n; ++i) {\n      sz[oz[i]].index = i;\n    }\n\n    offset(sz, oz);\n    return sz;\n  }\n\n  stack.keys = function(_) {\n    return arguments.length ? (keys = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(_array_js__WEBPACK_IMPORTED_MODULE_0__[\"slice\"].call(_)), stack) : keys;\n  };\n\n  stack.value = function(_) {\n    return arguments.length ? (value = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), stack) : value;\n  };\n\n  stack.order = function(_) {\n    return arguments.length ? (order = _ == null ? _order_none_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"] : typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(_array_js__WEBPACK_IMPORTED_MODULE_0__[\"slice\"].call(_)), stack) : order;\n  };\n\n  stack.offset = function(_) {\n    return arguments.length ? (offset = _ == null ? _offset_none_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"] : _, stack) : offset;\n  };\n\n  return stack;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/stack.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol.js ***!
  \*************************************************************************************/
/*! exports provided: symbols, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"symbols\", function() { return symbols; });\n/* harmony import */ var d3_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-path */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/index.js\");\n/* harmony import */ var _symbol_circle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./symbol/circle.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/circle.js\");\n/* harmony import */ var _symbol_cross_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./symbol/cross.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/cross.js\");\n/* harmony import */ var _symbol_diamond_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./symbol/diamond.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/diamond.js\");\n/* harmony import */ var _symbol_star_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./symbol/star.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/star.js\");\n/* harmony import */ var _symbol_square_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./symbol/square.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/square.js\");\n/* harmony import */ var _symbol_triangle_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./symbol/triangle.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/triangle.js\");\n/* harmony import */ var _symbol_wye_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./symbol/wye.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/wye.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js\");\n\n\n\n\n\n\n\n\n\n\nvar symbols = [\n  _symbol_circle_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  _symbol_cross_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n  _symbol_diamond_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n  _symbol_square_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"],\n  _symbol_star_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"],\n  _symbol_triangle_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"],\n  _symbol_wye_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"]\n];\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var type = Object(_constant_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(_symbol_circle_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]),\n      size = Object(_constant_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(64),\n      context = null;\n\n  function symbol() {\n    var buffer;\n    if (!context) context = buffer = Object(d3_path__WEBPACK_IMPORTED_MODULE_0__[\"path\"])();\n    type.apply(this, arguments).draw(context, +size.apply(this, arguments));\n    if (buffer) return context = null, buffer + \"\" || null;\n  }\n\n  symbol.type = function(_) {\n    return arguments.length ? (type = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(_), symbol) : type;\n  };\n\n  symbol.size = function(_) {\n    return arguments.length ? (size = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(+_), symbol) : size;\n  };\n\n  symbol.context = function(_) {\n    return arguments.length ? (context = _ == null ? null : _, symbol) : context;\n  };\n\n  return symbol;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/circle.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/circle.js ***!
  \********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../math.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/math.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var r = Math.sqrt(size / _math_js__WEBPACK_IMPORTED_MODULE_0__[\"pi\"]);\n    context.moveTo(r, 0);\n    context.arc(0, 0, r, 0, _math_js__WEBPACK_IMPORTED_MODULE_0__[\"tau\"]);\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/circle.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/cross.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/cross.js ***!
  \*******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var r = Math.sqrt(size / 5) / 2;\n    context.moveTo(-3 * r, -r);\n    context.lineTo(-r, -r);\n    context.lineTo(-r, -3 * r);\n    context.lineTo(r, -3 * r);\n    context.lineTo(r, -r);\n    context.lineTo(3 * r, -r);\n    context.lineTo(3 * r, r);\n    context.lineTo(r, r);\n    context.lineTo(r, 3 * r);\n    context.lineTo(-r, 3 * r);\n    context.lineTo(-r, r);\n    context.lineTo(-3 * r, r);\n    context.closePath();\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/cross.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/diamond.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/diamond.js ***!
  \*********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar tan30 = Math.sqrt(1 / 3),\n    tan30_2 = tan30 * 2;\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var y = Math.sqrt(size / tan30_2),\n        x = y * tan30;\n    context.moveTo(0, -y);\n    context.lineTo(x, 0);\n    context.lineTo(0, y);\n    context.lineTo(-x, 0);\n    context.closePath();\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/diamond.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/square.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/square.js ***!
  \********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var w = Math.sqrt(size),\n        x = -w / 2;\n    context.rect(x, x, w, w);\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/square.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/star.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/star.js ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../math.js */ \"./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/math.js\");\n\n\nvar ka = 0.89081309152928522810,\n    kr = Math.sin(_math_js__WEBPACK_IMPORTED_MODULE_0__[\"pi\"] / 10) / Math.sin(7 * _math_js__WEBPACK_IMPORTED_MODULE_0__[\"pi\"] / 10),\n    kx = Math.sin(_math_js__WEBPACK_IMPORTED_MODULE_0__[\"tau\"] / 10) * kr,\n    ky = -Math.cos(_math_js__WEBPACK_IMPORTED_MODULE_0__[\"tau\"] / 10) * kr;\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var r = Math.sqrt(size * ka),\n        x = kx * r,\n        y = ky * r;\n    context.moveTo(0, -r);\n    context.lineTo(x, y);\n    for (var i = 1; i < 5; ++i) {\n      var a = _math_js__WEBPACK_IMPORTED_MODULE_0__[\"tau\"] * i / 5,\n          c = Math.cos(a),\n          s = Math.sin(a);\n      context.lineTo(s * r, -c * r);\n      context.lineTo(c * x - s * y, s * x + c * y);\n    }\n    context.closePath();\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/star.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/triangle.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/triangle.js ***!
  \**********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar sqrt3 = Math.sqrt(3);\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var y = -Math.sqrt(size / (sqrt3 * 3));\n    context.moveTo(0, y * 2);\n    context.lineTo(-sqrt3 * y, -y);\n    context.lineTo(sqrt3 * y, -y);\n    context.closePath();\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/triangle.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/wye.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/wye.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar c = -0.5,\n    s = Math.sqrt(3) / 2,\n    k = 1 / Math.sqrt(12),\n    a = (k / 2 + 1) * 3;\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var r = Math.sqrt(size / a),\n        x0 = r / 2,\n        y0 = r * k,\n        x1 = x0,\n        y1 = r * k + r,\n        x2 = -x1,\n        y2 = y1;\n    context.moveTo(x0, y0);\n    context.lineTo(x1, y1);\n    context.lineTo(x2, y2);\n    context.lineTo(c * x0 - s * y0, s * x0 + c * y0);\n    context.lineTo(c * x1 - s * y1, s * x1 + c * y1);\n    context.lineTo(c * x2 - s * y2, s * x2 + c * y2);\n    context.lineTo(c * x0 + s * y0, c * y0 - s * x0);\n    context.lineTo(c * x1 + s * y1, c * y1 - s * x1);\n    context.lineTo(c * x2 + s * y2, c * y2 - s * x2);\n    context.closePath();\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/wye.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/index.js":
/*!*************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/index.js ***!
  \*************************************************/
/*! exports provided: sankey, sankeyCenter, sankeyLeft, sankeyRight, sankeyJustify, sankeyLinkHorizontal */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _src_sankey__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./src/sankey */ \"./node_modules/@plotly/d3-sankey/src/sankey.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"sankey\", function() { return _src_sankey__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n/* harmony import */ var _src_align__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./src/align */ \"./node_modules/@plotly/d3-sankey/src/align.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"sankeyCenter\", function() { return _src_align__WEBPACK_IMPORTED_MODULE_1__[\"center\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"sankeyLeft\", function() { return _src_align__WEBPACK_IMPORTED_MODULE_1__[\"left\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"sankeyRight\", function() { return _src_align__WEBPACK_IMPORTED_MODULE_1__[\"right\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"sankeyJustify\", function() { return _src_align__WEBPACK_IMPORTED_MODULE_1__[\"justify\"]; });\n\n/* harmony import */ var _src_sankeyLinkHorizontal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./src/sankeyLinkHorizontal */ \"./node_modules/@plotly/d3-sankey/src/sankeyLinkHorizontal.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"sankeyLinkHorizontal\", function() { return _src_sankeyLinkHorizontal__WEBPACK_IMPORTED_MODULE_2__[\"default\"]; });\n\n\n\n\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/index.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/array.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/array.js ***!
  \***************************************************************************/
/*! exports provided: slice, map */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"slice\", function() { return slice; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"map\", function() { return map; });\nvar array = Array.prototype;\n\nvar slice = array.slice;\nvar map = array.map;\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/array.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ascending.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ascending.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ascending.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisect.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisect.js ***!
  \****************************************************************************/
/*! exports provided: bisectRight, bisectLeft, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"bisectRight\", function() { return bisectRight; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"bisectLeft\", function() { return bisectLeft; });\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ascending.js\");\n/* harmony import */ var _bisector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bisector */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisector.js\");\n\n\n\nvar ascendingBisect = Object(_bisector__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(_ascending__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\nvar bisectRight = ascendingBisect.right;\nvar bisectLeft = ascendingBisect.left;\n/* harmony default export */ __webpack_exports__[\"default\"] = (bisectRight);\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisect.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisector.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisector.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ascending.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(compare) {\n  if (compare.length === 1) compare = ascendingComparator(compare);\n  return {\n    left: function(a, x, lo, hi) {\n      if (lo == null) lo = 0;\n      if (hi == null) hi = a.length;\n      while (lo < hi) {\n        var mid = lo + hi >>> 1;\n        if (compare(a[mid], x) < 0) lo = mid + 1;\n        else hi = mid;\n      }\n      return lo;\n    },\n    right: function(a, x, lo, hi) {\n      if (lo == null) lo = 0;\n      if (hi == null) hi = a.length;\n      while (lo < hi) {\n        var mid = lo + hi >>> 1;\n        if (compare(a[mid], x) > 0) hi = mid;\n        else lo = mid + 1;\n      }\n      return lo;\n    }\n  };\n});\n\nfunction ascendingComparator(f) {\n  return function(d, x) {\n    return Object(_ascending__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(f(d), x);\n  };\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisector.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/constant.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/constant.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x) {\n  return function() {\n    return x;\n  };\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/constant.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/cross.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/cross.js ***!
  \***************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _pairs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pairs */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/pairs.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values0, values1, reduce) {\n  var n0 = values0.length,\n      n1 = values1.length,\n      values = new Array(n0 * n1),\n      i0,\n      i1,\n      i,\n      value0;\n\n  if (reduce == null) reduce = _pairs__WEBPACK_IMPORTED_MODULE_0__[\"pair\"];\n\n  for (i0 = i = 0; i0 < n0; ++i0) {\n    for (value0 = values0[i0], i1 = 0; i1 < n1; ++i1, ++i) {\n      values[i] = reduce(value0, values1[i1]);\n    }\n  }\n\n  return values;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/cross.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/descending.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/descending.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/descending.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/deviation.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/deviation.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _variance__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./variance */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/variance.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(array, f) {\n  var v = Object(_variance__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(array, f);\n  return v ? Math.sqrt(v) : v;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/deviation.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/extent.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/extent.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      i = -1,\n      value,\n      min,\n      max;\n\n  if (valueof == null) {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = values[i]) != null && value >= value) {\n        min = max = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = values[i]) != null) {\n            if (min > value) min = value;\n            if (max < value) max = value;\n          }\n        }\n      }\n    }\n  }\n\n  else {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = valueof(values[i], i, values)) != null && value >= value) {\n        min = max = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = valueof(values[i], i, values)) != null) {\n            if (min > value) min = value;\n            if (max < value) max = value;\n          }\n        }\n      }\n    }\n  }\n\n  return [min, max];\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/extent.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/histogram.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/histogram.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./array */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/array.js\");\n/* harmony import */ var _bisect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bisect */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisect.js\");\n/* harmony import */ var _constant__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constant */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/constant.js\");\n/* harmony import */ var _extent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./extent */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/extent.js\");\n/* harmony import */ var _identity__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./identity */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/identity.js\");\n/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./range */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/range.js\");\n/* harmony import */ var _ticks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ticks */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ticks.js\");\n/* harmony import */ var _threshold_sturges__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./threshold/sturges */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/sturges.js\");\n\n\n\n\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var value = _identity__WEBPACK_IMPORTED_MODULE_4__[\"default\"],\n      domain = _extent__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n      threshold = _threshold_sturges__WEBPACK_IMPORTED_MODULE_7__[\"default\"];\n\n  function histogram(data) {\n    var i,\n        n = data.length,\n        x,\n        values = new Array(n);\n\n    for (i = 0; i < n; ++i) {\n      values[i] = value(data[i], i, data);\n    }\n\n    var xz = domain(values),\n        x0 = xz[0],\n        x1 = xz[1],\n        tz = threshold(values, x0, x1);\n\n    // Convert number of thresholds into uniform thresholds.\n    if (!Array.isArray(tz)) {\n      tz = Object(_ticks__WEBPACK_IMPORTED_MODULE_6__[\"tickStep\"])(x0, x1, tz);\n      tz = Object(_range__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(Math.ceil(x0 / tz) * tz, x1, tz); // exclusive\n    }\n\n    // Remove any thresholds outside the domain.\n    var m = tz.length;\n    while (tz[0] <= x0) tz.shift(), --m;\n    while (tz[m - 1] > x1) tz.pop(), --m;\n\n    var bins = new Array(m + 1),\n        bin;\n\n    // Initialize bins.\n    for (i = 0; i <= m; ++i) {\n      bin = bins[i] = [];\n      bin.x0 = i > 0 ? tz[i - 1] : x0;\n      bin.x1 = i < m ? tz[i] : x1;\n    }\n\n    // Assign data to bins by value, ignoring any outside the domain.\n    for (i = 0; i < n; ++i) {\n      x = values[i];\n      if (x0 <= x && x <= x1) {\n        bins[Object(_bisect__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(tz, x, 0, m)].push(data[i]);\n      }\n    }\n\n    return bins;\n  }\n\n  histogram.value = function(_) {\n    return arguments.length ? (value = typeof _ === \"function\" ? _ : Object(_constant__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(_), histogram) : value;\n  };\n\n  histogram.domain = function(_) {\n    return arguments.length ? (domain = typeof _ === \"function\" ? _ : Object(_constant__WEBPACK_IMPORTED_MODULE_2__[\"default\"])([_[0], _[1]]), histogram) : domain;\n  };\n\n  histogram.thresholds = function(_) {\n    return arguments.length ? (threshold = typeof _ === \"function\" ? _ : Array.isArray(_) ? Object(_constant__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(_array__WEBPACK_IMPORTED_MODULE_0__[\"slice\"].call(_)) : Object(_constant__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(_), histogram) : threshold;\n  };\n\n  return histogram;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/histogram.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/identity.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/identity.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x) {\n  return x;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/identity.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/index.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/index.js ***!
  \***************************************************************************/
/*! exports provided: bisect, bisectRight, bisectLeft, ascending, bisector, cross, descending, deviation, extent, histogram, thresholdFreedmanDiaconis, thresholdScott, thresholdSturges, max, mean, median, merge, min, pairs, permute, quantile, range, scan, shuffle, sum, ticks, tickIncrement, tickStep, transpose, variance, zip */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _bisect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bisect */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisect.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"bisect\", function() { return _bisect__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"bisectRight\", function() { return _bisect__WEBPACK_IMPORTED_MODULE_0__[\"bisectRight\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"bisectLeft\", function() { return _bisect__WEBPACK_IMPORTED_MODULE_0__[\"bisectLeft\"]; });\n\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ascending */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ascending.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"ascending\", function() { return _ascending__WEBPACK_IMPORTED_MODULE_1__[\"default\"]; });\n\n/* harmony import */ var _bisector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./bisector */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisector.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"bisector\", function() { return _bisector__WEBPACK_IMPORTED_MODULE_2__[\"default\"]; });\n\n/* harmony import */ var _cross__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./cross */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/cross.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"cross\", function() { return _cross__WEBPACK_IMPORTED_MODULE_3__[\"default\"]; });\n\n/* harmony import */ var _descending__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./descending */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/descending.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"descending\", function() { return _descending__WEBPACK_IMPORTED_MODULE_4__[\"default\"]; });\n\n/* harmony import */ var _deviation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./deviation */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/deviation.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"deviation\", function() { return _deviation__WEBPACK_IMPORTED_MODULE_5__[\"default\"]; });\n\n/* harmony import */ var _extent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./extent */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/extent.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"extent\", function() { return _extent__WEBPACK_IMPORTED_MODULE_6__[\"default\"]; });\n\n/* harmony import */ var _histogram__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./histogram */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/histogram.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"histogram\", function() { return _histogram__WEBPACK_IMPORTED_MODULE_7__[\"default\"]; });\n\n/* harmony import */ var _threshold_freedmanDiaconis__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./threshold/freedmanDiaconis */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/freedmanDiaconis.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"thresholdFreedmanDiaconis\", function() { return _threshold_freedmanDiaconis__WEBPACK_IMPORTED_MODULE_8__[\"default\"]; });\n\n/* harmony import */ var _threshold_scott__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./threshold/scott */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/scott.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"thresholdScott\", function() { return _threshold_scott__WEBPACK_IMPORTED_MODULE_9__[\"default\"]; });\n\n/* harmony import */ var _threshold_sturges__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./threshold/sturges */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/sturges.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"thresholdSturges\", function() { return _threshold_sturges__WEBPACK_IMPORTED_MODULE_10__[\"default\"]; });\n\n/* harmony import */ var _max__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./max */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/max.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"max\", function() { return _max__WEBPACK_IMPORTED_MODULE_11__[\"default\"]; });\n\n/* harmony import */ var _mean__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./mean */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/mean.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"mean\", function() { return _mean__WEBPACK_IMPORTED_MODULE_12__[\"default\"]; });\n\n/* harmony import */ var _median__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./median */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/median.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"median\", function() { return _median__WEBPACK_IMPORTED_MODULE_13__[\"default\"]; });\n\n/* harmony import */ var _merge__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./merge */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/merge.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"merge\", function() { return _merge__WEBPACK_IMPORTED_MODULE_14__[\"default\"]; });\n\n/* harmony import */ var _min__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./min */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/min.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"min\", function() { return _min__WEBPACK_IMPORTED_MODULE_15__[\"default\"]; });\n\n/* harmony import */ var _pairs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./pairs */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/pairs.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"pairs\", function() { return _pairs__WEBPACK_IMPORTED_MODULE_16__[\"default\"]; });\n\n/* harmony import */ var _permute__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./permute */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/permute.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"permute\", function() { return _permute__WEBPACK_IMPORTED_MODULE_17__[\"default\"]; });\n\n/* harmony import */ var _quantile__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./quantile */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/quantile.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"quantile\", function() { return _quantile__WEBPACK_IMPORTED_MODULE_18__[\"default\"]; });\n\n/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./range */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/range.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"range\", function() { return _range__WEBPACK_IMPORTED_MODULE_19__[\"default\"]; });\n\n/* harmony import */ var _scan__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./scan */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/scan.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"scan\", function() { return _scan__WEBPACK_IMPORTED_MODULE_20__[\"default\"]; });\n\n/* harmony import */ var _shuffle__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./shuffle */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/shuffle.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"shuffle\", function() { return _shuffle__WEBPACK_IMPORTED_MODULE_21__[\"default\"]; });\n\n/* harmony import */ var _sum__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./sum */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/sum.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"sum\", function() { return _sum__WEBPACK_IMPORTED_MODULE_22__[\"default\"]; });\n\n/* harmony import */ var _ticks__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./ticks */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ticks.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"ticks\", function() { return _ticks__WEBPACK_IMPORTED_MODULE_23__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"tickIncrement\", function() { return _ticks__WEBPACK_IMPORTED_MODULE_23__[\"tickIncrement\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"tickStep\", function() { return _ticks__WEBPACK_IMPORTED_MODULE_23__[\"tickStep\"]; });\n\n/* harmony import */ var _transpose__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./transpose */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/transpose.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"transpose\", function() { return _transpose__WEBPACK_IMPORTED_MODULE_24__[\"default\"]; });\n\n/* harmony import */ var _variance__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./variance */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/variance.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"variance\", function() { return _variance__WEBPACK_IMPORTED_MODULE_25__[\"default\"]; });\n\n/* harmony import */ var _zip__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./zip */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/zip.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"zip\", function() { return _zip__WEBPACK_IMPORTED_MODULE_26__[\"default\"]; });\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/index.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/max.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/max.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      i = -1,\n      value,\n      max;\n\n  if (valueof == null) {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = values[i]) != null && value >= value) {\n        max = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = values[i]) != null && value > max) {\n            max = value;\n          }\n        }\n      }\n    }\n  }\n\n  else {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = valueof(values[i], i, values)) != null && value >= value) {\n        max = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = valueof(values[i], i, values)) != null && value > max) {\n            max = value;\n          }\n        }\n      }\n    }\n  }\n\n  return max;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/max.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/mean.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/mean.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./number */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/number.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      m = n,\n      i = -1,\n      value,\n      sum = 0;\n\n  if (valueof == null) {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(values[i]))) sum += value;\n      else --m;\n    }\n  }\n\n  else {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(valueof(values[i], i, values)))) sum += value;\n      else --m;\n    }\n  }\n\n  if (m) return sum / m;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/mean.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/median.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/median.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ascending.js\");\n/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./number */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/number.js\");\n/* harmony import */ var _quantile__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./quantile */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/quantile.js\");\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      i = -1,\n      value,\n      numbers = [];\n\n  if (valueof == null) {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(values[i]))) {\n        numbers.push(value);\n      }\n    }\n  }\n\n  else {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(valueof(values[i], i, values)))) {\n        numbers.push(value);\n      }\n    }\n  }\n\n  return Object(_quantile__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(numbers.sort(_ascending__WEBPACK_IMPORTED_MODULE_0__[\"default\"]), 0.5);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/median.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/merge.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/merge.js ***!
  \***************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(arrays) {\n  var n = arrays.length,\n      m,\n      i = -1,\n      j = 0,\n      merged,\n      array;\n\n  while (++i < n) j += arrays[i].length;\n  merged = new Array(j);\n\n  while (--n >= 0) {\n    array = arrays[n];\n    m = array.length;\n    while (--m >= 0) {\n      merged[--j] = array[m];\n    }\n  }\n\n  return merged;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/merge.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/min.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/min.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      i = -1,\n      value,\n      min;\n\n  if (valueof == null) {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = values[i]) != null && value >= value) {\n        min = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = values[i]) != null && min > value) {\n            min = value;\n          }\n        }\n      }\n    }\n  }\n\n  else {\n    while (++i < n) { // Find the first comparable value.\n      if ((value = valueof(values[i], i, values)) != null && value >= value) {\n        min = value;\n        while (++i < n) { // Compare the remaining values.\n          if ((value = valueof(values[i], i, values)) != null && min > value) {\n            min = value;\n          }\n        }\n      }\n    }\n  }\n\n  return min;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/min.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/number.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/number.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x) {\n  return x === null ? NaN : +x;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/number.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/pairs.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/pairs.js ***!
  \***************************************************************************/
/*! exports provided: default, pair */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"pair\", function() { return pair; });\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(array, f) {\n  if (f == null) f = pair;\n  var i = 0, n = array.length - 1, p = array[0], pairs = new Array(n < 0 ? 0 : n);\n  while (i < n) pairs[i] = f(p, p = array[++i]);\n  return pairs;\n});\n\nfunction pair(a, b) {\n  return [a, b];\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/pairs.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/permute.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/permute.js ***!
  \*****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(array, indexes) {\n  var i = indexes.length, permutes = new Array(i);\n  while (i--) permutes[i] = array[indexes[i]];\n  return permutes;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/permute.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/quantile.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/quantile.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./number */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/number.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, p, valueof) {\n  if (valueof == null) valueof = _number__WEBPACK_IMPORTED_MODULE_0__[\"default\"];\n  if (!(n = values.length)) return;\n  if ((p = +p) <= 0 || n < 2) return +valueof(values[0], 0, values);\n  if (p >= 1) return +valueof(values[n - 1], n - 1, values);\n  var n,\n      i = (n - 1) * p,\n      i0 = Math.floor(i),\n      value0 = +valueof(values[i0], i0, values),\n      value1 = +valueof(values[i0 + 1], i0 + 1, values);\n  return value0 + (value1 - value0) * (i - i0);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/quantile.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/range.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/range.js ***!
  \***************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(start, stop, step) {\n  start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;\n\n  var i = -1,\n      n = Math.max(0, Math.ceil((stop - start) / step)) | 0,\n      range = new Array(n);\n\n  while (++i < n) {\n    range[i] = start + i * step;\n  }\n\n  return range;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/range.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/scan.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/scan.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ascending.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, compare) {\n  if (!(n = values.length)) return;\n  var n,\n      i = 0,\n      j = 0,\n      xi,\n      xj = values[j];\n\n  if (compare == null) compare = _ascending__WEBPACK_IMPORTED_MODULE_0__[\"default\"];\n\n  while (++i < n) {\n    if (compare(xi = values[i], xj) < 0 || compare(xj, xj) !== 0) {\n      xj = xi, j = i;\n    }\n  }\n\n  if (compare(xj, xj) === 0) return j;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/scan.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/shuffle.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/shuffle.js ***!
  \*****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(array, i0, i1) {\n  var m = (i1 == null ? array.length : i1) - (i0 = i0 == null ? 0 : +i0),\n      t,\n      i;\n\n  while (m) {\n    i = Math.random() * m-- | 0;\n    t = array[m + i0];\n    array[m + i0] = array[i + i0];\n    array[i + i0] = t;\n  }\n\n  return array;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/shuffle.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/sum.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/sum.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      i = -1,\n      value,\n      sum = 0;\n\n  if (valueof == null) {\n    while (++i < n) {\n      if (value = +values[i]) sum += value; // Note: zero and null are equivalent.\n    }\n  }\n\n  else {\n    while (++i < n) {\n      if (value = +valueof(values[i], i, values)) sum += value;\n    }\n  }\n\n  return sum;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/sum.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/freedmanDiaconis.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/freedmanDiaconis.js ***!
  \************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../array */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/array.js\");\n/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ascending */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ascending.js\");\n/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../number */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/number.js\");\n/* harmony import */ var _quantile__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../quantile */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/quantile.js\");\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, min, max) {\n  values = _array__WEBPACK_IMPORTED_MODULE_0__[\"map\"].call(values, _number__WEBPACK_IMPORTED_MODULE_2__[\"default\"]).sort(_ascending__WEBPACK_IMPORTED_MODULE_1__[\"default\"]);\n  return Math.ceil((max - min) / (2 * (Object(_quantile__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(values, 0.75) - Object(_quantile__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(values, 0.25)) * Math.pow(values.length, -1 / 3)));\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/freedmanDiaconis.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/scott.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/scott.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _deviation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../deviation */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/deviation.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, min, max) {\n  return Math.ceil((max - min) / (3.5 * Object(_deviation__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(values) * Math.pow(values.length, -1 / 3)));\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/scott.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/sturges.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/sturges.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values) {\n  return Math.ceil(Math.log(values.length) / Math.LN2) + 1;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/sturges.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ticks.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ticks.js ***!
  \***************************************************************************/
/*! exports provided: default, tickIncrement, tickStep */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tickIncrement\", function() { return tickIncrement; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tickStep\", function() { return tickStep; });\nvar e10 = Math.sqrt(50),\n    e5 = Math.sqrt(10),\n    e2 = Math.sqrt(2);\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(start, stop, count) {\n  var reverse,\n      i = -1,\n      n,\n      ticks,\n      step;\n\n  stop = +stop, start = +start, count = +count;\n  if (start === stop && count > 0) return [start];\n  if (reverse = stop < start) n = start, start = stop, stop = n;\n  if ((step = tickIncrement(start, stop, count)) === 0 || !isFinite(step)) return [];\n\n  if (step > 0) {\n    start = Math.ceil(start / step);\n    stop = Math.floor(stop / step);\n    ticks = new Array(n = Math.ceil(stop - start + 1));\n    while (++i < n) ticks[i] = (start + i) * step;\n  } else {\n    start = Math.floor(start * step);\n    stop = Math.ceil(stop * step);\n    ticks = new Array(n = Math.ceil(start - stop + 1));\n    while (++i < n) ticks[i] = (start - i) / step;\n  }\n\n  if (reverse) ticks.reverse();\n\n  return ticks;\n});\n\nfunction tickIncrement(start, stop, count) {\n  var step = (stop - start) / Math.max(0, count),\n      power = Math.floor(Math.log(step) / Math.LN10),\n      error = step / Math.pow(10, power);\n  return power >= 0\n      ? (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1) * Math.pow(10, power)\n      : -Math.pow(10, -power) / (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1);\n}\n\nfunction tickStep(start, stop, count) {\n  var step0 = Math.abs(stop - start) / Math.max(0, count),\n      step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),\n      error = step0 / step1;\n  if (error >= e10) step1 *= 10;\n  else if (error >= e5) step1 *= 5;\n  else if (error >= e2) step1 *= 2;\n  return stop < start ? -step1 : step1;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ticks.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/transpose.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/transpose.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _min__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./min */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/min.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(matrix) {\n  if (!(n = matrix.length)) return [];\n  for (var i = -1, m = Object(_min__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(matrix, length), transpose = new Array(m); ++i < m;) {\n    for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n;) {\n      row[j] = matrix[j][i];\n    }\n  }\n  return transpose;\n});\n\nfunction length(d) {\n  return d.length;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/transpose.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/variance.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/variance.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _number__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./number */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/number.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(values, valueof) {\n  var n = values.length,\n      m = 0,\n      i = -1,\n      mean = 0,\n      value,\n      delta,\n      sum = 0;\n\n  if (valueof == null) {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(values[i]))) {\n        delta = value - mean;\n        mean += delta / ++m;\n        sum += delta * (value - mean);\n      }\n    }\n  }\n\n  else {\n    while (++i < n) {\n      if (!isNaN(value = Object(_number__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(valueof(values[i], i, values)))) {\n        delta = value - mean;\n        mean += delta / ++m;\n        sum += delta * (value - mean);\n      }\n    }\n  }\n\n  if (m > 1) return sum / (m - 1);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/variance.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/zip.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/zip.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _transpose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./transpose */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/transpose.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  return Object(_transpose__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(arguments);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/zip.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/index.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/index.js ***!
  \**************************************************************************/
/*! exports provided: path */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./path.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/path.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"path\", function() { return _path_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/index.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/path.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/path.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar pi = Math.PI,\n    tau = 2 * pi,\n    epsilon = 1e-6,\n    tauEpsilon = tau - epsilon;\n\nfunction Path() {\n  this._x0 = this._y0 = // start of current subpath\n  this._x1 = this._y1 = null; // end of current subpath\n  this._ = \"\";\n}\n\nfunction path() {\n  return new Path;\n}\n\nPath.prototype = path.prototype = {\n  constructor: Path,\n  moveTo: function(x, y) {\n    this._ += \"M\" + (this._x0 = this._x1 = +x) + \",\" + (this._y0 = this._y1 = +y);\n  },\n  closePath: function() {\n    if (this._x1 !== null) {\n      this._x1 = this._x0, this._y1 = this._y0;\n      this._ += \"Z\";\n    }\n  },\n  lineTo: function(x, y) {\n    this._ += \"L\" + (this._x1 = +x) + \",\" + (this._y1 = +y);\n  },\n  quadraticCurveTo: function(x1, y1, x, y) {\n    this._ += \"Q\" + (+x1) + \",\" + (+y1) + \",\" + (this._x1 = +x) + \",\" + (this._y1 = +y);\n  },\n  bezierCurveTo: function(x1, y1, x2, y2, x, y) {\n    this._ += \"C\" + (+x1) + \",\" + (+y1) + \",\" + (+x2) + \",\" + (+y2) + \",\" + (this._x1 = +x) + \",\" + (this._y1 = +y);\n  },\n  arcTo: function(x1, y1, x2, y2, r) {\n    x1 = +x1, y1 = +y1, x2 = +x2, y2 = +y2, r = +r;\n    var x0 = this._x1,\n        y0 = this._y1,\n        x21 = x2 - x1,\n        y21 = y2 - y1,\n        x01 = x0 - x1,\n        y01 = y0 - y1,\n        l01_2 = x01 * x01 + y01 * y01;\n\n    // Is the radius negative? Error.\n    if (r < 0) throw new Error(\"negative radius: \" + r);\n\n    // Is this path empty? Move to (x1,y1).\n    if (this._x1 === null) {\n      this._ += \"M\" + (this._x1 = x1) + \",\" + (this._y1 = y1);\n    }\n\n    // Or, is (x1,y1) coincident with (x0,y0)? Do nothing.\n    else if (!(l01_2 > epsilon));\n\n    // Or, are (x0,y0), (x1,y1) and (x2,y2) collinear?\n    // Equivalently, is (x1,y1) coincident with (x2,y2)?\n    // Or, is the radius zero? Line to (x1,y1).\n    else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon) || !r) {\n      this._ += \"L\" + (this._x1 = x1) + \",\" + (this._y1 = y1);\n    }\n\n    // Otherwise, draw an arc!\n    else {\n      var x20 = x2 - x0,\n          y20 = y2 - y0,\n          l21_2 = x21 * x21 + y21 * y21,\n          l20_2 = x20 * x20 + y20 * y20,\n          l21 = Math.sqrt(l21_2),\n          l01 = Math.sqrt(l01_2),\n          l = r * Math.tan((pi - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2),\n          t01 = l / l01,\n          t21 = l / l21;\n\n      // If the start tangent is not coincident with (x0,y0), line to.\n      if (Math.abs(t01 - 1) > epsilon) {\n        this._ += \"L\" + (x1 + t01 * x01) + \",\" + (y1 + t01 * y01);\n      }\n\n      this._ += \"A\" + r + \",\" + r + \",0,0,\" + (+(y01 * x20 > x01 * y20)) + \",\" + (this._x1 = x1 + t21 * x21) + \",\" + (this._y1 = y1 + t21 * y21);\n    }\n  },\n  arc: function(x, y, r, a0, a1, ccw) {\n    x = +x, y = +y, r = +r, ccw = !!ccw;\n    var dx = r * Math.cos(a0),\n        dy = r * Math.sin(a0),\n        x0 = x + dx,\n        y0 = y + dy,\n        cw = 1 ^ ccw,\n        da = ccw ? a0 - a1 : a1 - a0;\n\n    // Is the radius negative? Error.\n    if (r < 0) throw new Error(\"negative radius: \" + r);\n\n    // Is this path empty? Move to (x0,y0).\n    if (this._x1 === null) {\n      this._ += \"M\" + x0 + \",\" + y0;\n    }\n\n    // Or, is (x0,y0) not coincident with the previous point? Line to (x0,y0).\n    else if (Math.abs(this._x1 - x0) > epsilon || Math.abs(this._y1 - y0) > epsilon) {\n      this._ += \"L\" + x0 + \",\" + y0;\n    }\n\n    // Is this arc empty? We’re done.\n    if (!r) return;\n\n    // Does the angle go the wrong way? Flip the direction.\n    if (da < 0) da = da % tau + tau;\n\n    // Is this a complete circle? Draw two arcs to complete the circle.\n    if (da > tauEpsilon) {\n      this._ += \"A\" + r + \",\" + r + \",0,1,\" + cw + \",\" + (x - dx) + \",\" + (y - dy) + \"A\" + r + \",\" + r + \",0,1,\" + cw + \",\" + (this._x1 = x0) + \",\" + (this._y1 = y0);\n    }\n\n    // Is this arc non-empty? Draw an arc!\n    else if (da > epsilon) {\n      this._ += \"A\" + r + \",\" + r + \",0,\" + (+(da >= pi)) + \",\" + cw + \",\" + (this._x1 = x + r * Math.cos(a1)) + \",\" + (this._y1 = y + r * Math.sin(a1));\n    }\n  },\n  rect: function(x, y, w, h) {\n    this._ += \"M\" + (this._x0 = this._x1 = +x) + \",\" + (this._y0 = this._y1 = +y) + \"h\" + (+w) + \"v\" + (+h) + \"h\" + (-w) + \"Z\";\n  },\n  toString: function() {\n    return this._;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (path);\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/path.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/arc.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/arc.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var d3_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-path */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/index.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./math.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/math.js\");\n\n\n\n\nfunction arcInnerRadius(d) {\n  return d.innerRadius;\n}\n\nfunction arcOuterRadius(d) {\n  return d.outerRadius;\n}\n\nfunction arcStartAngle(d) {\n  return d.startAngle;\n}\n\nfunction arcEndAngle(d) {\n  return d.endAngle;\n}\n\nfunction arcPadAngle(d) {\n  return d && d.padAngle; // Note: optional!\n}\n\nfunction intersect(x0, y0, x1, y1, x2, y2, x3, y3) {\n  var x10 = x1 - x0, y10 = y1 - y0,\n      x32 = x3 - x2, y32 = y3 - y2,\n      t = y32 * x10 - x32 * y10;\n  if (t * t < _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) return;\n  t = (x32 * (y0 - y2) - y32 * (x0 - x2)) / t;\n  return [x0 + t * x10, y0 + t * y10];\n}\n\n// Compute perpendicular offset line of length rc.\n// http://mathworld.wolfram.com/Circle-LineIntersection.html\nfunction cornerTangents(x0, y0, x1, y1, r1, rc, cw) {\n  var x01 = x0 - x1,\n      y01 = y0 - y1,\n      lo = (cw ? rc : -rc) / Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(x01 * x01 + y01 * y01),\n      ox = lo * y01,\n      oy = -lo * x01,\n      x11 = x0 + ox,\n      y11 = y0 + oy,\n      x10 = x1 + ox,\n      y10 = y1 + oy,\n      x00 = (x11 + x10) / 2,\n      y00 = (y11 + y10) / 2,\n      dx = x10 - x11,\n      dy = y10 - y11,\n      d2 = dx * dx + dy * dy,\n      r = r1 - rc,\n      D = x11 * y10 - x10 * y11,\n      d = (dy < 0 ? -1 : 1) * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"max\"])(0, r * r * d2 - D * D)),\n      cx0 = (D * dy - dx * d) / d2,\n      cy0 = (-D * dx - dy * d) / d2,\n      cx1 = (D * dy + dx * d) / d2,\n      cy1 = (-D * dx + dy * d) / d2,\n      dx0 = cx0 - x00,\n      dy0 = cy0 - y00,\n      dx1 = cx1 - x00,\n      dy1 = cy1 - y00;\n\n  // Pick the closer of the two intersection points.\n  // TODO Is there a faster way to determine which intersection to use?\n  if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) cx0 = cx1, cy0 = cy1;\n\n  return {\n    cx: cx0,\n    cy: cy0,\n    x01: -ox,\n    y01: -oy,\n    x11: cx0 * (r1 / r - 1),\n    y11: cy0 * (r1 / r - 1)\n  };\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var innerRadius = arcInnerRadius,\n      outerRadius = arcOuterRadius,\n      cornerRadius = Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(0),\n      padRadius = null,\n      startAngle = arcStartAngle,\n      endAngle = arcEndAngle,\n      padAngle = arcPadAngle,\n      context = null;\n\n  function arc() {\n    var buffer,\n        r,\n        r0 = +innerRadius.apply(this, arguments),\n        r1 = +outerRadius.apply(this, arguments),\n        a0 = startAngle.apply(this, arguments) - _math_js__WEBPACK_IMPORTED_MODULE_2__[\"halfPi\"],\n        a1 = endAngle.apply(this, arguments) - _math_js__WEBPACK_IMPORTED_MODULE_2__[\"halfPi\"],\n        da = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"abs\"])(a1 - a0),\n        cw = a1 > a0;\n\n    if (!context) context = buffer = Object(d3_path__WEBPACK_IMPORTED_MODULE_0__[\"path\"])();\n\n    // Ensure that the outer radius is always larger than the inner radius.\n    if (r1 < r0) r = r1, r1 = r0, r0 = r;\n\n    // Is it a point?\n    if (!(r1 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"])) context.moveTo(0, 0);\n\n    // Or is it a circle or annulus?\n    else if (da > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"tau\"] - _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n      context.moveTo(r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a0), r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a0));\n      context.arc(0, 0, r1, a0, a1, !cw);\n      if (r0 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n        context.moveTo(r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a1), r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a1));\n        context.arc(0, 0, r0, a1, a0, cw);\n      }\n    }\n\n    // Or is it a circular or annular sector?\n    else {\n      var a01 = a0,\n          a11 = a1,\n          a00 = a0,\n          a10 = a1,\n          da0 = da,\n          da1 = da,\n          ap = padAngle.apply(this, arguments) / 2,\n          rp = (ap > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) && (padRadius ? +padRadius.apply(this, arguments) : Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(r0 * r0 + r1 * r1)),\n          rc = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"min\"])(Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"abs\"])(r1 - r0) / 2, +cornerRadius.apply(this, arguments)),\n          rc0 = rc,\n          rc1 = rc,\n          t0,\n          t1;\n\n      // Apply padding? Note that since r1 ≥ r0, da1 ≥ da0.\n      if (rp > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n        var p0 = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"asin\"])(rp / r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(ap)),\n            p1 = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"asin\"])(rp / r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(ap));\n        if ((da0 -= p0 * 2) > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) p0 *= (cw ? 1 : -1), a00 += p0, a10 -= p0;\n        else da0 = 0, a00 = a10 = (a0 + a1) / 2;\n        if ((da1 -= p1 * 2) > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) p1 *= (cw ? 1 : -1), a01 += p1, a11 -= p1;\n        else da1 = 0, a01 = a11 = (a0 + a1) / 2;\n      }\n\n      var x01 = r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a01),\n          y01 = r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a01),\n          x10 = r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a10),\n          y10 = r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a10);\n\n      // Apply rounded corners?\n      if (rc > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n        var x11 = r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a11),\n            y11 = r1 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a11),\n            x00 = r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a00),\n            y00 = r0 * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a00),\n            oc;\n\n        // Restrict the corner radius according to the sector angle.\n        if (da < _math_js__WEBPACK_IMPORTED_MODULE_2__[\"pi\"] && (oc = intersect(x01, y01, x00, y00, x11, y11, x10, y10))) {\n          var ax = x01 - oc[0],\n              ay = y01 - oc[1],\n              bx = x11 - oc[0],\n              by = y11 - oc[1],\n              kc = 1 / Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"acos\"])((ax * bx + ay * by) / (Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(ax * ax + ay * ay) * Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(bx * bx + by * by))) / 2),\n              lc = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sqrt\"])(oc[0] * oc[0] + oc[1] * oc[1]);\n          rc0 = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"min\"])(rc, (r0 - lc) / (kc - 1));\n          rc1 = Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"min\"])(rc, (r1 - lc) / (kc + 1));\n        }\n      }\n\n      // Is the sector collapsed to a line?\n      if (!(da1 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"])) context.moveTo(x01, y01);\n\n      // Does the sector’s outer ring have rounded corners?\n      else if (rc1 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n        t0 = cornerTangents(x00, y00, x01, y01, r1, rc1, cw);\n        t1 = cornerTangents(x11, y11, x10, y10, r1, rc1, cw);\n\n        context.moveTo(t0.cx + t0.x01, t0.cy + t0.y01);\n\n        // Have the corners merged?\n        if (rc1 < rc) context.arc(t0.cx, t0.cy, rc1, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y01, t0.x01), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y01, t1.x01), !cw);\n\n        // Otherwise, draw the two corners and the ring.\n        else {\n          context.arc(t0.cx, t0.cy, rc1, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y01, t0.x01), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y11, t0.x11), !cw);\n          context.arc(0, 0, r1, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.cy + t0.y11, t0.cx + t0.x11), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.cy + t1.y11, t1.cx + t1.x11), !cw);\n          context.arc(t1.cx, t1.cy, rc1, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y11, t1.x11), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y01, t1.x01), !cw);\n        }\n      }\n\n      // Or is the outer ring just a circular arc?\n      else context.moveTo(x01, y01), context.arc(0, 0, r1, a01, a11, !cw);\n\n      // Is there no inner ring, and it’s a circular sector?\n      // Or perhaps it’s an annular sector collapsed due to padding?\n      if (!(r0 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) || !(da0 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"])) context.lineTo(x10, y10);\n\n      // Does the sector’s inner ring (or point) have rounded corners?\n      else if (rc0 > _math_js__WEBPACK_IMPORTED_MODULE_2__[\"epsilon\"]) {\n        t0 = cornerTangents(x10, y10, x11, y11, r0, -rc0, cw);\n        t1 = cornerTangents(x01, y01, x00, y00, r0, -rc0, cw);\n\n        context.lineTo(t0.cx + t0.x01, t0.cy + t0.y01);\n\n        // Have the corners merged?\n        if (rc0 < rc) context.arc(t0.cx, t0.cy, rc0, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y01, t0.x01), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y01, t1.x01), !cw);\n\n        // Otherwise, draw the two corners and the ring.\n        else {\n          context.arc(t0.cx, t0.cy, rc0, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y01, t0.x01), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.y11, t0.x11), !cw);\n          context.arc(0, 0, r0, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t0.cy + t0.y11, t0.cx + t0.x11), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.cy + t1.y11, t1.cx + t1.x11), cw);\n          context.arc(t1.cx, t1.cy, rc0, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y11, t1.x11), Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"atan2\"])(t1.y01, t1.x01), !cw);\n        }\n      }\n\n      // Or is the inner ring just a circular arc?\n      else context.arc(0, 0, r0, a10, a00, cw);\n    }\n\n    context.closePath();\n\n    if (buffer) return context = null, buffer + \"\" || null;\n  }\n\n  arc.centroid = function() {\n    var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2,\n        a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - _math_js__WEBPACK_IMPORTED_MODULE_2__[\"pi\"] / 2;\n    return [Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"cos\"])(a) * r, Object(_math_js__WEBPACK_IMPORTED_MODULE_2__[\"sin\"])(a) * r];\n  };\n\n  arc.innerRadius = function(_) {\n    return arguments.length ? (innerRadius = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : innerRadius;\n  };\n\n  arc.outerRadius = function(_) {\n    return arguments.length ? (outerRadius = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : outerRadius;\n  };\n\n  arc.cornerRadius = function(_) {\n    return arguments.length ? (cornerRadius = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : cornerRadius;\n  };\n\n  arc.padRadius = function(_) {\n    return arguments.length ? (padRadius = _ == null ? null : typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : padRadius;\n  };\n\n  arc.startAngle = function(_) {\n    return arguments.length ? (startAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : startAngle;\n  };\n\n  arc.endAngle = function(_) {\n    return arguments.length ? (endAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : endAngle;\n  };\n\n  arc.padAngle = function(_) {\n    return arguments.length ? (padAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), arc) : padAngle;\n  };\n\n  arc.context = function(_) {\n    return arguments.length ? ((context = _ == null ? null : _), arc) : context;\n  };\n\n  return arc;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/arc.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/area.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/area.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var d3_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-path */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/index.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _curve_linear_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./curve/linear.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linear.js\");\n/* harmony import */ var _line_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./line.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/line.js\");\n/* harmony import */ var _point_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./point.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/point.js\");\n\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var x0 = _point_js__WEBPACK_IMPORTED_MODULE_4__[\"x\"],\n      x1 = null,\n      y0 = Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(0),\n      y1 = _point_js__WEBPACK_IMPORTED_MODULE_4__[\"y\"],\n      defined = Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(true),\n      context = null,\n      curve = _curve_linear_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n      output = null;\n\n  function area(data) {\n    var i,\n        j,\n        k,\n        n = data.length,\n        d,\n        defined0 = false,\n        buffer,\n        x0z = new Array(n),\n        y0z = new Array(n);\n\n    if (context == null) output = curve(buffer = Object(d3_path__WEBPACK_IMPORTED_MODULE_0__[\"path\"])());\n\n    for (i = 0; i <= n; ++i) {\n      if (!(i < n && defined(d = data[i], i, data)) === defined0) {\n        if (defined0 = !defined0) {\n          j = i;\n          output.areaStart();\n          output.lineStart();\n        } else {\n          output.lineEnd();\n          output.lineStart();\n          for (k = i - 1; k >= j; --k) {\n            output.point(x0z[k], y0z[k]);\n          }\n          output.lineEnd();\n          output.areaEnd();\n        }\n      }\n      if (defined0) {\n        x0z[i] = +x0(d, i, data), y0z[i] = +y0(d, i, data);\n        output.point(x1 ? +x1(d, i, data) : x0z[i], y1 ? +y1(d, i, data) : y0z[i]);\n      }\n    }\n\n    if (buffer) return output = null, buffer + \"\" || null;\n  }\n\n  function arealine() {\n    return Object(_line_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])().defined(defined).curve(curve).context(context);\n  }\n\n  area.x = function(_) {\n    return arguments.length ? (x0 = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), x1 = null, area) : x0;\n  };\n\n  area.x0 = function(_) {\n    return arguments.length ? (x0 = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), area) : x0;\n  };\n\n  area.x1 = function(_) {\n    return arguments.length ? (x1 = _ == null ? null : typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), area) : x1;\n  };\n\n  area.y = function(_) {\n    return arguments.length ? (y0 = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), y1 = null, area) : y0;\n  };\n\n  area.y0 = function(_) {\n    return arguments.length ? (y0 = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), area) : y0;\n  };\n\n  area.y1 = function(_) {\n    return arguments.length ? (y1 = _ == null ? null : typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), area) : y1;\n  };\n\n  area.lineX0 =\n  area.lineY0 = function() {\n    return arealine().x(x0).y(y0);\n  };\n\n  area.lineY1 = function() {\n    return arealine().x(x0).y(y1);\n  };\n\n  area.lineX1 = function() {\n    return arealine().x(x1).y(y0);\n  };\n\n  area.defined = function(_) {\n    return arguments.length ? (defined = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(!!_), area) : defined;\n  };\n\n  area.curve = function(_) {\n    return arguments.length ? (curve = _, context != null && (output = curve(context)), area) : curve;\n  };\n\n  area.context = function(_) {\n    return arguments.length ? (_ == null ? context = output = null : output = curve(context = _), area) : context;\n  };\n\n  return area;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/area.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/areaRadial.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/areaRadial.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _curve_radial_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./curve/radial.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/radial.js\");\n/* harmony import */ var _area_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./area.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/area.js\");\n/* harmony import */ var _lineRadial_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lineRadial.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/lineRadial.js\");\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var a = Object(_area_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])().curve(_curve_radial_js__WEBPACK_IMPORTED_MODULE_0__[\"curveRadialLinear\"]),\n      c = a.curve,\n      x0 = a.lineX0,\n      x1 = a.lineX1,\n      y0 = a.lineY0,\n      y1 = a.lineY1;\n\n  a.angle = a.x, delete a.x;\n  a.startAngle = a.x0, delete a.x0;\n  a.endAngle = a.x1, delete a.x1;\n  a.radius = a.y, delete a.y;\n  a.innerRadius = a.y0, delete a.y0;\n  a.outerRadius = a.y1, delete a.y1;\n  a.lineStartAngle = function() { return Object(_lineRadial_js__WEBPACK_IMPORTED_MODULE_2__[\"lineRadial\"])(x0()); }, delete a.lineX0;\n  a.lineEndAngle = function() { return Object(_lineRadial_js__WEBPACK_IMPORTED_MODULE_2__[\"lineRadial\"])(x1()); }, delete a.lineX1;\n  a.lineInnerRadius = function() { return Object(_lineRadial_js__WEBPACK_IMPORTED_MODULE_2__[\"lineRadial\"])(y0()); }, delete a.lineY0;\n  a.lineOuterRadius = function() { return Object(_lineRadial_js__WEBPACK_IMPORTED_MODULE_2__[\"lineRadial\"])(y1()); }, delete a.lineY1;\n\n  a.curve = function(_) {\n    return arguments.length ? c(Object(_curve_radial_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(_)) : c()._curve;\n  };\n\n  return a;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/areaRadial.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/array.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/array.js ***!
  \***************************************************************************/
/*! exports provided: slice */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"slice\", function() { return slice; });\nvar slice = Array.prototype.slice;\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/array.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x) {\n  return function constant() {\n    return x;\n  };\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basis.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basis.js ***!
  \*********************************************************************************/
/*! exports provided: point, Basis, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"point\", function() { return point; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Basis\", function() { return Basis; });\nfunction point(that, x, y) {\n  that._context.bezierCurveTo(\n    (2 * that._x0 + that._x1) / 3,\n    (2 * that._y0 + that._y1) / 3,\n    (that._x0 + 2 * that._x1) / 3,\n    (that._y0 + 2 * that._y1) / 3,\n    (that._x0 + 4 * that._x1 + x) / 6,\n    (that._y0 + 4 * that._y1 + y) / 6\n  );\n}\n\nfunction Basis(context) {\n  this._context = context;\n}\n\nBasis.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 =\n    this._y0 = this._y1 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 3: point(this, this._x1, this._y1); // proceed\n      case 2: this._context.lineTo(this._x1, this._y1); break;\n    }\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6); // proceed\n      default: point(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = x;\n    this._y0 = this._y1, this._y1 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new Basis(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basis.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basisClosed.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basisClosed.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _noop_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../noop.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/noop.js\");\n/* harmony import */ var _basis_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./basis.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basis.js\");\n\n\n\nfunction BasisClosed(context) {\n  this._context = context;\n}\n\nBasisClosed.prototype = {\n  areaStart: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  areaEnd: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 =\n    this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 1: {\n        this._context.moveTo(this._x2, this._y2);\n        this._context.closePath();\n        break;\n      }\n      case 2: {\n        this._context.moveTo((this._x2 + 2 * this._x3) / 3, (this._y2 + 2 * this._y3) / 3);\n        this._context.lineTo((this._x3 + 2 * this._x2) / 3, (this._y3 + 2 * this._y2) / 3);\n        this._context.closePath();\n        break;\n      }\n      case 3: {\n        this.point(this._x2, this._y2);\n        this.point(this._x3, this._y3);\n        this.point(this._x4, this._y4);\n        break;\n      }\n    }\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._x2 = x, this._y2 = y; break;\n      case 1: this._point = 2; this._x3 = x, this._y3 = y; break;\n      case 2: this._point = 3; this._x4 = x, this._y4 = y; this._context.moveTo((this._x0 + 4 * this._x1 + x) / 6, (this._y0 + 4 * this._y1 + y) / 6); break;\n      default: Object(_basis_js__WEBPACK_IMPORTED_MODULE_1__[\"point\"])(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = x;\n    this._y0 = this._y1, this._y1 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new BasisClosed(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basisClosed.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basisOpen.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basisOpen.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _basis_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./basis.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basis.js\");\n\n\nfunction BasisOpen(context) {\n  this._context = context;\n}\n\nBasisOpen.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 =\n    this._y0 = this._y1 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (this._line || (this._line !== 0 && this._point === 3)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; var x0 = (this._x0 + 4 * this._x1 + x) / 6, y0 = (this._y0 + 4 * this._y1 + y) / 6; this._line ? this._context.lineTo(x0, y0) : this._context.moveTo(x0, y0); break;\n      case 3: this._point = 4; // proceed\n      default: Object(_basis_js__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = x;\n    this._y0 = this._y1, this._y1 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new BasisOpen(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basisOpen.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/bundle.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/bundle.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _basis_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./basis.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basis.js\");\n\n\nfunction Bundle(context, beta) {\n  this._basis = new _basis_js__WEBPACK_IMPORTED_MODULE_0__[\"Basis\"](context);\n  this._beta = beta;\n}\n\nBundle.prototype = {\n  lineStart: function() {\n    this._x = [];\n    this._y = [];\n    this._basis.lineStart();\n  },\n  lineEnd: function() {\n    var x = this._x,\n        y = this._y,\n        j = x.length - 1;\n\n    if (j > 0) {\n      var x0 = x[0],\n          y0 = y[0],\n          dx = x[j] - x0,\n          dy = y[j] - y0,\n          i = -1,\n          t;\n\n      while (++i <= j) {\n        t = i / j;\n        this._basis.point(\n          this._beta * x[i] + (1 - this._beta) * (x0 + t * dx),\n          this._beta * y[i] + (1 - this._beta) * (y0 + t * dy)\n        );\n      }\n    }\n\n    this._x = this._y = null;\n    this._basis.lineEnd();\n  },\n  point: function(x, y) {\n    this._x.push(+x);\n    this._y.push(+y);\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(beta) {\n\n  function bundle(context) {\n    return beta === 1 ? new _basis_js__WEBPACK_IMPORTED_MODULE_0__[\"Basis\"](context) : new Bundle(context, beta);\n  }\n\n  bundle.beta = function(beta) {\n    return custom(+beta);\n  };\n\n  return bundle;\n})(0.85));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/bundle.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinal.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinal.js ***!
  \************************************************************************************/
/*! exports provided: point, Cardinal, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"point\", function() { return point; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Cardinal\", function() { return Cardinal; });\nfunction point(that, x, y) {\n  that._context.bezierCurveTo(\n    that._x1 + that._k * (that._x2 - that._x0),\n    that._y1 + that._k * (that._y2 - that._y0),\n    that._x2 + that._k * (that._x1 - x),\n    that._y2 + that._k * (that._y1 - y),\n    that._x2,\n    that._y2\n  );\n}\n\nfunction Cardinal(context, tension) {\n  this._context = context;\n  this._k = (1 - tension) / 6;\n}\n\nCardinal.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 =\n    this._y0 = this._y1 = this._y2 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 2: this._context.lineTo(this._x2, this._y2); break;\n      case 3: point(this, this._x1, this._y1); break;\n    }\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; this._x1 = x, this._y1 = y; break;\n      case 2: this._point = 3; // proceed\n      default: point(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(tension) {\n\n  function cardinal(context) {\n    return new Cardinal(context, tension);\n  }\n\n  cardinal.tension = function(tension) {\n    return custom(+tension);\n  };\n\n  return cardinal;\n})(0));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinal.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalClosed.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalClosed.js ***!
  \******************************************************************************************/
/*! exports provided: CardinalClosed, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"CardinalClosed\", function() { return CardinalClosed; });\n/* harmony import */ var _noop_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../noop.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/noop.js\");\n/* harmony import */ var _cardinal_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cardinal.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinal.js\");\n\n\n\nfunction CardinalClosed(context, tension) {\n  this._context = context;\n  this._k = (1 - tension) / 6;\n}\n\nCardinalClosed.prototype = {\n  areaStart: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  areaEnd: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 =\n    this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 1: {\n        this._context.moveTo(this._x3, this._y3);\n        this._context.closePath();\n        break;\n      }\n      case 2: {\n        this._context.lineTo(this._x3, this._y3);\n        this._context.closePath();\n        break;\n      }\n      case 3: {\n        this.point(this._x3, this._y3);\n        this.point(this._x4, this._y4);\n        this.point(this._x5, this._y5);\n        break;\n      }\n    }\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._x3 = x, this._y3 = y; break;\n      case 1: this._point = 2; this._context.moveTo(this._x4 = x, this._y4 = y); break;\n      case 2: this._point = 3; this._x5 = x, this._y5 = y; break;\n      default: Object(_cardinal_js__WEBPACK_IMPORTED_MODULE_1__[\"point\"])(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(tension) {\n\n  function cardinal(context) {\n    return new CardinalClosed(context, tension);\n  }\n\n  cardinal.tension = function(tension) {\n    return custom(+tension);\n  };\n\n  return cardinal;\n})(0));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalClosed.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalOpen.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalOpen.js ***!
  \****************************************************************************************/
/*! exports provided: CardinalOpen, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"CardinalOpen\", function() { return CardinalOpen; });\n/* harmony import */ var _cardinal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cardinal.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinal.js\");\n\n\nfunction CardinalOpen(context, tension) {\n  this._context = context;\n  this._k = (1 - tension) / 6;\n}\n\nCardinalOpen.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 =\n    this._y0 = this._y1 = this._y2 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (this._line || (this._line !== 0 && this._point === 3)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2); break;\n      case 3: this._point = 4; // proceed\n      default: Object(_cardinal_js__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(this, x, y); break;\n    }\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(tension) {\n\n  function cardinal(context) {\n    return new CardinalOpen(context, tension);\n  }\n\n  cardinal.tension = function(tension) {\n    return custom(+tension);\n  };\n\n  return cardinal;\n})(0));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalOpen.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRom.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRom.js ***!
  \**************************************************************************************/
/*! exports provided: point, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"point\", function() { return point; });\n/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../math.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/math.js\");\n/* harmony import */ var _cardinal_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cardinal.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinal.js\");\n\n\n\nfunction point(that, x, y) {\n  var x1 = that._x1,\n      y1 = that._y1,\n      x2 = that._x2,\n      y2 = that._y2;\n\n  if (that._l01_a > _math_js__WEBPACK_IMPORTED_MODULE_0__[\"epsilon\"]) {\n    var a = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a,\n        n = 3 * that._l01_a * (that._l01_a + that._l12_a);\n    x1 = (x1 * a - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n;\n    y1 = (y1 * a - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;\n  }\n\n  if (that._l23_a > _math_js__WEBPACK_IMPORTED_MODULE_0__[\"epsilon\"]) {\n    var b = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a,\n        m = 3 * that._l23_a * (that._l23_a + that._l12_a);\n    x2 = (x2 * b + that._x1 * that._l23_2a - x * that._l12_2a) / m;\n    y2 = (y2 * b + that._y1 * that._l23_2a - y * that._l12_2a) / m;\n  }\n\n  that._context.bezierCurveTo(x1, y1, x2, y2, that._x2, that._y2);\n}\n\nfunction CatmullRom(context, alpha) {\n  this._context = context;\n  this._alpha = alpha;\n}\n\nCatmullRom.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 =\n    this._y0 = this._y1 = this._y2 = NaN;\n    this._l01_a = this._l12_a = this._l23_a =\n    this._l01_2a = this._l12_2a = this._l23_2a =\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 2: this._context.lineTo(this._x2, this._y2); break;\n      case 3: this.point(this._x2, this._y2); break;\n    }\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n\n    if (this._point) {\n      var x23 = this._x2 - x,\n          y23 = this._y2 - y;\n      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));\n    }\n\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; // proceed\n      default: point(this, x, y); break;\n    }\n\n    this._l01_a = this._l12_a, this._l12_a = this._l23_a;\n    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(alpha) {\n\n  function catmullRom(context) {\n    return alpha ? new CatmullRom(context, alpha) : new _cardinal_js__WEBPACK_IMPORTED_MODULE_1__[\"Cardinal\"](context, 0);\n  }\n\n  catmullRom.alpha = function(alpha) {\n    return custom(+alpha);\n  };\n\n  return catmullRom;\n})(0.5));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRom.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRomClosed.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRomClosed.js ***!
  \********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _cardinalClosed_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cardinalClosed.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalClosed.js\");\n/* harmony import */ var _noop_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../noop.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/noop.js\");\n/* harmony import */ var _catmullRom_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./catmullRom.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRom.js\");\n\n\n\n\nfunction CatmullRomClosed(context, alpha) {\n  this._context = context;\n  this._alpha = alpha;\n}\n\nCatmullRomClosed.prototype = {\n  areaStart: _noop_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  areaEnd: _noop_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 =\n    this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;\n    this._l01_a = this._l12_a = this._l23_a =\n    this._l01_2a = this._l12_2a = this._l23_2a =\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 1: {\n        this._context.moveTo(this._x3, this._y3);\n        this._context.closePath();\n        break;\n      }\n      case 2: {\n        this._context.lineTo(this._x3, this._y3);\n        this._context.closePath();\n        break;\n      }\n      case 3: {\n        this.point(this._x3, this._y3);\n        this.point(this._x4, this._y4);\n        this.point(this._x5, this._y5);\n        break;\n      }\n    }\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n\n    if (this._point) {\n      var x23 = this._x2 - x,\n          y23 = this._y2 - y;\n      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));\n    }\n\n    switch (this._point) {\n      case 0: this._point = 1; this._x3 = x, this._y3 = y; break;\n      case 1: this._point = 2; this._context.moveTo(this._x4 = x, this._y4 = y); break;\n      case 2: this._point = 3; this._x5 = x, this._y5 = y; break;\n      default: Object(_catmullRom_js__WEBPACK_IMPORTED_MODULE_2__[\"point\"])(this, x, y); break;\n    }\n\n    this._l01_a = this._l12_a, this._l12_a = this._l23_a;\n    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(alpha) {\n\n  function catmullRom(context) {\n    return alpha ? new CatmullRomClosed(context, alpha) : new _cardinalClosed_js__WEBPACK_IMPORTED_MODULE_0__[\"CardinalClosed\"](context, 0);\n  }\n\n  catmullRom.alpha = function(alpha) {\n    return custom(+alpha);\n  };\n\n  return catmullRom;\n})(0.5));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRomClosed.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRomOpen.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRomOpen.js ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _cardinalOpen_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cardinalOpen.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalOpen.js\");\n/* harmony import */ var _catmullRom_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./catmullRom.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRom.js\");\n\n\n\nfunction CatmullRomOpen(context, alpha) {\n  this._context = context;\n  this._alpha = alpha;\n}\n\nCatmullRomOpen.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 = this._x2 =\n    this._y0 = this._y1 = this._y2 = NaN;\n    this._l01_a = this._l12_a = this._l23_a =\n    this._l01_2a = this._l12_2a = this._l23_2a =\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (this._line || (this._line !== 0 && this._point === 3)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n\n    if (this._point) {\n      var x23 = this._x2 - x,\n          y23 = this._y2 - y;\n      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));\n    }\n\n    switch (this._point) {\n      case 0: this._point = 1; break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2); break;\n      case 3: this._point = 4; // proceed\n      default: Object(_catmullRom_js__WEBPACK_IMPORTED_MODULE_1__[\"point\"])(this, x, y); break;\n    }\n\n    this._l01_a = this._l12_a, this._l12_a = this._l23_a;\n    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;\n    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x;\n    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ((function custom(alpha) {\n\n  function catmullRom(context) {\n    return alpha ? new CatmullRomOpen(context, alpha) : new _cardinalOpen_js__WEBPACK_IMPORTED_MODULE_0__[\"CardinalOpen\"](context, 0);\n  }\n\n  catmullRom.alpha = function(alpha) {\n    return custom(+alpha);\n  };\n\n  return catmullRom;\n})(0.5));\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRomOpen.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linear.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linear.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction Linear(context) {\n  this._context = context;\n}\n\nLinear.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; // proceed\n      default: this._context.lineTo(x, y); break;\n    }\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new Linear(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linear.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linearClosed.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linearClosed.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _noop_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../noop.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/noop.js\");\n\n\nfunction LinearClosed(context) {\n  this._context = context;\n}\n\nLinearClosed.prototype = {\n  areaStart: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  areaEnd: _noop_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  lineStart: function() {\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (this._point) this._context.closePath();\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    if (this._point) this._context.lineTo(x, y);\n    else this._point = 1, this._context.moveTo(x, y);\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new LinearClosed(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linearClosed.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/monotone.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/monotone.js ***!
  \************************************************************************************/
/*! exports provided: monotoneX, monotoneY */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"monotoneX\", function() { return monotoneX; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"monotoneY\", function() { return monotoneY; });\nfunction sign(x) {\n  return x < 0 ? -1 : 1;\n}\n\n// Calculate the slopes of the tangents (Hermite-type interpolation) based on\n// the following paper: Steffen, M. 1990. A Simple Method for Monotonic\n// Interpolation in One Dimension. Astronomy and Astrophysics, Vol. 239, NO.\n// NOV(II), P. 443, 1990.\nfunction slope3(that, x2, y2) {\n  var h0 = that._x1 - that._x0,\n      h1 = x2 - that._x1,\n      s0 = (that._y1 - that._y0) / (h0 || h1 < 0 && -0),\n      s1 = (y2 - that._y1) / (h1 || h0 < 0 && -0),\n      p = (s0 * h1 + s1 * h0) / (h0 + h1);\n  return (sign(s0) + sign(s1)) * Math.min(Math.abs(s0), Math.abs(s1), 0.5 * Math.abs(p)) || 0;\n}\n\n// Calculate a one-sided slope.\nfunction slope2(that, t) {\n  var h = that._x1 - that._x0;\n  return h ? (3 * (that._y1 - that._y0) / h - t) / 2 : t;\n}\n\n// According to https://en.wikipedia.org/wiki/Cubic_Hermite_spline#Representations\n// \"you can express cubic Hermite interpolation in terms of cubic Bézier curves\n// with respect to the four values p0, p0 + m0 / 3, p1 - m1 / 3, p1\".\nfunction point(that, t0, t1) {\n  var x0 = that._x0,\n      y0 = that._y0,\n      x1 = that._x1,\n      y1 = that._y1,\n      dx = (x1 - x0) / 3;\n  that._context.bezierCurveTo(x0 + dx, y0 + dx * t0, x1 - dx, y1 - dx * t1, x1, y1);\n}\n\nfunction MonotoneX(context) {\n  this._context = context;\n}\n\nMonotoneX.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x0 = this._x1 =\n    this._y0 = this._y1 =\n    this._t0 = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    switch (this._point) {\n      case 2: this._context.lineTo(this._x1, this._y1); break;\n      case 3: point(this, this._t0, slope2(this, this._t0)); break;\n    }\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    var t1 = NaN;\n\n    x = +x, y = +y;\n    if (x === this._x1 && y === this._y1) return; // Ignore coincident points.\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; break;\n      case 2: this._point = 3; point(this, slope2(this, t1 = slope3(this, x, y)), t1); break;\n      default: point(this, this._t0, t1 = slope3(this, x, y)); break;\n    }\n\n    this._x0 = this._x1, this._x1 = x;\n    this._y0 = this._y1, this._y1 = y;\n    this._t0 = t1;\n  }\n}\n\nfunction MonotoneY(context) {\n  this._context = new ReflectContext(context);\n}\n\n(MonotoneY.prototype = Object.create(MonotoneX.prototype)).point = function(x, y) {\n  MonotoneX.prototype.point.call(this, y, x);\n};\n\nfunction ReflectContext(context) {\n  this._context = context;\n}\n\nReflectContext.prototype = {\n  moveTo: function(x, y) { this._context.moveTo(y, x); },\n  closePath: function() { this._context.closePath(); },\n  lineTo: function(x, y) { this._context.lineTo(y, x); },\n  bezierCurveTo: function(x1, y1, x2, y2, x, y) { this._context.bezierCurveTo(y1, x1, y2, x2, y, x); }\n};\n\nfunction monotoneX(context) {\n  return new MonotoneX(context);\n}\n\nfunction monotoneY(context) {\n  return new MonotoneY(context);\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/monotone.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/natural.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/natural.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction Natural(context) {\n  this._context = context;\n}\n\nNatural.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x = [];\n    this._y = [];\n  },\n  lineEnd: function() {\n    var x = this._x,\n        y = this._y,\n        n = x.length;\n\n    if (n) {\n      this._line ? this._context.lineTo(x[0], y[0]) : this._context.moveTo(x[0], y[0]);\n      if (n === 2) {\n        this._context.lineTo(x[1], y[1]);\n      } else {\n        var px = controlPoints(x),\n            py = controlPoints(y);\n        for (var i0 = 0, i1 = 1; i1 < n; ++i0, ++i1) {\n          this._context.bezierCurveTo(px[0][i0], py[0][i0], px[1][i0], py[1][i0], x[i1], y[i1]);\n        }\n      }\n    }\n\n    if (this._line || (this._line !== 0 && n === 1)) this._context.closePath();\n    this._line = 1 - this._line;\n    this._x = this._y = null;\n  },\n  point: function(x, y) {\n    this._x.push(+x);\n    this._y.push(+y);\n  }\n};\n\n// See https://www.particleincell.com/2012/bezier-splines/ for derivation.\nfunction controlPoints(x) {\n  var i,\n      n = x.length - 1,\n      m,\n      a = new Array(n),\n      b = new Array(n),\n      r = new Array(n);\n  a[0] = 0, b[0] = 2, r[0] = x[0] + 2 * x[1];\n  for (i = 1; i < n - 1; ++i) a[i] = 1, b[i] = 4, r[i] = 4 * x[i] + 2 * x[i + 1];\n  a[n - 1] = 2, b[n - 1] = 7, r[n - 1] = 8 * x[n - 1] + x[n];\n  for (i = 1; i < n; ++i) m = a[i] / b[i - 1], b[i] -= m, r[i] -= m * r[i - 1];\n  a[n - 1] = r[n - 1] / b[n - 1];\n  for (i = n - 2; i >= 0; --i) a[i] = (r[i] - a[i + 1]) / b[i];\n  b[n - 1] = (x[n] + a[n - 1]) / 2;\n  for (i = 0; i < n - 1; ++i) b[i] = 2 * x[i + 1] - a[i + 1];\n  return [a, b];\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new Natural(context);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/natural.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/radial.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/radial.js ***!
  \**********************************************************************************/
/*! exports provided: curveRadialLinear, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"curveRadialLinear\", function() { return curveRadialLinear; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return curveRadial; });\n/* harmony import */ var _linear_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./linear.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linear.js\");\n\n\nvar curveRadialLinear = curveRadial(_linear_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\nfunction Radial(curve) {\n  this._curve = curve;\n}\n\nRadial.prototype = {\n  areaStart: function() {\n    this._curve.areaStart();\n  },\n  areaEnd: function() {\n    this._curve.areaEnd();\n  },\n  lineStart: function() {\n    this._curve.lineStart();\n  },\n  lineEnd: function() {\n    this._curve.lineEnd();\n  },\n  point: function(a, r) {\n    this._curve.point(r * Math.sin(a), r * -Math.cos(a));\n  }\n};\n\nfunction curveRadial(curve) {\n\n  function radial(context) {\n    return new Radial(curve(context));\n  }\n\n  radial._curve = curve;\n\n  return radial;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/radial.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/step.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/step.js ***!
  \********************************************************************************/
/*! exports provided: default, stepBefore, stepAfter */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"stepBefore\", function() { return stepBefore; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"stepAfter\", function() { return stepAfter; });\nfunction Step(context, t) {\n  this._context = context;\n  this._t = t;\n}\n\nStep.prototype = {\n  areaStart: function() {\n    this._line = 0;\n  },\n  areaEnd: function() {\n    this._line = NaN;\n  },\n  lineStart: function() {\n    this._x = this._y = NaN;\n    this._point = 0;\n  },\n  lineEnd: function() {\n    if (0 < this._t && this._t < 1 && this._point === 2) this._context.lineTo(this._x, this._y);\n    if (this._line || (this._line !== 0 && this._point === 1)) this._context.closePath();\n    if (this._line >= 0) this._t = 1 - this._t, this._line = 1 - this._line;\n  },\n  point: function(x, y) {\n    x = +x, y = +y;\n    switch (this._point) {\n      case 0: this._point = 1; this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y); break;\n      case 1: this._point = 2; // proceed\n      default: {\n        if (this._t <= 0) {\n          this._context.lineTo(this._x, y);\n          this._context.lineTo(x, y);\n        } else {\n          var x1 = this._x * (1 - this._t) + x * this._t;\n          this._context.lineTo(x1, this._y);\n          this._context.lineTo(x1, y);\n        }\n        break;\n      }\n    }\n    this._x = x, this._y = y;\n  }\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(context) {\n  return new Step(context, 0.5);\n});\n\nfunction stepBefore(context) {\n  return new Step(context, 0);\n}\n\nfunction stepAfter(context) {\n  return new Step(context, 1);\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/step.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/descending.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/descending.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(a, b) {\n  return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/descending.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/identity.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/identity.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(d) {\n  return d;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/identity.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/index.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/index.js ***!
  \***************************************************************************/
/*! exports provided: arc, area, line, pie, areaRadial, radialArea, lineRadial, radialLine, pointRadial, linkHorizontal, linkVertical, linkRadial, symbol, symbols, symbolCircle, symbolCross, symbolDiamond, symbolSquare, symbolStar, symbolTriangle, symbolWye, curveBasisClosed, curveBasisOpen, curveBasis, curveBundle, curveCardinalClosed, curveCardinalOpen, curveCardinal, curveCatmullRomClosed, curveCatmullRomOpen, curveCatmullRom, curveLinearClosed, curveLinear, curveMonotoneX, curveMonotoneY, curveNatural, curveStep, curveStepAfter, curveStepBefore, stack, stackOffsetExpand, stackOffsetDiverging, stackOffsetNone, stackOffsetSilhouette, stackOffsetWiggle, stackOrderAppearance, stackOrderAscending, stackOrderDescending, stackOrderInsideOut, stackOrderNone, stackOrderReverse */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _arc_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arc.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/arc.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"arc\", function() { return _arc_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n/* harmony import */ var _area_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./area.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/area.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"area\", function() { return _area_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]; });\n\n/* harmony import */ var _line_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./line.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/line.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"line\", function() { return _line_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]; });\n\n/* harmony import */ var _pie_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pie.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pie.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"pie\", function() { return _pie_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"]; });\n\n/* harmony import */ var _areaRadial_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./areaRadial.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/areaRadial.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"areaRadial\", function() { return _areaRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"radialArea\", function() { return _areaRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]; });\n\n/* harmony import */ var _lineRadial_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./lineRadial.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/lineRadial.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"lineRadial\", function() { return _lineRadial_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"radialLine\", function() { return _lineRadial_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"]; });\n\n/* harmony import */ var _pointRadial_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./pointRadial.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pointRadial.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"pointRadial\", function() { return _pointRadial_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"]; });\n\n/* harmony import */ var _link_index_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./link/index.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/link/index.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"linkHorizontal\", function() { return _link_index_js__WEBPACK_IMPORTED_MODULE_7__[\"linkHorizontal\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"linkVertical\", function() { return _link_index_js__WEBPACK_IMPORTED_MODULE_7__[\"linkVertical\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"linkRadial\", function() { return _link_index_js__WEBPACK_IMPORTED_MODULE_7__[\"linkRadial\"]; });\n\n/* harmony import */ var _symbol_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./symbol.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbol\", function() { return _symbol_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbols\", function() { return _symbol_js__WEBPACK_IMPORTED_MODULE_8__[\"symbols\"]; });\n\n/* harmony import */ var _symbol_circle_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./symbol/circle.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/circle.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolCircle\", function() { return _symbol_circle_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"]; });\n\n/* harmony import */ var _symbol_cross_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./symbol/cross.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/cross.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolCross\", function() { return _symbol_cross_js__WEBPACK_IMPORTED_MODULE_10__[\"default\"]; });\n\n/* harmony import */ var _symbol_diamond_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./symbol/diamond.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/diamond.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolDiamond\", function() { return _symbol_diamond_js__WEBPACK_IMPORTED_MODULE_11__[\"default\"]; });\n\n/* harmony import */ var _symbol_square_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./symbol/square.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/square.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolSquare\", function() { return _symbol_square_js__WEBPACK_IMPORTED_MODULE_12__[\"default\"]; });\n\n/* harmony import */ var _symbol_star_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./symbol/star.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/star.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolStar\", function() { return _symbol_star_js__WEBPACK_IMPORTED_MODULE_13__[\"default\"]; });\n\n/* harmony import */ var _symbol_triangle_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./symbol/triangle.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/triangle.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolTriangle\", function() { return _symbol_triangle_js__WEBPACK_IMPORTED_MODULE_14__[\"default\"]; });\n\n/* harmony import */ var _symbol_wye_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./symbol/wye.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/wye.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"symbolWye\", function() { return _symbol_wye_js__WEBPACK_IMPORTED_MODULE_15__[\"default\"]; });\n\n/* harmony import */ var _curve_basisClosed_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./curve/basisClosed.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basisClosed.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveBasisClosed\", function() { return _curve_basisClosed_js__WEBPACK_IMPORTED_MODULE_16__[\"default\"]; });\n\n/* harmony import */ var _curve_basisOpen_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./curve/basisOpen.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basisOpen.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveBasisOpen\", function() { return _curve_basisOpen_js__WEBPACK_IMPORTED_MODULE_17__[\"default\"]; });\n\n/* harmony import */ var _curve_basis_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./curve/basis.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basis.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveBasis\", function() { return _curve_basis_js__WEBPACK_IMPORTED_MODULE_18__[\"default\"]; });\n\n/* harmony import */ var _curve_bundle_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./curve/bundle.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/bundle.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveBundle\", function() { return _curve_bundle_js__WEBPACK_IMPORTED_MODULE_19__[\"default\"]; });\n\n/* harmony import */ var _curve_cardinalClosed_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./curve/cardinalClosed.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalClosed.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCardinalClosed\", function() { return _curve_cardinalClosed_js__WEBPACK_IMPORTED_MODULE_20__[\"default\"]; });\n\n/* harmony import */ var _curve_cardinalOpen_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./curve/cardinalOpen.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalOpen.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCardinalOpen\", function() { return _curve_cardinalOpen_js__WEBPACK_IMPORTED_MODULE_21__[\"default\"]; });\n\n/* harmony import */ var _curve_cardinal_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./curve/cardinal.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinal.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCardinal\", function() { return _curve_cardinal_js__WEBPACK_IMPORTED_MODULE_22__[\"default\"]; });\n\n/* harmony import */ var _curve_catmullRomClosed_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./curve/catmullRomClosed.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRomClosed.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCatmullRomClosed\", function() { return _curve_catmullRomClosed_js__WEBPACK_IMPORTED_MODULE_23__[\"default\"]; });\n\n/* harmony import */ var _curve_catmullRomOpen_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./curve/catmullRomOpen.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRomOpen.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCatmullRomOpen\", function() { return _curve_catmullRomOpen_js__WEBPACK_IMPORTED_MODULE_24__[\"default\"]; });\n\n/* harmony import */ var _curve_catmullRom_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./curve/catmullRom.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRom.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveCatmullRom\", function() { return _curve_catmullRom_js__WEBPACK_IMPORTED_MODULE_25__[\"default\"]; });\n\n/* harmony import */ var _curve_linearClosed_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./curve/linearClosed.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linearClosed.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveLinearClosed\", function() { return _curve_linearClosed_js__WEBPACK_IMPORTED_MODULE_26__[\"default\"]; });\n\n/* harmony import */ var _curve_linear_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./curve/linear.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linear.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveLinear\", function() { return _curve_linear_js__WEBPACK_IMPORTED_MODULE_27__[\"default\"]; });\n\n/* harmony import */ var _curve_monotone_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./curve/monotone.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/monotone.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveMonotoneX\", function() { return _curve_monotone_js__WEBPACK_IMPORTED_MODULE_28__[\"monotoneX\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveMonotoneY\", function() { return _curve_monotone_js__WEBPACK_IMPORTED_MODULE_28__[\"monotoneY\"]; });\n\n/* harmony import */ var _curve_natural_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./curve/natural.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/natural.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveNatural\", function() { return _curve_natural_js__WEBPACK_IMPORTED_MODULE_29__[\"default\"]; });\n\n/* harmony import */ var _curve_step_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./curve/step.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/step.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveStep\", function() { return _curve_step_js__WEBPACK_IMPORTED_MODULE_30__[\"default\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveStepAfter\", function() { return _curve_step_js__WEBPACK_IMPORTED_MODULE_30__[\"stepAfter\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"curveStepBefore\", function() { return _curve_step_js__WEBPACK_IMPORTED_MODULE_30__[\"stepBefore\"]; });\n\n/* harmony import */ var _stack_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./stack.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/stack.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stack\", function() { return _stack_js__WEBPACK_IMPORTED_MODULE_31__[\"default\"]; });\n\n/* harmony import */ var _offset_expand_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./offset/expand.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/expand.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOffsetExpand\", function() { return _offset_expand_js__WEBPACK_IMPORTED_MODULE_32__[\"default\"]; });\n\n/* harmony import */ var _offset_diverging_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./offset/diverging.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/diverging.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOffsetDiverging\", function() { return _offset_diverging_js__WEBPACK_IMPORTED_MODULE_33__[\"default\"]; });\n\n/* harmony import */ var _offset_none_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./offset/none.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/none.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOffsetNone\", function() { return _offset_none_js__WEBPACK_IMPORTED_MODULE_34__[\"default\"]; });\n\n/* harmony import */ var _offset_silhouette_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./offset/silhouette.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/silhouette.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOffsetSilhouette\", function() { return _offset_silhouette_js__WEBPACK_IMPORTED_MODULE_35__[\"default\"]; });\n\n/* harmony import */ var _offset_wiggle_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./offset/wiggle.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/wiggle.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOffsetWiggle\", function() { return _offset_wiggle_js__WEBPACK_IMPORTED_MODULE_36__[\"default\"]; });\n\n/* harmony import */ var _order_appearance_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./order/appearance.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/appearance.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderAppearance\", function() { return _order_appearance_js__WEBPACK_IMPORTED_MODULE_37__[\"default\"]; });\n\n/* harmony import */ var _order_ascending_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./order/ascending.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/ascending.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderAscending\", function() { return _order_ascending_js__WEBPACK_IMPORTED_MODULE_38__[\"default\"]; });\n\n/* harmony import */ var _order_descending_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./order/descending.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/descending.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderDescending\", function() { return _order_descending_js__WEBPACK_IMPORTED_MODULE_39__[\"default\"]; });\n\n/* harmony import */ var _order_insideOut_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./order/insideOut.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/insideOut.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderInsideOut\", function() { return _order_insideOut_js__WEBPACK_IMPORTED_MODULE_40__[\"default\"]; });\n\n/* harmony import */ var _order_none_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./order/none.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/none.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderNone\", function() { return _order_none_js__WEBPACK_IMPORTED_MODULE_41__[\"default\"]; });\n\n/* harmony import */ var _order_reverse_js__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./order/reverse.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/reverse.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stackOrderReverse\", function() { return _order_reverse_js__WEBPACK_IMPORTED_MODULE_42__[\"default\"]; });\n\n\n\n\n\n // Note: radialArea is deprecated!\n // Note: radialLine is deprecated!\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/index.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/line.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/line.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var d3_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-path */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/index.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _curve_linear_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./curve/linear.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linear.js\");\n/* harmony import */ var _point_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./point.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/point.js\");\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var x = _point_js__WEBPACK_IMPORTED_MODULE_3__[\"x\"],\n      y = _point_js__WEBPACK_IMPORTED_MODULE_3__[\"y\"],\n      defined = Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(true),\n      context = null,\n      curve = _curve_linear_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n      output = null;\n\n  function line(data) {\n    var i,\n        n = data.length,\n        d,\n        defined0 = false,\n        buffer;\n\n    if (context == null) output = curve(buffer = Object(d3_path__WEBPACK_IMPORTED_MODULE_0__[\"path\"])());\n\n    for (i = 0; i <= n; ++i) {\n      if (!(i < n && defined(d = data[i], i, data)) === defined0) {\n        if (defined0 = !defined0) output.lineStart();\n        else output.lineEnd();\n      }\n      if (defined0) output.point(+x(d, i, data), +y(d, i, data));\n    }\n\n    if (buffer) return output = null, buffer + \"\" || null;\n  }\n\n  line.x = function(_) {\n    return arguments.length ? (x = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), line) : x;\n  };\n\n  line.y = function(_) {\n    return arguments.length ? (y = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), line) : y;\n  };\n\n  line.defined = function(_) {\n    return arguments.length ? (defined = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(!!_), line) : defined;\n  };\n\n  line.curve = function(_) {\n    return arguments.length ? (curve = _, context != null && (output = curve(context)), line) : curve;\n  };\n\n  line.context = function(_) {\n    return arguments.length ? (_ == null ? context = output = null : output = curve(context = _), line) : context;\n  };\n\n  return line;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/line.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/lineRadial.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/lineRadial.js ***!
  \********************************************************************************/
/*! exports provided: lineRadial, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"lineRadial\", function() { return lineRadial; });\n/* harmony import */ var _curve_radial_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./curve/radial.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/radial.js\");\n/* harmony import */ var _line_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./line.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/line.js\");\n\n\n\nfunction lineRadial(l) {\n  var c = l.curve;\n\n  l.angle = l.x, delete l.x;\n  l.radius = l.y, delete l.y;\n\n  l.curve = function(_) {\n    return arguments.length ? c(Object(_curve_radial_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(_)) : c()._curve;\n  };\n\n  return l;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  return lineRadial(Object(_line_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])().curve(_curve_radial_js__WEBPACK_IMPORTED_MODULE_0__[\"curveRadialLinear\"]));\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/lineRadial.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/link/index.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/link/index.js ***!
  \********************************************************************************/
/*! exports provided: linkHorizontal, linkVertical, linkRadial */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"linkHorizontal\", function() { return linkHorizontal; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"linkVertical\", function() { return linkVertical; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"linkRadial\", function() { return linkRadial; });\n/* harmony import */ var d3_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-path */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/index.js\");\n/* harmony import */ var _array_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../array.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/array.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constant.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _point_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../point.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/point.js\");\n/* harmony import */ var _pointRadial_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../pointRadial.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pointRadial.js\");\n\n\n\n\n\n\nfunction linkSource(d) {\n  return d.source;\n}\n\nfunction linkTarget(d) {\n  return d.target;\n}\n\nfunction link(curve) {\n  var source = linkSource,\n      target = linkTarget,\n      x = _point_js__WEBPACK_IMPORTED_MODULE_3__[\"x\"],\n      y = _point_js__WEBPACK_IMPORTED_MODULE_3__[\"y\"],\n      context = null;\n\n  function link() {\n    var buffer, argv = _array_js__WEBPACK_IMPORTED_MODULE_1__[\"slice\"].call(arguments), s = source.apply(this, argv), t = target.apply(this, argv);\n    if (!context) context = buffer = Object(d3_path__WEBPACK_IMPORTED_MODULE_0__[\"path\"])();\n    curve(context, +x.apply(this, (argv[0] = s, argv)), +y.apply(this, argv), +x.apply(this, (argv[0] = t, argv)), +y.apply(this, argv));\n    if (buffer) return context = null, buffer + \"\" || null;\n  }\n\n  link.source = function(_) {\n    return arguments.length ? (source = _, link) : source;\n  };\n\n  link.target = function(_) {\n    return arguments.length ? (target = _, link) : target;\n  };\n\n  link.x = function(_) {\n    return arguments.length ? (x = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(+_), link) : x;\n  };\n\n  link.y = function(_) {\n    return arguments.length ? (y = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(+_), link) : y;\n  };\n\n  link.context = function(_) {\n    return arguments.length ? ((context = _ == null ? null : _), link) : context;\n  };\n\n  return link;\n}\n\nfunction curveHorizontal(context, x0, y0, x1, y1) {\n  context.moveTo(x0, y0);\n  context.bezierCurveTo(x0 = (x0 + x1) / 2, y0, x0, y1, x1, y1);\n}\n\nfunction curveVertical(context, x0, y0, x1, y1) {\n  context.moveTo(x0, y0);\n  context.bezierCurveTo(x0, y0 = (y0 + y1) / 2, x1, y0, x1, y1);\n}\n\nfunction curveRadial(context, x0, y0, x1, y1) {\n  var p0 = Object(_pointRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(x0, y0),\n      p1 = Object(_pointRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(x0, y0 = (y0 + y1) / 2),\n      p2 = Object(_pointRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(x1, y0),\n      p3 = Object(_pointRadial_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(x1, y1);\n  context.moveTo(p0[0], p0[1]);\n  context.bezierCurveTo(p1[0], p1[1], p2[0], p2[1], p3[0], p3[1]);\n}\n\nfunction linkHorizontal() {\n  return link(curveHorizontal);\n}\n\nfunction linkVertical() {\n  return link(curveVertical);\n}\n\nfunction linkRadial() {\n  var l = link(curveRadial);\n  l.angle = l.x, delete l.x;\n  l.radius = l.y, delete l.y;\n  return l;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/link/index.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/math.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/math.js ***!
  \**************************************************************************/
/*! exports provided: abs, atan2, cos, max, min, sin, sqrt, epsilon, pi, halfPi, tau, acos, asin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"abs\", function() { return abs; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"atan2\", function() { return atan2; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cos\", function() { return cos; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"max\", function() { return max; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"min\", function() { return min; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sin\", function() { return sin; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sqrt\", function() { return sqrt; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"epsilon\", function() { return epsilon; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"pi\", function() { return pi; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"halfPi\", function() { return halfPi; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tau\", function() { return tau; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"acos\", function() { return acos; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"asin\", function() { return asin; });\nvar abs = Math.abs;\nvar atan2 = Math.atan2;\nvar cos = Math.cos;\nvar max = Math.max;\nvar min = Math.min;\nvar sin = Math.sin;\nvar sqrt = Math.sqrt;\n\nvar epsilon = 1e-12;\nvar pi = Math.PI;\nvar halfPi = pi / 2;\nvar tau = 2 * pi;\n\nfunction acos(x) {\n  return x > 1 ? 0 : x < -1 ? pi : Math.acos(x);\n}\n\nfunction asin(x) {\n  return x >= 1 ? halfPi : x <= -1 ? -halfPi : Math.asin(x);\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/math.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/noop.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/noop.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/noop.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/diverging.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/diverging.js ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series, order) {\n  if (!((n = series.length) > 0)) return;\n  for (var i, j = 0, d, dy, yp, yn, n, m = series[order[0]].length; j < m; ++j) {\n    for (yp = yn = 0, i = 0; i < n; ++i) {\n      if ((dy = (d = series[order[i]][j])[1] - d[0]) > 0) {\n        d[0] = yp, d[1] = yp += dy;\n      } else if (dy < 0) {\n        d[1] = yn, d[0] = yn += dy;\n      } else {\n        d[0] = 0, d[1] = dy;\n      }\n    }\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/diverging.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/expand.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/expand.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series, order) {\n  if (!((n = series.length) > 0)) return;\n  for (var i, n, j = 0, m = series[0].length, y; j < m; ++j) {\n    for (y = i = 0; i < n; ++i) y += series[i][j][1] || 0;\n    if (y) for (i = 0; i < n; ++i) series[i][j][1] /= y;\n  }\n  Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series, order);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/expand.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/none.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/none.js ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series, order) {\n  if (!((n = series.length) > 1)) return;\n  for (var i = 1, j, s0, s1 = series[order[0]], n, m = s1.length; i < n; ++i) {\n    s0 = s1, s1 = series[order[i]];\n    for (j = 0; j < m; ++j) {\n      s1[j][1] += s1[j][0] = isNaN(s0[j][1]) ? s0[j][0] : s0[j][1];\n    }\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/none.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/silhouette.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/silhouette.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series, order) {\n  if (!((n = series.length) > 0)) return;\n  for (var j = 0, s0 = series[order[0]], n, m = s0.length; j < m; ++j) {\n    for (var i = 0, y = 0; i < n; ++i) y += series[i][j][1] || 0;\n    s0[j][1] += s0[j][0] = -y / 2;\n  }\n  Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series, order);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/silhouette.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/wiggle.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/wiggle.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series, order) {\n  if (!((n = series.length) > 0) || !((m = (s0 = series[order[0]]).length) > 0)) return;\n  for (var y = 0, j = 1, s0, m, n; j < m; ++j) {\n    for (var i = 0, s1 = 0, s2 = 0; i < n; ++i) {\n      var si = series[order[i]],\n          sij0 = si[j][1] || 0,\n          sij1 = si[j - 1][1] || 0,\n          s3 = (sij0 - sij1) / 2;\n      for (var k = 0; k < i; ++k) {\n        var sk = series[order[k]],\n            skj0 = sk[j][1] || 0,\n            skj1 = sk[j - 1][1] || 0;\n        s3 += skj0 - skj1;\n      }\n      s1 += sij0, s2 += s3 * sij0;\n    }\n    s0[j - 1][1] += s0[j - 1][0] = y;\n    if (s1) y -= s2 / s1;\n  }\n  s0[j - 1][1] += s0[j - 1][0] = y;\n  Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series, order);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/wiggle.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/appearance.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/appearance.js ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  var peaks = series.map(peak);\n  return Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series).sort(function(a, b) { return peaks[a] - peaks[b]; });\n});\n\nfunction peak(series) {\n  var i = -1, j = 0, n = series.length, vi, vj = -Infinity;\n  while (++i < n) if ((vi = +series[i][1]) > vj) vj = vi, j = i;\n  return j;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/appearance.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/ascending.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/ascending.js ***!
  \*************************************************************************************/
/*! exports provided: default, sum */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"sum\", function() { return sum; });\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  var sums = series.map(sum);\n  return Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series).sort(function(a, b) { return sums[a] - sums[b]; });\n});\n\nfunction sum(series) {\n  var s = 0, i = -1, n = series.length, v;\n  while (++i < n) if (v = +series[i][1]) s += v;\n  return s;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/ascending.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/descending.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/descending.js ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ascending_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/ascending.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  return Object(_ascending_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series).reverse();\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/descending.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/insideOut.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/insideOut.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _appearance_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./appearance.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/appearance.js\");\n/* harmony import */ var _ascending_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ascending.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/ascending.js\");\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  var n = series.length,\n      i,\n      j,\n      sums = series.map(_ascending_js__WEBPACK_IMPORTED_MODULE_1__[\"sum\"]),\n      order = Object(_appearance_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series),\n      top = 0,\n      bottom = 0,\n      tops = [],\n      bottoms = [];\n\n  for (i = 0; i < n; ++i) {\n    j = order[i];\n    if (top < bottom) {\n      top += sums[j];\n      tops.push(j);\n    } else {\n      bottom += sums[j];\n      bottoms.push(j);\n    }\n  }\n\n  return bottoms.reverse().concat(tops);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/insideOut.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/none.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/none.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  var n = series.length, o = new Array(n);\n  while (--n >= 0) o[n] = n;\n  return o;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/none.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/reverse.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/reverse.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _none_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./none.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/none.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(series) {\n  return Object(_none_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(series).reverse();\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/reverse.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pie.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pie.js ***!
  \*************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _descending_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./descending.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/descending.js\");\n/* harmony import */ var _identity_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./identity.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/identity.js\");\n/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./math.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/math.js\");\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var value = _identity_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n      sortValues = _descending_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n      sort = null,\n      startAngle = Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(0),\n      endAngle = Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(_math_js__WEBPACK_IMPORTED_MODULE_3__[\"tau\"]),\n      padAngle = Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(0);\n\n  function pie(data) {\n    var i,\n        n = data.length,\n        j,\n        k,\n        sum = 0,\n        index = new Array(n),\n        arcs = new Array(n),\n        a0 = +startAngle.apply(this, arguments),\n        da = Math.min(_math_js__WEBPACK_IMPORTED_MODULE_3__[\"tau\"], Math.max(-_math_js__WEBPACK_IMPORTED_MODULE_3__[\"tau\"], endAngle.apply(this, arguments) - a0)),\n        a1,\n        p = Math.min(Math.abs(da) / n, padAngle.apply(this, arguments)),\n        pa = p * (da < 0 ? -1 : 1),\n        v;\n\n    for (i = 0; i < n; ++i) {\n      if ((v = arcs[index[i] = i] = +value(data[i], i, data)) > 0) {\n        sum += v;\n      }\n    }\n\n    // Optionally sort the arcs by previously-computed values or by data.\n    if (sortValues != null) index.sort(function(i, j) { return sortValues(arcs[i], arcs[j]); });\n    else if (sort != null) index.sort(function(i, j) { return sort(data[i], data[j]); });\n\n    // Compute the arcs! They are stored in the original data's order.\n    for (i = 0, k = sum ? (da - n * pa) / sum : 0; i < n; ++i, a0 = a1) {\n      j = index[i], v = arcs[j], a1 = a0 + (v > 0 ? v * k : 0) + pa, arcs[j] = {\n        data: data[j],\n        index: i,\n        value: v,\n        startAngle: a0,\n        endAngle: a1,\n        padAngle: p\n      };\n    }\n\n    return arcs;\n  }\n\n  pie.value = function(_) {\n    return arguments.length ? (value = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(+_), pie) : value;\n  };\n\n  pie.sortValues = function(_) {\n    return arguments.length ? (sortValues = _, sort = null, pie) : sortValues;\n  };\n\n  pie.sort = function(_) {\n    return arguments.length ? (sort = _, sortValues = null, pie) : sort;\n  };\n\n  pie.startAngle = function(_) {\n    return arguments.length ? (startAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(+_), pie) : startAngle;\n  };\n\n  pie.endAngle = function(_) {\n    return arguments.length ? (endAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(+_), pie) : endAngle;\n  };\n\n  pie.padAngle = function(_) {\n    return arguments.length ? (padAngle = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(+_), pie) : padAngle;\n  };\n\n  return pie;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pie.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/point.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/point.js ***!
  \***************************************************************************/
/*! exports provided: x, y */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"x\", function() { return x; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"y\", function() { return y; });\nfunction x(p) {\n  return p[0];\n}\n\nfunction y(p) {\n  return p[1];\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/point.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pointRadial.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pointRadial.js ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (function(x, y) {\n  return [(y = +y) * Math.cos(x -= Math.PI / 2), y * Math.sin(x)];\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pointRadial.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/stack.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/stack.js ***!
  \***************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _array_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./array.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/array.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js\");\n/* harmony import */ var _offset_none_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./offset/none.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/none.js\");\n/* harmony import */ var _order_none_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./order/none.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/none.js\");\n\n\n\n\n\nfunction stackValue(d, key) {\n  return d[key];\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var keys = Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])([]),\n      order = _order_none_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n      offset = _offset_none_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n      value = stackValue;\n\n  function stack(data) {\n    var kz = keys.apply(this, arguments),\n        i,\n        m = data.length,\n        n = kz.length,\n        sz = new Array(n),\n        oz;\n\n    for (i = 0; i < n; ++i) {\n      for (var ki = kz[i], si = sz[i] = new Array(m), j = 0, sij; j < m; ++j) {\n        si[j] = sij = [0, +value(data[j], ki, j, data)];\n        sij.data = data[j];\n      }\n      si.key = ki;\n    }\n\n    for (i = 0, oz = order(sz); i < n; ++i) {\n      sz[oz[i]].index = i;\n    }\n\n    offset(sz, oz);\n    return sz;\n  }\n\n  stack.keys = function(_) {\n    return arguments.length ? (keys = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(_array_js__WEBPACK_IMPORTED_MODULE_0__[\"slice\"].call(_)), stack) : keys;\n  };\n\n  stack.value = function(_) {\n    return arguments.length ? (value = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(+_), stack) : value;\n  };\n\n  stack.order = function(_) {\n    return arguments.length ? (order = _ == null ? _order_none_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"] : typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(_array_js__WEBPACK_IMPORTED_MODULE_0__[\"slice\"].call(_)), stack) : order;\n  };\n\n  stack.offset = function(_) {\n    return arguments.length ? (offset = _ == null ? _offset_none_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"] : _, stack) : offset;\n  };\n\n  return stack;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/stack.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol.js ***!
  \****************************************************************************/
/*! exports provided: symbols, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"symbols\", function() { return symbols; });\n/* harmony import */ var d3_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-path */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-path/src/index.js\");\n/* harmony import */ var _symbol_circle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./symbol/circle.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/circle.js\");\n/* harmony import */ var _symbol_cross_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./symbol/cross.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/cross.js\");\n/* harmony import */ var _symbol_diamond_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./symbol/diamond.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/diamond.js\");\n/* harmony import */ var _symbol_star_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./symbol/star.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/star.js\");\n/* harmony import */ var _symbol_square_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./symbol/square.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/square.js\");\n/* harmony import */ var _symbol_triangle_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./symbol/triangle.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/triangle.js\");\n/* harmony import */ var _symbol_wye_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./symbol/wye.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/wye.js\");\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./constant.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js\");\n\n\n\n\n\n\n\n\n\n\nvar symbols = [\n  _symbol_circle_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  _symbol_cross_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n  _symbol_diamond_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n  _symbol_square_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"],\n  _symbol_star_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"],\n  _symbol_triangle_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"],\n  _symbol_wye_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"]\n];\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var type = Object(_constant_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(_symbol_circle_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]),\n      size = Object(_constant_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(64),\n      context = null;\n\n  function symbol() {\n    var buffer;\n    if (!context) context = buffer = Object(d3_path__WEBPACK_IMPORTED_MODULE_0__[\"path\"])();\n    type.apply(this, arguments).draw(context, +size.apply(this, arguments));\n    if (buffer) return context = null, buffer + \"\" || null;\n  }\n\n  symbol.type = function(_) {\n    return arguments.length ? (type = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(_), symbol) : type;\n  };\n\n  symbol.size = function(_) {\n    return arguments.length ? (size = typeof _ === \"function\" ? _ : Object(_constant_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(+_), symbol) : size;\n  };\n\n  symbol.context = function(_) {\n    return arguments.length ? (context = _ == null ? null : _, symbol) : context;\n  };\n\n  return symbol;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/circle.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/circle.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../math.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/math.js\");\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var r = Math.sqrt(size / _math_js__WEBPACK_IMPORTED_MODULE_0__[\"pi\"]);\n    context.moveTo(r, 0);\n    context.arc(0, 0, r, 0, _math_js__WEBPACK_IMPORTED_MODULE_0__[\"tau\"]);\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/circle.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/cross.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/cross.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var r = Math.sqrt(size / 5) / 2;\n    context.moveTo(-3 * r, -r);\n    context.lineTo(-r, -r);\n    context.lineTo(-r, -3 * r);\n    context.lineTo(r, -3 * r);\n    context.lineTo(r, -r);\n    context.lineTo(3 * r, -r);\n    context.lineTo(3 * r, r);\n    context.lineTo(r, r);\n    context.lineTo(r, 3 * r);\n    context.lineTo(-r, 3 * r);\n    context.lineTo(-r, r);\n    context.lineTo(-3 * r, r);\n    context.closePath();\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/cross.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/diamond.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/diamond.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar tan30 = Math.sqrt(1 / 3),\n    tan30_2 = tan30 * 2;\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var y = Math.sqrt(size / tan30_2),\n        x = y * tan30;\n    context.moveTo(0, -y);\n    context.lineTo(x, 0);\n    context.lineTo(0, y);\n    context.lineTo(-x, 0);\n    context.closePath();\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/diamond.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/square.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/square.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var w = Math.sqrt(size),\n        x = -w / 2;\n    context.rect(x, x, w, w);\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/square.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/star.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/star.js ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../math.js */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/math.js\");\n\n\nvar ka = 0.89081309152928522810,\n    kr = Math.sin(_math_js__WEBPACK_IMPORTED_MODULE_0__[\"pi\"] / 10) / Math.sin(7 * _math_js__WEBPACK_IMPORTED_MODULE_0__[\"pi\"] / 10),\n    kx = Math.sin(_math_js__WEBPACK_IMPORTED_MODULE_0__[\"tau\"] / 10) * kr,\n    ky = -Math.cos(_math_js__WEBPACK_IMPORTED_MODULE_0__[\"tau\"] / 10) * kr;\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var r = Math.sqrt(size * ka),\n        x = kx * r,\n        y = ky * r;\n    context.moveTo(0, -r);\n    context.lineTo(x, y);\n    for (var i = 1; i < 5; ++i) {\n      var a = _math_js__WEBPACK_IMPORTED_MODULE_0__[\"tau\"] * i / 5,\n          c = Math.cos(a),\n          s = Math.sin(a);\n      context.lineTo(s * r, -c * r);\n      context.lineTo(c * x - s * y, s * x + c * y);\n    }\n    context.closePath();\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/star.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/triangle.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/triangle.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar sqrt3 = Math.sqrt(3);\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var y = -Math.sqrt(size / (sqrt3 * 3));\n    context.moveTo(0, y * 2);\n    context.lineTo(-sqrt3 * y, -y);\n    context.lineTo(sqrt3 * y, -y);\n    context.closePath();\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/triangle.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/wye.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/wye.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar c = -0.5,\n    s = Math.sqrt(3) / 2,\n    k = 1 / Math.sqrt(12),\n    a = (k / 2 + 1) * 3;\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  draw: function(context, size) {\n    var r = Math.sqrt(size / a),\n        x0 = r / 2,\n        y0 = r * k,\n        x1 = x0,\n        y1 = r * k + r,\n        x2 = -x1,\n        y2 = y1;\n    context.moveTo(x0, y0);\n    context.lineTo(x1, y1);\n    context.lineTo(x2, y2);\n    context.lineTo(c * x0 - s * y0, s * x0 + c * y0);\n    context.lineTo(c * x1 - s * y1, s * x1 + c * y1);\n    context.lineTo(c * x2 - s * y2, s * x2 + c * y2);\n    context.lineTo(c * x0 + s * y0, c * y0 - s * x0);\n    context.lineTo(c * x1 + s * y1, c * y1 - s * x1);\n    context.lineTo(c * x2 + s * y2, c * y2 - s * x2);\n    context.closePath();\n  }\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/wye.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/src/align.js":
/*!*****************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/src/align.js ***!
  \*****************************************************/
/*! exports provided: left, right, justify, center */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"left\", function() { return left; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"right\", function() { return right; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"justify\", function() { return justify; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"center\", function() { return center; });\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/index.js\");\n\n\nfunction targetDepth(d) {\n  return d.target.depth;\n}\n\nfunction left(node) {\n  return node.depth;\n}\n\nfunction right(node, n) {\n  return n - 1 - node.height;\n}\n\nfunction justify(node, n) {\n  return node.sourceLinks.length ? node.depth : n - 1;\n}\n\nfunction center(node) {\n  return node.targetLinks.length ? node.depth\n      : node.sourceLinks.length ? Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"min\"])(node.sourceLinks, targetDepth) - 1\n      : 0;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/src/align.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/src/constant.js":
/*!********************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/src/constant.js ***!
  \********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return constant; });\nfunction constant(x) {\n  return function() {\n    return x;\n  };\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/src/constant.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/src/sankey.js":
/*!******************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/src/sankey.js ***!
  \******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-array */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-array/src/index.js\");\n/* harmony import */ var d3_collection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! d3-collection */ \"./node_modules/d3-collection/src/index.js\");\n/* harmony import */ var _align__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./align */ \"./node_modules/@plotly/d3-sankey/src/align.js\");\n/* harmony import */ var _constant__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constant */ \"./node_modules/@plotly/d3-sankey/src/constant.js\");\n\n\n\n\n\nfunction ascendingSourceBreadth(a, b) {\n  return ascendingBreadth(a.source, b.source) || a.index - b.index;\n}\n\nfunction ascendingTargetBreadth(a, b) {\n  return ascendingBreadth(a.target, b.target) || a.index - b.index;\n}\n\nfunction ascendingBreadth(a, b) {\n  return a.y0 - b.y0;\n}\n\nfunction value(d) {\n  return d.value;\n}\n\nfunction nodeCenter(node) {\n  return (node.y0 + node.y1) / 2;\n}\n\nfunction weightedSource(link) {\n  return nodeCenter(link.source) * link.value;\n}\n\nfunction weightedTarget(link) {\n  return nodeCenter(link.target) * link.value;\n}\n\nfunction defaultId(d) {\n  return d.index;\n}\n\nfunction defaultNodes(graph) {\n  return graph.nodes;\n}\n\nfunction defaultLinks(graph) {\n  return graph.links;\n}\n\nfunction find(nodeById, id) {\n  var node = nodeById.get(id);\n  if (!node) throw new Error(\"missing: \" + id);\n  return node;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  var x0 = 0, y0 = 0, x1 = 1, y1 = 1, // extent\n      dx = 24, // nodeWidth\n      py = 8, // nodePadding\n      id = defaultId,\n      align = _align__WEBPACK_IMPORTED_MODULE_2__[\"justify\"],\n      nodes = defaultNodes,\n      links = defaultLinks,\n      iterations = 32,\n      maxPaddedSpace = 2 / 3; // Defined as a fraction of the total available space\n\n  function sankey() {\n    var graph = {nodes: nodes.apply(null, arguments), links: links.apply(null, arguments)};\n    computeNodeLinks(graph);\n    computeNodeValues(graph);\n    computeNodeDepths(graph);\n    computeNodeBreadths(graph, iterations);\n    computeLinkBreadths(graph);\n    return graph;\n  }\n\n  sankey.update = function(graph) {\n    computeLinkBreadths(graph);\n    return graph;\n  };\n\n  sankey.nodeId = function(_) {\n    return arguments.length ? (id = typeof _ === \"function\" ? _ : Object(_constant__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(_), sankey) : id;\n  };\n\n  sankey.nodeAlign = function(_) {\n    return arguments.length ? (align = typeof _ === \"function\" ? _ : Object(_constant__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(_), sankey) : align;\n  };\n\n  sankey.nodeWidth = function(_) {\n    return arguments.length ? (dx = +_, sankey) : dx;\n  };\n\n  sankey.nodePadding = function(_) {\n    return arguments.length ? (py = +_, sankey) : py;\n  };\n\n  sankey.nodes = function(_) {\n    return arguments.length ? (nodes = typeof _ === \"function\" ? _ : Object(_constant__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(_), sankey) : nodes;\n  };\n\n  sankey.links = function(_) {\n    return arguments.length ? (links = typeof _ === \"function\" ? _ : Object(_constant__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(_), sankey) : links;\n  };\n\n  sankey.size = function(_) {\n    return arguments.length ? (x0 = y0 = 0, x1 = +_[0], y1 = +_[1], sankey) : [x1 - x0, y1 - y0];\n  };\n\n  sankey.extent = function(_) {\n    return arguments.length ? (x0 = +_[0][0], x1 = +_[1][0], y0 = +_[0][1], y1 = +_[1][1], sankey) : [[x0, y0], [x1, y1]];\n  };\n\n  sankey.iterations = function(_) {\n    return arguments.length ? (iterations = +_, sankey) : iterations;\n  };\n\n  // Populate the sourceLinks and targetLinks for each node.\n  // Also, if the source and target are not objects, assume they are indices.\n  function computeNodeLinks(graph) {\n    graph.nodes.forEach(function(node, i) {\n      node.index = i;\n      node.sourceLinks = [];\n      node.targetLinks = [];\n    });\n\n    var nodeById = Object(d3_collection__WEBPACK_IMPORTED_MODULE_1__[\"map\"])(graph.nodes, id);\n    graph.links.forEach(function(link, i) {\n      link.index = i;\n      var source = link.source, target = link.target;\n      if (typeof source !== \"object\") source = link.source = find(nodeById, source);\n      if (typeof target !== \"object\") target = link.target = find(nodeById, target);\n      source.sourceLinks.push(link);\n      target.targetLinks.push(link);\n    });\n  }\n\n  // Compute the value (size) of each node by summing the associated links.\n  function computeNodeValues(graph) {\n    graph.nodes.forEach(function(node) {\n      node.value = Math.max(\n        Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"sum\"])(node.sourceLinks, value),\n        Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"sum\"])(node.targetLinks, value)\n      );\n    });\n  }\n\n  // Iteratively assign the depth (x-position) for each node.\n  // Nodes are assigned the maximum depth of incoming neighbors plus one;\n  // nodes with no incoming links are assigned depth zero, while\n  // nodes with no outgoing links are assigned the maximum depth.\n  function computeNodeDepths(graph) {\n    var nodes, next, x;\n\n    for (nodes = graph.nodes, next = [], x = 0; nodes.length; ++x, nodes = next, next = []) {\n      nodes.forEach(function(node) {\n        node.depth = x;\n        node.sourceLinks.forEach(function(link) {\n          if (next.indexOf(link.target) < 0) {\n            next.push(link.target);\n          }\n        });\n      });\n    }\n\n    for (nodes = graph.nodes, next = [], x = 0; nodes.length; ++x, nodes = next, next = []) {\n      nodes.forEach(function(node) {\n        node.height = x;\n        node.targetLinks.forEach(function(link) {\n          if (next.indexOf(link.source) < 0) {\n            next.push(link.source);\n          }\n        });\n      });\n    }\n\n    var kx = (x1 - x0 - dx) / (x - 1);\n    graph.nodes.forEach(function(node) {\n      node.x1 = (node.x0 = x0 + Math.max(0, Math.min(x - 1, Math.floor(align.call(null, node, x)))) * kx) + dx;\n    });\n  }\n\n  function computeNodeBreadths(graph) {\n    var columns = Object(d3_collection__WEBPACK_IMPORTED_MODULE_1__[\"nest\"])()\n        .key(function(d) { return d.x0; })\n        .sortKeys(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"ascending\"])\n        .entries(graph.nodes)\n        .map(function(d) { return d.values; });\n\n    //\n    initializeNodeBreadth();\n    resolveCollisions();\n    for (var alpha = 1, n = iterations; n > 0; --n) {\n      relaxRightToLeft(alpha *= 0.99);\n      resolveCollisions();\n      relaxLeftToRight(alpha);\n      resolveCollisions();\n    }\n\n    function initializeNodeBreadth() {\n      var L = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"max\"])(columns, function(nodes) {\n        return nodes.length;\n      });\n      var maxNodePadding = maxPaddedSpace * (y1 - y0) / (L - 1);\n      if(py > maxNodePadding) py = maxNodePadding;\n      var ky = Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"min\"])(columns, function(nodes) {\n        return (y1 - y0 - (nodes.length - 1) * py) / Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"sum\"])(nodes, value);\n      });\n\n      columns.forEach(function(nodes) {\n        nodes.forEach(function(node, i) {\n          node.y1 = (node.y0 = i) + node.value * ky;\n        });\n      });\n\n      graph.links.forEach(function(link) {\n        link.width = link.value * ky;\n      });\n    }\n\n    function relaxLeftToRight(alpha) {\n      columns.forEach(function(nodes) {\n        nodes.forEach(function(node) {\n          if (node.targetLinks.length) {\n            var dy = (Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"sum\"])(node.targetLinks, weightedSource) / Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"sum\"])(node.targetLinks, value) - nodeCenter(node)) * alpha;\n            node.y0 += dy, node.y1 += dy;\n          }\n        });\n      });\n    }\n\n    function relaxRightToLeft(alpha) {\n      columns.slice().reverse().forEach(function(nodes) {\n        nodes.forEach(function(node) {\n          if (node.sourceLinks.length) {\n            var dy = (Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"sum\"])(node.sourceLinks, weightedTarget) / Object(d3_array__WEBPACK_IMPORTED_MODULE_0__[\"sum\"])(node.sourceLinks, value) - nodeCenter(node)) * alpha;\n            node.y0 += dy, node.y1 += dy;\n          }\n        });\n      });\n    }\n\n    function resolveCollisions() {\n      columns.forEach(function(nodes) {\n        var node,\n            dy,\n            y = y0,\n            n = nodes.length,\n            i;\n\n        // Push any overlapping nodes down.\n        nodes.sort(ascendingBreadth);\n        for (i = 0; i < n; ++i) {\n          node = nodes[i];\n          dy = y - node.y0;\n          if (dy > 0) node.y0 += dy, node.y1 += dy;\n          y = node.y1 + py;\n        }\n\n        // If the bottommost node goes outside the bounds, push it back up.\n        dy = y - py - y1;\n        if (dy > 0) {\n          y = (node.y0 -= dy), node.y1 -= dy;\n\n          // Push any overlapping nodes back up.\n          for (i = n - 2; i >= 0; --i) {\n            node = nodes[i];\n            dy = node.y1 + py - y;\n            if (dy > 0) node.y0 -= dy, node.y1 -= dy;\n            y = node.y0;\n          }\n        }\n      });\n    }\n  }\n\n  function computeLinkBreadths(graph) {\n    graph.nodes.forEach(function(node) {\n      node.sourceLinks.sort(ascendingTargetBreadth);\n      node.targetLinks.sort(ascendingSourceBreadth);\n    });\n    graph.nodes.forEach(function(node) {\n      var y0 = node.y0, y1 = y0;\n      node.sourceLinks.forEach(function(link) {\n        link.y0 = y0 + link.width / 2, y0 += link.width;\n      });\n      node.targetLinks.forEach(function(link) {\n        link.y1 = y1 + link.width / 2, y1 += link.width;\n      });\n    });\n  }\n\n  return sankey;\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/src/sankey.js?");

/***/ }),

/***/ "./node_modules/@plotly/d3-sankey/src/sankeyLinkHorizontal.js":
/*!********************************************************************!*\
  !*** ./node_modules/@plotly/d3-sankey/src/sankeyLinkHorizontal.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var d3_shape__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-shape */ \"./node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/index.js\");\n\n\nfunction horizontalSource(d) {\n  return [d.source.x1, d.y0];\n}\n\nfunction horizontalTarget(d) {\n  return [d.target.x0, d.y1];\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (function() {\n  return Object(d3_shape__WEBPACK_IMPORTED_MODULE_0__[\"linkHorizontal\"])()\n      .source(horizontalSource)\n      .target(horizontalTarget);\n});\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/d3-sankey/src/sankeyLinkHorizontal.js?");

/***/ }),

/***/ "./node_modules/@plotly/point-cluster/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/@plotly/point-cluster/index.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = __webpack_require__(/*! ./quad */ \"./node_modules/@plotly/point-cluster/quad.js\")\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/point-cluster/index.js?");

/***/ }),

/***/ "./node_modules/@plotly/point-cluster/quad.js":
/*!****************************************************!*\
  !*** ./node_modules/@plotly/point-cluster/quad.js ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/**\n * @module  point-cluster/quad\n *\n * Bucket based quad tree clustering\n */\n\n\n\nconst search = __webpack_require__(/*! binary-search-bounds */ \"./node_modules/binary-search-bounds/search-bounds.js\")\nconst clamp = __webpack_require__(/*! clamp */ \"./node_modules/clamp/index.js\")\nconst rect = __webpack_require__(/*! parse-rect */ \"./node_modules/parse-rect/index.js\")\nconst getBounds = __webpack_require__(/*! array-bounds */ \"./node_modules/array-bounds/index.js\")\nconst pick = __webpack_require__(/*! pick-by-alias */ \"./node_modules/pick-by-alias/index.js\")\nconst defined = __webpack_require__(/*! defined */ \"./node_modules/defined/index.js\")\nconst flatten = __webpack_require__(/*! flatten-vertex-data */ \"./node_modules/flatten-vertex-data/index.js\")\nconst isObj = __webpack_require__(/*! is-obj */ \"./node_modules/is-obj/index.js\")\nconst dtype = __webpack_require__(/*! dtype */ \"./node_modules/dtype/index.js\")\nconst log2 = __webpack_require__(/*! math-log2 */ \"./node_modules/math-log2/index.js\")\n\nconst MAX_GROUP_ID = 1073741824\n\nmodule.exports = function cluster (srcPoints, options) {\n\tif (!options) options = {}\n\n\tsrcPoints = flatten(srcPoints, 'float64')\n\n\toptions = pick(options, {\n\t\tbounds: 'range bounds dataBox databox',\n\t\tmaxDepth: 'depth maxDepth maxdepth level maxLevel maxlevel levels',\n\t\tdtype: 'type dtype format out dst output destination'\n\t\t// sort: 'sortBy sortby sort',\n\t\t// pick: 'pick levelPoint',\n\t\t// nodeSize: 'node nodeSize minNodeSize minSize size'\n\t})\n\n\t// let nodeSize = defined(options.nodeSize, 1)\n\tlet maxDepth = defined(options.maxDepth, 255)\n\tlet bounds = defined(options.bounds, getBounds(srcPoints, 2))\n\tif (bounds[0] === bounds[2]) bounds[2]++\n\tif (bounds[1] === bounds[3]) bounds[3]++\n\n\tlet points = normalize(srcPoints, bounds)\n\n\t// init variables\n\tlet n = srcPoints.length >>> 1\n\tlet ids\n\tif (!options.dtype) options.dtype = 'array'\n\n\tif (typeof options.dtype === 'string') {\n\t\tids = new (dtype(options.dtype))(n)\n\t}\n\telse if (options.dtype) {\n\t\tids = options.dtype\n\t\tif (Array.isArray(ids)) ids.length = n\n\t}\n\tfor (let i = 0; i < n; ++i) {\n\t\tids[i] = i\n\t}\n\n\t// representative point indexes for levels\n\tlet levels = []\n\n\t// starting indexes of subranges in sub levels, levels.length * 4\n\tlet sublevels = []\n\n\t// unique group ids, sorted in z-curve fashion within levels by shifting bits\n\tlet groups = []\n\n\t// level offsets in `ids`\n\tlet offsets = []\n\n\n\t// sort points\n\tsort(0, 0, 1, ids, 0, 1)\n\n\n\t// return reordered ids with provided methods\n\t// save level offsets in output buffer\n\tlet offset = 0\n\tfor (let level = 0; level < levels.length; level++) {\n\t\tlet levelItems = levels[level]\n\t\tif (ids.set) ids.set(levelItems, offset)\n\t\telse {\n\t\t\tfor (let i = 0, l = levelItems.length; i < l; i++) {\n\t\t\t\tids[i + offset] = levelItems[i]\n\t\t\t}\n\t\t}\n\t\tlet nextOffset = offset + levels[level].length\n\t\toffsets[level] = [offset, nextOffset]\n\t\toffset = nextOffset\n\t}\n\n\tids.range = range\n\n\treturn ids\n\n\n\n\t// FIXME: it is possible to create one typed array heap and reuse that to avoid memory blow\n\tfunction sort (x, y, diam, ids, level, group) {\n\t\tif (!ids.length) return null\n\n\t\t// save first point as level representative\n\t\tlet levelItems = levels[level] || (levels[level] = [])\n\t\tlet levelGroups = groups[level] || (groups[level] = [])\n\t\tlet sublevel = sublevels[level] || (sublevels[level] = [])\n\t\tlet offset = levelItems.length\n\n\t\tlevel++\n\n\t\t// max depth reached - put all items into a first group\n\t\t// alternatively - if group id overflow - avoid proceeding\n\t\tif (level > maxDepth || group > MAX_GROUP_ID) {\n\t\t\tfor (let i = 0; i < ids.length; i++) {\n\t\t\t\tlevelItems.push(ids[i])\n\t\t\t\tlevelGroups.push(group)\n\t\t\t\tsublevel.push(null, null, null, null)\n\t\t\t}\n\n\t\t\treturn offset\n\t\t}\n\n\t\tlevelItems.push(ids[0])\n\t\tlevelGroups.push(group)\n\n\t\tif (ids.length <= 1) {\n\t\t\tsublevel.push(null, null, null, null)\n\t\t\treturn offset\n\t\t}\n\n\n\t\tlet d2 = diam * .5\n\t\tlet cx = x + d2, cy = y + d2\n\n\t\t// distribute points by 4 buckets\n\t\tlet lolo = [], lohi = [], hilo = [], hihi = []\n\n\t\tfor (let i = 1, l = ids.length; i < l; i++) {\n\t\t\tlet idx = ids[i],\n\t\t\t\tx = points[idx * 2],\n\t\t\t\ty = points[idx * 2 + 1]\n\t\t\tx < cx ? (y < cy ? lolo.push(idx) : lohi.push(idx)) : (y < cy ? hilo.push(idx) : hihi.push(idx))\n\t\t}\n\n\t\tgroup <<= 2\n\n\t\tsublevel.push(\n\t\t\tsort(x, y, d2, lolo, level, group),\n\t\t\tsort(x, cy, d2, lohi, level, group + 1),\n\t\t\tsort(cx, y, d2, hilo, level, group + 2),\n\t\t\tsort(cx, cy, d2, hihi, level, group + 3)\n\t\t)\n\n\t\treturn offset\n\t}\n\n\t// get all points within the passed range\n\tfunction range ( ...args ) {\n\t\tlet options\n\n\t\tif (isObj(args[args.length - 1])) {\n\t\t\tlet arg = args.pop()\n\n\t\t\t// detect if that was a rect object\n\t\t\tif (!args.length && (arg.x != null || arg.l != null || arg.left != null)) {\n\t\t\t\targs = [arg]\n\t\t\t\toptions = {}\n\t\t\t}\n\n\t\t\toptions = pick(arg, {\n\t\t\t\tlevel: 'level maxLevel',\n\t\t\t\td: 'd diam diameter r radius px pxSize pixel pixelSize maxD size minSize',\n\t\t\t\tlod: 'lod details ranges offsets'\n\t\t\t})\n\t\t}\n\t\telse {\n\t\t\toptions = {}\n\t\t}\n\n\t\tif (!args.length) args = bounds\n\n\t\tlet box = rect( ...args )\n\n\t\tlet [minX, minY, maxX, maxY] = [\n\t\t\tMath.min(box.x, box.x + box.width),\n\t\t\tMath.min(box.y, box.y + box.height),\n\t\t\tMath.max(box.x, box.x + box.width),\n\t\t\tMath.max(box.y, box.y + box.height)\n\t\t]\n\n\t\tlet [nminX, nminY, nmaxX, nmaxY] = normalize([minX, minY, maxX, maxY], bounds )\n\n\t\tlet maxLevel = defined(options.level, levels.length)\n\n\t\t// limit maxLevel by px size\n\t\tif (options.d != null) {\n\t\t\tlet d\n\t\t\tif (typeof options.d === 'number') d = [options.d, options.d]\n\t\t\telse if (options.d.length) d = options.d\n\n\t\t\tmaxLevel = Math.min(\n\t\t\t\tMath.max(\n\t\t\t\t\tMath.ceil(-log2(Math.abs(d[0]) / (bounds[2] - bounds[0]))),\n\t\t\t\t\tMath.ceil(-log2(Math.abs(d[1]) / (bounds[3] - bounds[1])))\n\t\t\t\t),\n\t\t\t\tmaxLevel\n\t\t\t)\n\t\t}\n\t\tmaxLevel = Math.min(maxLevel, levels.length)\n\n\t\t// return levels of details\n\t\tif (options.lod) {\n\t\t\treturn lod(nminX, nminY, nmaxX, nmaxY, maxLevel)\n\t\t}\n\n\n\n\t\t// do selection ids\n\t\tlet selection = []\n\n\t\t// FIXME: probably we can do LOD here beforehead\n\t\tselect( 0, 0, 1, 0, 0, 1)\n\n\t\tfunction select ( lox, loy, d, level, from, to ) {\n\t\t\tif (from === null || to === null) return\n\n\t\t\tlet hix = lox + d\n\t\t\tlet hiy = loy + d\n\n\t\t\t// if box does not intersect level - ignore\n\t\t\tif ( nminX > hix || nminY > hiy || nmaxX < lox || nmaxY < loy ) return\n\t\t\tif ( level >= maxLevel ) return\n\t\t\tif ( from === to ) return\n\n\t\t\t// if points fall into box range - take it\n\t\t\tlet levelItems = levels[level]\n\n\t\t\tif (to === undefined) to = levelItems.length\n\n\t\t\tfor (let i = from; i < to; i++) {\n\t\t\t\tlet id = levelItems[i]\n\n\t\t\t\tlet px = srcPoints[ id * 2 ]\n\t\t\t\tlet py = srcPoints[ id * 2 + 1 ]\n\n\t\t\t\tif ( px >= minX && px <= maxX && py >= minY && py <= maxY ) {selection.push(id)\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// for every subsection do select\n\t\t\tlet offsets = sublevels[ level ]\n\t\t\tlet off0 = offsets[ from * 4 + 0 ]\n\t\t\tlet off1 = offsets[ from * 4 + 1 ]\n\t\t\tlet off2 = offsets[ from * 4 + 2 ]\n\t\t\tlet off3 = offsets[ from * 4 + 3 ]\n\t\t\tlet end = nextOffset(offsets, from + 1)\n\n\t\t\tlet d2 = d * .5\n\t\t\tlet nextLevel = level + 1\n\t\t\tselect( lox, loy, d2, nextLevel, off0, off1 || off2 || off3 || end)\n\t\t\tselect( lox, loy + d2, d2, nextLevel, off1, off2 || off3 || end)\n\t\t\tselect( lox + d2, loy, d2, nextLevel, off2, off3 || end)\n\t\t\tselect( lox + d2, loy + d2, d2, nextLevel, off3, end)\n\t\t}\n\n\t\tfunction nextOffset(offsets, from) {\n\t\t\tlet offset = null, i = 0\n\t\t\twhile(offset === null) {\n\t\t\t\toffset = offsets[ from * 4 + i ]\n\t\t\t\ti++\n\t\t\t\tif (i > offsets.length) return null\n\t\t\t}\n\t\t\treturn offset\n\t\t}\n\n\t\treturn selection\n\t}\n\n\t// get range offsets within levels to render lods appropriate for zoom level\n\t// TODO: it is possible to store minSize of a point to optimize neede level calc\n\tfunction lod (lox, loy, hix, hiy, maxLevel) {\n\t\tlet ranges = []\n\n\t\tfor (let level = 0; level < maxLevel; level++) {\n\t\t\tlet levelGroups = groups[level]\n\t\t\tlet from = offsets[level][0]\n\n\t\t\tlet levelGroupStart = group(lox, loy, level)\n\t\t\tlet levelGroupEnd = group(hix, hiy, level)\n\n\t\t\t// FIXME: utilize sublevels to speed up search range here\n\t\t\tlet startOffset = search.ge(levelGroups, levelGroupStart)\n\t\t\tlet endOffset = search.gt(levelGroups, levelGroupEnd, startOffset, levelGroups.length - 1)\n\n\t\t\tranges[level] = [startOffset + from, endOffset + from]\n\t\t}\n\n\t\treturn ranges\n\t}\n\n\t// get group id closest to the x,y coordinate, corresponding to a level\n\tfunction group (x, y, level) {\n\t\tlet group = 1\n\n\t\tlet cx = .5, cy = .5\n\t\tlet diam = .5\n\n\t\tfor (let i = 0; i < level; i++) {\n\t\t\tgroup <<= 2\n\n\t\t\tgroup += x < cx ? (y < cy ? 0 : 1) : (y < cy ? 2 : 3)\n\n\t\t\tdiam *= .5\n\n\t\t\tcx += x < cx ? -diam : diam\n\t\t\tcy += y < cy ? -diam : diam\n\t\t}\n\n\t\treturn group\n\t}\n}\n\n\n// normalize points by bounds\nfunction normalize (pts, bounds) {\n\tlet [lox, loy, hix, hiy] = bounds\n\tlet scaleX = 1.0 / (hix - lox)\n\tlet scaleY = 1.0 / (hiy - loy)\n\tlet result = new Array(pts.length)\n\n\tfor (let i = 0, n = pts.length / 2; i < n; i++) {\n\t\tresult[2*i] = clamp((pts[2*i] - lox) * scaleX, 0, 1)\n\t\tresult[2*i+1] = clamp((pts[2*i+1] - loy) * scaleY, 0, 1)\n\t}\n\n\treturn result\n}\n\n\n//# sourceURL=webpack:///./node_modules/@plotly/point-cluster/quad.js?");

/***/ }),

/***/ "./node_modules/@turf/area/dist/es/index.js":
/*!**************************************************!*\
  !*** ./node_modules/@turf/area/dist/es/index.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return area; });\n/* harmony import */ var _turf_meta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @turf/meta */ \"./node_modules/@turf/meta/dist/es/index.js\");\n\n// Note: change RADIUS => earthRadius\nvar RADIUS = 6378137;\n/**\n * Takes one or more features and returns their area in square meters.\n *\n * @name area\n * @param {GeoJSON} geojson input GeoJSON feature(s)\n * @returns {number} area in square meters\n * @example\n * var polygon = turf.polygon([[[125, -15], [113, -22], [154, -27], [144, -15], [125, -15]]]);\n *\n * var area = turf.area(polygon);\n *\n * //addToMap\n * var addToMap = [polygon]\n * polygon.properties.area = area\n */\nfunction area(geojson) {\n    return Object(_turf_meta__WEBPACK_IMPORTED_MODULE_0__[\"geomReduce\"])(geojson, function (value, geom) {\n        return value + calculateArea(geom);\n    }, 0);\n}\n/**\n * Calculate Area\n *\n * @private\n * @param {Geometry} geom GeoJSON Geometries\n * @returns {number} area\n */\nfunction calculateArea(geom) {\n    var total = 0;\n    var i;\n    switch (geom.type) {\n        case \"Polygon\":\n            return polygonArea(geom.coordinates);\n        case \"MultiPolygon\":\n            for (i = 0; i < geom.coordinates.length; i++) {\n                total += polygonArea(geom.coordinates[i]);\n            }\n            return total;\n        case \"Point\":\n        case \"MultiPoint\":\n        case \"LineString\":\n        case \"MultiLineString\":\n            return 0;\n    }\n    return 0;\n}\nfunction polygonArea(coords) {\n    var total = 0;\n    if (coords && coords.length > 0) {\n        total += Math.abs(ringArea(coords[0]));\n        for (var i = 1; i < coords.length; i++) {\n            total -= Math.abs(ringArea(coords[i]));\n        }\n    }\n    return total;\n}\n/**\n * @private\n * Calculate the approximate area of the polygon were it projected onto the earth.\n * Note that this area will be positive if ring is oriented clockwise, otherwise it will be negative.\n *\n * Reference:\n * Robert. G. Chamberlain and William H. Duquette, \"Some Algorithms for Polygons on a Sphere\",\n * JPL Publication 07-03, Jet Propulsion\n * Laboratory, Pasadena, CA, June 2007 https://trs.jpl.nasa.gov/handle/2014/40409\n *\n * @param {Array<Array<number>>} coords Ring Coordinates\n * @returns {number} The approximate signed geodesic area of the polygon in square meters.\n */\nfunction ringArea(coords) {\n    var p1;\n    var p2;\n    var p3;\n    var lowerIndex;\n    var middleIndex;\n    var upperIndex;\n    var i;\n    var total = 0;\n    var coordsLength = coords.length;\n    if (coordsLength > 2) {\n        for (i = 0; i < coordsLength; i++) {\n            if (i === coordsLength - 2) {\n                // i = N-2\n                lowerIndex = coordsLength - 2;\n                middleIndex = coordsLength - 1;\n                upperIndex = 0;\n            }\n            else if (i === coordsLength - 1) {\n                // i = N-1\n                lowerIndex = coordsLength - 1;\n                middleIndex = 0;\n                upperIndex = 1;\n            }\n            else {\n                // i = 0 to N-3\n                lowerIndex = i;\n                middleIndex = i + 1;\n                upperIndex = i + 2;\n            }\n            p1 = coords[lowerIndex];\n            p2 = coords[middleIndex];\n            p3 = coords[upperIndex];\n            total += (rad(p3[0]) - rad(p1[0])) * Math.sin(rad(p2[1]));\n        }\n        total = (total * RADIUS * RADIUS) / 2;\n    }\n    return total;\n}\nfunction rad(num) {\n    return (num * Math.PI) / 180;\n}\n\n\n//# sourceURL=webpack:///./node_modules/@turf/area/dist/es/index.js?");

/***/ }),

/***/ "./node_modules/@turf/bbox/dist/es/index.js":
/*!**************************************************!*\
  !*** ./node_modules/@turf/bbox/dist/es/index.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _turf_meta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @turf/meta */ \"./node_modules/@turf/meta/dist/es/index.js\");\n\n/**\n * Takes a set of features, calculates the bbox of all input features, and returns a bounding box.\n *\n * @name bbox\n * @param {GeoJSON} geojson any GeoJSON object\n * @returns {BBox} bbox extent in [minX, minY, maxX, maxY] order\n * @example\n * var line = turf.lineString([[-74, 40], [-78, 42], [-82, 35]]);\n * var bbox = turf.bbox(line);\n * var bboxPolygon = turf.bboxPolygon(bbox);\n *\n * //addToMap\n * var addToMap = [line, bboxPolygon]\n */\nfunction bbox(geojson) {\n    var result = [Infinity, Infinity, -Infinity, -Infinity];\n    Object(_turf_meta__WEBPACK_IMPORTED_MODULE_0__[\"coordEach\"])(geojson, function (coord) {\n        if (result[0] > coord[0]) {\n            result[0] = coord[0];\n        }\n        if (result[1] > coord[1]) {\n            result[1] = coord[1];\n        }\n        if (result[2] < coord[0]) {\n            result[2] = coord[0];\n        }\n        if (result[3] < coord[1]) {\n            result[3] = coord[1];\n        }\n    });\n    return result;\n}\nbbox[\"default\"] = bbox;\n/* harmony default export */ __webpack_exports__[\"default\"] = (bbox);\n\n\n//# sourceURL=webpack:///./node_modules/@turf/bbox/dist/es/index.js?");

/***/ }),

/***/ "./node_modules/@turf/centroid/dist/es/index.js":
/*!******************************************************!*\
  !*** ./node_modules/@turf/centroid/dist/es/index.js ***!
  \******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _turf_meta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @turf/meta */ \"./node_modules/@turf/meta/dist/es/index.js\");\n/* harmony import */ var _turf_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @turf/helpers */ \"./node_modules/@turf/helpers/dist/es/index.js\");\n\n\n/**\n * Takes one or more features and calculates the centroid using the mean of all vertices.\n * This lessens the effect of small islands and artifacts when calculating the centroid of a set of polygons.\n *\n * @name centroid\n * @param {GeoJSON} geojson GeoJSON to be centered\n * @param {Object} [options={}] Optional Parameters\n * @param {Object} [options.properties={}] an Object that is used as the {@link Feature}'s properties\n * @returns {Feature<Point>} the centroid of the input features\n * @example\n * var polygon = turf.polygon([[[-81, 41], [-88, 36], [-84, 31], [-80, 33], [-77, 39], [-81, 41]]]);\n *\n * var centroid = turf.centroid(polygon);\n *\n * //addToMap\n * var addToMap = [polygon, centroid]\n */\nfunction centroid(geojson, options) {\n    if (options === void 0) { options = {}; }\n    var xSum = 0;\n    var ySum = 0;\n    var len = 0;\n    Object(_turf_meta__WEBPACK_IMPORTED_MODULE_0__[\"coordEach\"])(geojson, function (coord) {\n        xSum += coord[0];\n        ySum += coord[1];\n        len++;\n    }, true);\n    return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_1__[\"point\"])([xSum / len, ySum / len], options.properties);\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (centroid);\n\n\n//# sourceURL=webpack:///./node_modules/@turf/centroid/dist/es/index.js?");

/***/ }),

/***/ "./node_modules/@turf/helpers/dist/es/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/@turf/helpers/dist/es/index.js ***!
  \*****************************************************/
/*! exports provided: earthRadius, factors, unitsFactors, areaFactors, feature, geometry, point, points, polygon, polygons, lineString, lineStrings, featureCollection, multiLineString, multiPoint, multiPolygon, geometryCollection, round, radiansToLength, lengthToRadians, lengthToDegrees, bearingToAzimuth, radiansToDegrees, degreesToRadians, convertLength, convertArea, isNumber, isObject, validateBBox, validateId */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"earthRadius\", function() { return earthRadius; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"factors\", function() { return factors; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"unitsFactors\", function() { return unitsFactors; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"areaFactors\", function() { return areaFactors; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"feature\", function() { return feature; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"geometry\", function() { return geometry; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"point\", function() { return point; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"points\", function() { return points; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"polygon\", function() { return polygon; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"polygons\", function() { return polygons; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"lineString\", function() { return lineString; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"lineStrings\", function() { return lineStrings; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"featureCollection\", function() { return featureCollection; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"multiLineString\", function() { return multiLineString; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"multiPoint\", function() { return multiPoint; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"multiPolygon\", function() { return multiPolygon; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"geometryCollection\", function() { return geometryCollection; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"round\", function() { return round; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"radiansToLength\", function() { return radiansToLength; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"lengthToRadians\", function() { return lengthToRadians; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"lengthToDegrees\", function() { return lengthToDegrees; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"bearingToAzimuth\", function() { return bearingToAzimuth; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"radiansToDegrees\", function() { return radiansToDegrees; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"degreesToRadians\", function() { return degreesToRadians; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"convertLength\", function() { return convertLength; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"convertArea\", function() { return convertArea; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isNumber\", function() { return isNumber; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isObject\", function() { return isObject; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"validateBBox\", function() { return validateBBox; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"validateId\", function() { return validateId; });\n/**\n * @module helpers\n */\n/**\n * Earth Radius used with the Harvesine formula and approximates using a spherical (non-ellipsoid) Earth.\n *\n * @memberof helpers\n * @type {number}\n */\nvar earthRadius = 6371008.8;\n/**\n * Unit of measurement factors using a spherical (non-ellipsoid) earth radius.\n *\n * @memberof helpers\n * @type {Object}\n */\nvar factors = {\n    centimeters: earthRadius * 100,\n    centimetres: earthRadius * 100,\n    degrees: earthRadius / 111325,\n    feet: earthRadius * 3.28084,\n    inches: earthRadius * 39.37,\n    kilometers: earthRadius / 1000,\n    kilometres: earthRadius / 1000,\n    meters: earthRadius,\n    metres: earthRadius,\n    miles: earthRadius / 1609.344,\n    millimeters: earthRadius * 1000,\n    millimetres: earthRadius * 1000,\n    nauticalmiles: earthRadius / 1852,\n    radians: 1,\n    yards: earthRadius / 1.0936,\n};\n/**\n * Units of measurement factors based on 1 meter.\n *\n * @memberof helpers\n * @type {Object}\n */\nvar unitsFactors = {\n    centimeters: 100,\n    centimetres: 100,\n    degrees: 1 / 111325,\n    feet: 3.28084,\n    inches: 39.37,\n    kilometers: 1 / 1000,\n    kilometres: 1 / 1000,\n    meters: 1,\n    metres: 1,\n    miles: 1 / 1609.344,\n    millimeters: 1000,\n    millimetres: 1000,\n    nauticalmiles: 1 / 1852,\n    radians: 1 / earthRadius,\n    yards: 1 / 1.0936,\n};\n/**\n * Area of measurement factors based on 1 square meter.\n *\n * @memberof helpers\n * @type {Object}\n */\nvar areaFactors = {\n    acres: 0.000247105,\n    centimeters: 10000,\n    centimetres: 10000,\n    feet: 10.763910417,\n    hectares: 0.0001,\n    inches: 1550.003100006,\n    kilometers: 0.000001,\n    kilometres: 0.000001,\n    meters: 1,\n    metres: 1,\n    miles: 3.86e-7,\n    millimeters: 1000000,\n    millimetres: 1000000,\n    yards: 1.195990046,\n};\n/**\n * Wraps a GeoJSON {@link Geometry} in a GeoJSON {@link Feature}.\n *\n * @name feature\n * @param {Geometry} geometry input geometry\n * @param {Object} [properties={}] an Object of key-value pairs to add as properties\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature\n * @param {string|number} [options.id] Identifier associated with the Feature\n * @returns {Feature} a GeoJSON Feature\n * @example\n * var geometry = {\n *   \"type\": \"Point\",\n *   \"coordinates\": [110, 50]\n * };\n *\n * var feature = turf.feature(geometry);\n *\n * //=feature\n */\nfunction feature(geom, properties, options) {\n    if (options === void 0) { options = {}; }\n    var feat = { type: \"Feature\" };\n    if (options.id === 0 || options.id) {\n        feat.id = options.id;\n    }\n    if (options.bbox) {\n        feat.bbox = options.bbox;\n    }\n    feat.properties = properties || {};\n    feat.geometry = geom;\n    return feat;\n}\n/**\n * Creates a GeoJSON {@link Geometry} from a Geometry string type & coordinates.\n * For GeometryCollection type use `helpers.geometryCollection`\n *\n * @name geometry\n * @param {string} type Geometry Type\n * @param {Array<any>} coordinates Coordinates\n * @param {Object} [options={}] Optional Parameters\n * @returns {Geometry} a GeoJSON Geometry\n * @example\n * var type = \"Point\";\n * var coordinates = [110, 50];\n * var geometry = turf.geometry(type, coordinates);\n * // => geometry\n */\nfunction geometry(type, coordinates, _options) {\n    if (_options === void 0) { _options = {}; }\n    switch (type) {\n        case \"Point\":\n            return point(coordinates).geometry;\n        case \"LineString\":\n            return lineString(coordinates).geometry;\n        case \"Polygon\":\n            return polygon(coordinates).geometry;\n        case \"MultiPoint\":\n            return multiPoint(coordinates).geometry;\n        case \"MultiLineString\":\n            return multiLineString(coordinates).geometry;\n        case \"MultiPolygon\":\n            return multiPolygon(coordinates).geometry;\n        default:\n            throw new Error(type + \" is invalid\");\n    }\n}\n/**\n * Creates a {@link Point} {@link Feature} from a Position.\n *\n * @name point\n * @param {Array<number>} coordinates longitude, latitude position (each in decimal degrees)\n * @param {Object} [properties={}] an Object of key-value pairs to add as properties\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature\n * @param {string|number} [options.id] Identifier associated with the Feature\n * @returns {Feature<Point>} a Point feature\n * @example\n * var point = turf.point([-75.343, 39.984]);\n *\n * //=point\n */\nfunction point(coordinates, properties, options) {\n    if (options === void 0) { options = {}; }\n    if (!coordinates) {\n        throw new Error(\"coordinates is required\");\n    }\n    if (!Array.isArray(coordinates)) {\n        throw new Error(\"coordinates must be an Array\");\n    }\n    if (coordinates.length < 2) {\n        throw new Error(\"coordinates must be at least 2 numbers long\");\n    }\n    if (!isNumber(coordinates[0]) || !isNumber(coordinates[1])) {\n        throw new Error(\"coordinates must contain numbers\");\n    }\n    var geom = {\n        type: \"Point\",\n        coordinates: coordinates,\n    };\n    return feature(geom, properties, options);\n}\n/**\n * Creates a {@link Point} {@link FeatureCollection} from an Array of Point coordinates.\n *\n * @name points\n * @param {Array<Array<number>>} coordinates an array of Points\n * @param {Object} [properties={}] Translate these properties to each Feature\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north]\n * associated with the FeatureCollection\n * @param {string|number} [options.id] Identifier associated with the FeatureCollection\n * @returns {FeatureCollection<Point>} Point Feature\n * @example\n * var points = turf.points([\n *   [-75, 39],\n *   [-80, 45],\n *   [-78, 50]\n * ]);\n *\n * //=points\n */\nfunction points(coordinates, properties, options) {\n    if (options === void 0) { options = {}; }\n    return featureCollection(coordinates.map(function (coords) {\n        return point(coords, properties);\n    }), options);\n}\n/**\n * Creates a {@link Polygon} {@link Feature} from an Array of LinearRings.\n *\n * @name polygon\n * @param {Array<Array<Array<number>>>} coordinates an array of LinearRings\n * @param {Object} [properties={}] an Object of key-value pairs to add as properties\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature\n * @param {string|number} [options.id] Identifier associated with the Feature\n * @returns {Feature<Polygon>} Polygon Feature\n * @example\n * var polygon = turf.polygon([[[-5, 52], [-4, 56], [-2, 51], [-7, 54], [-5, 52]]], { name: 'poly1' });\n *\n * //=polygon\n */\nfunction polygon(coordinates, properties, options) {\n    if (options === void 0) { options = {}; }\n    for (var _i = 0, coordinates_1 = coordinates; _i < coordinates_1.length; _i++) {\n        var ring = coordinates_1[_i];\n        if (ring.length < 4) {\n            throw new Error(\"Each LinearRing of a Polygon must have 4 or more Positions.\");\n        }\n        for (var j = 0; j < ring[ring.length - 1].length; j++) {\n            // Check if first point of Polygon contains two numbers\n            if (ring[ring.length - 1][j] !== ring[0][j]) {\n                throw new Error(\"First and last Position are not equivalent.\");\n            }\n        }\n    }\n    var geom = {\n        type: \"Polygon\",\n        coordinates: coordinates,\n    };\n    return feature(geom, properties, options);\n}\n/**\n * Creates a {@link Polygon} {@link FeatureCollection} from an Array of Polygon coordinates.\n *\n * @name polygons\n * @param {Array<Array<Array<Array<number>>>>} coordinates an array of Polygon coordinates\n * @param {Object} [properties={}] an Object of key-value pairs to add as properties\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature\n * @param {string|number} [options.id] Identifier associated with the FeatureCollection\n * @returns {FeatureCollection<Polygon>} Polygon FeatureCollection\n * @example\n * var polygons = turf.polygons([\n *   [[[-5, 52], [-4, 56], [-2, 51], [-7, 54], [-5, 52]]],\n *   [[[-15, 42], [-14, 46], [-12, 41], [-17, 44], [-15, 42]]],\n * ]);\n *\n * //=polygons\n */\nfunction polygons(coordinates, properties, options) {\n    if (options === void 0) { options = {}; }\n    return featureCollection(coordinates.map(function (coords) {\n        return polygon(coords, properties);\n    }), options);\n}\n/**\n * Creates a {@link LineString} {@link Feature} from an Array of Positions.\n *\n * @name lineString\n * @param {Array<Array<number>>} coordinates an array of Positions\n * @param {Object} [properties={}] an Object of key-value pairs to add as properties\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature\n * @param {string|number} [options.id] Identifier associated with the Feature\n * @returns {Feature<LineString>} LineString Feature\n * @example\n * var linestring1 = turf.lineString([[-24, 63], [-23, 60], [-25, 65], [-20, 69]], {name: 'line 1'});\n * var linestring2 = turf.lineString([[-14, 43], [-13, 40], [-15, 45], [-10, 49]], {name: 'line 2'});\n *\n * //=linestring1\n * //=linestring2\n */\nfunction lineString(coordinates, properties, options) {\n    if (options === void 0) { options = {}; }\n    if (coordinates.length < 2) {\n        throw new Error(\"coordinates must be an array of two or more positions\");\n    }\n    var geom = {\n        type: \"LineString\",\n        coordinates: coordinates,\n    };\n    return feature(geom, properties, options);\n}\n/**\n * Creates a {@link LineString} {@link FeatureCollection} from an Array of LineString coordinates.\n *\n * @name lineStrings\n * @param {Array<Array<Array<number>>>} coordinates an array of LinearRings\n * @param {Object} [properties={}] an Object of key-value pairs to add as properties\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north]\n * associated with the FeatureCollection\n * @param {string|number} [options.id] Identifier associated with the FeatureCollection\n * @returns {FeatureCollection<LineString>} LineString FeatureCollection\n * @example\n * var linestrings = turf.lineStrings([\n *   [[-24, 63], [-23, 60], [-25, 65], [-20, 69]],\n *   [[-14, 43], [-13, 40], [-15, 45], [-10, 49]]\n * ]);\n *\n * //=linestrings\n */\nfunction lineStrings(coordinates, properties, options) {\n    if (options === void 0) { options = {}; }\n    return featureCollection(coordinates.map(function (coords) {\n        return lineString(coords, properties);\n    }), options);\n}\n/**\n * Takes one or more {@link Feature|Features} and creates a {@link FeatureCollection}.\n *\n * @name featureCollection\n * @param {Feature[]} features input features\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature\n * @param {string|number} [options.id] Identifier associated with the Feature\n * @returns {FeatureCollection} FeatureCollection of Features\n * @example\n * var locationA = turf.point([-75.343, 39.984], {name: 'Location A'});\n * var locationB = turf.point([-75.833, 39.284], {name: 'Location B'});\n * var locationC = turf.point([-75.534, 39.123], {name: 'Location C'});\n *\n * var collection = turf.featureCollection([\n *   locationA,\n *   locationB,\n *   locationC\n * ]);\n *\n * //=collection\n */\nfunction featureCollection(features, options) {\n    if (options === void 0) { options = {}; }\n    var fc = { type: \"FeatureCollection\" };\n    if (options.id) {\n        fc.id = options.id;\n    }\n    if (options.bbox) {\n        fc.bbox = options.bbox;\n    }\n    fc.features = features;\n    return fc;\n}\n/**\n * Creates a {@link Feature<MultiLineString>} based on a\n * coordinate array. Properties can be added optionally.\n *\n * @name multiLineString\n * @param {Array<Array<Array<number>>>} coordinates an array of LineStrings\n * @param {Object} [properties={}] an Object of key-value pairs to add as properties\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature\n * @param {string|number} [options.id] Identifier associated with the Feature\n * @returns {Feature<MultiLineString>} a MultiLineString feature\n * @throws {Error} if no coordinates are passed\n * @example\n * var multiLine = turf.multiLineString([[[0,0],[10,10]]]);\n *\n * //=multiLine\n */\nfunction multiLineString(coordinates, properties, options) {\n    if (options === void 0) { options = {}; }\n    var geom = {\n        type: \"MultiLineString\",\n        coordinates: coordinates,\n    };\n    return feature(geom, properties, options);\n}\n/**\n * Creates a {@link Feature<MultiPoint>} based on a\n * coordinate array. Properties can be added optionally.\n *\n * @name multiPoint\n * @param {Array<Array<number>>} coordinates an array of Positions\n * @param {Object} [properties={}] an Object of key-value pairs to add as properties\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature\n * @param {string|number} [options.id] Identifier associated with the Feature\n * @returns {Feature<MultiPoint>} a MultiPoint feature\n * @throws {Error} if no coordinates are passed\n * @example\n * var multiPt = turf.multiPoint([[0,0],[10,10]]);\n *\n * //=multiPt\n */\nfunction multiPoint(coordinates, properties, options) {\n    if (options === void 0) { options = {}; }\n    var geom = {\n        type: \"MultiPoint\",\n        coordinates: coordinates,\n    };\n    return feature(geom, properties, options);\n}\n/**\n * Creates a {@link Feature<MultiPolygon>} based on a\n * coordinate array. Properties can be added optionally.\n *\n * @name multiPolygon\n * @param {Array<Array<Array<Array<number>>>>} coordinates an array of Polygons\n * @param {Object} [properties={}] an Object of key-value pairs to add as properties\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature\n * @param {string|number} [options.id] Identifier associated with the Feature\n * @returns {Feature<MultiPolygon>} a multipolygon feature\n * @throws {Error} if no coordinates are passed\n * @example\n * var multiPoly = turf.multiPolygon([[[[0,0],[0,10],[10,10],[10,0],[0,0]]]]);\n *\n * //=multiPoly\n *\n */\nfunction multiPolygon(coordinates, properties, options) {\n    if (options === void 0) { options = {}; }\n    var geom = {\n        type: \"MultiPolygon\",\n        coordinates: coordinates,\n    };\n    return feature(geom, properties, options);\n}\n/**\n * Creates a {@link Feature<GeometryCollection>} based on a\n * coordinate array. Properties can be added optionally.\n *\n * @name geometryCollection\n * @param {Array<Geometry>} geometries an array of GeoJSON Geometries\n * @param {Object} [properties={}] an Object of key-value pairs to add as properties\n * @param {Object} [options={}] Optional Parameters\n * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature\n * @param {string|number} [options.id] Identifier associated with the Feature\n * @returns {Feature<GeometryCollection>} a GeoJSON GeometryCollection Feature\n * @example\n * var pt = turf.geometry(\"Point\", [100, 0]);\n * var line = turf.geometry(\"LineString\", [[101, 0], [102, 1]]);\n * var collection = turf.geometryCollection([pt, line]);\n *\n * // => collection\n */\nfunction geometryCollection(geometries, properties, options) {\n    if (options === void 0) { options = {}; }\n    var geom = {\n        type: \"GeometryCollection\",\n        geometries: geometries,\n    };\n    return feature(geom, properties, options);\n}\n/**\n * Round number to precision\n *\n * @param {number} num Number\n * @param {number} [precision=0] Precision\n * @returns {number} rounded number\n * @example\n * turf.round(120.4321)\n * //=120\n *\n * turf.round(120.4321, 2)\n * //=120.43\n */\nfunction round(num, precision) {\n    if (precision === void 0) { precision = 0; }\n    if (precision && !(precision >= 0)) {\n        throw new Error(\"precision must be a positive number\");\n    }\n    var multiplier = Math.pow(10, precision || 0);\n    return Math.round(num * multiplier) / multiplier;\n}\n/**\n * Convert a distance measurement (assuming a spherical Earth) from radians to a more friendly unit.\n * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet\n *\n * @name radiansToLength\n * @param {number} radians in radians across the sphere\n * @param {string} [units=\"kilometers\"] can be degrees, radians, miles, inches, yards, metres,\n * meters, kilometres, kilometers.\n * @returns {number} distance\n */\nfunction radiansToLength(radians, units) {\n    if (units === void 0) { units = \"kilometers\"; }\n    var factor = factors[units];\n    if (!factor) {\n        throw new Error(units + \" units is invalid\");\n    }\n    return radians * factor;\n}\n/**\n * Convert a distance measurement (assuming a spherical Earth) from a real-world unit into radians\n * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet\n *\n * @name lengthToRadians\n * @param {number} distance in real units\n * @param {string} [units=\"kilometers\"] can be degrees, radians, miles, inches, yards, metres,\n * meters, kilometres, kilometers.\n * @returns {number} radians\n */\nfunction lengthToRadians(distance, units) {\n    if (units === void 0) { units = \"kilometers\"; }\n    var factor = factors[units];\n    if (!factor) {\n        throw new Error(units + \" units is invalid\");\n    }\n    return distance / factor;\n}\n/**\n * Convert a distance measurement (assuming a spherical Earth) from a real-world unit into degrees\n * Valid units: miles, nauticalmiles, inches, yards, meters, metres, centimeters, kilometres, feet\n *\n * @name lengthToDegrees\n * @param {number} distance in real units\n * @param {string} [units=\"kilometers\"] can be degrees, radians, miles, inches, yards, metres,\n * meters, kilometres, kilometers.\n * @returns {number} degrees\n */\nfunction lengthToDegrees(distance, units) {\n    return radiansToDegrees(lengthToRadians(distance, units));\n}\n/**\n * Converts any bearing angle from the north line direction (positive clockwise)\n * and returns an angle between 0-360 degrees (positive clockwise), 0 being the north line\n *\n * @name bearingToAzimuth\n * @param {number} bearing angle, between -180 and +180 degrees\n * @returns {number} angle between 0 and 360 degrees\n */\nfunction bearingToAzimuth(bearing) {\n    var angle = bearing % 360;\n    if (angle < 0) {\n        angle += 360;\n    }\n    return angle;\n}\n/**\n * Converts an angle in radians to degrees\n *\n * @name radiansToDegrees\n * @param {number} radians angle in radians\n * @returns {number} degrees between 0 and 360 degrees\n */\nfunction radiansToDegrees(radians) {\n    var degrees = radians % (2 * Math.PI);\n    return (degrees * 180) / Math.PI;\n}\n/**\n * Converts an angle in degrees to radians\n *\n * @name degreesToRadians\n * @param {number} degrees angle between 0 and 360 degrees\n * @returns {number} angle in radians\n */\nfunction degreesToRadians(degrees) {\n    var radians = degrees % 360;\n    return (radians * Math.PI) / 180;\n}\n/**\n * Converts a length to the requested unit.\n * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet\n *\n * @param {number} length to be converted\n * @param {Units} [originalUnit=\"kilometers\"] of the length\n * @param {Units} [finalUnit=\"kilometers\"] returned unit\n * @returns {number} the converted length\n */\nfunction convertLength(length, originalUnit, finalUnit) {\n    if (originalUnit === void 0) { originalUnit = \"kilometers\"; }\n    if (finalUnit === void 0) { finalUnit = \"kilometers\"; }\n    if (!(length >= 0)) {\n        throw new Error(\"length must be a positive number\");\n    }\n    return radiansToLength(lengthToRadians(length, originalUnit), finalUnit);\n}\n/**\n * Converts a area to the requested unit.\n * Valid units: kilometers, kilometres, meters, metres, centimetres, millimeters, acres, miles, yards, feet, inches, hectares\n * @param {number} area to be converted\n * @param {Units} [originalUnit=\"meters\"] of the distance\n * @param {Units} [finalUnit=\"kilometers\"] returned unit\n * @returns {number} the converted area\n */\nfunction convertArea(area, originalUnit, finalUnit) {\n    if (originalUnit === void 0) { originalUnit = \"meters\"; }\n    if (finalUnit === void 0) { finalUnit = \"kilometers\"; }\n    if (!(area >= 0)) {\n        throw new Error(\"area must be a positive number\");\n    }\n    var startFactor = areaFactors[originalUnit];\n    if (!startFactor) {\n        throw new Error(\"invalid original units\");\n    }\n    var finalFactor = areaFactors[finalUnit];\n    if (!finalFactor) {\n        throw new Error(\"invalid final units\");\n    }\n    return (area / startFactor) * finalFactor;\n}\n/**\n * isNumber\n *\n * @param {*} num Number to validate\n * @returns {boolean} true/false\n * @example\n * turf.isNumber(123)\n * //=true\n * turf.isNumber('foo')\n * //=false\n */\nfunction isNumber(num) {\n    return !isNaN(num) && num !== null && !Array.isArray(num);\n}\n/**\n * isObject\n *\n * @param {*} input variable to validate\n * @returns {boolean} true/false\n * @example\n * turf.isObject({elevation: 10})\n * //=true\n * turf.isObject('foo')\n * //=false\n */\nfunction isObject(input) {\n    return !!input && input.constructor === Object;\n}\n/**\n * Validate BBox\n *\n * @private\n * @param {Array<number>} bbox BBox to validate\n * @returns {void}\n * @throws Error if BBox is not valid\n * @example\n * validateBBox([-180, -40, 110, 50])\n * //=OK\n * validateBBox([-180, -40])\n * //=Error\n * validateBBox('Foo')\n * //=Error\n * validateBBox(5)\n * //=Error\n * validateBBox(null)\n * //=Error\n * validateBBox(undefined)\n * //=Error\n */\nfunction validateBBox(bbox) {\n    if (!bbox) {\n        throw new Error(\"bbox is required\");\n    }\n    if (!Array.isArray(bbox)) {\n        throw new Error(\"bbox must be an Array\");\n    }\n    if (bbox.length !== 4 && bbox.length !== 6) {\n        throw new Error(\"bbox must be an Array of 4 or 6 numbers\");\n    }\n    bbox.forEach(function (num) {\n        if (!isNumber(num)) {\n            throw new Error(\"bbox must only contain numbers\");\n        }\n    });\n}\n/**\n * Validate Id\n *\n * @private\n * @param {string|number} id Id to validate\n * @returns {void}\n * @throws Error if Id is not valid\n * @example\n * validateId([-180, -40, 110, 50])\n * //=Error\n * validateId([-180, -40])\n * //=Error\n * validateId('Foo')\n * //=OK\n * validateId(5)\n * //=OK\n * validateId(null)\n * //=Error\n * validateId(undefined)\n * //=Error\n */\nfunction validateId(id) {\n    if (!id) {\n        throw new Error(\"id is required\");\n    }\n    if ([\"string\", \"number\"].indexOf(typeof id) === -1) {\n        throw new Error(\"id must be a number or a string\");\n    }\n}\n\n\n//# sourceURL=webpack:///./node_modules/@turf/helpers/dist/es/index.js?");

/***/ }),

/***/ "./node_modules/@turf/meta/dist/es/index.js":
/*!**************************************************!*\
  !*** ./node_modules/@turf/meta/dist/es/index.js ***!
  \**************************************************/
/*! exports provided: coordEach, coordReduce, propEach, propReduce, featureEach, featureReduce, coordAll, geomEach, geomReduce, flattenEach, flattenReduce, segmentEach, segmentReduce, lineEach, lineReduce, findSegment, findPoint */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"coordEach\", function() { return coordEach; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"coordReduce\", function() { return coordReduce; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"propEach\", function() { return propEach; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"propReduce\", function() { return propReduce; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"featureEach\", function() { return featureEach; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"featureReduce\", function() { return featureReduce; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"coordAll\", function() { return coordAll; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"geomEach\", function() { return geomEach; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"geomReduce\", function() { return geomReduce; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"flattenEach\", function() { return flattenEach; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"flattenReduce\", function() { return flattenReduce; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"segmentEach\", function() { return segmentEach; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"segmentReduce\", function() { return segmentReduce; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"lineEach\", function() { return lineEach; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"lineReduce\", function() { return lineReduce; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"findSegment\", function() { return findSegment; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"findPoint\", function() { return findPoint; });\n/* harmony import */ var _turf_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @turf/helpers */ \"./node_modules/@turf/helpers/dist/es/index.js\");\n\n\n/**\n * Callback for coordEach\n *\n * @callback coordEachCallback\n * @param {Array<number>} currentCoord The current coordinate being processed.\n * @param {number} coordIndex The current index of the coordinate being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.\n * @param {number} geometryIndex The current index of the Geometry being processed.\n */\n\n/**\n * Iterate over coordinates in any GeoJSON object, similar to Array.forEach()\n *\n * @name coordEach\n * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object\n * @param {Function} callback a method that takes (currentCoord, coordIndex, featureIndex, multiFeatureIndex)\n * @param {boolean} [excludeWrapCoord=false] whether or not to include the final coordinate of LinearRings that wraps the ring in its iteration.\n * @returns {void}\n * @example\n * var features = turf.featureCollection([\n *   turf.point([26, 37], {\"foo\": \"bar\"}),\n *   turf.point([36, 53], {\"hello\": \"world\"})\n * ]);\n *\n * turf.coordEach(features, function (currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {\n *   //=currentCoord\n *   //=coordIndex\n *   //=featureIndex\n *   //=multiFeatureIndex\n *   //=geometryIndex\n * });\n */\nfunction coordEach(geojson, callback, excludeWrapCoord) {\n  // Handles null Geometry -- Skips this GeoJSON\n  if (geojson === null) return;\n  var j,\n    k,\n    l,\n    geometry,\n    stopG,\n    coords,\n    geometryMaybeCollection,\n    wrapShrink = 0,\n    coordIndex = 0,\n    isGeometryCollection,\n    type = geojson.type,\n    isFeatureCollection = type === \"FeatureCollection\",\n    isFeature = type === \"Feature\",\n    stop = isFeatureCollection ? geojson.features.length : 1;\n\n  // This logic may look a little weird. The reason why it is that way\n  // is because it's trying to be fast. GeoJSON supports multiple kinds\n  // of objects at its root: FeatureCollection, Features, Geometries.\n  // This function has the responsibility of handling all of them, and that\n  // means that some of the `for` loops you see below actually just don't apply\n  // to certain inputs. For instance, if you give this just a\n  // Point geometry, then both loops are short-circuited and all we do\n  // is gradually rename the input until it's called 'geometry'.\n  //\n  // This also aims to allocate as few resources as possible: just a\n  // few numbers and booleans, rather than any temporary arrays as would\n  // be required with the normalization approach.\n  for (var featureIndex = 0; featureIndex < stop; featureIndex++) {\n    geometryMaybeCollection = isFeatureCollection\n      ? geojson.features[featureIndex].geometry\n      : isFeature\n      ? geojson.geometry\n      : geojson;\n    isGeometryCollection = geometryMaybeCollection\n      ? geometryMaybeCollection.type === \"GeometryCollection\"\n      : false;\n    stopG = isGeometryCollection\n      ? geometryMaybeCollection.geometries.length\n      : 1;\n\n    for (var geomIndex = 0; geomIndex < stopG; geomIndex++) {\n      var multiFeatureIndex = 0;\n      var geometryIndex = 0;\n      geometry = isGeometryCollection\n        ? geometryMaybeCollection.geometries[geomIndex]\n        : geometryMaybeCollection;\n\n      // Handles null Geometry -- Skips this geometry\n      if (geometry === null) continue;\n      coords = geometry.coordinates;\n      var geomType = geometry.type;\n\n      wrapShrink =\n        excludeWrapCoord &&\n        (geomType === \"Polygon\" || geomType === \"MultiPolygon\")\n          ? 1\n          : 0;\n\n      switch (geomType) {\n        case null:\n          break;\n        case \"Point\":\n          if (\n            callback(\n              coords,\n              coordIndex,\n              featureIndex,\n              multiFeatureIndex,\n              geometryIndex\n            ) === false\n          )\n            return false;\n          coordIndex++;\n          multiFeatureIndex++;\n          break;\n        case \"LineString\":\n        case \"MultiPoint\":\n          for (j = 0; j < coords.length; j++) {\n            if (\n              callback(\n                coords[j],\n                coordIndex,\n                featureIndex,\n                multiFeatureIndex,\n                geometryIndex\n              ) === false\n            )\n              return false;\n            coordIndex++;\n            if (geomType === \"MultiPoint\") multiFeatureIndex++;\n          }\n          if (geomType === \"LineString\") multiFeatureIndex++;\n          break;\n        case \"Polygon\":\n        case \"MultiLineString\":\n          for (j = 0; j < coords.length; j++) {\n            for (k = 0; k < coords[j].length - wrapShrink; k++) {\n              if (\n                callback(\n                  coords[j][k],\n                  coordIndex,\n                  featureIndex,\n                  multiFeatureIndex,\n                  geometryIndex\n                ) === false\n              )\n                return false;\n              coordIndex++;\n            }\n            if (geomType === \"MultiLineString\") multiFeatureIndex++;\n            if (geomType === \"Polygon\") geometryIndex++;\n          }\n          if (geomType === \"Polygon\") multiFeatureIndex++;\n          break;\n        case \"MultiPolygon\":\n          for (j = 0; j < coords.length; j++) {\n            geometryIndex = 0;\n            for (k = 0; k < coords[j].length; k++) {\n              for (l = 0; l < coords[j][k].length - wrapShrink; l++) {\n                if (\n                  callback(\n                    coords[j][k][l],\n                    coordIndex,\n                    featureIndex,\n                    multiFeatureIndex,\n                    geometryIndex\n                  ) === false\n                )\n                  return false;\n                coordIndex++;\n              }\n              geometryIndex++;\n            }\n            multiFeatureIndex++;\n          }\n          break;\n        case \"GeometryCollection\":\n          for (j = 0; j < geometry.geometries.length; j++)\n            if (\n              coordEach(geometry.geometries[j], callback, excludeWrapCoord) ===\n              false\n            )\n              return false;\n          break;\n        default:\n          throw new Error(\"Unknown Geometry Type\");\n      }\n    }\n  }\n}\n\n/**\n * Callback for coordReduce\n *\n * The first time the callback function is called, the values provided as arguments depend\n * on whether the reduce method has an initialValue argument.\n *\n * If an initialValue is provided to the reduce method:\n *  - The previousValue argument is initialValue.\n *  - The currentValue argument is the value of the first element present in the array.\n *\n * If an initialValue is not provided:\n *  - The previousValue argument is the value of the first element present in the array.\n *  - The currentValue argument is the value of the second element present in the array.\n *\n * @callback coordReduceCallback\n * @param {*} previousValue The accumulated value previously returned in the last invocation\n * of the callback, or initialValue, if supplied.\n * @param {Array<number>} currentCoord The current coordinate being processed.\n * @param {number} coordIndex The current index of the coordinate being processed.\n * Starts at index 0, if an initialValue is provided, and at index 1 otherwise.\n * @param {number} featureIndex The current index of the Feature being processed.\n * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.\n * @param {number} geometryIndex The current index of the Geometry being processed.\n */\n\n/**\n * Reduce coordinates in any GeoJSON object, similar to Array.reduce()\n *\n * @name coordReduce\n * @param {FeatureCollection|Geometry|Feature} geojson any GeoJSON object\n * @param {Function} callback a method that takes (previousValue, currentCoord, coordIndex)\n * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.\n * @param {boolean} [excludeWrapCoord=false] whether or not to include the final coordinate of LinearRings that wraps the ring in its iteration.\n * @returns {*} The value that results from the reduction.\n * @example\n * var features = turf.featureCollection([\n *   turf.point([26, 37], {\"foo\": \"bar\"}),\n *   turf.point([36, 53], {\"hello\": \"world\"})\n * ]);\n *\n * turf.coordReduce(features, function (previousValue, currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {\n *   //=previousValue\n *   //=currentCoord\n *   //=coordIndex\n *   //=featureIndex\n *   //=multiFeatureIndex\n *   //=geometryIndex\n *   return currentCoord;\n * });\n */\nfunction coordReduce(geojson, callback, initialValue, excludeWrapCoord) {\n  var previousValue = initialValue;\n  coordEach(\n    geojson,\n    function (\n      currentCoord,\n      coordIndex,\n      featureIndex,\n      multiFeatureIndex,\n      geometryIndex\n    ) {\n      if (coordIndex === 0 && initialValue === undefined)\n        previousValue = currentCoord;\n      else\n        previousValue = callback(\n          previousValue,\n          currentCoord,\n          coordIndex,\n          featureIndex,\n          multiFeatureIndex,\n          geometryIndex\n        );\n    },\n    excludeWrapCoord\n  );\n  return previousValue;\n}\n\n/**\n * Callback for propEach\n *\n * @callback propEachCallback\n * @param {Object} currentProperties The current Properties being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n */\n\n/**\n * Iterate over properties in any GeoJSON object, similar to Array.forEach()\n *\n * @name propEach\n * @param {FeatureCollection|Feature} geojson any GeoJSON object\n * @param {Function} callback a method that takes (currentProperties, featureIndex)\n * @returns {void}\n * @example\n * var features = turf.featureCollection([\n *     turf.point([26, 37], {foo: 'bar'}),\n *     turf.point([36, 53], {hello: 'world'})\n * ]);\n *\n * turf.propEach(features, function (currentProperties, featureIndex) {\n *   //=currentProperties\n *   //=featureIndex\n * });\n */\nfunction propEach(geojson, callback) {\n  var i;\n  switch (geojson.type) {\n    case \"FeatureCollection\":\n      for (i = 0; i < geojson.features.length; i++) {\n        if (callback(geojson.features[i].properties, i) === false) break;\n      }\n      break;\n    case \"Feature\":\n      callback(geojson.properties, 0);\n      break;\n  }\n}\n\n/**\n * Callback for propReduce\n *\n * The first time the callback function is called, the values provided as arguments depend\n * on whether the reduce method has an initialValue argument.\n *\n * If an initialValue is provided to the reduce method:\n *  - The previousValue argument is initialValue.\n *  - The currentValue argument is the value of the first element present in the array.\n *\n * If an initialValue is not provided:\n *  - The previousValue argument is the value of the first element present in the array.\n *  - The currentValue argument is the value of the second element present in the array.\n *\n * @callback propReduceCallback\n * @param {*} previousValue The accumulated value previously returned in the last invocation\n * of the callback, or initialValue, if supplied.\n * @param {*} currentProperties The current Properties being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n */\n\n/**\n * Reduce properties in any GeoJSON object into a single value,\n * similar to how Array.reduce works. However, in this case we lazily run\n * the reduction, so an array of all properties is unnecessary.\n *\n * @name propReduce\n * @param {FeatureCollection|Feature} geojson any GeoJSON object\n * @param {Function} callback a method that takes (previousValue, currentProperties, featureIndex)\n * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.\n * @returns {*} The value that results from the reduction.\n * @example\n * var features = turf.featureCollection([\n *     turf.point([26, 37], {foo: 'bar'}),\n *     turf.point([36, 53], {hello: 'world'})\n * ]);\n *\n * turf.propReduce(features, function (previousValue, currentProperties, featureIndex) {\n *   //=previousValue\n *   //=currentProperties\n *   //=featureIndex\n *   return currentProperties\n * });\n */\nfunction propReduce(geojson, callback, initialValue) {\n  var previousValue = initialValue;\n  propEach(geojson, function (currentProperties, featureIndex) {\n    if (featureIndex === 0 && initialValue === undefined)\n      previousValue = currentProperties;\n    else\n      previousValue = callback(previousValue, currentProperties, featureIndex);\n  });\n  return previousValue;\n}\n\n/**\n * Callback for featureEach\n *\n * @callback featureEachCallback\n * @param {Feature<any>} currentFeature The current Feature being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n */\n\n/**\n * Iterate over features in any GeoJSON object, similar to\n * Array.forEach.\n *\n * @name featureEach\n * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object\n * @param {Function} callback a method that takes (currentFeature, featureIndex)\n * @returns {void}\n * @example\n * var features = turf.featureCollection([\n *   turf.point([26, 37], {foo: 'bar'}),\n *   turf.point([36, 53], {hello: 'world'})\n * ]);\n *\n * turf.featureEach(features, function (currentFeature, featureIndex) {\n *   //=currentFeature\n *   //=featureIndex\n * });\n */\nfunction featureEach(geojson, callback) {\n  if (geojson.type === \"Feature\") {\n    callback(geojson, 0);\n  } else if (geojson.type === \"FeatureCollection\") {\n    for (var i = 0; i < geojson.features.length; i++) {\n      if (callback(geojson.features[i], i) === false) break;\n    }\n  }\n}\n\n/**\n * Callback for featureReduce\n *\n * The first time the callback function is called, the values provided as arguments depend\n * on whether the reduce method has an initialValue argument.\n *\n * If an initialValue is provided to the reduce method:\n *  - The previousValue argument is initialValue.\n *  - The currentValue argument is the value of the first element present in the array.\n *\n * If an initialValue is not provided:\n *  - The previousValue argument is the value of the first element present in the array.\n *  - The currentValue argument is the value of the second element present in the array.\n *\n * @callback featureReduceCallback\n * @param {*} previousValue The accumulated value previously returned in the last invocation\n * of the callback, or initialValue, if supplied.\n * @param {Feature} currentFeature The current Feature being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n */\n\n/**\n * Reduce features in any GeoJSON object, similar to Array.reduce().\n *\n * @name featureReduce\n * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object\n * @param {Function} callback a method that takes (previousValue, currentFeature, featureIndex)\n * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.\n * @returns {*} The value that results from the reduction.\n * @example\n * var features = turf.featureCollection([\n *   turf.point([26, 37], {\"foo\": \"bar\"}),\n *   turf.point([36, 53], {\"hello\": \"world\"})\n * ]);\n *\n * turf.featureReduce(features, function (previousValue, currentFeature, featureIndex) {\n *   //=previousValue\n *   //=currentFeature\n *   //=featureIndex\n *   return currentFeature\n * });\n */\nfunction featureReduce(geojson, callback, initialValue) {\n  var previousValue = initialValue;\n  featureEach(geojson, function (currentFeature, featureIndex) {\n    if (featureIndex === 0 && initialValue === undefined)\n      previousValue = currentFeature;\n    else previousValue = callback(previousValue, currentFeature, featureIndex);\n  });\n  return previousValue;\n}\n\n/**\n * Get all coordinates from any GeoJSON object.\n *\n * @name coordAll\n * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object\n * @returns {Array<Array<number>>} coordinate position array\n * @example\n * var features = turf.featureCollection([\n *   turf.point([26, 37], {foo: 'bar'}),\n *   turf.point([36, 53], {hello: 'world'})\n * ]);\n *\n * var coords = turf.coordAll(features);\n * //= [[26, 37], [36, 53]]\n */\nfunction coordAll(geojson) {\n  var coords = [];\n  coordEach(geojson, function (coord) {\n    coords.push(coord);\n  });\n  return coords;\n}\n\n/**\n * Callback for geomEach\n *\n * @callback geomEachCallback\n * @param {Geometry} currentGeometry The current Geometry being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n * @param {Object} featureProperties The current Feature Properties being processed.\n * @param {Array<number>} featureBBox The current Feature BBox being processed.\n * @param {number|string} featureId The current Feature Id being processed.\n */\n\n/**\n * Iterate over each geometry in any GeoJSON object, similar to Array.forEach()\n *\n * @name geomEach\n * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object\n * @param {Function} callback a method that takes (currentGeometry, featureIndex, featureProperties, featureBBox, featureId)\n * @returns {void}\n * @example\n * var features = turf.featureCollection([\n *     turf.point([26, 37], {foo: 'bar'}),\n *     turf.point([36, 53], {hello: 'world'})\n * ]);\n *\n * turf.geomEach(features, function (currentGeometry, featureIndex, featureProperties, featureBBox, featureId) {\n *   //=currentGeometry\n *   //=featureIndex\n *   //=featureProperties\n *   //=featureBBox\n *   //=featureId\n * });\n */\nfunction geomEach(geojson, callback) {\n  var i,\n    j,\n    g,\n    geometry,\n    stopG,\n    geometryMaybeCollection,\n    isGeometryCollection,\n    featureProperties,\n    featureBBox,\n    featureId,\n    featureIndex = 0,\n    isFeatureCollection = geojson.type === \"FeatureCollection\",\n    isFeature = geojson.type === \"Feature\",\n    stop = isFeatureCollection ? geojson.features.length : 1;\n\n  // This logic may look a little weird. The reason why it is that way\n  // is because it's trying to be fast. GeoJSON supports multiple kinds\n  // of objects at its root: FeatureCollection, Features, Geometries.\n  // This function has the responsibility of handling all of them, and that\n  // means that some of the `for` loops you see below actually just don't apply\n  // to certain inputs. For instance, if you give this just a\n  // Point geometry, then both loops are short-circuited and all we do\n  // is gradually rename the input until it's called 'geometry'.\n  //\n  // This also aims to allocate as few resources as possible: just a\n  // few numbers and booleans, rather than any temporary arrays as would\n  // be required with the normalization approach.\n  for (i = 0; i < stop; i++) {\n    geometryMaybeCollection = isFeatureCollection\n      ? geojson.features[i].geometry\n      : isFeature\n      ? geojson.geometry\n      : geojson;\n    featureProperties = isFeatureCollection\n      ? geojson.features[i].properties\n      : isFeature\n      ? geojson.properties\n      : {};\n    featureBBox = isFeatureCollection\n      ? geojson.features[i].bbox\n      : isFeature\n      ? geojson.bbox\n      : undefined;\n    featureId = isFeatureCollection\n      ? geojson.features[i].id\n      : isFeature\n      ? geojson.id\n      : undefined;\n    isGeometryCollection = geometryMaybeCollection\n      ? geometryMaybeCollection.type === \"GeometryCollection\"\n      : false;\n    stopG = isGeometryCollection\n      ? geometryMaybeCollection.geometries.length\n      : 1;\n\n    for (g = 0; g < stopG; g++) {\n      geometry = isGeometryCollection\n        ? geometryMaybeCollection.geometries[g]\n        : geometryMaybeCollection;\n\n      // Handle null Geometry\n      if (geometry === null) {\n        if (\n          callback(\n            null,\n            featureIndex,\n            featureProperties,\n            featureBBox,\n            featureId\n          ) === false\n        )\n          return false;\n        continue;\n      }\n      switch (geometry.type) {\n        case \"Point\":\n        case \"LineString\":\n        case \"MultiPoint\":\n        case \"Polygon\":\n        case \"MultiLineString\":\n        case \"MultiPolygon\": {\n          if (\n            callback(\n              geometry,\n              featureIndex,\n              featureProperties,\n              featureBBox,\n              featureId\n            ) === false\n          )\n            return false;\n          break;\n        }\n        case \"GeometryCollection\": {\n          for (j = 0; j < geometry.geometries.length; j++) {\n            if (\n              callback(\n                geometry.geometries[j],\n                featureIndex,\n                featureProperties,\n                featureBBox,\n                featureId\n              ) === false\n            )\n              return false;\n          }\n          break;\n        }\n        default:\n          throw new Error(\"Unknown Geometry Type\");\n      }\n    }\n    // Only increase `featureIndex` per each feature\n    featureIndex++;\n  }\n}\n\n/**\n * Callback for geomReduce\n *\n * The first time the callback function is called, the values provided as arguments depend\n * on whether the reduce method has an initialValue argument.\n *\n * If an initialValue is provided to the reduce method:\n *  - The previousValue argument is initialValue.\n *  - The currentValue argument is the value of the first element present in the array.\n *\n * If an initialValue is not provided:\n *  - The previousValue argument is the value of the first element present in the array.\n *  - The currentValue argument is the value of the second element present in the array.\n *\n * @callback geomReduceCallback\n * @param {*} previousValue The accumulated value previously returned in the last invocation\n * of the callback, or initialValue, if supplied.\n * @param {Geometry} currentGeometry The current Geometry being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n * @param {Object} featureProperties The current Feature Properties being processed.\n * @param {Array<number>} featureBBox The current Feature BBox being processed.\n * @param {number|string} featureId The current Feature Id being processed.\n */\n\n/**\n * Reduce geometry in any GeoJSON object, similar to Array.reduce().\n *\n * @name geomReduce\n * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object\n * @param {Function} callback a method that takes (previousValue, currentGeometry, featureIndex, featureProperties, featureBBox, featureId)\n * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.\n * @returns {*} The value that results from the reduction.\n * @example\n * var features = turf.featureCollection([\n *     turf.point([26, 37], {foo: 'bar'}),\n *     turf.point([36, 53], {hello: 'world'})\n * ]);\n *\n * turf.geomReduce(features, function (previousValue, currentGeometry, featureIndex, featureProperties, featureBBox, featureId) {\n *   //=previousValue\n *   //=currentGeometry\n *   //=featureIndex\n *   //=featureProperties\n *   //=featureBBox\n *   //=featureId\n *   return currentGeometry\n * });\n */\nfunction geomReduce(geojson, callback, initialValue) {\n  var previousValue = initialValue;\n  geomEach(\n    geojson,\n    function (\n      currentGeometry,\n      featureIndex,\n      featureProperties,\n      featureBBox,\n      featureId\n    ) {\n      if (featureIndex === 0 && initialValue === undefined)\n        previousValue = currentGeometry;\n      else\n        previousValue = callback(\n          previousValue,\n          currentGeometry,\n          featureIndex,\n          featureProperties,\n          featureBBox,\n          featureId\n        );\n    }\n  );\n  return previousValue;\n}\n\n/**\n * Callback for flattenEach\n *\n * @callback flattenEachCallback\n * @param {Feature} currentFeature The current flattened feature being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.\n */\n\n/**\n * Iterate over flattened features in any GeoJSON object, similar to\n * Array.forEach.\n *\n * @name flattenEach\n * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object\n * @param {Function} callback a method that takes (currentFeature, featureIndex, multiFeatureIndex)\n * @example\n * var features = turf.featureCollection([\n *     turf.point([26, 37], {foo: 'bar'}),\n *     turf.multiPoint([[40, 30], [36, 53]], {hello: 'world'})\n * ]);\n *\n * turf.flattenEach(features, function (currentFeature, featureIndex, multiFeatureIndex) {\n *   //=currentFeature\n *   //=featureIndex\n *   //=multiFeatureIndex\n * });\n */\nfunction flattenEach(geojson, callback) {\n  geomEach(geojson, function (geometry, featureIndex, properties, bbox, id) {\n    // Callback for single geometry\n    var type = geometry === null ? null : geometry.type;\n    switch (type) {\n      case null:\n      case \"Point\":\n      case \"LineString\":\n      case \"Polygon\":\n        if (\n          callback(\n            Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"feature\"])(geometry, properties, { bbox: bbox, id: id }),\n            featureIndex,\n            0\n          ) === false\n        )\n          return false;\n        return;\n    }\n\n    var geomType;\n\n    // Callback for multi-geometry\n    switch (type) {\n      case \"MultiPoint\":\n        geomType = \"Point\";\n        break;\n      case \"MultiLineString\":\n        geomType = \"LineString\";\n        break;\n      case \"MultiPolygon\":\n        geomType = \"Polygon\";\n        break;\n    }\n\n    for (\n      var multiFeatureIndex = 0;\n      multiFeatureIndex < geometry.coordinates.length;\n      multiFeatureIndex++\n    ) {\n      var coordinate = geometry.coordinates[multiFeatureIndex];\n      var geom = {\n        type: geomType,\n        coordinates: coordinate,\n      };\n      if (\n        callback(Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"feature\"])(geom, properties), featureIndex, multiFeatureIndex) ===\n        false\n      )\n        return false;\n    }\n  });\n}\n\n/**\n * Callback for flattenReduce\n *\n * The first time the callback function is called, the values provided as arguments depend\n * on whether the reduce method has an initialValue argument.\n *\n * If an initialValue is provided to the reduce method:\n *  - The previousValue argument is initialValue.\n *  - The currentValue argument is the value of the first element present in the array.\n *\n * If an initialValue is not provided:\n *  - The previousValue argument is the value of the first element present in the array.\n *  - The currentValue argument is the value of the second element present in the array.\n *\n * @callback flattenReduceCallback\n * @param {*} previousValue The accumulated value previously returned in the last invocation\n * of the callback, or initialValue, if supplied.\n * @param {Feature} currentFeature The current Feature being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.\n */\n\n/**\n * Reduce flattened features in any GeoJSON object, similar to Array.reduce().\n *\n * @name flattenReduce\n * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object\n * @param {Function} callback a method that takes (previousValue, currentFeature, featureIndex, multiFeatureIndex)\n * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.\n * @returns {*} The value that results from the reduction.\n * @example\n * var features = turf.featureCollection([\n *     turf.point([26, 37], {foo: 'bar'}),\n *     turf.multiPoint([[40, 30], [36, 53]], {hello: 'world'})\n * ]);\n *\n * turf.flattenReduce(features, function (previousValue, currentFeature, featureIndex, multiFeatureIndex) {\n *   //=previousValue\n *   //=currentFeature\n *   //=featureIndex\n *   //=multiFeatureIndex\n *   return currentFeature\n * });\n */\nfunction flattenReduce(geojson, callback, initialValue) {\n  var previousValue = initialValue;\n  flattenEach(\n    geojson,\n    function (currentFeature, featureIndex, multiFeatureIndex) {\n      if (\n        featureIndex === 0 &&\n        multiFeatureIndex === 0 &&\n        initialValue === undefined\n      )\n        previousValue = currentFeature;\n      else\n        previousValue = callback(\n          previousValue,\n          currentFeature,\n          featureIndex,\n          multiFeatureIndex\n        );\n    }\n  );\n  return previousValue;\n}\n\n/**\n * Callback for segmentEach\n *\n * @callback segmentEachCallback\n * @param {Feature<LineString>} currentSegment The current Segment being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.\n * @param {number} geometryIndex The current index of the Geometry being processed.\n * @param {number} segmentIndex The current index of the Segment being processed.\n * @returns {void}\n */\n\n/**\n * Iterate over 2-vertex line segment in any GeoJSON object, similar to Array.forEach()\n * (Multi)Point geometries do not contain segments therefore they are ignored during this operation.\n *\n * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON\n * @param {Function} callback a method that takes (currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex)\n * @returns {void}\n * @example\n * var polygon = turf.polygon([[[-50, 5], [-40, -10], [-50, -10], [-40, 5], [-50, 5]]]);\n *\n * // Iterate over GeoJSON by 2-vertex segments\n * turf.segmentEach(polygon, function (currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) {\n *   //=currentSegment\n *   //=featureIndex\n *   //=multiFeatureIndex\n *   //=geometryIndex\n *   //=segmentIndex\n * });\n *\n * // Calculate the total number of segments\n * var total = 0;\n * turf.segmentEach(polygon, function () {\n *     total++;\n * });\n */\nfunction segmentEach(geojson, callback) {\n  flattenEach(geojson, function (feature$$1, featureIndex, multiFeatureIndex) {\n    var segmentIndex = 0;\n\n    // Exclude null Geometries\n    if (!feature$$1.geometry) return;\n    // (Multi)Point geometries do not contain segments therefore they are ignored during this operation.\n    var type = feature$$1.geometry.type;\n    if (type === \"Point\" || type === \"MultiPoint\") return;\n\n    // Generate 2-vertex line segments\n    var previousCoords;\n    var previousFeatureIndex = 0;\n    var previousMultiIndex = 0;\n    var prevGeomIndex = 0;\n    if (\n      coordEach(\n        feature$$1,\n        function (\n          currentCoord,\n          coordIndex,\n          featureIndexCoord,\n          multiPartIndexCoord,\n          geometryIndex\n        ) {\n          // Simulating a meta.coordReduce() since `reduce` operations cannot be stopped by returning `false`\n          if (\n            previousCoords === undefined ||\n            featureIndex > previousFeatureIndex ||\n            multiPartIndexCoord > previousMultiIndex ||\n            geometryIndex > prevGeomIndex\n          ) {\n            previousCoords = currentCoord;\n            previousFeatureIndex = featureIndex;\n            previousMultiIndex = multiPartIndexCoord;\n            prevGeomIndex = geometryIndex;\n            segmentIndex = 0;\n            return;\n          }\n          var currentSegment = Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"lineString\"])(\n            [previousCoords, currentCoord],\n            feature$$1.properties\n          );\n          if (\n            callback(\n              currentSegment,\n              featureIndex,\n              multiFeatureIndex,\n              geometryIndex,\n              segmentIndex\n            ) === false\n          )\n            return false;\n          segmentIndex++;\n          previousCoords = currentCoord;\n        }\n      ) === false\n    )\n      return false;\n  });\n}\n\n/**\n * Callback for segmentReduce\n *\n * The first time the callback function is called, the values provided as arguments depend\n * on whether the reduce method has an initialValue argument.\n *\n * If an initialValue is provided to the reduce method:\n *  - The previousValue argument is initialValue.\n *  - The currentValue argument is the value of the first element present in the array.\n *\n * If an initialValue is not provided:\n *  - The previousValue argument is the value of the first element present in the array.\n *  - The currentValue argument is the value of the second element present in the array.\n *\n * @callback segmentReduceCallback\n * @param {*} previousValue The accumulated value previously returned in the last invocation\n * of the callback, or initialValue, if supplied.\n * @param {Feature<LineString>} currentSegment The current Segment being processed.\n * @param {number} featureIndex The current index of the Feature being processed.\n * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.\n * @param {number} geometryIndex The current index of the Geometry being processed.\n * @param {number} segmentIndex The current index of the Segment being processed.\n */\n\n/**\n * Reduce 2-vertex line segment in any GeoJSON object, similar to Array.reduce()\n * (Multi)Point geometries do not contain segments therefore they are ignored during this operation.\n *\n * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON\n * @param {Function} callback a method that takes (previousValue, currentSegment, currentIndex)\n * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.\n * @returns {void}\n * @example\n * var polygon = turf.polygon([[[-50, 5], [-40, -10], [-50, -10], [-40, 5], [-50, 5]]]);\n *\n * // Iterate over GeoJSON by 2-vertex segments\n * turf.segmentReduce(polygon, function (previousSegment, currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) {\n *   //= previousSegment\n *   //= currentSegment\n *   //= featureIndex\n *   //= multiFeatureIndex\n *   //= geometryIndex\n *   //= segmentIndex\n *   return currentSegment\n * });\n *\n * // Calculate the total number of segments\n * var initialValue = 0\n * var total = turf.segmentReduce(polygon, function (previousValue) {\n *     previousValue++;\n *     return previousValue;\n * }, initialValue);\n */\nfunction segmentReduce(geojson, callback, initialValue) {\n  var previousValue = initialValue;\n  var started = false;\n  segmentEach(\n    geojson,\n    function (\n      currentSegment,\n      featureIndex,\n      multiFeatureIndex,\n      geometryIndex,\n      segmentIndex\n    ) {\n      if (started === false && initialValue === undefined)\n        previousValue = currentSegment;\n      else\n        previousValue = callback(\n          previousValue,\n          currentSegment,\n          featureIndex,\n          multiFeatureIndex,\n          geometryIndex,\n          segmentIndex\n        );\n      started = true;\n    }\n  );\n  return previousValue;\n}\n\n/**\n * Callback for lineEach\n *\n * @callback lineEachCallback\n * @param {Feature<LineString>} currentLine The current LineString|LinearRing being processed\n * @param {number} featureIndex The current index of the Feature being processed\n * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed\n * @param {number} geometryIndex The current index of the Geometry being processed\n */\n\n/**\n * Iterate over line or ring coordinates in LineString, Polygon, MultiLineString, MultiPolygon Features or Geometries,\n * similar to Array.forEach.\n *\n * @name lineEach\n * @param {Geometry|Feature<LineString|Polygon|MultiLineString|MultiPolygon>} geojson object\n * @param {Function} callback a method that takes (currentLine, featureIndex, multiFeatureIndex, geometryIndex)\n * @example\n * var multiLine = turf.multiLineString([\n *   [[26, 37], [35, 45]],\n *   [[36, 53], [38, 50], [41, 55]]\n * ]);\n *\n * turf.lineEach(multiLine, function (currentLine, featureIndex, multiFeatureIndex, geometryIndex) {\n *   //=currentLine\n *   //=featureIndex\n *   //=multiFeatureIndex\n *   //=geometryIndex\n * });\n */\nfunction lineEach(geojson, callback) {\n  // validation\n  if (!geojson) throw new Error(\"geojson is required\");\n\n  flattenEach(geojson, function (feature$$1, featureIndex, multiFeatureIndex) {\n    if (feature$$1.geometry === null) return;\n    var type = feature$$1.geometry.type;\n    var coords = feature$$1.geometry.coordinates;\n    switch (type) {\n      case \"LineString\":\n        if (callback(feature$$1, featureIndex, multiFeatureIndex, 0, 0) === false)\n          return false;\n        break;\n      case \"Polygon\":\n        for (\n          var geometryIndex = 0;\n          geometryIndex < coords.length;\n          geometryIndex++\n        ) {\n          if (\n            callback(\n              Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"lineString\"])(coords[geometryIndex], feature$$1.properties),\n              featureIndex,\n              multiFeatureIndex,\n              geometryIndex\n            ) === false\n          )\n            return false;\n        }\n        break;\n    }\n  });\n}\n\n/**\n * Callback for lineReduce\n *\n * The first time the callback function is called, the values provided as arguments depend\n * on whether the reduce method has an initialValue argument.\n *\n * If an initialValue is provided to the reduce method:\n *  - The previousValue argument is initialValue.\n *  - The currentValue argument is the value of the first element present in the array.\n *\n * If an initialValue is not provided:\n *  - The previousValue argument is the value of the first element present in the array.\n *  - The currentValue argument is the value of the second element present in the array.\n *\n * @callback lineReduceCallback\n * @param {*} previousValue The accumulated value previously returned in the last invocation\n * of the callback, or initialValue, if supplied.\n * @param {Feature<LineString>} currentLine The current LineString|LinearRing being processed.\n * @param {number} featureIndex The current index of the Feature being processed\n * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed\n * @param {number} geometryIndex The current index of the Geometry being processed\n */\n\n/**\n * Reduce features in any GeoJSON object, similar to Array.reduce().\n *\n * @name lineReduce\n * @param {Geometry|Feature<LineString|Polygon|MultiLineString|MultiPolygon>} geojson object\n * @param {Function} callback a method that takes (previousValue, currentLine, featureIndex, multiFeatureIndex, geometryIndex)\n * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.\n * @returns {*} The value that results from the reduction.\n * @example\n * var multiPoly = turf.multiPolygon([\n *   turf.polygon([[[12,48],[2,41],[24,38],[12,48]], [[9,44],[13,41],[13,45],[9,44]]]),\n *   turf.polygon([[[5, 5], [0, 0], [2, 2], [4, 4], [5, 5]]])\n * ]);\n *\n * turf.lineReduce(multiPoly, function (previousValue, currentLine, featureIndex, multiFeatureIndex, geometryIndex) {\n *   //=previousValue\n *   //=currentLine\n *   //=featureIndex\n *   //=multiFeatureIndex\n *   //=geometryIndex\n *   return currentLine\n * });\n */\nfunction lineReduce(geojson, callback, initialValue) {\n  var previousValue = initialValue;\n  lineEach(\n    geojson,\n    function (currentLine, featureIndex, multiFeatureIndex, geometryIndex) {\n      if (featureIndex === 0 && initialValue === undefined)\n        previousValue = currentLine;\n      else\n        previousValue = callback(\n          previousValue,\n          currentLine,\n          featureIndex,\n          multiFeatureIndex,\n          geometryIndex\n        );\n    }\n  );\n  return previousValue;\n}\n\n/**\n * Finds a particular 2-vertex LineString Segment from a GeoJSON using `@turf/meta` indexes.\n *\n * Negative indexes are permitted.\n * Point & MultiPoint will always return null.\n *\n * @param {FeatureCollection|Feature|Geometry} geojson Any GeoJSON Feature or Geometry\n * @param {Object} [options={}] Optional parameters\n * @param {number} [options.featureIndex=0] Feature Index\n * @param {number} [options.multiFeatureIndex=0] Multi-Feature Index\n * @param {number} [options.geometryIndex=0] Geometry Index\n * @param {number} [options.segmentIndex=0] Segment Index\n * @param {Object} [options.properties={}] Translate Properties to output LineString\n * @param {BBox} [options.bbox={}] Translate BBox to output LineString\n * @param {number|string} [options.id={}] Translate Id to output LineString\n * @returns {Feature<LineString>} 2-vertex GeoJSON Feature LineString\n * @example\n * var multiLine = turf.multiLineString([\n *     [[10, 10], [50, 30], [30, 40]],\n *     [[-10, -10], [-50, -30], [-30, -40]]\n * ]);\n *\n * // First Segment (defaults are 0)\n * turf.findSegment(multiLine);\n * // => Feature<LineString<[[10, 10], [50, 30]]>>\n *\n * // First Segment of 2nd Multi Feature\n * turf.findSegment(multiLine, {multiFeatureIndex: 1});\n * // => Feature<LineString<[[-10, -10], [-50, -30]]>>\n *\n * // Last Segment of Last Multi Feature\n * turf.findSegment(multiLine, {multiFeatureIndex: -1, segmentIndex: -1});\n * // => Feature<LineString<[[-50, -30], [-30, -40]]>>\n */\nfunction findSegment(geojson, options) {\n  // Optional Parameters\n  options = options || {};\n  if (!Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"isObject\"])(options)) throw new Error(\"options is invalid\");\n  var featureIndex = options.featureIndex || 0;\n  var multiFeatureIndex = options.multiFeatureIndex || 0;\n  var geometryIndex = options.geometryIndex || 0;\n  var segmentIndex = options.segmentIndex || 0;\n\n  // Find FeatureIndex\n  var properties = options.properties;\n  var geometry;\n\n  switch (geojson.type) {\n    case \"FeatureCollection\":\n      if (featureIndex < 0)\n        featureIndex = geojson.features.length + featureIndex;\n      properties = properties || geojson.features[featureIndex].properties;\n      geometry = geojson.features[featureIndex].geometry;\n      break;\n    case \"Feature\":\n      properties = properties || geojson.properties;\n      geometry = geojson.geometry;\n      break;\n    case \"Point\":\n    case \"MultiPoint\":\n      return null;\n    case \"LineString\":\n    case \"Polygon\":\n    case \"MultiLineString\":\n    case \"MultiPolygon\":\n      geometry = geojson;\n      break;\n    default:\n      throw new Error(\"geojson is invalid\");\n  }\n\n  // Find SegmentIndex\n  if (geometry === null) return null;\n  var coords = geometry.coordinates;\n  switch (geometry.type) {\n    case \"Point\":\n    case \"MultiPoint\":\n      return null;\n    case \"LineString\":\n      if (segmentIndex < 0) segmentIndex = coords.length + segmentIndex - 1;\n      return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"lineString\"])(\n        [coords[segmentIndex], coords[segmentIndex + 1]],\n        properties,\n        options\n      );\n    case \"Polygon\":\n      if (geometryIndex < 0) geometryIndex = coords.length + geometryIndex;\n      if (segmentIndex < 0)\n        segmentIndex = coords[geometryIndex].length + segmentIndex - 1;\n      return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"lineString\"])(\n        [\n          coords[geometryIndex][segmentIndex],\n          coords[geometryIndex][segmentIndex + 1],\n        ],\n        properties,\n        options\n      );\n    case \"MultiLineString\":\n      if (multiFeatureIndex < 0)\n        multiFeatureIndex = coords.length + multiFeatureIndex;\n      if (segmentIndex < 0)\n        segmentIndex = coords[multiFeatureIndex].length + segmentIndex - 1;\n      return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"lineString\"])(\n        [\n          coords[multiFeatureIndex][segmentIndex],\n          coords[multiFeatureIndex][segmentIndex + 1],\n        ],\n        properties,\n        options\n      );\n    case \"MultiPolygon\":\n      if (multiFeatureIndex < 0)\n        multiFeatureIndex = coords.length + multiFeatureIndex;\n      if (geometryIndex < 0)\n        geometryIndex = coords[multiFeatureIndex].length + geometryIndex;\n      if (segmentIndex < 0)\n        segmentIndex =\n          coords[multiFeatureIndex][geometryIndex].length - segmentIndex - 1;\n      return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"lineString\"])(\n        [\n          coords[multiFeatureIndex][geometryIndex][segmentIndex],\n          coords[multiFeatureIndex][geometryIndex][segmentIndex + 1],\n        ],\n        properties,\n        options\n      );\n  }\n  throw new Error(\"geojson is invalid\");\n}\n\n/**\n * Finds a particular Point from a GeoJSON using `@turf/meta` indexes.\n *\n * Negative indexes are permitted.\n *\n * @param {FeatureCollection|Feature|Geometry} geojson Any GeoJSON Feature or Geometry\n * @param {Object} [options={}] Optional parameters\n * @param {number} [options.featureIndex=0] Feature Index\n * @param {number} [options.multiFeatureIndex=0] Multi-Feature Index\n * @param {number} [options.geometryIndex=0] Geometry Index\n * @param {number} [options.coordIndex=0] Coord Index\n * @param {Object} [options.properties={}] Translate Properties to output Point\n * @param {BBox} [options.bbox={}] Translate BBox to output Point\n * @param {number|string} [options.id={}] Translate Id to output Point\n * @returns {Feature<Point>} 2-vertex GeoJSON Feature Point\n * @example\n * var multiLine = turf.multiLineString([\n *     [[10, 10], [50, 30], [30, 40]],\n *     [[-10, -10], [-50, -30], [-30, -40]]\n * ]);\n *\n * // First Segment (defaults are 0)\n * turf.findPoint(multiLine);\n * // => Feature<Point<[10, 10]>>\n *\n * // First Segment of the 2nd Multi-Feature\n * turf.findPoint(multiLine, {multiFeatureIndex: 1});\n * // => Feature<Point<[-10, -10]>>\n *\n * // Last Segment of last Multi-Feature\n * turf.findPoint(multiLine, {multiFeatureIndex: -1, coordIndex: -1});\n * // => Feature<Point<[-30, -40]>>\n */\nfunction findPoint(geojson, options) {\n  // Optional Parameters\n  options = options || {};\n  if (!Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"isObject\"])(options)) throw new Error(\"options is invalid\");\n  var featureIndex = options.featureIndex || 0;\n  var multiFeatureIndex = options.multiFeatureIndex || 0;\n  var geometryIndex = options.geometryIndex || 0;\n  var coordIndex = options.coordIndex || 0;\n\n  // Find FeatureIndex\n  var properties = options.properties;\n  var geometry;\n\n  switch (geojson.type) {\n    case \"FeatureCollection\":\n      if (featureIndex < 0)\n        featureIndex = geojson.features.length + featureIndex;\n      properties = properties || geojson.features[featureIndex].properties;\n      geometry = geojson.features[featureIndex].geometry;\n      break;\n    case \"Feature\":\n      properties = properties || geojson.properties;\n      geometry = geojson.geometry;\n      break;\n    case \"Point\":\n    case \"MultiPoint\":\n      return null;\n    case \"LineString\":\n    case \"Polygon\":\n    case \"MultiLineString\":\n    case \"MultiPolygon\":\n      geometry = geojson;\n      break;\n    default:\n      throw new Error(\"geojson is invalid\");\n  }\n\n  // Find Coord Index\n  if (geometry === null) return null;\n  var coords = geometry.coordinates;\n  switch (geometry.type) {\n    case \"Point\":\n      return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(coords, properties, options);\n    case \"MultiPoint\":\n      if (multiFeatureIndex < 0)\n        multiFeatureIndex = coords.length + multiFeatureIndex;\n      return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(coords[multiFeatureIndex], properties, options);\n    case \"LineString\":\n      if (coordIndex < 0) coordIndex = coords.length + coordIndex;\n      return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(coords[coordIndex], properties, options);\n    case \"Polygon\":\n      if (geometryIndex < 0) geometryIndex = coords.length + geometryIndex;\n      if (coordIndex < 0)\n        coordIndex = coords[geometryIndex].length + coordIndex;\n      return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(coords[geometryIndex][coordIndex], properties, options);\n    case \"MultiLineString\":\n      if (multiFeatureIndex < 0)\n        multiFeatureIndex = coords.length + multiFeatureIndex;\n      if (coordIndex < 0)\n        coordIndex = coords[multiFeatureIndex].length + coordIndex;\n      return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(coords[multiFeatureIndex][coordIndex], properties, options);\n    case \"MultiPolygon\":\n      if (multiFeatureIndex < 0)\n        multiFeatureIndex = coords.length + multiFeatureIndex;\n      if (geometryIndex < 0)\n        geometryIndex = coords[multiFeatureIndex].length + geometryIndex;\n      if (coordIndex < 0)\n        coordIndex =\n          coords[multiFeatureIndex][geometryIndex].length - coordIndex;\n      return Object(_turf_helpers__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(\n        coords[multiFeatureIndex][geometryIndex][coordIndex],\n        properties,\n        options\n      );\n  }\n  throw new Error(\"geojson is invalid\");\n}\n\n\n\n\n//# sourceURL=webpack:///./node_modules/@turf/meta/dist/es/index.js?");

/***/ }),

/***/ "./node_modules/a-big-triangle/triangle.js":
/*!*************************************************!*\
  !*** ./node_modules/a-big-triangle/triangle.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar weakMap      = typeof WeakMap === 'undefined' ? __webpack_require__(/*! weak-map */ \"./node_modules/weak-map/weak-map.js\") : WeakMap\nvar createBuffer = __webpack_require__(/*! gl-buffer */ \"./node_modules/gl-buffer/buffer.js\")\nvar createVAO    = __webpack_require__(/*! gl-vao */ \"./node_modules/gl-vao/vao.js\")\n\nvar TriangleCache = new weakMap()\n\nfunction createABigTriangle(gl) {\n\n  var triangleVAO = TriangleCache.get(gl)\n  var handle = triangleVAO && (triangleVAO._triangleBuffer.handle || triangleVAO._triangleBuffer.buffer)\n  if(!handle || !gl.isBuffer(handle)) {\n    var buf = createBuffer(gl, new Float32Array([-1, -1, -1, 4, 4, -1]))\n    triangleVAO = createVAO(gl, [\n      { buffer: buf,\n        type: gl.FLOAT,\n        size: 2\n      }\n    ])\n    triangleVAO._triangleBuffer = buf\n    TriangleCache.set(gl, triangleVAO)\n  }\n  triangleVAO.bind()\n  gl.drawArrays(gl.TRIANGLES, 0, 3)\n  triangleVAO.unbind()\n}\n\nmodule.exports = createABigTriangle\n\n\n//# sourceURL=webpack:///./node_modules/a-big-triangle/triangle.js?");

/***/ }),

/***/ "./node_modules/abs-svg-path/index.js":
/*!********************************************!*\
  !*** ./node_modules/abs-svg-path/index.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("\nmodule.exports = absolutize\n\n/**\n * redefine `path` with absolute coordinates\n *\n * @param {Array} path\n * @return {Array}\n */\n\nfunction absolutize(path){\n\tvar startX = 0\n\tvar startY = 0\n\tvar x = 0\n\tvar y = 0\n\n\treturn path.map(function(seg){\n\t\tseg = seg.slice()\n\t\tvar type = seg[0]\n\t\tvar command = type.toUpperCase()\n\n\t\t// is relative\n\t\tif (type != command) {\n\t\t\tseg[0] = command\n\t\t\tswitch (type) {\n\t\t\t\tcase 'a':\n\t\t\t\t\tseg[6] += x\n\t\t\t\t\tseg[7] += y\n\t\t\t\t\tbreak\n\t\t\t\tcase 'v':\n\t\t\t\t\tseg[1] += y\n\t\t\t\t\tbreak\n\t\t\t\tcase 'h':\n\t\t\t\t\tseg[1] += x\n\t\t\t\t\tbreak\n\t\t\t\tdefault:\n\t\t\t\t\tfor (var i = 1; i < seg.length;) {\n\t\t\t\t\t\tseg[i++] += x\n\t\t\t\t\t\tseg[i++] += y\n\t\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// update cursor state\n\t\tswitch (command) {\n\t\t\tcase 'Z':\n\t\t\t\tx = startX\n\t\t\t\ty = startY\n\t\t\t\tbreak\n\t\t\tcase 'H':\n\t\t\t\tx = seg[1]\n\t\t\t\tbreak\n\t\t\tcase 'V':\n\t\t\t\ty = seg[1]\n\t\t\t\tbreak\n\t\t\tcase 'M':\n\t\t\t\tx = startX = seg[1]\n\t\t\t\ty = startY = seg[2]\n\t\t\t\tbreak\n\t\t\tdefault:\n\t\t\t\tx = seg[seg.length - 2]\n\t\t\t\ty = seg[seg.length - 1]\n\t\t}\n\n\t\treturn seg\n\t})\n}\n\n\n//# sourceURL=webpack:///./node_modules/abs-svg-path/index.js?");

/***/ }),

/***/ "./node_modules/add-line-numbers/index.js":
/*!************************************************!*\
  !*** ./node_modules/add-line-numbers/index.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var padLeft = __webpack_require__(/*! pad-left */ \"./node_modules/pad-left/index.js\")\n\nmodule.exports = addLineNumbers\nfunction addLineNumbers (string, start, delim) {\n  start = typeof start === 'number' ? start : 1\n  delim = delim || ': '\n\n  var lines = string.split(/\\r?\\n/)\n  var totalDigits = String(lines.length + start - 1).length\n  return lines.map(function (line, i) {\n    var c = i + start\n    var digits = String(c).length\n    var prefix = padLeft(c, totalDigits - digits)\n    return prefix + delim + line\n  }).join('\\n')\n}\n\n\n//# sourceURL=webpack:///./node_modules/add-line-numbers/index.js?");

/***/ }),

/***/ "./node_modules/affine-hull/aff.js":
/*!*****************************************!*\
  !*** ./node_modules/affine-hull/aff.js ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = affineHull\n\nvar orient = __webpack_require__(/*! robust-orientation */ \"./node_modules/robust-orientation/orientation.js\")\n\nfunction linearlyIndependent(points, d) {\n  var nhull = new Array(d+1)\n  for(var i=0; i<points.length; ++i) {\n    nhull[i] = points[i]\n  }\n  for(var i=0; i<=points.length; ++i) {\n    for(var j=points.length; j<=d; ++j) {\n      var x = new Array(d)\n      for(var k=0; k<d; ++k) {\n        x[k] = Math.pow(j+1-i, k)\n      }\n      nhull[j] = x\n    }\n    var o = orient.apply(void 0, nhull)\n    if(o) {\n      return true\n    }\n  }\n  return false\n}\n\nfunction affineHull(points) {\n  var n = points.length\n  if(n === 0) {\n    return []\n  }\n  if(n === 1) {\n    return [0]\n  }\n  var d = points[0].length\n  var frame = [ points[0] ]\n  var index = [ 0 ]\n  for(var i=1; i<n; ++i) {\n    frame.push(points[i])\n    if(!linearlyIndependent(frame, d)) {\n      frame.pop()\n      continue\n    }\n    index.push(i)\n    if(index.length === d+1) {\n      return index\n    }\n  }\n  return index\n}\n\n//# sourceURL=webpack:///./node_modules/affine-hull/aff.js?");

/***/ }),

/***/ "./node_modules/alpha-complex/alpha.js":
/*!*********************************************!*\
  !*** ./node_modules/alpha-complex/alpha.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = alphaComplex\n\nvar delaunay = __webpack_require__(/*! delaunay-triangulate */ \"./node_modules/delaunay-triangulate/triangulate.js\")\nvar circumradius = __webpack_require__(/*! circumradius */ \"./node_modules/circumradius/crad.js\")\n\nfunction alphaComplex(alpha, points) {\n  return delaunay(points).filter(function(cell) {\n    var simplex = new Array(cell.length)\n    for(var i=0; i<cell.length; ++i) {\n      simplex[i] = points[cell[i]]\n    }\n    return circumradius(simplex) * alpha < 1\n  })\n}\n\n//# sourceURL=webpack:///./node_modules/alpha-complex/alpha.js?");

/***/ }),

/***/ "./node_modules/alpha-shape/alpha.js":
/*!*******************************************!*\
  !*** ./node_modules/alpha-shape/alpha.js ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("module.exports = alphaShape\n\nvar ac = __webpack_require__(/*! alpha-complex */ \"./node_modules/alpha-complex/alpha.js\")\nvar bnd = __webpack_require__(/*! simplicial-complex-boundary */ \"./node_modules/simplicial-complex-boundary/boundary.js\")\n\nfunction alphaShape(alpha, points) {\n  return bnd(ac(alpha, points))\n}\n\n//# sourceURL=webpack:///./node_modules/alpha-shape/alpha.js?");

/***/ }),

/***/ "./node_modules/array-bounds/index.js":
/*!********************************************!*\
  !*** ./node_modules/array-bounds/index.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\r\n\r\nmodule.exports = normalize;\r\n\r\nfunction normalize (arr, dim) {\r\n\tif (!arr || arr.length == null) throw Error('Argument should be an array')\r\n\r\n\tif (dim == null) dim = 1\r\n\telse dim = Math.floor(dim)\r\n\r\n\tvar bounds = Array(dim * 2)\r\n\r\n\tfor (var offset = 0; offset < dim; offset++) {\r\n\t\tvar max = -Infinity, min = Infinity, i = offset, l = arr.length;\r\n\r\n\t\tfor (; i < l; i+=dim) {\r\n\t\t\tif (arr[i] > max) max = arr[i];\r\n\t\t\tif (arr[i] < min) min = arr[i];\r\n\t\t}\r\n\r\n\t\tbounds[offset] = min\r\n\t\tbounds[dim + offset] = max\r\n\t}\r\n\r\n\treturn bounds;\r\n}\r\n\n\n//# sourceURL=webpack:///./node_modules/array-bounds/index.js?");

/***/ }),

/***/ "./node_modules/array-find-index/index.js":
/*!************************************************!*\
  !*** ./node_modules/array-find-index/index.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\nmodule.exports = function (arr, predicate, ctx) {\n\tif (typeof Array.prototype.findIndex === 'function') {\n\t\treturn arr.findIndex(predicate, ctx);\n\t}\n\n\tif (typeof predicate !== 'function') {\n\t\tthrow new TypeError('predicate must be a function');\n\t}\n\n\tvar list = Object(arr);\n\tvar len = list.length;\n\n\tif (len === 0) {\n\t\treturn -1;\n\t}\n\n\tfor (var i = 0; i < len; i++) {\n\t\tif (predicate.call(ctx, list[i], i, list)) {\n\t\t\treturn i;\n\t\t}\n\t}\n\n\treturn -1;\n};\n\n\n//# sourceURL=webpack:///./node_modules/array-find-index/index.js?");

/***/ }),

/***/ "./node_modules/array-normalize/index.js":
/*!***********************************************!*\
  !*** ./node_modules/array-normalize/index.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\r\n\r\nvar getBounds = __webpack_require__(/*! array-bounds */ \"./node_modules/array-bounds/index.js\")\r\n\r\nmodule.exports = normalize;\r\n\r\nfunction normalize (arr, dim, bounds) {\r\n\tif (!arr || arr.length == null) throw Error('Argument should be an array')\r\n\r\n\tif (dim == null) dim = 1\r\n\tif (bounds == null) bounds = getBounds(arr, dim)\r\n\r\n\tfor (var offset = 0; offset < dim; offset++) {\r\n\t\tvar max = bounds[dim + offset], min = bounds[offset], i = offset, l = arr.length;\r\n\r\n\t\tif (max === Infinity && min === -Infinity) {\r\n\t\t\tfor (i = offset; i < l; i+=dim) {\r\n\t\t\t\tarr[i] = arr[i] === max ? 1 : arr[i] === min ? 0 : .5\r\n\t\t\t}\r\n\t\t}\r\n\t\telse if (max === Infinity) {\r\n\t\t\tfor (i = offset; i < l; i+=dim) {\r\n\t\t\t\tarr[i] = arr[i] === max ? 1 : 0\r\n\t\t\t}\r\n\t\t}\r\n\t\telse if (min === -Infinity) {\r\n\t\t\tfor (i = offset; i < l; i+=dim) {\r\n\t\t\t\tarr[i] = arr[i] === min ? 0 : 1\r\n\t\t\t}\r\n\t\t}\r\n\t\telse {\r\n\t\t\tvar range = max - min\r\n\t\t\tfor (i = offset; i < l; i+=dim) {\r\n\t\t\t\tif (!isNaN(arr[i])) {\r\n\t\t\t\t\tarr[i] = range === 0 ? .5 : (arr[i] - min) / range\r\n\t\t\t\t}\r\n\t\t\t}\r\n\t\t}\r\n\t}\r\n\r\n\treturn arr;\r\n}\r\n\n\n//# sourceURL=webpack:///./node_modules/array-normalize/index.js?");

/***/ }),

/***/ "./node_modules/array-range/index.js":
/*!*******************************************!*\
  !*** ./node_modules/array-range/index.js ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("\nmodule.exports = function newArray(start, end) {\n    var n0 = typeof start === 'number',\n        n1 = typeof end === 'number'\n\n    if (n0 && !n1) {\n        end = start\n        start = 0\n    } else if (!n0 && !n1) {\n        start = 0\n        end = 0\n    }\n\n    start = start|0\n    end = end|0\n    var len = end-start\n    if (len<0)\n        throw new Error('array length must be positive')\n    \n    var a = new Array(len)\n    for (var i=0, c=start; i<len; i++, c++)\n        a[i] = c\n    return a\n}\n\n//# sourceURL=webpack:///./node_modules/array-range/index.js?");

/***/ }),

/***/ "./node_modules/assert/assert.js":
/*!***************************************!*\
  !*** ./node_modules/assert/assert.js ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/* WEBPACK VAR INJECTION */(function(global) {\n\nvar objectAssign = __webpack_require__(/*! object-assign */ \"./node_modules/object-assign/index.js\");\n\n// compare and isBuffer taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js\n// original notice:\n\n/*!\n * The buffer module from node.js, for the browser.\n *\n * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>\n * @license  MIT\n */\nfunction compare(a, b) {\n  if (a === b) {\n    return 0;\n  }\n\n  var x = a.length;\n  var y = b.length;\n\n  for (var i = 0, len = Math.min(x, y); i < len; ++i) {\n    if (a[i] !== b[i]) {\n      x = a[i];\n      y = b[i];\n      break;\n    }\n  }\n\n  if (x < y) {\n    return -1;\n  }\n  if (y < x) {\n    return 1;\n  }\n  return 0;\n}\nfunction isBuffer(b) {\n  if (global.Buffer && typeof global.Buffer.isBuffer === 'function') {\n    return global.Buffer.isBuffer(b);\n  }\n  return !!(b != null && b._isBuffer);\n}\n\n// based on node assert, original notice:\n// NB: The URL to the CommonJS spec is kept just for tradition.\n//     node-assert has evolved a lot since then, both in API and behavior.\n\n// http://wiki.commonjs.org/wiki/Unit_Testing/1.0\n//\n// THIS IS NOT TESTED NOR LIKELY TO WORK OUTSIDE V8!\n//\n// Originally from narwhal.js (http://narwhaljs.org)\n// Copyright (c) 2009 Thomas Robinson <280north.com>\n//\n// Permission is hereby granted, free of charge, to any person obtaining a copy\n// of this software and associated documentation files (the 'Software'), to\n// deal in the Software without restriction, including without limitation the\n// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or\n// sell copies of the Software, and to permit persons to whom the Software is\n// furnished to do so, subject to the following conditions:\n//\n// The above copyright notice and this permission notice shall be included in\n// all copies or substantial portions of the Software.\n//\n// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN\n// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\n// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n\nvar util = __webpack_require__(/*! util/ */ \"./node_modules/util/util.js\");\nvar hasOwn = Object.prototype.hasOwnProperty;\nvar pSlice = Array.prototype.slice;\nvar functionsHaveNames = (function () {\n  return function foo() {}.name === 'foo';\n}());\nfunction pToString (obj) {\n  return Object.prototype.toString.call(obj);\n}\nfunction isView(arrbuf) {\n  if (isBuffer(arrbuf)) {\n    return false;\n  }\n  if (typeof global.ArrayBuffer !== 'function') {\n    return false;\n  }\n  if (typeof ArrayBuffer.isView === 'function') {\n    return ArrayBuffer.isView(arrbuf);\n  }\n  if (!arrbuf) {\n    return false;\n  }\n  if (arrbuf instanceof DataView) {\n    return true;\n  }\n  if (arrbuf.buffer && arrbuf.buffer instanceof ArrayBuffer) {\n    return true;\n  }\n  return false;\n}\n// 1. The assert module provides functions that throw\n// AssertionError's when particular conditions are not met. The\n// assert module must conform to the following interface.\n\nvar assert = module.exports = ok;\n\n// 2. The AssertionError is defined in assert.\n// new assert.AssertionError({ message: message,\n//                             actual: actual,\n//                             expected: expected })\n\nvar regex = /\\s*function\\s+([^\\(\\s]*)\\s*/;\n// based on https://github.com/ljharb/function.prototype.name/blob/adeeeec8bfcc6068b187d7d9fb3d5bb1d3a30899/implementation.js\nfunction getName(func) {\n  if (!util.isFunction(func)) {\n    return;\n  }\n  if (functionsHaveNames) {\n    return func.name;\n  }\n  var str = func.toString();\n  var match = str.match(regex);\n  return match && match[1];\n}\nassert.AssertionError = function AssertionError(options) {\n  this.name = 'AssertionError';\n  this.actual = options.actual;\n  this.expected = options.expected;\n  this.operator = options.operator;\n  if (options.message) {\n    this.message = options.message;\n    this.generatedMessage = false;\n  } else {\n    this.message = getMessage(this);\n    this.generatedMessage = true;\n  }\n  var stackStartFunction = options.stackStartFunction || fail;\n  if (Error.captureStackTrace) {\n    Error.captureStackTrace(this, stackStartFunction);\n  } else {\n    // non v8 browsers so we can have a stacktrace\n    var err = new Error();\n    if (err.stack) {\n      var out = err.stack;\n\n      // try to strip useless frames\n      var fn_name = getName(stackStartFunction);\n      var idx = out.indexOf('\\n' + fn_name);\n      if (idx >= 0) {\n        // once we have located the function frame\n        // we need to strip out everything before it (and its line)\n        var next_line = out.indexOf('\\n', idx + 1);\n        out = out.substring(next_line + 1);\n      }\n\n      this.stack = out;\n    }\n  }\n};\n\n// assert.AssertionError instanceof Error\nutil.inherits(assert.AssertionError, Error);\n\nfunction truncate(s, n) {\n  if (typeof s === 'string') {\n    return s.length < n ? s : s.slice(0, n);\n  } else {\n    return s;\n  }\n}\nfunction inspect(something) {\n  if (functionsHaveNames || !util.isFunction(something)) {\n    return util.inspect(something);\n  }\n  var rawname = getName(something);\n  var name = rawname ? ': ' + rawname : '';\n  return '[Function' +  name + ']';\n}\nfunction getMessage(self) {\n  return truncate(inspect(self.actual), 128) + ' ' +\n         self.operator + ' ' +\n         truncate(inspect(self.expected), 128);\n}\n\n// At present only the three keys mentioned above are used and\n// understood by the spec. Implementations or sub modules can pass\n// other keys to the AssertionError's constructor - they will be\n// ignored.\n\n// 3. All of the following functions must throw an AssertionError\n// when a corresponding condition is not met, with a message that\n// may be undefined if not provided.  All assertion methods provide\n// both the actual and expected values to the assertion error for\n// display purposes.\n\nfunction fail(actual, expected, message, operator, stackStartFunction) {\n  throw new assert.AssertionError({\n    message: message,\n    actual: actual,\n    expected: expected,\n    operator: operator,\n    stackStartFunction: stackStartFunction\n  });\n}\n\n// EXTENSION! allows for well behaved errors defined elsewhere.\nassert.fail = fail;\n\n// 4. Pure assertion tests whether a value is truthy, as determined\n// by !!guard.\n// assert.ok(guard, message_opt);\n// This statement is equivalent to assert.equal(true, !!guard,\n// message_opt);. To test strictly for the value true, use\n// assert.strictEqual(true, guard, message_opt);.\n\nfunction ok(value, message) {\n  if (!value) fail(value, true, message, '==', assert.ok);\n}\nassert.ok = ok;\n\n// 5. The equality assertion tests shallow, coercive equality with\n// ==.\n// assert.equal(actual, expected, message_opt);\n\nassert.equal = function equal(actual, expected, message) {\n  if (actual != expected) fail(actual, expected, message, '==', assert.equal);\n};\n\n// 6. The non-equality assertion tests for whether two objects are not equal\n// with != assert.notEqual(actual, expected, message_opt);\n\nassert.notEqual = function notEqual(actual, expected, message) {\n  if (actual == expected) {\n    fail(actual, expected, message, '!=', assert.notEqual);\n  }\n};\n\n// 7. The equivalence assertion tests a deep equality relation.\n// assert.deepEqual(actual, expected, message_opt);\n\nassert.deepEqual = function deepEqual(actual, expected, message) {\n  if (!_deepEqual(actual, expected, false)) {\n    fail(actual, expected, message, 'deepEqual', assert.deepEqual);\n  }\n};\n\nassert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {\n  if (!_deepEqual(actual, expected, true)) {\n    fail(actual, expected, message, 'deepStrictEqual', assert.deepStrictEqual);\n  }\n};\n\nfunction _deepEqual(actual, expected, strict, memos) {\n  // 7.1. All identical values are equivalent, as determined by ===.\n  if (actual === expected) {\n    return true;\n  } else if (isBuffer(actual) && isBuffer(expected)) {\n    return compare(actual, expected) === 0;\n\n  // 7.2. If the expected value is a Date object, the actual value is\n  // equivalent if it is also a Date object that refers to the same time.\n  } else if (util.isDate(actual) && util.isDate(expected)) {\n    return actual.getTime() === expected.getTime();\n\n  // 7.3 If the expected value is a RegExp object, the actual value is\n  // equivalent if it is also a RegExp object with the same source and\n  // properties (`global`, `multiline`, `lastIndex`, `ignoreCase`).\n  } else if (util.isRegExp(actual) && util.isRegExp(expected)) {\n    return actual.source === expected.source &&\n           actual.global === expected.global &&\n           actual.multiline === expected.multiline &&\n           actual.lastIndex === expected.lastIndex &&\n           actual.ignoreCase === expected.ignoreCase;\n\n  // 7.4. Other pairs that do not both pass typeof value == 'object',\n  // equivalence is determined by ==.\n  } else if ((actual === null || typeof actual !== 'object') &&\n             (expected === null || typeof expected !== 'object')) {\n    return strict ? actual === expected : actual == expected;\n\n  // If both values are instances of typed arrays, wrap their underlying\n  // ArrayBuffers in a Buffer each to increase performance\n  // This optimization requires the arrays to have the same type as checked by\n  // Object.prototype.toString (aka pToString). Never perform binary\n  // comparisons for Float*Arrays, though, since e.g. +0 === -0 but their\n  // bit patterns are not identical.\n  } else if (isView(actual) && isView(expected) &&\n             pToString(actual) === pToString(expected) &&\n             !(actual instanceof Float32Array ||\n               actual instanceof Float64Array)) {\n    return compare(new Uint8Array(actual.buffer),\n                   new Uint8Array(expected.buffer)) === 0;\n\n  // 7.5 For all other Object pairs, including Array objects, equivalence is\n  // determined by having the same number of owned properties (as verified\n  // with Object.prototype.hasOwnProperty.call), the same set of keys\n  // (although not necessarily the same order), equivalent values for every\n  // corresponding key, and an identical 'prototype' property. Note: this\n  // accounts for both named and indexed properties on Arrays.\n  } else if (isBuffer(actual) !== isBuffer(expected)) {\n    return false;\n  } else {\n    memos = memos || {actual: [], expected: []};\n\n    var actualIndex = memos.actual.indexOf(actual);\n    if (actualIndex !== -1) {\n      if (actualIndex === memos.expected.indexOf(expected)) {\n        return true;\n      }\n    }\n\n    memos.actual.push(actual);\n    memos.expected.push(expected);\n\n    return objEquiv(actual, expected, strict, memos);\n  }\n}\n\nfunction isArguments(object) {\n  return Object.prototype.toString.call(object) == '[object Arguments]';\n}\n\nfunction objEquiv(a, b, strict, actualVisitedObjects) {\n  if (a === null || a === undefined || b === null || b === undefined)\n    return false;\n  // if one is a primitive, the other must be same\n  if (util.isPrimitive(a) || util.isPrimitive(b))\n    return a === b;\n  if (strict && Object.getPrototypeOf(a) !== Object.getPrototypeOf(b))\n    return false;\n  var aIsArgs = isArguments(a);\n  var bIsArgs = isArguments(b);\n  if ((aIsArgs && !bIsArgs) || (!aIsArgs && bIsArgs))\n    return false;\n  if (aIsArgs) {\n    a = pSlice.call(a);\n    b = pSlice.call(b);\n    return _deepEqual(a, b, strict);\n  }\n  var ka = objectKeys(a);\n  var kb = objectKeys(b);\n  var key, i;\n  // having the same number of owned properties (keys incorporates\n  // hasOwnProperty)\n  if (ka.length !== kb.length)\n    return false;\n  //the same set of keys (although not necessarily the same order),\n  ka.sort();\n  kb.sort();\n  //~~~cheap key test\n  for (i = ka.length - 1; i >= 0; i--) {\n    if (ka[i] !== kb[i])\n      return false;\n  }\n  //equivalent values for every corresponding key, and\n  //~~~possibly expensive deep test\n  for (i = ka.length - 1; i >= 0; i--) {\n    key = ka[i];\n    if (!_deepEqual(a[key], b[key], strict, actualVisitedObjects))\n      return false;\n  }\n  return true;\n}\n\n// 8. The non-equivalence assertion tests for any deep inequality.\n// assert.notDeepEqual(actual, expected, message_opt);\n\nassert.notDeepEqual = function notDeepEqual(actual, expected, message) {\n  if (_deepEqual(actual, expected, false)) {\n    fail(actual, expected, message, 'notDeepEqual', assert.notDeepEqual);\n  }\n};\n\nassert.notDeepStrictEqual = notDeepStrictEqual;\nfunction notDeepStrictEqual(actual, expected, message) {\n  if (_deepEqual(actual, expected, true)) {\n    fail(actual, expected, message, 'notDeepStrictEqual', notDeepStrictEqual);\n  }\n}\n\n\n// 9. The strict equality assertion tests strict equality, as determined by ===.\n// assert.strictEqual(actual, expected, message_opt);\n\nassert.strictEqual = function strictEqual(actual, expected, message) {\n  if (actual !== expected) {\n    fail(actual, expected, message, '===', assert.strictEqual);\n  }\n};\n\n// 10. The strict non-equality assertion tests for strict inequality, as\n// determined by !==.  assert.notStrictEqual(actual, expected, message_opt);\n\nassert.notStrictEqual = function notStrictEqual(actual, expected, message) {\n  if (actual === expected) {\n    fail(actual, expected, message, '!==', assert.notStrictEqual);\n  }\n};\n\nfunction expectedException(actual, expected) {\n  if (!actual || !expected) {\n    return false;\n  }\n\n  if (Object.prototype.toString.call(expected) == '[object RegExp]') {\n    return expected.test(actual);\n  }\n\n  try {\n    if (actual instanceof expected) {\n      return true;\n    }\n  } catch (e) {\n    // Ignore.  The instanceof check doesn't work for arrow functions.\n  }\n\n  if (Error.isPrototypeOf(expected)) {\n    return false;\n  }\n\n  return expected.call({}, actual) === true;\n}\n\nfunction _tryBlock(block) {\n  var error;\n  try {\n    block();\n  } catch (e) {\n    error = e;\n  }\n  return error;\n}\n\nfunction _throws(shouldThrow, block, expected, message) {\n  var actual;\n\n  if (typeof block !== 'function') {\n    throw new TypeError('\"block\" argument must be a function');\n  }\n\n  if (typeof expected === 'string') {\n    message = expected;\n    expected = null;\n  }\n\n  actual = _tryBlock(block);\n\n  message = (expected && expected.name ? ' (' + expected.name + ').' : '.') +\n            (message ? ' ' + message : '.');\n\n  if (shouldThrow && !actual) {\n    fail(actual, expected, 'Missing expected exception' + message);\n  }\n\n  var userProvidedMessage = typeof message === 'string';\n  var isUnwantedException = !shouldThrow && util.isError(actual);\n  var isUnexpectedException = !shouldThrow && actual && !expected;\n\n  if ((isUnwantedException &&\n      userProvidedMessage &&\n      expectedException(actual, expected)) ||\n      isUnexpectedException) {\n    fail(actual, expected, 'Got unwanted exception' + message);\n  }\n\n  if ((shouldThrow && actual && expected &&\n      !expectedException(actual, expected)) || (!shouldThrow && actual)) {\n    throw actual;\n  }\n}\n\n// 11. Expected to throw an error:\n// assert.throws(block, Error_opt, message_opt);\n\nassert.throws = function(block, /*optional*/error, /*optional*/message) {\n  _throws(true, block, error, message);\n};\n\n// EXTENSION! This is annoying to write outside this module.\nassert.doesNotThrow = function(block, /*optional*/error, /*optional*/message) {\n  _throws(false, block, error, message);\n};\n\nassert.ifError = function(err) { if (err) throw err; };\n\n// Expose a strict only variant of assert\nfunction strict(value, message) {\n  if (!value) fail(value, true, message, '==', strict);\n}\nassert.strict = objectAssign(strict, assert, {\n  equal: assert.strictEqual,\n  deepEqual: assert.deepStrictEqual,\n  notEqual: assert.notStrictEqual,\n  notDeepEqual: assert.notDeepStrictEqual\n});\nassert.strict.strict = assert.strict;\n\nvar objectKeys = Object.keys || function (obj) {\n  var keys = [];\n  for (var key in obj) {\n    if (hasOwn.call(obj, key)) keys.push(key);\n  }\n  return keys;\n};\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../webpack/buildin/global.js */ \"./node_modules/webpack/buildin/global.js\")))\n\n//# sourceURL=webpack:///./node_modules/assert/assert.js?");

/***/ }),

/***/ "./node_modules/atob-lite/atob-browser.js":
/*!************************************************!*\
  !*** ./node_modules/atob-lite/atob-browser.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("module.exports = function _atob(str) {\n  return atob(str)\n}\n\n\n//# sourceURL=webpack:///./node_modules/atob-lite/atob-browser.js?");

/***/ }),

/***/ "./node_modules/barycentric/barycentric.js":
/*!*************************************************!*\
  !*** ./node_modules/barycentric/barycentric.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = barycentric\n\nvar solve = __webpack_require__(/*! robust-linear-solve */ \"./node_modules/robust-linear-solve/linsolve.js\")\n\nfunction reduce(x) {\n  var r = 0\n  for(var i=0; i<x.length; ++i) {\n    r += x[i]\n  }\n  return r\n}\n\nfunction barycentric(simplex, point) {\n  var d = point.length\n  var A = new Array(d+1)\n  for(var i=0; i<d; ++i) {\n    var row = new Array(d+1)\n    for(var j=0; j<=d; ++j) {\n      row[j] = simplex[j][i]\n    }\n    A[i] = row\n  }\n  A[d] = new Array(d+1)\n  for(var i=0; i<=d; ++i) {\n    A[d][i] = 1\n  }\n\n  var b = new Array(d+1)\n  for(var i=0; i<d; ++i) {\n    b[i] = point[i]\n  }\n  b[d] = 1.0\n\n  var x = solve(A, b)\n  var w = reduce(x[d+1])\n  \n  if(w === 0) {\n    w = 1.0\n  }\n  var y = new Array(d+1)\n  for(var i=0; i<=d; ++i) {\n    y[i] = reduce(x[i]) / w\n  }\n  return y\n}\n\n//# sourceURL=webpack:///./node_modules/barycentric/barycentric.js?");

/***/ }),

/***/ "./node_modules/base64-js/index.js":
/*!*****************************************!*\
  !*** ./node_modules/base64-js/index.js ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nexports.byteLength = byteLength\nexports.toByteArray = toByteArray\nexports.fromByteArray = fromByteArray\n\nvar lookup = []\nvar revLookup = []\nvar Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array\n\nvar code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'\nfor (var i = 0, len = code.length; i < len; ++i) {\n  lookup[i] = code[i]\n  revLookup[code.charCodeAt(i)] = i\n}\n\n// Support decoding URL-safe base64 strings, as Node.js does.\n// See: https://en.wikipedia.org/wiki/Base64#URL_applications\nrevLookup['-'.charCodeAt(0)] = 62\nrevLookup['_'.charCodeAt(0)] = 63\n\nfunction getLens (b64) {\n  var len = b64.length\n\n  if (len % 4 > 0) {\n    throw new Error('Invalid string. Length must be a multiple of 4')\n  }\n\n  // Trim off extra bytes after placeholder bytes are found\n  // See: https://github.com/beatgammit/base64-js/issues/42\n  var validLen = b64.indexOf('=')\n  if (validLen === -1) validLen = len\n\n  var placeHoldersLen = validLen === len\n    ? 0\n    : 4 - (validLen % 4)\n\n  return [validLen, placeHoldersLen]\n}\n\n// base64 is 4/3 + up to two characters of the original data\nfunction byteLength (b64) {\n  var lens = getLens(b64)\n  var validLen = lens[0]\n  var placeHoldersLen = lens[1]\n  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen\n}\n\nfunction _byteLength (b64, validLen, placeHoldersLen) {\n  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen\n}\n\nfunction toByteArray (b64) {\n  var tmp\n  var lens = getLens(b64)\n  var validLen = lens[0]\n  var placeHoldersLen = lens[1]\n\n  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))\n\n  var curByte = 0\n\n  // if there are placeholders, only get up to the last complete 4 chars\n  var len = placeHoldersLen > 0\n    ? validLen - 4\n    : validLen\n\n  var i\n  for (i = 0; i < len; i += 4) {\n    tmp =\n      (revLookup[b64.charCodeAt(i)] << 18) |\n      (revLookup[b64.charCodeAt(i + 1)] << 12) |\n      (revLookup[b64.charCodeAt(i + 2)] << 6) |\n      revLookup[b64.charCodeAt(i + 3)]\n    arr[curByte++] = (tmp >> 16) & 0xFF\n    arr[curByte++] = (tmp >> 8) & 0xFF\n    arr[curByte++] = tmp & 0xFF\n  }\n\n  if (placeHoldersLen === 2) {\n    tmp =\n      (revLookup[b64.charCodeAt(i)] << 2) |\n      (revLookup[b64.charCodeAt(i + 1)] >> 4)\n    arr[curByte++] = tmp & 0xFF\n  }\n\n  if (placeHoldersLen === 1) {\n    tmp =\n      (revLookup[b64.charCodeAt(i)] << 10) |\n      (revLookup[b64.charCodeAt(i + 1)] << 4) |\n      (revLookup[b64.charCodeAt(i + 2)] >> 2)\n    arr[curByte++] = (tmp >> 8) & 0xFF\n    arr[curByte++] = tmp & 0xFF\n  }\n\n  return arr\n}\n\nfunction tripletToBase64 (num) {\n  return lookup[num >> 18 & 0x3F] +\n    lookup[num >> 12 & 0x3F] +\n    lookup[num >> 6 & 0x3F] +\n    lookup[num & 0x3F]\n}\n\nfunction encodeChunk (uint8, start, end) {\n  var tmp\n  var output = []\n  for (var i = start; i < end; i += 3) {\n    tmp =\n      ((uint8[i] << 16) & 0xFF0000) +\n      ((uint8[i + 1] << 8) & 0xFF00) +\n      (uint8[i + 2] & 0xFF)\n    output.push(tripletToBase64(tmp))\n  }\n  return output.join('')\n}\n\nfunction fromByteArray (uint8) {\n  var tmp\n  var len = uint8.length\n  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes\n  var parts = []\n  var maxChunkLength = 16383 // must be multiple of 3\n\n  // go through the array every three bytes, we'll deal with trailing stuff later\n  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {\n    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))\n  }\n\n  // pad the end with zeros, but make sure to not forget the extra bytes\n  if (extraBytes === 1) {\n    tmp = uint8[len - 1]\n    parts.push(\n      lookup[tmp >> 2] +\n      lookup[(tmp << 4) & 0x3F] +\n      '=='\n    )\n  } else if (extraBytes === 2) {\n    tmp = (uint8[len - 2] << 8) + uint8[len - 1]\n    parts.push(\n      lookup[tmp >> 10] +\n      lookup[(tmp >> 4) & 0x3F] +\n      lookup[(tmp << 2) & 0x3F] +\n      '='\n    )\n  }\n\n  return parts.join('')\n}\n\n\n//# sourceURL=webpack:///./node_modules/base64-js/index.js?");

/***/ }),

/***/ "./node_modules/big-rat/add.js":
/*!*************************************!*\
  !*** ./node_modules/big-rat/add.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar rationalize = __webpack_require__(/*! ./lib/rationalize */ \"./node_modules/big-rat/lib/rationalize.js\")\n\nmodule.exports = add\n\nfunction add(a, b) {\n  return rationalize(\n    a[0].mul(b[1]).add(b[0].mul(a[1])),\n    a[1].mul(b[1]))\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/add.js?");

/***/ }),

/***/ "./node_modules/big-rat/cmp.js":
/*!*************************************!*\
  !*** ./node_modules/big-rat/cmp.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = cmp\n\nfunction cmp(a, b) {\n    return a[0].mul(b[1]).cmp(b[0].mul(a[1]))\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/cmp.js?");

/***/ }),

/***/ "./node_modules/big-rat/div.js":
/*!*************************************!*\
  !*** ./node_modules/big-rat/div.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar rationalize = __webpack_require__(/*! ./lib/rationalize */ \"./node_modules/big-rat/lib/rationalize.js\")\n\nmodule.exports = div\n\nfunction div(a, b) {\n  return rationalize(a[0].mul(b[1]), a[1].mul(b[0]))\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/div.js?");

/***/ }),

/***/ "./node_modules/big-rat/index.js":
/*!***************************************!*\
  !*** ./node_modules/big-rat/index.js ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar isRat = __webpack_require__(/*! ./is-rat */ \"./node_modules/big-rat/is-rat.js\")\nvar isBN = __webpack_require__(/*! ./lib/is-bn */ \"./node_modules/big-rat/lib/is-bn.js\")\nvar num2bn = __webpack_require__(/*! ./lib/num-to-bn */ \"./node_modules/big-rat/lib/num-to-bn.js\")\nvar str2bn = __webpack_require__(/*! ./lib/str-to-bn */ \"./node_modules/big-rat/lib/str-to-bn.js\")\nvar rationalize = __webpack_require__(/*! ./lib/rationalize */ \"./node_modules/big-rat/lib/rationalize.js\")\nvar div = __webpack_require__(/*! ./div */ \"./node_modules/big-rat/div.js\")\n\nmodule.exports = makeRational\n\nfunction makeRational(numer, denom) {\n  if(isRat(numer)) {\n    if(denom) {\n      return div(numer, makeRational(denom))\n    }\n    return [numer[0].clone(), numer[1].clone()]\n  }\n  var shift = 0\n  var a, b\n  if(isBN(numer)) {\n    a = numer.clone()\n  } else if(typeof numer === 'string') {\n    a = str2bn(numer)\n  } else if(numer === 0) {\n    return [num2bn(0), num2bn(1)]\n  } else if(numer === Math.floor(numer)) {\n    a = num2bn(numer)\n  } else {\n    while(numer !== Math.floor(numer)) {\n      numer = numer * Math.pow(2, 256)\n      shift -= 256\n    }\n    a = num2bn(numer)\n  }\n  if(isRat(denom)) {\n    a.mul(denom[1])\n    b = denom[0].clone()\n  } else if(isBN(denom)) {\n    b = denom.clone()\n  } else if(typeof denom === 'string') {\n    b = str2bn(denom)\n  } else if(!denom) {\n    b = num2bn(1)\n  } else if(denom === Math.floor(denom)) {\n    b = num2bn(denom)\n  } else {\n    while(denom !== Math.floor(denom)) {\n      denom = denom * Math.pow(2, 256)\n      shift += 256\n    }\n    b = num2bn(denom)\n  }\n  if(shift > 0) {\n    a = a.ushln(shift)\n  } else if(shift < 0) {\n    b = b.ushln(-shift)\n  }\n  return rationalize(a, b)\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/index.js?");

/***/ }),

/***/ "./node_modules/big-rat/is-rat.js":
/*!****************************************!*\
  !*** ./node_modules/big-rat/is-rat.js ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar isBN = __webpack_require__(/*! ./lib/is-bn */ \"./node_modules/big-rat/lib/is-bn.js\")\n\nmodule.exports = isRat\n\nfunction isRat(x) {\n  return Array.isArray(x) && x.length === 2 && isBN(x[0]) && isBN(x[1])\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/is-rat.js?");

/***/ }),

/***/ "./node_modules/big-rat/lib/bn-sign.js":
/*!*********************************************!*\
  !*** ./node_modules/big-rat/lib/bn-sign.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar BN = __webpack_require__(/*! bn.js */ \"./node_modules/bn.js/lib/bn.js\")\n\nmodule.exports = sign\n\nfunction sign (x) {\n  return x.cmp(new BN(0))\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/lib/bn-sign.js?");

/***/ }),

/***/ "./node_modules/big-rat/lib/bn-to-num.js":
/*!***********************************************!*\
  !*** ./node_modules/big-rat/lib/bn-to-num.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar sign = __webpack_require__(/*! ./bn-sign */ \"./node_modules/big-rat/lib/bn-sign.js\")\n\nmodule.exports = bn2num\n\n//TODO: Make this better\nfunction bn2num(b) {\n  var l = b.length\n  var words = b.words\n  var out = 0\n  if (l === 1) {\n    out = words[0]\n  } else if (l === 2) {\n    out = words[0] + (words[1] * 0x4000000)\n  } else {\n    for (var i = 0; i < l; i++) {\n      var w = words[i]\n      out += w * Math.pow(0x4000000, i)\n    }\n  }\n  return sign(b) * out\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/lib/bn-to-num.js?");

/***/ }),

/***/ "./node_modules/big-rat/lib/ctz.js":
/*!*****************************************!*\
  !*** ./node_modules/big-rat/lib/ctz.js ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar db = __webpack_require__(/*! double-bits */ \"./node_modules/double-bits/double.js\")\nvar ctz = __webpack_require__(/*! bit-twiddle */ \"./node_modules/bit-twiddle/twiddle.js\").countTrailingZeros\n\nmodule.exports = ctzNumber\n\n//Counts the number of trailing zeros\nfunction ctzNumber(x) {\n  var l = ctz(db.lo(x))\n  if(l < 32) {\n    return l\n  }\n  var h = ctz(db.hi(x))\n  if(h > 20) {\n    return 52\n  }\n  return h + 32\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/lib/ctz.js?");

/***/ }),

/***/ "./node_modules/big-rat/lib/is-bn.js":
/*!*******************************************!*\
  !*** ./node_modules/big-rat/lib/is-bn.js ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar BN = __webpack_require__(/*! bn.js */ \"./node_modules/bn.js/lib/bn.js\")\n\nmodule.exports = isBN\n\n//Test if x is a bignumber\n//FIXME: obviously this is the wrong way to do it\nfunction isBN(x) {\n  return x && typeof x === 'object' && Boolean(x.words)\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/lib/is-bn.js?");

/***/ }),

/***/ "./node_modules/big-rat/lib/num-to-bn.js":
/*!***********************************************!*\
  !*** ./node_modules/big-rat/lib/num-to-bn.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar BN = __webpack_require__(/*! bn.js */ \"./node_modules/bn.js/lib/bn.js\")\nvar db = __webpack_require__(/*! double-bits */ \"./node_modules/double-bits/double.js\")\n\nmodule.exports = num2bn\n\nfunction num2bn(x) {\n  var e = db.exponent(x)\n  if(e < 52) {\n    return new BN(x)\n  } else {\n    return (new BN(x * Math.pow(2, 52-e))).ushln(e-52)\n  }\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/lib/num-to-bn.js?");

/***/ }),

/***/ "./node_modules/big-rat/lib/rationalize.js":
/*!*************************************************!*\
  !*** ./node_modules/big-rat/lib/rationalize.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar num2bn = __webpack_require__(/*! ./num-to-bn */ \"./node_modules/big-rat/lib/num-to-bn.js\")\nvar sign = __webpack_require__(/*! ./bn-sign */ \"./node_modules/big-rat/lib/bn-sign.js\")\n\nmodule.exports = rationalize\n\nfunction rationalize(numer, denom) {\n  var snumer = sign(numer)\n  var sdenom = sign(denom)\n  if(snumer === 0) {\n    return [num2bn(0), num2bn(1)]\n  }\n  if(sdenom === 0) {\n    return [num2bn(0), num2bn(0)]\n  }\n  if(sdenom < 0) {\n    numer = numer.neg()\n    denom = denom.neg()\n  }\n  var d = numer.gcd(denom)\n  if(d.cmpn(1)) {\n    return [ numer.div(d), denom.div(d) ]\n  }\n  return [ numer, denom ]\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/lib/rationalize.js?");

/***/ }),

/***/ "./node_modules/big-rat/lib/str-to-bn.js":
/*!***********************************************!*\
  !*** ./node_modules/big-rat/lib/str-to-bn.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar BN = __webpack_require__(/*! bn.js */ \"./node_modules/bn.js/lib/bn.js\")\n\nmodule.exports = str2BN\n\nfunction str2BN(x) {\n  return new BN(x)\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/lib/str-to-bn.js?");

/***/ }),

/***/ "./node_modules/big-rat/mul.js":
/*!*************************************!*\
  !*** ./node_modules/big-rat/mul.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar rationalize = __webpack_require__(/*! ./lib/rationalize */ \"./node_modules/big-rat/lib/rationalize.js\")\n\nmodule.exports = mul\n\nfunction mul(a, b) {\n  return rationalize(a[0].mul(b[0]), a[1].mul(b[1]))\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/mul.js?");

/***/ }),

/***/ "./node_modules/big-rat/sign.js":
/*!**************************************!*\
  !*** ./node_modules/big-rat/sign.js ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar bnsign = __webpack_require__(/*! ./lib/bn-sign */ \"./node_modules/big-rat/lib/bn-sign.js\")\n\nmodule.exports = sign\n\nfunction sign(x) {\n  return bnsign(x[0]) * bnsign(x[1])\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/sign.js?");

/***/ }),

/***/ "./node_modules/big-rat/sub.js":
/*!*************************************!*\
  !*** ./node_modules/big-rat/sub.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar rationalize = __webpack_require__(/*! ./lib/rationalize */ \"./node_modules/big-rat/lib/rationalize.js\")\n\nmodule.exports = sub\n\nfunction sub(a, b) {\n  return rationalize(a[0].mul(b[1]).sub(a[1].mul(b[0])), a[1].mul(b[1]))\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/sub.js?");

/***/ }),

/***/ "./node_modules/big-rat/to-float.js":
/*!******************************************!*\
  !*** ./node_modules/big-rat/to-float.js ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar bn2num = __webpack_require__(/*! ./lib/bn-to-num */ \"./node_modules/big-rat/lib/bn-to-num.js\")\nvar ctz = __webpack_require__(/*! ./lib/ctz */ \"./node_modules/big-rat/lib/ctz.js\")\n\nmodule.exports = roundRat\n\n// Round a rational to the closest float\nfunction roundRat (f) {\n  var a = f[0]\n  var b = f[1]\n  if (a.cmpn(0) === 0) {\n    return 0\n  }\n  var h = a.abs().divmod(b.abs())\n  var iv = h.div\n  var x = bn2num(iv)\n  var ir = h.mod\n  var sgn = (a.negative !== b.negative) ? -1 : 1\n  if (ir.cmpn(0) === 0) {\n    return sgn * x\n  }\n  if (x) {\n    var s = ctz(x) + 4\n    var y = bn2num(ir.ushln(s).divRound(b))\n    return sgn * (x + y * Math.pow(2, -s))\n  } else {\n    var ybits = b.bitLength() - ir.bitLength() + 53\n    var y = bn2num(ir.ushln(ybits).divRound(b))\n    if (ybits < 1023) {\n      return sgn * y * Math.pow(2, -ybits)\n    }\n    y *= Math.pow(2, -1023)\n    return sgn * y * Math.pow(2, 1023 - ybits)\n  }\n}\n\n\n//# sourceURL=webpack:///./node_modules/big-rat/to-float.js?");

/***/ }),

/***/ "./node_modules/binary-search-bounds/search-bounds.js":
/*!************************************************************!*\
  !*** ./node_modules/binary-search-bounds/search-bounds.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\n// (a, y, c, l, h) = (array, y[, cmp, lo, hi])\n\nfunction ge(a, y, c, l, h) {\n  var i = h + 1;\n  while (l <= h) {\n    var m = (l + h) >>> 1, x = a[m];\n    var p = (c !== undefined) ? c(x, y) : (x - y);\n    if (p >= 0) { i = m; h = m - 1 } else { l = m + 1 }\n  }\n  return i;\n};\n\nfunction gt(a, y, c, l, h) {\n  var i = h + 1;\n  while (l <= h) {\n    var m = (l + h) >>> 1, x = a[m];\n    var p = (c !== undefined) ? c(x, y) : (x - y);\n    if (p > 0) { i = m; h = m - 1 } else { l = m + 1 }\n  }\n  return i;\n};\n\nfunction lt(a, y, c, l, h) {\n  var i = l - 1;\n  while (l <= h) {\n    var m = (l + h) >>> 1, x = a[m];\n    var p = (c !== undefined) ? c(x, y) : (x - y);\n    if (p < 0) { i = m; l = m + 1 } else { h = m - 1 }\n  }\n  return i;\n};\n\nfunction le(a, y, c, l, h) {\n  var i = l - 1;\n  while (l <= h) {\n    var m = (l + h) >>> 1, x = a[m];\n    var p = (c !== undefined) ? c(x, y) : (x - y);\n    if (p <= 0) { i = m; l = m + 1 } else { h = m - 1 }\n  }\n  return i;\n};\n\nfunction eq(a, y, c, l, h) {\n  while (l <= h) {\n    var m = (l + h) >>> 1, x = a[m];\n    var p = (c !== undefined) ? c(x, y) : (x - y);\n    if (p === 0) { return m }\n    if (p <= 0) { l = m + 1 } else { h = m - 1 }\n  }\n  return -1;\n};\n\nfunction norm(a, y, c, l, h, f) {\n  if (typeof c === 'function') {\n    return f(a, y, c, (l === undefined) ? 0 : l | 0, (h === undefined) ? a.length - 1 : h | 0);\n  }\n  return f(a, y, undefined, (c === undefined) ? 0 : c | 0, (l === undefined) ? a.length - 1 : l | 0);\n}\n\nmodule.exports = {\n  ge: function(a, y, c, l, h) { return norm(a, y, c, l, h, ge)},\n  gt: function(a, y, c, l, h) { return norm(a, y, c, l, h, gt)},\n  lt: function(a, y, c, l, h) { return norm(a, y, c, l, h, lt)},\n  le: function(a, y, c, l, h) { return norm(a, y, c, l, h, le)},\n  eq: function(a, y, c, l, h) { return norm(a, y, c, l, h, eq)}\n}\n\n\n//# sourceURL=webpack:///./node_modules/binary-search-bounds/search-bounds.js?");

/***/ }),

/***/ "./node_modules/bit-twiddle/twiddle.js":
/*!*********************************************!*\
  !*** ./node_modules/bit-twiddle/twiddle.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/**\n * Bit twiddling hacks for JavaScript.\n *\n * Author: Mikola Lysenko\n *\n * Ported from Stanford bit twiddling hack library:\n *    http://graphics.stanford.edu/~seander/bithacks.html\n */\n\n \"use restrict\";\n\n//Number of bits in an integer\nvar INT_BITS = 32;\n\n//Constants\nexports.INT_BITS  = INT_BITS;\nexports.INT_MAX   =  0x7fffffff;\nexports.INT_MIN   = -1<<(INT_BITS-1);\n\n//Returns -1, 0, +1 depending on sign of x\nexports.sign = function(v) {\n  return (v > 0) - (v < 0);\n}\n\n//Computes absolute value of integer\nexports.abs = function(v) {\n  var mask = v >> (INT_BITS-1);\n  return (v ^ mask) - mask;\n}\n\n//Computes minimum of integers x and y\nexports.min = function(x, y) {\n  return y ^ ((x ^ y) & -(x < y));\n}\n\n//Computes maximum of integers x and y\nexports.max = function(x, y) {\n  return x ^ ((x ^ y) & -(x < y));\n}\n\n//Checks if a number is a power of two\nexports.isPow2 = function(v) {\n  return !(v & (v-1)) && (!!v);\n}\n\n//Computes log base 2 of v\nexports.log2 = function(v) {\n  var r, shift;\n  r =     (v > 0xFFFF) << 4; v >>>= r;\n  shift = (v > 0xFF  ) << 3; v >>>= shift; r |= shift;\n  shift = (v > 0xF   ) << 2; v >>>= shift; r |= shift;\n  shift = (v > 0x3   ) << 1; v >>>= shift; r |= shift;\n  return r | (v >> 1);\n}\n\n//Computes log base 10 of v\nexports.log10 = function(v) {\n  return  (v >= 1000000000) ? 9 : (v >= 100000000) ? 8 : (v >= 10000000) ? 7 :\n          (v >= 1000000) ? 6 : (v >= 100000) ? 5 : (v >= 10000) ? 4 :\n          (v >= 1000) ? 3 : (v >= 100) ? 2 : (v >= 10) ? 1 : 0;\n}\n\n//Counts number of bits\nexports.popCount = function(v) {\n  v = v - ((v >>> 1) & 0x55555555);\n  v = (v & 0x33333333) + ((v >>> 2) & 0x33333333);\n  return ((v + (v >>> 4) & 0xF0F0F0F) * 0x1010101) >>> 24;\n}\n\n//Counts number of trailing zeros\nfunction countTrailingZeros(v) {\n  var c = 32;\n  v &= -v;\n  if (v) c--;\n  if (v & 0x0000FFFF) c -= 16;\n  if (v & 0x00FF00FF) c -= 8;\n  if (v & 0x0F0F0F0F) c -= 4;\n  if (v & 0x33333333) c -= 2;\n  if (v & 0x55555555) c -= 1;\n  return c;\n}\nexports.countTrailingZeros = countTrailingZeros;\n\n//Rounds to next power of 2\nexports.nextPow2 = function(v) {\n  v += v === 0;\n  --v;\n  v |= v >>> 1;\n  v |= v >>> 2;\n  v |= v >>> 4;\n  v |= v >>> 8;\n  v |= v >>> 16;\n  return v + 1;\n}\n\n//Rounds down to previous power of 2\nexports.prevPow2 = function(v) {\n  v |= v >>> 1;\n  v |= v >>> 2;\n  v |= v >>> 4;\n  v |= v >>> 8;\n  v |= v >>> 16;\n  return v - (v>>>1);\n}\n\n//Computes parity of word\nexports.parity = function(v) {\n  v ^= v >>> 16;\n  v ^= v >>> 8;\n  v ^= v >>> 4;\n  v &= 0xf;\n  return (0x6996 >>> v) & 1;\n}\n\nvar REVERSE_TABLE = new Array(256);\n\n(function(tab) {\n  for(var i=0; i<256; ++i) {\n    var v = i, r = i, s = 7;\n    for (v >>>= 1; v; v >>>= 1) {\n      r <<= 1;\n      r |= v & 1;\n      --s;\n    }\n    tab[i] = (r << s) & 0xff;\n  }\n})(REVERSE_TABLE);\n\n//Reverse bits in a 32 bit word\nexports.reverse = function(v) {\n  return  (REVERSE_TABLE[ v         & 0xff] << 24) |\n          (REVERSE_TABLE[(v >>> 8)  & 0xff] << 16) |\n          (REVERSE_TABLE[(v >>> 16) & 0xff] << 8)  |\n           REVERSE_TABLE[(v >>> 24) & 0xff];\n}\n\n//Interleave bits of 2 coordinates with 16 bits.  Useful for fast quadtree codes\nexports.interleave2 = function(x, y) {\n  x &= 0xFFFF;\n  x = (x | (x << 8)) & 0x00FF00FF;\n  x = (x | (x << 4)) & 0x0F0F0F0F;\n  x = (x | (x << 2)) & 0x33333333;\n  x = (x | (x << 1)) & 0x55555555;\n\n  y &= 0xFFFF;\n  y = (y | (y << 8)) & 0x00FF00FF;\n  y = (y | (y << 4)) & 0x0F0F0F0F;\n  y = (y | (y << 2)) & 0x33333333;\n  y = (y | (y << 1)) & 0x55555555;\n\n  return x | (y << 1);\n}\n\n//Extracts the nth interleaved component\nexports.deinterleave2 = function(v, n) {\n  v = (v >>> n) & 0x55555555;\n  v = (v | (v >>> 1))  & 0x33333333;\n  v = (v | (v >>> 2))  & 0x0F0F0F0F;\n  v = (v | (v >>> 4))  & 0x00FF00FF;\n  v = (v | (v >>> 16)) & 0x000FFFF;\n  return (v << 16) >> 16;\n}\n\n\n//Interleave bits of 3 coordinates, each with 10 bits.  Useful for fast octree codes\nexports.interleave3 = function(x, y, z) {\n  x &= 0x3FF;\n  x  = (x | (x<<16)) & 4278190335;\n  x  = (x | (x<<8))  & 251719695;\n  x  = (x | (x<<4))  & 3272356035;\n  x  = (x | (x<<2))  & 1227133513;\n\n  y &= 0x3FF;\n  y  = (y | (y<<16)) & 4278190335;\n  y  = (y | (y<<8))  & 251719695;\n  y  = (y | (y<<4))  & 3272356035;\n  y  = (y | (y<<2))  & 1227133513;\n  x |= (y << 1);\n  \n  z &= 0x3FF;\n  z  = (z | (z<<16)) & 4278190335;\n  z  = (z | (z<<8))  & 251719695;\n  z  = (z | (z<<4))  & 3272356035;\n  z  = (z | (z<<2))  & 1227133513;\n  \n  return x | (z << 2);\n}\n\n//Extracts nth interleaved component of a 3-tuple\nexports.deinterleave3 = function(v, n) {\n  v = (v >>> n)       & 1227133513;\n  v = (v | (v>>>2))   & 3272356035;\n  v = (v | (v>>>4))   & 251719695;\n  v = (v | (v>>>8))   & 4278190335;\n  v = (v | (v>>>16))  & 0x3FF;\n  return (v<<22)>>22;\n}\n\n//Computes next combination in colexicographic order (this is mistakenly called nextPermutation on the bit twiddling hacks page)\nexports.nextCombination = function(v) {\n  var t = v | (v - 1);\n  return (t + 1) | (((~t & -~t) - 1) >>> (countTrailingZeros(v) + 1));\n}\n\n\n\n//# sourceURL=webpack:///./node_modules/bit-twiddle/twiddle.js?");

/***/ }),

/***/ "./node_modules/bitmap-sdf/index.js":
/*!******************************************!*\
  !*** ./node_modules/bitmap-sdf/index.js ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\r\n\r\nvar clamp = __webpack_require__(/*! clamp */ \"./node_modules/clamp/index.js\")\r\n\r\nmodule.exports = calcSDF\r\n\r\nvar INF = 1e20;\r\n\r\nfunction calcSDF(src, options) {\r\n    if (!options) options = {}\r\n\r\n    var cutoff = options.cutoff == null ? 0.25 : options.cutoff\r\n    var radius = options.radius == null ? 8 : options.radius\r\n    var channel = options.channel || 0\r\n    var w, h, size, data, intData, stride, ctx, canvas, imgData, i, l\r\n\r\n    // handle image container\r\n    if (ArrayBuffer.isView(src) || Array.isArray(src)) {\r\n        if (!options.width || !options.height) throw Error('For raw data width and height should be provided by options')\r\n        w = options.width, h = options.height\r\n        data = src\r\n\r\n        if (!options.stride) stride = Math.floor(src.length / w / h)\r\n        else stride = options.stride\r\n    }\r\n    else {\r\n        if (window.HTMLCanvasElement && src instanceof window.HTMLCanvasElement) {\r\n            canvas = src\r\n            ctx = canvas.getContext('2d')\r\n            w = canvas.width, h = canvas.height\r\n            imgData = ctx.getImageData(0, 0, w, h)\r\n            data = imgData.data\r\n            stride = 4\r\n        }\r\n        else if (window.CanvasRenderingContext2D && src instanceof window.CanvasRenderingContext2D) {\r\n            canvas = src.canvas\r\n            ctx = src\r\n            w = canvas.width, h = canvas.height\r\n            imgData = ctx.getImageData(0, 0, w, h)\r\n            data = imgData.data\r\n            stride = 4\r\n        }\r\n        else if (window.ImageData && src instanceof window.ImageData) {\r\n            imgData = src\r\n            w = src.width, h = src.height\r\n            data = imgData.data\r\n            stride = 4\r\n        }\r\n    }\r\n\r\n    size = Math.max(w, h)\r\n\r\n    //convert int data to floats\r\n    if ((window.Uint8ClampedArray && data instanceof window.Uint8ClampedArray) || (window.Uint8Array && data instanceof window.Uint8Array)) {\r\n        intData = data\r\n        data = Array(w*h)\r\n\r\n        for (i = 0, l = intData.length; i < l; i++) {\r\n            data[i] = intData[i*stride + channel] / 255\r\n        }\r\n    }\r\n    else {\r\n        if (stride !== 1) throw Error('Raw data can have only 1 value per pixel')\r\n    }\r\n\r\n    // temporary arrays for the distance transform\r\n    var gridOuter = Array(w * h)\r\n    var gridInner = Array(w * h)\r\n    var f = Array(size)\r\n    var d = Array(size)\r\n    var z = Array(size + 1)\r\n    var v = Array(size)\r\n\r\n    for (i = 0, l = w * h; i < l; i++) {\r\n        var a = data[i]\r\n        gridOuter[i] = a === 1 ? 0 : a === 0 ? INF : Math.pow(Math.max(0, 0.5 - a), 2)\r\n        gridInner[i] = a === 1 ? INF : a === 0 ? 0 : Math.pow(Math.max(0, a - 0.5), 2)\r\n    }\r\n\r\n    edt(gridOuter, w, h, f, d, v, z)\r\n    edt(gridInner, w, h, f, d, v, z)\r\n\r\n    var dist = window.Float32Array ? new Float32Array(w * h) : new Array(w * h)\r\n\r\n    for (i = 0, l = w*h; i < l; i++) {\r\n        dist[i] = clamp(1 - ( (gridOuter[i] - gridInner[i]) / radius + cutoff), 0, 1)\r\n    }\r\n\r\n    return dist\r\n}\r\n\r\n// 2D Euclidean distance transform by Felzenszwalb & Huttenlocher https://cs.brown.edu/~pff/dt/\r\nfunction edt(data, width, height, f, d, v, z) {\r\n    for (var x = 0; x < width; x++) {\r\n        for (var y = 0; y < height; y++) {\r\n            f[y] = data[y * width + x]\r\n        }\r\n        edt1d(f, d, v, z, height)\r\n        for (y = 0; y < height; y++) {\r\n            data[y * width + x] = d[y]\r\n        }\r\n    }\r\n    for (y = 0; y < height; y++) {\r\n        for (x = 0; x < width; x++) {\r\n            f[x] = data[y * width + x]\r\n        }\r\n        edt1d(f, d, v, z, width)\r\n        for (x = 0; x < width; x++) {\r\n            data[y * width + x] = Math.sqrt(d[x])\r\n        }\r\n    }\r\n}\r\n\r\n// 1D squared distance transform\r\nfunction edt1d(f, d, v, z, n) {\r\n    v[0] = 0;\r\n    z[0] = -INF\r\n    z[1] = +INF\r\n\r\n    for (var q = 1, k = 0; q < n; q++) {\r\n        var s = ((f[q] + q * q) - (f[v[k]] + v[k] * v[k])) / (2 * q - 2 * v[k])\r\n        while (s <= z[k]) {\r\n            k--\r\n            s = ((f[q] + q * q) - (f[v[k]] + v[k] * v[k])) / (2 * q - 2 * v[k])\r\n        }\r\n        k++\r\n        v[k] = q\r\n        z[k] = s\r\n        z[k + 1] = +INF\r\n    }\r\n\r\n    for (q = 0, k = 0; q < n; q++) {\r\n        while (z[k + 1] < q) k++\r\n        d[q] = (q - v[k]) * (q - v[k]) + f[v[k]]\r\n    }\r\n}\r\n\n\n//# sourceURL=webpack:///./node_modules/bitmap-sdf/index.js?");

/***/ }),

/***/ "./node_modules/bn.js/lib/bn.js":
/*!**************************************!*\
  !*** ./node_modules/bn.js/lib/bn.js ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("/* WEBPACK VAR INJECTION */(function(module) {(function (module, exports) {\n  'use strict';\n\n  // Utils\n  function assert (val, msg) {\n    if (!val) throw new Error(msg || 'Assertion failed');\n  }\n\n  // Could use `inherits` module, but don't want to move from single file\n  // architecture yet.\n  function inherits (ctor, superCtor) {\n    ctor.super_ = superCtor;\n    var TempCtor = function () {};\n    TempCtor.prototype = superCtor.prototype;\n    ctor.prototype = new TempCtor();\n    ctor.prototype.constructor = ctor;\n  }\n\n  // BN\n\n  function BN (number, base, endian) {\n    if (BN.isBN(number)) {\n      return number;\n    }\n\n    this.negative = 0;\n    this.words = null;\n    this.length = 0;\n\n    // Reduction context\n    this.red = null;\n\n    if (number !== null) {\n      if (base === 'le' || base === 'be') {\n        endian = base;\n        base = 10;\n      }\n\n      this._init(number || 0, base || 10, endian || 'be');\n    }\n  }\n  if (typeof module === 'object') {\n    module.exports = BN;\n  } else {\n    exports.BN = BN;\n  }\n\n  BN.BN = BN;\n  BN.wordSize = 26;\n\n  var Buffer;\n  try {\n    Buffer = __webpack_require__(/*! buffer */ 1).Buffer;\n  } catch (e) {\n  }\n\n  BN.isBN = function isBN (num) {\n    if (num instanceof BN) {\n      return true;\n    }\n\n    return num !== null && typeof num === 'object' &&\n      num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);\n  };\n\n  BN.max = function max (left, right) {\n    if (left.cmp(right) > 0) return left;\n    return right;\n  };\n\n  BN.min = function min (left, right) {\n    if (left.cmp(right) < 0) return left;\n    return right;\n  };\n\n  BN.prototype._init = function init (number, base, endian) {\n    if (typeof number === 'number') {\n      return this._initNumber(number, base, endian);\n    }\n\n    if (typeof number === 'object') {\n      return this._initArray(number, base, endian);\n    }\n\n    if (base === 'hex') {\n      base = 16;\n    }\n    assert(base === (base | 0) && base >= 2 && base <= 36);\n\n    number = number.toString().replace(/\\s+/g, '');\n    var start = 0;\n    if (number[0] === '-') {\n      start++;\n    }\n\n    if (base === 16) {\n      this._parseHex(number, start);\n    } else {\n      this._parseBase(number, base, start);\n    }\n\n    if (number[0] === '-') {\n      this.negative = 1;\n    }\n\n    this.strip();\n\n    if (endian !== 'le') return;\n\n    this._initArray(this.toArray(), base, endian);\n  };\n\n  BN.prototype._initNumber = function _initNumber (number, base, endian) {\n    if (number < 0) {\n      this.negative = 1;\n      number = -number;\n    }\n    if (number < 0x4000000) {\n      this.words = [ number & 0x3ffffff ];\n      this.length = 1;\n    } else if (number < 0x10000000000000) {\n      this.words = [\n        number & 0x3ffffff,\n        (number / 0x4000000) & 0x3ffffff\n      ];\n      this.length = 2;\n    } else {\n      assert(number < 0x20000000000000); // 2 ^ 53 (unsafe)\n      this.words = [\n        number & 0x3ffffff,\n        (number / 0x4000000) & 0x3ffffff,\n        1\n      ];\n      this.length = 3;\n    }\n\n    if (endian !== 'le') return;\n\n    // Reverse the bytes\n    this._initArray(this.toArray(), base, endian);\n  };\n\n  BN.prototype._initArray = function _initArray (number, base, endian) {\n    // Perhaps a Uint8Array\n    assert(typeof number.length === 'number');\n    if (number.length <= 0) {\n      this.words = [ 0 ];\n      this.length = 1;\n      return this;\n    }\n\n    this.length = Math.ceil(number.length / 3);\n    this.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      this.words[i] = 0;\n    }\n\n    var j, w;\n    var off = 0;\n    if (endian === 'be') {\n      for (i = number.length - 1, j = 0; i >= 0; i -= 3) {\n        w = number[i] | (number[i - 1] << 8) | (number[i - 2] << 16);\n        this.words[j] |= (w << off) & 0x3ffffff;\n        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;\n        off += 24;\n        if (off >= 26) {\n          off -= 26;\n          j++;\n        }\n      }\n    } else if (endian === 'le') {\n      for (i = 0, j = 0; i < number.length; i += 3) {\n        w = number[i] | (number[i + 1] << 8) | (number[i + 2] << 16);\n        this.words[j] |= (w << off) & 0x3ffffff;\n        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;\n        off += 24;\n        if (off >= 26) {\n          off -= 26;\n          j++;\n        }\n      }\n    }\n    return this.strip();\n  };\n\n  function parseHex (str, start, end) {\n    var r = 0;\n    var len = Math.min(str.length, end);\n    for (var i = start; i < len; i++) {\n      var c = str.charCodeAt(i) - 48;\n\n      r <<= 4;\n\n      // 'a' - 'f'\n      if (c >= 49 && c <= 54) {\n        r |= c - 49 + 0xa;\n\n      // 'A' - 'F'\n      } else if (c >= 17 && c <= 22) {\n        r |= c - 17 + 0xa;\n\n      // '0' - '9'\n      } else {\n        r |= c & 0xf;\n      }\n    }\n    return r;\n  }\n\n  BN.prototype._parseHex = function _parseHex (number, start) {\n    // Create possibly bigger array to ensure that it fits the number\n    this.length = Math.ceil((number.length - start) / 6);\n    this.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      this.words[i] = 0;\n    }\n\n    var j, w;\n    // Scan 24-bit chunks and add them to the number\n    var off = 0;\n    for (i = number.length - 6, j = 0; i >= start; i -= 6) {\n      w = parseHex(number, i, i + 6);\n      this.words[j] |= (w << off) & 0x3ffffff;\n      // NOTE: `0x3fffff` is intentional here, 26bits max shift + 24bit hex limb\n      this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;\n      off += 24;\n      if (off >= 26) {\n        off -= 26;\n        j++;\n      }\n    }\n    if (i + 6 !== start) {\n      w = parseHex(number, start, i + 6);\n      this.words[j] |= (w << off) & 0x3ffffff;\n      this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;\n    }\n    this.strip();\n  };\n\n  function parseBase (str, start, end, mul) {\n    var r = 0;\n    var len = Math.min(str.length, end);\n    for (var i = start; i < len; i++) {\n      var c = str.charCodeAt(i) - 48;\n\n      r *= mul;\n\n      // 'a'\n      if (c >= 49) {\n        r += c - 49 + 0xa;\n\n      // 'A'\n      } else if (c >= 17) {\n        r += c - 17 + 0xa;\n\n      // '0' - '9'\n      } else {\n        r += c;\n      }\n    }\n    return r;\n  }\n\n  BN.prototype._parseBase = function _parseBase (number, base, start) {\n    // Initialize as zero\n    this.words = [ 0 ];\n    this.length = 1;\n\n    // Find length of limb in base\n    for (var limbLen = 0, limbPow = 1; limbPow <= 0x3ffffff; limbPow *= base) {\n      limbLen++;\n    }\n    limbLen--;\n    limbPow = (limbPow / base) | 0;\n\n    var total = number.length - start;\n    var mod = total % limbLen;\n    var end = Math.min(total, total - mod) + start;\n\n    var word = 0;\n    for (var i = start; i < end; i += limbLen) {\n      word = parseBase(number, i, i + limbLen, base);\n\n      this.imuln(limbPow);\n      if (this.words[0] + word < 0x4000000) {\n        this.words[0] += word;\n      } else {\n        this._iaddn(word);\n      }\n    }\n\n    if (mod !== 0) {\n      var pow = 1;\n      word = parseBase(number, i, number.length, base);\n\n      for (i = 0; i < mod; i++) {\n        pow *= base;\n      }\n\n      this.imuln(pow);\n      if (this.words[0] + word < 0x4000000) {\n        this.words[0] += word;\n      } else {\n        this._iaddn(word);\n      }\n    }\n  };\n\n  BN.prototype.copy = function copy (dest) {\n    dest.words = new Array(this.length);\n    for (var i = 0; i < this.length; i++) {\n      dest.words[i] = this.words[i];\n    }\n    dest.length = this.length;\n    dest.negative = this.negative;\n    dest.red = this.red;\n  };\n\n  BN.prototype.clone = function clone () {\n    var r = new BN(null);\n    this.copy(r);\n    return r;\n  };\n\n  BN.prototype._expand = function _expand (size) {\n    while (this.length < size) {\n      this.words[this.length++] = 0;\n    }\n    return this;\n  };\n\n  // Remove leading `0` from `this`\n  BN.prototype.strip = function strip () {\n    while (this.length > 1 && this.words[this.length - 1] === 0) {\n      this.length--;\n    }\n    return this._normSign();\n  };\n\n  BN.prototype._normSign = function _normSign () {\n    // -0 = 0\n    if (this.length === 1 && this.words[0] === 0) {\n      this.negative = 0;\n    }\n    return this;\n  };\n\n  BN.prototype.inspect = function inspect () {\n    return (this.red ? '<BN-R: ' : '<BN: ') + this.toString(16) + '>';\n  };\n\n  /*\n\n  var zeros = [];\n  var groupSizes = [];\n  var groupBases = [];\n\n  var s = '';\n  var i = -1;\n  while (++i < BN.wordSize) {\n    zeros[i] = s;\n    s += '0';\n  }\n  groupSizes[0] = 0;\n  groupSizes[1] = 0;\n  groupBases[0] = 0;\n  groupBases[1] = 0;\n  var base = 2 - 1;\n  while (++base < 36 + 1) {\n    var groupSize = 0;\n    var groupBase = 1;\n    while (groupBase < (1 << BN.wordSize) / base) {\n      groupBase *= base;\n      groupSize += 1;\n    }\n    groupSizes[base] = groupSize;\n    groupBases[base] = groupBase;\n  }\n\n  */\n\n  var zeros = [\n    '',\n    '0',\n    '00',\n    '000',\n    '0000',\n    '00000',\n    '000000',\n    '0000000',\n    '00000000',\n    '000000000',\n    '0000000000',\n    '00000000000',\n    '000000000000',\n    '0000000000000',\n    '00000000000000',\n    '000000000000000',\n    '0000000000000000',\n    '00000000000000000',\n    '000000000000000000',\n    '0000000000000000000',\n    '00000000000000000000',\n    '000000000000000000000',\n    '0000000000000000000000',\n    '00000000000000000000000',\n    '000000000000000000000000',\n    '0000000000000000000000000'\n  ];\n\n  var groupSizes = [\n    0, 0,\n    25, 16, 12, 11, 10, 9, 8,\n    8, 7, 7, 7, 7, 6, 6,\n    6, 6, 6, 6, 6, 5, 5,\n    5, 5, 5, 5, 5, 5, 5,\n    5, 5, 5, 5, 5, 5, 5\n  ];\n\n  var groupBases = [\n    0, 0,\n    33554432, 43046721, 16777216, 48828125, 60466176, 40353607, 16777216,\n    43046721, 10000000, 19487171, 35831808, 62748517, 7529536, 11390625,\n    16777216, 24137569, 34012224, 47045881, 64000000, 4084101, 5153632,\n    6436343, 7962624, 9765625, 11881376, 14348907, 17210368, 20511149,\n    24300000, 28629151, 33554432, 39135393, 45435424, 52521875, 60466176\n  ];\n\n  BN.prototype.toString = function toString (base, padding) {\n    base = base || 10;\n    padding = padding | 0 || 1;\n\n    var out;\n    if (base === 16 || base === 'hex') {\n      out = '';\n      var off = 0;\n      var carry = 0;\n      for (var i = 0; i < this.length; i++) {\n        var w = this.words[i];\n        var word = (((w << off) | carry) & 0xffffff).toString(16);\n        carry = (w >>> (24 - off)) & 0xffffff;\n        if (carry !== 0 || i !== this.length - 1) {\n          out = zeros[6 - word.length] + word + out;\n        } else {\n          out = word + out;\n        }\n        off += 2;\n        if (off >= 26) {\n          off -= 26;\n          i--;\n        }\n      }\n      if (carry !== 0) {\n        out = carry.toString(16) + out;\n      }\n      while (out.length % padding !== 0) {\n        out = '0' + out;\n      }\n      if (this.negative !== 0) {\n        out = '-' + out;\n      }\n      return out;\n    }\n\n    if (base === (base | 0) && base >= 2 && base <= 36) {\n      // var groupSize = Math.floor(BN.wordSize * Math.LN2 / Math.log(base));\n      var groupSize = groupSizes[base];\n      // var groupBase = Math.pow(base, groupSize);\n      var groupBase = groupBases[base];\n      out = '';\n      var c = this.clone();\n      c.negative = 0;\n      while (!c.isZero()) {\n        var r = c.modn(groupBase).toString(base);\n        c = c.idivn(groupBase);\n\n        if (!c.isZero()) {\n          out = zeros[groupSize - r.length] + r + out;\n        } else {\n          out = r + out;\n        }\n      }\n      if (this.isZero()) {\n        out = '0' + out;\n      }\n      while (out.length % padding !== 0) {\n        out = '0' + out;\n      }\n      if (this.negative !== 0) {\n        out = '-' + out;\n      }\n      return out;\n    }\n\n    assert(false, 'Base should be between 2 and 36');\n  };\n\n  BN.prototype.toNumber = function toNumber () {\n    var ret = this.words[0];\n    if (this.length === 2) {\n      ret += this.words[1] * 0x4000000;\n    } else if (this.length === 3 && this.words[2] === 0x01) {\n      // NOTE: at this stage it is known that the top bit is set\n      ret += 0x10000000000000 + (this.words[1] * 0x4000000);\n    } else if (this.length > 2) {\n      assert(false, 'Number can only safely store up to 53 bits');\n    }\n    return (this.negative !== 0) ? -ret : ret;\n  };\n\n  BN.prototype.toJSON = function toJSON () {\n    return this.toString(16);\n  };\n\n  BN.prototype.toBuffer = function toBuffer (endian, length) {\n    assert(typeof Buffer !== 'undefined');\n    return this.toArrayLike(Buffer, endian, length);\n  };\n\n  BN.prototype.toArray = function toArray (endian, length) {\n    return this.toArrayLike(Array, endian, length);\n  };\n\n  BN.prototype.toArrayLike = function toArrayLike (ArrayType, endian, length) {\n    var byteLength = this.byteLength();\n    var reqLength = length || Math.max(1, byteLength);\n    assert(byteLength <= reqLength, 'byte array longer than desired length');\n    assert(reqLength > 0, 'Requested array length <= 0');\n\n    this.strip();\n    var littleEndian = endian === 'le';\n    var res = new ArrayType(reqLength);\n\n    var b, i;\n    var q = this.clone();\n    if (!littleEndian) {\n      // Assume big-endian\n      for (i = 0; i < reqLength - byteLength; i++) {\n        res[i] = 0;\n      }\n\n      for (i = 0; !q.isZero(); i++) {\n        b = q.andln(0xff);\n        q.iushrn(8);\n\n        res[reqLength - i - 1] = b;\n      }\n    } else {\n      for (i = 0; !q.isZero(); i++) {\n        b = q.andln(0xff);\n        q.iushrn(8);\n\n        res[i] = b;\n      }\n\n      for (; i < reqLength; i++) {\n        res[i] = 0;\n      }\n    }\n\n    return res;\n  };\n\n  if (Math.clz32) {\n    BN.prototype._countBits = function _countBits (w) {\n      return 32 - Math.clz32(w);\n    };\n  } else {\n    BN.prototype._countBits = function _countBits (w) {\n      var t = w;\n      var r = 0;\n      if (t >= 0x1000) {\n        r += 13;\n        t >>>= 13;\n      }\n      if (t >= 0x40) {\n        r += 7;\n        t >>>= 7;\n      }\n      if (t >= 0x8) {\n        r += 4;\n        t >>>= 4;\n      }\n      if (t >= 0x02) {\n        r += 2;\n        t >>>= 2;\n      }\n      return r + t;\n    };\n  }\n\n  BN.prototype._zeroBits = function _zeroBits (w) {\n    // Short-cut\n    if (w === 0) return 26;\n\n    var t = w;\n    var r = 0;\n    if ((t & 0x1fff) === 0) {\n      r += 13;\n      t >>>= 13;\n    }\n    if ((t & 0x7f) === 0) {\n      r += 7;\n      t >>>= 7;\n    }\n    if ((t & 0xf) === 0) {\n      r += 4;\n      t >>>= 4;\n    }\n    if ((t & 0x3) === 0) {\n      r += 2;\n      t >>>= 2;\n    }\n    if ((t & 0x1) === 0) {\n      r++;\n    }\n    return r;\n  };\n\n  // Return number of used bits in a BN\n  BN.prototype.bitLength = function bitLength () {\n    var w = this.words[this.length - 1];\n    var hi = this._countBits(w);\n    return (this.length - 1) * 26 + hi;\n  };\n\n  function toBitArray (num) {\n    var w = new Array(num.bitLength());\n\n    for (var bit = 0; bit < w.length; bit++) {\n      var off = (bit / 26) | 0;\n      var wbit = bit % 26;\n\n      w[bit] = (num.words[off] & (1 << wbit)) >>> wbit;\n    }\n\n    return w;\n  }\n\n  // Number of trailing zero bits\n  BN.prototype.zeroBits = function zeroBits () {\n    if (this.isZero()) return 0;\n\n    var r = 0;\n    for (var i = 0; i < this.length; i++) {\n      var b = this._zeroBits(this.words[i]);\n      r += b;\n      if (b !== 26) break;\n    }\n    return r;\n  };\n\n  BN.prototype.byteLength = function byteLength () {\n    return Math.ceil(this.bitLength() / 8);\n  };\n\n  BN.prototype.toTwos = function toTwos (width) {\n    if (this.negative !== 0) {\n      return this.abs().inotn(width).iaddn(1);\n    }\n    return this.clone();\n  };\n\n  BN.prototype.fromTwos = function fromTwos (width) {\n    if (this.testn(width - 1)) {\n      return this.notn(width).iaddn(1).ineg();\n    }\n    return this.clone();\n  };\n\n  BN.prototype.isNeg = function isNeg () {\n    return this.negative !== 0;\n  };\n\n  // Return negative clone of `this`\n  BN.prototype.neg = function neg () {\n    return this.clone().ineg();\n  };\n\n  BN.prototype.ineg = function ineg () {\n    if (!this.isZero()) {\n      this.negative ^= 1;\n    }\n\n    return this;\n  };\n\n  // Or `num` with `this` in-place\n  BN.prototype.iuor = function iuor (num) {\n    while (this.length < num.length) {\n      this.words[this.length++] = 0;\n    }\n\n    for (var i = 0; i < num.length; i++) {\n      this.words[i] = this.words[i] | num.words[i];\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.ior = function ior (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuor(num);\n  };\n\n  // Or `num` with `this`\n  BN.prototype.or = function or (num) {\n    if (this.length > num.length) return this.clone().ior(num);\n    return num.clone().ior(this);\n  };\n\n  BN.prototype.uor = function uor (num) {\n    if (this.length > num.length) return this.clone().iuor(num);\n    return num.clone().iuor(this);\n  };\n\n  // And `num` with `this` in-place\n  BN.prototype.iuand = function iuand (num) {\n    // b = min-length(num, this)\n    var b;\n    if (this.length > num.length) {\n      b = num;\n    } else {\n      b = this;\n    }\n\n    for (var i = 0; i < b.length; i++) {\n      this.words[i] = this.words[i] & num.words[i];\n    }\n\n    this.length = b.length;\n\n    return this.strip();\n  };\n\n  BN.prototype.iand = function iand (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuand(num);\n  };\n\n  // And `num` with `this`\n  BN.prototype.and = function and (num) {\n    if (this.length > num.length) return this.clone().iand(num);\n    return num.clone().iand(this);\n  };\n\n  BN.prototype.uand = function uand (num) {\n    if (this.length > num.length) return this.clone().iuand(num);\n    return num.clone().iuand(this);\n  };\n\n  // Xor `num` with `this` in-place\n  BN.prototype.iuxor = function iuxor (num) {\n    // a.length > b.length\n    var a;\n    var b;\n    if (this.length > num.length) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    for (var i = 0; i < b.length; i++) {\n      this.words[i] = a.words[i] ^ b.words[i];\n    }\n\n    if (this !== a) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    this.length = a.length;\n\n    return this.strip();\n  };\n\n  BN.prototype.ixor = function ixor (num) {\n    assert((this.negative | num.negative) === 0);\n    return this.iuxor(num);\n  };\n\n  // Xor `num` with `this`\n  BN.prototype.xor = function xor (num) {\n    if (this.length > num.length) return this.clone().ixor(num);\n    return num.clone().ixor(this);\n  };\n\n  BN.prototype.uxor = function uxor (num) {\n    if (this.length > num.length) return this.clone().iuxor(num);\n    return num.clone().iuxor(this);\n  };\n\n  // Not ``this`` with ``width`` bitwidth\n  BN.prototype.inotn = function inotn (width) {\n    assert(typeof width === 'number' && width >= 0);\n\n    var bytesNeeded = Math.ceil(width / 26) | 0;\n    var bitsLeft = width % 26;\n\n    // Extend the buffer with leading zeroes\n    this._expand(bytesNeeded);\n\n    if (bitsLeft > 0) {\n      bytesNeeded--;\n    }\n\n    // Handle complete words\n    for (var i = 0; i < bytesNeeded; i++) {\n      this.words[i] = ~this.words[i] & 0x3ffffff;\n    }\n\n    // Handle the residue\n    if (bitsLeft > 0) {\n      this.words[i] = ~this.words[i] & (0x3ffffff >> (26 - bitsLeft));\n    }\n\n    // And remove leading zeroes\n    return this.strip();\n  };\n\n  BN.prototype.notn = function notn (width) {\n    return this.clone().inotn(width);\n  };\n\n  // Set `bit` of `this`\n  BN.prototype.setn = function setn (bit, val) {\n    assert(typeof bit === 'number' && bit >= 0);\n\n    var off = (bit / 26) | 0;\n    var wbit = bit % 26;\n\n    this._expand(off + 1);\n\n    if (val) {\n      this.words[off] = this.words[off] | (1 << wbit);\n    } else {\n      this.words[off] = this.words[off] & ~(1 << wbit);\n    }\n\n    return this.strip();\n  };\n\n  // Add `num` to `this` in-place\n  BN.prototype.iadd = function iadd (num) {\n    var r;\n\n    // negative + positive\n    if (this.negative !== 0 && num.negative === 0) {\n      this.negative = 0;\n      r = this.isub(num);\n      this.negative ^= 1;\n      return this._normSign();\n\n    // positive + negative\n    } else if (this.negative === 0 && num.negative !== 0) {\n      num.negative = 0;\n      r = this.isub(num);\n      num.negative = 1;\n      return r._normSign();\n    }\n\n    // a.length > b.length\n    var a, b;\n    if (this.length > num.length) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    var carry = 0;\n    for (var i = 0; i < b.length; i++) {\n      r = (a.words[i] | 0) + (b.words[i] | 0) + carry;\n      this.words[i] = r & 0x3ffffff;\n      carry = r >>> 26;\n    }\n    for (; carry !== 0 && i < a.length; i++) {\n      r = (a.words[i] | 0) + carry;\n      this.words[i] = r & 0x3ffffff;\n      carry = r >>> 26;\n    }\n\n    this.length = a.length;\n    if (carry !== 0) {\n      this.words[this.length] = carry;\n      this.length++;\n    // Copy the rest of the words\n    } else if (a !== this) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    return this;\n  };\n\n  // Add `num` to `this`\n  BN.prototype.add = function add (num) {\n    var res;\n    if (num.negative !== 0 && this.negative === 0) {\n      num.negative = 0;\n      res = this.sub(num);\n      num.negative ^= 1;\n      return res;\n    } else if (num.negative === 0 && this.negative !== 0) {\n      this.negative = 0;\n      res = num.sub(this);\n      this.negative = 1;\n      return res;\n    }\n\n    if (this.length > num.length) return this.clone().iadd(num);\n\n    return num.clone().iadd(this);\n  };\n\n  // Subtract `num` from `this` in-place\n  BN.prototype.isub = function isub (num) {\n    // this - (-num) = this + num\n    if (num.negative !== 0) {\n      num.negative = 0;\n      var r = this.iadd(num);\n      num.negative = 1;\n      return r._normSign();\n\n    // -this - num = -(this + num)\n    } else if (this.negative !== 0) {\n      this.negative = 0;\n      this.iadd(num);\n      this.negative = 1;\n      return this._normSign();\n    }\n\n    // At this point both numbers are positive\n    var cmp = this.cmp(num);\n\n    // Optimization - zeroify\n    if (cmp === 0) {\n      this.negative = 0;\n      this.length = 1;\n      this.words[0] = 0;\n      return this;\n    }\n\n    // a > b\n    var a, b;\n    if (cmp > 0) {\n      a = this;\n      b = num;\n    } else {\n      a = num;\n      b = this;\n    }\n\n    var carry = 0;\n    for (var i = 0; i < b.length; i++) {\n      r = (a.words[i] | 0) - (b.words[i] | 0) + carry;\n      carry = r >> 26;\n      this.words[i] = r & 0x3ffffff;\n    }\n    for (; carry !== 0 && i < a.length; i++) {\n      r = (a.words[i] | 0) + carry;\n      carry = r >> 26;\n      this.words[i] = r & 0x3ffffff;\n    }\n\n    // Copy rest of the words\n    if (carry === 0 && i < a.length && a !== this) {\n      for (; i < a.length; i++) {\n        this.words[i] = a.words[i];\n      }\n    }\n\n    this.length = Math.max(this.length, i);\n\n    if (a !== this) {\n      this.negative = 1;\n    }\n\n    return this.strip();\n  };\n\n  // Subtract `num` from `this`\n  BN.prototype.sub = function sub (num) {\n    return this.clone().isub(num);\n  };\n\n  function smallMulTo (self, num, out) {\n    out.negative = num.negative ^ self.negative;\n    var len = (self.length + num.length) | 0;\n    out.length = len;\n    len = (len - 1) | 0;\n\n    // Peel one iteration (compiler can't do it, because of code complexity)\n    var a = self.words[0] | 0;\n    var b = num.words[0] | 0;\n    var r = a * b;\n\n    var lo = r & 0x3ffffff;\n    var carry = (r / 0x4000000) | 0;\n    out.words[0] = lo;\n\n    for (var k = 1; k < len; k++) {\n      // Sum all words with the same `i + j = k` and accumulate `ncarry`,\n      // note that ncarry could be >= 0x3ffffff\n      var ncarry = carry >>> 26;\n      var rword = carry & 0x3ffffff;\n      var maxJ = Math.min(k, num.length - 1);\n      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {\n        var i = (k - j) | 0;\n        a = self.words[i] | 0;\n        b = num.words[j] | 0;\n        r = a * b + rword;\n        ncarry += (r / 0x4000000) | 0;\n        rword = r & 0x3ffffff;\n      }\n      out.words[k] = rword | 0;\n      carry = ncarry | 0;\n    }\n    if (carry !== 0) {\n      out.words[k] = carry | 0;\n    } else {\n      out.length--;\n    }\n\n    return out.strip();\n  }\n\n  // TODO(indutny): it may be reasonable to omit it for users who don't need\n  // to work with 256-bit numbers, otherwise it gives 20% improvement for 256-bit\n  // multiplication (like elliptic secp256k1).\n  var comb10MulTo = function comb10MulTo (self, num, out) {\n    var a = self.words;\n    var b = num.words;\n    var o = out.words;\n    var c = 0;\n    var lo;\n    var mid;\n    var hi;\n    var a0 = a[0] | 0;\n    var al0 = a0 & 0x1fff;\n    var ah0 = a0 >>> 13;\n    var a1 = a[1] | 0;\n    var al1 = a1 & 0x1fff;\n    var ah1 = a1 >>> 13;\n    var a2 = a[2] | 0;\n    var al2 = a2 & 0x1fff;\n    var ah2 = a2 >>> 13;\n    var a3 = a[3] | 0;\n    var al3 = a3 & 0x1fff;\n    var ah3 = a3 >>> 13;\n    var a4 = a[4] | 0;\n    var al4 = a4 & 0x1fff;\n    var ah4 = a4 >>> 13;\n    var a5 = a[5] | 0;\n    var al5 = a5 & 0x1fff;\n    var ah5 = a5 >>> 13;\n    var a6 = a[6] | 0;\n    var al6 = a6 & 0x1fff;\n    var ah6 = a6 >>> 13;\n    var a7 = a[7] | 0;\n    var al7 = a7 & 0x1fff;\n    var ah7 = a7 >>> 13;\n    var a8 = a[8] | 0;\n    var al8 = a8 & 0x1fff;\n    var ah8 = a8 >>> 13;\n    var a9 = a[9] | 0;\n    var al9 = a9 & 0x1fff;\n    var ah9 = a9 >>> 13;\n    var b0 = b[0] | 0;\n    var bl0 = b0 & 0x1fff;\n    var bh0 = b0 >>> 13;\n    var b1 = b[1] | 0;\n    var bl1 = b1 & 0x1fff;\n    var bh1 = b1 >>> 13;\n    var b2 = b[2] | 0;\n    var bl2 = b2 & 0x1fff;\n    var bh2 = b2 >>> 13;\n    var b3 = b[3] | 0;\n    var bl3 = b3 & 0x1fff;\n    var bh3 = b3 >>> 13;\n    var b4 = b[4] | 0;\n    var bl4 = b4 & 0x1fff;\n    var bh4 = b4 >>> 13;\n    var b5 = b[5] | 0;\n    var bl5 = b5 & 0x1fff;\n    var bh5 = b5 >>> 13;\n    var b6 = b[6] | 0;\n    var bl6 = b6 & 0x1fff;\n    var bh6 = b6 >>> 13;\n    var b7 = b[7] | 0;\n    var bl7 = b7 & 0x1fff;\n    var bh7 = b7 >>> 13;\n    var b8 = b[8] | 0;\n    var bl8 = b8 & 0x1fff;\n    var bh8 = b8 >>> 13;\n    var b9 = b[9] | 0;\n    var bl9 = b9 & 0x1fff;\n    var bh9 = b9 >>> 13;\n\n    out.negative = self.negative ^ num.negative;\n    out.length = 19;\n    /* k = 0 */\n    lo = Math.imul(al0, bl0);\n    mid = Math.imul(al0, bh0);\n    mid = (mid + Math.imul(ah0, bl0)) | 0;\n    hi = Math.imul(ah0, bh0);\n    var w0 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w0 >>> 26)) | 0;\n    w0 &= 0x3ffffff;\n    /* k = 1 */\n    lo = Math.imul(al1, bl0);\n    mid = Math.imul(al1, bh0);\n    mid = (mid + Math.imul(ah1, bl0)) | 0;\n    hi = Math.imul(ah1, bh0);\n    lo = (lo + Math.imul(al0, bl1)) | 0;\n    mid = (mid + Math.imul(al0, bh1)) | 0;\n    mid = (mid + Math.imul(ah0, bl1)) | 0;\n    hi = (hi + Math.imul(ah0, bh1)) | 0;\n    var w1 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w1 >>> 26)) | 0;\n    w1 &= 0x3ffffff;\n    /* k = 2 */\n    lo = Math.imul(al2, bl0);\n    mid = Math.imul(al2, bh0);\n    mid = (mid + Math.imul(ah2, bl0)) | 0;\n    hi = Math.imul(ah2, bh0);\n    lo = (lo + Math.imul(al1, bl1)) | 0;\n    mid = (mid + Math.imul(al1, bh1)) | 0;\n    mid = (mid + Math.imul(ah1, bl1)) | 0;\n    hi = (hi + Math.imul(ah1, bh1)) | 0;\n    lo = (lo + Math.imul(al0, bl2)) | 0;\n    mid = (mid + Math.imul(al0, bh2)) | 0;\n    mid = (mid + Math.imul(ah0, bl2)) | 0;\n    hi = (hi + Math.imul(ah0, bh2)) | 0;\n    var w2 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w2 >>> 26)) | 0;\n    w2 &= 0x3ffffff;\n    /* k = 3 */\n    lo = Math.imul(al3, bl0);\n    mid = Math.imul(al3, bh0);\n    mid = (mid + Math.imul(ah3, bl0)) | 0;\n    hi = Math.imul(ah3, bh0);\n    lo = (lo + Math.imul(al2, bl1)) | 0;\n    mid = (mid + Math.imul(al2, bh1)) | 0;\n    mid = (mid + Math.imul(ah2, bl1)) | 0;\n    hi = (hi + Math.imul(ah2, bh1)) | 0;\n    lo = (lo + Math.imul(al1, bl2)) | 0;\n    mid = (mid + Math.imul(al1, bh2)) | 0;\n    mid = (mid + Math.imul(ah1, bl2)) | 0;\n    hi = (hi + Math.imul(ah1, bh2)) | 0;\n    lo = (lo + Math.imul(al0, bl3)) | 0;\n    mid = (mid + Math.imul(al0, bh3)) | 0;\n    mid = (mid + Math.imul(ah0, bl3)) | 0;\n    hi = (hi + Math.imul(ah0, bh3)) | 0;\n    var w3 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w3 >>> 26)) | 0;\n    w3 &= 0x3ffffff;\n    /* k = 4 */\n    lo = Math.imul(al4, bl0);\n    mid = Math.imul(al4, bh0);\n    mid = (mid + Math.imul(ah4, bl0)) | 0;\n    hi = Math.imul(ah4, bh0);\n    lo = (lo + Math.imul(al3, bl1)) | 0;\n    mid = (mid + Math.imul(al3, bh1)) | 0;\n    mid = (mid + Math.imul(ah3, bl1)) | 0;\n    hi = (hi + Math.imul(ah3, bh1)) | 0;\n    lo = (lo + Math.imul(al2, bl2)) | 0;\n    mid = (mid + Math.imul(al2, bh2)) | 0;\n    mid = (mid + Math.imul(ah2, bl2)) | 0;\n    hi = (hi + Math.imul(ah2, bh2)) | 0;\n    lo = (lo + Math.imul(al1, bl3)) | 0;\n    mid = (mid + Math.imul(al1, bh3)) | 0;\n    mid = (mid + Math.imul(ah1, bl3)) | 0;\n    hi = (hi + Math.imul(ah1, bh3)) | 0;\n    lo = (lo + Math.imul(al0, bl4)) | 0;\n    mid = (mid + Math.imul(al0, bh4)) | 0;\n    mid = (mid + Math.imul(ah0, bl4)) | 0;\n    hi = (hi + Math.imul(ah0, bh4)) | 0;\n    var w4 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w4 >>> 26)) | 0;\n    w4 &= 0x3ffffff;\n    /* k = 5 */\n    lo = Math.imul(al5, bl0);\n    mid = Math.imul(al5, bh0);\n    mid = (mid + Math.imul(ah5, bl0)) | 0;\n    hi = Math.imul(ah5, bh0);\n    lo = (lo + Math.imul(al4, bl1)) | 0;\n    mid = (mid + Math.imul(al4, bh1)) | 0;\n    mid = (mid + Math.imul(ah4, bl1)) | 0;\n    hi = (hi + Math.imul(ah4, bh1)) | 0;\n    lo = (lo + Math.imul(al3, bl2)) | 0;\n    mid = (mid + Math.imul(al3, bh2)) | 0;\n    mid = (mid + Math.imul(ah3, bl2)) | 0;\n    hi = (hi + Math.imul(ah3, bh2)) | 0;\n    lo = (lo + Math.imul(al2, bl3)) | 0;\n    mid = (mid + Math.imul(al2, bh3)) | 0;\n    mid = (mid + Math.imul(ah2, bl3)) | 0;\n    hi = (hi + Math.imul(ah2, bh3)) | 0;\n    lo = (lo + Math.imul(al1, bl4)) | 0;\n    mid = (mid + Math.imul(al1, bh4)) | 0;\n    mid = (mid + Math.imul(ah1, bl4)) | 0;\n    hi = (hi + Math.imul(ah1, bh4)) | 0;\n    lo = (lo + Math.imul(al0, bl5)) | 0;\n    mid = (mid + Math.imul(al0, bh5)) | 0;\n    mid = (mid + Math.imul(ah0, bl5)) | 0;\n    hi = (hi + Math.imul(ah0, bh5)) | 0;\n    var w5 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w5 >>> 26)) | 0;\n    w5 &= 0x3ffffff;\n    /* k = 6 */\n    lo = Math.imul(al6, bl0);\n    mid = Math.imul(al6, bh0);\n    mid = (mid + Math.imul(ah6, bl0)) | 0;\n    hi = Math.imul(ah6, bh0);\n    lo = (lo + Math.imul(al5, bl1)) | 0;\n    mid = (mid + Math.imul(al5, bh1)) | 0;\n    mid = (mid + Math.imul(ah5, bl1)) | 0;\n    hi = (hi + Math.imul(ah5, bh1)) | 0;\n    lo = (lo + Math.imul(al4, bl2)) | 0;\n    mid = (mid + Math.imul(al4, bh2)) | 0;\n    mid = (mid + Math.imul(ah4, bl2)) | 0;\n    hi = (hi + Math.imul(ah4, bh2)) | 0;\n    lo = (lo + Math.imul(al3, bl3)) | 0;\n    mid = (mid + Math.imul(al3, bh3)) | 0;\n    mid = (mid + Math.imul(ah3, bl3)) | 0;\n    hi = (hi + Math.imul(ah3, bh3)) | 0;\n    lo = (lo + Math.imul(al2, bl4)) | 0;\n    mid = (mid + Math.imul(al2, bh4)) | 0;\n    mid = (mid + Math.imul(ah2, bl4)) | 0;\n    hi = (hi + Math.imul(ah2, bh4)) | 0;\n    lo = (lo + Math.imul(al1, bl5)) | 0;\n    mid = (mid + Math.imul(al1, bh5)) | 0;\n    mid = (mid + Math.imul(ah1, bl5)) | 0;\n    hi = (hi + Math.imul(ah1, bh5)) | 0;\n    lo = (lo + Math.imul(al0, bl6)) | 0;\n    mid = (mid + Math.imul(al0, bh6)) | 0;\n    mid = (mid + Math.imul(ah0, bl6)) | 0;\n    hi = (hi + Math.imul(ah0, bh6)) | 0;\n    var w6 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w6 >>> 26)) | 0;\n    w6 &= 0x3ffffff;\n    /* k = 7 */\n    lo = Math.imul(al7, bl0);\n    mid = Math.imul(al7, bh0);\n    mid = (mid + Math.imul(ah7, bl0)) | 0;\n    hi = Math.imul(ah7, bh0);\n    lo = (lo + Math.imul(al6, bl1)) | 0;\n    mid = (mid + Math.imul(al6, bh1)) | 0;\n    mid = (mid + Math.imul(ah6, bl1)) | 0;\n    hi = (hi + Math.imul(ah6, bh1)) | 0;\n    lo = (lo + Math.imul(al5, bl2)) | 0;\n    mid = (mid + Math.imul(al5, bh2)) | 0;\n    mid = (mid + Math.imul(ah5, bl2)) | 0;\n    hi = (hi + Math.imul(ah5, bh2)) | 0;\n    lo = (lo + Math.imul(al4, bl3)) | 0;\n    mid = (mid + Math.imul(al4, bh3)) | 0;\n    mid = (mid + Math.imul(ah4, bl3)) | 0;\n    hi = (hi + Math.imul(ah4, bh3)) | 0;\n    lo = (lo + Math.imul(al3, bl4)) | 0;\n    mid = (mid + Math.imul(al3, bh4)) | 0;\n    mid = (mid + Math.imul(ah3, bl4)) | 0;\n    hi = (hi + Math.imul(ah3, bh4)) | 0;\n    lo = (lo + Math.imul(al2, bl5)) | 0;\n    mid = (mid + Math.imul(al2, bh5)) | 0;\n    mid = (mid + Math.imul(ah2, bl5)) | 0;\n    hi = (hi + Math.imul(ah2, bh5)) | 0;\n    lo = (lo + Math.imul(al1, bl6)) | 0;\n    mid = (mid + Math.imul(al1, bh6)) | 0;\n    mid = (mid + Math.imul(ah1, bl6)) | 0;\n    hi = (hi + Math.imul(ah1, bh6)) | 0;\n    lo = (lo + Math.imul(al0, bl7)) | 0;\n    mid = (mid + Math.imul(al0, bh7)) | 0;\n    mid = (mid + Math.imul(ah0, bl7)) | 0;\n    hi = (hi + Math.imul(ah0, bh7)) | 0;\n    var w7 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w7 >>> 26)) | 0;\n    w7 &= 0x3ffffff;\n    /* k = 8 */\n    lo = Math.imul(al8, bl0);\n    mid = Math.imul(al8, bh0);\n    mid = (mid + Math.imul(ah8, bl0)) | 0;\n    hi = Math.imul(ah8, bh0);\n    lo = (lo + Math.imul(al7, bl1)) | 0;\n    mid = (mid + Math.imul(al7, bh1)) | 0;\n    mid = (mid + Math.imul(ah7, bl1)) | 0;\n    hi = (hi + Math.imul(ah7, bh1)) | 0;\n    lo = (lo + Math.imul(al6, bl2)) | 0;\n    mid = (mid + Math.imul(al6, bh2)) | 0;\n    mid = (mid + Math.imul(ah6, bl2)) | 0;\n    hi = (hi + Math.imul(ah6, bh2)) | 0;\n    lo = (lo + Math.imul(al5, bl3)) | 0;\n    mid = (mid + Math.imul(al5, bh3)) | 0;\n    mid = (mid + Math.imul(ah5, bl3)) | 0;\n    hi = (hi + Math.imul(ah5, bh3)) | 0;\n    lo = (lo + Math.imul(al4, bl4)) | 0;\n    mid = (mid + Math.imul(al4, bh4)) | 0;\n    mid = (mid + Math.imul(ah4, bl4)) | 0;\n    hi = (hi + Math.imul(ah4, bh4)) | 0;\n    lo = (lo + Math.imul(al3, bl5)) | 0;\n    mid = (mid + Math.imul(al3, bh5)) | 0;\n    mid = (mid + Math.imul(ah3, bl5)) | 0;\n    hi = (hi + Math.imul(ah3, bh5)) | 0;\n    lo = (lo + Math.imul(al2, bl6)) | 0;\n    mid = (mid + Math.imul(al2, bh6)) | 0;\n    mid = (mid + Math.imul(ah2, bl6)) | 0;\n    hi = (hi + Math.imul(ah2, bh6)) | 0;\n    lo = (lo + Math.imul(al1, bl7)) | 0;\n    mid = (mid + Math.imul(al1, bh7)) | 0;\n    mid = (mid + Math.imul(ah1, bl7)) | 0;\n    hi = (hi + Math.imul(ah1, bh7)) | 0;\n    lo = (lo + Math.imul(al0, bl8)) | 0;\n    mid = (mid + Math.imul(al0, bh8)) | 0;\n    mid = (mid + Math.imul(ah0, bl8)) | 0;\n    hi = (hi + Math.imul(ah0, bh8)) | 0;\n    var w8 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w8 >>> 26)) | 0;\n    w8 &= 0x3ffffff;\n    /* k = 9 */\n    lo = Math.imul(al9, bl0);\n    mid = Math.imul(al9, bh0);\n    mid = (mid + Math.imul(ah9, bl0)) | 0;\n    hi = Math.imul(ah9, bh0);\n    lo = (lo + Math.imul(al8, bl1)) | 0;\n    mid = (mid + Math.imul(al8, bh1)) | 0;\n    mid = (mid + Math.imul(ah8, bl1)) | 0;\n    hi = (hi + Math.imul(ah8, bh1)) | 0;\n    lo = (lo + Math.imul(al7, bl2)) | 0;\n    mid = (mid + Math.imul(al7, bh2)) | 0;\n    mid = (mid + Math.imul(ah7, bl2)) | 0;\n    hi = (hi + Math.imul(ah7, bh2)) | 0;\n    lo = (lo + Math.imul(al6, bl3)) | 0;\n    mid = (mid + Math.imul(al6, bh3)) | 0;\n    mid = (mid + Math.imul(ah6, bl3)) | 0;\n    hi = (hi + Math.imul(ah6, bh3)) | 0;\n    lo = (lo + Math.imul(al5, bl4)) | 0;\n    mid = (mid + Math.imul(al5, bh4)) | 0;\n    mid = (mid + Math.imul(ah5, bl4)) | 0;\n    hi = (hi + Math.imul(ah5, bh4)) | 0;\n    lo = (lo + Math.imul(al4, bl5)) | 0;\n    mid = (mid + Math.imul(al4, bh5)) | 0;\n    mid = (mid + Math.imul(ah4, bl5)) | 0;\n    hi = (hi + Math.imul(ah4, bh5)) | 0;\n    lo = (lo + Math.imul(al3, bl6)) | 0;\n    mid = (mid + Math.imul(al3, bh6)) | 0;\n    mid = (mid + Math.imul(ah3, bl6)) | 0;\n    hi = (hi + Math.imul(ah3, bh6)) | 0;\n    lo = (lo + Math.imul(al2, bl7)) | 0;\n    mid = (mid + Math.imul(al2, bh7)) | 0;\n    mid = (mid + Math.imul(ah2, bl7)) | 0;\n    hi = (hi + Math.imul(ah2, bh7)) | 0;\n    lo = (lo + Math.imul(al1, bl8)) | 0;\n    mid = (mid + Math.imul(al1, bh8)) | 0;\n    mid = (mid + Math.imul(ah1, bl8)) | 0;\n    hi = (hi + Math.imul(ah1, bh8)) | 0;\n    lo = (lo + Math.imul(al0, bl9)) | 0;\n    mid = (mid + Math.imul(al0, bh9)) | 0;\n    mid = (mid + Math.imul(ah0, bl9)) | 0;\n    hi = (hi + Math.imul(ah0, bh9)) | 0;\n    var w9 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w9 >>> 26)) | 0;\n    w9 &= 0x3ffffff;\n    /* k = 10 */\n    lo = Math.imul(al9, bl1);\n    mid = Math.imul(al9, bh1);\n    mid = (mid + Math.imul(ah9, bl1)) | 0;\n    hi = Math.imul(ah9, bh1);\n    lo = (lo + Math.imul(al8, bl2)) | 0;\n    mid = (mid + Math.imul(al8, bh2)) | 0;\n    mid = (mid + Math.imul(ah8, bl2)) | 0;\n    hi = (hi + Math.imul(ah8, bh2)) | 0;\n    lo = (lo + Math.imul(al7, bl3)) | 0;\n    mid = (mid + Math.imul(al7, bh3)) | 0;\n    mid = (mid + Math.imul(ah7, bl3)) | 0;\n    hi = (hi + Math.imul(ah7, bh3)) | 0;\n    lo = (lo + Math.imul(al6, bl4)) | 0;\n    mid = (mid + Math.imul(al6, bh4)) | 0;\n    mid = (mid + Math.imul(ah6, bl4)) | 0;\n    hi = (hi + Math.imul(ah6, bh4)) | 0;\n    lo = (lo + Math.imul(al5, bl5)) | 0;\n    mid = (mid + Math.imul(al5, bh5)) | 0;\n    mid = (mid + Math.imul(ah5, bl5)) | 0;\n    hi = (hi + Math.imul(ah5, bh5)) | 0;\n    lo = (lo + Math.imul(al4, bl6)) | 0;\n    mid = (mid + Math.imul(al4, bh6)) | 0;\n    mid = (mid + Math.imul(ah4, bl6)) | 0;\n    hi = (hi + Math.imul(ah4, bh6)) | 0;\n    lo = (lo + Math.imul(al3, bl7)) | 0;\n    mid = (mid + Math.imul(al3, bh7)) | 0;\n    mid = (mid + Math.imul(ah3, bl7)) | 0;\n    hi = (hi + Math.imul(ah3, bh7)) | 0;\n    lo = (lo + Math.imul(al2, bl8)) | 0;\n    mid = (mid + Math.imul(al2, bh8)) | 0;\n    mid = (mid + Math.imul(ah2, bl8)) | 0;\n    hi = (hi + Math.imul(ah2, bh8)) | 0;\n    lo = (lo + Math.imul(al1, bl9)) | 0;\n    mid = (mid + Math.imul(al1, bh9)) | 0;\n    mid = (mid + Math.imul(ah1, bl9)) | 0;\n    hi = (hi + Math.imul(ah1, bh9)) | 0;\n    var w10 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w10 >>> 26)) | 0;\n    w10 &= 0x3ffffff;\n    /* k = 11 */\n    lo = Math.imul(al9, bl2);\n    mid = Math.imul(al9, bh2);\n    mid = (mid + Math.imul(ah9, bl2)) | 0;\n    hi = Math.imul(ah9, bh2);\n    lo = (lo + Math.imul(al8, bl3)) | 0;\n    mid = (mid + Math.imul(al8, bh3)) | 0;\n    mid = (mid + Math.imul(ah8, bl3)) | 0;\n    hi = (hi + Math.imul(ah8, bh3)) | 0;\n    lo = (lo + Math.imul(al7, bl4)) | 0;\n    mid = (mid + Math.imul(al7, bh4)) | 0;\n    mid = (mid + Math.imul(ah7, bl4)) | 0;\n    hi = (hi + Math.imul(ah7, bh4)) | 0;\n    lo = (lo + Math.imul(al6, bl5)) | 0;\n    mid = (mid + Math.imul(al6, bh5)) | 0;\n    mid = (mid + Math.imul(ah6, bl5)) | 0;\n    hi = (hi + Math.imul(ah6, bh5)) | 0;\n    lo = (lo + Math.imul(al5, bl6)) | 0;\n    mid = (mid + Math.imul(al5, bh6)) | 0;\n    mid = (mid + Math.imul(ah5, bl6)) | 0;\n    hi = (hi + Math.imul(ah5, bh6)) | 0;\n    lo = (lo + Math.imul(al4, bl7)) | 0;\n    mid = (mid + Math.imul(al4, bh7)) | 0;\n    mid = (mid + Math.imul(ah4, bl7)) | 0;\n    hi = (hi + Math.imul(ah4, bh7)) | 0;\n    lo = (lo + Math.imul(al3, bl8)) | 0;\n    mid = (mid + Math.imul(al3, bh8)) | 0;\n    mid = (mid + Math.imul(ah3, bl8)) | 0;\n    hi = (hi + Math.imul(ah3, bh8)) | 0;\n    lo = (lo + Math.imul(al2, bl9)) | 0;\n    mid = (mid + Math.imul(al2, bh9)) | 0;\n    mid = (mid + Math.imul(ah2, bl9)) | 0;\n    hi = (hi + Math.imul(ah2, bh9)) | 0;\n    var w11 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w11 >>> 26)) | 0;\n    w11 &= 0x3ffffff;\n    /* k = 12 */\n    lo = Math.imul(al9, bl3);\n    mid = Math.imul(al9, bh3);\n    mid = (mid + Math.imul(ah9, bl3)) | 0;\n    hi = Math.imul(ah9, bh3);\n    lo = (lo + Math.imul(al8, bl4)) | 0;\n    mid = (mid + Math.imul(al8, bh4)) | 0;\n    mid = (mid + Math.imul(ah8, bl4)) | 0;\n    hi = (hi + Math.imul(ah8, bh4)) | 0;\n    lo = (lo + Math.imul(al7, bl5)) | 0;\n    mid = (mid + Math.imul(al7, bh5)) | 0;\n    mid = (mid + Math.imul(ah7, bl5)) | 0;\n    hi = (hi + Math.imul(ah7, bh5)) | 0;\n    lo = (lo + Math.imul(al6, bl6)) | 0;\n    mid = (mid + Math.imul(al6, bh6)) | 0;\n    mid = (mid + Math.imul(ah6, bl6)) | 0;\n    hi = (hi + Math.imul(ah6, bh6)) | 0;\n    lo = (lo + Math.imul(al5, bl7)) | 0;\n    mid = (mid + Math.imul(al5, bh7)) | 0;\n    mid = (mid + Math.imul(ah5, bl7)) | 0;\n    hi = (hi + Math.imul(ah5, bh7)) | 0;\n    lo = (lo + Math.imul(al4, bl8)) | 0;\n    mid = (mid + Math.imul(al4, bh8)) | 0;\n    mid = (mid + Math.imul(ah4, bl8)) | 0;\n    hi = (hi + Math.imul(ah4, bh8)) | 0;\n    lo = (lo + Math.imul(al3, bl9)) | 0;\n    mid = (mid + Math.imul(al3, bh9)) | 0;\n    mid = (mid + Math.imul(ah3, bl9)) | 0;\n    hi = (hi + Math.imul(ah3, bh9)) | 0;\n    var w12 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w12 >>> 26)) | 0;\n    w12 &= 0x3ffffff;\n    /* k = 13 */\n    lo = Math.imul(al9, bl4);\n    mid = Math.imul(al9, bh4);\n    mid = (mid + Math.imul(ah9, bl4)) | 0;\n    hi = Math.imul(ah9, bh4);\n    lo = (lo + Math.imul(al8, bl5)) | 0;\n    mid = (mid + Math.imul(al8, bh5)) | 0;\n    mid = (mid + Math.imul(ah8, bl5)) | 0;\n    hi = (hi + Math.imul(ah8, bh5)) | 0;\n    lo = (lo + Math.imul(al7, bl6)) | 0;\n    mid = (mid + Math.imul(al7, bh6)) | 0;\n    mid = (mid + Math.imul(ah7, bl6)) | 0;\n    hi = (hi + Math.imul(ah7, bh6)) | 0;\n    lo = (lo + Math.imul(al6, bl7)) | 0;\n    mid = (mid + Math.imul(al6, bh7)) | 0;\n    mid = (mid + Math.imul(ah6, bl7)) | 0;\n    hi = (hi + Math.imul(ah6, bh7)) | 0;\n    lo = (lo + Math.imul(al5, bl8)) | 0;\n    mid = (mid + Math.imul(al5, bh8)) | 0;\n    mid = (mid + Math.imul(ah5, bl8)) | 0;\n    hi = (hi + Math.imul(ah5, bh8)) | 0;\n    lo = (lo + Math.imul(al4, bl9)) | 0;\n    mid = (mid + Math.imul(al4, bh9)) | 0;\n    mid = (mid + Math.imul(ah4, bl9)) | 0;\n    hi = (hi + Math.imul(ah4, bh9)) | 0;\n    var w13 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w13 >>> 26)) | 0;\n    w13 &= 0x3ffffff;\n    /* k = 14 */\n    lo = Math.imul(al9, bl5);\n    mid = Math.imul(al9, bh5);\n    mid = (mid + Math.imul(ah9, bl5)) | 0;\n    hi = Math.imul(ah9, bh5);\n    lo = (lo + Math.imul(al8, bl6)) | 0;\n    mid = (mid + Math.imul(al8, bh6)) | 0;\n    mid = (mid + Math.imul(ah8, bl6)) | 0;\n    hi = (hi + Math.imul(ah8, bh6)) | 0;\n    lo = (lo + Math.imul(al7, bl7)) | 0;\n    mid = (mid + Math.imul(al7, bh7)) | 0;\n    mid = (mid + Math.imul(ah7, bl7)) | 0;\n    hi = (hi + Math.imul(ah7, bh7)) | 0;\n    lo = (lo + Math.imul(al6, bl8)) | 0;\n    mid = (mid + Math.imul(al6, bh8)) | 0;\n    mid = (mid + Math.imul(ah6, bl8)) | 0;\n    hi = (hi + Math.imul(ah6, bh8)) | 0;\n    lo = (lo + Math.imul(al5, bl9)) | 0;\n    mid = (mid + Math.imul(al5, bh9)) | 0;\n    mid = (mid + Math.imul(ah5, bl9)) | 0;\n    hi = (hi + Math.imul(ah5, bh9)) | 0;\n    var w14 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w14 >>> 26)) | 0;\n    w14 &= 0x3ffffff;\n    /* k = 15 */\n    lo = Math.imul(al9, bl6);\n    mid = Math.imul(al9, bh6);\n    mid = (mid + Math.imul(ah9, bl6)) | 0;\n    hi = Math.imul(ah9, bh6);\n    lo = (lo + Math.imul(al8, bl7)) | 0;\n    mid = (mid + Math.imul(al8, bh7)) | 0;\n    mid = (mid + Math.imul(ah8, bl7)) | 0;\n    hi = (hi + Math.imul(ah8, bh7)) | 0;\n    lo = (lo + Math.imul(al7, bl8)) | 0;\n    mid = (mid + Math.imul(al7, bh8)) | 0;\n    mid = (mid + Math.imul(ah7, bl8)) | 0;\n    hi = (hi + Math.imul(ah7, bh8)) | 0;\n    lo = (lo + Math.imul(al6, bl9)) | 0;\n    mid = (mid + Math.imul(al6, bh9)) | 0;\n    mid = (mid + Math.imul(ah6, bl9)) | 0;\n    hi = (hi + Math.imul(ah6, bh9)) | 0;\n    var w15 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w15 >>> 26)) | 0;\n    w15 &= 0x3ffffff;\n    /* k = 16 */\n    lo = Math.imul(al9, bl7);\n    mid = Math.imul(al9, bh7);\n    mid = (mid + Math.imul(ah9, bl7)) | 0;\n    hi = Math.imul(ah9, bh7);\n    lo = (lo + Math.imul(al8, bl8)) | 0;\n    mid = (mid + Math.imul(al8, bh8)) | 0;\n    mid = (mid + Math.imul(ah8, bl8)) | 0;\n    hi = (hi + Math.imul(ah8, bh8)) | 0;\n    lo = (lo + Math.imul(al7, bl9)) | 0;\n    mid = (mid + Math.imul(al7, bh9)) | 0;\n    mid = (mid + Math.imul(ah7, bl9)) | 0;\n    hi = (hi + Math.imul(ah7, bh9)) | 0;\n    var w16 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w16 >>> 26)) | 0;\n    w16 &= 0x3ffffff;\n    /* k = 17 */\n    lo = Math.imul(al9, bl8);\n    mid = Math.imul(al9, bh8);\n    mid = (mid + Math.imul(ah9, bl8)) | 0;\n    hi = Math.imul(ah9, bh8);\n    lo = (lo + Math.imul(al8, bl9)) | 0;\n    mid = (mid + Math.imul(al8, bh9)) | 0;\n    mid = (mid + Math.imul(ah8, bl9)) | 0;\n    hi = (hi + Math.imul(ah8, bh9)) | 0;\n    var w17 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w17 >>> 26)) | 0;\n    w17 &= 0x3ffffff;\n    /* k = 18 */\n    lo = Math.imul(al9, bl9);\n    mid = Math.imul(al9, bh9);\n    mid = (mid + Math.imul(ah9, bl9)) | 0;\n    hi = Math.imul(ah9, bh9);\n    var w18 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;\n    c = (((hi + (mid >>> 13)) | 0) + (w18 >>> 26)) | 0;\n    w18 &= 0x3ffffff;\n    o[0] = w0;\n    o[1] = w1;\n    o[2] = w2;\n    o[3] = w3;\n    o[4] = w4;\n    o[5] = w5;\n    o[6] = w6;\n    o[7] = w7;\n    o[8] = w8;\n    o[9] = w9;\n    o[10] = w10;\n    o[11] = w11;\n    o[12] = w12;\n    o[13] = w13;\n    o[14] = w14;\n    o[15] = w15;\n    o[16] = w16;\n    o[17] = w17;\n    o[18] = w18;\n    if (c !== 0) {\n      o[19] = c;\n      out.length++;\n    }\n    return out;\n  };\n\n  // Polyfill comb\n  if (!Math.imul) {\n    comb10MulTo = smallMulTo;\n  }\n\n  function bigMulTo (self, num, out) {\n    out.negative = num.negative ^ self.negative;\n    out.length = self.length + num.length;\n\n    var carry = 0;\n    var hncarry = 0;\n    for (var k = 0; k < out.length - 1; k++) {\n      // Sum all words with the same `i + j = k` and accumulate `ncarry`,\n      // note that ncarry could be >= 0x3ffffff\n      var ncarry = hncarry;\n      hncarry = 0;\n      var rword = carry & 0x3ffffff;\n      var maxJ = Math.min(k, num.length - 1);\n      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {\n        var i = k - j;\n        var a = self.words[i] | 0;\n        var b = num.words[j] | 0;\n        var r = a * b;\n\n        var lo = r & 0x3ffffff;\n        ncarry = (ncarry + ((r / 0x4000000) | 0)) | 0;\n        lo = (lo + rword) | 0;\n        rword = lo & 0x3ffffff;\n        ncarry = (ncarry + (lo >>> 26)) | 0;\n\n        hncarry += ncarry >>> 26;\n        ncarry &= 0x3ffffff;\n      }\n      out.words[k] = rword;\n      carry = ncarry;\n      ncarry = hncarry;\n    }\n    if (carry !== 0) {\n      out.words[k] = carry;\n    } else {\n      out.length--;\n    }\n\n    return out.strip();\n  }\n\n  function jumboMulTo (self, num, out) {\n    var fftm = new FFTM();\n    return fftm.mulp(self, num, out);\n  }\n\n  BN.prototype.mulTo = function mulTo (num, out) {\n    var res;\n    var len = this.length + num.length;\n    if (this.length === 10 && num.length === 10) {\n      res = comb10MulTo(this, num, out);\n    } else if (len < 63) {\n      res = smallMulTo(this, num, out);\n    } else if (len < 1024) {\n      res = bigMulTo(this, num, out);\n    } else {\n      res = jumboMulTo(this, num, out);\n    }\n\n    return res;\n  };\n\n  // Cooley-Tukey algorithm for FFT\n  // slightly revisited to rely on looping instead of recursion\n\n  function FFTM (x, y) {\n    this.x = x;\n    this.y = y;\n  }\n\n  FFTM.prototype.makeRBT = function makeRBT (N) {\n    var t = new Array(N);\n    var l = BN.prototype._countBits(N) - 1;\n    for (var i = 0; i < N; i++) {\n      t[i] = this.revBin(i, l, N);\n    }\n\n    return t;\n  };\n\n  // Returns binary-reversed representation of `x`\n  FFTM.prototype.revBin = function revBin (x, l, N) {\n    if (x === 0 || x === N - 1) return x;\n\n    var rb = 0;\n    for (var i = 0; i < l; i++) {\n      rb |= (x & 1) << (l - i - 1);\n      x >>= 1;\n    }\n\n    return rb;\n  };\n\n  // Performs \"tweedling\" phase, therefore 'emulating'\n  // behaviour of the recursive algorithm\n  FFTM.prototype.permute = function permute (rbt, rws, iws, rtws, itws, N) {\n    for (var i = 0; i < N; i++) {\n      rtws[i] = rws[rbt[i]];\n      itws[i] = iws[rbt[i]];\n    }\n  };\n\n  FFTM.prototype.transform = function transform (rws, iws, rtws, itws, N, rbt) {\n    this.permute(rbt, rws, iws, rtws, itws, N);\n\n    for (var s = 1; s < N; s <<= 1) {\n      var l = s << 1;\n\n      var rtwdf = Math.cos(2 * Math.PI / l);\n      var itwdf = Math.sin(2 * Math.PI / l);\n\n      for (var p = 0; p < N; p += l) {\n        var rtwdf_ = rtwdf;\n        var itwdf_ = itwdf;\n\n        for (var j = 0; j < s; j++) {\n          var re = rtws[p + j];\n          var ie = itws[p + j];\n\n          var ro = rtws[p + j + s];\n          var io = itws[p + j + s];\n\n          var rx = rtwdf_ * ro - itwdf_ * io;\n\n          io = rtwdf_ * io + itwdf_ * ro;\n          ro = rx;\n\n          rtws[p + j] = re + ro;\n          itws[p + j] = ie + io;\n\n          rtws[p + j + s] = re - ro;\n          itws[p + j + s] = ie - io;\n\n          /* jshint maxdepth : false */\n          if (j !== l) {\n            rx = rtwdf * rtwdf_ - itwdf * itwdf_;\n\n            itwdf_ = rtwdf * itwdf_ + itwdf * rtwdf_;\n            rtwdf_ = rx;\n          }\n        }\n      }\n    }\n  };\n\n  FFTM.prototype.guessLen13b = function guessLen13b (n, m) {\n    var N = Math.max(m, n) | 1;\n    var odd = N & 1;\n    var i = 0;\n    for (N = N / 2 | 0; N; N = N >>> 1) {\n      i++;\n    }\n\n    return 1 << i + 1 + odd;\n  };\n\n  FFTM.prototype.conjugate = function conjugate (rws, iws, N) {\n    if (N <= 1) return;\n\n    for (var i = 0; i < N / 2; i++) {\n      var t = rws[i];\n\n      rws[i] = rws[N - i - 1];\n      rws[N - i - 1] = t;\n\n      t = iws[i];\n\n      iws[i] = -iws[N - i - 1];\n      iws[N - i - 1] = -t;\n    }\n  };\n\n  FFTM.prototype.normalize13b = function normalize13b (ws, N) {\n    var carry = 0;\n    for (var i = 0; i < N / 2; i++) {\n      var w = Math.round(ws[2 * i + 1] / N) * 0x2000 +\n        Math.round(ws[2 * i] / N) +\n        carry;\n\n      ws[i] = w & 0x3ffffff;\n\n      if (w < 0x4000000) {\n        carry = 0;\n      } else {\n        carry = w / 0x4000000 | 0;\n      }\n    }\n\n    return ws;\n  };\n\n  FFTM.prototype.convert13b = function convert13b (ws, len, rws, N) {\n    var carry = 0;\n    for (var i = 0; i < len; i++) {\n      carry = carry + (ws[i] | 0);\n\n      rws[2 * i] = carry & 0x1fff; carry = carry >>> 13;\n      rws[2 * i + 1] = carry & 0x1fff; carry = carry >>> 13;\n    }\n\n    // Pad with zeroes\n    for (i = 2 * len; i < N; ++i) {\n      rws[i] = 0;\n    }\n\n    assert(carry === 0);\n    assert((carry & ~0x1fff) === 0);\n  };\n\n  FFTM.prototype.stub = function stub (N) {\n    var ph = new Array(N);\n    for (var i = 0; i < N; i++) {\n      ph[i] = 0;\n    }\n\n    return ph;\n  };\n\n  FFTM.prototype.mulp = function mulp (x, y, out) {\n    var N = 2 * this.guessLen13b(x.length, y.length);\n\n    var rbt = this.makeRBT(N);\n\n    var _ = this.stub(N);\n\n    var rws = new Array(N);\n    var rwst = new Array(N);\n    var iwst = new Array(N);\n\n    var nrws = new Array(N);\n    var nrwst = new Array(N);\n    var niwst = new Array(N);\n\n    var rmws = out.words;\n    rmws.length = N;\n\n    this.convert13b(x.words, x.length, rws, N);\n    this.convert13b(y.words, y.length, nrws, N);\n\n    this.transform(rws, _, rwst, iwst, N, rbt);\n    this.transform(nrws, _, nrwst, niwst, N, rbt);\n\n    for (var i = 0; i < N; i++) {\n      var rx = rwst[i] * nrwst[i] - iwst[i] * niwst[i];\n      iwst[i] = rwst[i] * niwst[i] + iwst[i] * nrwst[i];\n      rwst[i] = rx;\n    }\n\n    this.conjugate(rwst, iwst, N);\n    this.transform(rwst, iwst, rmws, _, N, rbt);\n    this.conjugate(rmws, _, N);\n    this.normalize13b(rmws, N);\n\n    out.negative = x.negative ^ y.negative;\n    out.length = x.length + y.length;\n    return out.strip();\n  };\n\n  // Multiply `this` by `num`\n  BN.prototype.mul = function mul (num) {\n    var out = new BN(null);\n    out.words = new Array(this.length + num.length);\n    return this.mulTo(num, out);\n  };\n\n  // Multiply employing FFT\n  BN.prototype.mulf = function mulf (num) {\n    var out = new BN(null);\n    out.words = new Array(this.length + num.length);\n    return jumboMulTo(this, num, out);\n  };\n\n  // In-place Multiplication\n  BN.prototype.imul = function imul (num) {\n    return this.clone().mulTo(num, this);\n  };\n\n  BN.prototype.imuln = function imuln (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n\n    // Carry\n    var carry = 0;\n    for (var i = 0; i < this.length; i++) {\n      var w = (this.words[i] | 0) * num;\n      var lo = (w & 0x3ffffff) + (carry & 0x3ffffff);\n      carry >>= 26;\n      carry += (w / 0x4000000) | 0;\n      // NOTE: lo is 27bit maximum\n      carry += lo >>> 26;\n      this.words[i] = lo & 0x3ffffff;\n    }\n\n    if (carry !== 0) {\n      this.words[i] = carry;\n      this.length++;\n    }\n\n    return this;\n  };\n\n  BN.prototype.muln = function muln (num) {\n    return this.clone().imuln(num);\n  };\n\n  // `this` * `this`\n  BN.prototype.sqr = function sqr () {\n    return this.mul(this);\n  };\n\n  // `this` * `this` in-place\n  BN.prototype.isqr = function isqr () {\n    return this.imul(this.clone());\n  };\n\n  // Math.pow(`this`, `num`)\n  BN.prototype.pow = function pow (num) {\n    var w = toBitArray(num);\n    if (w.length === 0) return new BN(1);\n\n    // Skip leading zeroes\n    var res = this;\n    for (var i = 0; i < w.length; i++, res = res.sqr()) {\n      if (w[i] !== 0) break;\n    }\n\n    if (++i < w.length) {\n      for (var q = res.sqr(); i < w.length; i++, q = q.sqr()) {\n        if (w[i] === 0) continue;\n\n        res = res.mul(q);\n      }\n    }\n\n    return res;\n  };\n\n  // Shift-left in-place\n  BN.prototype.iushln = function iushln (bits) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var r = bits % 26;\n    var s = (bits - r) / 26;\n    var carryMask = (0x3ffffff >>> (26 - r)) << (26 - r);\n    var i;\n\n    if (r !== 0) {\n      var carry = 0;\n\n      for (i = 0; i < this.length; i++) {\n        var newCarry = this.words[i] & carryMask;\n        var c = ((this.words[i] | 0) - newCarry) << r;\n        this.words[i] = c | carry;\n        carry = newCarry >>> (26 - r);\n      }\n\n      if (carry) {\n        this.words[i] = carry;\n        this.length++;\n      }\n    }\n\n    if (s !== 0) {\n      for (i = this.length - 1; i >= 0; i--) {\n        this.words[i + s] = this.words[i];\n      }\n\n      for (i = 0; i < s; i++) {\n        this.words[i] = 0;\n      }\n\n      this.length += s;\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.ishln = function ishln (bits) {\n    // TODO(indutny): implement me\n    assert(this.negative === 0);\n    return this.iushln(bits);\n  };\n\n  // Shift-right in-place\n  // NOTE: `hint` is a lowest bit before trailing zeroes\n  // NOTE: if `extended` is present - it will be filled with destroyed bits\n  BN.prototype.iushrn = function iushrn (bits, hint, extended) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var h;\n    if (hint) {\n      h = (hint - (hint % 26)) / 26;\n    } else {\n      h = 0;\n    }\n\n    var r = bits % 26;\n    var s = Math.min((bits - r) / 26, this.length);\n    var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);\n    var maskedWords = extended;\n\n    h -= s;\n    h = Math.max(0, h);\n\n    // Extended mode, copy masked part\n    if (maskedWords) {\n      for (var i = 0; i < s; i++) {\n        maskedWords.words[i] = this.words[i];\n      }\n      maskedWords.length = s;\n    }\n\n    if (s === 0) {\n      // No-op, we should not move anything at all\n    } else if (this.length > s) {\n      this.length -= s;\n      for (i = 0; i < this.length; i++) {\n        this.words[i] = this.words[i + s];\n      }\n    } else {\n      this.words[0] = 0;\n      this.length = 1;\n    }\n\n    var carry = 0;\n    for (i = this.length - 1; i >= 0 && (carry !== 0 || i >= h); i--) {\n      var word = this.words[i] | 0;\n      this.words[i] = (carry << (26 - r)) | (word >>> r);\n      carry = word & mask;\n    }\n\n    // Push carried bits as a mask\n    if (maskedWords && carry !== 0) {\n      maskedWords.words[maskedWords.length++] = carry;\n    }\n\n    if (this.length === 0) {\n      this.words[0] = 0;\n      this.length = 1;\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.ishrn = function ishrn (bits, hint, extended) {\n    // TODO(indutny): implement me\n    assert(this.negative === 0);\n    return this.iushrn(bits, hint, extended);\n  };\n\n  // Shift-left\n  BN.prototype.shln = function shln (bits) {\n    return this.clone().ishln(bits);\n  };\n\n  BN.prototype.ushln = function ushln (bits) {\n    return this.clone().iushln(bits);\n  };\n\n  // Shift-right\n  BN.prototype.shrn = function shrn (bits) {\n    return this.clone().ishrn(bits);\n  };\n\n  BN.prototype.ushrn = function ushrn (bits) {\n    return this.clone().iushrn(bits);\n  };\n\n  // Test if n bit is set\n  BN.prototype.testn = function testn (bit) {\n    assert(typeof bit === 'number' && bit >= 0);\n    var r = bit % 26;\n    var s = (bit - r) / 26;\n    var q = 1 << r;\n\n    // Fast case: bit is much higher than all existing words\n    if (this.length <= s) return false;\n\n    // Check bit and return\n    var w = this.words[s];\n\n    return !!(w & q);\n  };\n\n  // Return only lowers bits of number (in-place)\n  BN.prototype.imaskn = function imaskn (bits) {\n    assert(typeof bits === 'number' && bits >= 0);\n    var r = bits % 26;\n    var s = (bits - r) / 26;\n\n    assert(this.negative === 0, 'imaskn works only with positive numbers');\n\n    if (this.length <= s) {\n      return this;\n    }\n\n    if (r !== 0) {\n      s++;\n    }\n    this.length = Math.min(s, this.length);\n\n    if (r !== 0) {\n      var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);\n      this.words[this.length - 1] &= mask;\n    }\n\n    return this.strip();\n  };\n\n  // Return only lowers bits of number\n  BN.prototype.maskn = function maskn (bits) {\n    return this.clone().imaskn(bits);\n  };\n\n  // Add plain number `num` to `this`\n  BN.prototype.iaddn = function iaddn (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n    if (num < 0) return this.isubn(-num);\n\n    // Possible sign change\n    if (this.negative !== 0) {\n      if (this.length === 1 && (this.words[0] | 0) < num) {\n        this.words[0] = num - (this.words[0] | 0);\n        this.negative = 0;\n        return this;\n      }\n\n      this.negative = 0;\n      this.isubn(num);\n      this.negative = 1;\n      return this;\n    }\n\n    // Add without checks\n    return this._iaddn(num);\n  };\n\n  BN.prototype._iaddn = function _iaddn (num) {\n    this.words[0] += num;\n\n    // Carry\n    for (var i = 0; i < this.length && this.words[i] >= 0x4000000; i++) {\n      this.words[i] -= 0x4000000;\n      if (i === this.length - 1) {\n        this.words[i + 1] = 1;\n      } else {\n        this.words[i + 1]++;\n      }\n    }\n    this.length = Math.max(this.length, i + 1);\n\n    return this;\n  };\n\n  // Subtract plain number `num` from `this`\n  BN.prototype.isubn = function isubn (num) {\n    assert(typeof num === 'number');\n    assert(num < 0x4000000);\n    if (num < 0) return this.iaddn(-num);\n\n    if (this.negative !== 0) {\n      this.negative = 0;\n      this.iaddn(num);\n      this.negative = 1;\n      return this;\n    }\n\n    this.words[0] -= num;\n\n    if (this.length === 1 && this.words[0] < 0) {\n      this.words[0] = -this.words[0];\n      this.negative = 1;\n    } else {\n      // Carry\n      for (var i = 0; i < this.length && this.words[i] < 0; i++) {\n        this.words[i] += 0x4000000;\n        this.words[i + 1] -= 1;\n      }\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.addn = function addn (num) {\n    return this.clone().iaddn(num);\n  };\n\n  BN.prototype.subn = function subn (num) {\n    return this.clone().isubn(num);\n  };\n\n  BN.prototype.iabs = function iabs () {\n    this.negative = 0;\n\n    return this;\n  };\n\n  BN.prototype.abs = function abs () {\n    return this.clone().iabs();\n  };\n\n  BN.prototype._ishlnsubmul = function _ishlnsubmul (num, mul, shift) {\n    var len = num.length + shift;\n    var i;\n\n    this._expand(len);\n\n    var w;\n    var carry = 0;\n    for (i = 0; i < num.length; i++) {\n      w = (this.words[i + shift] | 0) + carry;\n      var right = (num.words[i] | 0) * mul;\n      w -= right & 0x3ffffff;\n      carry = (w >> 26) - ((right / 0x4000000) | 0);\n      this.words[i + shift] = w & 0x3ffffff;\n    }\n    for (; i < this.length - shift; i++) {\n      w = (this.words[i + shift] | 0) + carry;\n      carry = w >> 26;\n      this.words[i + shift] = w & 0x3ffffff;\n    }\n\n    if (carry === 0) return this.strip();\n\n    // Subtraction overflow\n    assert(carry === -1);\n    carry = 0;\n    for (i = 0; i < this.length; i++) {\n      w = -(this.words[i] | 0) + carry;\n      carry = w >> 26;\n      this.words[i] = w & 0x3ffffff;\n    }\n    this.negative = 1;\n\n    return this.strip();\n  };\n\n  BN.prototype._wordDiv = function _wordDiv (num, mode) {\n    var shift = this.length - num.length;\n\n    var a = this.clone();\n    var b = num;\n\n    // Normalize\n    var bhi = b.words[b.length - 1] | 0;\n    var bhiBits = this._countBits(bhi);\n    shift = 26 - bhiBits;\n    if (shift !== 0) {\n      b = b.ushln(shift);\n      a.iushln(shift);\n      bhi = b.words[b.length - 1] | 0;\n    }\n\n    // Initialize quotient\n    var m = a.length - b.length;\n    var q;\n\n    if (mode !== 'mod') {\n      q = new BN(null);\n      q.length = m + 1;\n      q.words = new Array(q.length);\n      for (var i = 0; i < q.length; i++) {\n        q.words[i] = 0;\n      }\n    }\n\n    var diff = a.clone()._ishlnsubmul(b, 1, m);\n    if (diff.negative === 0) {\n      a = diff;\n      if (q) {\n        q.words[m] = 1;\n      }\n    }\n\n    for (var j = m - 1; j >= 0; j--) {\n      var qj = (a.words[b.length + j] | 0) * 0x4000000 +\n        (a.words[b.length + j - 1] | 0);\n\n      // NOTE: (qj / bhi) is (0x3ffffff * 0x4000000 + 0x3ffffff) / 0x2000000 max\n      // (0x7ffffff)\n      qj = Math.min((qj / bhi) | 0, 0x3ffffff);\n\n      a._ishlnsubmul(b, qj, j);\n      while (a.negative !== 0) {\n        qj--;\n        a.negative = 0;\n        a._ishlnsubmul(b, 1, j);\n        if (!a.isZero()) {\n          a.negative ^= 1;\n        }\n      }\n      if (q) {\n        q.words[j] = qj;\n      }\n    }\n    if (q) {\n      q.strip();\n    }\n    a.strip();\n\n    // Denormalize\n    if (mode !== 'div' && shift !== 0) {\n      a.iushrn(shift);\n    }\n\n    return {\n      div: q || null,\n      mod: a\n    };\n  };\n\n  // NOTE: 1) `mode` can be set to `mod` to request mod only,\n  //       to `div` to request div only, or be absent to\n  //       request both div & mod\n  //       2) `positive` is true if unsigned mod is requested\n  BN.prototype.divmod = function divmod (num, mode, positive) {\n    assert(!num.isZero());\n\n    if (this.isZero()) {\n      return {\n        div: new BN(0),\n        mod: new BN(0)\n      };\n    }\n\n    var div, mod, res;\n    if (this.negative !== 0 && num.negative === 0) {\n      res = this.neg().divmod(num, mode);\n\n      if (mode !== 'mod') {\n        div = res.div.neg();\n      }\n\n      if (mode !== 'div') {\n        mod = res.mod.neg();\n        if (positive && mod.negative !== 0) {\n          mod.iadd(num);\n        }\n      }\n\n      return {\n        div: div,\n        mod: mod\n      };\n    }\n\n    if (this.negative === 0 && num.negative !== 0) {\n      res = this.divmod(num.neg(), mode);\n\n      if (mode !== 'mod') {\n        div = res.div.neg();\n      }\n\n      return {\n        div: div,\n        mod: res.mod\n      };\n    }\n\n    if ((this.negative & num.negative) !== 0) {\n      res = this.neg().divmod(num.neg(), mode);\n\n      if (mode !== 'div') {\n        mod = res.mod.neg();\n        if (positive && mod.negative !== 0) {\n          mod.isub(num);\n        }\n      }\n\n      return {\n        div: res.div,\n        mod: mod\n      };\n    }\n\n    // Both numbers are positive at this point\n\n    // Strip both numbers to approximate shift value\n    if (num.length > this.length || this.cmp(num) < 0) {\n      return {\n        div: new BN(0),\n        mod: this\n      };\n    }\n\n    // Very short reduction\n    if (num.length === 1) {\n      if (mode === 'div') {\n        return {\n          div: this.divn(num.words[0]),\n          mod: null\n        };\n      }\n\n      if (mode === 'mod') {\n        return {\n          div: null,\n          mod: new BN(this.modn(num.words[0]))\n        };\n      }\n\n      return {\n        div: this.divn(num.words[0]),\n        mod: new BN(this.modn(num.words[0]))\n      };\n    }\n\n    return this._wordDiv(num, mode);\n  };\n\n  // Find `this` / `num`\n  BN.prototype.div = function div (num) {\n    return this.divmod(num, 'div', false).div;\n  };\n\n  // Find `this` % `num`\n  BN.prototype.mod = function mod (num) {\n    return this.divmod(num, 'mod', false).mod;\n  };\n\n  BN.prototype.umod = function umod (num) {\n    return this.divmod(num, 'mod', true).mod;\n  };\n\n  // Find Round(`this` / `num`)\n  BN.prototype.divRound = function divRound (num) {\n    var dm = this.divmod(num);\n\n    // Fast case - exact division\n    if (dm.mod.isZero()) return dm.div;\n\n    var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;\n\n    var half = num.ushrn(1);\n    var r2 = num.andln(1);\n    var cmp = mod.cmp(half);\n\n    // Round down\n    if (cmp < 0 || r2 === 1 && cmp === 0) return dm.div;\n\n    // Round up\n    return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);\n  };\n\n  BN.prototype.modn = function modn (num) {\n    assert(num <= 0x3ffffff);\n    var p = (1 << 26) % num;\n\n    var acc = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      acc = (p * acc + (this.words[i] | 0)) % num;\n    }\n\n    return acc;\n  };\n\n  // In-place division by number\n  BN.prototype.idivn = function idivn (num) {\n    assert(num <= 0x3ffffff);\n\n    var carry = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      var w = (this.words[i] | 0) + carry * 0x4000000;\n      this.words[i] = (w / num) | 0;\n      carry = w % num;\n    }\n\n    return this.strip();\n  };\n\n  BN.prototype.divn = function divn (num) {\n    return this.clone().idivn(num);\n  };\n\n  BN.prototype.egcd = function egcd (p) {\n    assert(p.negative === 0);\n    assert(!p.isZero());\n\n    var x = this;\n    var y = p.clone();\n\n    if (x.negative !== 0) {\n      x = x.umod(p);\n    } else {\n      x = x.clone();\n    }\n\n    // A * x + B * y = x\n    var A = new BN(1);\n    var B = new BN(0);\n\n    // C * x + D * y = y\n    var C = new BN(0);\n    var D = new BN(1);\n\n    var g = 0;\n\n    while (x.isEven() && y.isEven()) {\n      x.iushrn(1);\n      y.iushrn(1);\n      ++g;\n    }\n\n    var yp = y.clone();\n    var xp = x.clone();\n\n    while (!x.isZero()) {\n      for (var i = 0, im = 1; (x.words[0] & im) === 0 && i < 26; ++i, im <<= 1);\n      if (i > 0) {\n        x.iushrn(i);\n        while (i-- > 0) {\n          if (A.isOdd() || B.isOdd()) {\n            A.iadd(yp);\n            B.isub(xp);\n          }\n\n          A.iushrn(1);\n          B.iushrn(1);\n        }\n      }\n\n      for (var j = 0, jm = 1; (y.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);\n      if (j > 0) {\n        y.iushrn(j);\n        while (j-- > 0) {\n          if (C.isOdd() || D.isOdd()) {\n            C.iadd(yp);\n            D.isub(xp);\n          }\n\n          C.iushrn(1);\n          D.iushrn(1);\n        }\n      }\n\n      if (x.cmp(y) >= 0) {\n        x.isub(y);\n        A.isub(C);\n        B.isub(D);\n      } else {\n        y.isub(x);\n        C.isub(A);\n        D.isub(B);\n      }\n    }\n\n    return {\n      a: C,\n      b: D,\n      gcd: y.iushln(g)\n    };\n  };\n\n  // This is reduced incarnation of the binary EEA\n  // above, designated to invert members of the\n  // _prime_ fields F(p) at a maximal speed\n  BN.prototype._invmp = function _invmp (p) {\n    assert(p.negative === 0);\n    assert(!p.isZero());\n\n    var a = this;\n    var b = p.clone();\n\n    if (a.negative !== 0) {\n      a = a.umod(p);\n    } else {\n      a = a.clone();\n    }\n\n    var x1 = new BN(1);\n    var x2 = new BN(0);\n\n    var delta = b.clone();\n\n    while (a.cmpn(1) > 0 && b.cmpn(1) > 0) {\n      for (var i = 0, im = 1; (a.words[0] & im) === 0 && i < 26; ++i, im <<= 1);\n      if (i > 0) {\n        a.iushrn(i);\n        while (i-- > 0) {\n          if (x1.isOdd()) {\n            x1.iadd(delta);\n          }\n\n          x1.iushrn(1);\n        }\n      }\n\n      for (var j = 0, jm = 1; (b.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);\n      if (j > 0) {\n        b.iushrn(j);\n        while (j-- > 0) {\n          if (x2.isOdd()) {\n            x2.iadd(delta);\n          }\n\n          x2.iushrn(1);\n        }\n      }\n\n      if (a.cmp(b) >= 0) {\n        a.isub(b);\n        x1.isub(x2);\n      } else {\n        b.isub(a);\n        x2.isub(x1);\n      }\n    }\n\n    var res;\n    if (a.cmpn(1) === 0) {\n      res = x1;\n    } else {\n      res = x2;\n    }\n\n    if (res.cmpn(0) < 0) {\n      res.iadd(p);\n    }\n\n    return res;\n  };\n\n  BN.prototype.gcd = function gcd (num) {\n    if (this.isZero()) return num.abs();\n    if (num.isZero()) return this.abs();\n\n    var a = this.clone();\n    var b = num.clone();\n    a.negative = 0;\n    b.negative = 0;\n\n    // Remove common factor of two\n    for (var shift = 0; a.isEven() && b.isEven(); shift++) {\n      a.iushrn(1);\n      b.iushrn(1);\n    }\n\n    do {\n      while (a.isEven()) {\n        a.iushrn(1);\n      }\n      while (b.isEven()) {\n        b.iushrn(1);\n      }\n\n      var r = a.cmp(b);\n      if (r < 0) {\n        // Swap `a` and `b` to make `a` always bigger than `b`\n        var t = a;\n        a = b;\n        b = t;\n      } else if (r === 0 || b.cmpn(1) === 0) {\n        break;\n      }\n\n      a.isub(b);\n    } while (true);\n\n    return b.iushln(shift);\n  };\n\n  // Invert number in the field F(num)\n  BN.prototype.invm = function invm (num) {\n    return this.egcd(num).a.umod(num);\n  };\n\n  BN.prototype.isEven = function isEven () {\n    return (this.words[0] & 1) === 0;\n  };\n\n  BN.prototype.isOdd = function isOdd () {\n    return (this.words[0] & 1) === 1;\n  };\n\n  // And first word and num\n  BN.prototype.andln = function andln (num) {\n    return this.words[0] & num;\n  };\n\n  // Increment at the bit position in-line\n  BN.prototype.bincn = function bincn (bit) {\n    assert(typeof bit === 'number');\n    var r = bit % 26;\n    var s = (bit - r) / 26;\n    var q = 1 << r;\n\n    // Fast case: bit is much higher than all existing words\n    if (this.length <= s) {\n      this._expand(s + 1);\n      this.words[s] |= q;\n      return this;\n    }\n\n    // Add bit and propagate, if needed\n    var carry = q;\n    for (var i = s; carry !== 0 && i < this.length; i++) {\n      var w = this.words[i] | 0;\n      w += carry;\n      carry = w >>> 26;\n      w &= 0x3ffffff;\n      this.words[i] = w;\n    }\n    if (carry !== 0) {\n      this.words[i] = carry;\n      this.length++;\n    }\n    return this;\n  };\n\n  BN.prototype.isZero = function isZero () {\n    return this.length === 1 && this.words[0] === 0;\n  };\n\n  BN.prototype.cmpn = function cmpn (num) {\n    var negative = num < 0;\n\n    if (this.negative !== 0 && !negative) return -1;\n    if (this.negative === 0 && negative) return 1;\n\n    this.strip();\n\n    var res;\n    if (this.length > 1) {\n      res = 1;\n    } else {\n      if (negative) {\n        num = -num;\n      }\n\n      assert(num <= 0x3ffffff, 'Number is too big');\n\n      var w = this.words[0] | 0;\n      res = w === num ? 0 : w < num ? -1 : 1;\n    }\n    if (this.negative !== 0) return -res | 0;\n    return res;\n  };\n\n  // Compare two numbers and return:\n  // 1 - if `this` > `num`\n  // 0 - if `this` == `num`\n  // -1 - if `this` < `num`\n  BN.prototype.cmp = function cmp (num) {\n    if (this.negative !== 0 && num.negative === 0) return -1;\n    if (this.negative === 0 && num.negative !== 0) return 1;\n\n    var res = this.ucmp(num);\n    if (this.negative !== 0) return -res | 0;\n    return res;\n  };\n\n  // Unsigned comparison\n  BN.prototype.ucmp = function ucmp (num) {\n    // At this point both numbers have the same sign\n    if (this.length > num.length) return 1;\n    if (this.length < num.length) return -1;\n\n    var res = 0;\n    for (var i = this.length - 1; i >= 0; i--) {\n      var a = this.words[i] | 0;\n      var b = num.words[i] | 0;\n\n      if (a === b) continue;\n      if (a < b) {\n        res = -1;\n      } else if (a > b) {\n        res = 1;\n      }\n      break;\n    }\n    return res;\n  };\n\n  BN.prototype.gtn = function gtn (num) {\n    return this.cmpn(num) === 1;\n  };\n\n  BN.prototype.gt = function gt (num) {\n    return this.cmp(num) === 1;\n  };\n\n  BN.prototype.gten = function gten (num) {\n    return this.cmpn(num) >= 0;\n  };\n\n  BN.prototype.gte = function gte (num) {\n    return this.cmp(num) >= 0;\n  };\n\n  BN.prototype.ltn = function ltn (num) {\n    return this.cmpn(num) === -1;\n  };\n\n  BN.prototype.lt = function lt (num) {\n    return this.cmp(num) === -1;\n  };\n\n  BN.prototype.lten = function lten (num) {\n    return this.cmpn(num) <= 0;\n  };\n\n  BN.prototype.lte = function lte (num) {\n    return this.cmp(num) <= 0;\n  };\n\n  BN.prototype.eqn = function eqn (num) {\n    return this.cmpn(num) === 0;\n  };\n\n  BN.prototype.eq = function eq (num) {\n    return this.cmp(num) === 0;\n  };\n\n  //\n  // A reduce context, could be using montgomery or something better, depending\n  // on the `m` itself.\n  //\n  BN.red = function red (num) {\n    return new Red(num);\n  };\n\n  BN.prototype.toRed = function toRed (ctx) {\n    assert(!this.red, 'Already a number in reduction context');\n    assert(this.negative === 0, 'red works only with positives');\n    return ctx.convertTo(this)._forceRed(ctx);\n  };\n\n  BN.prototype.fromRed = function fromRed () {\n    assert(this.red, 'fromRed works only with numbers in reduction context');\n    return this.red.convertFrom(this);\n  };\n\n  BN.prototype._forceRed = function _forceRed (ctx) {\n    this.red = ctx;\n    return this;\n  };\n\n  BN.prototype.forceRed = function forceRed (ctx) {\n    assert(!this.red, 'Already a number in reduction context');\n    return this._forceRed(ctx);\n  };\n\n  BN.prototype.redAdd = function redAdd (num) {\n    assert(this.red, 'redAdd works only with red numbers');\n    return this.red.add(this, num);\n  };\n\n  BN.prototype.redIAdd = function redIAdd (num) {\n    assert(this.red, 'redIAdd works only with red numbers');\n    return this.red.iadd(this, num);\n  };\n\n  BN.prototype.redSub = function redSub (num) {\n    assert(this.red, 'redSub works only with red numbers');\n    return this.red.sub(this, num);\n  };\n\n  BN.prototype.redISub = function redISub (num) {\n    assert(this.red, 'redISub works only with red numbers');\n    return this.red.isub(this, num);\n  };\n\n  BN.prototype.redShl = function redShl (num) {\n    assert(this.red, 'redShl works only with red numbers');\n    return this.red.shl(this, num);\n  };\n\n  BN.prototype.redMul = function redMul (num) {\n    assert(this.red, 'redMul works only with red numbers');\n    this.red._verify2(this, num);\n    return this.red.mul(this, num);\n  };\n\n  BN.prototype.redIMul = function redIMul (num) {\n    assert(this.red, 'redMul works only with red numbers');\n    this.red._verify2(this, num);\n    return this.red.imul(this, num);\n  };\n\n  BN.prototype.redSqr = function redSqr () {\n    assert(this.red, 'redSqr works only with red numbers');\n    this.red._verify1(this);\n    return this.red.sqr(this);\n  };\n\n  BN.prototype.redISqr = function redISqr () {\n    assert(this.red, 'redISqr works only with red numbers');\n    this.red._verify1(this);\n    return this.red.isqr(this);\n  };\n\n  // Square root over p\n  BN.prototype.redSqrt = function redSqrt () {\n    assert(this.red, 'redSqrt works only with red numbers');\n    this.red._verify1(this);\n    return this.red.sqrt(this);\n  };\n\n  BN.prototype.redInvm = function redInvm () {\n    assert(this.red, 'redInvm works only with red numbers');\n    this.red._verify1(this);\n    return this.red.invm(this);\n  };\n\n  // Return negative clone of `this` % `red modulo`\n  BN.prototype.redNeg = function redNeg () {\n    assert(this.red, 'redNeg works only with red numbers');\n    this.red._verify1(this);\n    return this.red.neg(this);\n  };\n\n  BN.prototype.redPow = function redPow (num) {\n    assert(this.red && !num.red, 'redPow(normalNum)');\n    this.red._verify1(this);\n    return this.red.pow(this, num);\n  };\n\n  // Prime numbers with efficient reduction\n  var primes = {\n    k256: null,\n    p224: null,\n    p192: null,\n    p25519: null\n  };\n\n  // Pseudo-Mersenne prime\n  function MPrime (name, p) {\n    // P = 2 ^ N - K\n    this.name = name;\n    this.p = new BN(p, 16);\n    this.n = this.p.bitLength();\n    this.k = new BN(1).iushln(this.n).isub(this.p);\n\n    this.tmp = this._tmp();\n  }\n\n  MPrime.prototype._tmp = function _tmp () {\n    var tmp = new BN(null);\n    tmp.words = new Array(Math.ceil(this.n / 13));\n    return tmp;\n  };\n\n  MPrime.prototype.ireduce = function ireduce (num) {\n    // Assumes that `num` is less than `P^2`\n    // num = HI * (2 ^ N - K) + HI * K + LO = HI * K + LO (mod P)\n    var r = num;\n    var rlen;\n\n    do {\n      this.split(r, this.tmp);\n      r = this.imulK(r);\n      r = r.iadd(this.tmp);\n      rlen = r.bitLength();\n    } while (rlen > this.n);\n\n    var cmp = rlen < this.n ? -1 : r.ucmp(this.p);\n    if (cmp === 0) {\n      r.words[0] = 0;\n      r.length = 1;\n    } else if (cmp > 0) {\n      r.isub(this.p);\n    } else {\n      if (r.strip !== undefined) {\n        // r is BN v4 instance\n        r.strip();\n      } else {\n        // r is BN v5 instance\n        r._strip();\n      }\n    }\n\n    return r;\n  };\n\n  MPrime.prototype.split = function split (input, out) {\n    input.iushrn(this.n, 0, out);\n  };\n\n  MPrime.prototype.imulK = function imulK (num) {\n    return num.imul(this.k);\n  };\n\n  function K256 () {\n    MPrime.call(\n      this,\n      'k256',\n      'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f');\n  }\n  inherits(K256, MPrime);\n\n  K256.prototype.split = function split (input, output) {\n    // 256 = 9 * 26 + 22\n    var mask = 0x3fffff;\n\n    var outLen = Math.min(input.length, 9);\n    for (var i = 0; i < outLen; i++) {\n      output.words[i] = input.words[i];\n    }\n    output.length = outLen;\n\n    if (input.length <= 9) {\n      input.words[0] = 0;\n      input.length = 1;\n      return;\n    }\n\n    // Shift by 9 limbs\n    var prev = input.words[9];\n    output.words[output.length++] = prev & mask;\n\n    for (i = 10; i < input.length; i++) {\n      var next = input.words[i] | 0;\n      input.words[i - 10] = ((next & mask) << 4) | (prev >>> 22);\n      prev = next;\n    }\n    prev >>>= 22;\n    input.words[i - 10] = prev;\n    if (prev === 0 && input.length > 10) {\n      input.length -= 10;\n    } else {\n      input.length -= 9;\n    }\n  };\n\n  K256.prototype.imulK = function imulK (num) {\n    // K = 0x1000003d1 = [ 0x40, 0x3d1 ]\n    num.words[num.length] = 0;\n    num.words[num.length + 1] = 0;\n    num.length += 2;\n\n    // bounded at: 0x40 * 0x3ffffff + 0x3d0 = 0x100000390\n    var lo = 0;\n    for (var i = 0; i < num.length; i++) {\n      var w = num.words[i] | 0;\n      lo += w * 0x3d1;\n      num.words[i] = lo & 0x3ffffff;\n      lo = w * 0x40 + ((lo / 0x4000000) | 0);\n    }\n\n    // Fast length reduction\n    if (num.words[num.length - 1] === 0) {\n      num.length--;\n      if (num.words[num.length - 1] === 0) {\n        num.length--;\n      }\n    }\n    return num;\n  };\n\n  function P224 () {\n    MPrime.call(\n      this,\n      'p224',\n      'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001');\n  }\n  inherits(P224, MPrime);\n\n  function P192 () {\n    MPrime.call(\n      this,\n      'p192',\n      'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff');\n  }\n  inherits(P192, MPrime);\n\n  function P25519 () {\n    // 2 ^ 255 - 19\n    MPrime.call(\n      this,\n      '25519',\n      '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed');\n  }\n  inherits(P25519, MPrime);\n\n  P25519.prototype.imulK = function imulK (num) {\n    // K = 0x13\n    var carry = 0;\n    for (var i = 0; i < num.length; i++) {\n      var hi = (num.words[i] | 0) * 0x13 + carry;\n      var lo = hi & 0x3ffffff;\n      hi >>>= 26;\n\n      num.words[i] = lo;\n      carry = hi;\n    }\n    if (carry !== 0) {\n      num.words[num.length++] = carry;\n    }\n    return num;\n  };\n\n  // Exported mostly for testing purposes, use plain name instead\n  BN._prime = function prime (name) {\n    // Cached version of prime\n    if (primes[name]) return primes[name];\n\n    var prime;\n    if (name === 'k256') {\n      prime = new K256();\n    } else if (name === 'p224') {\n      prime = new P224();\n    } else if (name === 'p192') {\n      prime = new P192();\n    } else if (name === 'p25519') {\n      prime = new P25519();\n    } else {\n      throw new Error('Unknown prime ' + name);\n    }\n    primes[name] = prime;\n\n    return prime;\n  };\n\n  //\n  // Base reduction engine\n  //\n  function Red (m) {\n    if (typeof m === 'string') {\n      var prime = BN._prime(m);\n      this.m = prime.p;\n      this.prime = prime;\n    } else {\n      assert(m.gtn(1), 'modulus must be greater than 1');\n      this.m = m;\n      this.prime = null;\n    }\n  }\n\n  Red.prototype._verify1 = function _verify1 (a) {\n    assert(a.negative === 0, 'red works only with positives');\n    assert(a.red, 'red works only with red numbers');\n  };\n\n  Red.prototype._verify2 = function _verify2 (a, b) {\n    assert((a.negative | b.negative) === 0, 'red works only with positives');\n    assert(a.red && a.red === b.red,\n      'red works only with red numbers');\n  };\n\n  Red.prototype.imod = function imod (a) {\n    if (this.prime) return this.prime.ireduce(a)._forceRed(this);\n    return a.umod(this.m)._forceRed(this);\n  };\n\n  Red.prototype.neg = function neg (a) {\n    if (a.isZero()) {\n      return a.clone();\n    }\n\n    return this.m.sub(a)._forceRed(this);\n  };\n\n  Red.prototype.add = function add (a, b) {\n    this._verify2(a, b);\n\n    var res = a.add(b);\n    if (res.cmp(this.m) >= 0) {\n      res.isub(this.m);\n    }\n    return res._forceRed(this);\n  };\n\n  Red.prototype.iadd = function iadd (a, b) {\n    this._verify2(a, b);\n\n    var res = a.iadd(b);\n    if (res.cmp(this.m) >= 0) {\n      res.isub(this.m);\n    }\n    return res;\n  };\n\n  Red.prototype.sub = function sub (a, b) {\n    this._verify2(a, b);\n\n    var res = a.sub(b);\n    if (res.cmpn(0) < 0) {\n      res.iadd(this.m);\n    }\n    return res._forceRed(this);\n  };\n\n  Red.prototype.isub = function isub (a, b) {\n    this._verify2(a, b);\n\n    var res = a.isub(b);\n    if (res.cmpn(0) < 0) {\n      res.iadd(this.m);\n    }\n    return res;\n  };\n\n  Red.prototype.shl = function shl (a, num) {\n    this._verify1(a);\n    return this.imod(a.ushln(num));\n  };\n\n  Red.prototype.imul = function imul (a, b) {\n    this._verify2(a, b);\n    return this.imod(a.imul(b));\n  };\n\n  Red.prototype.mul = function mul (a, b) {\n    this._verify2(a, b);\n    return this.imod(a.mul(b));\n  };\n\n  Red.prototype.isqr = function isqr (a) {\n    return this.imul(a, a.clone());\n  };\n\n  Red.prototype.sqr = function sqr (a) {\n    return this.mul(a, a);\n  };\n\n  Red.prototype.sqrt = function sqrt (a) {\n    if (a.isZero()) return a.clone();\n\n    var mod3 = this.m.andln(3);\n    assert(mod3 % 2 === 1);\n\n    // Fast case\n    if (mod3 === 3) {\n      var pow = this.m.add(new BN(1)).iushrn(2);\n      return this.pow(a, pow);\n    }\n\n    // Tonelli-Shanks algorithm (Totally unoptimized and slow)\n    //\n    // Find Q and S, that Q * 2 ^ S = (P - 1)\n    var q = this.m.subn(1);\n    var s = 0;\n    while (!q.isZero() && q.andln(1) === 0) {\n      s++;\n      q.iushrn(1);\n    }\n    assert(!q.isZero());\n\n    var one = new BN(1).toRed(this);\n    var nOne = one.redNeg();\n\n    // Find quadratic non-residue\n    // NOTE: Max is such because of generalized Riemann hypothesis.\n    var lpow = this.m.subn(1).iushrn(1);\n    var z = this.m.bitLength();\n    z = new BN(2 * z * z).toRed(this);\n\n    while (this.pow(z, lpow).cmp(nOne) !== 0) {\n      z.redIAdd(nOne);\n    }\n\n    var c = this.pow(z, q);\n    var r = this.pow(a, q.addn(1).iushrn(1));\n    var t = this.pow(a, q);\n    var m = s;\n    while (t.cmp(one) !== 0) {\n      var tmp = t;\n      for (var i = 0; tmp.cmp(one) !== 0; i++) {\n        tmp = tmp.redSqr();\n      }\n      assert(i < m);\n      var b = this.pow(c, new BN(1).iushln(m - i - 1));\n\n      r = r.redMul(b);\n      c = b.redSqr();\n      t = t.redMul(c);\n      m = i;\n    }\n\n    return r;\n  };\n\n  Red.prototype.invm = function invm (a) {\n    var inv = a._invmp(this.m);\n    if (inv.negative !== 0) {\n      inv.negative = 0;\n      return this.imod(inv).redNeg();\n    } else {\n      return this.imod(inv);\n    }\n  };\n\n  Red.prototype.pow = function pow (a, num) {\n    if (num.isZero()) return new BN(1).toRed(this);\n    if (num.cmpn(1) === 0) return a.clone();\n\n    var windowSize = 4;\n    var wnd = new Array(1 << windowSize);\n    wnd[0] = new BN(1).toRed(this);\n    wnd[1] = a;\n    for (var i = 2; i < wnd.length; i++) {\n      wnd[i] = this.mul(wnd[i - 1], a);\n    }\n\n    var res = wnd[0];\n    var current = 0;\n    var currentLen = 0;\n    var start = num.bitLength() % 26;\n    if (start === 0) {\n      start = 26;\n    }\n\n    for (i = num.length - 1; i >= 0; i--) {\n      var word = num.words[i];\n      for (var j = start - 1; j >= 0; j--) {\n        var bit = (word >> j) & 1;\n        if (res !== wnd[0]) {\n          res = this.sqr(res);\n        }\n\n        if (bit === 0 && current === 0) {\n          currentLen = 0;\n          continue;\n        }\n\n        current <<= 1;\n        current |= bit;\n        currentLen++;\n        if (currentLen !== windowSize && (i !== 0 || j !== 0)) continue;\n\n        res = this.mul(res, wnd[current]);\n        currentLen = 0;\n        current = 0;\n      }\n      start = 26;\n    }\n\n    return res;\n  };\n\n  Red.prototype.convertTo = function convertTo (num) {\n    var r = num.umod(this.m);\n\n    return r === num ? r.clone() : r;\n  };\n\n  Red.prototype.convertFrom = function convertFrom (num) {\n    var res = num.clone();\n    res.red = null;\n    return res;\n  };\n\n  //\n  // Montgomery method engine\n  //\n\n  BN.mont = function mont (num) {\n    return new Mont(num);\n  };\n\n  function Mont (m) {\n    Red.call(this, m);\n\n    this.shift = this.m.bitLength();\n    if (this.shift % 26 !== 0) {\n      this.shift += 26 - (this.shift % 26);\n    }\n\n    this.r = new BN(1).iushln(this.shift);\n    this.r2 = this.imod(this.r.sqr());\n    this.rinv = this.r._invmp(this.m);\n\n    this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);\n    this.minv = this.minv.umod(this.r);\n    this.minv = this.r.sub(this.minv);\n  }\n  inherits(Mont, Red);\n\n  Mont.prototype.convertTo = function convertTo (num) {\n    return this.imod(num.ushln(this.shift));\n  };\n\n  Mont.prototype.convertFrom = function convertFrom (num) {\n    var r = this.imod(num.mul(this.rinv));\n    r.red = null;\n    return r;\n  };\n\n  Mont.prototype.imul = function imul (a, b) {\n    if (a.isZero() || b.isZero()) {\n      a.words[0] = 0;\n      a.length = 1;\n      return a;\n    }\n\n    var t = a.imul(b);\n    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);\n    var u = t.isub(c).iushrn(this.shift);\n    var res = u;\n\n    if (u.cmp(this.m) >= 0) {\n      res = u.isub(this.m);\n    } else if (u.cmpn(0) < 0) {\n      res = u.iadd(this.m);\n    }\n\n    return res._forceRed(this);\n  };\n\n  Mont.prototype.mul = function mul (a, b) {\n    if (a.isZero() || b.isZero()) return new BN(0)._forceRed(this);\n\n    var t = a.mul(b);\n    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);\n    var u = t.isub(c).iushrn(this.shift);\n    var res = u;\n    if (u.cmp(this.m) >= 0) {\n      res = u.isub(this.m);\n    } else if (u.cmpn(0) < 0) {\n      res = u.iadd(this.m);\n    }\n\n    return res._forceRed(this);\n  };\n\n  Mont.prototype.invm = function invm (a) {\n    // (AR)^-1 * R^2 = (A^-1 * R^-1) * R^2 = A^-1 * R\n    var res = this.imod(a._invmp(this.m).mul(this.r2));\n    return res._forceRed(this);\n  };\n})( false || module, this);\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../webpack/buildin/module.js */ \"./node_modules/webpack/buildin/module.js\")(module)))\n\n//# sourceURL=webpack:///./node_modules/bn.js/lib/bn.js?");

/***/ }),

/***/ "./node_modules/boundary-cells/boundary.js":
/*!*************************************************!*\
  !*** ./node_modules/boundary-cells/boundary.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = boundary\n\nfunction boundary (cells) {\n  var i, j, k\n  var n = cells.length\n  var sz = 0\n  for (i = 0; i < n; ++i) {\n    sz += cells[i].length\n  }\n  var result = new Array(sz)\n  var ptr = 0\n  for (i = 0; i < n; ++i) {\n    var c = cells[i]\n    var d = c.length\n    for (j = 0; j < d; ++j) {\n      var b = result[ptr++] = new Array(d - 1)\n      var p = 0\n      for (k = 0; k < d; ++k) {\n        if (k === j) {\n          continue\n        }\n        b[p++] = c[k]\n      }\n      if (j & 1) {\n        var tmp = b[1]\n        b[1] = b[0]\n        b[0] = tmp\n      }\n    }\n  }\n  return result\n}\n\n\n//# sourceURL=webpack:///./node_modules/boundary-cells/boundary.js?");

/***/ }),

/***/ "./node_modules/box-intersect/index.js":
/*!*********************************************!*\
  !*** ./node_modules/box-intersect/index.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = boxIntersectWrapper\n\nvar pool = __webpack_require__(/*! typedarray-pool */ \"./node_modules/typedarray-pool/pool.js\")\nvar sweep = __webpack_require__(/*! ./lib/sweep */ \"./node_modules/box-intersect/lib/sweep.js\")\nvar boxIntersectIter = __webpack_require__(/*! ./lib/intersect */ \"./node_modules/box-intersect/lib/intersect.js\")\n\nfunction boxEmpty(d, box) {\n  for(var j=0; j<d; ++j) {\n    if(!(box[j] <= box[j+d])) {\n      return true\n    }\n  }\n  return false\n}\n\n//Unpack boxes into a flat typed array, remove empty boxes\nfunction convertBoxes(boxes, d, data, ids) {\n  var ptr = 0\n  var count = 0\n  for(var i=0, n=boxes.length; i<n; ++i) {\n    var b = boxes[i]\n    if(boxEmpty(d, b)) {\n      continue\n    }\n    for(var j=0; j<2*d; ++j) {\n      data[ptr++] = b[j]\n    }\n    ids[count++] = i\n  }\n  return count\n}\n\n//Perform type conversions, check bounds\nfunction boxIntersect(red, blue, visit, full) {\n  var n = red.length\n  var m = blue.length\n\n  //If either array is empty, then we can skip this whole thing\n  if(n <= 0 || m <= 0) {\n    return\n  }\n\n  //Compute dimension, if it is 0 then we skip\n  var d = (red[0].length)>>>1\n  if(d <= 0) {\n    return\n  }\n\n  var retval\n\n  //Convert red boxes\n  var redList  = pool.mallocDouble(2*d*n)\n  var redIds   = pool.mallocInt32(n)\n  n = convertBoxes(red, d, redList, redIds)\n\n  if(n > 0) {\n    if(d === 1 && full) {\n      //Special case: 1d complete\n      sweep.init(n)\n      retval = sweep.sweepComplete(\n        d, visit, \n        0, n, redList, redIds,\n        0, n, redList, redIds)\n    } else {\n\n      //Convert blue boxes\n      var blueList = pool.mallocDouble(2*d*m)\n      var blueIds  = pool.mallocInt32(m)\n      m = convertBoxes(blue, d, blueList, blueIds)\n\n      if(m > 0) {\n        sweep.init(n+m)\n\n        if(d === 1) {\n          //Special case: 1d bipartite\n          retval = sweep.sweepBipartite(\n            d, visit, \n            0, n, redList,  redIds,\n            0, m, blueList, blueIds)\n        } else {\n          //General case:  d>1\n          retval = boxIntersectIter(\n            d, visit,    full,\n            n, redList,  redIds,\n            m, blueList, blueIds)\n        }\n\n        pool.free(blueList)\n        pool.free(blueIds)\n      }\n    }\n\n    pool.free(redList)\n    pool.free(redIds)\n  }\n\n  return retval\n}\n\n\nvar RESULT\n\nfunction appendItem(i,j) {\n  RESULT.push([i,j])\n}\n\nfunction intersectFullArray(x) {\n  RESULT = []\n  boxIntersect(x, x, appendItem, true)\n  return RESULT\n}\n\nfunction intersectBipartiteArray(x, y) {\n  RESULT = []\n  boxIntersect(x, y, appendItem, false)\n  return RESULT\n}\n\n//User-friendly wrapper, handle full input and no-visitor cases\nfunction boxIntersectWrapper(arg0, arg1, arg2) {\n  var result\n  switch(arguments.length) {\n    case 1:\n      return intersectFullArray(arg0)\n    case 2:\n      if(typeof arg1 === 'function') {\n        return boxIntersect(arg0, arg0, arg1, true)\n      } else {\n        return intersectBipartiteArray(arg0, arg1)\n      }\n    case 3:\n      return boxIntersect(arg0, arg1, arg2, false)\n    default:\n      throw new Error('box-intersect: Invalid arguments')\n  }\n}\n\n//# sourceURL=webpack:///./node_modules/box-intersect/index.js?");

/***/ }),

/***/ "./node_modules/box-intersect/lib/brute.js":
/*!*************************************************!*\
  !*** ./node_modules/box-intersect/lib/brute.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar DIMENSION   = 'd'\nvar AXIS        = 'ax'\nvar VISIT       = 'vv'\nvar FLIP        = 'fp'\n\nvar ELEM_SIZE   = 'es'\n\nvar RED_START   = 'rs'\nvar RED_END     = 're'\nvar RED_BOXES   = 'rb'\nvar RED_INDEX   = 'ri'\nvar RED_PTR     = 'rp'\n\nvar BLUE_START  = 'bs'\nvar BLUE_END    = 'be'\nvar BLUE_BOXES  = 'bb'\nvar BLUE_INDEX  = 'bi'\nvar BLUE_PTR    = 'bp'\n\nvar RETVAL      = 'rv'\n\nvar INNER_LABEL = 'Q'\n\nvar ARGS = [\n  DIMENSION,\n  AXIS,\n  VISIT,\n  RED_START,\n  RED_END,\n  RED_BOXES,\n  RED_INDEX,\n  BLUE_START,\n  BLUE_END,\n  BLUE_BOXES,\n  BLUE_INDEX\n]\n\nfunction generateBruteForce(redMajor, flip, full) {\n  var funcName = 'bruteForce' + \n    (redMajor ? 'Red' : 'Blue') + \n    (flip ? 'Flip' : '') +\n    (full ? 'Full' : '')\n\n  var code = ['function ', funcName, '(', ARGS.join(), '){',\n    'var ', ELEM_SIZE, '=2*', DIMENSION, ';']\n\n  var redLoop = \n    'for(var i=' + RED_START + ',' + RED_PTR + '=' + ELEM_SIZE + '*' + RED_START + ';' +\n        'i<' + RED_END +';' +\n        '++i,' + RED_PTR + '+=' + ELEM_SIZE + '){' +\n        'var x0=' + RED_BOXES + '[' + AXIS + '+' + RED_PTR + '],' +\n            'x1=' + RED_BOXES + '[' + AXIS + '+' + RED_PTR + '+' + DIMENSION + '],' +\n            'xi=' + RED_INDEX + '[i];'\n\n  var blueLoop = \n    'for(var j=' + BLUE_START + ',' + BLUE_PTR + '=' + ELEM_SIZE + '*' + BLUE_START + ';' +\n        'j<' + BLUE_END + ';' +\n        '++j,' + BLUE_PTR + '+=' + ELEM_SIZE + '){' +\n        'var y0=' + BLUE_BOXES + '[' + AXIS + '+' + BLUE_PTR + '],' +\n            (full ? 'y1=' + BLUE_BOXES + '[' + AXIS + '+' + BLUE_PTR + '+' + DIMENSION + '],' : '') +\n            'yi=' + BLUE_INDEX + '[j];'\n\n  if(redMajor) {\n    code.push(redLoop, INNER_LABEL, ':', blueLoop)\n  } else {\n    code.push(blueLoop, INNER_LABEL, ':', redLoop)\n  }\n\n  if(full) {\n    code.push('if(y1<x0||x1<y0)continue;')\n  } else if(flip) {\n    code.push('if(y0<=x0||x1<y0)continue;')\n  } else {\n    code.push('if(y0<x0||x1<y0)continue;')\n  }\n\n  code.push('for(var k='+AXIS+'+1;k<'+DIMENSION+';++k){'+\n    'var r0='+RED_BOXES+'[k+'+RED_PTR+'],'+\n        'r1='+RED_BOXES+'[k+'+DIMENSION+'+'+RED_PTR+'],'+\n        'b0='+BLUE_BOXES+'[k+'+BLUE_PTR+'],'+\n        'b1='+BLUE_BOXES+'[k+'+DIMENSION+'+'+BLUE_PTR+'];'+\n      'if(r1<b0||b1<r0)continue ' + INNER_LABEL + ';}' +\n      'var ' + RETVAL + '=' + VISIT + '(')\n\n  if(flip) {\n    code.push('yi,xi')\n  } else {\n    code.push('xi,yi')\n  }\n\n  code.push(');if(' + RETVAL + '!==void 0)return ' + RETVAL + ';}}}')\n\n  return {\n    name: funcName, \n    code: code.join('')\n  }\n}\n\nfunction bruteForcePlanner(full) {\n  var funcName = 'bruteForce' + (full ? 'Full' : 'Partial')\n  var prefix = []\n  var fargs = ARGS.slice()\n  if(!full) {\n    fargs.splice(3, 0, FLIP)\n  }\n\n  var code = ['function ' + funcName + '(' + fargs.join() + '){']\n\n  function invoke(redMajor, flip) {\n    var res = generateBruteForce(redMajor, flip, full)\n    prefix.push(res.code)\n    code.push('return ' + res.name + '(' + ARGS.join() + ');')\n  }\n\n  code.push('if(' + RED_END + '-' + RED_START + '>' +\n                    BLUE_END + '-' + BLUE_START + '){')\n\n  if(full) {\n    invoke(true, false)\n    code.push('}else{')\n    invoke(false, false)\n  } else {\n    code.push('if(' + FLIP + '){')\n    invoke(true, true)\n    code.push('}else{')\n    invoke(true, false)\n    code.push('}}else{if(' + FLIP + '){')\n    invoke(false, true)\n    code.push('}else{')\n    invoke(false, false)\n    code.push('}')\n  }\n  code.push('}}return ' + funcName)\n\n  var codeStr = prefix.join('') + code.join('')\n  var proc = new Function(codeStr)\n  return proc()\n}\n\n\nexports.partial = bruteForcePlanner(false)\nexports.full    = bruteForcePlanner(true)\n\n//# sourceURL=webpack:///./node_modules/box-intersect/lib/brute.js?");

/***/ }),

/***/ "./node_modules/box-intersect/lib/intersect.js":
/*!*****************************************************!*\
  !*** ./node_modules/box-intersect/lib/intersect.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = boxIntersectIter\n\nvar pool = __webpack_require__(/*! typedarray-pool */ \"./node_modules/typedarray-pool/pool.js\")\nvar bits = __webpack_require__(/*! bit-twiddle */ \"./node_modules/bit-twiddle/twiddle.js\")\nvar bruteForce = __webpack_require__(/*! ./brute */ \"./node_modules/box-intersect/lib/brute.js\")\nvar bruteForcePartial = bruteForce.partial\nvar bruteForceFull = bruteForce.full\nvar sweep = __webpack_require__(/*! ./sweep */ \"./node_modules/box-intersect/lib/sweep.js\")\nvar findMedian = __webpack_require__(/*! ./median */ \"./node_modules/box-intersect/lib/median.js\")\nvar genPartition = __webpack_require__(/*! ./partition */ \"./node_modules/box-intersect/lib/partition.js\")\n\n//Twiddle parameters\nvar BRUTE_FORCE_CUTOFF    = 128       //Cut off for brute force search\nvar SCAN_CUTOFF           = (1<<22)   //Cut off for two way scan\nvar SCAN_COMPLETE_CUTOFF  = (1<<22)  \n\n//Partition functions\nvar partitionInteriorContainsInterval = genPartition(\n  '!(lo>=p0)&&!(p1>=hi)', \n  ['p0', 'p1'])\n\nvar partitionStartEqual = genPartition(\n  'lo===p0',\n  ['p0'])\n\nvar partitionStartLessThan = genPartition(\n  'lo<p0',\n  ['p0'])\n\nvar partitionEndLessThanEqual = genPartition(\n  'hi<=p0',\n  ['p0'])\n\nvar partitionContainsPoint = genPartition(\n  'lo<=p0&&p0<=hi',\n  ['p0'])\n\nvar partitionContainsPointProper = genPartition(\n  'lo<p0&&p0<=hi',\n  ['p0'])\n\n//Frame size for iterative loop\nvar IFRAME_SIZE = 6\nvar DFRAME_SIZE = 2\n\n//Data for box statck\nvar INIT_CAPACITY = 1024\nvar BOX_ISTACK  = pool.mallocInt32(INIT_CAPACITY)\nvar BOX_DSTACK  = pool.mallocDouble(INIT_CAPACITY)\n\n//Initialize iterative loop queue\nfunction iterInit(d, count) {\n  var levels = (8 * bits.log2(count+1) * (d+1))|0\n  var maxInts = bits.nextPow2(IFRAME_SIZE*levels)\n  if(BOX_ISTACK.length < maxInts) {\n    pool.free(BOX_ISTACK)\n    BOX_ISTACK = pool.mallocInt32(maxInts)\n  }\n  var maxDoubles = bits.nextPow2(DFRAME_SIZE*levels)\n  if(BOX_DSTACK.length < maxDoubles) {\n    pool.free(BOX_DSTACK)\n    BOX_DSTACK = pool.mallocDouble(maxDoubles)\n  }\n}\n\n//Append item to queue\nfunction iterPush(ptr,\n  axis, \n  redStart, redEnd, \n  blueStart, blueEnd, \n  state, \n  lo, hi) {\n\n  var iptr = IFRAME_SIZE * ptr\n  BOX_ISTACK[iptr]   = axis\n  BOX_ISTACK[iptr+1] = redStart\n  BOX_ISTACK[iptr+2] = redEnd\n  BOX_ISTACK[iptr+3] = blueStart\n  BOX_ISTACK[iptr+4] = blueEnd\n  BOX_ISTACK[iptr+5] = state\n\n  var dptr = DFRAME_SIZE * ptr\n  BOX_DSTACK[dptr]   = lo\n  BOX_DSTACK[dptr+1] = hi\n}\n\n//Special case:  Intersect single point with list of intervals\nfunction onePointPartial(\n  d, axis, visit, flip,\n  redStart, redEnd, red, redIndex,\n  blueOffset, blue, blueId) {\n\n  var elemSize = 2 * d\n  var bluePtr  = blueOffset * elemSize\n  var blueX    = blue[bluePtr + axis]\n\nred_loop:\n  for(var i=redStart, redPtr=redStart*elemSize; i<redEnd; ++i, redPtr+=elemSize) {\n    var r0 = red[redPtr+axis]\n    var r1 = red[redPtr+axis+d]\n    if(blueX < r0 || r1 < blueX) {\n      continue\n    }\n    if(flip && blueX === r0) {\n      continue\n    }\n    var redId = redIndex[i]\n    for(var j=axis+1; j<d; ++j) {\n      var r0 = red[redPtr+j]\n      var r1 = red[redPtr+j+d]\n      var b0 = blue[bluePtr+j]\n      var b1 = blue[bluePtr+j+d]\n      if(r1 < b0 || b1 < r0) {\n        continue red_loop\n      }\n    }\n    var retval\n    if(flip) {\n      retval = visit(blueId, redId)\n    } else {\n      retval = visit(redId, blueId)\n    }\n    if(retval !== void 0) {\n      return retval\n    }\n  }\n}\n\n//Special case:  Intersect one point with list of intervals\nfunction onePointFull(\n  d, axis, visit,\n  redStart, redEnd, red, redIndex,\n  blueOffset, blue, blueId) {\n\n  var elemSize = 2 * d\n  var bluePtr  = blueOffset * elemSize\n  var blueX    = blue[bluePtr + axis]\n\nred_loop:\n  for(var i=redStart, redPtr=redStart*elemSize; i<redEnd; ++i, redPtr+=elemSize) {\n    var redId = redIndex[i]\n    if(redId === blueId) {\n      continue\n    }\n    var r0 = red[redPtr+axis]\n    var r1 = red[redPtr+axis+d]\n    if(blueX < r0 || r1 < blueX) {\n      continue\n    }\n    for(var j=axis+1; j<d; ++j) {\n      var r0 = red[redPtr+j]\n      var r1 = red[redPtr+j+d]\n      var b0 = blue[bluePtr+j]\n      var b1 = blue[bluePtr+j+d]\n      if(r1 < b0 || b1 < r0) {\n        continue red_loop\n      }\n    }\n    var retval = visit(redId, blueId)\n    if(retval !== void 0) {\n      return retval\n    }\n  }\n}\n\n//The main box intersection routine\nfunction boxIntersectIter(\n  d, visit, initFull,\n  xSize, xBoxes, xIndex,\n  ySize, yBoxes, yIndex) {\n\n  //Reserve memory for stack\n  iterInit(d, xSize + ySize)\n\n  var top  = 0\n  var elemSize = 2 * d\n  var retval\n\n  iterPush(top++,\n      0,\n      0, xSize,\n      0, ySize,\n      initFull ? 16 : 0, \n      -Infinity, Infinity)\n  if(!initFull) {\n    iterPush(top++,\n      0,\n      0, ySize,\n      0, xSize,\n      1, \n      -Infinity, Infinity)\n  }\n\n  while(top > 0) {\n    top  -= 1\n\n    var iptr = top * IFRAME_SIZE\n    var axis      = BOX_ISTACK[iptr]\n    var redStart  = BOX_ISTACK[iptr+1]\n    var redEnd    = BOX_ISTACK[iptr+2]\n    var blueStart = BOX_ISTACK[iptr+3]\n    var blueEnd   = BOX_ISTACK[iptr+4]\n    var state     = BOX_ISTACK[iptr+5]\n\n    var dptr = top * DFRAME_SIZE\n    var lo        = BOX_DSTACK[dptr]\n    var hi        = BOX_DSTACK[dptr+1]\n\n    //Unpack state info\n    var flip      = (state & 1)\n    var full      = !!(state & 16)\n\n    //Unpack indices\n    var red       = xBoxes\n    var redIndex  = xIndex\n    var blue      = yBoxes\n    var blueIndex = yIndex\n    if(flip) {\n      red         = yBoxes\n      redIndex    = yIndex\n      blue        = xBoxes\n      blueIndex   = xIndex\n    }\n\n    if(state & 2) {\n      redEnd = partitionStartLessThan(\n        d, axis,\n        redStart, redEnd, red, redIndex,\n        hi)\n      if(redStart >= redEnd) {\n        continue\n      }\n    }\n    if(state & 4) {\n      redStart = partitionEndLessThanEqual(\n        d, axis,\n        redStart, redEnd, red, redIndex,\n        lo)\n      if(redStart >= redEnd) {\n        continue\n      }\n    }\n    \n    var redCount  = redEnd  - redStart\n    var blueCount = blueEnd - blueStart\n\n    if(full) {\n      if(d * redCount * (redCount + blueCount) < SCAN_COMPLETE_CUTOFF) {\n        retval = sweep.scanComplete(\n          d, axis, visit, \n          redStart, redEnd, red, redIndex,\n          blueStart, blueEnd, blue, blueIndex)\n        if(retval !== void 0) {\n          return retval\n        }\n        continue\n      }\n    } else {\n      if(d * Math.min(redCount, blueCount) < BRUTE_FORCE_CUTOFF) {\n        //If input small, then use brute force\n        retval = bruteForcePartial(\n            d, axis, visit, flip,\n            redStart,  redEnd,  red,  redIndex,\n            blueStart, blueEnd, blue, blueIndex)\n        if(retval !== void 0) {\n          return retval\n        }\n        continue\n      } else if(d * redCount * blueCount < SCAN_CUTOFF) {\n        //If input medium sized, then use sweep and prune\n        retval = sweep.scanBipartite(\n          d, axis, visit, flip, \n          redStart, redEnd, red, redIndex,\n          blueStart, blueEnd, blue, blueIndex)\n        if(retval !== void 0) {\n          return retval\n        }\n        continue\n      }\n    }\n    \n    //First, find all red intervals whose interior contains (lo,hi)\n    var red0 = partitionInteriorContainsInterval(\n      d, axis, \n      redStart, redEnd, red, redIndex,\n      lo, hi)\n\n    //Lower dimensional case\n    if(redStart < red0) {\n\n      if(d * (red0 - redStart) < BRUTE_FORCE_CUTOFF) {\n        //Special case for small inputs: use brute force\n        retval = bruteForceFull(\n          d, axis+1, visit,\n          redStart, red0, red, redIndex,\n          blueStart, blueEnd, blue, blueIndex)\n        if(retval !== void 0) {\n          return retval\n        }\n      } else if(axis === d-2) {\n        if(flip) {\n          retval = sweep.sweepBipartite(\n            d, visit,\n            blueStart, blueEnd, blue, blueIndex,\n            redStart, red0, red, redIndex)\n        } else {\n          retval = sweep.sweepBipartite(\n            d, visit,\n            redStart, red0, red, redIndex,\n            blueStart, blueEnd, blue, blueIndex)\n        }\n        if(retval !== void 0) {\n          return retval\n        }\n      } else {\n        iterPush(top++,\n          axis+1,\n          redStart, red0,\n          blueStart, blueEnd,\n          flip,\n          -Infinity, Infinity)\n        iterPush(top++,\n          axis+1,\n          blueStart, blueEnd,\n          redStart, red0,\n          flip^1,\n          -Infinity, Infinity)\n      }\n    }\n\n    //Divide and conquer phase\n    if(red0 < redEnd) {\n\n      //Cut blue into 3 parts:\n      //\n      //  Points < mid point\n      //  Points = mid point\n      //  Points > mid point\n      //\n      var blue0 = findMedian(\n        d, axis, \n        blueStart, blueEnd, blue, blueIndex)\n      var mid = blue[elemSize * blue0 + axis]\n      var blue1 = partitionStartEqual(\n        d, axis,\n        blue0, blueEnd, blue, blueIndex,\n        mid)\n\n      //Right case\n      if(blue1 < blueEnd) {\n        iterPush(top++,\n          axis,\n          red0, redEnd,\n          blue1, blueEnd,\n          (flip|4) + (full ? 16 : 0),\n          mid, hi)\n      }\n\n      //Left case\n      if(blueStart < blue0) {\n        iterPush(top++,\n          axis,\n          red0, redEnd,\n          blueStart, blue0,\n          (flip|2) + (full ? 16 : 0),\n          lo, mid)\n      }\n\n      //Center case (the hard part)\n      if(blue0 + 1 === blue1) {\n        //Optimization: Range with exactly 1 point, use a brute force scan\n        if(full) {\n          retval = onePointFull(\n            d, axis, visit,\n            red0, redEnd, red, redIndex,\n            blue0, blue, blueIndex[blue0])\n        } else {\n          retval = onePointPartial(\n            d, axis, visit, flip,\n            red0, redEnd, red, redIndex,\n            blue0, blue, blueIndex[blue0])\n        }\n        if(retval !== void 0) {\n          return retval\n        }\n      } else if(blue0 < blue1) {\n        var red1\n        if(full) {\n          //If full intersection, need to handle special case\n          red1 = partitionContainsPoint(\n            d, axis,\n            red0, redEnd, red, redIndex,\n            mid)\n          if(red0 < red1) {\n            var redX = partitionStartEqual(\n              d, axis,\n              red0, red1, red, redIndex,\n              mid)\n            if(axis === d-2) {\n              //Degenerate sweep intersection:\n              //  [red0, redX] with [blue0, blue1]\n              if(red0 < redX) {\n                retval = sweep.sweepComplete(\n                  d, visit,\n                  red0, redX, red, redIndex,\n                  blue0, blue1, blue, blueIndex)\n                if(retval !== void 0) {\n                  return retval\n                }\n              }\n\n              //Normal sweep intersection:\n              //  [redX, red1] with [blue0, blue1]\n              if(redX < red1) {\n                retval = sweep.sweepBipartite(\n                  d, visit,\n                  redX, red1, red, redIndex,\n                  blue0, blue1, blue, blueIndex)\n                if(retval !== void 0) {\n                  return retval\n                }\n              }\n            } else {\n              if(red0 < redX) {\n                iterPush(top++,\n                  axis+1,\n                  red0, redX,\n                  blue0, blue1,\n                  16,\n                  -Infinity, Infinity)\n              }\n              if(redX < red1) {\n                iterPush(top++,\n                  axis+1,\n                  redX, red1,\n                  blue0, blue1,\n                  0,\n                  -Infinity, Infinity)\n                iterPush(top++,\n                  axis+1,\n                  blue0, blue1,\n                  redX, red1,\n                  1,\n                  -Infinity, Infinity)\n              }\n            }\n          }\n        } else {\n          if(flip) {\n            red1 = partitionContainsPointProper(\n              d, axis,\n              red0, redEnd, red, redIndex,\n              mid)\n          } else {\n            red1 = partitionContainsPoint(\n              d, axis,\n              red0, redEnd, red, redIndex,\n              mid)\n          }\n          if(red0 < red1) {\n            if(axis === d-2) {\n              if(flip) {\n                retval = sweep.sweepBipartite(\n                  d, visit,\n                  blue0, blue1, blue, blueIndex,\n                  red0, red1, red, redIndex)\n              } else {\n                retval = sweep.sweepBipartite(\n                  d, visit,\n                  red0, red1, red, redIndex,\n                  blue0, blue1, blue, blueIndex)\n              }\n            } else {\n              iterPush(top++,\n                axis+1,\n                red0, red1,\n                blue0, blue1,\n                flip,\n                -Infinity, Infinity)\n              iterPush(top++,\n                axis+1,\n                blue0, blue1,\n                red0, red1,\n                flip^1,\n                -Infinity, Infinity)\n            }\n          }\n        }\n      }\n    }\n  }\n}\n\n//# sourceURL=webpack:///./node_modules/box-intersect/lib/intersect.js?");

/***/ }),

/***/ "./node_modules/box-intersect/lib/median.js":
/*!**************************************************!*\
  !*** ./node_modules/box-intersect/lib/median.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = findMedian\n\nvar genPartition = __webpack_require__(/*! ./partition */ \"./node_modules/box-intersect/lib/partition.js\")\n\nvar partitionStartLessThan = genPartition('lo<p0', ['p0'])\n\nvar PARTITION_THRESHOLD = 8   //Cut off for using insertion sort in findMedian\n\n//Base case for median finding:  Use insertion sort\nfunction insertionSort(d, axis, start, end, boxes, ids) {\n  var elemSize = 2 * d\n  var boxPtr = elemSize * (start+1) + axis\n  for(var i=start+1; i<end; ++i, boxPtr+=elemSize) {\n    var x = boxes[boxPtr]\n    for(var j=i, ptr=elemSize*(i-1); \n        j>start && boxes[ptr+axis] > x; \n        --j, ptr-=elemSize) {\n      //Swap\n      var aPtr = ptr\n      var bPtr = ptr+elemSize\n      for(var k=0; k<elemSize; ++k, ++aPtr, ++bPtr) {\n        var y = boxes[aPtr]\n        boxes[aPtr] = boxes[bPtr]\n        boxes[bPtr] = y\n      }\n      var tmp = ids[j]\n      ids[j] = ids[j-1]\n      ids[j-1] = tmp\n    }\n  }\n}\n\n//Find median using quick select algorithm\n//  takes O(n) time with high probability\nfunction findMedian(d, axis, start, end, boxes, ids) {\n  if(end <= start+1) {\n    return start\n  }\n\n  var lo       = start\n  var hi       = end\n  var mid      = ((end + start) >>> 1)\n  var elemSize = 2*d\n  var pivot    = mid\n  var value    = boxes[elemSize*mid+axis]\n  \n  while(lo < hi) {\n    if(hi - lo < PARTITION_THRESHOLD) {\n      insertionSort(d, axis, lo, hi, boxes, ids)\n      value = boxes[elemSize*mid+axis]\n      break\n    }\n    \n    //Select pivot using median-of-3\n    var count  = hi - lo\n    var pivot0 = (Math.random()*count+lo)|0\n    var value0 = boxes[elemSize*pivot0 + axis]\n    var pivot1 = (Math.random()*count+lo)|0\n    var value1 = boxes[elemSize*pivot1 + axis]\n    var pivot2 = (Math.random()*count+lo)|0\n    var value2 = boxes[elemSize*pivot2 + axis]\n    if(value0 <= value1) {\n      if(value2 >= value1) {\n        pivot = pivot1\n        value = value1\n      } else if(value0 >= value2) {\n        pivot = pivot0\n        value = value0\n      } else {\n        pivot = pivot2\n        value = value2\n      }\n    } else {\n      if(value1 >= value2) {\n        pivot = pivot1\n        value = value1\n      } else if(value2 >= value0) {\n        pivot = pivot0\n        value = value0\n      } else {\n        pivot = pivot2\n        value = value2\n      }\n    }\n\n    //Swap pivot to end of array\n    var aPtr = elemSize * (hi-1)\n    var bPtr = elemSize * pivot\n    for(var i=0; i<elemSize; ++i, ++aPtr, ++bPtr) {\n      var x = boxes[aPtr]\n      boxes[aPtr] = boxes[bPtr]\n      boxes[bPtr] = x\n    }\n    var y = ids[hi-1]\n    ids[hi-1] = ids[pivot]\n    ids[pivot] = y\n\n    //Partition using pivot\n    pivot = partitionStartLessThan(\n      d, axis, \n      lo, hi-1, boxes, ids,\n      value)\n\n    //Swap pivot back\n    var aPtr = elemSize * (hi-1)\n    var bPtr = elemSize * pivot\n    for(var i=0; i<elemSize; ++i, ++aPtr, ++bPtr) {\n      var x = boxes[aPtr]\n      boxes[aPtr] = boxes[bPtr]\n      boxes[bPtr] = x\n    }\n    var y = ids[hi-1]\n    ids[hi-1] = ids[pivot]\n    ids[pivot] = y\n\n    //Swap pivot to last pivot\n    if(mid < pivot) {\n      hi = pivot-1\n      while(lo < hi && \n        boxes[elemSize*(hi-1)+axis] === value) {\n        hi -= 1\n      }\n      hi += 1\n    } else if(pivot < mid) {\n      lo = pivot + 1\n      while(lo < hi &&\n        boxes[elemSize*lo+axis] === value) {\n        lo += 1\n      }\n    } else {\n      break\n    }\n  }\n\n  //Make sure pivot is at start\n  return partitionStartLessThan(\n    d, axis, \n    start, mid, boxes, ids,\n    boxes[elemSize*mid+axis])\n}\n\n//# sourceURL=webpack:///./node_modules/box-intersect/lib/median.js?");

/***/ }),

/***/ "./node_modules/box-intersect/lib/partition.js":
/*!*****************************************************!*\
  !*** ./node_modules/box-intersect/lib/partition.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = genPartition\n\nvar code = 'for(var j=2*a,k=j*c,l=k,m=c,n=b,o=a+b,p=c;d>p;++p,k+=j){var _;if($)if(m===p)m+=1,l+=j;else{for(var s=0;j>s;++s){var t=e[k+s];e[k+s]=e[l],e[l++]=t}var u=f[p];f[p]=f[m],f[m++]=u}}return m'\n\nfunction genPartition(predicate, args) {\n  var fargs ='abcdef'.split('').concat(args)\n  var reads = []\n  if(predicate.indexOf('lo') >= 0) {\n    reads.push('lo=e[k+n]')\n  }\n  if(predicate.indexOf('hi') >= 0) {\n    reads.push('hi=e[k+o]')\n  }\n  fargs.push(\n    code.replace('_', reads.join())\n        .replace('$', predicate))\n  return Function.apply(void 0, fargs)\n}\n\n//# sourceURL=webpack:///./node_modules/box-intersect/lib/partition.js?");

/***/ }),

/***/ "./node_modules/box-intersect/lib/sort.js":
/*!************************************************!*\
  !*** ./node_modules/box-intersect/lib/sort.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\n//This code is extracted from ndarray-sort\n//It is inlined here as a temporary workaround\n\nmodule.exports = wrapper;\n\nvar INSERT_SORT_CUTOFF = 32\n\nfunction wrapper(data, n0) {\n  if (n0 <= 4*INSERT_SORT_CUTOFF) {\n    insertionSort(0, n0 - 1, data);\n  } else {\n    quickSort(0, n0 - 1, data);\n  }\n}\n\nfunction insertionSort(left, right, data) {\n  var ptr = 2*(left+1)\n  for(var i=left+1; i<=right; ++i) {\n    var a = data[ptr++]\n    var b = data[ptr++]\n    var j = i\n    var jptr = ptr-2\n    while(j-- > left) {\n      var x = data[jptr-2]\n      var y = data[jptr-1]\n      if(x < a) {\n        break\n      } else if(x === a && y < b) {\n        break\n      }\n      data[jptr]   = x\n      data[jptr+1] = y\n      jptr -= 2\n    }\n    data[jptr]   = a\n    data[jptr+1] = b\n  }\n}\n\nfunction swap(i, j, data) {\n  i *= 2\n  j *= 2\n  var x = data[i]\n  var y = data[i+1]\n  data[i] = data[j]\n  data[i+1] = data[j+1]\n  data[j] = x\n  data[j+1] = y\n}\n\nfunction move(i, j, data) {\n  i *= 2\n  j *= 2\n  data[i] = data[j]\n  data[i+1] = data[j+1]\n}\n\nfunction rotate(i, j, k, data) {\n  i *= 2\n  j *= 2\n  k *= 2\n  var x = data[i]\n  var y = data[i+1]\n  data[i] = data[j]\n  data[i+1] = data[j+1]\n  data[j] = data[k]\n  data[j+1] = data[k+1]\n  data[k] = x\n  data[k+1] = y\n}\n\nfunction shufflePivot(i, j, px, py, data) {\n  i *= 2\n  j *= 2\n  data[i] = data[j]\n  data[j] = px\n  data[i+1] = data[j+1]\n  data[j+1] = py\n}\n\nfunction compare(i, j, data) {\n  i *= 2\n  j *= 2\n  var x = data[i],\n      y = data[j]\n  if(x < y) {\n    return false\n  } else if(x === y) {\n    return data[i+1] > data[j+1]\n  }\n  return true\n}\n\nfunction comparePivot(i, y, b, data) {\n  i *= 2\n  var x = data[i]\n  if(x < y) {\n    return true\n  } else if(x === y) {\n    return data[i+1] < b\n  }\n  return false\n}\n\nfunction quickSort(left, right, data) {\n  var sixth = (right - left + 1) / 6 | 0, \n      index1 = left + sixth, \n      index5 = right - sixth, \n      index3 = left + right >> 1, \n      index2 = index3 - sixth, \n      index4 = index3 + sixth, \n      el1 = index1, \n      el2 = index2, \n      el3 = index3, \n      el4 = index4, \n      el5 = index5, \n      less = left + 1, \n      great = right - 1, \n      tmp = 0\n  if(compare(el1, el2, data)) {\n    tmp = el1\n    el1 = el2\n    el2 = tmp\n  }\n  if(compare(el4, el5, data)) {\n    tmp = el4\n    el4 = el5\n    el5 = tmp\n  }\n  if(compare(el1, el3, data)) {\n    tmp = el1\n    el1 = el3\n    el3 = tmp\n  }\n  if(compare(el2, el3, data)) {\n    tmp = el2\n    el2 = el3\n    el3 = tmp\n  }\n  if(compare(el1, el4, data)) {\n    tmp = el1\n    el1 = el4\n    el4 = tmp\n  }\n  if(compare(el3, el4, data)) {\n    tmp = el3\n    el3 = el4\n    el4 = tmp\n  }\n  if(compare(el2, el5, data)) {\n    tmp = el2\n    el2 = el5\n    el5 = tmp\n  }\n  if(compare(el2, el3, data)) {\n    tmp = el2\n    el2 = el3\n    el3 = tmp\n  }\n  if(compare(el4, el5, data)) {\n    tmp = el4\n    el4 = el5\n    el5 = tmp\n  }\n\n  var pivot1X = data[2*el2]\n  var pivot1Y = data[2*el2+1]\n  var pivot2X = data[2*el4]\n  var pivot2Y = data[2*el4+1]\n\n  var ptr0 = 2 * el1;\n  var ptr2 = 2 * el3;\n  var ptr4 = 2 * el5;\n  var ptr5 = 2 * index1;\n  var ptr6 = 2 * index3;\n  var ptr7 = 2 * index5;\n  for (var i1 = 0; i1 < 2; ++i1) {\n    var x = data[ptr0+i1];\n    var y = data[ptr2+i1];\n    var z = data[ptr4+i1];\n    data[ptr5+i1] = x;\n    data[ptr6+i1] = y;\n    data[ptr7+i1] = z;\n  }\n\n  move(index2, left, data)\n  move(index4, right, data)\n  for (var k = less; k <= great; ++k) {\n    if (comparePivot(k, pivot1X, pivot1Y, data)) {\n      if (k !== less) {\n        swap(k, less, data)\n      }\n      ++less;\n    } else {\n      if (!comparePivot(k, pivot2X, pivot2Y, data)) {\n        while (true) {\n          if (!comparePivot(great, pivot2X, pivot2Y, data)) {\n            if (--great < k) {\n              break;\n            }\n            continue;\n          } else {\n            if (comparePivot(great, pivot1X, pivot1Y, data)) {\n              rotate(k, less, great, data)\n              ++less;\n              --great;\n            } else {\n              swap(k, great, data)\n              --great;\n            }\n            break;\n          }\n        }\n      }\n    }\n  }\n  shufflePivot(left, less-1, pivot1X, pivot1Y, data)\n  shufflePivot(right, great+1, pivot2X, pivot2Y, data)\n  if (less - 2 - left <= INSERT_SORT_CUTOFF) {\n    insertionSort(left, less - 2, data);\n  } else {\n    quickSort(left, less - 2, data);\n  }\n  if (right - (great + 2) <= INSERT_SORT_CUTOFF) {\n    insertionSort(great + 2, right, data);\n  } else {\n    quickSort(great + 2, right, data);\n  }\n  if (great - less <= INSERT_SORT_CUTOFF) {\n    insertionSort(less, great, data);\n  } else {\n    quickSort(less, great, data);\n  }\n}\n\n//# sourceURL=webpack:///./node_modules/box-intersect/lib/sort.js?");

/***/ }),

/***/ "./node_modules/box-intersect/lib/sweep.js":
/*!*************************************************!*\
  !*** ./node_modules/box-intersect/lib/sweep.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = {\n  init:           sqInit,\n  sweepBipartite: sweepBipartite,\n  sweepComplete:  sweepComplete,\n  scanBipartite:  scanBipartite,\n  scanComplete:   scanComplete\n}\n\nvar pool  = __webpack_require__(/*! typedarray-pool */ \"./node_modules/typedarray-pool/pool.js\")\nvar bits  = __webpack_require__(/*! bit-twiddle */ \"./node_modules/bit-twiddle/twiddle.js\")\nvar isort = __webpack_require__(/*! ./sort */ \"./node_modules/box-intersect/lib/sort.js\")\n\n//Flag for blue\nvar BLUE_FLAG = (1<<28)\n\n//1D sweep event queue stuff (use pool to save space)\nvar INIT_CAPACITY      = 1024\nvar RED_SWEEP_QUEUE    = pool.mallocInt32(INIT_CAPACITY)\nvar RED_SWEEP_INDEX    = pool.mallocInt32(INIT_CAPACITY)\nvar BLUE_SWEEP_QUEUE   = pool.mallocInt32(INIT_CAPACITY)\nvar BLUE_SWEEP_INDEX   = pool.mallocInt32(INIT_CAPACITY)\nvar COMMON_SWEEP_QUEUE = pool.mallocInt32(INIT_CAPACITY)\nvar COMMON_SWEEP_INDEX = pool.mallocInt32(INIT_CAPACITY)\nvar SWEEP_EVENTS       = pool.mallocDouble(INIT_CAPACITY * 8)\n\n//Reserves memory for the 1D sweep data structures\nfunction sqInit(count) {\n  var rcount = bits.nextPow2(count)\n  if(RED_SWEEP_QUEUE.length < rcount) {\n    pool.free(RED_SWEEP_QUEUE)\n    RED_SWEEP_QUEUE = pool.mallocInt32(rcount)\n  }\n  if(RED_SWEEP_INDEX.length < rcount) {\n    pool.free(RED_SWEEP_INDEX)\n    RED_SWEEP_INDEX = pool.mallocInt32(rcount)\n  }\n  if(BLUE_SWEEP_QUEUE.length < rcount) {\n    pool.free(BLUE_SWEEP_QUEUE)\n    BLUE_SWEEP_QUEUE = pool.mallocInt32(rcount)\n  }\n  if(BLUE_SWEEP_INDEX.length < rcount) {\n    pool.free(BLUE_SWEEP_INDEX)\n    BLUE_SWEEP_INDEX = pool.mallocInt32(rcount)\n  }\n  if(COMMON_SWEEP_QUEUE.length < rcount) {\n    pool.free(COMMON_SWEEP_QUEUE)\n    COMMON_SWEEP_QUEUE = pool.mallocInt32(rcount)\n  }\n  if(COMMON_SWEEP_INDEX.length < rcount) {\n    pool.free(COMMON_SWEEP_INDEX)\n    COMMON_SWEEP_INDEX = pool.mallocInt32(rcount)\n  }\n  var eventLength = 8 * rcount\n  if(SWEEP_EVENTS.length < eventLength) {\n    pool.free(SWEEP_EVENTS)\n    SWEEP_EVENTS = pool.mallocDouble(eventLength)\n  }\n}\n\n//Remove an item from the active queue in O(1)\nfunction sqPop(queue, index, count, item) {\n  var idx = index[item]\n  var top = queue[count-1]\n  queue[idx] = top\n  index[top] = idx\n}\n\n//Insert an item into the active queue in O(1)\nfunction sqPush(queue, index, count, item) {\n  queue[count] = item\n  index[item]  = count\n}\n\n//Recursion base case: use 1D sweep algorithm\nfunction sweepBipartite(\n    d, visit,\n    redStart,  redEnd, red, redIndex,\n    blueStart, blueEnd, blue, blueIndex) {\n\n  //store events as pairs [coordinate, idx]\n  //\n  //  red create:  -(idx+1)\n  //  red destroy: idx\n  //  blue create: -(idx+BLUE_FLAG)\n  //  blue destroy: idx+BLUE_FLAG\n  //\n  var ptr      = 0\n  var elemSize = 2*d\n  var istart   = d-1\n  var iend     = elemSize-1\n\n  for(var i=redStart; i<redEnd; ++i) {\n    var idx = redIndex[i]\n    var redOffset = elemSize*i\n    SWEEP_EVENTS[ptr++] = red[redOffset+istart]\n    SWEEP_EVENTS[ptr++] = -(idx+1)\n    SWEEP_EVENTS[ptr++] = red[redOffset+iend]\n    SWEEP_EVENTS[ptr++] = idx\n  }\n\n  for(var i=blueStart; i<blueEnd; ++i) {\n    var idx = blueIndex[i]+BLUE_FLAG\n    var blueOffset = elemSize*i\n    SWEEP_EVENTS[ptr++] = blue[blueOffset+istart]\n    SWEEP_EVENTS[ptr++] = -idx\n    SWEEP_EVENTS[ptr++] = blue[blueOffset+iend]\n    SWEEP_EVENTS[ptr++] = idx\n  }\n\n  //process events from left->right\n  var n = ptr >>> 1\n  isort(SWEEP_EVENTS, n)\n  \n  var redActive  = 0\n  var blueActive = 0\n  for(var i=0; i<n; ++i) {\n    var e = SWEEP_EVENTS[2*i+1]|0\n    if(e >= BLUE_FLAG) {\n      //blue destroy event\n      e = (e-BLUE_FLAG)|0\n      sqPop(BLUE_SWEEP_QUEUE, BLUE_SWEEP_INDEX, blueActive--, e)\n    } else if(e >= 0) {\n      //red destroy event\n      sqPop(RED_SWEEP_QUEUE, RED_SWEEP_INDEX, redActive--, e)\n    } else if(e <= -BLUE_FLAG) {\n      //blue create event\n      e = (-e-BLUE_FLAG)|0\n      for(var j=0; j<redActive; ++j) {\n        var retval = visit(RED_SWEEP_QUEUE[j], e)\n        if(retval !== void 0) {\n          return retval\n        }\n      }\n      sqPush(BLUE_SWEEP_QUEUE, BLUE_SWEEP_INDEX, blueActive++, e)\n    } else {\n      //red create event\n      e = (-e-1)|0\n      for(var j=0; j<blueActive; ++j) {\n        var retval = visit(e, BLUE_SWEEP_QUEUE[j])\n        if(retval !== void 0) {\n          return retval\n        }\n      }\n      sqPush(RED_SWEEP_QUEUE, RED_SWEEP_INDEX, redActive++, e)\n    }\n  }\n}\n\n//Complete sweep\nfunction sweepComplete(d, visit, \n  redStart, redEnd, red, redIndex,\n  blueStart, blueEnd, blue, blueIndex) {\n\n  var ptr      = 0\n  var elemSize = 2*d\n  var istart   = d-1\n  var iend     = elemSize-1\n\n  for(var i=redStart; i<redEnd; ++i) {\n    var idx = (redIndex[i]+1)<<1\n    var redOffset = elemSize*i\n    SWEEP_EVENTS[ptr++] = red[redOffset+istart]\n    SWEEP_EVENTS[ptr++] = -idx\n    SWEEP_EVENTS[ptr++] = red[redOffset+iend]\n    SWEEP_EVENTS[ptr++] = idx\n  }\n\n  for(var i=blueStart; i<blueEnd; ++i) {\n    var idx = (blueIndex[i]+1)<<1\n    var blueOffset = elemSize*i\n    SWEEP_EVENTS[ptr++] = blue[blueOffset+istart]\n    SWEEP_EVENTS[ptr++] = (-idx)|1\n    SWEEP_EVENTS[ptr++] = blue[blueOffset+iend]\n    SWEEP_EVENTS[ptr++] = idx|1\n  }\n\n  //process events from left->right\n  var n = ptr >>> 1\n  isort(SWEEP_EVENTS, n)\n  \n  var redActive    = 0\n  var blueActive   = 0\n  var commonActive = 0\n  for(var i=0; i<n; ++i) {\n    var e     = SWEEP_EVENTS[2*i+1]|0\n    var color = e&1\n    if(i < n-1 && (e>>1) === (SWEEP_EVENTS[2*i+3]>>1)) {\n      color = 2\n      i += 1\n    }\n    \n    if(e < 0) {\n      //Create event\n      var id = -(e>>1) - 1\n\n      //Intersect with common\n      for(var j=0; j<commonActive; ++j) {\n        var retval = visit(COMMON_SWEEP_QUEUE[j], id)\n        if(retval !== void 0) {\n          return retval\n        }\n      }\n\n      if(color !== 0) {\n        //Intersect with red\n        for(var j=0; j<redActive; ++j) {\n          var retval = visit(RED_SWEEP_QUEUE[j], id)\n          if(retval !== void 0) {\n            return retval\n          }\n        }\n      }\n\n      if(color !== 1) {\n        //Intersect with blue\n        for(var j=0; j<blueActive; ++j) {\n          var retval = visit(BLUE_SWEEP_QUEUE[j], id)\n          if(retval !== void 0) {\n            return retval\n          }\n        }\n      }\n\n      if(color === 0) {\n        //Red\n        sqPush(RED_SWEEP_QUEUE, RED_SWEEP_INDEX, redActive++, id)\n      } else if(color === 1) {\n        //Blue\n        sqPush(BLUE_SWEEP_QUEUE, BLUE_SWEEP_INDEX, blueActive++, id)\n      } else if(color === 2) {\n        //Both\n        sqPush(COMMON_SWEEP_QUEUE, COMMON_SWEEP_INDEX, commonActive++, id)\n      }\n    } else {\n      //Destroy event\n      var id = (e>>1) - 1\n      if(color === 0) {\n        //Red\n        sqPop(RED_SWEEP_QUEUE, RED_SWEEP_INDEX, redActive--, id)\n      } else if(color === 1) {\n        //Blue\n        sqPop(BLUE_SWEEP_QUEUE, BLUE_SWEEP_INDEX, blueActive--, id)\n      } else if(color === 2) {\n        //Both\n        sqPop(COMMON_SWEEP_QUEUE, COMMON_SWEEP_INDEX, commonActive--, id)\n      }\n    }\n  }\n}\n\n//Sweep and prune/scanline algorithm:\n//  Scan along axis, detect intersections\n//  Brute force all boxes along axis\nfunction scanBipartite(\n  d, axis, visit, flip,\n  redStart,  redEnd, red, redIndex,\n  blueStart, blueEnd, blue, blueIndex) {\n  \n  var ptr      = 0\n  var elemSize = 2*d\n  var istart   = axis\n  var iend     = axis+d\n\n  var redShift  = 1\n  var blueShift = 1\n  if(flip) {\n    blueShift = BLUE_FLAG\n  } else {\n    redShift  = BLUE_FLAG\n  }\n\n  for(var i=redStart; i<redEnd; ++i) {\n    var idx = i + redShift\n    var redOffset = elemSize*i\n    SWEEP_EVENTS[ptr++] = red[redOffset+istart]\n    SWEEP_EVENTS[ptr++] = -idx\n    SWEEP_EVENTS[ptr++] = red[redOffset+iend]\n    SWEEP_EVENTS[ptr++] = idx\n  }\n  for(var i=blueStart; i<blueEnd; ++i) {\n    var idx = i + blueShift\n    var blueOffset = elemSize*i\n    SWEEP_EVENTS[ptr++] = blue[blueOffset+istart]\n    SWEEP_EVENTS[ptr++] = -idx\n  }\n\n  //process events from left->right\n  var n = ptr >>> 1\n  isort(SWEEP_EVENTS, n)\n  \n  var redActive    = 0\n  for(var i=0; i<n; ++i) {\n    var e = SWEEP_EVENTS[2*i+1]|0\n    if(e < 0) {\n      var idx   = -e\n      var isRed = false\n      if(idx >= BLUE_FLAG) {\n        isRed = !flip\n        idx -= BLUE_FLAG \n      } else {\n        isRed = !!flip\n        idx -= 1\n      }\n      if(isRed) {\n        sqPush(RED_SWEEP_QUEUE, RED_SWEEP_INDEX, redActive++, idx)\n      } else {\n        var blueId  = blueIndex[idx]\n        var bluePtr = elemSize * idx\n        \n        var b0 = blue[bluePtr+axis+1]\n        var b1 = blue[bluePtr+axis+1+d]\n\nred_loop:\n        for(var j=0; j<redActive; ++j) {\n          var oidx   = RED_SWEEP_QUEUE[j]\n          var redPtr = elemSize * oidx\n\n          if(b1 < red[redPtr+axis+1] || \n             red[redPtr+axis+1+d] < b0) {\n            continue\n          }\n\n          for(var k=axis+2; k<d; ++k) {\n            if(blue[bluePtr + k + d] < red[redPtr + k] || \n               red[redPtr + k + d] < blue[bluePtr + k]) {\n              continue red_loop\n            }\n          }\n\n          var redId  = redIndex[oidx]\n          var retval\n          if(flip) {\n            retval = visit(blueId, redId)\n          } else {\n            retval = visit(redId, blueId)\n          }\n          if(retval !== void 0) {\n            return retval \n          }\n        }\n      }\n    } else {\n      sqPop(RED_SWEEP_QUEUE, RED_SWEEP_INDEX, redActive--, e - redShift)\n    }\n  }\n}\n\nfunction scanComplete(\n  d, axis, visit,\n  redStart,  redEnd, red, redIndex,\n  blueStart, blueEnd, blue, blueIndex) {\n\n  var ptr      = 0\n  var elemSize = 2*d\n  var istart   = axis\n  var iend     = axis+d\n\n  for(var i=redStart; i<redEnd; ++i) {\n    var idx = i + BLUE_FLAG\n    var redOffset = elemSize*i\n    SWEEP_EVENTS[ptr++] = red[redOffset+istart]\n    SWEEP_EVENTS[ptr++] = -idx\n    SWEEP_EVENTS[ptr++] = red[redOffset+iend]\n    SWEEP_EVENTS[ptr++] = idx\n  }\n  for(var i=blueStart; i<blueEnd; ++i) {\n    var idx = i + 1\n    var blueOffset = elemSize*i\n    SWEEP_EVENTS[ptr++] = blue[blueOffset+istart]\n    SWEEP_EVENTS[ptr++] = -idx\n  }\n\n  //process events from left->right\n  var n = ptr >>> 1\n  isort(SWEEP_EVENTS, n)\n  \n  var redActive    = 0\n  for(var i=0; i<n; ++i) {\n    var e = SWEEP_EVENTS[2*i+1]|0\n    if(e < 0) {\n      var idx   = -e\n      if(idx >= BLUE_FLAG) {\n        RED_SWEEP_QUEUE[redActive++] = idx - BLUE_FLAG\n      } else {\n        idx -= 1\n        var blueId  = blueIndex[idx]\n        var bluePtr = elemSize * idx\n\n        var b0 = blue[bluePtr+axis+1]\n        var b1 = blue[bluePtr+axis+1+d]\n\nred_loop:\n        for(var j=0; j<redActive; ++j) {\n          var oidx   = RED_SWEEP_QUEUE[j]\n          var redId  = redIndex[oidx]\n\n          if(redId === blueId) {\n            break\n          }\n\n          var redPtr = elemSize * oidx\n          if(b1 < red[redPtr+axis+1] || \n            red[redPtr+axis+1+d] < b0) {\n            continue\n          }\n          for(var k=axis+2; k<d; ++k) {\n            if(blue[bluePtr + k + d] < red[redPtr + k] || \n               red[redPtr + k + d]   < blue[bluePtr + k]) {\n              continue red_loop\n            }\n          }\n\n          var retval = visit(redId, blueId)\n          if(retval !== void 0) {\n            return retval \n          }\n        }\n      }\n    } else {\n      var idx = e - BLUE_FLAG\n      for(var j=redActive-1; j>=0; --j) {\n        if(RED_SWEEP_QUEUE[j] === idx) {\n          for(var k=j+1; k<redActive; ++k) {\n            RED_SWEEP_QUEUE[k-1] = RED_SWEEP_QUEUE[k]\n          }\n          break\n        }\n      }\n      --redActive\n    }\n  }\n}\n\n//# sourceURL=webpack:///./node_modules/box-intersect/lib/sweep.js?");

/***/ }),

/***/ "./node_modules/buffer/index.js":
/*!**************************************!*\
  !*** ./node_modules/buffer/index.js ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/* WEBPACK VAR INJECTION */(function(global) {/*!\n * The buffer module from node.js, for the browser.\n *\n * @author   Feross Aboukhadijeh <http://feross.org>\n * @license  MIT\n */\n/* eslint-disable no-proto */\n\n\n\nvar base64 = __webpack_require__(/*! base64-js */ \"./node_modules/base64-js/index.js\")\nvar ieee754 = __webpack_require__(/*! ieee754 */ \"./node_modules/ieee754/index.js\")\nvar isArray = __webpack_require__(/*! isarray */ \"./node_modules/buffer/node_modules/isarray/index.js\")\n\nexports.Buffer = Buffer\nexports.SlowBuffer = SlowBuffer\nexports.INSPECT_MAX_BYTES = 50\n\n/**\n * If `Buffer.TYPED_ARRAY_SUPPORT`:\n *   === true    Use Uint8Array implementation (fastest)\n *   === false   Use Object implementation (most compatible, even IE6)\n *\n * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,\n * Opera 11.6+, iOS 4.2+.\n *\n * Due to various browser bugs, sometimes the Object implementation will be used even\n * when the browser supports typed arrays.\n *\n * Note:\n *\n *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,\n *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.\n *\n *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.\n *\n *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of\n *     incorrect length in some situations.\n\n * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they\n * get the Object implementation, which is slower but behaves correctly.\n */\nBuffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined\n  ? global.TYPED_ARRAY_SUPPORT\n  : typedArraySupport()\n\n/*\n * Export kMaxLength after typed array support is determined.\n */\nexports.kMaxLength = kMaxLength()\n\nfunction typedArraySupport () {\n  try {\n    var arr = new Uint8Array(1)\n    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}\n    return arr.foo() === 42 && // typed array instances can be augmented\n        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`\n        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`\n  } catch (e) {\n    return false\n  }\n}\n\nfunction kMaxLength () {\n  return Buffer.TYPED_ARRAY_SUPPORT\n    ? 0x7fffffff\n    : 0x3fffffff\n}\n\nfunction createBuffer (that, length) {\n  if (kMaxLength() < length) {\n    throw new RangeError('Invalid typed array length')\n  }\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    // Return an augmented `Uint8Array` instance, for best performance\n    that = new Uint8Array(length)\n    that.__proto__ = Buffer.prototype\n  } else {\n    // Fallback: Return an object instance of the Buffer class\n    if (that === null) {\n      that = new Buffer(length)\n    }\n    that.length = length\n  }\n\n  return that\n}\n\n/**\n * The Buffer constructor returns instances of `Uint8Array` that have their\n * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of\n * `Uint8Array`, so the returned instances will have all the node `Buffer` methods\n * and the `Uint8Array` methods. Square bracket notation works as expected -- it\n * returns a single octet.\n *\n * The `Uint8Array` prototype remains unmodified.\n */\n\nfunction Buffer (arg, encodingOrOffset, length) {\n  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {\n    return new Buffer(arg, encodingOrOffset, length)\n  }\n\n  // Common case.\n  if (typeof arg === 'number') {\n    if (typeof encodingOrOffset === 'string') {\n      throw new Error(\n        'If encoding is specified then the first argument must be a string'\n      )\n    }\n    return allocUnsafe(this, arg)\n  }\n  return from(this, arg, encodingOrOffset, length)\n}\n\nBuffer.poolSize = 8192 // not used by this implementation\n\n// TODO: Legacy, not needed anymore. Remove in next major version.\nBuffer._augment = function (arr) {\n  arr.__proto__ = Buffer.prototype\n  return arr\n}\n\nfunction from (that, value, encodingOrOffset, length) {\n  if (typeof value === 'number') {\n    throw new TypeError('\"value\" argument must not be a number')\n  }\n\n  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {\n    return fromArrayBuffer(that, value, encodingOrOffset, length)\n  }\n\n  if (typeof value === 'string') {\n    return fromString(that, value, encodingOrOffset)\n  }\n\n  return fromObject(that, value)\n}\n\n/**\n * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError\n * if value is a number.\n * Buffer.from(str[, encoding])\n * Buffer.from(array)\n * Buffer.from(buffer)\n * Buffer.from(arrayBuffer[, byteOffset[, length]])\n **/\nBuffer.from = function (value, encodingOrOffset, length) {\n  return from(null, value, encodingOrOffset, length)\n}\n\nif (Buffer.TYPED_ARRAY_SUPPORT) {\n  Buffer.prototype.__proto__ = Uint8Array.prototype\n  Buffer.__proto__ = Uint8Array\n  if (typeof Symbol !== 'undefined' && Symbol.species &&\n      Buffer[Symbol.species] === Buffer) {\n    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97\n    Object.defineProperty(Buffer, Symbol.species, {\n      value: null,\n      configurable: true\n    })\n  }\n}\n\nfunction assertSize (size) {\n  if (typeof size !== 'number') {\n    throw new TypeError('\"size\" argument must be a number')\n  } else if (size < 0) {\n    throw new RangeError('\"size\" argument must not be negative')\n  }\n}\n\nfunction alloc (that, size, fill, encoding) {\n  assertSize(size)\n  if (size <= 0) {\n    return createBuffer(that, size)\n  }\n  if (fill !== undefined) {\n    // Only pay attention to encoding if it's a string. This\n    // prevents accidentally sending in a number that would\n    // be interpretted as a start offset.\n    return typeof encoding === 'string'\n      ? createBuffer(that, size).fill(fill, encoding)\n      : createBuffer(that, size).fill(fill)\n  }\n  return createBuffer(that, size)\n}\n\n/**\n * Creates a new filled Buffer instance.\n * alloc(size[, fill[, encoding]])\n **/\nBuffer.alloc = function (size, fill, encoding) {\n  return alloc(null, size, fill, encoding)\n}\n\nfunction allocUnsafe (that, size) {\n  assertSize(size)\n  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)\n  if (!Buffer.TYPED_ARRAY_SUPPORT) {\n    for (var i = 0; i < size; ++i) {\n      that[i] = 0\n    }\n  }\n  return that\n}\n\n/**\n * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.\n * */\nBuffer.allocUnsafe = function (size) {\n  return allocUnsafe(null, size)\n}\n/**\n * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.\n */\nBuffer.allocUnsafeSlow = function (size) {\n  return allocUnsafe(null, size)\n}\n\nfunction fromString (that, string, encoding) {\n  if (typeof encoding !== 'string' || encoding === '') {\n    encoding = 'utf8'\n  }\n\n  if (!Buffer.isEncoding(encoding)) {\n    throw new TypeError('\"encoding\" must be a valid string encoding')\n  }\n\n  var length = byteLength(string, encoding) | 0\n  that = createBuffer(that, length)\n\n  var actual = that.write(string, encoding)\n\n  if (actual !== length) {\n    // Writing a hex string, for example, that contains invalid characters will\n    // cause everything after the first invalid character to be ignored. (e.g.\n    // 'abxxcd' will be treated as 'ab')\n    that = that.slice(0, actual)\n  }\n\n  return that\n}\n\nfunction fromArrayLike (that, array) {\n  var length = array.length < 0 ? 0 : checked(array.length) | 0\n  that = createBuffer(that, length)\n  for (var i = 0; i < length; i += 1) {\n    that[i] = array[i] & 255\n  }\n  return that\n}\n\nfunction fromArrayBuffer (that, array, byteOffset, length) {\n  array.byteLength // this throws if `array` is not a valid ArrayBuffer\n\n  if (byteOffset < 0 || array.byteLength < byteOffset) {\n    throw new RangeError('\\'offset\\' is out of bounds')\n  }\n\n  if (array.byteLength < byteOffset + (length || 0)) {\n    throw new RangeError('\\'length\\' is out of bounds')\n  }\n\n  if (byteOffset === undefined && length === undefined) {\n    array = new Uint8Array(array)\n  } else if (length === undefined) {\n    array = new Uint8Array(array, byteOffset)\n  } else {\n    array = new Uint8Array(array, byteOffset, length)\n  }\n\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    // Return an augmented `Uint8Array` instance, for best performance\n    that = array\n    that.__proto__ = Buffer.prototype\n  } else {\n    // Fallback: Return an object instance of the Buffer class\n    that = fromArrayLike(that, array)\n  }\n  return that\n}\n\nfunction fromObject (that, obj) {\n  if (Buffer.isBuffer(obj)) {\n    var len = checked(obj.length) | 0\n    that = createBuffer(that, len)\n\n    if (that.length === 0) {\n      return that\n    }\n\n    obj.copy(that, 0, 0, len)\n    return that\n  }\n\n  if (obj) {\n    if ((typeof ArrayBuffer !== 'undefined' &&\n        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {\n      if (typeof obj.length !== 'number' || isnan(obj.length)) {\n        return createBuffer(that, 0)\n      }\n      return fromArrayLike(that, obj)\n    }\n\n    if (obj.type === 'Buffer' && isArray(obj.data)) {\n      return fromArrayLike(that, obj.data)\n    }\n  }\n\n  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')\n}\n\nfunction checked (length) {\n  // Note: cannot use `length < kMaxLength()` here because that fails when\n  // length is NaN (which is otherwise coerced to zero.)\n  if (length >= kMaxLength()) {\n    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +\n                         'size: 0x' + kMaxLength().toString(16) + ' bytes')\n  }\n  return length | 0\n}\n\nfunction SlowBuffer (length) {\n  if (+length != length) { // eslint-disable-line eqeqeq\n    length = 0\n  }\n  return Buffer.alloc(+length)\n}\n\nBuffer.isBuffer = function isBuffer (b) {\n  return !!(b != null && b._isBuffer)\n}\n\nBuffer.compare = function compare (a, b) {\n  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {\n    throw new TypeError('Arguments must be Buffers')\n  }\n\n  if (a === b) return 0\n\n  var x = a.length\n  var y = b.length\n\n  for (var i = 0, len = Math.min(x, y); i < len; ++i) {\n    if (a[i] !== b[i]) {\n      x = a[i]\n      y = b[i]\n      break\n    }\n  }\n\n  if (x < y) return -1\n  if (y < x) return 1\n  return 0\n}\n\nBuffer.isEncoding = function isEncoding (encoding) {\n  switch (String(encoding).toLowerCase()) {\n    case 'hex':\n    case 'utf8':\n    case 'utf-8':\n    case 'ascii':\n    case 'latin1':\n    case 'binary':\n    case 'base64':\n    case 'ucs2':\n    case 'ucs-2':\n    case 'utf16le':\n    case 'utf-16le':\n      return true\n    default:\n      return false\n  }\n}\n\nBuffer.concat = function concat (list, length) {\n  if (!isArray(list)) {\n    throw new TypeError('\"list\" argument must be an Array of Buffers')\n  }\n\n  if (list.length === 0) {\n    return Buffer.alloc(0)\n  }\n\n  var i\n  if (length === undefined) {\n    length = 0\n    for (i = 0; i < list.length; ++i) {\n      length += list[i].length\n    }\n  }\n\n  var buffer = Buffer.allocUnsafe(length)\n  var pos = 0\n  for (i = 0; i < list.length; ++i) {\n    var buf = list[i]\n    if (!Buffer.isBuffer(buf)) {\n      throw new TypeError('\"list\" argument must be an Array of Buffers')\n    }\n    buf.copy(buffer, pos)\n    pos += buf.length\n  }\n  return buffer\n}\n\nfunction byteLength (string, encoding) {\n  if (Buffer.isBuffer(string)) {\n    return string.length\n  }\n  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&\n      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {\n    return string.byteLength\n  }\n  if (typeof string !== 'string') {\n    string = '' + string\n  }\n\n  var len = string.length\n  if (len === 0) return 0\n\n  // Use a for loop to avoid recursion\n  var loweredCase = false\n  for (;;) {\n    switch (encoding) {\n      case 'ascii':\n      case 'latin1':\n      case 'binary':\n        return len\n      case 'utf8':\n      case 'utf-8':\n      case undefined:\n        return utf8ToBytes(string).length\n      case 'ucs2':\n      case 'ucs-2':\n      case 'utf16le':\n      case 'utf-16le':\n        return len * 2\n      case 'hex':\n        return len >>> 1\n      case 'base64':\n        return base64ToBytes(string).length\n      default:\n        if (loweredCase) return utf8ToBytes(string).length // assume utf8\n        encoding = ('' + encoding).toLowerCase()\n        loweredCase = true\n    }\n  }\n}\nBuffer.byteLength = byteLength\n\nfunction slowToString (encoding, start, end) {\n  var loweredCase = false\n\n  // No need to verify that \"this.length <= MAX_UINT32\" since it's a read-only\n  // property of a typed array.\n\n  // This behaves neither like String nor Uint8Array in that we set start/end\n  // to their upper/lower bounds if the value passed is out of range.\n  // undefined is handled specially as per ECMA-262 6th Edition,\n  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.\n  if (start === undefined || start < 0) {\n    start = 0\n  }\n  // Return early if start > this.length. Done here to prevent potential uint32\n  // coercion fail below.\n  if (start > this.length) {\n    return ''\n  }\n\n  if (end === undefined || end > this.length) {\n    end = this.length\n  }\n\n  if (end <= 0) {\n    return ''\n  }\n\n  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.\n  end >>>= 0\n  start >>>= 0\n\n  if (end <= start) {\n    return ''\n  }\n\n  if (!encoding) encoding = 'utf8'\n\n  while (true) {\n    switch (encoding) {\n      case 'hex':\n        return hexSlice(this, start, end)\n\n      case 'utf8':\n      case 'utf-8':\n        return utf8Slice(this, start, end)\n\n      case 'ascii':\n        return asciiSlice(this, start, end)\n\n      case 'latin1':\n      case 'binary':\n        return latin1Slice(this, start, end)\n\n      case 'base64':\n        return base64Slice(this, start, end)\n\n      case 'ucs2':\n      case 'ucs-2':\n      case 'utf16le':\n      case 'utf-16le':\n        return utf16leSlice(this, start, end)\n\n      default:\n        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)\n        encoding = (encoding + '').toLowerCase()\n        loweredCase = true\n    }\n  }\n}\n\n// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect\n// Buffer instances.\nBuffer.prototype._isBuffer = true\n\nfunction swap (b, n, m) {\n  var i = b[n]\n  b[n] = b[m]\n  b[m] = i\n}\n\nBuffer.prototype.swap16 = function swap16 () {\n  var len = this.length\n  if (len % 2 !== 0) {\n    throw new RangeError('Buffer size must be a multiple of 16-bits')\n  }\n  for (var i = 0; i < len; i += 2) {\n    swap(this, i, i + 1)\n  }\n  return this\n}\n\nBuffer.prototype.swap32 = function swap32 () {\n  var len = this.length\n  if (len % 4 !== 0) {\n    throw new RangeError('Buffer size must be a multiple of 32-bits')\n  }\n  for (var i = 0; i < len; i += 4) {\n    swap(this, i, i + 3)\n    swap(this, i + 1, i + 2)\n  }\n  return this\n}\n\nBuffer.prototype.swap64 = function swap64 () {\n  var len = this.length\n  if (len % 8 !== 0) {\n    throw new RangeError('Buffer size must be a multiple of 64-bits')\n  }\n  for (var i = 0; i < len; i += 8) {\n    swap(this, i, i + 7)\n    swap(this, i + 1, i + 6)\n    swap(this, i + 2, i + 5)\n    swap(this, i + 3, i + 4)\n  }\n  return this\n}\n\nBuffer.prototype.toString = function toString () {\n  var length = this.length | 0\n  if (length === 0) return ''\n  if (arguments.length === 0) return utf8Slice(this, 0, length)\n  return slowToString.apply(this, arguments)\n}\n\nBuffer.prototype.equals = function equals (b) {\n  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')\n  if (this === b) return true\n  return Buffer.compare(this, b) === 0\n}\n\nBuffer.prototype.inspect = function inspect () {\n  var str = ''\n  var max = exports.INSPECT_MAX_BYTES\n  if (this.length > 0) {\n    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')\n    if (this.length > max) str += ' ... '\n  }\n  return '<Buffer ' + str + '>'\n}\n\nBuffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {\n  if (!Buffer.isBuffer(target)) {\n    throw new TypeError('Argument must be a Buffer')\n  }\n\n  if (start === undefined) {\n    start = 0\n  }\n  if (end === undefined) {\n    end = target ? target.length : 0\n  }\n  if (thisStart === undefined) {\n    thisStart = 0\n  }\n  if (thisEnd === undefined) {\n    thisEnd = this.length\n  }\n\n  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {\n    throw new RangeError('out of range index')\n  }\n\n  if (thisStart >= thisEnd && start >= end) {\n    return 0\n  }\n  if (thisStart >= thisEnd) {\n    return -1\n  }\n  if (start >= end) {\n    return 1\n  }\n\n  start >>>= 0\n  end >>>= 0\n  thisStart >>>= 0\n  thisEnd >>>= 0\n\n  if (this === target) return 0\n\n  var x = thisEnd - thisStart\n  var y = end - start\n  var len = Math.min(x, y)\n\n  var thisCopy = this.slice(thisStart, thisEnd)\n  var targetCopy = target.slice(start, end)\n\n  for (var i = 0; i < len; ++i) {\n    if (thisCopy[i] !== targetCopy[i]) {\n      x = thisCopy[i]\n      y = targetCopy[i]\n      break\n    }\n  }\n\n  if (x < y) return -1\n  if (y < x) return 1\n  return 0\n}\n\n// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,\n// OR the last index of `val` in `buffer` at offset <= `byteOffset`.\n//\n// Arguments:\n// - buffer - a Buffer to search\n// - val - a string, Buffer, or number\n// - byteOffset - an index into `buffer`; will be clamped to an int32\n// - encoding - an optional encoding, relevant is val is a string\n// - dir - true for indexOf, false for lastIndexOf\nfunction bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {\n  // Empty buffer means no match\n  if (buffer.length === 0) return -1\n\n  // Normalize byteOffset\n  if (typeof byteOffset === 'string') {\n    encoding = byteOffset\n    byteOffset = 0\n  } else if (byteOffset > 0x7fffffff) {\n    byteOffset = 0x7fffffff\n  } else if (byteOffset < -0x80000000) {\n    byteOffset = -0x80000000\n  }\n  byteOffset = +byteOffset  // Coerce to Number.\n  if (isNaN(byteOffset)) {\n    // byteOffset: it it's undefined, null, NaN, \"foo\", etc, search whole buffer\n    byteOffset = dir ? 0 : (buffer.length - 1)\n  }\n\n  // Normalize byteOffset: negative offsets start from the end of the buffer\n  if (byteOffset < 0) byteOffset = buffer.length + byteOffset\n  if (byteOffset >= buffer.length) {\n    if (dir) return -1\n    else byteOffset = buffer.length - 1\n  } else if (byteOffset < 0) {\n    if (dir) byteOffset = 0\n    else return -1\n  }\n\n  // Normalize val\n  if (typeof val === 'string') {\n    val = Buffer.from(val, encoding)\n  }\n\n  // Finally, search either indexOf (if dir is true) or lastIndexOf\n  if (Buffer.isBuffer(val)) {\n    // Special case: looking for empty string/buffer always fails\n    if (val.length === 0) {\n      return -1\n    }\n    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)\n  } else if (typeof val === 'number') {\n    val = val & 0xFF // Search for a byte value [0-255]\n    if (Buffer.TYPED_ARRAY_SUPPORT &&\n        typeof Uint8Array.prototype.indexOf === 'function') {\n      if (dir) {\n        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)\n      } else {\n        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)\n      }\n    }\n    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)\n  }\n\n  throw new TypeError('val must be string, number or Buffer')\n}\n\nfunction arrayIndexOf (arr, val, byteOffset, encoding, dir) {\n  var indexSize = 1\n  var arrLength = arr.length\n  var valLength = val.length\n\n  if (encoding !== undefined) {\n    encoding = String(encoding).toLowerCase()\n    if (encoding === 'ucs2' || encoding === 'ucs-2' ||\n        encoding === 'utf16le' || encoding === 'utf-16le') {\n      if (arr.length < 2 || val.length < 2) {\n        return -1\n      }\n      indexSize = 2\n      arrLength /= 2\n      valLength /= 2\n      byteOffset /= 2\n    }\n  }\n\n  function read (buf, i) {\n    if (indexSize === 1) {\n      return buf[i]\n    } else {\n      return buf.readUInt16BE(i * indexSize)\n    }\n  }\n\n  var i\n  if (dir) {\n    var foundIndex = -1\n    for (i = byteOffset; i < arrLength; i++) {\n      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {\n        if (foundIndex === -1) foundIndex = i\n        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize\n      } else {\n        if (foundIndex !== -1) i -= i - foundIndex\n        foundIndex = -1\n      }\n    }\n  } else {\n    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength\n    for (i = byteOffset; i >= 0; i--) {\n      var found = true\n      for (var j = 0; j < valLength; j++) {\n        if (read(arr, i + j) !== read(val, j)) {\n          found = false\n          break\n        }\n      }\n      if (found) return i\n    }\n  }\n\n  return -1\n}\n\nBuffer.prototype.includes = function includes (val, byteOffset, encoding) {\n  return this.indexOf(val, byteOffset, encoding) !== -1\n}\n\nBuffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {\n  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)\n}\n\nBuffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {\n  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)\n}\n\nfunction hexWrite (buf, string, offset, length) {\n  offset = Number(offset) || 0\n  var remaining = buf.length - offset\n  if (!length) {\n    length = remaining\n  } else {\n    length = Number(length)\n    if (length > remaining) {\n      length = remaining\n    }\n  }\n\n  // must be an even number of digits\n  var strLen = string.length\n  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')\n\n  if (length > strLen / 2) {\n    length = strLen / 2\n  }\n  for (var i = 0; i < length; ++i) {\n    var parsed = parseInt(string.substr(i * 2, 2), 16)\n    if (isNaN(parsed)) return i\n    buf[offset + i] = parsed\n  }\n  return i\n}\n\nfunction utf8Write (buf, string, offset, length) {\n  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)\n}\n\nfunction asciiWrite (buf, string, offset, length) {\n  return blitBuffer(asciiToBytes(string), buf, offset, length)\n}\n\nfunction latin1Write (buf, string, offset, length) {\n  return asciiWrite(buf, string, offset, length)\n}\n\nfunction base64Write (buf, string, offset, length) {\n  return blitBuffer(base64ToBytes(string), buf, offset, length)\n}\n\nfunction ucs2Write (buf, string, offset, length) {\n  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)\n}\n\nBuffer.prototype.write = function write (string, offset, length, encoding) {\n  // Buffer#write(string)\n  if (offset === undefined) {\n    encoding = 'utf8'\n    length = this.length\n    offset = 0\n  // Buffer#write(string, encoding)\n  } else if (length === undefined && typeof offset === 'string') {\n    encoding = offset\n    length = this.length\n    offset = 0\n  // Buffer#write(string, offset[, length][, encoding])\n  } else if (isFinite(offset)) {\n    offset = offset | 0\n    if (isFinite(length)) {\n      length = length | 0\n      if (encoding === undefined) encoding = 'utf8'\n    } else {\n      encoding = length\n      length = undefined\n    }\n  // legacy write(string, encoding, offset, length) - remove in v0.13\n  } else {\n    throw new Error(\n      'Buffer.write(string, encoding, offset[, length]) is no longer supported'\n    )\n  }\n\n  var remaining = this.length - offset\n  if (length === undefined || length > remaining) length = remaining\n\n  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {\n    throw new RangeError('Attempt to write outside buffer bounds')\n  }\n\n  if (!encoding) encoding = 'utf8'\n\n  var loweredCase = false\n  for (;;) {\n    switch (encoding) {\n      case 'hex':\n        return hexWrite(this, string, offset, length)\n\n      case 'utf8':\n      case 'utf-8':\n        return utf8Write(this, string, offset, length)\n\n      case 'ascii':\n        return asciiWrite(this, string, offset, length)\n\n      case 'latin1':\n      case 'binary':\n        return latin1Write(this, string, offset, length)\n\n      case 'base64':\n        // Warning: maxLength not taken into account in base64Write\n        return base64Write(this, string, offset, length)\n\n      case 'ucs2':\n      case 'ucs-2':\n      case 'utf16le':\n      case 'utf-16le':\n        return ucs2Write(this, string, offset, length)\n\n      default:\n        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)\n        encoding = ('' + encoding).toLowerCase()\n        loweredCase = true\n    }\n  }\n}\n\nBuffer.prototype.toJSON = function toJSON () {\n  return {\n    type: 'Buffer',\n    data: Array.prototype.slice.call(this._arr || this, 0)\n  }\n}\n\nfunction base64Slice (buf, start, end) {\n  if (start === 0 && end === buf.length) {\n    return base64.fromByteArray(buf)\n  } else {\n    return base64.fromByteArray(buf.slice(start, end))\n  }\n}\n\nfunction utf8Slice (buf, start, end) {\n  end = Math.min(buf.length, end)\n  var res = []\n\n  var i = start\n  while (i < end) {\n    var firstByte = buf[i]\n    var codePoint = null\n    var bytesPerSequence = (firstByte > 0xEF) ? 4\n      : (firstByte > 0xDF) ? 3\n      : (firstByte > 0xBF) ? 2\n      : 1\n\n    if (i + bytesPerSequence <= end) {\n      var secondByte, thirdByte, fourthByte, tempCodePoint\n\n      switch (bytesPerSequence) {\n        case 1:\n          if (firstByte < 0x80) {\n            codePoint = firstByte\n          }\n          break\n        case 2:\n          secondByte = buf[i + 1]\n          if ((secondByte & 0xC0) === 0x80) {\n            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)\n            if (tempCodePoint > 0x7F) {\n              codePoint = tempCodePoint\n            }\n          }\n          break\n        case 3:\n          secondByte = buf[i + 1]\n          thirdByte = buf[i + 2]\n          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {\n            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)\n            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {\n              codePoint = tempCodePoint\n            }\n          }\n          break\n        case 4:\n          secondByte = buf[i + 1]\n          thirdByte = buf[i + 2]\n          fourthByte = buf[i + 3]\n          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {\n            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)\n            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {\n              codePoint = tempCodePoint\n            }\n          }\n      }\n    }\n\n    if (codePoint === null) {\n      // we did not generate a valid codePoint so insert a\n      // replacement char (U+FFFD) and advance only 1 byte\n      codePoint = 0xFFFD\n      bytesPerSequence = 1\n    } else if (codePoint > 0xFFFF) {\n      // encode to utf16 (surrogate pair dance)\n      codePoint -= 0x10000\n      res.push(codePoint >>> 10 & 0x3FF | 0xD800)\n      codePoint = 0xDC00 | codePoint & 0x3FF\n    }\n\n    res.push(codePoint)\n    i += bytesPerSequence\n  }\n\n  return decodeCodePointsArray(res)\n}\n\n// Based on http://stackoverflow.com/a/22747272/680742, the browser with\n// the lowest limit is Chrome, with 0x10000 args.\n// We go 1 magnitude less, for safety\nvar MAX_ARGUMENTS_LENGTH = 0x1000\n\nfunction decodeCodePointsArray (codePoints) {\n  var len = codePoints.length\n  if (len <= MAX_ARGUMENTS_LENGTH) {\n    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()\n  }\n\n  // Decode in chunks to avoid \"call stack size exceeded\".\n  var res = ''\n  var i = 0\n  while (i < len) {\n    res += String.fromCharCode.apply(\n      String,\n      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)\n    )\n  }\n  return res\n}\n\nfunction asciiSlice (buf, start, end) {\n  var ret = ''\n  end = Math.min(buf.length, end)\n\n  for (var i = start; i < end; ++i) {\n    ret += String.fromCharCode(buf[i] & 0x7F)\n  }\n  return ret\n}\n\nfunction latin1Slice (buf, start, end) {\n  var ret = ''\n  end = Math.min(buf.length, end)\n\n  for (var i = start; i < end; ++i) {\n    ret += String.fromCharCode(buf[i])\n  }\n  return ret\n}\n\nfunction hexSlice (buf, start, end) {\n  var len = buf.length\n\n  if (!start || start < 0) start = 0\n  if (!end || end < 0 || end > len) end = len\n\n  var out = ''\n  for (var i = start; i < end; ++i) {\n    out += toHex(buf[i])\n  }\n  return out\n}\n\nfunction utf16leSlice (buf, start, end) {\n  var bytes = buf.slice(start, end)\n  var res = ''\n  for (var i = 0; i < bytes.length; i += 2) {\n    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)\n  }\n  return res\n}\n\nBuffer.prototype.slice = function slice (start, end) {\n  var len = this.length\n  start = ~~start\n  end = end === undefined ? len : ~~end\n\n  if (start < 0) {\n    start += len\n    if (start < 0) start = 0\n  } else if (start > len) {\n    start = len\n  }\n\n  if (end < 0) {\n    end += len\n    if (end < 0) end = 0\n  } else if (end > len) {\n    end = len\n  }\n\n  if (end < start) end = start\n\n  var newBuf\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    newBuf = this.subarray(start, end)\n    newBuf.__proto__ = Buffer.prototype\n  } else {\n    var sliceLen = end - start\n    newBuf = new Buffer(sliceLen, undefined)\n    for (var i = 0; i < sliceLen; ++i) {\n      newBuf[i] = this[i + start]\n    }\n  }\n\n  return newBuf\n}\n\n/*\n * Need to make sure that buffer isn't trying to write out of bounds.\n */\nfunction checkOffset (offset, ext, length) {\n  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')\n  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')\n}\n\nBuffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) checkOffset(offset, byteLength, this.length)\n\n  var val = this[offset]\n  var mul = 1\n  var i = 0\n  while (++i < byteLength && (mul *= 0x100)) {\n    val += this[offset + i] * mul\n  }\n\n  return val\n}\n\nBuffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) {\n    checkOffset(offset, byteLength, this.length)\n  }\n\n  var val = this[offset + --byteLength]\n  var mul = 1\n  while (byteLength > 0 && (mul *= 0x100)) {\n    val += this[offset + --byteLength] * mul\n  }\n\n  return val\n}\n\nBuffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 1, this.length)\n  return this[offset]\n}\n\nBuffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 2, this.length)\n  return this[offset] | (this[offset + 1] << 8)\n}\n\nBuffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 2, this.length)\n  return (this[offset] << 8) | this[offset + 1]\n}\n\nBuffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n\n  return ((this[offset]) |\n      (this[offset + 1] << 8) |\n      (this[offset + 2] << 16)) +\n      (this[offset + 3] * 0x1000000)\n}\n\nBuffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n\n  return (this[offset] * 0x1000000) +\n    ((this[offset + 1] << 16) |\n    (this[offset + 2] << 8) |\n    this[offset + 3])\n}\n\nBuffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) checkOffset(offset, byteLength, this.length)\n\n  var val = this[offset]\n  var mul = 1\n  var i = 0\n  while (++i < byteLength && (mul *= 0x100)) {\n    val += this[offset + i] * mul\n  }\n  mul *= 0x80\n\n  if (val >= mul) val -= Math.pow(2, 8 * byteLength)\n\n  return val\n}\n\nBuffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) checkOffset(offset, byteLength, this.length)\n\n  var i = byteLength\n  var mul = 1\n  var val = this[offset + --i]\n  while (i > 0 && (mul *= 0x100)) {\n    val += this[offset + --i] * mul\n  }\n  mul *= 0x80\n\n  if (val >= mul) val -= Math.pow(2, 8 * byteLength)\n\n  return val\n}\n\nBuffer.prototype.readInt8 = function readInt8 (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 1, this.length)\n  if (!(this[offset] & 0x80)) return (this[offset])\n  return ((0xff - this[offset] + 1) * -1)\n}\n\nBuffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 2, this.length)\n  var val = this[offset] | (this[offset + 1] << 8)\n  return (val & 0x8000) ? val | 0xFFFF0000 : val\n}\n\nBuffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 2, this.length)\n  var val = this[offset + 1] | (this[offset] << 8)\n  return (val & 0x8000) ? val | 0xFFFF0000 : val\n}\n\nBuffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n\n  return (this[offset]) |\n    (this[offset + 1] << 8) |\n    (this[offset + 2] << 16) |\n    (this[offset + 3] << 24)\n}\n\nBuffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n\n  return (this[offset] << 24) |\n    (this[offset + 1] << 16) |\n    (this[offset + 2] << 8) |\n    (this[offset + 3])\n}\n\nBuffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n  return ieee754.read(this, offset, true, 23, 4)\n}\n\nBuffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n  return ieee754.read(this, offset, false, 23, 4)\n}\n\nBuffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 8, this.length)\n  return ieee754.read(this, offset, true, 52, 8)\n}\n\nBuffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 8, this.length)\n  return ieee754.read(this, offset, false, 52, 8)\n}\n\nfunction checkInt (buf, value, offset, ext, max, min) {\n  if (!Buffer.isBuffer(buf)) throw new TypeError('\"buffer\" argument must be a Buffer instance')\n  if (value > max || value < min) throw new RangeError('\"value\" argument is out of bounds')\n  if (offset + ext > buf.length) throw new RangeError('Index out of range')\n}\n\nBuffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {\n  value = +value\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) {\n    var maxBytes = Math.pow(2, 8 * byteLength) - 1\n    checkInt(this, value, offset, byteLength, maxBytes, 0)\n  }\n\n  var mul = 1\n  var i = 0\n  this[offset] = value & 0xFF\n  while (++i < byteLength && (mul *= 0x100)) {\n    this[offset + i] = (value / mul) & 0xFF\n  }\n\n  return offset + byteLength\n}\n\nBuffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {\n  value = +value\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) {\n    var maxBytes = Math.pow(2, 8 * byteLength) - 1\n    checkInt(this, value, offset, byteLength, maxBytes, 0)\n  }\n\n  var i = byteLength - 1\n  var mul = 1\n  this[offset + i] = value & 0xFF\n  while (--i >= 0 && (mul *= 0x100)) {\n    this[offset + i] = (value / mul) & 0xFF\n  }\n\n  return offset + byteLength\n}\n\nBuffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)\n  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)\n  this[offset] = (value & 0xff)\n  return offset + 1\n}\n\nfunction objectWriteUInt16 (buf, value, offset, littleEndian) {\n  if (value < 0) value = 0xffff + value + 1\n  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {\n    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>\n      (littleEndian ? i : 1 - i) * 8\n  }\n}\n\nBuffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value & 0xff)\n    this[offset + 1] = (value >>> 8)\n  } else {\n    objectWriteUInt16(this, value, offset, true)\n  }\n  return offset + 2\n}\n\nBuffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value >>> 8)\n    this[offset + 1] = (value & 0xff)\n  } else {\n    objectWriteUInt16(this, value, offset, false)\n  }\n  return offset + 2\n}\n\nfunction objectWriteUInt32 (buf, value, offset, littleEndian) {\n  if (value < 0) value = 0xffffffff + value + 1\n  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {\n    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff\n  }\n}\n\nBuffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset + 3] = (value >>> 24)\n    this[offset + 2] = (value >>> 16)\n    this[offset + 1] = (value >>> 8)\n    this[offset] = (value & 0xff)\n  } else {\n    objectWriteUInt32(this, value, offset, true)\n  }\n  return offset + 4\n}\n\nBuffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value >>> 24)\n    this[offset + 1] = (value >>> 16)\n    this[offset + 2] = (value >>> 8)\n    this[offset + 3] = (value & 0xff)\n  } else {\n    objectWriteUInt32(this, value, offset, false)\n  }\n  return offset + 4\n}\n\nBuffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) {\n    var limit = Math.pow(2, 8 * byteLength - 1)\n\n    checkInt(this, value, offset, byteLength, limit - 1, -limit)\n  }\n\n  var i = 0\n  var mul = 1\n  var sub = 0\n  this[offset] = value & 0xFF\n  while (++i < byteLength && (mul *= 0x100)) {\n    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {\n      sub = 1\n    }\n    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF\n  }\n\n  return offset + byteLength\n}\n\nBuffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) {\n    var limit = Math.pow(2, 8 * byteLength - 1)\n\n    checkInt(this, value, offset, byteLength, limit - 1, -limit)\n  }\n\n  var i = byteLength - 1\n  var mul = 1\n  var sub = 0\n  this[offset + i] = value & 0xFF\n  while (--i >= 0 && (mul *= 0x100)) {\n    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {\n      sub = 1\n    }\n    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF\n  }\n\n  return offset + byteLength\n}\n\nBuffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)\n  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)\n  if (value < 0) value = 0xff + value + 1\n  this[offset] = (value & 0xff)\n  return offset + 1\n}\n\nBuffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value & 0xff)\n    this[offset + 1] = (value >>> 8)\n  } else {\n    objectWriteUInt16(this, value, offset, true)\n  }\n  return offset + 2\n}\n\nBuffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value >>> 8)\n    this[offset + 1] = (value & 0xff)\n  } else {\n    objectWriteUInt16(this, value, offset, false)\n  }\n  return offset + 2\n}\n\nBuffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value & 0xff)\n    this[offset + 1] = (value >>> 8)\n    this[offset + 2] = (value >>> 16)\n    this[offset + 3] = (value >>> 24)\n  } else {\n    objectWriteUInt32(this, value, offset, true)\n  }\n  return offset + 4\n}\n\nBuffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)\n  if (value < 0) value = 0xffffffff + value + 1\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value >>> 24)\n    this[offset + 1] = (value >>> 16)\n    this[offset + 2] = (value >>> 8)\n    this[offset + 3] = (value & 0xff)\n  } else {\n    objectWriteUInt32(this, value, offset, false)\n  }\n  return offset + 4\n}\n\nfunction checkIEEE754 (buf, value, offset, ext, max, min) {\n  if (offset + ext > buf.length) throw new RangeError('Index out of range')\n  if (offset < 0) throw new RangeError('Index out of range')\n}\n\nfunction writeFloat (buf, value, offset, littleEndian, noAssert) {\n  if (!noAssert) {\n    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)\n  }\n  ieee754.write(buf, value, offset, littleEndian, 23, 4)\n  return offset + 4\n}\n\nBuffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {\n  return writeFloat(this, value, offset, true, noAssert)\n}\n\nBuffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {\n  return writeFloat(this, value, offset, false, noAssert)\n}\n\nfunction writeDouble (buf, value, offset, littleEndian, noAssert) {\n  if (!noAssert) {\n    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)\n  }\n  ieee754.write(buf, value, offset, littleEndian, 52, 8)\n  return offset + 8\n}\n\nBuffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {\n  return writeDouble(this, value, offset, true, noAssert)\n}\n\nBuffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {\n  return writeDouble(this, value, offset, false, noAssert)\n}\n\n// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)\nBuffer.prototype.copy = function copy (target, targetStart, start, end) {\n  if (!start) start = 0\n  if (!end && end !== 0) end = this.length\n  if (targetStart >= target.length) targetStart = target.length\n  if (!targetStart) targetStart = 0\n  if (end > 0 && end < start) end = start\n\n  // Copy 0 bytes; we're done\n  if (end === start) return 0\n  if (target.length === 0 || this.length === 0) return 0\n\n  // Fatal error conditions\n  if (targetStart < 0) {\n    throw new RangeError('targetStart out of bounds')\n  }\n  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')\n  if (end < 0) throw new RangeError('sourceEnd out of bounds')\n\n  // Are we oob?\n  if (end > this.length) end = this.length\n  if (target.length - targetStart < end - start) {\n    end = target.length - targetStart + start\n  }\n\n  var len = end - start\n  var i\n\n  if (this === target && start < targetStart && targetStart < end) {\n    // descending copy from end\n    for (i = len - 1; i >= 0; --i) {\n      target[i + targetStart] = this[i + start]\n    }\n  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {\n    // ascending copy from start\n    for (i = 0; i < len; ++i) {\n      target[i + targetStart] = this[i + start]\n    }\n  } else {\n    Uint8Array.prototype.set.call(\n      target,\n      this.subarray(start, start + len),\n      targetStart\n    )\n  }\n\n  return len\n}\n\n// Usage:\n//    buffer.fill(number[, offset[, end]])\n//    buffer.fill(buffer[, offset[, end]])\n//    buffer.fill(string[, offset[, end]][, encoding])\nBuffer.prototype.fill = function fill (val, start, end, encoding) {\n  // Handle string cases:\n  if (typeof val === 'string') {\n    if (typeof start === 'string') {\n      encoding = start\n      start = 0\n      end = this.length\n    } else if (typeof end === 'string') {\n      encoding = end\n      end = this.length\n    }\n    if (val.length === 1) {\n      var code = val.charCodeAt(0)\n      if (code < 256) {\n        val = code\n      }\n    }\n    if (encoding !== undefined && typeof encoding !== 'string') {\n      throw new TypeError('encoding must be a string')\n    }\n    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {\n      throw new TypeError('Unknown encoding: ' + encoding)\n    }\n  } else if (typeof val === 'number') {\n    val = val & 255\n  }\n\n  // Invalid ranges are not set to a default, so can range check early.\n  if (start < 0 || this.length < start || this.length < end) {\n    throw new RangeError('Out of range index')\n  }\n\n  if (end <= start) {\n    return this\n  }\n\n  start = start >>> 0\n  end = end === undefined ? this.length : end >>> 0\n\n  if (!val) val = 0\n\n  var i\n  if (typeof val === 'number') {\n    for (i = start; i < end; ++i) {\n      this[i] = val\n    }\n  } else {\n    var bytes = Buffer.isBuffer(val)\n      ? val\n      : utf8ToBytes(new Buffer(val, encoding).toString())\n    var len = bytes.length\n    for (i = 0; i < end - start; ++i) {\n      this[i + start] = bytes[i % len]\n    }\n  }\n\n  return this\n}\n\n// HELPER FUNCTIONS\n// ================\n\nvar INVALID_BASE64_RE = /[^+\\/0-9A-Za-z-_]/g\n\nfunction base64clean (str) {\n  // Node strips out invalid characters like \\n and \\t from the string, base64-js does not\n  str = stringtrim(str).replace(INVALID_BASE64_RE, '')\n  // Node converts strings with length < 2 to ''\n  if (str.length < 2) return ''\n  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not\n  while (str.length % 4 !== 0) {\n    str = str + '='\n  }\n  return str\n}\n\nfunction stringtrim (str) {\n  if (str.trim) return str.trim()\n  return str.replace(/^\\s+|\\s+$/g, '')\n}\n\nfunction toHex (n) {\n  if (n < 16) return '0' + n.toString(16)\n  return n.toString(16)\n}\n\nfunction utf8ToBytes (string, units) {\n  units = units || Infinity\n  var codePoint\n  var length = string.length\n  var leadSurrogate = null\n  var bytes = []\n\n  for (var i = 0; i < length; ++i) {\n    codePoint = string.charCodeAt(i)\n\n    // is surrogate component\n    if (codePoint > 0xD7FF && codePoint < 0xE000) {\n      // last char was a lead\n      if (!leadSurrogate) {\n        // no lead yet\n        if (codePoint > 0xDBFF) {\n          // unexpected trail\n          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)\n          continue\n        } else if (i + 1 === length) {\n          // unpaired lead\n          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)\n          continue\n        }\n\n        // valid lead\n        leadSurrogate = codePoint\n\n        continue\n      }\n\n      // 2 leads in a row\n      if (codePoint < 0xDC00) {\n        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)\n        leadSurrogate = codePoint\n        continue\n      }\n\n      // valid surrogate pair\n      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000\n    } else if (leadSurrogate) {\n      // valid bmp char, but last char was a lead\n      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)\n    }\n\n    leadSurrogate = null\n\n    // encode utf8\n    if (codePoint < 0x80) {\n      if ((units -= 1) < 0) break\n      bytes.push(codePoint)\n    } else if (codePoint < 0x800) {\n      if ((units -= 2) < 0) break\n      bytes.push(\n        codePoint >> 0x6 | 0xC0,\n        codePoint & 0x3F | 0x80\n      )\n    } else if (codePoint < 0x10000) {\n      if ((units -= 3) < 0) break\n      bytes.push(\n        codePoint >> 0xC | 0xE0,\n        codePoint >> 0x6 & 0x3F | 0x80,\n        codePoint & 0x3F | 0x80\n      )\n    } else if (codePoint < 0x110000) {\n      if ((units -= 4) < 0) break\n      bytes.push(\n        codePoint >> 0x12 | 0xF0,\n        codePoint >> 0xC & 0x3F | 0x80,\n        codePoint >> 0x6 & 0x3F | 0x80,\n        codePoint & 0x3F | 0x80\n      )\n    } else {\n      throw new Error('Invalid code point')\n    }\n  }\n\n  return bytes\n}\n\nfunction asciiToBytes (str) {\n  var byteArray = []\n  for (var i = 0; i < str.length; ++i) {\n    // Node's code seems to be doing this and not & 0x7F..\n    byteArray.push(str.charCodeAt(i) & 0xFF)\n  }\n  return byteArray\n}\n\nfunction utf16leToBytes (str, units) {\n  var c, hi, lo\n  var byteArray = []\n  for (var i = 0; i < str.length; ++i) {\n    if ((units -= 2) < 0) break\n\n    c = str.charCodeAt(i)\n    hi = c >> 8\n    lo = c % 256\n    byteArray.push(lo)\n    byteArray.push(hi)\n  }\n\n  return byteArray\n}\n\nfunction base64ToBytes (str) {\n  return base64.toByteArray(base64clean(str))\n}\n\nfunction blitBuffer (src, dst, offset, length) {\n  for (var i = 0; i < length; ++i) {\n    if ((i + offset >= dst.length) || (i >= src.length)) break\n    dst[i + offset] = src[i]\n  }\n  return i\n}\n\nfunction isnan (val) {\n  return val !== val // eslint-disable-line no-self-compare\n}\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../webpack/buildin/global.js */ \"./node_modules/webpack/buildin/global.js\")))\n\n//# sourceURL=webpack:///./node_modules/buffer/index.js?");

/***/ }),

/***/ "./node_modules/buffer/node_modules/isarray/index.js":
/*!***********************************************************!*\
  !*** ./node_modules/buffer/node_modules/isarray/index.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("var toString = {}.toString;\n\nmodule.exports = Array.isArray || function (arr) {\n  return toString.call(arr) == '[object Array]';\n};\n\n\n//# sourceURL=webpack:///./node_modules/buffer/node_modules/isarray/index.js?");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/ts-loader/index.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/components/DetailedRunView.vue?vue&type=script&lang=ts":
/*!******************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/components/DetailedRunView.vue?vue&type=script&lang=ts ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.filter.js */ \"./node_modules/core-js/modules/es.array.filter.js\");\n/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ \"./node_modules/core-js/modules/es.array.for-each.js\");\n/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.from.js */ \"./node_modules/core-js/modules/es.array.from.js\");\n/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.index-of.js */ \"./node_modules/core-js/modules/es.array.index-of.js\");\n/* harmony import */ var core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_index_of_js__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ \"./node_modules/core-js/modules/es.array.join.js\");\n/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ \"./node_modules/core-js/modules/es.array.map.js\");\n/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ \"./node_modules/core-js/modules/es.array.slice.js\");\n/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_6__);\n/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ \"./node_modules/core-js/modules/es.function.name.js\");\n/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_7__);\n/* harmony import */ var core_js_modules_es_object_values_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.values.js */ \"./node_modules/core-js/modules/es.object.values.js\");\n/* harmony import */ var core_js_modules_es_object_values_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_values_js__WEBPACK_IMPORTED_MODULE_8__);\n/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ \"./node_modules/core-js/modules/es.regexp.exec.js\");\n/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_9__);\n/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ \"./node_modules/core-js/modules/es.string.iterator.js\");\n/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_10__);\n/* harmony import */ var core_js_modules_es_string_split_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.string.split.js */ \"./node_modules/core-js/modules/es.string.split.js\");\n/* harmony import */ var core_js_modules_es_string_split_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_split_js__WEBPACK_IMPORTED_MODULE_11__);\n/* harmony import */ var core_js_modules_es_string_starts_with_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.string.starts-with.js */ \"./node_modules/core-js/modules/es.string.starts-with.js\");\n/* harmony import */ var core_js_modules_es_string_starts_with_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_starts_with_js__WEBPACK_IMPORTED_MODULE_12__);\n/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ \"./node_modules/core-js/modules/web.dom-collections.for-each.js\");\n/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_13__);\n/* harmony import */ var regenerator_runtime_runtime_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! regenerator-runtime/runtime.js */ \"./node_modules/regenerator-runtime/runtime.js\");\n/* harmony import */ var regenerator_runtime_runtime_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(regenerator_runtime_runtime_js__WEBPACK_IMPORTED_MODULE_14__);\n/* harmony import */ var _Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_asyncToGenerator__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator */ \"./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js\");\n/* harmony import */ var _vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @vue/runtime-core */ \"./node_modules/@vue/runtime-core/dist/runtime-core.esm-bundler.js\");\n/* harmony import */ var _api_API__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/api/API */ \"./src/api/API.ts\");\n/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! d3 */ \"./node_modules/d3/d3.js\");\n/* harmony import */ var d3__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(d3__WEBPACK_IMPORTED_MODULE_18__);\n/* harmony import */ var _components_PlotlyLineplot_vue__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @/components/PlotlyLineplot.vue */ \"./src/components/PlotlyLineplot.vue\");\n/* harmony import */ var _components_ChoroplethMap_vue__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @/components/ChoroplethMap.vue */ \"./src/components/ChoroplethMap.vue\");\n/* harmony import */ var _components_GeoSlider_vue__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @/components/GeoSlider.vue */ \"./src/components/GeoSlider.vue\");\n/* harmony import */ var _components_ParamSelector_vue__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @/components/ParamSelector.vue */ \"./src/components/ParamSelector.vue\");\n/* harmony import */ var _logic_ui_config__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../logic/ui_config */ \"./src/logic/ui_config.ts\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"defineComponent\"])({\n  name: \"DetailedRunView\",\n  components: {\n    PlotlyLineplot: _components_PlotlyLineplot_vue__WEBPACK_IMPORTED_MODULE_19__[\"default\"],\n    ChoroplethMap: _components_ChoroplethMap_vue__WEBPACK_IMPORTED_MODULE_20__[\"default\"],\n    GeoSlider: _components_GeoSlider_vue__WEBPACK_IMPORTED_MODULE_21__[\"default\"],\n    ParamSelector: _components_ParamSelector_vue__WEBPACK_IMPORTED_MODULE_22__[\"default\"]\n  },\n  props: {\n    projectId: {\n      type: String,\n      required: true\n    },\n    runId: {\n      type: String,\n      required: true\n    },\n    axisRanges: {\n      type: Object,\n      default: {}\n    },\n    mutePlots: {\n      type: Boolean,\n      default: false\n    }\n  },\n  setup: function setup(props, context) {\n    return Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_asyncToGenerator__WEBPACK_IMPORTED_MODULE_15__[\"default\"])( /*#__PURE__*/regeneratorRuntime.mark(function _callee6() {\n      var project, run, selectedRegion, paramOptions, plotlys, hasProject, hasRun, hasParamOptions, selectedOptionIdxs, regionTrace, xData, fieldsSIR, fieldTracesSIR, dataSIR, legendSIR, hasLocInfo, fieldsLoc, fieldTracesLoc, dataLoc, legendLoc, hasAgeInfo, fieldsAge, selectedFieldAge, validFieldsAge, ageBinKeys, fieldTracesAge, dataAge, legendAge, allRegions, allFields, selectedFieldGeo, changeRun, axisRangeExtents, redraw;\n      return regeneratorRuntime.wrap(function _callee6$(_context6) {\n        while (1) {\n          switch (_context6.prev = _context6.next) {\n            case 0:\n              redraw = function _redraw() {\n                //@ts-ignore\n                var vs = Object.values(plotlys.value); //@ts-ignore\n\n                vs.forEach(function (p) {\n                  return p != null && p.draw();\n                });\n              };\n\n              axisRangeExtents = function _axisRangeExtents() {\n                var SIRmin = d3__WEBPACK_IMPORTED_MODULE_18__[\"min\"](fieldTracesSIR.value.map(function (v) {\n                  return d3__WEBPACK_IMPORTED_MODULE_18__[\"min\"](v);\n                }));\n                var SIRmax = d3__WEBPACK_IMPORTED_MODULE_18__[\"max\"](fieldTracesSIR.value.map(function (v) {\n                  return d3__WEBPACK_IMPORTED_MODULE_18__[\"max\"](v);\n                }));\n                var LocMin = d3__WEBPACK_IMPORTED_MODULE_18__[\"min\"](fieldTracesLoc.value.map(function (v) {\n                  return d3__WEBPACK_IMPORTED_MODULE_18__[\"min\"](v);\n                }));\n                var LocMax = d3__WEBPACK_IMPORTED_MODULE_18__[\"max\"](fieldTracesLoc.value.map(function (v) {\n                  return d3__WEBPACK_IMPORTED_MODULE_18__[\"max\"](v);\n                }));\n                var AgeMin = d3__WEBPACK_IMPORTED_MODULE_18__[\"min\"](fieldTracesAge.value.map(function (v) {\n                  return d3__WEBPACK_IMPORTED_MODULE_18__[\"min\"](v);\n                }));\n                var AgeMax = d3__WEBPACK_IMPORTED_MODULE_18__[\"max\"](fieldTracesAge.value.map(function (v) {\n                  return d3__WEBPACK_IMPORTED_MODULE_18__[\"max\"](v);\n                }));\n                return {\n                  SIR: [SIRmin, SIRmax],\n                  Loc: [LocMin, LocMax],\n                  Age: [AgeMin, AgeMax]\n                };\n              };\n\n              changeRun = function _changeRun(event) {\n                context.emit(\"selected-options-change\", event);\n              };\n\n              project = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"ref\"])(undefined);\n              run = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"ref\"])(undefined);\n              selectedRegion = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"ref\"])(\"\");\n              paramOptions = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"ref\"])([]); // Create objects to bind for Plotly graphs, if redrawing is needed\n\n              plotlys = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"ref\"])({\n                SIR: null,\n                Age: null,\n                Loc: null\n              });\n              Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"onBeforeUpdate\"])(function () {\n                //@ts-ignore\n                plotlys.value = {\n                  SIR: null,\n                  Age: null,\n                  Loc: null\n                };\n              });\n              hasProject = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return project.value != undefined;\n              });\n              hasRun = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return run.value != undefined;\n              });\n              hasParamOptions = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return paramOptions.value.length > 0;\n              }); // project won't change, run can\n\n              Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"watchEffect\"])( /*#__PURE__*/Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_asyncToGenerator__WEBPACK_IMPORTED_MODULE_15__[\"default\"])( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {\n                return regeneratorRuntime.wrap(function _callee$(_context) {\n                  while (1) {\n                    switch (_context.prev = _context.next) {\n                      case 0:\n                        _context.next = 2;\n                        return _api_API__WEBPACK_IMPORTED_MODULE_17__[\"getProject\"](props.projectId);\n\n                      case 2:\n                        project.value = _context.sent;\n\n                      case 3:\n                      case \"end\":\n                        return _context.stop();\n                    }\n                  }\n                }, _callee);\n              })));\n              Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"watchEffect\"])( /*#__PURE__*/Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_asyncToGenerator__WEBPACK_IMPORTED_MODULE_15__[\"default\"])( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {\n                return regeneratorRuntime.wrap(function _callee2$(_context2) {\n                  while (1) {\n                    switch (_context2.prev = _context2.next) {\n                      case 0:\n                        _context2.next = 2;\n                        return _api_API__WEBPACK_IMPORTED_MODULE_17__[\"getRun\"](props.projectId, props.runId);\n\n                      case 2:\n                        run.value = _context2.sent;\n\n                      case 3:\n                      case \"end\":\n                        return _context2.stop();\n                    }\n                  }\n                }, _callee2);\n              })));\n              Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"watchEffect\"])( /*#__PURE__*/Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_asyncToGenerator__WEBPACK_IMPORTED_MODULE_15__[\"default\"])( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {\n                return regeneratorRuntime.wrap(function _callee3$(_context3) {\n                  while (1) {\n                    switch (_context3.prev = _context3.next) {\n                      case 0:\n                        _context3.next = 2;\n                        return _api_API__WEBPACK_IMPORTED_MODULE_17__[\"getRun\"](props.projectId, props.runId);\n\n                      case 2:\n                        run.value = _context3.sent;\n\n                      case 3:\n                      case \"end\":\n                        return _context3.stop();\n                    }\n                  }\n                }, _callee3);\n              })));\n              Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"watchEffect\"])( /*#__PURE__*/Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_asyncToGenerator__WEBPACK_IMPORTED_MODULE_15__[\"default\"])( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {\n                return regeneratorRuntime.wrap(function _callee4$(_context4) {\n                  while (1) {\n                    switch (_context4.prev = _context4.next) {\n                      case 0:\n                        _context4.next = 2;\n                        return _api_API__WEBPACK_IMPORTED_MODULE_17__[\"getParamSelection\"](props.projectId);\n\n                      case 2:\n                        paramOptions.value = _context4.sent;\n\n                      case 3:\n                      case \"end\":\n                        return _context4.stop();\n                    }\n                  }\n                }, _callee4);\n              })));\n              Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"watchEffect\"])( /*#__PURE__*/Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_asyncToGenerator__WEBPACK_IMPORTED_MODULE_15__[\"default\"])( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {\n                var _project$value$availa, _project$value;\n\n                return regeneratorRuntime.wrap(function _callee5$(_context5) {\n                  while (1) {\n                    switch (_context5.prev = _context5.next) {\n                      case 0:\n                        selectedRegion.value = (_project$value$availa = (_project$value = project.value) === null || _project$value === void 0 ? void 0 : _project$value.available_regions[0]) !== null && _project$value$availa !== void 0 ? _project$value$availa : \"\";\n\n                      case 1:\n                      case \"end\":\n                        return _context5.stop();\n                    }\n                  }\n                }, _callee5);\n              })));\n              selectedOptionIdxs = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return hasRun.value ? paramOptions.value.map(function (p) {\n                  //@ts-ignore\n                  return p.options.indexOf(run.value.run_parameters[p.name]);\n                }) : [];\n              });\n              regionTrace = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                var _run$value$aggregateB, _run$value;\n\n                return (_run$value$aggregateB = (_run$value = run.value) === null || _run$value === void 0 ? void 0 : _run$value.aggregateByRegion(selectedRegion.value)) !== null && _run$value$aggregateB !== void 0 ? _run$value$aggregateB : [];\n              });\n              xData = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return _logic_ui_config__WEBPACK_IMPORTED_MODULE_23__[\"default\"].showRealDate ? regionTrace.value.map(function (d, i) {\n                  return d.date_time;\n                }) : regionTrace.value.map(function (d, i) {\n                  return i;\n                });\n              }); // SIR Curve Information\n\n              fieldsSIR = [\"currently_susceptible\", \"currently_infected\", \"currently_recovered\"];\n              fieldTracesSIR = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return fieldsSIR.map(function (f) {\n                  return regionTrace.value.map(function (d) {\n                    return d[f];\n                  });\n                });\n              });\n              dataSIR = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return fieldTracesSIR.value.map(function (t) {\n                  return {\n                    x: xData.value,\n                    y: t\n                  };\n                });\n              });\n              legendSIR = [\"susceptible\", \"infected\", \"recovered\"]; // Location of Infection Information\n\n              hasLocInfo = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                var _project$value2;\n\n                return (_project$value2 = project.value) === null || _project$value2 === void 0 ? void 0 : _project$value2.hasLocOfInfectionInfo;\n              }); // const hasLocInfo = false; // For testing\n\n              fieldsLoc = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                var _project$value$locOfI, _project$value3;\n\n                return (_project$value$locOfI = (_project$value3 = project.value) === null || _project$value3 === void 0 ? void 0 : _project$value3.locOfInfectionFields) !== null && _project$value$locOfI !== void 0 ? _project$value$locOfI : [];\n              });\n              fieldTracesLoc = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return fieldsLoc.value.map(function (f) {\n                  return regionTrace.value.map(function (d) {\n                    return d[f];\n                  });\n                });\n              });\n              dataLoc = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return fieldTracesLoc.value.map(function (t) {\n                  return {\n                    x: xData.value,\n                    y: t\n                  };\n                });\n              });\n              legendLoc = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return fieldsLoc.value.map(function (f) {\n                  return f.split(\"_\").slice(3).join(\"_\");\n                });\n              }); // Age of infection information\n\n              hasAgeInfo = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                var _project$value4;\n\n                return (_project$value4 = project.value) === null || _project$value4 === void 0 ? void 0 : _project$value4.hasAgeInfo;\n              }); // const hasAgeInfo = false; // For testing\n\n              fieldsAge = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                var _project$value$ageFie, _project$value5;\n\n                return Array.from((_project$value$ageFie = (_project$value5 = project.value) === null || _project$value5 === void 0 ? void 0 : _project$value5.ageFieldsAvailable) !== null && _project$value$ageFie !== void 0 ? _project$value$ageFie : []);\n              });\n              selectedFieldAge = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"ref\"])(\"\");\n              Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"watch\"])(function () {\n                return fieldsAge.value;\n              }, function () {\n                if (selectedFieldAge.value == \"\" && fieldsAge.value.length > 0) {\n                  selectedFieldAge.value = fieldsAge.value[0];\n                }\n              });\n              validFieldsAge = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                var _project$value$all_fi, _project$value6;\n\n                return (_project$value$all_fi = (_project$value6 = project.value) === null || _project$value6 === void 0 ? void 0 : _project$value6.all_fields.filter(function (f) {\n                  return f.startsWith(selectedFieldAge.value + \"_\");\n                })) !== null && _project$value$all_fi !== void 0 ? _project$value$all_fi : [];\n              });\n              ageBinKeys = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                var _run$value$ageBinKeys, _run$value2;\n\n                return (_run$value$ageBinKeys = (_run$value2 = run.value) === null || _run$value2 === void 0 ? void 0 : _run$value2.ageBinKeys()) !== null && _run$value$ageBinKeys !== void 0 ? _run$value$ageBinKeys : [];\n              });\n              fieldTracesAge = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                var _run$value$ageBinCoun, _run$value3;\n\n                var ageBinCounts = (_run$value$ageBinCoun = (_run$value3 = run.value) === null || _run$value3 === void 0 ? void 0 : _run$value3.ageBinCounts(regionTrace.value)) !== null && _run$value$ageBinCoun !== void 0 ? _run$value$ageBinCoun : {};\n                return validFieldsAge.value.map(function (f, i) {\n                  if (_logic_ui_config__WEBPACK_IMPORTED_MODULE_23__[\"default\"].normalizeAgeBins) {\n                    var div = ageBinCounts[ageBinKeys.value[i]]; //@ts-ignore\n\n                    return regionTrace.value.map(function (d) {\n                      return +d[f] / div;\n                    });\n                  }\n\n                  return regionTrace.value.map(function (d) {\n                    return d[f];\n                  });\n                });\n              });\n              dataAge = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return fieldTracesAge.value.map(function (t, i) {\n                  return {\n                    x: xData.value,\n                    y: t\n                  };\n                });\n              });\n              legendAge = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                return validFieldsAge.value.map(function (f) {\n                  return \"Ages \" + f.split(\"_\").slice(-2).join(\" - \");\n                });\n              }); // Chloropleth Information\n\n              allRegions = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                var _project$value$all_re, _project$value7;\n\n                return (_project$value$all_re = (_project$value7 = project.value) === null || _project$value7 === void 0 ? void 0 : _project$value7.all_regions) !== null && _project$value$all_re !== void 0 ? _project$value$all_re : [];\n              });\n              allFields = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"computed\"])(function () {\n                var _project$value$baseNu, _project$value8;\n\n                return (_project$value$baseNu = (_project$value8 = project.value) === null || _project$value8 === void 0 ? void 0 : _project$value8.baseNumericFields) !== null && _project$value$baseNu !== void 0 ? _project$value$baseNu : [];\n              });\n              selectedFieldGeo = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"ref\"])(allFields.value.length > 0 ? allFields.value[0] : \"\");\n              Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_16__[\"watch\"])(function () {\n                return allFields.value;\n              }, function () {\n                if (selectedFieldGeo.value == \"\" && allFields.value.length > 0) {\n                  selectedFieldGeo.value = allFields.value[0];\n                }\n              });\n              return _context6.abrupt(\"return\", {\n                project: project,\n                run: run,\n                hasProject: hasProject,\n                hasRun: hasRun,\n                selectedRegion: selectedRegion,\n                dataSIR: dataSIR,\n                legendSIR: legendSIR,\n                hasLocInfo: hasLocInfo,\n                dataLoc: dataLoc,\n                legendLoc: legendLoc,\n                selectedFieldGeo: selectedFieldGeo,\n                hasAgeInfo: hasAgeInfo,\n                selectedFieldAge: selectedFieldAge,\n                dataAge: dataAge,\n                legendAge: legendAge,\n                fieldsAge: fieldsAge,\n                paramOptions: paramOptions,\n                selectedOptionIdxs: selectedOptionIdxs,\n                changeRun: changeRun,\n                axisRangeExtents: axisRangeExtents,\n                plotlys: plotlys,\n                redraw: redraw\n              });\n\n            case 43:\n            case \"end\":\n              return _context6.stop();\n          }\n        }\n      }, _callee6);\n    }))();\n  },\n  emits: [\"selected-options-change\"]\n}));\n\n//# sourceURL=webpack:///./src/components/DetailedRunView.vue?./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/ts-loader/index.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/components/ParamSelector.vue?vue&type=script&lang=ts":
/*!****************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/components/ParamSelector.vue?vue&type=script&lang=ts ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ \"./node_modules/core-js/modules/es.function.name.js\");\n/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.number.constructor.js */ \"./node_modules/core-js/modules/es.number.constructor.js\");\n/* harmony import */ var core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor_js__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.runtime.esm-bundler.js\");\n/* harmony import */ var _logic_display__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/logic/display */ \"./src/logic/display.ts\");\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"defineComponent\"])({\n  name: \"ParamSelector\",\n  props: {\n    paramData: {\n      type: Object,\n      required: true\n    },\n    selectedOptionIdxs: {\n      type: Object,\n      required: true\n    },\n    freeIdx: {\n      type: Number || null,\n      default: null,\n      required: false\n    },\n    allowRowSelection: {\n      type: Boolean,\n      default: true\n    }\n  },\n  setup: function setup(props, context) {\n    var hoveredRowIdx = Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"ref\"])(null);\n    var selectedRowIdx = Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"computed\"])(function () {\n      return props.allowRowSelection ? props.freeIdx : null;\n    });\n\n    function hoverRow(i) {\n      hoveredRowIdx.value = i;\n    }\n\n    function unHoverRow(i) {\n      hoveredRowIdx.value = null;\n    }\n\n    function emitFree(idx) {\n      context.emit(\"free-idx-change\", {\n        freeIdx: idx\n      });\n    }\n\n    function emitSelectedOptions(rowIdx, optionIdx) {\n      if (rowIdx != selectedRowIdx.value && !(props.selectedOptionIdxs[rowIdx] == optionIdx)) {\n        var pd = props.paramData[rowIdx];\n        context.emit(\"selected-options-change\", {\n          rowIdx: rowIdx,\n          optionIdx: optionIdx,\n          paramName: pd.name,\n          paramValue: pd.options[optionIdx],\n          fullParamData: props.paramData,\n          prevSelectedOptionIdxs: props.selectedOptionIdxs\n        });\n      }\n    }\n\n    return {\n      formatValDisplay: _logic_display__WEBPACK_IMPORTED_MODULE_3__[\"formatValDisplay\"],\n      emitFree: emitFree,\n      emitSelectedOptions: emitSelectedOptions,\n      hoveredRowIdx: hoveredRowIdx,\n      selectedRowIdx: selectedRowIdx,\n      hoverRow: hoverRow,\n      unHoverRow: unHoverRow\n    };\n  },\n  emits: [\"selected-options-change\", \"free-idx-change\"]\n}));\n\n//# sourceURL=webpack:///./src/components/ParamSelector.vue?./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/ts-loader/index.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/components/PlotlyLineplot.vue?vue&type=script&lang=ts":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/components/PlotlyLineplot.vue?vue&type=script&lang=ts ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ \"./node_modules/core-js/modules/es.array.map.js\");\n/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_objectSpread2__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/objectSpread2 */ \"./node_modules/@babel/runtime/helpers/esm/objectSpread2.js\");\n/* harmony import */ var _vue_runtime_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @vue/runtime-core */ \"./node_modules/@vue/runtime-core/dist/runtime-core.esm-bundler.js\");\n/* harmony import */ var _logic_display__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/logic/display */ \"./src/logic/display.ts\");\n/* harmony import */ var plotly_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! plotly.js */ \"./node_modules/plotly.js/lib/index.js\");\n/* harmony import */ var plotly_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(plotly_js__WEBPACK_IMPORTED_MODULE_4__);\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_2__[\"defineComponent\"])({\n  name: \"PlotlyLineplot\",\n  props: {\n    plotData: {\n      type: Array,\n      required: true\n    },\n    title: {\n      type: String,\n      default: null\n    },\n    legend: {\n      type: Array,\n      default: null\n    },\n    yLabel: {\n      type: String,\n      default: \"Number of People\"\n    },\n    yRange: {\n      type: Array,\n      default: undefined\n    }\n  },\n  setup: function setup(props, ctx) {\n    var plotDiv = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_2__[\"ref\"])(null);\n\n    var convertData = function convertData(data) {\n      return data.map(function (v, i) {\n        return Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_objectSpread2__WEBPACK_IMPORTED_MODULE_1__[\"default\"])({\n          type: \"scatter\",\n          name: props.legend == undefined ? undefined : props.legend[i],\n          line: {\n            color: Object(_logic_display__WEBPACK_IMPORTED_MODULE_3__[\"lineColor\"])(i)\n          }\n        }, v);\n      });\n    };\n\n    var layout = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_2__[\"computed\"])(function () {\n      return {\n        title: props.title || undefined,\n        yaxis: {\n          fixedrange: false,\n          title: props.yLabel,\n          range: props.yRange\n        },\n        xaxis: {\n          // fixedrange: true,\n          title: \"Day\"\n        }\n      };\n    });\n\n    function draw() {\n      if (plotDiv.value != null && plotDiv.value != undefined) {\n        plotly_js__WEBPACK_IMPORTED_MODULE_4___default.a.newPlot(plotDiv.value, convertData(props.plotData), layout.value);\n      }\n    }\n\n    function redraw() {\n      if (plotDiv.value != null && plotDiv.value != undefined) {\n        plotly_js__WEBPACK_IMPORTED_MODULE_4___default.a.react(plotDiv.value, convertData(props.plotData), layout.value);\n      }\n    }\n\n    Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_2__[\"onMounted\"])(function () {\n      draw();\n    });\n    Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_2__[\"watch\"])(function () {\n      return [props.plotData, layout.value];\n    }, function () {\n      redraw();\n    });\n    return {\n      plotDiv: plotDiv,\n      draw: draw,\n      redraw: redraw\n    };\n  }\n}));\n\n//# sourceURL=webpack:///./src/components/PlotlyLineplot.vue?./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/ts-loader/index.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/components/RunSummaryCard.vue?vue&type=script&lang=ts":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/components/RunSummaryCard.vue?vue&type=script&lang=ts ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ \"./node_modules/core-js/modules/es.array.concat.js\");\n/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ \"./node_modules/core-js/modules/es.array.map.js\");\n/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var core_js_modules_es_number_to_fixed_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.number.to-fixed.js */ \"./node_modules/core-js/modules/es.number.to-fixed.js\");\n/* harmony import */ var core_js_modules_es_number_to_fixed_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_to_fixed_js__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/toConsumableArray */ \"./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js\");\n/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.runtime.esm-bundler.js\");\n/* harmony import */ var _logic_display__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/logic/display */ \"./src/logic/display.ts\");\n/* harmony import */ var _api_API__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/api/API */ \"./src/api/API.ts\");\n/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! d3-array */ \"./node_modules/d3-array/src/index.js\");\n/* harmony import */ var d3_scale__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! d3-scale */ \"./node_modules/d3-scale/src/index.js\");\n/* harmony import */ var d3_shape__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! d3-shape */ \"./node_modules/d3-shape/src/index.js\");\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"defineComponent\"])({\n  name: \"RunSummaryCard\",\n  components: {},\n  props: {\n    projectId: {\n      type: String,\n      required: true\n    },\n    runId: {\n      type: String,\n      required: true\n    },\n    yExtent: {\n      type: Object,\n      default: undefined\n    },\n    xExtent: {\n      type: Object,\n      default: undefined\n    },\n    isBaseline: {\n      type: Boolean,\n      default: false\n    },\n    observer: {\n      type: Object,\n      default: undefined\n    },\n    region: {\n      type: String,\n      default: null\n    },\n    shadowColor: {\n      type: String,\n      default: null\n    }\n  },\n  setup: function setup(props, context) {\n    var svgWidth = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"ref\"])(225);\n    var svgHeight = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"ref\"])(150);\n    var root = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"ref\"])(null);\n    var run = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"ref\"])(null);\n    var run_parameters = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"ref\"])({});\n    var isLoaded = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"ref\"])(false); // change on component start\n\n    var trace = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n      if (run.value == null) return [];\n      if (props.region == null) return run.value.aggregateByAvgRegion();\n      return run.value.aggregateByRegion(props.region);\n    });\n    var susceptible = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n      return trace.value.map(function (t) {\n        return t.currently_susceptible;\n      });\n    });\n    var infected = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n      return trace.value.map(function (t) {\n        return t.currently_infected;\n      });\n    });\n    var recovered = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n      return trace.value.map(function (t) {\n        return t.currently_recovered;\n      });\n    });\n    var yExtent = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n      if (props.yExtent == undefined) {\n        //@ts-ignore\n        return Object(d3_array__WEBPACK_IMPORTED_MODULE_7__[\"extent\"])([].concat(Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(susceptible.value), Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(infected.value), Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(recovered.value)));\n      }\n\n      return props.yExtent;\n    });\n    var xExtent = props.xExtent == undefined ? Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n      return [0, susceptible.value.length];\n    }) : Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n      return props.xExtent;\n    });\n    var scales = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n      return {\n        x: Object(d3_scale__WEBPACK_IMPORTED_MODULE_8__[\"scaleLinear\"])().domain(xExtent.value).range([0, svgWidth.value]),\n        y: Object(d3_scale__WEBPACK_IMPORTED_MODULE_8__[\"scaleLinear\"])().domain(yExtent.value).range([svgHeight.value, 0])\n      };\n    });\n    var lineFct = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n      return Object(d3_shape__WEBPACK_IMPORTED_MODULE_9__[\"line\"])().x(function (d, i) {\n        return scales.value.x(i);\n      }).y(function (d) {\n        return scales.value.y(d);\n      });\n    });\n    var paths = Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n      return [{\n        className: \"susceptible\",\n        path: lineFct.value(susceptible.value),\n        style: \"stroke: \".concat(_logic_display__WEBPACK_IMPORTED_MODULE_5__[\"colorway\"][_logic_display__WEBPACK_IMPORTED_MODULE_5__[\"colorway\"].length - 1])\n      }, {\n        className: \"infected\",\n        path: lineFct.value(infected.value),\n        style: \"stroke: \".concat(_logic_display__WEBPACK_IMPORTED_MODULE_5__[\"colorway\"][_logic_display__WEBPACK_IMPORTED_MODULE_5__[\"colorway\"].length - 2])\n      }, {\n        className: \"recovered\",\n        path: lineFct.value(recovered.value),\n        style: \"stroke: \".concat(_logic_display__WEBPACK_IMPORTED_MODULE_5__[\"colorway\"][_logic_display__WEBPACK_IMPORTED_MODULE_5__[\"colorway\"].length - 3])\n      }];\n    });\n\n    function formatValDisplay(val) {\n      if (typeof val == \"number\") return val.toFixed(2);\n      return val;\n    }\n\n    function emitBaseline() {\n      context.emit(\"set-baseline\", {\n        runId: props.runId\n      });\n    }\n\n    function emitClick() {\n      context.emit(\"card-click\", {\n        runId: props.runId\n      });\n    }\n\n    function load() {\n      _api_API__WEBPACK_IMPORTED_MODULE_6__[\"getRun\"](props.projectId, props.runId).then(function (r) {\n        run.value = r;\n        isLoaded.value = true;\n      });\n    }\n\n    Object(vue__WEBPACK_IMPORTED_MODULE_4__[\"onMounted\"])(function () {\n      if (props.observer != undefined && root.value != null) {\n        props.observer.observe(root.value);\n      }\n    });\n    return {\n      run: run,\n      paths: paths,\n      svgWidth: svgWidth,\n      svgHeight: svgHeight,\n      formatValDisplay: formatValDisplay,\n      emitBaseline: emitBaseline,\n      emitClick: emitClick,\n      root: root,\n      isLoaded: isLoaded,\n      load: load,\n      yExtent: yExtent\n    };\n  },\n  emits: [\"set-baseline\", \"card-click\", \"on-screen\"]\n}));\n\n//# sourceURL=webpack:///./src/components/RunSummaryCard.vue?./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/ts-loader/index.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/components/RunSummaryList.vue?vue&type=script&lang=ts":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/components/RunSummaryList.vue?vue&type=script&lang=ts ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ \"./node_modules/core-js/modules/es.array.for-each.js\");\n/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ \"./node_modules/core-js/modules/web.dom-collections.for-each.js\");\n/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var regenerator_runtime_runtime_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! regenerator-runtime/runtime.js */ \"./node_modules/regenerator-runtime/runtime.js\");\n/* harmony import */ var regenerator_runtime_runtime_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(regenerator_runtime_runtime_js__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_asyncToGenerator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator */ \"./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js\");\n/* harmony import */ var _vue_reactivity__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @vue/reactivity */ \"./node_modules/@vue/reactivity/dist/reactivity.esm-bundler.js\");\n/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.runtime.esm-bundler.js\");\n/* harmony import */ var _RunSummaryCard_vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./RunSummaryCard.vue */ \"./src/components/RunSummaryCard.vue\");\n/* harmony import */ var _api_API__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../api/API */ \"./src/api/API.ts\");\n/* harmony import */ var _logic_display__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/logic/display */ \"./src/logic/display.ts\");\n\n\n\n\n\n/**\n * The asynchronous setup to browser (loading from the API)\n */\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Object(vue__WEBPACK_IMPORTED_MODULE_5__[\"defineComponent\"])({\n  name: \"RunSummaryList\",\n  components: {\n    RunSummaryCard: _RunSummaryCard_vue__WEBPACK_IMPORTED_MODULE_6__[\"default\"]\n  },\n  props: {\n    projectId: {\n      type: String,\n      required: true\n    },\n    runKeys: {\n      type: Object,\n      required: true\n    },\n    selectedRuns: {\n      type: Object,\n      default: []\n    },\n    baselineRunId: {\n      type: String,\n      default: \"\"\n    },\n    allowSorting: {\n      type: Boolean,\n      default: true\n    }\n  },\n  setup: function setup(props, context) {\n    return Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_asyncToGenerator__WEBPACK_IMPORTED_MODULE_3__[\"default\"])( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {\n      var project, yExtent, runCards, allKeys, sortByKey, orderOptions, sortOrder, region, baselineRunIdRef, runColors, callback, observer, getParam, runIDsOrdered, emitBaseline, emitCardClick;\n      return regeneratorRuntime.wrap(function _callee$(_context) {\n        while (1) {\n          switch (_context.prev = _context.next) {\n            case 0:\n              emitCardClick = function _emitCardClick(payload) {\n                context.emit(\"card-click\", payload);\n              };\n\n              emitBaseline = function _emitBaseline(payload) {\n                context.emit(\"set-baseline\", payload);\n              };\n\n              _context.next = 4;\n              return _api_API__WEBPACK_IMPORTED_MODULE_7__[\"getProject\"](props.projectId);\n\n            case 4:\n              project = _context.sent;\n              yExtent = project.fieldExtent([\"currently_susceptible\", \"currently_recovered\", \"currently_infected\"]);\n              runCards = Object(_vue_reactivity__WEBPACK_IMPORTED_MODULE_4__[\"ref\"])({});\n              allKeys = Object(_vue_reactivity__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n                return project.sorting_parameters;\n              });\n              sortByKey = Object(_vue_reactivity__WEBPACK_IMPORTED_MODULE_4__[\"ref\"])(allKeys.value.length > 0 ? allKeys.value[0] : \"\");\n              orderOptions = [\"ascending\", \"descending\"];\n              sortOrder = Object(_vue_reactivity__WEBPACK_IMPORTED_MODULE_4__[\"ref\"])(orderOptions[0]);\n              region = project.all_regions[0];\n              baselineRunIdRef = Object(_vue_reactivity__WEBPACK_IMPORTED_MODULE_4__[\"ref\"])(props.baselineRunId);\n              runColors = Object(_vue_reactivity__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n                var out = {};\n                props.selectedRuns.forEach(function (r, i) {\n                  out[r] = Object(_logic_display__WEBPACK_IMPORTED_MODULE_8__[\"lineColor\"])(i);\n                });\n                return out;\n              });\n\n              callback = function callback(entries) {\n                entries.forEach(function (_ref) {\n                  var target = _ref.target,\n                      isIntersecting = _ref.isIntersecting;\n\n                  if (!isIntersecting) {\n                    return;\n                  }\n\n                  observer.unobserve(target);\n                  var i = target.getAttribute(\"run-id\");\n                  runCards.value[i].load();\n                });\n              };\n\n              observer = new IntersectionObserver(callback, {\n                // root: document.querySelector(\"#observer-root\"),\n                threshold: 0.4\n              });\n\n              getParam = function getParam(run, val) {\n                return project.run_parameters[run][val];\n              };\n\n              runIDsOrdered = Object(_vue_reactivity__WEBPACK_IMPORTED_MODULE_4__[\"computed\"])(function () {\n                return props.runKeys.sort(function (runA, runB) {\n                  if (sortByKey.value == \"ID\") {\n                    return sortOrder.value == \"ascending\" ? +runA - +runB : +runB - +runA;\n                  }\n\n                  var runs = sortOrder.value == \"ascending\" ? [runA, runB] : [runB, runA];\n                  return getParam(runs[0], sortByKey.value) - getParam(runs[1], sortByKey.value);\n                });\n              });\n              return _context.abrupt(\"return\", {\n                runIDsOrdered: runIDsOrdered,\n                sortOrder: sortOrder,\n                sortByKey: sortByKey,\n                allKeys: allKeys,\n                runColors: runColors,\n                orderOptions: orderOptions,\n                emitCardClick: emitCardClick,\n                emitBaseline: emitBaseline,\n                observer: observer,\n                runCards: runCards,\n                region: region,\n                yExtent: yExtent\n              });\n\n            case 19:\n            case \"end\":\n              return _context.stop();\n          }\n        }\n      }, _callee);\n    }))();\n  },\n  emits: [\"set-baseline\", \"card-click\"]\n}));\n\n//# sourceURL=webpack:///./src/components/RunSummaryList.vue?./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/ts-loader/index.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/views/CompareRuns.vue?vue&type=script&lang=ts":
/*!*********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/views/CompareRuns.vue?vue&type=script&lang=ts ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ \"./node_modules/core-js/modules/es.array.concat.js\");\n/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter.js */ \"./node_modules/core-js/modules/es.array.filter.js\");\n/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var core_js_modules_es_array_find_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.find-index.js */ \"./node_modules/core-js/modules/es.array.find-index.js\");\n/* harmony import */ var core_js_modules_es_array_find_index_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find_index_js__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ \"./node_modules/core-js/modules/es.array.map.js\");\n/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_objectSpread2__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/objectSpread2 */ \"./node_modules/@babel/runtime/helpers/esm/objectSpread2.js\");\n/* harmony import */ var _Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/toConsumableArray */ \"./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js\");\n/* harmony import */ var _vue_runtime_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @vue/runtime-core */ \"./node_modules/@vue/runtime-core/dist/runtime-core.esm-bundler.js\");\n/* harmony import */ var _components_PlotlyLineplot_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/components/PlotlyLineplot.vue */ \"./src/components/PlotlyLineplot.vue\");\n/* harmony import */ var _components_ParamSelector_vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/components/ParamSelector.vue */ \"./src/components/ParamSelector.vue\");\n/* harmony import */ var _components_RunSummaryList_vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/components/RunSummaryList.vue */ \"./src/components/RunSummaryList.vue\");\n/* harmony import */ var _api_API__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/api/API */ \"./src/api/API.ts\");\n/* harmony import */ var _exploreStore__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/exploreStore */ \"./src/exploreStore.ts\");\n/* harmony import */ var vue_router__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! vue-router */ \"./node_modules/vue-router/dist/vue-router.esm-bundler.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_6__[\"defineComponent\"])({\n  name: \"CompareRuns\",\n  components: {\n    PlotlyLineplot: _components_PlotlyLineplot_vue__WEBPACK_IMPORTED_MODULE_7__[\"default\"],\n    ParamSelector: _components_ParamSelector_vue__WEBPACK_IMPORTED_MODULE_8__[\"default\"],\n    RunSummaryList: _components_RunSummaryList_vue__WEBPACK_IMPORTED_MODULE_9__[\"default\"]\n  },\n  props: {\n    projectId: {\n      type: String,\n      required: true\n    }\n  },\n  setup: function setup(props, context) {\n    var allRunKeys = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_6__[\"ref\"])([]);\n    var yExtent = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_6__[\"ref\"])([]);\n    var project = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_6__[\"ref\"])({});\n    var router = Object(vue_router__WEBPACK_IMPORTED_MODULE_12__[\"useRouter\"])(); // Override projectId stored in state\n\n    _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state.projectId = props.projectId;\n\n    function initState() {\n      _api_API__WEBPACK_IMPORTED_MODULE_10__[\"getProject\"](props.projectId).then(function (r) {\n        project.value = r;\n        _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state.selectedRegion = project.value.available_regions[0];\n        allRunKeys.value = r.runKeys;\n      });\n      _api_API__WEBPACK_IMPORTED_MODULE_10__[\"getFieldExtent\"](props.projectId, [\"currently_infected\", \"currently_susceptible\", \"currently_recovered\"]).then(function (r) {\n        yExtent.value = r;\n      }); // Get all parameter options\n\n      _api_API__WEBPACK_IMPORTED_MODULE_10__[\"getParamSelection\"](props.projectId).then(function (params) {\n        _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].newParamOptions(params);\n        _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state.selectedParamIdxs = params.map(function (x) {\n          return 0;\n        });\n        var multipleOptions = params.map(function (x, i) {\n          return {\n            options: x.options,\n            i: i\n          };\n        }).filter(function (o) {\n          return o.options.length > 1;\n        });\n        var initFreeIdx = multipleOptions.length > 1 ? multipleOptions[0].i : null;\n        _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state.freeIdx = initFreeIdx;\n      }); // Get default parameter selection\n\n      _api_API__WEBPACK_IMPORTED_MODULE_10__[\"getRunParameters\"](props.projectId, \"1\").then(function (r) {\n        _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].updateSelectedIdxsFromParamObject(r);\n      }); // Get fields\n\n      _api_API__WEBPACK_IMPORTED_MODULE_10__[\"baseNumericFields\"](props.projectId).then(function (r) {\n        _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].newAvailableFields(r);\n      }); // Get numeric fields\n\n      _api_API__WEBPACK_IMPORTED_MODULE_10__[\"baseNumericFields\"](props.projectId).then(function (r) {\n        _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].newNumericFields(r);\n      });\n    }\n\n    Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_6__[\"onMounted\"])(function () {\n      initState();\n    });\n\n    function updateSelectedOptions(payload) {\n      _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].updateParamSelection(payload.rowIdx, payload.optionIdx);\n    }\n\n    function updateFreeIdx(payload) {\n      _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].toggleFreeIdx(payload.freeIdx);\n    }\n\n    function toggleBaseline(payload) {\n      payload.runId == _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state.baselineRunId ? _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].newBaselineRunId(\"\") : _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].newBaselineRunId(payload.runId);\n    }\n\n    function detailedRedirect(payload) {\n      var path = \"/\".concat(props.projectId, \"/runDetails/\").concat(payload.runId);\n      router.push({\n        path: path\n      });\n    }\n\n    var addBaselineRun = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_6__[\"computed\"])(function () {\n      return _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state.baselineRunId && _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state.selectedRunIds.findIndex(function (x) {\n        return x == _exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state.baselineRunId;\n      }) == -1;\n    });\n    var displayRuns = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_6__[\"computed\"])(function () {\n      return [].concat(Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(_exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state.selectedRunIds), Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_toConsumableArray__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(addBaselineRun.value ? [_exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state.baselineRunId] : []));\n    });\n    return Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_objectSpread2__WEBPACK_IMPORTED_MODULE_4__[\"default\"])({\n      project: project,\n      updateSelectedOptions: updateSelectedOptions,\n      updateFreeIdx: updateFreeIdx,\n      allRunKeys: allRunKeys,\n      yExtent: yExtent,\n      toggleBaseline: toggleBaseline,\n      detailedRedirect: detailedRedirect,\n      displayRuns: displayRuns\n    }, Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_6__[\"toRefs\"])(_exploreStore__WEBPACK_IMPORTED_MODULE_11__[\"default\"].state));\n  }\n}));\n\n//# sourceURL=webpack:///./src/views/CompareRuns.vue?./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/ts-loader/index.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/views/RunDetails.vue?vue&type=script&lang=ts":
/*!********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/views/RunDetails.vue?vue&type=script&lang=ts ***!
  \********************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ \"./node_modules/core-js/modules/es.array.concat.js\");\n/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.for-each.js */ \"./node_modules/core-js/modules/es.array.for-each.js\");\n/* harmony import */ var core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each_js__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ \"./node_modules/core-js/modules/es.function.name.js\");\n/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.keys.js */ \"./node_modules/core-js/modules/es.object.keys.js\");\n/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ \"./node_modules/core-js/modules/web.dom-collections.for-each.js\");\n/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _vue_runtime_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @vue/runtime-core */ \"./node_modules/@vue/runtime-core/dist/runtime-core.esm-bundler.js\");\n/* harmony import */ var _router_index__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../router/index */ \"./src/router/index.ts\");\n/* harmony import */ var _api_API__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/api/API */ \"./src/api/API.ts\");\n/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ramda */ \"./node_modules/ramda/es/index.js\");\n/* harmony import */ var _components_ChoroplethMap_vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/components/ChoroplethMap.vue */ \"./src/components/ChoroplethMap.vue\");\n/* harmony import */ var _utils_numerical__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/utils/numerical */ \"./src/utils/numerical.ts\");\n/* harmony import */ var _components_DetailedRunView_vue__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/components/DetailedRunView.vue */ \"./src/components/DetailedRunView.vue\");\n\n\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_5__[\"defineComponent\"])({\n  name: \"RunDetails\",\n  components: {\n    ChoroplethMap: _components_ChoroplethMap_vue__WEBPACK_IMPORTED_MODULE_9__[\"default\"],\n    DetailedRunView: _components_DetailedRunView_vue__WEBPACK_IMPORTED_MODULE_11__[\"default\"]\n  },\n  props: {\n    projectId: {\n      type: String,\n      required: true\n    },\n    run1Id: {\n      type: String,\n      default: \"1\"\n    },\n    run2Id: {\n      type: String,\n      required: false,\n      default: null\n    }\n  },\n  setup: function setup(props, ctx) {\n    var unifyYAxes = true;\n    var sameRun = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_5__[\"computed\"])(function () {\n      var r1 = props.run1Id,\n          r2 = props.run2Id;\n      return r2 == r1 || r2 == \"\" || r2 == null;\n    });\n    var run1div = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_5__[\"ref\"])(null);\n    var run2div = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_5__[\"ref\"])(null);\n    var ax1 = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_5__[\"computed\"])(function () {\n      var _run1div$value$axisRa, _run1div$value;\n\n      //@ts-ignore\n      return (_run1div$value$axisRa = (_run1div$value = run1div.value) === null || _run1div$value === void 0 ? void 0 : _run1div$value.axisRangeExtents()) !== null && _run1div$value$axisRa !== void 0 ? _run1div$value$axisRa : {};\n    });\n    var ax2 = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_5__[\"computed\"])(function () {\n      var _run2div$value$axisRa, _run2div$value;\n\n      //@ts-ignore\n      return (_run2div$value$axisRa = (_run2div$value = run2div.value) === null || _run2div$value === void 0 ? void 0 : _run2div$value.axisRangeExtents()) !== null && _run2div$value$axisRa !== void 0 ? _run2div$value$axisRa : {};\n    });\n    var axisRanges = Object(_vue_runtime_core__WEBPACK_IMPORTED_MODULE_5__[\"computed\"])(function () {\n      var out = {};\n\n      if (!ramda__WEBPACK_IMPORTED_MODULE_8__[\"isEmpty\"](ax1.value) && !ramda__WEBPACK_IMPORTED_MODULE_8__[\"isEmpty\"](ax2.value)) {\n        Object.keys(ax1.value).forEach(function (k) {\n          var newRange = ax1.value == undefined || ax2.value == undefined ? undefined : Object(_utils_numerical__WEBPACK_IMPORTED_MODULE_10__[\"encompass\"])(ax1.value[k], ax2.value[k]);\n\n          if (newRange != undefined) {\n            newRange[1] = 1.03 * newRange[1]; // Pad the maximum by a bit\n          }\n\n          out[k] = newRange;\n        });\n      }\n\n      return out;\n    });\n\n    function catchRunChange(e, side) {\n      var query = {};\n      e.fullParamData.forEach(function (a, i) {\n        var optionIdx = i == e.rowIdx ? e.optionIdx : e.prevSelectedOptionIdxs[i];\n        query[a.name] = [a.options[optionIdx]];\n      });\n      document.body.classList.add(\"working\");\n      _api_API__WEBPACK_IMPORTED_MODULE_7__[\"filterByParamSelection\"](props.projectId, query).then(function (r) {\n        // Handle invalid selection\n        if (r.length == 0) {\n          alert(\"No valid simulation run found for the requested parameter object: \".concat(JSON.stringify(query)));\n        } else {\n          var newRunId = r[0];\n          var newRoute;\n\n          if (side == \"left\") {\n            newRoute = \"/\".concat(props.projectId, \"/runDetails/\").concat(newRunId, \"/\").concat(props.run2Id || props.run1Id);\n          } else if (side == \"right\") {\n            newRoute = \"/\".concat(props.projectId, \"/runDetails/\").concat(props.run1Id, \"/\").concat(newRunId);\n          } else {\n            newRoute = \"/\".concat(props.projectId, \"/runDetails/\").concat(newRunId, \"/\").concat(newRunId);\n          }\n\n          _router_index__WEBPACK_IMPORTED_MODULE_6__[\"default\"].push(newRoute);\n        }\n\n        document.body.classList.remove(\"working\");\n      });\n    }\n\n    return {\n      catchRunChange: catchRunChange,\n      sameRun: sameRun,\n      run1div: run1div,\n      run2div: run2div,\n      axisRanges: axisRanges\n    };\n  }\n}));\n\n//# sourceURL=webpack:///./src/views/RunDetails.vue?./node_modules/cache-loader/dist/cjs.js??ref--13-0!./node_modules/babel-loader/lib!./node_modules/ts-loader??ref--13-2!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader-v16/dist/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/components/DetailedRunView.vue?vue&type=template&id=77169300&scoped=true":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/components/DetailedRunView.vue?vue&type=template&id=77169300&scoped=true ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return render; });\n/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.runtime.esm-bundler.js\");\n\n\nvar _withId = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withScopeId\"])(\"data-v-77169300\");\n\nObject(vue__WEBPACK_IMPORTED_MODULE_0__[\"pushScopeId\"])(\"data-v-77169300\");\n\nvar _hoisted_1 = {\n  class: \"main\"\n};\nvar _hoisted_2 = {\n  class: \"sticky overlay\"\n};\n\nvar _hoisted_3 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"hr\", null, null, -1\n/* HOISTED */\n);\n\nvar _hoisted_4 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"hr\", null, null, -1\n/* HOISTED */\n);\n\nvar _hoisted_5 = {\n  key: 0\n};\nvar _hoisted_6 = {\n  key: 1\n};\n\nvar _hoisted_7 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"h4\", null, \"No location info available\", -1\n/* HOISTED */\n);\n\nvar _hoisted_8 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"hr\", null, null, -1\n/* HOISTED */\n);\n\nvar _hoisted_9 = {\n  key: 2\n};\n\nvar _hoisted_10 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"label\", {\n  for: \"field-selection-ages\"\n}, \"Select field: \", -1\n/* HOISTED */\n);\n\nvar _hoisted_11 = {\n  key: 3\n};\n\nvar _hoisted_12 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"h4\", null, \"No age info available\", -1\n/* HOISTED */\n);\n\nvar _hoisted_13 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"hr\", null, null, -1\n/* HOISTED */\n);\n\nvar _hoisted_14 = {\n  key: 4\n};\n\nvar _hoisted_15 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"label\", {\n  for: \"field-selection\"\n}, \"Select field:\", -1\n/* HOISTED */\n);\n\nObject(vue__WEBPACK_IMPORTED_MODULE_0__[\"popScopeId\"])();\n\nvar render = /*#__PURE__*/_withId(function (_ctx, _cache, $props, $setup, $data, $options) {\n  var _component_param_selector = Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"resolveComponent\"])(\"param-selector\");\n\n  var _component_plotly_lineplot = Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"resolveComponent\"])(\"plotly-lineplot\");\n\n  var _component_geo_slider = Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"resolveComponent\"])(\"geo-slider\");\n\n  return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"div\", _hoisted_1, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_2, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"h2\", null, \"Run \" + Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"toDisplayString\"])(_ctx.hasRun ? _ctx.run.runId : \"...\"), 1\n  /* TEXT */\n  ), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_param_selector, {\n    paramData: _ctx.paramOptions,\n    selectedOptionIdxs: _ctx.selectedOptionIdxs,\n    allowRowSelection: false,\n    onSelectedOptionsChange: _ctx.changeRun\n  }, null, 8\n  /* PROPS */\n  , [\"paramData\", \"selectedOptionIdxs\", \"onSelectedOptionsChange\"]), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createCommentVNode\"])(\" <label for=\\\"region-selection\\\">Select region:</label>\\n      <div v-if=\\\"hasProject\\\">\\n        <select id=\\\"region-selection\\\" v-model=\\\"selectedRegion\\\">\\n          <option v-for=\\\"region in project.available_regions\\\" :value=\\\"region\\\">\\n            {{ region }}\\n          </option>\\n        </select>\\n      </div> \"), _hoisted_3]), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", {\n    class: {\n      opaque: _ctx.mutePlots\n    }\n  }, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_plotly_lineplot, {\n    plotData: _ctx.dataSIR,\n    legend: _ctx.legendSIR,\n    yRange: _ctx.axisRanges['SIR'],\n    ref: _ctx.plotlys['SIR'],\n    title: \"SIR Curve\"\n  }, null, 8\n  /* PROPS */\n  , [\"plotData\", \"legend\", \"yRange\"]), _hoisted_4, _ctx.hasLocInfo ? (Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"div\", _hoisted_5, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_plotly_lineplot, {\n    plotData: _ctx.dataLoc,\n    legend: _ctx.legendLoc,\n    yRange: _ctx.axisRanges['Loc'],\n    ref: _ctx.plotlys['Loc'],\n    title: \"Locations of Infection\"\n  }, null, 8\n  /* PROPS */\n  , [\"plotData\", \"legend\", \"yRange\"])])) : (Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"div\", _hoisted_6, [_hoisted_7])), _hoisted_8, _ctx.hasAgeInfo ? (Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"div\", _hoisted_9, [_hoisted_10, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withDirectives\"])(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"select\", {\n    id: \"field-selection-ages\",\n    \"onUpdate:modelValue\": _cache[1] || (_cache[1] = function ($event) {\n      return _ctx.selectedFieldAge = $event;\n    })\n  }, [(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"renderList\"])(_ctx.fieldsAge, function (field) {\n    return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"option\", {\n      value: field\n    }, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"toDisplayString\"])(field), 9\n    /* TEXT, PROPS */\n    , [\"value\"]);\n  }), 256\n  /* UNKEYED_FRAGMENT */\n  ))], 512\n  /* NEED_PATCH */\n  ), [[vue__WEBPACK_IMPORTED_MODULE_0__[\"vModelSelect\"], _ctx.selectedFieldAge]]), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_plotly_lineplot, {\n    plotData: _ctx.dataAge,\n    legend: _ctx.legendAge,\n    yRange: _ctx.axisRanges['Age'],\n    ref: _ctx.plotlys['Age'],\n    title: \"Ages Affected\",\n    yLabel: \"Pct of Population\"\n  }, null, 8\n  /* PROPS */\n  , [\"plotData\", \"legend\", \"yRange\"])])) : (Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"div\", _hoisted_11, [_hoisted_12])), _hoisted_13, _ctx.hasProject && _ctx.hasRun ? (Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"div\", _hoisted_14, [_hoisted_15, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withDirectives\"])(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"select\", {\n    id: \"field-selection\",\n    \"onUpdate:modelValue\": _cache[2] || (_cache[2] = function ($event) {\n      return _ctx.selectedFieldGeo = $event;\n    })\n  }, [(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"renderList\"])(_ctx.project.numeric_fields, function (field) {\n    return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"option\", {\n      value: field\n    }, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"toDisplayString\"])(field), 9\n    /* TEXT, PROPS */\n    , [\"value\"]);\n  }), 256\n  /* UNKEYED_FRAGMENT */\n  ))], 512\n  /* NEED_PATCH */\n  ), [[vue__WEBPACK_IMPORTED_MODULE_0__[\"vModelSelect\"], _ctx.selectedFieldGeo]]), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_geo_slider, {\n    projectId: _ctx.projectId,\n    runId: _ctx.runId,\n    selectedDimension: _ctx.selectedFieldGeo\n  }, null, 8\n  /* PROPS */\n  , [\"projectId\", \"runId\", \"selectedDimension\"])])) : Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createCommentVNode\"])(\"v-if\", true)], 2\n  /* CLASS */\n  )]);\n});\n\n//# sourceURL=webpack:///./src/components/DetailedRunView.vue?./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader-v16/dist/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/components/ParamSelector.vue?vue&type=template&id=3c76f18c&scoped=true":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/components/ParamSelector.vue?vue&type=template&id=3c76f18c&scoped=true ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return render; });\n/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.function.name.js */ \"./node_modules/core-js/modules/es.function.name.js\");\n/* harmony import */ var core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.runtime.esm-bundler.js\");\n\n\n\nvar _withId = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"withScopeId\"])(\"data-v-3c76f18c\");\n\nObject(vue__WEBPACK_IMPORTED_MODULE_1__[\"pushScopeId\"])(\"data-v-3c76f18c\");\n\nvar _hoisted_1 = {\n  class: \"param-selector\"\n};\n\nvar _hoisted_2 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createVNode\"])(\"thead\", null, [/*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createVNode\"])(\"tr\", null, [/*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createVNode\"])(\"th\", {\n  scope: \"col\",\n  align: \"left\"\n}, \"Parameter Name\"), /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createVNode\"])(\"th\", {\n  scope: \"col\",\n  align: \"left\"\n}, \"Options\")])], -1\n/* HOISTED */\n);\n\nvar _hoisted_3 = {\n  class: \"param-options\"\n};\n\nObject(vue__WEBPACK_IMPORTED_MODULE_1__[\"popScopeId\"])();\n\nvar render = /*#__PURE__*/_withId(function (_ctx, _cache, $props, $setup, $data, $options) {\n  return Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createBlock\"])(\"table\", _hoisted_1, [_hoisted_2, Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createVNode\"])(\"tbody\", null, [Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createCommentVNode\"])(\" <td colspan=\\\"3\\\"> <hr /> </td> \"), (Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_1__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"renderList\"])(_ctx.paramData, function (param, i) {\n    return Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createBlock\"])(\"tr\", {\n      class: [\"param-row\", {\n        clickable: _ctx.allowRowSelection,\n        selected: _ctx.selectedRowIdx == i\n      }],\n      onMouseout: function onMouseout() {\n        return _ctx.unHoverRow(i);\n      }\n    }, [Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createVNode\"])(\"td\", {\n      class: [\"param-name\", {\n        hovered: _ctx.allowRowSelection && _ctx.hoveredRowIdx == i\n      }],\n      onClick: function onClick() {\n        return _ctx.allowRowSelection && _ctx.emitFree(i);\n      },\n      onMouseover: function onMouseover() {\n        _ctx.allowRowSelection && _ctx.hoverRow(i);\n      }\n    }, Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"toDisplayString\"])(param.name), 43\n    /* TEXT, CLASS, PROPS, HYDRATE_EVENTS */\n    , [\"onClick\", \"onMouseover\"]), Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createVNode\"])(\"td\", _hoisted_3, [(Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_1__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"renderList\"])(param.options, function (option, j) {\n      return Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"createBlock\"])(\"div\", {\n        class: [\"param-cell inline\", {\n          selected: _ctx.selectedRowIdx != i && _ctx.selectedOptionIdxs[i] == j,\n          unselectable: _ctx.selectedRowIdx == i,\n          clickable: true\n        }],\n        onClick: function onClick() {\n          return _ctx.emitSelectedOptions(i, j);\n        }\n      }, Object(vue__WEBPACK_IMPORTED_MODULE_1__[\"toDisplayString\"])(_ctx.formatValDisplay(option)), 11\n      /* TEXT, CLASS, PROPS */\n      , [\"onClick\"]);\n    }), 256\n    /* UNKEYED_FRAGMENT */\n    ))])], 42\n    /* CLASS, PROPS, HYDRATE_EVENTS */\n    , [\"onMouseout\"]);\n  }), 256\n  /* UNKEYED_FRAGMENT */\n  ))])]);\n});\n\n//# sourceURL=webpack:///./src/components/ParamSelector.vue?./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader-v16/dist/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/components/PlotlyLineplot.vue?vue&type=template&id=5656a3d3&scoped=true":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/components/PlotlyLineplot.vue?vue&type=template&id=5656a3d3&scoped=true ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return render; });\n/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.runtime.esm-bundler.js\");\n\n\nvar _withId = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withScopeId\"])(\"data-v-5656a3d3\");\n\nObject(vue__WEBPACK_IMPORTED_MODULE_0__[\"pushScopeId\"])(\"data-v-5656a3d3\");\n\nvar _hoisted_1 = {\n  ref: \"plotDiv\"\n};\n\nObject(vue__WEBPACK_IMPORTED_MODULE_0__[\"popScopeId\"])();\n\nvar render = /*#__PURE__*/_withId(function (_ctx, _cache, $props, $setup, $data, $options) {\n  return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"div\", _hoisted_1, null, 512\n  /* NEED_PATCH */\n  );\n});\n\n//# sourceURL=webpack:///./src/components/PlotlyLineplot.vue?./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader-v16/dist/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/components/RunSummaryCard.vue?vue&type=template&id=3a433cfb&scoped=true":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/components/RunSummaryCard.vue?vue&type=template&id=3a433cfb&scoped=true ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return render; });\n/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.entries.js */ \"./node_modules/core-js/modules/es.object.entries.js\");\n/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/slicedToArray */ \"./node_modules/@babel/runtime/helpers/esm/slicedToArray.js\");\n/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.runtime.esm-bundler.js\");\n\n\n\n\nvar _withId = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"withScopeId\"])(\"data-v-3a433cfb\");\n\nObject(vue__WEBPACK_IMPORTED_MODULE_2__[\"pushScopeId\"])(\"data-v-3a433cfb\");\n\nvar _hoisted_1 = {\n  class: \"title\"\n};\nvar _hoisted_2 = {\n  key: 0,\n  class: \"run-info\"\n};\nvar _hoisted_3 = {\n  class: \"thumbnail-plot\"\n};\nvar _hoisted_4 = {\n  class: \"path-list\"\n};\nvar _hoisted_5 = {\n  class: \"hyperparameter-display\"\n};\nvar _hoisted_6 = {\n  class: \"param-row\"\n};\nvar _hoisted_7 = {\n  class: \"param-name\"\n};\nvar _hoisted_8 = {\n  class: \"param-val\"\n};\nvar _hoisted_9 = {\n  key: 1\n};\nvar _hoisted_10 = {\n  class: \"bottom-border\"\n};\n\nObject(vue__WEBPACK_IMPORTED_MODULE_2__[\"popScopeId\"])();\n\nvar render = /*#__PURE__*/_withId(function (_ctx, _cache, $props, $setup, $data, $options) {\n  return Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createBlock\"])(\"div\", {\n    class: [\"card\", {\n      basecard: _ctx.isBaseline\n    }],\n    \"run-id\": _ctx.runId,\n    style: \"color: \".concat(_ctx.shadowColor == null ? 'rgba(0, 0, 0, 0.3)' : _ctx.shadowColor),\n    ref: \"root\"\n  }, [Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createVNode\"])(\"div\", {\n    class: \"clickable\",\n    onClick: _cache[1] || (_cache[1] = function () {\n      return _ctx.emitClick && _ctx.emitClick.apply(_ctx, arguments);\n    })\n  }, [Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createVNode\"])(\"p\", _hoisted_1, \"Run \" + Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"toDisplayString\"])(_ctx.runId), 1\n  /* TEXT */\n  ), _ctx.isLoaded ? (Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createBlock\"])(\"div\", _hoisted_2, [Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createVNode\"])(\"div\", _hoisted_3, [(Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createBlock\"])(\"svg\", {\n    width: _ctx.svgWidth,\n    height: _ctx.svgHeight\n  }, [Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createVNode\"])(\"g\", _hoisted_4, [(Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_2__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"renderList\"])(_ctx.paths, function (path) {\n    return Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createBlock\"])(\"path\", {\n      d: path.path,\n      class: path.className,\n      style: path.style\n    }, null, 14\n    /* CLASS, STYLE, PROPS */\n    , [\"d\"]);\n  }), 256\n  /* UNKEYED_FRAGMENT */\n  ))])], 8\n  /* PROPS */\n  , [\"width\", \"height\"]))]), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createVNode\"])(\"div\", _hoisted_5, [(Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_2__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"renderList\"])(Object.entries(_ctx.run.run_parameters), function (_ref) {\n    var _ref2 = Object(_Users_benjamin_hoover_ibm_com_Projects_JUNE_vis_junevis_client_node_modules_babel_runtime_helpers_esm_slicedToArray__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(_ref, 2),\n        key = _ref2[0],\n        val = _ref2[1];\n\n    return Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createBlock\"])(\"div\", _hoisted_6, [Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createVNode\"])(\"p\", _hoisted_7, Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"toDisplayString\"])(key) + \":\", 1\n    /* TEXT */\n    ), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createVNode\"])(\"p\", _hoisted_8, Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"toDisplayString\"])(_ctx.formatValDisplay(val)), 1\n    /* TEXT */\n    )]);\n  }), 256\n  /* UNKEYED_FRAGMENT */\n  ))])])) : (Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createBlock\"])(\"div\", _hoisted_9, \"Loading Run...\"))]), Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createVNode\"])(\"div\", _hoisted_10, [Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"createVNode\"])(\"button\", {\n    class: \"btn\",\n    onClick: _cache[2] || (_cache[2] = function () {\n      return _ctx.emitBaseline && _ctx.emitBaseline.apply(_ctx, arguments);\n    })\n  }, Object(vue__WEBPACK_IMPORTED_MODULE_2__[\"toDisplayString\"])(_ctx.isBaseline ? \"Deselect\" : \"Use as Baseline\"), 1\n  /* TEXT */\n  )])], 14\n  /* CLASS, STYLE, PROPS */\n  , [\"run-id\"]);\n});\n\n//# sourceURL=webpack:///./src/components/RunSummaryCard.vue?./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader-v16/dist/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/components/RunSummaryList.vue?vue&type=template&id=ea1408ee&scoped=true":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/components/RunSummaryList.vue?vue&type=template&id=ea1408ee&scoped=true ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return render; });\n/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.runtime.esm-bundler.js\");\n\n\nvar _withId = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withScopeId\"])(\"data-v-ea1408ee\");\n\nObject(vue__WEBPACK_IMPORTED_MODULE_0__[\"pushScopeId\"])(\"data-v-ea1408ee\");\n\nvar _hoisted_1 = {\n  key: 0,\n  class: \"sorter\"\n};\n\nvar _hoisted_2 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"label\", {\n  for: \"param-dropdown\"\n}, \"Sort by:\", -1\n/* HOISTED */\n);\n\nvar _hoisted_3 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"label\", {\n  for: \"order-dropdown\"\n}, \"Order:\", -1\n/* HOISTED */\n);\n\nObject(vue__WEBPACK_IMPORTED_MODULE_0__[\"popScopeId\"])();\n\nvar render = /*#__PURE__*/_withId(function (_ctx, _cache, $props, $setup, $data, $options) {\n  var _component_run_summary_card = Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"resolveComponent\"])(\"run-summary-card\");\n\n  return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Fragment\"], null, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createCommentVNode\"])(\" <main :class=\\\"{progress: inProgress}\\\" class=\\\"details-wrapper\\\"> \"), _ctx.allowSorting ? (Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"div\", _hoisted_1, [_hoisted_2, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withDirectives\"])(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"select\", {\n    name: \"param-dropdown\",\n    id: \"param-dropdown\",\n    \"onUpdate:modelValue\": _cache[1] || (_cache[1] = function ($event) {\n      return _ctx.sortByKey = $event;\n    })\n  }, [(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"renderList\"])(_ctx.allKeys, function (k) {\n    return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"option\", {\n      value: k\n    }, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"toDisplayString\"])(k), 9\n    /* TEXT, PROPS */\n    , [\"value\"]);\n  }), 256\n  /* UNKEYED_FRAGMENT */\n  ))], 512\n  /* NEED_PATCH */\n  ), [[vue__WEBPACK_IMPORTED_MODULE_0__[\"vModelSelect\"], _ctx.sortByKey]]), _hoisted_3, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withDirectives\"])(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"select\", {\n    name: \"order-dropdown\",\n    id: \"order-dropdown\",\n    \"onUpdate:modelValue\": _cache[2] || (_cache[2] = function ($event) {\n      return _ctx.sortOrder = $event;\n    })\n  }, [(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"renderList\"])(_ctx.orderOptions, function (o) {\n    return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"option\", {\n      value: o\n    }, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"toDisplayString\"])(o), 9\n    /* TEXT, PROPS */\n    , [\"value\"]);\n  }), 256\n  /* UNKEYED_FRAGMENT */\n  ))], 512\n  /* NEED_PATCH */\n  ), [[vue__WEBPACK_IMPORTED_MODULE_0__[\"vModelSelect\"], _ctx.sortOrder]])])) : Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createCommentVNode\"])(\"v-if\", true), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"TransitionGroup\"], {\n    name: \"details-wrapper\",\n    class: \"details-wrapper\",\n    tag: \"div\"\n  }, {\n    default: _withId(function () {\n      return [(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"renderList\"])(_ctx.runIDsOrdered, function (runId) {\n        return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(_component_run_summary_card, {\n          key: runId,\n          runId: runId,\n          projectId: _ctx.projectId,\n          isBaseline: runId == _ctx.baselineRunId,\n          observer: _ctx.observer,\n          yExtent: _ctx.yExtent,\n          region: _ctx.region,\n          shadowColor: _ctx.runColors[runId] || null,\n          onSetBaseline: _ctx.emitBaseline,\n          onCardClick: _ctx.emitCardClick,\n          ref: function ref(el) {\n            if (el) _ctx.runCards[runId] = el;\n          }\n        }, null, 8\n        /* PROPS */\n        , [\"runId\", \"projectId\", \"isBaseline\", \"observer\", \"yExtent\", \"region\", \"shadowColor\", \"onSetBaseline\", \"onCardClick\"]);\n      }), 128\n      /* KEYED_FRAGMENT */\n      ))];\n    }),\n    _: 1\n    /* STABLE */\n\n  })], 64\n  /* STABLE_FRAGMENT */\n  );\n});\n\n//# sourceURL=webpack:///./src/components/RunSummaryList.vue?./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader-v16/dist/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/views/CompareRuns.vue?vue&type=template&id=ddbc91fa&scoped=true":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/views/CompareRuns.vue?vue&type=template&id=ddbc91fa&scoped=true ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return render; });\n/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.runtime.esm-bundler.js\");\n\n\nvar _withId = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withScopeId\"])(\"data-v-ddbc91fa\");\n\nObject(vue__WEBPACK_IMPORTED_MODULE_0__[\"pushScopeId\"])(\"data-v-ddbc91fa\");\n\nvar _hoisted_1 = {\n  class: \"container\"\n};\n\nvar _hoisted_2 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"h2\", {\n  class: \"title\"\n}, \"Explore Runs\", -1\n/* HOISTED */\n);\n\nvar _hoisted_3 = {\n  class: \"row\"\n};\nvar _hoisted_4 = {\n  class: \"col-4\"\n};\n\nvar _hoisted_5 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"h3\", {\n  class: \"muted\"\n}, \"Parameter Selection\", -1\n/* HOISTED */\n);\n\nvar _hoisted_6 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", {\n  class: \"muted\"\n}, [/*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"strong\", null, \"Click\"), /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createTextVNode\"])(\" a parameter name to compare all options for that parameter, or click a value to select a specific run matching that parameter set \")], -1\n/* HOISTED */\n);\n\nvar _hoisted_7 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"label\", {\n  for: \"field-selection\"\n}, \"Select field:\", -1\n/* HOISTED */\n);\n\nvar _hoisted_8 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"label\", {\n  for: \"region-selection\"\n}, \"Select region:\", -1\n/* HOISTED */\n);\n\nvar _hoisted_9 = {\n  class: \"col-8\"\n};\n\nvar _hoisted_10 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"h3\", {\n  class: \"muted\"\n}, \"Matched Runs\", -1\n/* HOISTED */\n);\n\nvar _hoisted_11 = {\n  class: \"pinned-runs\"\n};\n\nvar _hoisted_12 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", null, \"Loading runs...\", -1\n/* HOISTED */\n);\n\nvar _hoisted_13 = {\n  class: \"row\"\n};\n\nvar _hoisted_14 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"hr\", null, null, -1\n/* HOISTED */\n);\n\nvar _hoisted_15 = {\n  class: \"all-runs\"\n};\n\nvar _hoisted_16 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"p\", {\n  class: \"muted\"\n}, [/*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createTextVNode\"])(\" Below are all the simulations for this project. Shown on the thumbnail is the iconic SIR curve (Susceptible (S) = green, Infected (I) = red, Recovered (R) = blue). \"), /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"strong\", null, \"Click\"), /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createTextVNode\"])(\" on any card to view more details. \")], -1\n/* HOISTED */\n);\n\nvar _hoisted_17 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"h3\", {\n  class: \"muted\"\n}, \"Explore all runs\", -1\n/* HOISTED */\n);\n\nvar _hoisted_18 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", null, \"Loading runs...\", -1\n/* HOISTED */\n);\n\nObject(vue__WEBPACK_IMPORTED_MODULE_0__[\"popScopeId\"])();\n\nvar render = /*#__PURE__*/_withId(function (_ctx, _cache, $props, $setup, $data, $options) {\n  var _component_ParamSelector = Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"resolveComponent\"])(\"ParamSelector\");\n\n  var _component_run_summary_list = Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"resolveComponent\"])(\"run-summary-list\");\n\n  var _component_PlotlyLineplot = Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"resolveComponent\"])(\"PlotlyLineplot\");\n\n  return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"main\", null, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_1, [_hoisted_2, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_3, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_4, [_hoisted_5, _hoisted_6, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", null, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_ParamSelector, {\n    freeIdx: _ctx.freeIdx,\n    paramData: _ctx.paramOptions,\n    selectedOptionIdxs: _ctx.selectedParamIdxs,\n    onSelectedOptionsChange: _ctx.updateSelectedOptions,\n    onFreeIdxChange: _ctx.updateFreeIdx\n  }, null, 8\n  /* PROPS */\n  , [\"freeIdx\", \"paramData\", \"selectedOptionIdxs\", \"onSelectedOptionsChange\", \"onFreeIdxChange\"])]), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", null, [_hoisted_7, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withDirectives\"])(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"select\", {\n    id: \"field-selection\",\n    \"onUpdate:modelValue\": _cache[1] || (_cache[1] = function ($event) {\n      return _ctx.selectedField = $event;\n    })\n  }, [(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"renderList\"])(_ctx.numericFields, function (field) {\n    return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"option\", {\n      value: field\n    }, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"toDisplayString\"])(field), 9\n    /* TEXT, PROPS */\n    , [\"value\"]);\n  }), 256\n  /* UNKEYED_FRAGMENT */\n  ))], 512\n  /* NEED_PATCH */\n  ), [[vue__WEBPACK_IMPORTED_MODULE_0__[\"vModelSelect\"], _ctx.selectedField]])]), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", null, [_hoisted_8, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withDirectives\"])(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"select\", {\n    id: \"region-selection\",\n    \"onUpdate:modelValue\": _cache[2] || (_cache[2] = function ($event) {\n      return _ctx.selectedRegion = $event;\n    })\n  }, [(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(true), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Fragment\"], null, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"renderList\"])(_ctx.project.available_regions, function (region) {\n    return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"option\", {\n      value: region\n    }, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"toDisplayString\"])(region), 9\n    /* TEXT, PROPS */\n    , [\"value\"]);\n  }), 256\n  /* UNKEYED_FRAGMENT */\n  ))], 512\n  /* NEED_PATCH */\n  ), [[vue__WEBPACK_IMPORTED_MODULE_0__[\"vModelSelect\"], _ctx.selectedRegion]])])]), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_9, [_hoisted_10, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_11, [(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Suspense\"], null, {\n    default: _withId(function () {\n      return [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_run_summary_list, {\n        projectId: _ctx.projectId,\n        runKeys: _ctx.displayRuns,\n        selectedRuns: _ctx.selectedRunIds,\n        allowSorting: false,\n        baselineRunId: _ctx.baselineRunId,\n        onSetBaseline: _ctx.toggleBaseline,\n        onCardClick: _ctx.detailedRedirect\n      }, null, 8\n      /* PROPS */\n      , [\"projectId\", \"runKeys\", \"selectedRuns\", \"baselineRunId\", \"onSetBaseline\", \"onCardClick\"])];\n    }),\n    fallback: _withId(function () {\n      return [_hoisted_12];\n    }),\n    _: 1\n    /* STABLE */\n\n  }))])])]), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_13, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_PlotlyLineplot, {\n    plotData: _ctx.overviewTraces,\n    legend: _ctx.legend\n  }, null, 8\n  /* PROPS */\n  , [\"plotData\", \"legend\"])])]), _hoisted_14, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", null, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_15, [_hoisted_16, _hoisted_17, (Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Suspense\"], null, {\n    default: _withId(function () {\n      return [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_run_summary_list, {\n        projectId: _ctx.projectId,\n        runKeys: _ctx.allRunKeys,\n        selectedRuns: _ctx.selectedRunIds,\n        allowSorting: true,\n        baselineRunId: _ctx.baselineRunId,\n        onSetBaseline: _ctx.toggleBaseline,\n        onCardClick: _ctx.detailedRedirect\n      }, null, 8\n      /* PROPS */\n      , [\"projectId\", \"runKeys\", \"selectedRuns\", \"baselineRunId\", \"onSetBaseline\", \"onCardClick\"])];\n    }),\n    fallback: _withId(function () {\n      return [_hoisted_18];\n    }),\n    _: 1\n    /* STABLE */\n\n  }))])])]);\n});\n\n//# sourceURL=webpack:///./src/views/CompareRuns.vue?./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cache-loader/dist/cjs.js?!./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader-v16/dist/templateLoader.js?!./node_modules/cache-loader/dist/cjs.js?!./node_modules/vue-loader-v16/dist/index.js?!./src/views/RunDetails.vue?vue&type=template&id=11b7ab71&scoped=true":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1!./src/views/RunDetails.vue?vue&type=template&id=11b7ab71&scoped=true ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return render; });\n/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.runtime.esm-bundler.js\");\n\n\nvar _withId = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"withScopeId\"])(\"data-v-11b7ab71\");\n\nObject(vue__WEBPACK_IMPORTED_MODULE_0__[\"pushScopeId\"])(\"data-v-11b7ab71\");\n\nvar _hoisted_1 = {\n  class: \"main container\"\n};\n\nvar _hoisted_2 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"h2\", {\n  class: \"title\"\n}, \"Compare Runs\", -1\n/* HOISTED */\n);\n\nvar _hoisted_3 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", {\n  class: \"row intro\"\n}, [/*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", {\n  class: \"col-12 muted\"\n}, [/*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createTextVNode\"])(\" Here, you can select your variables of interest and view results from any 2 runs at a given time. (Note that one set of plots will be \"), /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"span\", {\n  class: \"muted-3\"\n}, \"faded out\"), /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createTextVNode\"])(\" if the 2 runs are identical.) \")])], -1\n/* HOISTED */\n);\n\nvar _hoisted_4 = {\n  class: \"row\"\n};\nvar _hoisted_5 = {\n  class: \"col-6\"\n};\n\nvar _hoisted_6 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"h1\", null, \"Loading...\", -1\n/* HOISTED */\n);\n\nvar _hoisted_7 = {\n  class: \"col-6\"\n};\n\nvar _hoisted_8 = /*#__PURE__*/Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"h1\", null, \"Loading...\", -1\n/* HOISTED */\n);\n\nObject(vue__WEBPACK_IMPORTED_MODULE_0__[\"popScopeId\"])();\n\nvar render = /*#__PURE__*/_withId(function (_ctx, _cache, $props, $setup, $data, $options) {\n  var _component_detailed_run_view = Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"resolveComponent\"])(\"detailed-run-view\");\n\n  return Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(\"div\", _hoisted_1, [_hoisted_2, _hoisted_3, Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_4, [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_5, [(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Suspense\"], null, {\n    default: _withId(function () {\n      return [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_detailed_run_view, {\n        ref: \"run1div\",\n        projectId: _ctx.projectId,\n        runId: _ctx.run1Id,\n        axisRanges: _ctx.axisRanges,\n        onSelectedOptionsChange: _cache[1] || (_cache[1] = function (e) {\n          return _ctx.catchRunChange(e, 'left');\n        })\n      }, null, 8\n      /* PROPS */\n      , [\"projectId\", \"runId\", \"axisRanges\"])];\n    }),\n    fallback: _withId(function () {\n      return [_hoisted_6];\n    }),\n    _: 1\n    /* STABLE */\n\n  }))]), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(\"div\", _hoisted_7, [(Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"openBlock\"])(), Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createBlock\"])(vue__WEBPACK_IMPORTED_MODULE_0__[\"Suspense\"], null, {\n    default: _withId(function () {\n      return [Object(vue__WEBPACK_IMPORTED_MODULE_0__[\"createVNode\"])(_component_detailed_run_view, {\n        ref: \"run2div\",\n        projectId: _ctx.projectId,\n        runId: _ctx.run2Id ? _ctx.run2Id : _ctx.run1Id,\n        axisRanges: _ctx.axisRanges,\n        mutePlots: _ctx.sameRun,\n        onSelectedOptionsChange: _cache[2] || (_cache[2] = function (e) {\n          return _ctx.catchRunChange(e, 'right');\n        })\n      }, null, 8\n      /* PROPS */\n      , [\"projectId\", \"runId\", \"axisRanges\", \"mutePlots\"])];\n    }),\n    fallback: _withId(function () {\n      return [_hoisted_8];\n    }),\n    _: 1\n    /* STABLE */\n\n  }))])])]);\n});\n\n//# sourceURL=webpack:///./src/views/RunDetails.vue?./node_modules/cache-loader/dist/cjs.js??ref--12-0!./node_modules/babel-loader/lib!./node_modules/vue-loader-v16/dist/templateLoader.js??ref--6!./node_modules/cache-loader/dist/cjs.js??ref--0-0!./node_modules/vue-loader-v16/dist??ref--0-1");

/***/ }),

/***/ "./node_modules/cdt2d/cdt2d.js":
/*!*************************************!*\
  !*** ./node_modules/cdt2d/cdt2d.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar monotoneTriangulate = __webpack_require__(/*! ./lib/monotone */ \"./node_modules/cdt2d/lib/monotone.js\")\nvar makeIndex = __webpack_require__(/*! ./lib/triangulation */ \"./node_modules/cdt2d/lib/triangulation.js\")\nvar delaunayFlip = __webpack_require__(/*! ./lib/delaunay */ \"./node_modules/cdt2d/lib/delaunay.js\")\nvar filterTriangulation = __webpack_require__(/*! ./lib/filter */ \"./node_modules/cdt2d/lib/filter.js\")\n\nmodule.exports = cdt2d\n\nfunction canonicalizeEdge(e) {\n  return [Math.min(e[0], e[1]), Math.max(e[0], e[1])]\n}\n\nfunction compareEdge(a, b) {\n  return a[0]-b[0] || a[1]-b[1]\n}\n\nfunction canonicalizeEdges(edges) {\n  return edges.map(canonicalizeEdge).sort(compareEdge)\n}\n\nfunction getDefault(options, property, dflt) {\n  if(property in options) {\n    return options[property]\n  }\n  return dflt\n}\n\nfunction cdt2d(points, edges, options) {\n\n  if(!Array.isArray(edges)) {\n    options = edges || {}\n    edges = []\n  } else {\n    options = options || {}\n    edges = edges || []\n  }\n\n  //Parse out options\n  var delaunay = !!getDefault(options, 'delaunay', true)\n  var interior = !!getDefault(options, 'interior', true)\n  var exterior = !!getDefault(options, 'exterior', true)\n  var infinity = !!getDefault(options, 'infinity', false)\n\n  //Handle trivial case\n  if((!interior && !exterior) || points.length === 0) {\n    return []\n  }\n\n  //Construct initial triangulation\n  var cells = monotoneTriangulate(points, edges)\n\n  //If delaunay refinement needed, then improve quality by edge flipping\n  if(delaunay || interior !== exterior || infinity) {\n\n    //Index all of the cells to support fast neighborhood queries\n    var triangulation = makeIndex(points.length, canonicalizeEdges(edges))\n    for(var i=0; i<cells.length; ++i) {\n      var f = cells[i]\n      triangulation.addTriangle(f[0], f[1], f[2])\n    }\n\n    //Run edge flipping\n    if(delaunay) {\n      delaunayFlip(points, triangulation)\n    }\n\n    //Filter points\n    if(!exterior) {\n      return filterTriangulation(triangulation, -1)\n    } else if(!interior) {\n      return filterTriangulation(triangulation,  1, infinity)\n    } else if(infinity) {\n      return filterTriangulation(triangulation, 0, infinity)\n    } else {\n      return triangulation.cells()\n    }\n    \n  } else {\n    return cells\n  }\n}\n\n\n//# sourceURL=webpack:///./node_modules/cdt2d/cdt2d.js?");

/***/ }),

/***/ "./node_modules/cdt2d/lib/delaunay.js":
/*!********************************************!*\
  !*** ./node_modules/cdt2d/lib/delaunay.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar inCircle = __webpack_require__(/*! robust-in-sphere */ \"./node_modules/robust-in-sphere/in-sphere.js\")[4]\nvar bsearch = __webpack_require__(/*! binary-search-bounds */ \"./node_modules/binary-search-bounds/search-bounds.js\")\n\nmodule.exports = delaunayRefine\n\nfunction testFlip(points, triangulation, stack, a, b, x) {\n  var y = triangulation.opposite(a, b)\n\n  //Test boundary edge\n  if(y < 0) {\n    return\n  }\n\n  //Swap edge if order flipped\n  if(b < a) {\n    var tmp = a\n    a = b\n    b = tmp\n    tmp = x\n    x = y\n    y = tmp\n  }\n\n  //Test if edge is constrained\n  if(triangulation.isConstraint(a, b)) {\n    return\n  }\n\n  //Test if edge is delaunay\n  if(inCircle(points[a], points[b], points[x], points[y]) < 0) {\n    stack.push(a, b)\n  }\n}\n\n//Assume edges are sorted lexicographically\nfunction delaunayRefine(points, triangulation) {\n  var stack = []\n\n  var numPoints = points.length\n  var stars = triangulation.stars\n  for(var a=0; a<numPoints; ++a) {\n    var star = stars[a]\n    for(var j=1; j<star.length; j+=2) {\n      var b = star[j]\n\n      //If order is not consistent, then skip edge\n      if(b < a) {\n        continue\n      }\n\n      //Check if edge is constrained\n      if(triangulation.isConstraint(a, b)) {\n        continue\n      }\n\n      //Find opposite edge\n      var x = star[j-1], y = -1\n      for(var k=1; k<star.length; k+=2) {\n        if(star[k-1] === b) {\n          y = star[k]\n          break\n        }\n      }\n\n      //If this is a boundary edge, don't flip it\n      if(y < 0) {\n        continue\n      }\n\n      //If edge is in circle, flip it\n      if(inCircle(points[a], points[b], points[x], points[y]) < 0) {\n        stack.push(a, b)\n      }\n    }\n  }\n\n  while(stack.length > 0) {\n    var b = stack.pop()\n    var a = stack.pop()\n\n    //Find opposite pairs\n    var x = -1, y = -1\n    var star = stars[a]\n    for(var i=1; i<star.length; i+=2) {\n      var s = star[i-1]\n      var t = star[i]\n      if(s === b) {\n        y = t\n      } else if(t === b) {\n        x = s\n      }\n    }\n\n    //If x/y are both valid then skip edge\n    if(x < 0 || y < 0) {\n      continue\n    }\n\n    //If edge is now delaunay, then don't flip it\n    if(inCircle(points[a], points[b], points[x], points[y]) >= 0) {\n      continue\n    }\n\n    //Flip the edge\n    triangulation.flip(a, b)\n\n    //Test flipping neighboring edges\n    testFlip(points, triangulation, stack, x, a, y)\n    testFlip(points, triangulation, stack, a, y, x)\n    testFlip(points, triangulation, stack, y, b, x)\n    testFlip(points, triangulation, stack, b, x, y)\n  }\n}\n\n\n//# sourceURL=webpack:///./node_modules/cdt2d/lib/delaunay.js?");

/***/ }),

/***/ "./node_modules/cdt2d/lib/filter.js":
/*!******************************************!*\
  !*** ./node_modules/cdt2d/lib/filter.js ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar bsearch = __webpack_require__(/*! binary-search-bounds */ \"./node_modules/binary-search-bounds/search-bounds.js\")\n\nmodule.exports = classifyFaces\n\nfunction FaceIndex(cells, neighbor, constraint, flags, active, next, boundary) {\n  this.cells       = cells\n  this.neighbor    = neighbor\n  this.flags       = flags\n  this.constraint  = constraint\n  this.active      = active\n  this.next        = next\n  this.boundary    = boundary\n}\n\nvar proto = FaceIndex.prototype\n\nfunction compareCell(a, b) {\n  return a[0] - b[0] ||\n         a[1] - b[1] ||\n         a[2] - b[2]\n}\n\nproto.locate = (function() {\n  var key = [0,0,0]\n  return function(a, b, c) {\n    var x = a, y = b, z = c\n    if(b < c) {\n      if(b < a) {\n        x = b\n        y = c\n        z = a\n      }\n    } else if(c < a) {\n      x = c\n      y = a\n      z = b\n    }\n    if(x < 0) {\n      return -1\n    }\n    key[0] = x\n    key[1] = y\n    key[2] = z\n    return bsearch.eq(this.cells, key, compareCell)\n  }\n})()\n\nfunction indexCells(triangulation, infinity) {\n  //First get cells and canonicalize\n  var cells = triangulation.cells()\n  var nc = cells.length\n  for(var i=0; i<nc; ++i) {\n    var c = cells[i]\n    var x = c[0], y = c[1], z = c[2]\n    if(y < z) {\n      if(y < x) {\n        c[0] = y\n        c[1] = z\n        c[2] = x\n      }\n    } else if(z < x) {\n      c[0] = z\n      c[1] = x\n      c[2] = y\n    }\n  }\n  cells.sort(compareCell)\n\n  //Initialize flag array\n  var flags = new Array(nc)\n  for(var i=0; i<flags.length; ++i) {\n    flags[i] = 0\n  }\n\n  //Build neighbor index, initialize queues\n  var active = []\n  var next   = []\n  var neighbor = new Array(3*nc)\n  var constraint = new Array(3*nc)\n  var boundary = null\n  if(infinity) {\n    boundary = []\n  }\n  var index = new FaceIndex(\n    cells,\n    neighbor,\n    constraint,\n    flags,\n    active,\n    next,\n    boundary)\n  for(var i=0; i<nc; ++i) {\n    var c = cells[i]\n    for(var j=0; j<3; ++j) {\n      var x = c[j], y = c[(j+1)%3]\n      var a = neighbor[3*i+j] = index.locate(y, x, triangulation.opposite(y, x))\n      var b = constraint[3*i+j] = triangulation.isConstraint(x, y)\n      if(a < 0) {\n        if(b) {\n          next.push(i)\n        } else {\n          active.push(i)\n          flags[i] = 1\n        }\n        if(infinity) {\n          boundary.push([y, x, -1])\n        }\n      }\n    }\n  }\n  return index\n}\n\nfunction filterCells(cells, flags, target) {\n  var ptr = 0\n  for(var i=0; i<cells.length; ++i) {\n    if(flags[i] === target) {\n      cells[ptr++] = cells[i]\n    }\n  }\n  cells.length = ptr\n  return cells\n}\n\nfunction classifyFaces(triangulation, target, infinity) {\n  var index = indexCells(triangulation, infinity)\n\n  if(target === 0) {\n    if(infinity) {\n      return index.cells.concat(index.boundary)\n    } else {\n      return index.cells\n    }\n  }\n\n  var side = 1\n  var active = index.active\n  var next = index.next\n  var flags = index.flags\n  var cells = index.cells\n  var constraint = index.constraint\n  var neighbor = index.neighbor\n\n  while(active.length > 0 || next.length > 0) {\n    while(active.length > 0) {\n      var t = active.pop()\n      if(flags[t] === -side) {\n        continue\n      }\n      flags[t] = side\n      var c = cells[t]\n      for(var j=0; j<3; ++j) {\n        var f = neighbor[3*t+j]\n        if(f >= 0 && flags[f] === 0) {\n          if(constraint[3*t+j]) {\n            next.push(f)\n          } else {\n            active.push(f)\n            flags[f] = side\n          }\n        }\n      }\n    }\n\n    //Swap arrays and loop\n    var tmp = next\n    next = active\n    active = tmp\n    next.length = 0\n    side = -side\n  }\n\n  var result = filterCells(cells, flags, target)\n  if(infinity) {\n    return result.concat(index.boundary)\n  }\n  return result\n}\n\n\n//# sourceURL=webpack:///./node_modules/cdt2d/lib/filter.js?");

/***/ }),

/***/ "./node_modules/cdt2d/lib/monotone.js":
/*!********************************************!*\
  !*** ./node_modules/cdt2d/lib/monotone.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar bsearch = __webpack_require__(/*! binary-search-bounds */ \"./node_modules/binary-search-bounds/search-bounds.js\")\nvar orient = __webpack_require__(/*! robust-orientation */ \"./node_modules/robust-orientation/orientation.js\")[3]\n\nvar EVENT_POINT = 0\nvar EVENT_END   = 1\nvar EVENT_START = 2\n\nmodule.exports = monotoneTriangulate\n\n//A partial convex hull fragment, made of two unimonotone polygons\nfunction PartialHull(a, b, idx, lowerIds, upperIds) {\n  this.a = a\n  this.b = b\n  this.idx = idx\n  this.lowerIds = lowerIds\n  this.upperIds = upperIds\n}\n\n//An event in the sweep line procedure\nfunction Event(a, b, type, idx) {\n  this.a    = a\n  this.b    = b\n  this.type = type\n  this.idx  = idx\n}\n\n//This is used to compare events for the sweep line procedure\n// Points are:\n//  1. sorted lexicographically\n//  2. sorted by type  (point < end < start)\n//  3. segments sorted by winding order\n//  4. sorted by index\nfunction compareEvent(a, b) {\n  var d =\n    (a.a[0] - b.a[0]) ||\n    (a.a[1] - b.a[1]) ||\n    (a.type - b.type)\n  if(d) { return d }\n  if(a.type !== EVENT_POINT) {\n    d = orient(a.a, a.b, b.b)\n    if(d) { return d }\n  }\n  return a.idx - b.idx\n}\n\nfunction testPoint(hull, p) {\n  return orient(hull.a, hull.b, p)\n}\n\nfunction addPoint(cells, hulls, points, p, idx) {\n  var lo = bsearch.lt(hulls, p, testPoint)\n  var hi = bsearch.gt(hulls, p, testPoint)\n  for(var i=lo; i<hi; ++i) {\n    var hull = hulls[i]\n\n    //Insert p into lower hull\n    var lowerIds = hull.lowerIds\n    var m = lowerIds.length\n    while(m > 1 && orient(\n        points[lowerIds[m-2]],\n        points[lowerIds[m-1]],\n        p) > 0) {\n      cells.push(\n        [lowerIds[m-1],\n         lowerIds[m-2],\n         idx])\n      m -= 1\n    }\n    lowerIds.length = m\n    lowerIds.push(idx)\n\n    //Insert p into upper hull\n    var upperIds = hull.upperIds\n    var m = upperIds.length\n    while(m > 1 && orient(\n        points[upperIds[m-2]],\n        points[upperIds[m-1]],\n        p) < 0) {\n      cells.push(\n        [upperIds[m-2],\n         upperIds[m-1],\n         idx])\n      m -= 1\n    }\n    upperIds.length = m\n    upperIds.push(idx)\n  }\n}\n\nfunction findSplit(hull, edge) {\n  var d\n  if(hull.a[0] < edge.a[0]) {\n    d = orient(hull.a, hull.b, edge.a)\n  } else {\n    d = orient(edge.b, edge.a, hull.a)\n  }\n  if(d) { return d }\n  if(edge.b[0] < hull.b[0]) {\n    d = orient(hull.a, hull.b, edge.b)\n  } else {\n    d = orient(edge.b, edge.a, hull.b)\n  }\n  return d || hull.idx - edge.idx\n}\n\nfunction splitHulls(hulls, points, event) {\n  var splitIdx = bsearch.le(hulls, event, findSplit)\n  var hull = hulls[splitIdx]\n  var upperIds = hull.upperIds\n  var x = upperIds[upperIds.length-1]\n  hull.upperIds = [x]\n  hulls.splice(splitIdx+1, 0,\n    new PartialHull(event.a, event.b, event.idx, [x], upperIds))\n}\n\n\nfunction mergeHulls(hulls, points, event) {\n  //Swap pointers for merge search\n  var tmp = event.a\n  event.a = event.b\n  event.b = tmp\n  var mergeIdx = bsearch.eq(hulls, event, findSplit)\n  var upper = hulls[mergeIdx]\n  var lower = hulls[mergeIdx-1]\n  lower.upperIds = upper.upperIds\n  hulls.splice(mergeIdx, 1)\n}\n\n\nfunction monotoneTriangulate(points, edges) {\n\n  var numPoints = points.length\n  var numEdges = edges.length\n\n  var events = []\n\n  //Create point events\n  for(var i=0; i<numPoints; ++i) {\n    events.push(new Event(\n      points[i],\n      null,\n      EVENT_POINT,\n      i))\n  }\n\n  //Create edge events\n  for(var i=0; i<numEdges; ++i) {\n    var e = edges[i]\n    var a = points[e[0]]\n    var b = points[e[1]]\n    if(a[0] < b[0]) {\n      events.push(\n        new Event(a, b, EVENT_START, i),\n        new Event(b, a, EVENT_END, i))\n    } else if(a[0] > b[0]) {\n      events.push(\n        new Event(b, a, EVENT_START, i),\n        new Event(a, b, EVENT_END, i))\n    }\n  }\n\n  //Sort events\n  events.sort(compareEvent)\n\n  //Initialize hull\n  var minX = events[0].a[0] - (1 + Math.abs(events[0].a[0])) * Math.pow(2, -52)\n  var hull = [ new PartialHull([minX, 1], [minX, 0], -1, [], [], [], []) ]\n\n  //Process events in order\n  var cells = []\n  for(var i=0, numEvents=events.length; i<numEvents; ++i) {\n    var event = events[i]\n    var type = event.type\n    if(type === EVENT_POINT) {\n      addPoint(cells, hull, points, event.a, event.idx)\n    } else if(type === EVENT_START) {\n      splitHulls(hull, points, event)\n    } else {\n      mergeHulls(hull, points, event)\n    }\n  }\n\n  //Return triangulation\n  return cells\n}\n\n\n//# sourceURL=webpack:///./node_modules/cdt2d/lib/monotone.js?");

/***/ }),

/***/ "./node_modules/cdt2d/lib/triangulation.js":
/*!*************************************************!*\
  !*** ./node_modules/cdt2d/lib/triangulation.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar bsearch = __webpack_require__(/*! binary-search-bounds */ \"./node_modules/binary-search-bounds/search-bounds.js\")\n\nmodule.exports = createTriangulation\n\nfunction Triangulation(stars, edges) {\n  this.stars = stars\n  this.edges = edges\n}\n\nvar proto = Triangulation.prototype\n\nfunction removePair(list, j, k) {\n  for(var i=1, n=list.length; i<n; i+=2) {\n    if(list[i-1] === j && list[i] === k) {\n      list[i-1] = list[n-2]\n      list[i] = list[n-1]\n      list.length = n - 2\n      return\n    }\n  }\n}\n\nproto.isConstraint = (function() {\n  var e = [0,0]\n  function compareLex(a, b) {\n    return a[0] - b[0] || a[1] - b[1]\n  }\n  return function(i, j) {\n    e[0] = Math.min(i,j)\n    e[1] = Math.max(i,j)\n    return bsearch.eq(this.edges, e, compareLex) >= 0\n  }\n})()\n\nproto.removeTriangle = function(i, j, k) {\n  var stars = this.stars\n  removePair(stars[i], j, k)\n  removePair(stars[j], k, i)\n  removePair(stars[k], i, j)\n}\n\nproto.addTriangle = function(i, j, k) {\n  var stars = this.stars\n  stars[i].push(j, k)\n  stars[j].push(k, i)\n  stars[k].push(i, j)\n}\n\nproto.opposite = function(j, i) {\n  var list = this.stars[i]\n  for(var k=1, n=list.length; k<n; k+=2) {\n    if(list[k] === j) {\n      return list[k-1]\n    }\n  }\n  return -1\n}\n\nproto.flip = function(i, j) {\n  var a = this.opposite(i, j)\n  var b = this.opposite(j, i)\n  this.removeTriangle(i, j, a)\n  this.removeTriangle(j, i, b)\n  this.addTriangle(i, b, a)\n  this.addTriangle(j, a, b)\n}\n\nproto.edges = function() {\n  var stars = this.stars\n  var result = []\n  for(var i=0, n=stars.length; i<n; ++i) {\n    var list = stars[i]\n    for(var j=0, m=list.length; j<m; j+=2) {\n      result.push([list[j], list[j+1]])\n    }\n  }\n  return result\n}\n\nproto.cells = function() {\n  var stars = this.stars\n  var result = []\n  for(var i=0, n=stars.length; i<n; ++i) {\n    var list = stars[i]\n    for(var j=0, m=list.length; j<m; j+=2) {\n      var s = list[j]\n      var t = list[j+1]\n      if(i < Math.min(s, t)) {\n        result.push([i, s, t])\n      }\n    }\n  }\n  return result\n}\n\nfunction createTriangulation(numVerts, edges) {\n  var stars = new Array(numVerts)\n  for(var i=0; i<numVerts; ++i) {\n    stars[i] = []\n  }\n  return new Triangulation(stars, edges)\n}\n\n\n//# sourceURL=webpack:///./node_modules/cdt2d/lib/triangulation.js?");

/***/ }),

/***/ "./node_modules/cell-orientation/orientation.js":
/*!******************************************************!*\
  !*** ./node_modules/cell-orientation/orientation.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = orientation\n\nfunction orientation(s) {\n  var p = 1\n  for(var i=1; i<s.length; ++i) {\n    for(var j=0; j<i; ++j) {\n      if(s[i] < s[j]) {\n        p = -p\n      } else if(s[j] === s[i]) {\n        return 0\n      }\n    }\n  }\n  return p\n}\n\n\n//# sourceURL=webpack:///./node_modules/cell-orientation/orientation.js?");

/***/ }),

/***/ "./node_modules/circumcenter/circumcenter.js":
/*!***************************************************!*\
  !*** ./node_modules/circumcenter/circumcenter.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nvar dup = __webpack_require__(/*! dup */ \"./node_modules/dup/dup.js\")\nvar solve = __webpack_require__(/*! robust-linear-solve */ \"./node_modules/robust-linear-solve/linsolve.js\")\n\nfunction dot(a, b) {\n  var s = 0.0\n  var d = a.length\n  for(var i=0; i<d; ++i) {\n    s += a[i] * b[i]\n  }\n  return s\n}\n\nfunction barycentricCircumcenter(points) {\n  var N = points.length\n  if(N === 0) {\n    return []\n  }\n  \n  var D = points[0].length\n  var A = dup([points.length+1, points.length+1], 1.0)\n  var b = dup([points.length+1], 1.0)\n  A[N][N] = 0.0\n  for(var i=0; i<N; ++i) {\n    for(var j=0; j<=i; ++j) {\n      A[j][i] = A[i][j] = 2.0 * dot(points[i], points[j])\n    }\n    b[i] = dot(points[i], points[i])\n  }\n  var x = solve(A, b)\n\n  var denom = 0.0\n  var h = x[N+1]\n  for(var i=0; i<h.length; ++i) {\n    denom += h[i]\n  }\n\n  var y = new Array(N)\n  for(var i=0; i<N; ++i) {\n    var h = x[i]\n    var numer = 0.0\n    for(var j=0; j<h.length; ++j) {\n      numer += h[j]\n    }\n    y[i] =  numer / denom\n  }\n\n  return y\n}\n\nfunction circumcenter(points) {\n  if(points.length === 0) {\n    return []\n  }\n  var D = points[0].length\n  var result = dup([D])\n  var weights = barycentricCircumcenter(points)\n  for(var i=0; i<points.length; ++i) {\n    for(var j=0; j<D; ++j) {\n      result[j] += points[i][j] * weights[i]\n    }\n  }\n  return result\n}\n\ncircumcenter.barycenetric = barycentricCircumcenter\nmodule.exports = circumcenter\n\n//# sourceURL=webpack:///./node_modules/circumcenter/circumcenter.js?");

/***/ }),

/***/ "./node_modules/circumradius/crad.js":
/*!*******************************************!*\
  !*** ./node_modules/circumradius/crad.js ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("module.exports = circumradius\n\nvar circumcenter = __webpack_require__(/*! circumcenter */ \"./node_modules/circumcenter/circumcenter.js\")\n\nfunction circumradius(points) {\n  var center = circumcenter(points)\n  var avgDist = 0.0\n  for(var i=0; i<points.length; ++i) {\n    var p = points[i]\n    for(var j=0; j<center.length; ++j) {\n      avgDist += Math.pow(p[j] - center[j], 2)\n    }\n  }\n  return Math.sqrt(avgDist / points.length)\n}\n\n//# sourceURL=webpack:///./node_modules/circumradius/crad.js?");

/***/ }),

/***/ "./node_modules/clamp/index.js":
/*!*************************************!*\
  !*** ./node_modules/clamp/index.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("module.exports = clamp\n\nfunction clamp(value, min, max) {\n  return min < max\n    ? (value < min ? min : value > max ? max : value)\n    : (value < max ? max : value > min ? min : value)\n}\n\n\n//# sourceURL=webpack:///./node_modules/clamp/index.js?");

/***/ }),

/***/ "./node_modules/clean-pslg/clean-pslg.js":
/*!***********************************************!*\
  !*** ./node_modules/clean-pslg/clean-pslg.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = cleanPSLG\n\nvar UnionFind = __webpack_require__(/*! union-find */ \"./node_modules/union-find/index.js\")\nvar boxIntersect = __webpack_require__(/*! box-intersect */ \"./node_modules/box-intersect/index.js\")\nvar segseg = __webpack_require__(/*! robust-segment-intersect */ \"./node_modules/robust-segment-intersect/segseg.js\")\nvar rat = __webpack_require__(/*! big-rat */ \"./node_modules/big-rat/index.js\")\nvar ratCmp = __webpack_require__(/*! big-rat/cmp */ \"./node_modules/big-rat/cmp.js\")\nvar ratToFloat = __webpack_require__(/*! big-rat/to-float */ \"./node_modules/big-rat/to-float.js\")\nvar ratVec = __webpack_require__(/*! rat-vec */ \"./node_modules/rat-vec/index.js\")\nvar nextafter = __webpack_require__(/*! nextafter */ \"./node_modules/nextafter/nextafter.js\")\n\nvar solveIntersection = __webpack_require__(/*! ./lib/rat-seg-intersect */ \"./node_modules/clean-pslg/lib/rat-seg-intersect.js\")\n\n// Bounds on a rational number when rounded to a float\nfunction boundRat (r) {\n  var f = ratToFloat(r)\n  return [\n    nextafter(f, -Infinity),\n    nextafter(f, Infinity)\n  ]\n}\n\n// Convert a list of edges in a pslg to bounding boxes\nfunction boundEdges (points, edges) {\n  var bounds = new Array(edges.length)\n  for (var i = 0; i < edges.length; ++i) {\n    var e = edges[i]\n    var a = points[e[0]]\n    var b = points[e[1]]\n    bounds[i] = [\n      nextafter(Math.min(a[0], b[0]), -Infinity),\n      nextafter(Math.min(a[1], b[1]), -Infinity),\n      nextafter(Math.max(a[0], b[0]), Infinity),\n      nextafter(Math.max(a[1], b[1]), Infinity)\n    ]\n  }\n  return bounds\n}\n\n// Convert a list of points into bounding boxes by duplicating coords\nfunction boundPoints (points) {\n  var bounds = new Array(points.length)\n  for (var i = 0; i < points.length; ++i) {\n    var p = points[i]\n    bounds[i] = [\n      nextafter(p[0], -Infinity),\n      nextafter(p[1], -Infinity),\n      nextafter(p[0], Infinity),\n      nextafter(p[1], Infinity)\n    ]\n  }\n  return bounds\n}\n\n// Find all pairs of crossing edges in a pslg (given edge bounds)\nfunction getCrossings (points, edges, edgeBounds) {\n  var result = []\n  boxIntersect(edgeBounds, function (i, j) {\n    var e = edges[i]\n    var f = edges[j]\n    if (e[0] === f[0] || e[0] === f[1] ||\n      e[1] === f[0] || e[1] === f[1]) {\n      return\n    }\n    var a = points[e[0]]\n    var b = points[e[1]]\n    var c = points[f[0]]\n    var d = points[f[1]]\n    if (segseg(a, b, c, d)) {\n      result.push([i, j])\n    }\n  })\n  return result\n}\n\n// Find all pairs of crossing vertices in a pslg (given edge/vert bounds)\nfunction getTJunctions (points, edges, edgeBounds, vertBounds) {\n  var result = []\n  boxIntersect(edgeBounds, vertBounds, function (i, v) {\n    var e = edges[i]\n    if (e[0] === v || e[1] === v) {\n      return\n    }\n    var p = points[v]\n    var a = points[e[0]]\n    var b = points[e[1]]\n    if (segseg(a, b, p, p)) {\n      result.push([i, v])\n    }\n  })\n  return result\n}\n\n// Cut edges along crossings/tjunctions\nfunction cutEdges (floatPoints, edges, crossings, junctions, useColor) {\n  var i, e\n\n  // Convert crossings into tjunctions by constructing rational points\n  var ratPoints = floatPoints.map(function(p) {\n      return [\n          rat(p[0]),\n          rat(p[1])\n      ]\n  })\n  for (i = 0; i < crossings.length; ++i) {\n    var crossing = crossings[i]\n    e = crossing[0]\n    var f = crossing[1]\n    var ee = edges[e]\n    var ef = edges[f]\n    var x = solveIntersection(\n      ratVec(floatPoints[ee[0]]),\n      ratVec(floatPoints[ee[1]]),\n      ratVec(floatPoints[ef[0]]),\n      ratVec(floatPoints[ef[1]]))\n    if (!x) {\n      // Segments are parallel, should already be handled by t-junctions\n      continue\n    }\n    var idx = floatPoints.length\n    floatPoints.push([ratToFloat(x[0]), ratToFloat(x[1])])\n    ratPoints.push(x)\n    junctions.push([e, idx], [f, idx])\n  }\n\n  // Sort tjunctions\n  junctions.sort(function (a, b) {\n    if (a[0] !== b[0]) {\n      return a[0] - b[0]\n    }\n    var u = ratPoints[a[1]]\n    var v = ratPoints[b[1]]\n    return ratCmp(u[0], v[0]) || ratCmp(u[1], v[1])\n  })\n\n  // Split edges along junctions\n  for (i = junctions.length - 1; i >= 0; --i) {\n    var junction = junctions[i]\n    e = junction[0]\n\n    var edge = edges[e]\n    var s = edge[0]\n    var t = edge[1]\n\n    // Check if edge is not lexicographically sorted\n    var a = floatPoints[s]\n    var b = floatPoints[t]\n    if (((a[0] - b[0]) || (a[1] - b[1])) < 0) {\n      var tmp = s\n      s = t\n      t = tmp\n    }\n\n    // Split leading edge\n    edge[0] = s\n    var last = edge[1] = junction[1]\n\n    // If we are grouping edges by color, remember to track data\n    var color\n    if (useColor) {\n      color = edge[2]\n    }\n\n    // Split other edges\n    while (i > 0 && junctions[i - 1][0] === e) {\n      var junction = junctions[--i]\n      var next = junction[1]\n      if (useColor) {\n        edges.push([last, next, color])\n      } else {\n        edges.push([last, next])\n      }\n      last = next\n    }\n\n    // Add final edge\n    if (useColor) {\n      edges.push([last, t, color])\n    } else {\n      edges.push([last, t])\n    }\n  }\n\n  // Return constructed rational points\n  return ratPoints\n}\n\n// Merge overlapping points\nfunction dedupPoints (floatPoints, ratPoints, floatBounds) {\n  var numPoints = ratPoints.length\n  var uf = new UnionFind(numPoints)\n\n  // Compute rational bounds\n  var bounds = []\n  for (var i = 0; i < ratPoints.length; ++i) {\n    var p = ratPoints[i]\n    var xb = boundRat(p[0])\n    var yb = boundRat(p[1])\n    bounds.push([\n      nextafter(xb[0], -Infinity),\n      nextafter(yb[0], -Infinity),\n      nextafter(xb[1], Infinity),\n      nextafter(yb[1], Infinity)\n    ])\n  }\n\n  // Link all points with over lapping boxes\n  boxIntersect(bounds, function (i, j) {\n    uf.link(i, j)\n  })\n\n  // Do 1 pass over points to combine points in label sets\n  var noDupes = true\n  var labels = new Array(numPoints)\n  for (var i = 0; i < numPoints; ++i) {\n    var j = uf.find(i)\n    if (j !== i) {\n      // Clear no-dupes flag, zero out label\n      noDupes = false\n      // Make each point the top-left point from its cell\n      floatPoints[j] = [\n        Math.min(floatPoints[i][0], floatPoints[j][0]),\n        Math.min(floatPoints[i][1], floatPoints[j][1])\n      ]\n    }\n  }\n\n  // If no duplicates, return null to signal termination\n  if (noDupes) {\n    return null\n  }\n\n  var ptr = 0\n  for (var i = 0; i < numPoints; ++i) {\n    var j = uf.find(i)\n    if (j === i) {\n      labels[i] = ptr\n      floatPoints[ptr++] = floatPoints[i]\n    } else {\n      labels[i] = -1\n    }\n  }\n\n  floatPoints.length = ptr\n\n  // Do a second pass to fix up missing labels\n  for (var i = 0; i < numPoints; ++i) {\n    if (labels[i] < 0) {\n      labels[i] = labels[uf.find(i)]\n    }\n  }\n\n  // Return resulting union-find data structure\n  return labels\n}\n\nfunction compareLex2 (a, b) { return (a[0] - b[0]) || (a[1] - b[1]) }\nfunction compareLex3 (a, b) {\n  var d = (a[0] - b[0]) || (a[1] - b[1])\n  if (d) {\n    return d\n  }\n  if (a[2] < b[2]) {\n    return -1\n  } else if (a[2] > b[2]) {\n    return 1\n  }\n  return 0\n}\n\n// Remove duplicate edge labels\nfunction dedupEdges (edges, labels, useColor) {\n  if (edges.length === 0) {\n    return\n  }\n  if (labels) {\n    for (var i = 0; i < edges.length; ++i) {\n      var e = edges[i]\n      var a = labels[e[0]]\n      var b = labels[e[1]]\n      e[0] = Math.min(a, b)\n      e[1] = Math.max(a, b)\n    }\n  } else {\n    for (var i = 0; i < edges.length; ++i) {\n      var e = edges[i]\n      var a = e[0]\n      var b = e[1]\n      e[0] = Math.min(a, b)\n      e[1] = Math.max(a, b)\n    }\n  }\n  if (useColor) {\n    edges.sort(compareLex3)\n  } else {\n    edges.sort(compareLex2)\n  }\n  var ptr = 1\n  for (var i = 1; i < edges.length; ++i) {\n    var prev = edges[i - 1]\n    var next = edges[i]\n    if (next[0] === prev[0] && next[1] === prev[1] &&\n      (!useColor || next[2] === prev[2])) {\n      continue\n    }\n    edges[ptr++] = next\n  }\n  edges.length = ptr\n}\n\nfunction preRound (points, edges, useColor) {\n  var labels = dedupPoints(points, [], boundPoints(points))\n  dedupEdges(edges, labels, useColor)\n  return !!labels\n}\n\n// Repeat until convergence\nfunction snapRound (points, edges, useColor) {\n  // 1. find edge crossings\n  var edgeBounds = boundEdges(points, edges)\n  var crossings = getCrossings(points, edges, edgeBounds)\n\n  // 2. find t-junctions\n  var vertBounds = boundPoints(points)\n  var tjunctions = getTJunctions(points, edges, edgeBounds, vertBounds)\n\n  // 3. cut edges, construct rational points\n  var ratPoints = cutEdges(points, edges, crossings, tjunctions, useColor)\n\n  // 4. dedupe verts\n  var labels = dedupPoints(points, ratPoints, vertBounds)\n\n  // 5. dedupe edges\n  dedupEdges(edges, labels, useColor)\n\n  // 6. check termination\n  if (!labels) {\n    return (crossings.length > 0 || tjunctions.length > 0)\n  }\n\n  // More iterations necessary\n  return true\n}\n\n// Main loop, runs PSLG clean up until completion\nfunction cleanPSLG (points, edges, colors) {\n  // If using colors, augment edges with color data\n  var prevEdges\n  if (colors) {\n    prevEdges = edges\n    var augEdges = new Array(edges.length)\n    for (var i = 0; i < edges.length; ++i) {\n      var e = edges[i]\n      augEdges[i] = [e[0], e[1], colors[i]]\n    }\n    edges = augEdges\n  }\n\n  // First round: remove duplicate edges and points\n  var modified = preRound(points, edges, !!colors)\n\n  // Run snap rounding until convergence\n  while (snapRound(points, edges, !!colors)) {\n    modified = true\n  }\n\n  // Strip color tags\n  if (!!colors && modified) {\n    prevEdges.length = 0\n    colors.length = 0\n    for (var i = 0; i < edges.length; ++i) {\n      var e = edges[i]\n      prevEdges.push([e[0], e[1]])\n      colors.push(e[2])\n    }\n  }\n\n  return modified\n}\n\n\n//# sourceURL=webpack:///./node_modules/clean-pslg/clean-pslg.js?");

/***/ }),

/***/ "./node_modules/clean-pslg/lib/rat-seg-intersect.js":
/*!**********************************************************!*\
  !*** ./node_modules/clean-pslg/lib/rat-seg-intersect.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = solveIntersection\n\nvar ratMul = __webpack_require__(/*! big-rat/mul */ \"./node_modules/big-rat/mul.js\")\nvar ratDiv = __webpack_require__(/*! big-rat/div */ \"./node_modules/big-rat/div.js\")\nvar ratSub = __webpack_require__(/*! big-rat/sub */ \"./node_modules/big-rat/sub.js\")\nvar ratSign = __webpack_require__(/*! big-rat/sign */ \"./node_modules/big-rat/sign.js\")\nvar rvSub = __webpack_require__(/*! rat-vec/sub */ \"./node_modules/rat-vec/sub.js\")\nvar rvAdd = __webpack_require__(/*! rat-vec/add */ \"./node_modules/rat-vec/add.js\")\nvar rvMuls = __webpack_require__(/*! rat-vec/muls */ \"./node_modules/rat-vec/muls.js\")\n\nfunction ratPerp (a, b) {\n  return ratSub(ratMul(a[0], b[1]), ratMul(a[1], b[0]))\n}\n\n// Solve for intersection\n//  x = a + t (b-a)\n//  (x - c) ^ (d-c) = 0\n//  (t * (b-a) + (a-c) ) ^ (d-c) = 0\n//  t * (b-a)^(d-c) = (d-c)^(a-c)\n//  t = (d-c)^(a-c) / (b-a)^(d-c)\n\nfunction solveIntersection (a, b, c, d) {\n  var ba = rvSub(b, a)\n  var dc = rvSub(d, c)\n\n  var baXdc = ratPerp(ba, dc)\n\n  if (ratSign(baXdc) === 0) {\n    return null\n  }\n\n  var ac = rvSub(a, c)\n  var dcXac = ratPerp(dc, ac)\n\n  var t = ratDiv(dcXac, baXdc)\n  var s = rvMuls(ba, t)\n  var r = rvAdd(a, s)\n\n  return r\n}\n\n\n//# sourceURL=webpack:///./node_modules/clean-pslg/lib/rat-seg-intersect.js?");

/***/ }),

/***/ "./node_modules/color-id/index.js":
/*!****************************************!*\
  !*** ./node_modules/color-id/index.js ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/** @module  color-id */\r\n\r\n\r\n\r\nvar clamp = __webpack_require__(/*! clamp */ \"./node_modules/clamp/index.js\")\r\n\r\nmodule.exports = toNumber\r\nmodule.exports.to = toNumber\r\nmodule.exports.from = fromNumber\r\n\r\nfunction toNumber (rgba, normalized) {\r\n\tif(normalized == null) normalized = true\r\n\r\n\tvar r = rgba[0], g = rgba[1], b = rgba[2], a = rgba[3]\r\n\r\n\tif (a == null) a = normalized ? 1 : 255\r\n\r\n\tif (normalized) {\r\n\t\tr *= 255\r\n\t\tg *= 255\r\n\t\tb *= 255\r\n\t\ta *= 255\r\n\t}\r\n\r\n\tr = clamp(r, 0, 255) & 0xFF\r\n\tg = clamp(g, 0, 255) & 0xFF\r\n\tb = clamp(b, 0, 255) & 0xFF\r\n\ta = clamp(a, 0, 255) & 0xFF\r\n\r\n\t//hi-order shift converts to -1, so we can't use <<24\r\n\tvar n = (r * 0x01000000) + (g << 16) + (b << 8) + (a)\r\n\r\n\treturn n\r\n}\r\n\r\nfunction fromNumber (n, normalized) {\r\n\tn = +n\r\n\r\n\tvar r = n >>> 24\r\n\tvar g = (n & 0x00ff0000) >>> 16\r\n\tvar b = (n & 0x0000ff00) >>> 8\r\n\tvar a = n & 0x000000ff\r\n\r\n\tif (normalized === false) return [r, g, b, a]\r\n\r\n\treturn [r/255, g/255, b/255, a/255]\r\n}\r\n\n\n//# sourceURL=webpack:///./node_modules/color-id/index.js?");

/***/ }),

/***/ "./node_modules/color-name/index.js":
/*!******************************************!*\
  !*** ./node_modules/color-name/index.js ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\r\n\r\nmodule.exports = {\r\n\t\"aliceblue\": [240, 248, 255],\r\n\t\"antiquewhite\": [250, 235, 215],\r\n\t\"aqua\": [0, 255, 255],\r\n\t\"aquamarine\": [127, 255, 212],\r\n\t\"azure\": [240, 255, 255],\r\n\t\"beige\": [245, 245, 220],\r\n\t\"bisque\": [255, 228, 196],\r\n\t\"black\": [0, 0, 0],\r\n\t\"blanchedalmond\": [255, 235, 205],\r\n\t\"blue\": [0, 0, 255],\r\n\t\"blueviolet\": [138, 43, 226],\r\n\t\"brown\": [165, 42, 42],\r\n\t\"burlywood\": [222, 184, 135],\r\n\t\"cadetblue\": [95, 158, 160],\r\n\t\"chartreuse\": [127, 255, 0],\r\n\t\"chocolate\": [210, 105, 30],\r\n\t\"coral\": [255, 127, 80],\r\n\t\"cornflowerblue\": [100, 149, 237],\r\n\t\"cornsilk\": [255, 248, 220],\r\n\t\"crimson\": [220, 20, 60],\r\n\t\"cyan\": [0, 255, 255],\r\n\t\"darkblue\": [0, 0, 139],\r\n\t\"darkcyan\": [0, 139, 139],\r\n\t\"darkgoldenrod\": [184, 134, 11],\r\n\t\"darkgray\": [169, 169, 169],\r\n\t\"darkgreen\": [0, 100, 0],\r\n\t\"darkgrey\": [169, 169, 169],\r\n\t\"darkkhaki\": [189, 183, 107],\r\n\t\"darkmagenta\": [139, 0, 139],\r\n\t\"darkolivegreen\": [85, 107, 47],\r\n\t\"darkorange\": [255, 140, 0],\r\n\t\"darkorchid\": [153, 50, 204],\r\n\t\"darkred\": [139, 0, 0],\r\n\t\"darksalmon\": [233, 150, 122],\r\n\t\"darkseagreen\": [143, 188, 143],\r\n\t\"darkslateblue\": [72, 61, 139],\r\n\t\"darkslategray\": [47, 79, 79],\r\n\t\"darkslategrey\": [47, 79, 79],\r\n\t\"darkturquoise\": [0, 206, 209],\r\n\t\"darkviolet\": [148, 0, 211],\r\n\t\"deeppink\": [255, 20, 147],\r\n\t\"deepskyblue\": [0, 191, 255],\r\n\t\"dimgray\": [105, 105, 105],\r\n\t\"dimgrey\": [105, 105, 105],\r\n\t\"dodgerblue\": [30, 144, 255],\r\n\t\"firebrick\": [178, 34, 34],\r\n\t\"floralwhite\": [255, 250, 240],\r\n\t\"forestgreen\": [34, 139, 34],\r\n\t\"fuchsia\": [255, 0, 255],\r\n\t\"gainsboro\": [220, 220, 220],\r\n\t\"ghostwhite\": [248, 248, 255],\r\n\t\"gold\": [255, 215, 0],\r\n\t\"goldenrod\": [218, 165, 32],\r\n\t\"gray\": [128, 128, 128],\r\n\t\"green\": [0, 128, 0],\r\n\t\"greenyellow\": [173, 255, 47],\r\n\t\"grey\": [128, 128, 128],\r\n\t\"honeydew\": [240, 255, 240],\r\n\t\"hotpink\": [255, 105, 180],\r\n\t\"indianred\": [205, 92, 92],\r\n\t\"indigo\": [75, 0, 130],\r\n\t\"ivory\": [255, 255, 240],\r\n\t\"khaki\": [240, 230, 140],\r\n\t\"lavender\": [230, 230, 250],\r\n\t\"lavenderblush\": [255, 240, 245],\r\n\t\"lawngreen\": [124, 252, 0],\r\n\t\"lemonchiffon\": [255, 250, 205],\r\n\t\"lightblue\": [173, 216, 230],\r\n\t\"lightcoral\": [240, 128, 128],\r\n\t\"lightcyan\": [224, 255, 255],\r\n\t\"lightgoldenrodyellow\": [250, 250, 210],\r\n\t\"lightgray\": [211, 211, 211],\r\n\t\"lightgreen\": [144, 238, 144],\r\n\t\"lightgrey\": [211, 211, 211],\r\n\t\"lightpink\": [255, 182, 193],\r\n\t\"lightsalmon\": [255, 160, 122],\r\n\t\"lightseagreen\": [32, 178, 170],\r\n\t\"lightskyblue\": [135, 206, 250],\r\n\t\"lightslategray\": [119, 136, 153],\r\n\t\"lightslategrey\": [119, 136, 153],\r\n\t\"lightsteelblue\": [176, 196, 222],\r\n\t\"lightyellow\": [255, 255, 224],\r\n\t\"lime\": [0, 255, 0],\r\n\t\"limegreen\": [50, 205, 50],\r\n\t\"linen\": [250, 240, 230],\r\n\t\"magenta\": [255, 0, 255],\r\n\t\"maroon\": [128, 0, 0],\r\n\t\"mediumaquamarine\": [102, 205, 170],\r\n\t\"mediumblue\": [0, 0, 205],\r\n\t\"mediumorchid\": [186, 85, 211],\r\n\t\"mediumpurple\": [147, 112, 219],\r\n\t\"mediumseagreen\": [60, 179, 113],\r\n\t\"mediumslateblue\": [123, 104, 238],\r\n\t\"mediumspringgreen\": [0, 250, 154],\r\n\t\"mediumturquoise\": [72, 209, 204],\r\n\t\"mediumvioletred\": [199, 21, 133],\r\n\t\"midnightblue\": [25, 25, 112],\r\n\t\"mintcream\": [245, 255, 250],\r\n\t\"mistyrose\": [255, 228, 225],\r\n\t\"moccasin\": [255, 228, 181],\r\n\t\"navajowhite\": [255, 222, 173],\r\n\t\"navy\": [0, 0, 128],\r\n\t\"oldlace\": [253, 245, 230],\r\n\t\"olive\": [128, 128, 0],\r\n\t\"olivedrab\": [107, 142, 35],\r\n\t\"orange\": [255, 165, 0],\r\n\t\"orangered\": [255, 69, 0],\r\n\t\"orchid\": [218, 112, 214],\r\n\t\"palegoldenrod\": [238, 232, 170],\r\n\t\"palegreen\": [152, 251, 152],\r\n\t\"paleturquoise\": [175, 238, 238],\r\n\t\"palevioletred\": [219, 112, 147],\r\n\t\"papayawhip\": [255, 239, 213],\r\n\t\"peachpuff\": [255, 218, 185],\r\n\t\"peru\": [205, 133, 63],\r\n\t\"pink\": [255, 192, 203],\r\n\t\"plum\": [221, 160, 221],\r\n\t\"powderblue\": [176, 224, 230],\r\n\t\"purple\": [128, 0, 128],\r\n\t\"rebeccapurple\": [102, 51, 153],\r\n\t\"red\": [255, 0, 0],\r\n\t\"rosybrown\": [188, 143, 143],\r\n\t\"royalblue\": [65, 105, 225],\r\n\t\"saddlebrown\": [139, 69, 19],\r\n\t\"salmon\": [250, 128, 114],\r\n\t\"sandybrown\": [244, 164, 96],\r\n\t\"seagreen\": [46, 139, 87],\r\n\t\"seashell\": [255, 245, 238],\r\n\t\"sienna\": [160, 82, 45],\r\n\t\"silver\": [192, 192, 192],\r\n\t\"skyblue\": [135, 206, 235],\r\n\t\"slateblue\": [106, 90, 205],\r\n\t\"slategray\": [112, 128, 144],\r\n\t\"slategrey\": [112, 128, 144],\r\n\t\"snow\": [255, 250, 250],\r\n\t\"springgreen\": [0, 255, 127],\r\n\t\"steelblue\": [70, 130, 180],\r\n\t\"tan\": [210, 180, 140],\r\n\t\"teal\": [0, 128, 128],\r\n\t\"thistle\": [216, 191, 216],\r\n\t\"tomato\": [255, 99, 71],\r\n\t\"turquoise\": [64, 224, 208],\r\n\t\"violet\": [238, 130, 238],\r\n\t\"wheat\": [245, 222, 179],\r\n\t\"white\": [255, 255, 255],\r\n\t\"whitesmoke\": [245, 245, 245],\r\n\t\"yellow\": [255, 255, 0],\r\n\t\"yellowgreen\": [154, 205, 50]\r\n};\r\n\n\n//# sourceURL=webpack:///./node_modules/color-name/index.js?");

/***/ }),

/***/ "./node_modules/color-normalize/index.js":
/*!***********************************************!*\
  !*** ./node_modules/color-normalize/index.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/** @module  color-normalize */\r\n\r\n\r\n\r\nvar rgba = __webpack_require__(/*! color-rgba */ \"./node_modules/color-rgba/index.js\")\r\nvar clamp = __webpack_require__(/*! clamp */ \"./node_modules/clamp/index.js\")\r\nvar dtype = __webpack_require__(/*! dtype */ \"./node_modules/dtype/index.js\")\r\n\r\nmodule.exports = function normalize (color, type) {\r\n\tif (type === 'float' || !type) type = 'array'\r\n\tif (type === 'uint') type = 'uint8'\r\n\tif (type === 'uint_clamped') type = 'uint8_clamped'\r\n\tvar Ctor = dtype(type)\r\n\tvar output = new Ctor(4)\r\n\r\n\tvar normalize = type !== 'uint8' && type !== 'uint8_clamped'\r\n\r\n\t// attempt to parse non-array arguments\r\n\tif (!color.length || typeof color === 'string') {\r\n\t\tcolor = rgba(color)\r\n\t\tcolor[0] /= 255\r\n\t\tcolor[1] /= 255\r\n\t\tcolor[2] /= 255\r\n\t}\r\n\r\n\t// 0, 1 are possible contradictory values for Arrays:\r\n\t// [1,1,1] input gives [1,1,1] output instead of [1/255,1/255,1/255], which may be collision if input is meant to be uint.\r\n\t// converting [1,1,1] to [1/255,1/255,1/255] in case of float input gives larger mistake since [1,1,1] float is frequent edge value, whereas [0,1,1], [1,1,1] etc. uint inputs are relatively rare\r\n\tif (isInt(color)) {\r\n\t\toutput[0] = color[0]\r\n\t\toutput[1] = color[1]\r\n\t\toutput[2] = color[2]\r\n\t\toutput[3] = color[3] != null ? color[3] : 255\r\n\r\n\t\tif (normalize) {\r\n\t\t\toutput[0] /= 255\r\n\t\t\toutput[1] /= 255\r\n\t\t\toutput[2] /= 255\r\n\t\t\toutput[3] /= 255\r\n\t\t}\r\n\r\n\t\treturn output\r\n\t}\r\n\r\n\tif (!normalize) {\r\n\t\toutput[0] = clamp(Math.floor(color[0] * 255), 0, 255)\r\n\t\toutput[1] = clamp(Math.floor(color[1] * 255), 0, 255)\r\n\t\toutput[2] = clamp(Math.floor(color[2] * 255), 0, 255)\r\n\t\toutput[3] = color[3] == null ? 255 : clamp(Math.floor(color[3] * 255), 0, 255)\r\n\t} else {\r\n\t\toutput[0] = color[0]\r\n\t\toutput[1] = color[1]\r\n\t\toutput[2] = color[2]\r\n\t\toutput[3] = color[3] != null ? color[3] : 1\r\n\t}\r\n\r\n\treturn output\r\n}\r\n\r\nfunction isInt(color) {\r\n\tif (color instanceof Uint8Array || color instanceof Uint8ClampedArray) return true\r\n\r\n\tif (Array.isArray(color) &&\r\n\t\t(color[0] > 1 || color[0] === 0) &&\r\n\t\t(color[1] > 1 || color[1] === 0) &&\r\n\t\t(color[2] > 1 || color[2] === 0) &&\r\n\t\t(!color[3] || color[3] > 1)\r\n\t) return true\r\n\r\n\treturn false\r\n}\r\n\n\n//# sourceURL=webpack:///./node_modules/color-normalize/index.js?");

/***/ }),

/***/ "./node_modules/color-parse/index.js":
/*!*******************************************!*\
  !*** ./node_modules/color-parse/index.js ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/* WEBPACK VAR INJECTION */(function(global) {/**\n * @module color-parse\n */\n\n\n\nvar names = __webpack_require__(/*! color-name */ \"./node_modules/color-name/index.js\")\nvar isObject = __webpack_require__(/*! is-plain-obj */ \"./node_modules/is-plain-obj/index.js\")\nvar defined = __webpack_require__(/*! defined */ \"./node_modules/defined/index.js\")\n\nmodule.exports = parse\n\n/**\n * Base hues\n * http://dev.w3.org/csswg/css-color/#typedef-named-hue\n */\n//FIXME: use external hue detector\nvar baseHues = {\n\tred: 0,\n\torange: 60,\n\tyellow: 120,\n\tgreen: 180,\n\tblue: 240,\n\tpurple: 300\n}\n\n/**\n * Parse color from the string passed\n *\n * @return {Object} A space indicator `space`, an array `values` and `alpha`\n */\nfunction parse (cstr) {\n\tvar m, parts = [], alpha = 1, space\n\n\tif (typeof cstr === 'string') {\n\t\t//keyword\n\t\tif (names[cstr]) {\n\t\t\tparts = names[cstr].slice()\n\t\t\tspace = 'rgb'\n\t\t}\n\n\t\t//reserved words\n\t\telse if (cstr === 'transparent') {\n\t\t\talpha = 0\n\t\t\tspace = 'rgb'\n\t\t\tparts = [0,0,0]\n\t\t}\n\n\t\t//hex\n\t\telse if (/^#[A-Fa-f0-9]+$/.test(cstr)) {\n\t\t\tvar base = cstr.slice(1)\n\t\t\tvar size = base.length\n\t\t\tvar isShort = size <= 4\n\t\t\talpha = 1\n\n\t\t\tif (isShort) {\n\t\t\t\tparts = [\n\t\t\t\t\tparseInt(base[0] + base[0], 16),\n\t\t\t\t\tparseInt(base[1] + base[1], 16),\n\t\t\t\t\tparseInt(base[2] + base[2], 16)\n\t\t\t\t]\n\t\t\t\tif (size === 4) {\n\t\t\t\t\talpha = parseInt(base[3] + base[3], 16) / 255\n\t\t\t\t}\n\t\t\t}\n\t\t\telse {\n\t\t\t\tparts = [\n\t\t\t\t\tparseInt(base[0] + base[1], 16),\n\t\t\t\t\tparseInt(base[2] + base[3], 16),\n\t\t\t\t\tparseInt(base[4] + base[5], 16)\n\t\t\t\t]\n\t\t\t\tif (size === 8) {\n\t\t\t\t\talpha = parseInt(base[6] + base[7], 16) / 255\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (!parts[0]) parts[0] = 0\n\t\t\tif (!parts[1]) parts[1] = 0\n\t\t\tif (!parts[2]) parts[2] = 0\n\n\t\t\tspace = 'rgb'\n\t\t}\n\n\t\t//color space\n\t\telse if (m = /^((?:rgb|hs[lvb]|hwb|cmyk?|xy[zy]|gray|lab|lchu?v?|[ly]uv|lms)a?)\\s*\\(([^\\)]*)\\)/.exec(cstr)) {\n\t\t\tvar name = m[1]\n\t\t\tvar isRGB = name === 'rgb'\n\t\t\tvar base = name.replace(/a$/, '')\n\t\t\tspace = base\n\t\t\tvar size = base === 'cmyk' ? 4 : base === 'gray' ? 1 : 3\n\t\t\tparts = m[2].trim()\n\t\t\t\t.split(/\\s*,\\s*/)\n\t\t\t\t.map(function (x, i) {\n\t\t\t\t\t//<percentage>\n\t\t\t\t\tif (/%$/.test(x)) {\n\t\t\t\t\t\t//alpha\n\t\t\t\t\t\tif (i === size)\treturn parseFloat(x) / 100\n\t\t\t\t\t\t//rgb\n\t\t\t\t\t\tif (base === 'rgb') return parseFloat(x) * 255 / 100\n\t\t\t\t\t\treturn parseFloat(x)\n\t\t\t\t\t}\n\t\t\t\t\t//hue\n\t\t\t\t\telse if (base[i] === 'h') {\n\t\t\t\t\t\t//<deg>\n\t\t\t\t\t\tif (/deg$/.test(x)) {\n\t\t\t\t\t\t\treturn parseFloat(x)\n\t\t\t\t\t\t}\n\t\t\t\t\t\t//<base-hue>\n\t\t\t\t\t\telse if (baseHues[x] !== undefined) {\n\t\t\t\t\t\t\treturn baseHues[x]\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn parseFloat(x)\n\t\t\t\t})\n\n\t\t\tif (name === base) parts.push(1)\n\t\t\talpha = (isRGB) ? 1 : (parts[size] === undefined) ? 1 : parts[size]\n\t\t\tparts = parts.slice(0, size)\n\t\t}\n\n\t\t//named channels case\n\t\telse if (cstr.length > 10 && /[0-9](?:\\s|\\/)/.test(cstr)) {\n\t\t\tparts = cstr.match(/([0-9]+)/g).map(function (value) {\n\t\t\t\treturn parseFloat(value)\n\t\t\t})\n\n\t\t\tspace = cstr.match(/([a-z])/ig).join('').toLowerCase()\n\t\t}\n\t}\n\n\t//numeric case\n\telse if (!isNaN(cstr)) {\n\t\tspace = 'rgb'\n\t\tparts = [cstr >>> 16, (cstr & 0x00ff00) >>> 8, cstr & 0x0000ff]\n\t}\n\n\t//object case - detects css cases of rgb and hsl\n\telse if (isObject(cstr)) {\n\t\tvar r = defined(cstr.r, cstr.red, cstr.R, null)\n\n\t\tif (r !== null) {\n\t\t\tspace = 'rgb'\n\t\t\tparts = [\n\t\t\t\tr,\n\t\t\t\tdefined(cstr.g, cstr.green, cstr.G),\n\t\t\t\tdefined(cstr.b, cstr.blue, cstr.B)\n\t\t\t]\n\t\t}\n\t\telse {\n\t\t\tspace = 'hsl'\n\t\t\tparts = [\n\t\t\t\tdefined(cstr.h, cstr.hue, cstr.H),\n\t\t\t\tdefined(cstr.s, cstr.saturation, cstr.S),\n\t\t\t\tdefined(cstr.l, cstr.lightness, cstr.L, cstr.b, cstr.brightness)\n\t\t\t]\n\t\t}\n\n\t\talpha = defined(cstr.a, cstr.alpha, cstr.opacity, 1)\n\n\t\tif (cstr.opacity != null) alpha /= 100\n\t}\n\n\t//array\n\telse if (Array.isArray(cstr) || global.ArrayBuffer && ArrayBuffer.isView && ArrayBuffer.isView(cstr)) {\n\t\tparts = [cstr[0], cstr[1], cstr[2]]\n\t\tspace = 'rgb'\n\t\talpha = cstr.length === 4 ? cstr[3] : 1\n\t}\n\n\treturn {\n\t\tspace: space,\n\t\tvalues: parts,\n\t\talpha: alpha\n\t}\n}\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../webpack/buildin/global.js */ \"./node_modules/webpack/buildin/global.js\")))\n\n//# sourceURL=webpack:///./node_modules/color-parse/index.js?");

/***/ }),

/***/ "./node_modules/color-rgba/index.js":
/*!******************************************!*\
  !*** ./node_modules/color-rgba/index.js ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/** @module  color-rgba */\n\n\n\nvar parse = __webpack_require__(/*! color-parse */ \"./node_modules/color-parse/index.js\")\nvar hsl = __webpack_require__(/*! color-space/hsl */ \"./node_modules/color-space/hsl.js\")\nvar clamp = __webpack_require__(/*! clamp */ \"./node_modules/clamp/index.js\")\n\nmodule.exports = function rgba (color) {\n\tvar values, i, l\n\n\t//attempt to parse non-array arguments\n\tvar parsed = parse(color)\n\n\tif (!parsed.space) return []\n\n\tvalues = Array(3)\n\tvalues[0] = clamp(parsed.values[0], 0, 255)\n\tvalues[1] = clamp(parsed.values[1], 0, 255)\n\tvalues[2] = clamp(parsed.values[2], 0, 255)\n\n\tif (parsed.space[0] === 'h') {\n\t\tvalues = hsl.rgb(values)\n\t}\n\n\tvalues.push(clamp(parsed.alpha, 0, 1))\n\n\treturn values\n}\n\n\n//# sourceURL=webpack:///./node_modules/color-rgba/index.js?");

/***/ }),

/***/ "./node_modules/color-space/hsl.js":
/*!*****************************************!*\
  !*** ./node_modules/color-space/hsl.js ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/**\n * @module color-space/hsl\n */\n\n\nvar rgb = __webpack_require__(/*! ./rgb */ \"./node_modules/color-space/rgb.js\");\n\nmodule.exports = {\n\tname: 'hsl',\n\tmin: [0,0,0],\n\tmax: [360,100,100],\n\tchannel: ['hue', 'saturation', 'lightness'],\n\talias: ['HSL'],\n\n\trgb: function(hsl) {\n\t\tvar h = hsl[0] / 360,\n\t\t\t\ts = hsl[1] / 100,\n\t\t\t\tl = hsl[2] / 100,\n\t\t\t\tt1, t2, t3, rgb, val;\n\n\t\tif (s === 0) {\n\t\t\tval = l * 255;\n\t\t\treturn [val, val, val];\n\t\t}\n\n\t\tif (l < 0.5) {\n\t\t\tt2 = l * (1 + s);\n\t\t}\n\t\telse {\n\t\t\tt2 = l + s - l * s;\n\t\t}\n\t\tt1 = 2 * l - t2;\n\n\t\trgb = [0, 0, 0];\n\t\tfor (var i = 0; i < 3; i++) {\n\t\t\tt3 = h + 1 / 3 * - (i - 1);\n\t\t\tif (t3 < 0) {\n\t\t\t\tt3++;\n\t\t\t}\n\t\t\telse if (t3 > 1) {\n\t\t\t\tt3--;\n\t\t\t}\n\n\t\t\tif (6 * t3 < 1) {\n\t\t\t\tval = t1 + (t2 - t1) * 6 * t3;\n\t\t\t}\n\t\t\telse if (2 * t3 < 1) {\n\t\t\t\tval = t2;\n\t\t\t}\n\t\t\telse if (3 * t3 < 2) {\n\t\t\t\tval = t1 + (t2 - t1) * (2 / 3 - t3) * 6;\n\t\t\t}\n\t\t\telse {\n\t\t\t\tval = t1;\n\t\t\t}\n\n\t\t\trgb[i] = val * 255;\n\t\t}\n\n\t\treturn rgb;\n\t}\n};\n\n\n//extend rgb\nrgb.hsl = function(rgb) {\n\tvar r = rgb[0]/255,\n\t\t\tg = rgb[1]/255,\n\t\t\tb = rgb[2]/255,\n\t\t\tmin = Math.min(r, g, b),\n\t\t\tmax = Math.max(r, g, b),\n\t\t\tdelta = max - min,\n\t\t\th, s, l;\n\n\tif (max === min) {\n\t\th = 0;\n\t}\n\telse if (r === max) {\n\t\th = (g - b) / delta;\n\t}\n\telse if (g === max) {\n\t\th = 2 + (b - r) / delta;\n\t}\n\telse if (b === max) {\n\t\th = 4 + (r - g)/ delta;\n\t}\n\n\th = Math.min(h * 60, 360);\n\n\tif (h < 0) {\n\t\th += 360;\n\t}\n\n\tl = (min + max) / 2;\n\n\tif (max === min) {\n\t\ts = 0;\n\t}\n\telse if (l <= 0.5) {\n\t\ts = delta / (max + min);\n\t}\n\telse {\n\t\ts = delta / (2 - max - min);\n\t}\n\n\treturn [h, s * 100, l * 100];\n};\n\n\n//# sourceURL=webpack:///./node_modu