/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ChannelLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.InternalChannelz;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.SecurityLevel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AsyncSemaphore;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.NettyTsiHandshaker;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiFrameHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiFrameProtector;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiPeer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcAttributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.annotation.Nullable;

public final class TsiHandshakeHandler
extends ByteToMessageDecoder {
    private static final int HANDSHAKE_FRAME_SIZE = 1024;
    private final NettyTsiHandshaker handshaker;
    private final HandshakeValidator handshakeValidator;
    private final ChannelHandler next;
    private final AsyncSemaphore semaphore;
    private ProtocolNegotiationEvent pne;
    private boolean semaphoreAcquired;
    private final ChannelLogger negotiationLogger;

    public TsiHandshakeHandler(ChannelHandler next, NettyTsiHandshaker handshaker, HandshakeValidator handshakeValidator, ChannelLogger negotiationLogger) {
        this(next, handshaker, handshakeValidator, null, negotiationLogger);
    }

    public TsiHandshakeHandler(ChannelHandler next, NettyTsiHandshaker handshaker, HandshakeValidator handshakeValidator, AsyncSemaphore semaphore, ChannelLogger negotiationLogger) {
        this.handshaker = Preconditions.checkNotNull(handshaker, "handshaker");
        this.handshakeValidator = Preconditions.checkNotNull(handshakeValidator, "handshakeValidator");
        this.next = Preconditions.checkNotNull(next, "next");
        this.semaphore = semaphore;
        this.negotiationLogger = negotiationLogger;
    }

    @Override
    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        this.decode(ctx, in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.handshaker.processBytesFromPeer(in) && this.handshaker.isInProgress()) {
            this.sendHandshake(ctx);
        }
        if (!this.handshaker.isInProgress()) {
            TsiPeer peer = this.handshaker.extractPeer();
            Object authContext = this.handshaker.extractPeerObject();
            HandshakeValidator.SecurityDetails details = this.handshakeValidator.validatePeerObject(authContext);
            TsiFrameProtector protector = this.handshaker.createFrameProtector(ctx.alloc());
            boolean success = false;
            try {
                TsiFrameHandler framer = new TsiFrameHandler(protector);
                ctx.pipeline().addAfter(ctx.name(), null, framer);
                ctx.pipeline().addAfter(ctx.pipeline().context(framer).name(), null, this.next);
                ctx.pipeline().remove(ctx.name());
                this.fireProtocolNegotiationEvent(ctx, peer, authContext, details);
                success = true;
            }
            finally {
                if (!success && protector != null) {
                    protector.destroy();
                }
            }
        }
    }

    @Override
    public void userEventTriggered(final ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ProtocolNegotiationEvent) {
            Preconditions.checkState(this.pne == null, "negotiation already started");
            this.pne = (ProtocolNegotiationEvent)evt;
            this.negotiationLogger.log(ChannelLogger.ChannelLogLevel.INFO, "TsiHandshake started");
            ChannelFuture acquire = this.semaphoreAcquire(ctx);
            if (acquire.isSuccess()) {
                this.semaphoreAcquired = true;
                this.sendHandshake(ctx);
            } else {
                acquire.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) {
                        if (!future.isSuccess()) {
                            ctx.fireExceptionCaught(future.cause());
                            return;
                        }
                        if (ctx.isRemoved()) {
                            TsiHandshakeHandler.this.semaphoreRelease();
                            return;
                        }
                        TsiHandshakeHandler.this.semaphoreAcquired = true;
                        try {
                            TsiHandshakeHandler.this.sendHandshake(ctx);
                        }
                        catch (Exception ex) {
                            ctx.fireExceptionCaught(ex);
                        }
                        ctx.flush();
                    }
                });
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    private void fireProtocolNegotiationEvent(ChannelHandlerContext ctx, TsiPeer peer, Object authContext, HandshakeValidator.SecurityDetails details) {
        Preconditions.checkState(this.pne != null, "negotiation not yet complete");
        this.negotiationLogger.log(ChannelLogger.ChannelLogLevel.INFO, "TsiHandshake finished");
        ProtocolNegotiationEvent localPne = this.pne;
        Attributes.Builder attrs = InternalProtocolNegotiationEvent.getAttributes(localPne).toBuilder().set(AltsProtocolNegotiator.TSI_PEER_KEY, peer).set(AltsProtocolNegotiator.AUTH_CONTEXT_KEY, authContext).set(GrpcAttributes.ATTR_SECURITY_LEVEL, details.getSecurityLevel());
        localPne = InternalProtocolNegotiationEvent.withAttributes(localPne, attrs.build());
        localPne = InternalProtocolNegotiationEvent.withSecurity(localPne, details.getSecurity());
        ctx.fireUserEventTriggered(localPne);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendHandshake(ChannelHandlerContext ctx) throws GeneralSecurityException {
        while (true) {
            ByteBuf buf;
            boolean written;
            block6: {
                int n;
                written = false;
                buf = ctx.alloc().buffer(1024).retain();
                try {
                    this.handshaker.getBytesToSendToPeer(buf);
                    if (buf.isReadable()) {
                        ctx.writeAndFlush(buf).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                        written = true;
                        break block6;
                    }
                    n = written ? 1 : 2;
                }
                catch (GeneralSecurityException e) {
                    try {
                        throw new GeneralSecurityException("TsiHandshakeHandler encountered exception", e);
                    }
                    catch (Throwable throwable) {
                        buf.release(written ? 1 : 2);
                        throw throwable;
                    }
                }
                buf.release(n);
                return;
            }
            buf.release(written ? 1 : 2);
        }
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        if (this.semaphoreAcquired) {
            this.semaphoreRelease();
            this.semaphoreAcquired = false;
        }
        this.handshaker.close();
    }

    private ChannelFuture semaphoreAcquire(ChannelHandlerContext ctx) {
        if (this.semaphore == null) {
            return ctx.newSucceededFuture();
        }
        return this.semaphore.acquire(ctx);
    }

    private void semaphoreRelease() {
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }

    public static abstract class HandshakeValidator {
        public abstract SecurityDetails validatePeerObject(Object var1) throws GeneralSecurityException;

        public static final class SecurityDetails {
            private final SecurityLevel securityLevel;
            private final InternalChannelz.Security security;

            public SecurityDetails(SecurityLevel securityLevel, @Nullable InternalChannelz.Security security) {
                this.securityLevel = Preconditions.checkNotNull(securityLevel, "securityLevel");
                this.security = security;
            }

            public InternalChannelz.Security getSecurity() {
                return this.security;
            }

            public SecurityLevel getSecurityLevel() {
                return this.securityLevel;
            }
        }
    }
}

