![python-version](https://img.shields.io/badge/python-3.7+-blue.svg)
[![publish](https://github.com/mnogomed/pm-attacher/actions/workflows/publish.yml/badge.svg)](https://github.com/mnogomed/pm-attacher/actions/workflows/publish.yml)
![PyPI](https://img.shields.io/pypi/v/pm-attacher)

# Прикрепление файлов к МКАБ

Утилита предназначена для поиска и прикрепления файлов к медицинским картам амбулаторных больных (МКАБ), основываясь на имени файла, в котором должен быть номер МКАБ.

## Установка

```shell
pip install pm-attacher
```

## Настройка

Управление параметрами утилиты производится либо через переменные окружения, либо через ключи запуска, причём приоритет имеют последние. Обязательные параметры обозначены значком :exclamation:

| Ключ запуска         | Переменная<br>окружения |               | Значение по<br>умолчанию | Описание                                          |
|----------------------|-------------------------|:-------------:|--------------------------|---------------------------------------------------|
| `--file-type-code`   |                         | :exclamation: |                          | Код типа файла                                    | 
| `--file-type-name`   |                         | :exclamation: |                          | Наименование типа файла                           | 
| `--file-info-name`   |                         |               | `Протокол осмотра`       | Наименование файла                                | 
| `--create-user-id`   |                         |               | `1`                      | Идентификатор пользователя,<br>прикрепившего файл | 
| `--create-user-name` |                         |               | `Администратор`          | ФИО пользователя,<br>прикрепившего файл           | 
| `--prefix`           |                         |               |                          | Префикс имени файла                               |         
| `--suffix`           |                         |               |                          | Суффикс имени файла                               |         
| `--recursive`        |                         |               |                          | Рекурсивный поиск                                 |      
| `--dry-run`          |                         |               |                          | Тестовый запуск,<br>изменения не сохраняются      |        
| `--mis-db-server`    | `MIS_DB_SERVER`         | :exclamation: |                          | Адрес сервера МИС                                 |  
| `--mis-db-port`      | `MIS_DB_PORT`           |               | `1433`                   | Порт сервера МИС                                  |    
| `--mis-db-name`      | `MIS_DB_NAME`           | :exclamation: |                          | Наименование базы данных                          |    
| `--mis-db-username`  | `MIS_DB_USERNAME`       |               | `sa`                     | Имя пользователя для<br>подключения к БД МИС      |
| `--mis-db-password`  | `MIS_DB_PASSWORD`       | :exclamation: |                          | Пароль пользователя для<br>подключения к БД МИС   |
| `--mis-file-path`    | `MIS_FILE_PATH`         | :exclamation: |                          | Путь до хранилища<br>прикреплённых файлов МИС     |  
| `--log-path`         | `PMA_LOG_PATH`          |               |                          | Путь для хранения<br>журнала приложения           |         

Ключи `--create-user-id` и `--create-user-name` должны соответствовать полям `UserID` и `FIO` таблицы `x_User`.

Ключи `--file-type-code` и `--file-type-name` должны соответствовать полям `Code` и `Name` таблицы `atf_FileType`. Если совпадение по коду не будет найдено, то программа создаст тип прикрепляемого файла с указанными параметрами. **Внимание!** Поиск типа производится по полю `Code` и используется
первое найденное вхождение.

Ключи `--recursive` и `--dry-run` являются флагами и им **не передаются** значения.

При использовании ключа `--log-path` в указанной директории будет формироваться журнал `debug.log` с ротацией каждые 1 Мб и очисткой данных через 3 месяца.

Получить справку по описанным выше параметрам из командной строки можно запустив утилиту с ключом `--help`:

```shell
pm-attacher --help
```

## Запуск

При запуске необходимо определить обязательные параметры (таблица выше) и указать путь, по которому будет производиться обработка файлов:

```shell
pm-attacher [OPTIONS] WATCH_DIR
```

Для получения информации о названии и версии утилиты необходимо выполнить команду с ключом `--version`:

```shell
pm-attacher --version
```
