"""

RenderPipeline

Copyright (c) 2014-2016 tobspr <tobias.springer1@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

"""

from panda3d.core import SamplerState

from rpcore.render_stage import RenderStage
from rpcore.globals import Globals


class ShadowStage(RenderStage):

    """ This is the stage which renders all shadows """
    required_inputs = []

    def __init__(self, pipeline):
        RenderStage.__init__(self, pipeline)
        self.size = 4096

    @property
    def produced_pipes(self):
        return {
            "ShadowAtlas": self.target.depth_tex,
            "ShadowAtlasPCF": (self.target.depth_tex, self.make_pcf_state()),
        }

    def make_pcf_state(self):
        state = SamplerState()
        state.set_minfilter(SamplerState.FT_shadow)
        state.set_magfilter(SamplerState.FT_shadow)
        return state

    @property
    def atlas_buffer(self):
        return self.target.internal_buffer

    def create(self):
        self.target = self.create_target("ShadowAtlas")
        self.target.size = self.size
        self.target.add_depth_attachment(bits=16)
        self.target.prepare_render(None)

        # Remove all current display regions
        self.target.internal_buffer.remove_all_display_regions()
        self.target.internal_buffer.get_display_region(0).set_active(False)

        # Disable the target, and also disable depth clear
        self.target.active = False
        self.target.internal_buffer.set_clear_depth_active(False)
        self.target.region.set_clear_depth_active(False)

    def set_shader_input(self, *args):
        Globals.render.set_shader_input(*args)

    def set_shader_inputs(self, **kwargs):
        Globals.render.set_shader_inputs(**kwargs)
