# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/04_calib.greg.ipynb (unless otherwise specified).

__all__ = ['StarCalibs', 'filter_spica_for_date']

# Cell
from fastcore.utils import Path
from tqdm.auto import tqdm

import pandas as pd
from planetarypy.utils import nasa_time_to_iso
from ..io import UVPDS, UVISObs
from ..pds import CatalogFilter

# Cell
class StarCalibs:
    star_list = Path(
        "/home/maye/Dropbox/Documents/projects/uvis_pdart/calib/stars_list.txt"
    )

    def __init__(self):
        "Read Greg's file into dataframe and add some meta-columns."
        star_obs = pd.read_table(
            self.star_list, sep="\\s\\s+", index_col=False, engine="python"
        )  # engine kw to avoid warning

        star_obs["detector"] = star_obs.filename.str[:3]
        star_obs["filename_time"] = star_obs.filename.map(
            lambda x: nasa_time_to_iso(
                x[3:20].replace("_", "-", 1).replace("_", "T", 1).replace("_", ":")
            )
        )
        star_obs.filename_time = pd.to_datetime(star_obs.filename_time)
        star_obs["date"] = pd.DatetimeIndex(star_obs.filename_time.dt.date)
        star_obs["product_id"] = star_obs['filename'].str[:17]
        self.obs = star_obs

    @property
    def duplicated(self):
        "Beware, this contains windowed observations as well!"
        df = self.obs
        return df[df.duplicated(subset="product_id", keep=False)]

    @property
    def spicas(self):
        "Filter Greg's list for Spica (alp vir) obs."
        return self.obs.query("name=='alp vir'")

    @property
    def steffls(self):
        "TODO: make sure that's sufficient."
        return self.spicas.query("int==332")

    @property
    def steffl_dates(self):
        return pd.DatetimeIndex(self.steffls.date)

    @property
    def steffl_years(self):
        return self.steffl_dates.year.unique()

    def steffls_by_year(self, year):
        index = self.steffl_dates
        return self.steffls[index.year == int(year)]

    def euv_steffls_by_year(self, year, pids_only=True):
        df = self.steffls_by_year(year)
        df = df[df.detector == "EUV"]
        return df.product_id if pids_only else df

    def fuv_steffls_by_year(self, year, pids_only=True):
        df = self.steffls_by_year(year)
        df =  df[df.detector == "FUV"]
        return df.product_id if pids_only else df

# Cell
def filter_spica_for_date(date: str):  # date in shape of yyyy-mm-dd
    return get_spica_obs().query("date==@date")