# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nonebot_plugin_gachalogs']

package_data = \
{'': ['*']}

install_requires = \
['httpx>=0.20.0,<1.0.0',
 'matplotlib>=3.5.1',
 'nonebot-adapter-onebot>=2.0.0b1',
 'nonebot2>=2.0.0a16',
 'pytz',
 'xlsxwriter>=3.0.2']

setup_kwargs = {
    'name': 'nonebot-plugin-gachalogs',
    'version': '0.2.9',
    'description': 'Genshin gacha history analysis plugin for NoneBot2',
    'long_description': '<h1 align="center">NoneBot Plugin GachaLogs</h1></br>\n\n\n<p align="center">🤖 用于分析与管理原神祈愿记录的 NoneBot2 插件</p></br>\n\n\n<p align="center">\n  <a href="https://github.com/monsterxcn/nonebot-plugin-gachalogs/actions">\n    <img src="https://img.shields.io/github/actions/workflow/status/monsterxcn/nonebot-plugin-gachalogs/publish.yml?branch=main" alt="actions">\n  </a>\n  <a href="https://raw.githubusercontent.com/monsterxcn/nonebot-plugin-gachalogs/master/LICENSE">\n    <img src="https://img.shields.io/github/license/monsterxcn/nonebot-plugin-gachalogs" alt="license">\n  </a>\n  <a href="https://pypi.python.org/pypi/nonebot-plugin-gachalogs">\n    <img src="https://img.shields.io/pypi/v/nonebot-plugin-gachalogs" alt="pypi">\n  </a>\n  <a href="https://www.python.org/">\n    <img src="https://img.shields.io/badge/python-3.8+-blue" alt="python" />\n  </a><br />\n  <a href="https://github.com/psf/black">\n    <img src="https://img.shields.io/badge/code%20style-black-000000.svg" alt="Code style: black" />\n  </a>\n  <a href="https://pycqa.github.io/isort">\n    <img src="https://img.shields.io/badge/%20imports-isort-%231674b1?&labelColor=ef8336" alt="Imports: isort" />\n  </a>\n  <a href="https://results.pre-commit.ci/latest/github/monsterxcn/nonebot-plugin-gachalogs/main">\n    <img src="https://results.pre-commit.ci/badge/github/monsterxcn/nonebot-plugin-gachalogs/main.svg" alt="pre-commit" />\n  </a>\n</p></br>\n\n\n| ![祈愿统计图](https://user-images.githubusercontent.com/22407052/198547014-469865b5-a298-4b91-beb2-645e028a4721.PNG) | ![成就示意图](https://user-images.githubusercontent.com/22407052/210336667-ecb56bcb-42dc-4235-ab17-1e30bea04362.PNG) |\n|:--:|:--:|\n\n\n## 安装方法\n\n\n如果你正在使用 2.0.0.beta1 以上版本 NoneBot2，推荐使用以下命令安装：\n\n\n```bash\n# 从 nb_cli 安装\npython -m nb_cli plugin install nonebot-plugin-gachalogs\n\n# 或从 PyPI 安装\npython -m pip install nonebot-plugin-gachalogs\n```\n\n\n## 使用须知\n\n\n - 初次使用 `抽卡记录` 命令时，要求输入祈愿历史记录链接或米哈游通行证 Cookie。如果初次使用输入链接（只要回复的内容中含有即可，不必手动截取准确的链接），在该链接的 AuthKey 过期（24 小时）后需要重新输入链接或 Cookie 才能刷新数据。如果初次使用输入 Cookie，只要 Cookie 有效，后续使用时祈愿历史记录链接将自动更新，无需再次输入。\n   \n - 插件使用米哈游通行证 Cookie 来自动更新祈愿历史记录链接，该 Cookie 可在 [米哈游通行证](https://user.mihoyo.com/#/login/) 登陆获取，并非一些教程中使用的 [米游社 BBS](https://bbs.mihoyo.com/) Cookie，其中需要包含 `stoken` `stuid` 或 `login_ticket`。\n   \n   你可以参考 [KimigaiiWuyi/GenshinUID#255](https://github.com/KimigaiiWuyi/GenshinUID/issues/255) 等教程获取米哈游通行证 Cookie。此处提供一种获取该 Cookie 的简便方法：\n   \n   1. 在桌面端浏览器新建 **隐身标签页**，后面均在此隐身标签页内操作\n   2. 进入 https://www.miyoushe.com/ys/ 并正常登录\n   3. 进入 http://user.mihoyo.com/ 并正常登录\n   4. 按下 F12 键，切换至「Console / 控制台」页面，在输入处（通常由蓝色「>」符号示意）输入 `document.cookie` 回车，控制台中出现的字符串即为插件需要的 Cookie\n   \n - 一般来说，插件安装完成后无需设置环境变量，只需重启 Bot 即可开始使用。你也可以在 NoneBot2 当前使用的 `.env` 文件中参考 [.env.example](.env.example) 添加下表给出的环境变量，对插件进行更多配置。环境变量修改后需要重启 Bot 才能生效。\n   \n   | 环境变量 | 必需 | 默认 | 说明 |\n   |:-------|:----:|:-----|:----|\n   | `gachalogs_safe_group` | 否 | `[]` | 安全群组，只有在安全群组内才允许输入链接、Cookie 等内容 |\n   | `gacha_expire_sec` | 否 | `3600` | 祈愿历史记录本地缓存过期秒数 |\n   | `resources_dir` | 否 | `/path/to/bot/data/` | 插件缓存目录的父文件夹，包含 `gachalogs` 文件夹的上级文件夹路径 |\n   | `gachalogs_font` | 否 | `/path/to/bot/data/gachalogs/LXGW-Bold.ttf` | 祈愿历史记录绘制字体 |\n   | `gachalogs_pie_font` | 否 | `/path/to/bot/data/gachalogs/LXGW-Bold-minipie.ttf` | 祈愿历史记录绘制饼图字体 |\n   | `gachalogs_achieve_font` | 否 | `/path/to/bot/data/gachalogs/HYWH-85W.ttf` | 祈愿历史记录绘制成就字体 |\n   \n - 在群组中发送米哈游通行证 Cookie 等内容存在安全隐患，因此即使某些命令在群组中触发，处理结果最终也会通过私聊发送。如果用户未添加 Bot 为好友，私聊消息将发送失败。添加安全群组环境变量，即可允许在这些群组中直接发送敏感消息，如果大家不在意的话。\n   \n - commit [`e2f38f3`](https://github.com/monsterxcn/nonebot-plugin-gachalogs/commit/e2f38f30379dac4f98f9314fa012a1272c2dcc95) 之后插件私聊文件发送功能不再依赖腾讯云 COS 转存，只需 go-cqhttp 支持 [上传私聊文件](https://docs.go-cqhttp.org/api/#%E4%B8%8A%E4%BC%A0%E7%A7%81%E8%81%8A%E6%96%87%E4%BB%B6) 接口。因此如果有私聊文件发送需求，务必保证 go-cqhttp 版本不低于 [v1.0.0-rc3](https://github.com/Mrs4s/go-cqhttp/releases/tag/v1.0.0-rc3)。\n   \n - 使用 `抽卡记录导出` 命令生成的表格与 JSON 文件均符合 [统一可交换祈愿记录标准](https://github.com/DGP-Studio/Snap.Genshin/wiki/StandardFormat)（UIGF）格式，你可以尝试在其他支持此标准的工具中导入。导出的祈愿历史记录链接、米哈游通行证 Cookie 在某些地方也许有用。\n   \n - 插件运行后，用户的基本配置信息会写入 `config.json` 文件，祈愿历史记录数据缓存于 `gachalogs-{uid}.json` 文件。\n\n\n## 命令说明\n\n\n - `抽卡记录` / `ckjl`\n   \n   返回一张祈愿历史记录统计图，样式与 https://genshin.voderl.cn/ 一致。\n   \n   | 可选附带参数 | 默认 | 说明 |\n   |:-----------|:-----|:----|\n   | `刷新` / `-f` / `--force` | 空 | 要求强制刷新最新祈愿历史记录，即使本地缓存未过期（结果默认缓存 1 小时） |\n   | 祈愿历史记录链接 | 空 | 指定祈愿历史记录链接（仅初次使用、无法自动更新祈愿历史记录链接时生效） |\n   | 米哈游通行证 Cookie | 空 | 指定米哈游通行证 Cookie（仅初次使用、无法自动更新祈愿历史记录链接时生效） |\n   \n - `抽卡成就` / `ckcj`\n   \n   返回一张祈愿历史记录成就图，样式与 https://genshin.voderl.cn/ 一致。\n   \n - 抽卡记录导入（在私聊或群聊中上传抽卡记录文件）\n   \n   返回导入结果及一张祈愿历史记录统计图。\n   \n   普通用户只允许导入与本地记录（如果有）归属 UID 相同的抽卡记录。超级用户在普通用户规则基础上，还允许为拥有本地记录的其他用户导入 UID 相同的抽卡记录。\n   \n   目前支持导入的文件格式有：\n   \n   + 程序内部缓存格式。导入后执行恢复，即将本地记录直接替换为该文件的记录\n   + UIGF v2.2 格式，并且每条记录必须拥有 `time` `rank_type` 等 UIGF v2.2 标准中定义为非必需的字段。导入后执行合并，即尝试将本地记录与该文件的记录合并\n   \n   如果导入前 *被导入者* 有本地记录，插件会创建一个本地记录备份文件用于意外恢复，并尝试通过私聊将此文件发送给 *被导入者*（如果发送成功则 Bot 在服务器上创建的备份文件会被删除）。一旦发现插件导入后记录异常，*被导入者* 可以直接发送此文件给 Bot 来触发记录恢复。\n   \n - `抽卡记录导出` / `logexp` / `ckjldc`\n   \n   导出祈愿历史记录表格，通过可选附带参数指定导出祈愿历史记录 JSON 文件、祈愿历史记录链接或米哈游通行证 Cookie。\n   \n   | 可选附带参数 | 默认 | 说明 |\n   |:-----------|:-----|:----|\n   | @某人 | **@自己** | 指定导出记录用户，仅 **Bot 管理员** 可导出其他用户的记录 |\n   | `统一` / `标准` / `uigf` / `json` | 空 | 指定导出祈愿历史记录为 JSON 文件 |\n   | `链接` / `地址` / `url` | 空 | 指定导出祈愿历史记录链接 |\n   | `饼干` / `ck` / `cookie` | 空 | 指定导出米哈游通行证 Cookie |\n   \n   ![导出示意图](https://user-images.githubusercontent.com/22407052/187933780-64fa0be4-a43f-40f1-9fa9-88e033e9d372.png)\n   \n - `抽卡记录删除` / `logdel` / `ckjldc`\n   \n   默认只删除本地祈愿历史记录缓存（不会影响 Cookie 等配置数据），即只删除 `gachalogs-{uid}.json` 文件。\n   \n   如果需要连同指定用户在 `config.json` 文件中的配置一起删除，请使用附带参数 `全部` 等。\n   \n   记录、配置一旦删除将无法恢复，所以只有输入中附带了 `确认` 等附带参数时，命令才会真正对本地文件执行删除动作。\n   \n   | 可选附带参数 | 默认 | 说明 |\n   |:-----------|:-----|:----|\n   | @某人 | **@自己** | 指定删除记录或配置的用户，仅 **Bot 管理员** 可删除其他用户的记录或配置 |\n   | `强制` / `确认` / `force` / `-f` / `-y` | 空 | 删除操作确认 |\n   | `全部` / `所有` / `配置` / `all` / `-a` / `config` / `-c` | 空 | 指定删除用户的 **配置和记录** 全部数据 |\n\n\n## 特别鸣谢\n\n\n[@nonebot/nonebot2](https://github.com/nonebot/nonebot2/) | [@Mrs4s/go-cqhttp](https://github.com/Mrs4s/go-cqhttp) | **[@sunfkny/genshin-gacha-export](https://github.com/sunfkny/genshin-gacha-export)** | **[@voderl/genshin-gacha-analyzer](https://github.com/voderl/genshin-gacha-analyzer)** | [@vikiboss/genshin-helper](https://github.com/vikiboss/genshin-helper) | [@DGP-Studio/Snap.Metadata](https://github.com/DGP-Studio/Snap.Metadata)\n',
    'author': 'monsterxcn',
    'author_email': 'monsterxcn@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/monsterxcn/nonebot-plugin-gachalogs',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
