"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const bundling_1 = require("./bundling");
const util_1 = require("./util");
/**
 * A Golang Lambda function
 */
class GoFunction extends lambda.Function {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_go_GoFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GoFunction);
            }
            throw error;
        }
        if (props.runtime && (props.runtime.family !== lambda.RuntimeFamily.GO && props.runtime.family != lambda.RuntimeFamily.OTHER)) {
            throw new Error('Only `go` and `provided` runtimes are supported.');
        }
        const entry = path.resolve(props.entry);
        // Find the project root
        let moduleDir;
        if (props.moduleDir) {
            const parsedModuleDir = path.parse(props.moduleDir);
            if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base === 'go.mod') {
                if (!fs.existsSync(props.moduleDir)) {
                    throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
                }
            }
            else if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base != 'go.mod') {
                throw new Error('moduleDir is specifying a file that is not go.mod');
            }
            else if (!fs.existsSync(path.join(props.moduleDir, 'go.mod'))) {
                throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
            }
            moduleDir = props.moduleDir;
        }
        else {
            const modFile = util_1.findUp('go.mod', entry);
            if (!modFile) {
                throw new Error('Cannot find go.mod. Please specify it with `moduleDir`.');
            }
            moduleDir = modFile;
        }
        const runtime = props.runtime ?? lambda.Runtime.PROVIDED_AL2;
        const architecture = props.architecture ?? lambda.Architecture.X86_64;
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                ...props.bundling ?? {},
                entry,
                runtime,
                architecture,
                moduleDir,
            }),
            handler: 'bootstrap',
        });
    }
}
exports.GoFunction = GoFunction;
_a = JSII_RTTI_SYMBOL_1;
GoFunction[_a] = { fqn: "@aws-cdk/aws-lambda-go.GoFunction", version: "1.184.1" };
/**
 * The address of the Google Go proxy
 */
GoFunction.GOOGLE_GOPROXY = 'https://proxy.golang.org';
//# sourceMappingURL=data:application/json;base64,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