# Generated by Django 4.0.3 on 2022-03-31 17:38

from django.db import migrations, models
import tagulous.models.fields
import tagulous.models.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Tagulous_HostModel_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_BaseTimetrackingTaggedModel_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='HostModel',
            fields=[
                ('create_dt', models.DateTimeField(blank=True, editable=False, help_text='ModelTimetrackingMixin.create_dt.help_text', null=True, verbose_name='ModelTimetrackingMixin.create_dt.verbose_name')),
                ('update_dt', models.DateTimeField(blank=True, editable=False, help_text='ModelTimetrackingMixin.update_dt.help_text', null=True, verbose_name='ModelTimetrackingMixin.update_dt.verbose_name')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='BaseModel.id.help_text', primary_key=True, serialize=False, verbose_name='BaseModel.id.verbose_name')),
                ('mac', models.CharField(db_index=True, help_text='HostModel.mac.help_text', max_length=17, unique=True, verbose_name='HostModel.mac.verbose_name')),
                ('name', models.CharField(help_text='HostModel.name.help_text', max_length=63, verbose_name='HostModel.name.verbose_name')),
                ('last_status', models.BooleanField(help_text='HostModel.last_status.help_text', verbose_name='HostModel.last_status.verbose_name')),
                ('interface_type', models.CharField(blank=True, help_text='HostModel.interface_type.help_text', max_length=8, null=True, verbose_name='HostModel.interface_type.verbose_name')),
                ('address_source', models.CharField(help_text='HostModel.address_source.help_text', max_length=6, verbose_name='HostModel.address_source.verbose_name')),
                ('lease_time_remaining', models.PositiveIntegerField(help_text='HostModel.lease_time_remaining.help_text', verbose_name='HostModel.lease_time_remaining.verbose_name')),
                ('tags', tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, case_sensitive=False, force_lowercase=False, help_text='BaseModel.tags.help_text', max_count=10, space_delimiter=False, to='djfritz.tagulous_hostmodel_tags', verbose_name='BaseModel.tags.verbose_name')),
            ],
            options={
                'verbose_name': 'HostModel.verbose_name',
                'verbose_name_plural': 'HostModel.verbose_name_plural',
            },
        ),
    ]
