from .exceptions import InvalidStyleError


_STYLES_CONVERSION = {
    'Circled': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '⊛', '+': '⊕',',': ',', '-': '⊖', '.': '⨀', '/': '⊘', '0': '0', '1': '①', '2': '②', '3': '③', '4': '④', '5': '⑤', '6': '⑥', '7': '⑦', '8': '⑧', '9': '⑨', ':': ':', ';': ';', '<': '⧀', '=': '⊜', '>': '⧁', '?': '?', '@': '@', 'A': 'Ⓐ', 'B': 'Ⓑ', 'C': 'Ⓒ', 'D': 'Ⓓ', 'E': 'Ⓔ', 'F': 'Ⓕ', 'G': 'Ⓖ', 'H': 'Ⓗ', 'I': 'Ⓘ', 'J': 'Ⓙ', 'K': 'Ⓚ', 'L': 'Ⓛ', 'M': 'Ⓜ', 'N': 'Ⓝ', 'O': 'Ⓞ', 'P': 'Ⓟ', 'Q': 'Ⓠ', 'R': 'Ⓡ', 'S': 'Ⓢ', 'T': 'Ⓣ', 'U': 'Ⓤ', 'V': 'Ⓥ', 'W': 'Ⓦ', 'X': 'Ⓧ', 'Y': 'Ⓨ', 'Z': 'Ⓩ', '[': '[', '\\': '⦸', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'ⓐ', 'b': 'ⓑ', 'c': 'ⓒ', 'd': 'ⓓ', 'e': 'ⓔ', 'f': 'ⓕ', 'g': 'ⓖ', 'h': 'ⓗ', 'i': 'ⓘ', 'j': 'ⓙ', 'k': 'ⓚ', 'l': 'ⓛ', 'm': 'ⓜ', 'n': 'ⓝ', 'o': 'ⓞ', 'p': 'ⓟ', 'q': 'ⓠ', 'r': 'ⓡ', 's': 'ⓢ', 't': 'ⓣ', 'u': 'ⓤ', 'v': 'ⓥ', 'w': 'ⓦ', 'x': 'ⓧ', 'y': 'ⓨ', 'z': 'ⓩ', '{': '{', '|': '⦶', '}': '}', '~': '~', "'": "'"},
    'Circled (neg)': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '⓿', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '🅐', 'B': '🅑', 'C': '🅒', 'D': '🅓', 'E': '🅔', 'F': '🅕', 'G': '🅖', 'H': '🅗', 'I': '🅘', 'J': '🅙', 'K': '🅚', 'L': '🅛', 'M': '🅜', 'N': '🅝', 'O': '🅞', 'P': '🅟', 'Q': '🅠', 'R': '🅡', 'S': '🅢', 'T': '🅣', 'U': '🅤', 'V': '🅥', 'W': '🅦', 'X': '🅧', 'Y': '🅨', 'Z': '🅩', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '🅐', 'b': '🅑', 'c': '🅒', 'd': '🅓', 'e': '🅔', 'f': '🅕', 'g': '🅖', 'h': '🅗', 'i': '🅘', 'j': '🅙', 'k': '🅚', 'l': '🅛', 'm': '🅜', 'n': '🅝', 'o': '🅞', 'p': '🅟', 'q': '🅠', 'r': '🅡', 's': '🅢', 't': '🅣', 'u': '🅤', 'v': '🅥', 'w': '🅦', 'x': '🅧', 'y': '🅨', 'z': '🅩', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Fullwidth': {'!': '！', '"': '"', '#': '＃', '$': '＄', '%': '％', '&': '＆', '(': '（', ')': '）', '*': '＊', '+': '＋', ',': '，', '-': '－', '.': '．', '/': '／', '0': '０', '1': '１', '2': '２', '3': '３', '4': '４', '5': '５', '6': '６', '7': '７', '8': '８', '9': '９', ':': '：', ';': '；', '<': '<', '=': '＝', '>': '>', '?': '？', '@': '＠', 'A': 'Ａ', 'B': 'Ｂ', 'C': 'Ｃ', 'D': 'Ｄ', 'E': 'Ｅ', 'F': 'Ｆ', 'G': 'Ｇ', 'H': 'Ｈ', 'I': 'Ｉ', 'J': 'Ｊ', 'K': 'Ｋ', 'L': 'Ｌ', 'M': 'Ｍ', 'N': 'Ｎ', 'O': 'Ｏ', 'P': 'Ｐ', 'Q': 'Ｑ', 'R': 'Ｒ', 'S': 'Ｓ', 'T': 'Ｔ', 'U': 'Ｕ', 'V': 'Ｖ', 'W': 'Ｗ', 'X': 'Ｘ', 'Y': 'Ｙ', 'Z': 'Ｚ', '[': '［', '\\': '＼', ']': '］', '^': '＾', '_': '＿', '`': '｀', 'a': 'ａ', 'b': 'ｂ', 'c': 'ｃ', 'd': 'ｄ', 'e': 'ｅ', 'f': 'ｆ', 'g': 'ｇ', 'h': 'ｈ', 'i': 'ｉ', 'j': 'ｊ', 'k': 'ｋ', 'l': 'ｌ', 'm': 'ｍ', 'n': 'ｎ', 'o': 'ｏ', 'p': 'ｐ', 'q': 'ｑ', 'r': 'ｒ', 's': 'ｓ', 't': 'ｔ', 'u': 'ｕ', 'v': 'ｖ', 'w': 'ｗ', 'x': 'ｘ', 'y': 'ｙ', 'z': 'ｚ', '{': '｛', '|': '｜', '}': '｝', '~': '～', "'": '＇'},
    'Math bold': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '𝟎', '1': '𝟏', '2': '𝟐', '3': '𝟑', '4': '𝟒', '5': '𝟓', '6': '𝟔', '7': '𝟕', '8': '𝟖', '9': '𝟗', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝐀', 'B': '𝐁', 'C': '𝐂', 'D': '𝐃', 'E': '𝐄', 'F': '𝐅', 'G': '𝐆', 'H': '𝐇', 'I': '𝐈', 'J': '𝐉', 'K': '𝐊', 'L': '𝐋', 'M': '𝐌', 'N': '𝐍', 'O': '𝐎', 'P': '𝐏', 'Q': '𝐐', 'R': '𝐑', 'S': '𝐒', 'T': '𝐓', 'U': '𝐔', 'V': '𝐕', 'W': '𝐖', 'X': '𝐗', 'Y': '𝐘', 'Z': '𝐙', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝐚', 'b': '𝐛', 'c': '𝐜', 'd': '𝐝', 'e': '𝐞', 'f': '𝐟', 'g': '𝐠', 'h': '𝐡', 'i': '𝐢', 'j': '𝐣', 'k': '𝐤', 'l': '𝐥', 'm': '𝐦', 'n': '𝐧', 'o': '𝐨', 'p': '𝐩', 'q': '𝐪', 'r': '𝐫', 's': '𝐬', 't': '𝐭', 'u': '𝐮', 'v': '𝐯', 'w': '𝐰', 'x': '𝐱', 'y': '𝐲', 'z': '𝐳', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Math bold Fraktur': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝕬', 'B': '𝕭', 'C': '𝕮', 'D': '𝕯', 'E': '𝕰', 'F': '𝕱', 'G': '𝕲', 'H': '𝕳', 'I': '𝕴', 'J': '𝕵', 'K': '𝕶', 'L': '𝕷', 'M': '𝕸', 'N': '𝕹', 'O': '𝕺', 'P': '𝕻', 'Q': '𝕼', 'R': '𝕽', 'S': '𝕾', 'T': '𝕿', 'U': '𝖀', 'V': '𝖁', 'W': '𝖂', 'X': '𝖃', 'Y': '𝖄', 'Z': '𝖅', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝖆', 'b': '𝖇', 'c': '𝖈', 'd': '𝖉', 'e': '𝖊', 'f': '𝖋', 'g': '𝖌', 'h': '𝖍', 'i': '𝖎', 'j': '𝖏', 'k': '𝖐', 'l': '𝖑', 'm': '𝖒', 'n': '𝖓', 'o': '𝖔', 'p': '𝖕', 'q': '𝖖', 'r': '𝖗', 's': '𝖘', 't': '𝖙', 'u': '𝖚', 'v': '𝖛', 'w': '𝖜', 'x': '𝖝', 'y': '𝖞', 'z': '𝖟', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Math bold italic': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝑨', 'B': '𝑩', 'C': '𝑪', 'D': '𝑫', 'E': '𝑬', 'F': '𝑭', 'G': '𝑮', 'H': '𝑯', 'I': '𝑰', 'J': '𝑱', 'K': '𝑲', 'L': '𝑳', 'M': '𝑴', 'N': '𝑵', 'O': '𝑶', 'P': '𝑷', 'Q': '𝑸', 'R': '𝑹', 'S': '𝑺', 'T': '𝑻', 'U': '𝑼', 'V': '𝑽', 'W': '𝑾', 'X': '𝑿', 'Y': '𝒀', 'Z': '𝒁', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝒂', 'b': '𝒃', 'c': '𝒄', 'd': '𝒅', 'e': '𝒆', 'f': '𝒇', 'g': '𝒈', 'h': '𝒉', 'i': '𝒊', 'j': '𝒋', 'k': '𝒌', 'l': '𝒍', 'm': '𝒎', 'n': '𝒏', 'o': '𝒐', 'p': '𝒑', 'q': '𝒒', 'r': '𝒓', 's': '𝒔', 't': '𝒕', 'u': '𝒖', 'v': '𝒗', 'w': '𝒘', 'x': '𝒙', 'y': '𝒚', 'z': '𝒛', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Math bold script': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝓐', 'B': '𝓑', 'C': '𝓒', 'D': '𝓓', 'E': '𝓔', 'F': '𝓕', 'G': '𝓖', 'H': '𝓗', 'I': '𝓘', 'J': '𝓙', 'K': '𝓚', 'L': '𝓛', 'M': '𝓜', 'N': '𝓝', 'O': '𝓞', 'P': '𝓟', 'Q': '𝓠', 'R': '𝓡', 'S': '𝓢', 'T': '𝓣', 'U': '𝓤', 'V': '𝓥', 'W': '𝓦', 'X': '𝓧', 'Y': '𝓨', 'Z': '𝓩', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝓪', 'b': '𝓫', 'c': '𝓬', 'd': '𝓭', 'e': '𝓮', 'f': '𝓯', 'g': '𝓰', 'h': '𝓱', 'i': '𝓲', 'j': '𝓳', 'k': '𝓴', 'l': '𝓵', 'm': '𝓶', 'n': '𝓷', 'o': '𝓸', 'p': '𝓹', 'q': '𝓺', 'r': '𝓻', 's': '𝓼', 't': '𝓽', 'u': '𝓾', 'v': '𝓿', 'w': '𝔀', 'x': '𝔁', 'y': '𝔂', 'z': '𝔃', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Math double-struck': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '𝟘', '1': '𝟙', '2': '𝟚', '3': '𝟛', '4': '𝟜', '5': '𝟝', '6': '𝟞', '7': '𝟟', '8': '𝟠', '9': '𝟡', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝔸', 'B': '𝔹', 'C': 'ℂ', 'D': '𝔻', 'E': '𝔼', 'F': '𝔽', 'G': '𝔾', 'H': 'ℍ', 'I': '𝕀', 'J': '𝕁', 'K': '𝕂', 'L': '𝕃', 'M': '𝕄', 'N': 'ℕ', 'O': '𝕆', 'P': 'ℙ', 'Q': 'ℚ', 'R': 'ℝ', 'S': '𝕊', 'T': '𝕋', 'U': '𝕌', 'V': '𝕍', 'W': '𝕎', 'X': '𝕏', 'Y': '𝕐', 'Z': 'ℤ', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝕒', 'b': '𝕓', 'c': '𝕔', 'd': '𝕕', 'e': '𝕖', 'f': '𝕗', 'g': '𝕘', 'h': '𝕙', 'i': '𝕚', 'j': '𝕛', 'k': '𝕜', 'l': '𝕝', 'm': '𝕞', 'n': '𝕟', 'o': '𝕠', 'p': '𝕡', 'q': '𝕢', 'r': '𝕣', 's': '𝕤', 't': '𝕥', 'u': '𝕦', 'v': '𝕧', 'w': '𝕨', 'x': '𝕩', 'y': '𝕪', 'z': '𝕫', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Math monospace': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '𝟶', '1': '𝟷', '2': '𝟸', '3': '𝟹', '4': '𝟺', '5': '𝟻', '6': '𝟼', '7': '𝟽', '8': '𝟾', '9': '𝟿', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝙰', 'B': '𝙱', 'C': '𝙲', 'D': '𝙳', 'E': '𝙴', 'F': '𝙵', 'G': '𝙶', 'H': '𝙷', 'I': '𝙸', 'J': '𝙹', 'K': '𝙺', 'L': '𝙻', 'M': '𝙼', 'N': '𝙽', 'O': '𝙾', 'P': '𝙿', 'Q': '𝚀', 'R': '𝚁', 'S': '𝚂', 'T': '𝚃', 'U': '𝚄', 'V': '𝚅', 'W': '𝚆', 'X': '𝚇', 'Y': '𝚈', 'Z': '𝚉', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝚊', 'b': '𝚋', 'c': '𝚌', 'd': '𝚍', 'e': '𝚎', 'f': '𝚏', 'g': '𝚐', 'h': '𝚑', 'i': '𝚒', 'j': '𝚓', 'k': '𝚔', 'l': '𝚕', 'm': '𝚖', 'n': '𝚗', 'o': '𝚘', 'p': '𝚙', 'q': '𝚚', 'r': '𝚛', 's': '𝚜', 't': '𝚝', 'u': '𝚞', 'v': '𝚟', 'w': '𝚠', 'x': '𝚡', 'y': '𝚢', 'z': '𝚣', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Math sans': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '𝟢', '1': '𝟣', '2': '𝟤', '3': '𝟥', '4': '𝟦', '5': '𝟧', '6': '𝟨', '7': '𝟩', '8': '𝟪', '9': '𝟫', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝖠', 'B': '𝖡', 'C': '𝖢', 'D': '𝖣', 'E': '𝖤', 'F': '𝖥', 'G': '𝖦', 'H': '𝖧', 'I': '𝖨', 'J': '𝖩', 'K': '𝖪', 'L': '𝖫', 'M': '𝖬', 'N': '𝖭', 'O': '𝖮', 'P': '𝖯', 'Q': '𝖰', 'R': '𝖱', 'S': '𝖲', 'T': '𝖳', 'U': '𝖴', 'V': '𝖵', 'W': '𝖶', 'X': '𝖷', 'Y': '𝖸', 'Z': '𝖹', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝖺', 'b': '𝖻', 'c': '𝖼', 'd': '𝖽', 'e': '𝖾', 'f': '𝖿', 'g': '𝗀', 'h': '𝗁', 'i': '𝗂', 'j': '𝗃', 'k': '𝗄', 'l': '𝗅', 'm': '𝗆', 'n': '𝗇', 'o': '𝗈', 'p': '𝗉', 'q': '𝗊', 'r': '𝗋', 's': '𝗌', 't': '𝗍', 'u': '𝗎', 'v': '𝗏', 'w': '𝗐', 'x': '𝗑', 'y': '𝗒', 'z': '𝗓', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Math sans bold': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '𝟬', '1': '𝟭', '2': '𝟮', '3': '𝟯', '4': '𝟰', '5': '𝟱', '6': '𝟲', '7': '𝟳', '8': '𝟴', '9': '𝟵', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝗔', 'B': '𝗕', 'C': '𝗖', 'D': '𝗗', 'E': '𝗘', 'F': '𝗙', 'G': '𝗚', 'H': '𝗛', 'I': '𝗜', 'J': '𝗝', 'K': '𝗞', 'L': '𝗟', 'M': '𝗠', 'N': '𝗡', 'O': '𝗢', 'P': '𝗣', 'Q': '𝗤', 'R': '𝗥', 'S': '𝗦', 'T': '𝗧', 'U': '𝗨', 'V': '𝗩', 'W': '𝗪', 'X': '𝗫', 'Y': '𝗬', 'Z': '𝗭', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝗮', 'b': '𝗯', 'c': '𝗰', 'd': '𝗱', 'e': '𝗲', 'f': '𝗳', 'g': '𝗴', 'h': '𝗵', 'i': '𝗶', 'j': '𝗷', 'k': '𝗸', 'l': '𝗹', 'm': '𝗺', 'n': '𝗻', 'o': '𝗼', 'p': '𝗽', 'q': '𝗾', 'r': '𝗿', 's': '𝘀', 't': '𝘁', 'u': '𝘂', 'v': '𝘃', 'w': '𝘄', 'x': '𝘅', 'y': '𝘆', 'z': '𝘇', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Math sans bold italic': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝘼', 'B': '𝘽', 'C': '𝘾', 'D': '𝘿', 'E': '𝙀', 'F': '𝙁', 'G': '𝙂', 'H': '𝙃', 'I': '𝙄', 'J': '𝙅', 'K': '𝙆', 'L': '𝙇', 'M': '𝙈', 'N': '𝙉', 'O': '𝙊', 'P': '𝙋', 'Q': '𝙌', 'R': '𝙍', 'S': '𝙎', 'T': '𝙏', 'U': '𝙐', 'V': '𝙑', 'W': '𝙒', 'X': '𝙓', 'Y': '𝙔', 'Z': '𝙕', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝙖', 'b': '𝙗', 'c': '𝙘', 'd': '𝙙', 'e': '𝙚', 'f': '𝙛', 'g': '𝙜', 'h': '𝙝', 'i': '𝙞', 'j': '𝙟', 'k': '𝙠', 'l': '𝙡', 'm': '𝙢', 'n': '𝙣', 'o': '𝙤', 'p': '𝙥', 'q': '𝙦', 'r': '𝙧', 's': '𝙨', 't': '𝙩', 'u': '𝙪', 'v': '𝙫', 'w': '𝙬', 'x': '𝙭', 'y': '𝙮', 'z': '𝙯', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Math sans italic': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝘈', 'B': '𝘉', 'C': '𝘊', 'D': '𝘋', 'E': '𝘌', 'F': '𝘍', 'G': '𝘎', 'H': '𝘏', 'I': '𝘐', 'J': '𝘑', 'K': '𝘒', 'L': '𝘓', 'M': '𝘔', 'N': '𝘕', 'O': '𝘖', 'P': '𝘗', 'Q': '𝘘', 'R': '𝘙', 'S': '𝘚', 'T': '𝘛', 'U': '𝘜', 'V': '𝘝', 'W': '𝘞', 'X': '𝘟', 'Y': '𝘠', 'Z': '𝘡', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝘢', 'b': '𝘣', 'c': '𝘤', 'd': '𝘥', 'e': '𝘦', 'f': '𝘧', 'g': '𝘨', 'h': '𝘩', 'i': '𝘪', 'j': '𝘫', 'k': '𝘬', 'l': '𝘭', 'm': '𝘮', 'n': '𝘯', 'o': '𝘰', 'p': '𝘱', 'q': '𝘲', 'r': '𝘳', 's': '𝘴', 't': '𝘵', 'u': '𝘶', 'v': '𝘷', 'w': '𝘸', 'x': '𝘹', 'y': '𝘺', 'z': '𝘻', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Parenthesized': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '⑴', '2': '⑵', '3': '⑶', '4': '⑷', '5': '⑸', '6': '⑹', '7': '⑺', '8': '⑻', '9': '⑼', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '⒜', 'B': '⒝', 'C': '⒞', 'D': '⒟', 'E': '⒠', 'F': '⒡', 'G': '⒢', 'H': '⒣', 'I': '⒤', 'J': '⒥', 'K': '⒦', 'L': '⒧', 'M': '⒨', 'N': '⒩', 'O': '⒪', 'P': '⒫', 'Q': '⒬', 'R': '⒭', 'S': '⒮', 'T': '⒯', 'U': '⒰', 'V': '⒱', 'W': '⒲', 'X': '⒳', 'Y': '⒴', 'Z': '⒵', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '⒜', 'b': '⒝', 'c': '⒞', 'd': '⒟', 'e': '⒠', 'f': '⒡', 'g': '⒢', 'h': '⒣', 'i': '⒤', 'j': '⒥', 'k': '⒦', 'l': '⒧', 'm': '⒨', 'n': '⒩', 'o': '⒪', 'p': '⒫', 'q': '⒬', 'r': '⒭', 's': '⒮', 't': '⒯', 'u': '⒰', 'v': '⒱', 'w': '⒲', 'x': '⒳', 'y': '⒴', 'z': '⒵', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Regional Indicator': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '🇦', 'B': '🇧', 'C': '🇨', 'D': '🇩', 'E': '🇪', 'F': '🇫', 'G': '🇬', 'H': '🇭', 'I': '🇮', 'J': '🇯', 'K': '🇰', 'L': '🇱', 'M': '🇲', 'N': '🇳', 'O': '🇴', 'P': '🇵', 'Q': '🇶', 'R': '🇷', 'S': '🇸', 'T': '🇹', 'U': '🇺', 'V': '🇻', 'W': '🇼', 'X': '🇽', 'Y': '🇾', 'Z': '🇿', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '🇦', 'b': '🇧', 'c': '🇨', 'd': '🇩', 'e': '🇪', 'f': '🇫', 'g': '🇬', 'h': '🇭', 'i': '🇮', 'j': '🇯', 'k': '🇰', 'l': '🇱', 'm': '🇲', 'n': '🇳', 'o': '🇴', 'p': '🇵', 'q': '🇶', 'r': '🇷', 's': '🇸', 't': '🇹', 'u': '🇺', 'v': '🇻', 'w': '🇼', 'x': '🇽', 'y': '🇾', 'z': '🇿', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Squared': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '⧆', '+': '⊞', ',': ',', '-': '⊟', '.': '⊡', '/': '⧄', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '🄰', 'B': '🄱', 'C': '🄲', 'D': '🄳', 'E': '🄴', 'F': '🄵', 'G': '🄶', 'H': '🄷', 'I': '🄸', 'J': '🄹', 'K': '🄺', 'L': '🄻', 'M': '🄼', 'N': '🄽', 'O': '🄾', 'P': '🄿', 'Q': '🅀', 'R': '🅁', 'S': '🅂', 'T': '🅃', 'U': '🅄', 'V': '🅅', 'W': '🅆', 'X': '🅇', 'Y': '🅈', 'Z': '🅉', '[': '[', '\\': '⧅', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '🄰', 'b': '🄱', 'c': '🄲', 'd': '🄳', 'e': '🄴', 'f': '🄵', 'g': '🄶', 'h': '🄷', 'i': '🄸', 'j': '🄹', 'k': '🄺', 'l': '🄻', 'm': '🄼', 'n': '🄽', 'o': '🄾', 'p': '🄿', 'q': '🅀', 'r': '🅁', 's': '🅂', 't': '🅃', 'u': '🅄', 'v': '🅅', 'w': '🅆', 'x': '🅇', 'y': '🅈', 'z': '🅉', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Squared (neg)': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '🅰', 'B': '🅱', 'C': '🅲', 'D': '🅳', 'E': '🅴', 'F': '🅵', 'G': '🅶', 'H': '🅷', 'I': '🅸', 'J': '🅹', 'K': '🅺', 'L': '🅻', 'M': '🅼', 'N': '🅽', 'O': '🅾', 'P': '🅿', 'Q': '🆀', 'R': '🆁', 'S': '🆂', 'T': '🆃', 'U': '🆄', 'V': '🆅', 'W': '🆆', 'X': '🆇', 'Y': '🆈', 'Z': '🆉', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '🅰', 'b': '🅱', 'c': '🅲', 'd': '🅳', 'e': '🅴', 'f': '🅵', 'g': '🅶', 'h': '🅷', 'i': '🅸', 'j': '🅹', 'k': '🅺', 'l': '🅻', 'm': '🅼', 'n': '🅽', 'o': '🅾', 'p': '🅿', 'q': '🆀', 'r': '🆁', 's': '🆂', 't': '🆃', 'u': '🆄', 'v': '🆅', 'w': '🆆', 'x': '🆇', 'y': '🆈', 'z': '🆉', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Tag': {'!': '\U000e0020', '"': '\U000e0021', '#': '"', '$': '\U000e0023', '%': '\U000e0024', '&': '\U000e0025', '(': '\U000e0026', ')': '\U000e0028', '*': '\U000e0029', '+': '\U000e002a', ',': '\U000e002b', '-': '\U000e002c', '.': '\U000e002d', '/': '\U000e002e', '0': '\U000e002f', '1': '\U000e0030', '2': '\U000e0031', '3': '\U000e0032', '4': '\U000e0033', '5': '\U000e0034', '6': '\U000e0035', '7': '\U000e0036', '8': '\U000e0037', '9': '\U000e0038', ':': '\U000e0039', ';': '\U000e003a', '<': '\U000e003b', '=': '<', '>': '\U000e003d', '?': '>', '@': '\U000e003f', 'A': '\U000e0040', 'B': '\U000e0041', 'C': '\U000e0042', 'D': '\U000e0043', 'E': '\U000e0044', 'F': '\U000e0045', 'G': '\U000e0046', 'H': '\U000e0047', 'I': '\U000e0048', 'J': '\U000e0049', 'K': '\U000e004a', 'L': '\U000e004b', 'M': '\U000e004c', 'N': '\U000e004d', 'O': '\U000e004e', 'P': '\U000e004f', 'Q': '\U000e0050', 'R': '\U000e0051', 'S': '\U000e0052', 'T': '\U000e0053', 'U': '\U000e0054', 'V': '\U000e0055', 'W': '\U000e0056', 'X': '\U000e0057', 'Y': '\U000e0058', 'Z': '\U000e0059', '[': '\U000e005a', '\\': '\U000e005b', ']': '\U000e005c', '^': '\U000e005d', '_': '\U000e005e', '`': '\U000e005f', 'a': '\U000e0060', 'b': '\U000e0061', 'c': '\U000e0062', 'd': '\U000e0063', 'e': '\U000e0064', 'f': '\U000e0065', 'g': '\U000e0066', 'h': '\U000e0067', 'i': '\U000e0068', 'j': '\U000e0069', 'k': '\U000e006a', 'l': '\U000e006b', 'm': '\U000e006c', 'n': '\U000e006d', 'o': '\U000e006e', 'p': '\U000e006f', 'q': '\U000e0070', 'r': '\U000e0071', 's': '\U000e0072', 't': '\U000e0073', 'u': '\U000e0074', 'v': '\U000e0075', 'w': '\U000e0076', 'x': '\U000e0077', 'y': '\U000e0078', 'z': '\U000e0079', '{': '\U000e007a', '|': '\U000e007b', '}': '\U000e007c', '~': '\U000e007d', "'": '\U000e007e'},
    'A-cute pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'Á', 'B': 'B', 'C': 'Ć', 'D': 'D', 'E': 'É', 'F': 'F', 'G': 'Ǵ', 'H': 'H', 'I': 'í', 'J': 'J', 'K': 'Ḱ', 'L': 'Ĺ', 'M': 'Ḿ', 'N': 'Ń', 'O': 'Ő', 'P': 'Ṕ', 'Q': 'Q', 'R': 'Ŕ', 'S': 'ś', 'T': 'T', 'U': 'Ű', 'V': 'V', 'W': 'Ẃ', 'X': 'X', 'Y': 'Ӳ', 'Z': 'Ź', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'á', 'b': 'b', 'c': 'ć', 'd': 'd', 'e': 'é', 'f': 'f', 'g': 'ǵ', 'h': 'h', 'i': 'í', 'j': 'j', 'k': 'ḱ', 'l': 'ĺ', 'm': 'ḿ', 'n': 'ń', 'o': 'ő', 'p': 'ṕ', 'q': 'q', 'r': 'ŕ', 's': 'ś', 't': 't', 'u': 'ú', 'v': 'v', 'w': 'ẃ', 'x': 'x', 'y': 'ӳ', 'z': 'ź', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'CJK+Thai pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'ﾑ', 'B': '乃', 'C': 'c', 'D': 'd', 'E': '乇', 'F': 'ｷ', 'G': 'g', 'H': 'ん', 'I': 'ﾉ', 'J': 'ﾌ', 'K': 'ズ', 'L': 'ﾚ', 'M': 'ﾶ', 'N': '刀', 'O': 'o', 'P': 'ｱ', 'Q': 'q', 'R': '尺', 'S': '丂', 'T': 'ｲ', 'U': 'u', 'V': '√', 'W': 'w', 'X': 'ﾒ', 'Y': 'ﾘ', 'Z': '乙', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'ﾑ', 'b': '乃', 'c': 'c', 'd': 'd', 'e': '乇', 'f': 'ｷ', 'g': 'g', 'h': 'ん', 'i': 'ﾉ', 'j': 'ﾌ', 'k': 'ズ', 'l': 'ﾚ', 'm': 'ﾶ', 'n': '刀', 'o': 'o', 'p': 'ｱ', 'q': 'q', 'r': '尺', 's': '丂', 't': 'ｲ', 'u': 'u', 'v': '√', 'w': 'w', 'x': 'ﾒ', 'y': 'ﾘ', 'z': '乙', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Curvy 1 pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '܁', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'ค', 'B': '๒', 'C': 'ƈ', 'D': 'ɗ', 'E': 'ﻉ', 'F': 'ि', 'G': 'ﻭ', 'H': 'ɦ', 'I': 'ٱ', 'J': 'ﻝ', 'K': 'ᛕ', 'L': 'ɭ', 'M': '๓', 'N': 'ก', 'O': 'ѻ', 'P': 'ρ', 'Q': '۹', 'R': 'ɼ', 'S': 'ร', 'T': 'Շ', 'U': 'પ', 'V': '۷', 'W': 'ฝ', 'X': 'ซ', 'Y': 'ץ', 'Z': 'չ', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'ค', 'b': '๒', 'c': 'ƈ', 'd': 'ɗ', 'e': 'ﻉ', 'f': 'ि', 'g': 'ﻭ', 'h': 'ɦ', 'i': 'ٱ', 'j': 'ﻝ', 'k': 'ᛕ', 'l': 'ɭ', 'm': '๓', 'n': 'ก', 'o': 'ѻ', 'p': 'ρ', 'q': '۹', 'r': 'ɼ', 's': 'ร', 't': 'Շ', 'u': 'પ', 'v': '۷', 'w': 'ฝ', 'x': 'ซ', 'y': 'ץ', 'z': 'չ', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Curvy 2 pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'α', 'B': 'в', 'C': '¢', 'D': '∂', 'E': 'є', 'F': 'ƒ', 'G': 'ﻭ', 'H': 'н', 'I': 'ι', 'J': 'נ', 'K': 'к', 'L': 'ℓ', 'M': 'м', 'N': 'η', 'O': 'σ', 'P': 'ρ', 'Q': '۹', 'R': 'я', 'S': 'ѕ', 'T': 'т', 'U': 'υ', 'V': 'ν', 'W': 'ω', 'X': 'χ', 'Y': 'у', 'Z': 'չ', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'α', 'b': 'в', 'c': '¢', 'd': '∂', 'e': 'є', 'f': 'ƒ', 'g': 'ﻭ', 'h': 'н', 'i': 'ι', 'j': 'נ', 'k': 'к', 'l': 'ℓ', 'm': 'м', 'n': 'η', 'o': 'σ', 'p': 'ρ', 'q': '۹', 'r': 'я', 's': 'ѕ', 't': 'т', 'u': 'υ', 'v': 'ν', 'w': 'ω', 'x': 'χ', 'y': 'у', 'z': 'չ', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Curvy 3 pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'ค', 'B': '๒', 'C': 'ς', 'D': '๔', 'E': 'є', 'F': 'Ŧ', 'G': 'ﻮ', 'H': 'ђ', 'I': 'เ', 'J': 'ן', 'K': 'к', 'L': 'ɭ', 'M': '๓', 'N': 'ภ', 'O': '๏', 'P': 'ק', 'Q': 'ợ', 'R': 'г', 'S': 'ร', 'T': 'Շ', 'U': 'ย', 'V': 'ש', 'W': 'ฬ', 'X': 'א', 'Y': 'ץ', 'Z': 'չ', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'ค', 'b': '๒', 'c': 'ς', 'd': '๔', 'e': 'є', 'f': 'Ŧ', 'g': 'ﻮ', 'h': 'ђ', 'i': 'เ', 'j': 'ן', 'k': 'к', 'l': 'ɭ', 'm': '๓', 'n': 'ภ', 'o': '๏', 'p': 'ק', 'q': 'ợ', 'r': 'г', 's': 'ร', 't': 'Շ', 'u': 'ย', 'v': 'ש', 'w': 'ฬ', 'x': 'א', 'y': 'ץ', 'z': 'չ', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Faux Cyrillic pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'Д', 'B': 'Б', 'C': 'Ҁ', 'D': 'ↁ', 'E': 'Є', 'F': 'F', 'G': 'Б', 'H': 'Н', 'I': 'І', 'J': 'Ј', 'K': 'Ќ', 'L': 'L', 'M': 'М', 'N': 'И', 'O': 'Ф', 'P': 'Р', 'Q': 'Q', 'R': 'Я', 'S': 'Ѕ', 'T': 'Г', 'U': 'Ц', 'V': 'V', 'W': 'Щ', 'X': 'Ж', 'Y': 'Ч', 'Z': 'Z', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'а', 'b': 'ъ', 'c': 'с', 'd': 'ↁ', 'e': 'э', 'f': 'f', 'g': 'Б', 'h': 'Ђ', 'i': 'і', 'j': 'ј', 'k': 'к', 'l': 'l', 'm': 'м', 'n': 'и', 'o': 'о', 'p': 'р', 'q': 'q', 'r': 'ѓ', 's': 'ѕ', 't': 'т', 'u': 'ц', 'v': 'v', 'w': 'ш', 'x': 'х', 'y': 'Ў', 'z': 'z', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Faux Ethiopic pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'ል', 'B': 'ጌ', 'C': 'ር', 'D': 'ዕ', 'E': 'ቿ', 'F': 'ቻ', 'G': 'ኗ', 'H': 'ዘ', 'I': 'ጎ', 'J': 'ጋ', 'K': 'ጕ', 'L': 'ረ', 'M': 'ጠ', 'N': 'ክ', 'O': 'ዐ', 'P': 'የ', 'Q': 'ዒ', 'R': 'ዪ', 'S': 'ነ', 'T': 'ፕ', 'U': 'ሁ', 'V': 'ሀ', 'W': 'ሠ', 'X': 'ሸ', 'Y': 'ሃ', 'Z': 'ጊ', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'ል', 'b': 'ጌ', 'c': 'ር', 'd': 'ዕ', 'e': 'ቿ', 'f': 'ቻ', 'g': 'ኗ', 'h': 'ዘ', 'i': 'ጎ', 'j': 'ጋ', 'k': 'ጕ', 'l': 'ረ', 'm': 'ጠ', 'n': 'ክ', 'o': 'ዐ', 'p': 'የ', 'q': 'ዒ', 'r': 'ዪ', 's': 'ነ', 't': 'ፕ', 'u': 'ሁ', 'v': 'ሀ', 'w': 'ሠ', 'x': 'ሸ', 'y': 'ሃ', 'z': 'ጊ', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Math Fraktur pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': '𝔄', 'B': '𝔅', 'C': 'ℭ', 'D': '𝔇', 'E': '𝔈', 'F': '𝔉', 'G': '𝔊', 'H': 'ℌ', 'I': 'ℑ', 'J': '𝔍', 'K': '𝔎', 'L': '𝔏', 'M': '𝔐', 'N': '𝔑', 'O': '𝔒', 'P': '𝔓', 'Q': '𝔔', 'R': 'ℜ', 'S': '𝔖', 'T': '𝔗', 'U': '𝔘', 'V': '𝔙', 'W': '𝔚', 'X': '𝔛', 'Y': '𝔜', 'Z': 'ℨ', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': '𝔞', 'b': '𝔟', 'c': '𝔠', 'd': '𝔡', 'e': '𝔢', 'f': '𝔣', 'g': '𝔤', 'h': '𝔥', 'i': '𝔦', 'j': '𝔧', 'k': '𝔨', 'l': '𝔩', 'm': '𝔪', 'n': '𝔫', 'o': '𝔬', 'p': '𝔭', 'q': '𝔮', 'r': '𝔯', 's': '𝔰', 't': '𝔱', 'u': '𝔲', 'v': '𝔳', 'w': '𝔴', 'x': '𝔵', 'y': '𝔶', 'z': '𝔷', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Rock Dots pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '⸚', '.': '∵', '/': '/', '0': '0', '1': '1', '2': '2', '3': 'ӟ', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'Ä', 'B': 'Ḅ', 'C': 'Ċ', 'D': 'Ḋ', 'E': 'Ё', 'F': 'Ḟ', 'G': 'Ġ', 'H': 'Ḧ', 'I': 'Ї', 'J': 'J', 'K': 'Ḳ', 'L': 'Ḷ', 'M': 'Ṁ', 'N': 'Ṅ', 'O': 'Ö', 'P': 'Ṗ', 'Q': 'Q', 'R': 'Ṛ', 'S': 'Ṡ', 'T': 'Ṫ', 'U': 'Ü', 'V': 'Ṿ', 'W': 'Ẅ', 'X': 'Ẍ', 'Y': 'Ÿ', 'Z': 'Ż', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'ä', 'b': 'ḅ', 'c': 'ċ', 'd': 'ḋ', 'e': 'ë', 'f': 'ḟ', 'g': 'ġ', 'h': 'ḧ', 'i': 'ï', 'j': 'j', 'k': 'ḳ', 'l': 'ḷ', 'm': 'ṁ', 'n': 'ṅ', 'o': 'ö', 'p': 'ṗ', 'q': 'q', 'r': 'ṛ', 's': 'ṡ', 't': 'ẗ', 'u': 'ü', 'v': 'ṿ', 'w': 'ẅ', 'x': 'ẍ', 'y': 'ÿ', 'z': 'ż', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Small Caps pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'ᴀ', 'B': 'ʙ', 'C': 'ᴄ', 'D': 'ᴅ', 'E': 'ᴇ', 'F': 'ꜰ', 'G': 'ɢ', 'H': 'ʜ', 'I': 'ɪ', 'J': 'ᴊ', 'K': 'ᴋ', 'L': 'ʟ', 'M': 'ᴍ', 'N': 'ɴ', 'O': 'ᴏ', 'P': 'ᴩ', 'Q': 'Q', 'R': 'ʀ', 'S': 'ꜱ', 'T': 'ᴛ', 'U': 'ᴜ', 'V': 'ᴠ', 'W': 'ᴡ', 'X': 'x', 'Y': 'Y', 'Z': 'ᴢ', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'ᴀ', 'b': 'ʙ', 'c': 'ᴄ', 'd': 'ᴅ', 'e': 'ᴇ', 'f': 'ꜰ', 'g': 'ɢ', 'h': 'ʜ', 'i': 'ɪ', 'j': 'ᴊ', 'k': 'ᴋ', 'l': 'ʟ', 'm': 'ᴍ', 'n': 'ɴ', 'o': 'ᴏ', 'p': 'ᴩ', 'q': 'q', 'r': 'ʀ', 's': 'ꜱ', 't': 'ᴛ', 'u': 'ᴜ', 'v': 'ᴠ', 'w': 'ᴡ', 'x': 'x', 'y': 'y', 'z': 'ᴢ', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Stroked pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '1', '2': 'ƻ', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'Ⱥ', 'B': 'Ƀ', 'C': 'Ȼ', 'D': 'Đ', 'E': 'Ɇ', 'F': 'F', 'G': 'Ǥ', 'H': 'Ħ', 'I': 'Ɨ', 'J': 'Ɉ', 'K': 'Ꝁ', 'L': 'Ł', 'M': 'M', 'N': 'N', 'O': 'Ø', 'P': 'Ᵽ', 'Q': 'Ꝗ', 'R': 'Ɍ', 'S': 'S', 'T': 'Ŧ', 'U': 'ᵾ', 'V': 'V', 'W': 'W', 'X': 'X', 'Y': 'Ɏ', 'Z': 'Ƶ', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'Ⱥ', 'b': 'ƀ', 'c': 'ȼ', 'd': 'đ', 'e': 'ɇ', 'f': 'f', 'g': 'ǥ', 'h': 'ħ', 'i': 'ɨ', 'j': 'ɉ', 'k': 'ꝁ', 'l': 'ł', 'm': 'm', 'n': 'n', 'o': 'ø', 'p': 'ᵽ', 'q': 'ꝗ', 'r': 'ɍ', 's': 's', 't': 'ŧ', 'u': 'ᵾ', 'v': 'v', 'w': 'w', 'x': 'x', 'y': 'ɏ', 'z': 'ƶ', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Subscript pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '₀', '1': '₁', '2': '₂', '3': '₃', '4': '₄', '5': '₅', '6': '₆', '7': '₇', '8': '₈', '9': '₉', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'ₐ', 'B': 'B', 'C': 'C', 'D': 'D', 'E': 'ₑ', 'F': 'F', 'G': 'G', 'H': 'ₕ', 'I': 'ᵢ', 'J': 'ⱼ', 'K': 'ₖ', 'L': 'ₗ', 'M': 'ₘ', 'N': 'ₙ', 'O': 'ₒ', 'P': 'ₚ', 'Q': 'Q', 'R': 'ᵣ', 'S': 'ₛ', 'T': 'ₜ', 'U': 'ᵤ', 'V': 'ᵥ', 'W': 'W', 'X': 'ₓ', 'Y': 'Y', 'Z': 'Z', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'ₐ', 'b': 'b', 'c': 'c', 'd': 'd', 'e': 'ₑ', 'f': 'f', 'g': 'g', 'h': 'ₕ', 'i': 'ᵢ', 'j': 'ⱼ', 'k': 'ₖ', 'l': 'ₗ', 'm': 'ₘ', 'n': 'ₙ', 'o': 'ₒ', 'p': 'ₚ', 'q': 'q', 'r': 'ᵣ', 's': 'ₛ', 't': 'ₜ', 'u': 'ᵤ', 'v': 'ᵥ', 'w': 'w', 'x': 'ₓ', 'y': 'y', 'z': 'z', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Superscript pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '⁰', '1': '¹', '2': '²', '3': '³', '4': '⁴', '5': '⁵', '6': '⁶', '7': '⁷', '8': '⁸', '9': '⁹', ':': ':', ';': ';', '<': '<', '=': '=', '>': '>', '?': '?', '@': '@', 'A': 'ᴬ', 'B': 'ᴮ', 'C': 'ᶜ', 'D': 'ᴰ', 'E': 'ᴱ', 'F': 'ᶠ', 'G': 'ᴳ', 'H': 'ᴴ', 'I': 'ᴵ', 'J': 'ᴶ', 'K': 'ᴷ', 'L': 'ᴸ', 'M': 'ᴹ', 'N': 'ᴺ', 'O': 'ᴼ', 'P': 'ᴾ', 'Q': 'Q', 'R': 'ᴿ', 'S': 'ˢ', 'T': 'ᵀ', 'U': 'ᵁ', 'V': 'ⱽ', 'W': 'ᵂ', 'X': 'ˣ', 'Y': 'ʸ', 'Z': 'ᶻ', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'ᵃ', 'b': 'ᵇ', 'c': 'ᶜ', 'd': 'ᵈ', 'e': 'ᵉ', 'f': 'ᶠ', 'g': 'ᵍ', 'h': 'ʰ', 'i': 'ⁱ', 'j': 'ʲ', 'k': 'ᵏ', 'l': 'ˡ', 'm': 'ᵐ', 'n': 'ⁿ', 'o': 'ᵒ', 'p': 'ᵖ', 'q': 'q', 'r': 'ʳ', 's': 'ˢ', 't': 'ᵗ', 'u': 'ᵘ', 'v': 'ᵛ', 'w': 'ʷ', 'x': 'ˣ', 'y': 'ʸ', 'z': 'ᶻ', '{': '{', '|': '|', '}': '}', '~': '~', "'": "'"},
    'Reversed pseudoalphabet': {'!': '!', '"': '"', '#': '#', '$': '$', '%': '%', '&': '&', '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', '-': '-', '.': '.', '/': '/', '0': '0', '1': '߁', '2': '2', '3': '3', '4': '4', '5': '5', '6': '6', '7': '7', '8': '8', '9': '9', ':': ':', ';': '⁏', '<': '<', '=': '=', '>': '>', '?': '⸮', '@': '@', 'A': 'A', 'B': 'd', 'C': 'Ↄ', 'D': 'b', 'E': 'Ǝ', 'F': 'ꟻ', 'G': 'G', 'H': 'H', 'I': 'I', 'J': 'J', 'K': 'K', 'L': '⅃', 'M': 'M', 'N': 'ᴎ', 'O': 'O', 'P': 'ꟼ', 'Q': 'p', 'R': 'ᴙ', 'S': 'Ꙅ', 'T': 'T', 'U': 'U', 'V': 'V', 'W': 'W', 'X': 'X', 'Y': 'Y', 'Z': 'Z', '[': '[', '\\': '\\', ']': ']', '^': '^', '_': '_', '`': '`', 'a': 'A', 'b': 'd', 'c': 'ↄ', 'd': 'b', 'e': 'ɘ', 'f': 'ꟻ', 'g': 'g', 'h': 'H', 'i': 'i', 'j': 'j', 'k': 'k', 'l': 'l', 'm': 'm', 'n': 'ᴎ', 'o': 'o', 'p': 'q', 'q': 'p', 'r': 'ᴙ', 's': 'ꙅ', 't': 'T', 'u': 'U', 'v': 'v', 'w': 'w', 'x': 'x', 'y': 'Y', 'z': 'z', '{': '{', '|': '|', '}': '}', '~': '∽', "'": "'"}}


def slugify(string):
    """Removes restricted characters from filename and replaces relevant characters with allowed characters."""
    restricted = r'\/:*?"<>|'
    string = string.strip().replace('\"', "'").replace(':', ' -').replace('/', '-')
    while string[-1] in ['.']:
        string = string[0:-1]
    return ''.join(s for s in string if s not in restricted)


def convert_unicode(string, style):
    """Returns unicode text in the selected style for a string.

    Allowed styles: Circled, Circled (neg), Fullwidth, Math bold, Math bold Fraktur, Math bold italic,
    Math bold script, Math double-struck, Math monospace, Math sans, Math sans bold, Math sans bold italic,
    Math sans italic, Parenthesized, Regional Indicator, Squared, Squared (neg), Tag, A-cute pseudoalphabet,
    CJK+Thai pseudoalphabet, Curvy 1 pseudoalphabet, Curvy 2 pseudoalphabet, Curvy 3 pseudoalphabet,
    Faux Cyrillic pseudoalphabet, Faux Ethiopic pseudoalphabet, Math Fraktur pseudoalphabet, Rock Dots pseudoalphabet,
    Small Caps pseudoalphabet, Stroked pseudoalphabet, Subscript pseudoalphabet, Superscript pseudoalphabet,
    Reversed pseudoalphabet
    """
    if style not in _STYLES_CONVERSION:
        raise InvalidStyleError(style)
    result = ''
    for s in string:
        if s in _STYLES_CONVERSION[style]:
            result += _STYLES_CONVERSION[style][s]
        else:
            result += s
    return result


def wide(string): return convert_unicode(string, 'Fullwidth')
def bold(string): return convert_unicode(string, 'Math bold')
def bold_italic(string): return convert_unicode(string, 'Math bold italic')
def sans_bold(string): return convert_unicode(string, 'Math sans bold')
def sans_bold_italic(string): return convert_unicode(string, 'Math sans bold italic')
def sans_italic(string): return convert_unicode(string, 'Math sans italic')
