import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { STSServiceException as __BaseException } from "./STSServiceException";

export interface AssumedRoleUser {
    
    AssumedRoleId: string | undefined;
    
    Arn: string | undefined;
}
export declare namespace AssumedRoleUser {
    
    const filterSensitiveLog: (obj: AssumedRoleUser) => any;
}

export interface PolicyDescriptorType {
    
    arn?: string;
}
export declare namespace PolicyDescriptorType {
    
    const filterSensitiveLog: (obj: PolicyDescriptorType) => any;
}

export interface Tag {
    
    Key: string | undefined;
    
    Value: string | undefined;
}
export declare namespace Tag {
    
    const filterSensitiveLog: (obj: Tag) => any;
}
export interface AssumeRoleRequest {
    
    RoleArn: string | undefined;
    
    RoleSessionName: string | undefined;
    
    PolicyArns?: PolicyDescriptorType[];
    
    Policy?: string;
    
    DurationSeconds?: number;
    
    Tags?: Tag[];
    
    TransitiveTagKeys?: string[];
    
    ExternalId?: string;
    
    SerialNumber?: string;
    
    TokenCode?: string;
    
    SourceIdentity?: string;
}
export declare namespace AssumeRoleRequest {
    
    const filterSensitiveLog: (obj: AssumeRoleRequest) => any;
}

export interface Credentials {
    
    AccessKeyId: string | undefined;
    
    SecretAccessKey: string | undefined;
    
    SessionToken: string | undefined;
    
    Expiration: Date | undefined;
}
export declare namespace Credentials {
    
    const filterSensitiveLog: (obj: Credentials) => any;
}

export interface AssumeRoleResponse {
    
    Credentials?: Credentials;
    
    AssumedRoleUser?: AssumedRoleUser;
    
    PackedPolicySize?: number;
    
    SourceIdentity?: string;
}
export declare namespace AssumeRoleResponse {
    
    const filterSensitiveLog: (obj: AssumeRoleResponse) => any;
}

export declare class ExpiredTokenException extends __BaseException {
    readonly name: "ExpiredTokenException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ExpiredTokenException, __BaseException>);
}

export declare class MalformedPolicyDocumentException extends __BaseException {
    readonly name: "MalformedPolicyDocumentException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<MalformedPolicyDocumentException, __BaseException>);
}

export declare class PackedPolicyTooLargeException extends __BaseException {
    readonly name: "PackedPolicyTooLargeException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<PackedPolicyTooLargeException, __BaseException>);
}

export declare class RegionDisabledException extends __BaseException {
    readonly name: "RegionDisabledException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<RegionDisabledException, __BaseException>);
}
export interface AssumeRoleWithSAMLRequest {
    
    RoleArn: string | undefined;
    
    PrincipalArn: string | undefined;
    
    SAMLAssertion: string | undefined;
    
    PolicyArns?: PolicyDescriptorType[];
    
    Policy?: string;
    
    DurationSeconds?: number;
}
export declare namespace AssumeRoleWithSAMLRequest {
    
    const filterSensitiveLog: (obj: AssumeRoleWithSAMLRequest) => any;
}

export interface AssumeRoleWithSAMLResponse {
    
    Credentials?: Credentials;
    
    AssumedRoleUser?: AssumedRoleUser;
    
    PackedPolicySize?: number;
    
    Subject?: string;
    
    SubjectType?: string;
    
    Issuer?: string;
    
    Audience?: string;
    
    NameQualifier?: string;
    
    SourceIdentity?: string;
}
export declare namespace AssumeRoleWithSAMLResponse {
    
    const filterSensitiveLog: (obj: AssumeRoleWithSAMLResponse) => any;
}

export declare class IDPRejectedClaimException extends __BaseException {
    readonly name: "IDPRejectedClaimException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<IDPRejectedClaimException, __BaseException>);
}

export declare class InvalidIdentityTokenException extends __BaseException {
    readonly name: "InvalidIdentityTokenException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidIdentityTokenException, __BaseException>);
}
export interface AssumeRoleWithWebIdentityRequest {
    
    RoleArn: string | undefined;
    
    RoleSessionName: string | undefined;
    
    WebIdentityToken: string | undefined;
    
    ProviderId?: string;
    
    PolicyArns?: PolicyDescriptorType[];
    
    Policy?: string;
    
    DurationSeconds?: number;
}
export declare namespace AssumeRoleWithWebIdentityRequest {
    
    const filterSensitiveLog: (obj: AssumeRoleWithWebIdentityRequest) => any;
}

export interface AssumeRoleWithWebIdentityResponse {
    
    Credentials?: Credentials;
    
    SubjectFromWebIdentityToken?: string;
    
    AssumedRoleUser?: AssumedRoleUser;
    
    PackedPolicySize?: number;
    
    Provider?: string;
    
    Audience?: string;
    
    SourceIdentity?: string;
}
export declare namespace AssumeRoleWithWebIdentityResponse {
    
    const filterSensitiveLog: (obj: AssumeRoleWithWebIdentityResponse) => any;
}

export declare class IDPCommunicationErrorException extends __BaseException {
    readonly name: "IDPCommunicationErrorException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<IDPCommunicationErrorException, __BaseException>);
}
export interface DecodeAuthorizationMessageRequest {
    
    EncodedMessage: string | undefined;
}
export declare namespace DecodeAuthorizationMessageRequest {
    
    const filterSensitiveLog: (obj: DecodeAuthorizationMessageRequest) => any;
}

export interface DecodeAuthorizationMessageResponse {
    
    DecodedMessage?: string;
}
export declare namespace DecodeAuthorizationMessageResponse {
    
    const filterSensitiveLog: (obj: DecodeAuthorizationMessageResponse) => any;
}

export declare class InvalidAuthorizationMessageException extends __BaseException {
    readonly name: "InvalidAuthorizationMessageException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidAuthorizationMessageException, __BaseException>);
}
export interface GetAccessKeyInfoRequest {
    
    AccessKeyId: string | undefined;
}
export declare namespace GetAccessKeyInfoRequest {
    
    const filterSensitiveLog: (obj: GetAccessKeyInfoRequest) => any;
}
export interface GetAccessKeyInfoResponse {
    
    Account?: string;
}
export declare namespace GetAccessKeyInfoResponse {
    
    const filterSensitiveLog: (obj: GetAccessKeyInfoResponse) => any;
}
export interface GetCallerIdentityRequest {
}
export declare namespace GetCallerIdentityRequest {
    
    const filterSensitiveLog: (obj: GetCallerIdentityRequest) => any;
}

export interface GetCallerIdentityResponse {
    
    UserId?: string;
    
    Account?: string;
    
    Arn?: string;
}
export declare namespace GetCallerIdentityResponse {
    
    const filterSensitiveLog: (obj: GetCallerIdentityResponse) => any;
}
export interface GetFederationTokenRequest {
    
    Name: string | undefined;
    
    Policy?: string;
    
    PolicyArns?: PolicyDescriptorType[];
    
    DurationSeconds?: number;
    
    Tags?: Tag[];
}
export declare namespace GetFederationTokenRequest {
    
    const filterSensitiveLog: (obj: GetFederationTokenRequest) => any;
}

export interface FederatedUser {
    
    FederatedUserId: string | undefined;
    
    Arn: string | undefined;
}
export declare namespace FederatedUser {
    
    const filterSensitiveLog: (obj: FederatedUser) => any;
}

export interface GetFederationTokenResponse {
    
    Credentials?: Credentials;
    
    FederatedUser?: FederatedUser;
    
    PackedPolicySize?: number;
}
export declare namespace GetFederationTokenResponse {
    
    const filterSensitiveLog: (obj: GetFederationTokenResponse) => any;
}
export interface GetSessionTokenRequest {
    
    DurationSeconds?: number;
    
    SerialNumber?: string;
    
    TokenCode?: string;
}
export declare namespace GetSessionTokenRequest {
    
    const filterSensitiveLog: (obj: GetSessionTokenRequest) => any;
}

export interface GetSessionTokenResponse {
    
    Credentials?: Credentials;
}
export declare namespace GetSessionTokenResponse {
    
    const filterSensitiveLog: (obj: GetSessionTokenResponse) => any;
}
