import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { DeleteSecretRequest, DeleteSecretResponse } from "../models/models_0";
import { SecretsManagerClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../SecretsManagerClient";
export interface DeleteSecretCommandInput extends DeleteSecretRequest {
}
export interface DeleteSecretCommandOutput extends DeleteSecretResponse, __MetadataBearer {
}
/**
 * <p>Deletes a secret and all of its versions. You can specify a recovery
 *       window during which you can restore the secret. The minimum recovery window is 7 days.
 *       The default recovery window is 30 days. Secrets Manager attaches a <code>DeletionDate</code> stamp to
 *       the secret that specifies the end of the recovery window. At the end of the recovery window,
 *       Secrets Manager deletes the secret permanently.</p>
 *          <p>You can't delete a primary secret that is replicated to other Regions. You must first delete the
 *     replicas using <a>RemoveRegionsFromReplication</a>, and then delete the primary secret.
 *     When you delete a replica, it is deleted immediately.</p>
 *          <p>You can't directly delete a version of a secret. Instead, you remove all staging labels
 *     from the version using <a>UpdateSecretVersionStage</a>. This marks the version as deprecated,
 *     and then Secrets Manager can automatically delete the version in the background.</p>
 *          <p>To determine whether an application still uses a secret, you can create an Amazon CloudWatch alarm
 *     to alert you to any attempts to access a secret during the recovery window. For more information,
 *     see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/monitoring_cloudwatch_deleted-secrets.html">
 *     Monitor secrets scheduled for deletion</a>.</p>
 *          <p>Secrets Manager performs the permanent secret deletion at the end of the waiting period as a
 *         background task with low priority. There is no guarantee of a specific time after the
 *         recovery window for the permanent delete to occur.</p>
 *          <p>At any time before recovery window ends, you can use <a>RestoreSecret</a> to
 *       remove the <code>DeletionDate</code> and cancel the deletion of the secret.</p>
 *          <p>When a secret is scheduled for deletion, you cannot retrieve the secret value.
 *       You must first cancel the deletion with <a>RestoreSecret</a> and then you can retrieve the secret.</p>
 *          <p>
 *             <b>Required permissions: </b>
 *             <code>secretsmanager:DeleteSecret</code>.
 *       For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#reference_iam-permissions_actions">
 *       IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication
 *       and access control in Secrets Manager</a>. </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { SecretsManagerClient, DeleteSecretCommand } from "@aws-sdk/client-secrets-manager"; // ES Modules import
 * // const { SecretsManagerClient, DeleteSecretCommand } = require("@aws-sdk/client-secrets-manager"); // CommonJS import
 * const client = new SecretsManagerClient(config);
 * const command = new DeleteSecretCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DeleteSecretCommandInput} for command's `input` shape.
 * @see {@link DeleteSecretCommandOutput} for command's `response` shape.
 * @see {@link SecretsManagerClientResolvedConfig | config} for SecretsManagerClient's `config` shape.
 *
 */
export declare class DeleteSecretCommand extends $Command<DeleteSecretCommandInput, DeleteSecretCommandOutput, SecretsManagerClientResolvedConfig> {
    readonly input: DeleteSecretCommandInput;
    constructor(input: DeleteSecretCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: SecretsManagerClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteSecretCommandInput, DeleteSecretCommandOutput>;
    private serialize;
    private deserialize;
}
