import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetResourcePolicyRequest, GetResourcePolicyResponse } from "../models/models_0";
import { deserializeAws_json1_1GetResourcePolicyCommand, serializeAws_json1_1GetResourcePolicyCommand, } from "../protocols/Aws_json1_1";
var GetResourcePolicyCommand = (function (_super) {
    __extends(GetResourcePolicyCommand, _super);
    function GetResourcePolicyCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetResourcePolicyCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "GetResourcePolicyCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetResourcePolicyRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetResourcePolicyResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetResourcePolicyCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1GetResourcePolicyCommand(input, context);
    };
    GetResourcePolicyCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1GetResourcePolicyCommand(output, context);
    };
    return GetResourcePolicyCommand;
}($Command));
export { GetResourcePolicyCommand };
