"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchIndex = exports.SearchIndexProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ots_generated_1 = require("./ots.generated");
Object.defineProperty(exports, "SearchIndexProperty", { enumerable: true, get: function () { return ots_generated_1.RosSearchIndex; } });
/**
 * A ROS resource type:  `ALIYUN::OTS::SearchIndex`
 */
class SearchIndex extends ros.Resource {
    /**
     * Create a new `ALIYUN::OTS::SearchIndex`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSearchIndex = new ots_generated_1.RosSearchIndex(this, id, {
            indexName: props.indexName,
            instanceName: props.instanceName,
            tableName: props.tableName,
            fieldSchemas: props.fieldSchemas,
            indexSort: props.indexSort,
            indexSetting: props.indexSetting,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSearchIndex;
        this.attrIndexName = rosSearchIndex.attrIndexName;
    }
}
exports.SearchIndex = SearchIndex;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VhcmNoaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzZWFyY2hpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQWlEO0FBRXRCLG9HQUZsQiw4QkFBYyxPQUV1QjtBQXdDOUM7O0dBRUc7QUFDSCxNQUFhLFdBQVksU0FBUSxHQUFHLENBQUMsUUFBUTtJQVl6Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXVCLEVBQUUsbUNBQTJDLElBQUk7UUFDbEgsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLGNBQWMsR0FBRyxJQUFJLDhCQUFjLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNqRCxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtTQUNuQyxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLGNBQWMsQ0FBQztRQUMvQixJQUFJLENBQUMsYUFBYSxHQUFHLGNBQWMsQ0FBQyxhQUFhLENBQUM7SUFDdEQsQ0FBQztDQUNKO0FBakNELGtDQWlDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc1NlYXJjaEluZGV4IH0gZnJvbSAnLi9vdHMuZ2VuZXJhdGVkJztcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuZXhwb3J0IHsgUm9zU2VhcmNoSW5kZXggYXMgU2VhcmNoSW5kZXhQcm9wZXJ0eSB9O1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6T1RTOjpTZWFyY2hJbmRleGBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTZWFyY2hJbmRleFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGZpZWxkU2NoZW1hczogbGlzdCBvZiBmaWVsZF9zY2hlbWEuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZmllbGRTY2hlbWFzOiBBcnJheTxSb3NTZWFyY2hJbmRleC5GaWVsZFNjaGVtYXNQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBpbmRleE5hbWU6IFRoZSBpbmRleCBuYW1lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluZGV4TmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaW5zdGFuY2VOYW1lOiBUaGUgbmFtZSBvZiB0aGUgT1RTIGluc3RhbmNlIGluIHdoaWNoIHRhYmxlIHdpbGwgbG9jYXRlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlTmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdGFibGVOYW1lOiBUaGUgdGFibGUgbmFtZSBvZiB0aGUgT1RTIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhYmxlTmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaW5kZXhTZXR0aW5nOiBJbmRleCBzZXR0aW5nc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGluZGV4U2V0dGluZz86IFJvc1NlYXJjaEluZGV4LkluZGV4U2V0dGluZ1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaW5kZXhTb3J0OiBUaGlzIHBhcmFtZXRlciBzcGVjaWZpZXMgaG93IGRhdGEgaXMgc29ydGVkLiBcbiAgICAgKiBCeSBkZWZhdWx0LCB0aGUgZGF0YSBpcyBzb3J0ZWQgaW4gdGhlIHNhbWUgd2F5IGFzIHRoZSBwcmltYXJ5IGtleSBvZiB0aGUgdGFibGUuIFxuICAgICAqIElmIHRoZSBzZWFyY2ggaW5kZXggY29udGFpbnMgTkVTVEVEIGZpZWxkcywgZGF0YSBpcyBub3Qgc29ydGVkIGJ5IGRlZmF1bHQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5kZXhTb3J0PzogUm9zU2VhcmNoSW5kZXguSW5kZXhTb3J0UHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogQSBST1MgcmVzb3VyY2UgdHlwZTogIGBBTElZVU46Ok9UUzo6U2VhcmNoSW5kZXhgXG4gKi9cbmV4cG9ydCBjbGFzcyBTZWFyY2hJbmRleCBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgcHJvcGVydGllcyBvZiB0aGlzIFJPUyByZXNvdXJjZSwgd2hpY2ggd2lsbCBiZSBhc3NpZ25lZCB0byBST1MgcmVzb3VyY2UuXG4gICAgICovXG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgSW5kZXhOYW1lOiBJbmRleCBuYW1lLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRySW5kZXhOYW1lOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6T1RTOjpTZWFyY2hJbmRleGAuXG4gICAgICpcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU2VhcmNoSW5kZXhQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCByb3NTZWFyY2hJbmRleCA9IG5ldyBSb3NTZWFyY2hJbmRleCh0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIGluZGV4TmFtZTogcHJvcHMuaW5kZXhOYW1lLFxuICAgICAgICAgICAgaW5zdGFuY2VOYW1lOiBwcm9wcy5pbnN0YW5jZU5hbWUsXG4gICAgICAgICAgICB0YWJsZU5hbWU6IHByb3BzLnRhYmxlTmFtZSxcbiAgICAgICAgICAgIGZpZWxkU2NoZW1hczogcHJvcHMuZmllbGRTY2hlbWFzLFxuICAgICAgICAgICAgaW5kZXhTb3J0OiBwcm9wcy5pbmRleFNvcnQsXG4gICAgICAgICAgICBpbmRleFNldHRpbmc6IHByb3BzLmluZGV4U2V0dGluZyxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NTZWFyY2hJbmRleDtcbiAgICAgICAgdGhpcy5hdHRySW5kZXhOYW1lID0gcm9zU2VhcmNoSW5kZXguYXR0ckluZGV4TmFtZTtcbiAgICB9XG59XG4iXX0=