# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['spraycharles',
 'spraycharles.targets',
 'spraycharles.targets.classes',
 'spraycharles.utils']

package_data = \
{'': ['*']}

install_requires = \
['click-config-file>=0.6.0,<0.7.0',
 'click>=8.1.2,<9.0.0',
 'discord-webhook>=0.15.0,<0.16.0',
 'impacket>=0.9.24,<0.10.0',
 'notifiers>=1.3.3,<2.0.0',
 'numpy>=1.22.3,<2.0.0',
 'pymsteams>=0.2.1,<0.3.0',
 'requests>=2.27.1,<3.0.0',
 'requests_ntlm>=1.1.0,<2.0.0',
 'rich>=12.0.1,<13.0.0',
 'texttable>=1.6.4,<2.0.0']

entry_points = \
{'console_scripts': ['sc = spraycharles.spraycharles:cli',
                     'spraycharles = spraycharles.spraycharles:cli']}

setup_kwargs = {
    'name': 'spraycharles',
    'version': '1.0.7',
    'description': 'Low and slow password spraying tool, designed to spray on an interval over a long period of time.',
    'long_description': 'spraycharles\n======\n## Overview ##\nLow and slow password spraying tool, designed to spray on an interval over a long period of time.\n\nAssociated [blog post](https://www.sprocketsecurity.com/blog/how-to-bypass-mfa-all-day) by [@sprocket_ed](https://twitter.com/sprocket_ed) covering NTLM over HTTP, Exchange Web Services and spraycharles.\n\n## Content ##\n- [Install](#install)\n  - [Using pipx](#using-pipx)\n  - [Using Docker](#using-docker)\n- [Usage](#usage)\n  - [Config File](#config-file)\n  - [Notifications](#notifications)\n  - [Examples](#examples)\n- [Utilities](#utilities)\n  - [Generating Custom Spray Lists](#generating-custom-spray-lists)\n  - [Extracting Domain from NTLM over HTTP and SMB](#extracting-domain-from-ntlm-over-http-and-smb)\n  - [Analyzing the results CSV file](#analyzing-the-results-csv-file)\n- [Disclaimer](#disclaimer)\n- [Development](#development)\n- [Credits](#credits)\n\n## Install ##\n\n### Using pipx ###\n\nYou can use pipx to to install the spraycharles package into an isolated environment. First install pipx:\n\n```\npip3 install pipx\npipx ensurepath\n```\n\nFollowing this, install the package directly from GitHub using the following command:\n\n```\npipx install spraycharles\n```\n\nThe spraycharles package will then be in your path and useable from anywhere.\n\nNote that log and output CSV files are stored in a directory created in your users home folder with the name `.spraycharles`. These log and CSV files are dynamically created on runtime. These files are in the format:\n\n```\ntarget-host.timestamp.csv\n```\n\nSee [usage](#usage) for instructions on how to specify an alternative location for your CSV file.\n\n### Using Docker ###\nExecute the following commands to build the spraycharles Docker container:\n\n```\ngit clone https://github.com/Tw1sm/spraycharles\ncd spraycharles/extras\ndocker build . -t spraycharles\n```\n\nExecute the following command to use the spraycharles Docker container:\n\n```\ndocker run -it -v ~/.spraycharles:/root/.spraycharles spraycharles -h\n```\n\nYou may need to specify additional volumes based on where username a password lists are being stored.\n\n\n<br/>\n\n## Usage ##\n```\nUsage: spraycharles spray [OPTIONS]\n\n  Low and slow password spraying tool.\n\nOptions:\n  -p, --passwords TEXT            Filepath of the passwords list or a single\n                                  password to spray.  [required]\n  -u, --usernames TEXT            Filepath of the usernames list.  [required]\n  -H, --host TEXT                 Host to password spray (ip or hostname). Can\n                                  by anything when using Office365 module -\n                                  only used for logfile name.\n  -m, --module TEXT               Module corresponding to target host.\n                                  [required]\n  --path TEXT                     NTLM authentication endpoint. Ex: rpc or ews\n  -o, --output TEXT               Name and path of output csv where attempts\n                                  will be logged.\n  -a, --attempts INTEGER          Number of logins submissions per interval\n                                  (for each user).\n  -i, --interval INTEGER          Minutes inbetween login intervals.\n  -e, --equal INTEGER             Does 1 spray for each user where password =\n                                  username.\n  -t, --timeout INTEGER           Web request timeout threshold. Default is 5\n                                  seconds.\n  -P, --port INTEGER              Port to connect to on the specified host.\n                                  Default is 443.\n  -f, --fireprox TEXT             The url of the fireprox interface, if you\n                                  are using fireprox.\n  -d, --domain TEXT               HTTP: Prepend DOMAIN\\ to usernames. SMB:\n                                  Supply domain for smb connection.\n  --analyze                       Run the results analyzer after each spray\n                                  interval. False positives are more likely\n  --pause                         Pause the spray following a potentially\n                                  successful login\n  -j, --jitter INTEGER            Jitter time between requests in seconds.\n  -jm, --jitter-min INTEGER       Minimum time between requests in seconds.\n  -n, --notify [teams|slack|discord]\n                                  Enable notifications for Slack, MS Teams or\n                                  Discord.\n  -w, --webhook TEXT              Webhook used for specified notification\n                                  module\n  --config FILE                   Read configuration from FILE.\n  -h, --help                      Show this message and exit.\n```\n\nSpraycharles also includes other submodules:\n\n```\nUsage: spraycharles [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  --help  Show this message and exit.\n\nCommands:\n  analyze  Analyze existing csv files.\n  gen      Generate custom password lists from JSON file.\n  list     List all the available spraying modules\n  parse    Parse NTLM over HTTP and SMB endpoints to collect domain...\n  spray    Low and slow password spraying tool.\n```\n\nSee below for further information about these modules.\n\n#### Config File\nIt is possible to pre-populate command line arguments form a configuration file using the `--config` argument.\n\nAn example configuration file is listed below:\n\n```\nusernames = \'/tmp/users.txt\'\npasswords = \'/tmp/passwords.txt\'\noutput = \'mail.acme.com.csv\'\nmodule = \'owa\'\nhost = \'mail.acme.com\'\ndomain = \'ACME\'\nanalyze = \'True\'\nattempts = \'1\'\ninterval = \'30\'\ntimeout = \'25\'\n```\n\n<br/>\n\n### Notifications ###\nSpraycharles has the ability to issue notifications to Discord, Slack and Microsoft Teams following a potentially successful login attempt. This list of notification providers can augmented using the utils/notify.py script. For any of the potential notification agents, you must specify its name and a webhook URL.\n\nIt is best to specify this information using the configuration file to keep your command shorter:\n\n```\nnotify = \'slack\'\nwebhook = \'https://hooks.slack.com/services/T00000000/B00000000/XXXXXXXXXXXXXXXXXXXXXXXX\'\n```\n\nNotifications sent to any of the providers will include the targeted hostname associated with the spraying job. This is expecially useful when spraying multiple targets at once using spraycharles.\n\n<br/>\n\n### Examples ###\nBasic usage (Office365)\n```\nspraycharles spray -u users.txt -p passwords.txt -m Office365\n```\nBasic usage (non-Office365) with a single password, supplied via command line\n```\nspraycharles spray -u users.txt -H webmail.company.com -p Password123 -m owa\n```\nAttempt 5 logins per user every 20 minutes\n```\nspraycharles spray -u users.txt -H webmail.company.com -p passwords.txt -i 20 -a 5 -m owa\n```\nUsage with fireprox (Office365)\n```\nspraycharles spray -u users.txt -p passwords.txt -m office365 -f abcdefg.execute-api.us-east-1.amazonawms.com\n```\nSpray host over SMB with 2 attempts per user every hour\n```\nspraycharles spray -u users.txt -p passwords.txt -m Smb -H 10.10.1.5 -a 2 -i 60\n```\n\n<br/>\n\n## Utilities ##\nSpraycharles is packaged with some additional utilities to assist with spraying efforts.\n<br/>\n\n#### Generating Custom Spray Lists\nThe spraycharles "gen" subcommand will generate a password list based off the specifications provided in extras/list_elements.json\n\n```\nspraycharles gen extras/list_elements.json custom_passwords.txt\n```\n\n<br/>\n\n#### Extracting Domain from NTLM over HTTP and SMB\nThe spraycharles parse subcommand will extract the internal domain from both NTLM over HTTP and SMB services using a command similar to the one listed below.\n\n\n```\nspraycharles parse https://example.com/ews\n```\n\n<br/>\n\n### Analyzing the results CSV file ###\nThe `analyze` submodule can read your output CSV and determine response lengths that are statistically relevant. With enough data, it should be able to pull successful logins out of your CSV file. This is not the only way to determine successful logins, depending on your target site, and I would still recommend checking the data yourself to be sure nothing is missed. For SMB, it will simply find entries with NTSTATUS codes that indicate success.\n\n```\nspraycharles analyze myresults.csv\n```\n\n<br/>\n\n## Disclaimer ##\nThis tool is designed for use during penetration testing; usage of this tool for attacking targets without prior mutual consent is illegal. It is the end user\'s responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse of this program.\n<br/>\n\n## Development ##\nGit pre-commit is used to maintain code quality and ensure uniform formatting. To begin developing with spraycharles:\n\n```\npip3 install poetry\ngit clone https://github.com/Tw1sm/spraycharles\ncd spraycharles\npoetry shell && poetry install\n```\n\nTests for the spraycharles project are written and stored in the tests directory. A more extensive testing harness is coming soon!\n<br/>\n\n## Credits ##\n- [@sprocket_ed](https://twitter.com/sprocket_ed) for contributing: several spray modules, many of features that make spraycharles great, and the associated blog post\n- [@b17zr](https://twitter.com/b17zr) for the `ntlm_challenger.py` script, which is included in the `utils` folder\n',
    'author': 'Matt Creel',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Tw1sm/spraycharles',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
