# coding: utf-8

"""
    Xero Payroll NZ

    This is the Xero Payroll API for orgs in the NZ region.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class EmployeeLeaveSetup(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "include_holiday_pay": "bool",
        "holiday_pay_opening_balance": "float",
        "annual_leave_opening_balance": "float",
        "negative_annual_leave_balance_paid_amount": "float",
        "sick_leave_hours_to_accrue_annually": "float",
        "sick_leave_maximum_hours_to_accrue": "float",
        "sick_leave_opening_balance": "float",
    }

    attribute_map = {
        "include_holiday_pay": "includeHolidayPay",
        "holiday_pay_opening_balance": "holidayPayOpeningBalance",
        "annual_leave_opening_balance": "annualLeaveOpeningBalance",
        "negative_annual_leave_balance_paid_amount": "negativeAnnualLeaveBalancePaidAmount",
        "sick_leave_hours_to_accrue_annually": "sickLeaveHoursToAccrueAnnually",
        "sick_leave_maximum_hours_to_accrue": "sickLeaveMaximumHoursToAccrue",
        "sick_leave_opening_balance": "sickLeaveOpeningBalance",
    }

    def __init__(
        self,
        include_holiday_pay=None,
        holiday_pay_opening_balance=None,
        annual_leave_opening_balance=None,
        negative_annual_leave_balance_paid_amount=None,
        sick_leave_hours_to_accrue_annually=None,
        sick_leave_maximum_hours_to_accrue=None,
        sick_leave_opening_balance=None,
    ):  # noqa: E501
        """EmployeeLeaveSetup - a model defined in OpenAPI"""  # noqa: E501

        self._include_holiday_pay = None
        self._holiday_pay_opening_balance = None
        self._annual_leave_opening_balance = None
        self._negative_annual_leave_balance_paid_amount = None
        self._sick_leave_hours_to_accrue_annually = None
        self._sick_leave_maximum_hours_to_accrue = None
        self._sick_leave_opening_balance = None
        self.discriminator = None

        if include_holiday_pay is not None:
            self.include_holiday_pay = include_holiday_pay
        if holiday_pay_opening_balance is not None:
            self.holiday_pay_opening_balance = holiday_pay_opening_balance
        if annual_leave_opening_balance is not None:
            self.annual_leave_opening_balance = annual_leave_opening_balance
        if negative_annual_leave_balance_paid_amount is not None:
            self.negative_annual_leave_balance_paid_amount = (
                negative_annual_leave_balance_paid_amount
            )
        if sick_leave_hours_to_accrue_annually is not None:
            self.sick_leave_hours_to_accrue_annually = (
                sick_leave_hours_to_accrue_annually
            )
        if sick_leave_maximum_hours_to_accrue is not None:
            self.sick_leave_maximum_hours_to_accrue = sick_leave_maximum_hours_to_accrue
        if sick_leave_opening_balance is not None:
            self.sick_leave_opening_balance = sick_leave_opening_balance

    @property
    def include_holiday_pay(self):
        """Gets the include_holiday_pay of this EmployeeLeaveSetup.  # noqa: E501

        Identifier if holiday pay will be included in each payslip  # noqa: E501

        :return: The include_holiday_pay of this EmployeeLeaveSetup.  # noqa: E501
        :rtype: bool
        """
        return self._include_holiday_pay

    @include_holiday_pay.setter
    def include_holiday_pay(self, include_holiday_pay):
        """Sets the include_holiday_pay of this EmployeeLeaveSetup.

        Identifier if holiday pay will be included in each payslip  # noqa: E501

        :param include_holiday_pay: The include_holiday_pay of this EmployeeLeaveSetup.  # noqa: E501
        :type: bool
        """

        self._include_holiday_pay = include_holiday_pay

    @property
    def holiday_pay_opening_balance(self):
        """Gets the holiday_pay_opening_balance of this EmployeeLeaveSetup.  # noqa: E501

        Initial holiday pay balance. A percentage — usually 8% — of gross earnings since their last work anniversary.  # noqa: E501

        :return: The holiday_pay_opening_balance of this EmployeeLeaveSetup.  # noqa: E501
        :rtype: float
        """
        return self._holiday_pay_opening_balance

    @holiday_pay_opening_balance.setter
    def holiday_pay_opening_balance(self, holiday_pay_opening_balance):
        """Sets the holiday_pay_opening_balance of this EmployeeLeaveSetup.

        Initial holiday pay balance. A percentage — usually 8% — of gross earnings since their last work anniversary.  # noqa: E501

        :param holiday_pay_opening_balance: The holiday_pay_opening_balance of this EmployeeLeaveSetup.  # noqa: E501
        :type: float
        """

        self._holiday_pay_opening_balance = holiday_pay_opening_balance

    @property
    def annual_leave_opening_balance(self):
        """Gets the annual_leave_opening_balance of this EmployeeLeaveSetup.  # noqa: E501

        Initial annual leave balance. The balance at their last anniversary, less any leave taken since then and excluding accrued annual leave.  # noqa: E501

        :return: The annual_leave_opening_balance of this EmployeeLeaveSetup.  # noqa: E501
        :rtype: float
        """
        return self._annual_leave_opening_balance

    @annual_leave_opening_balance.setter
    def annual_leave_opening_balance(self, annual_leave_opening_balance):
        """Sets the annual_leave_opening_balance of this EmployeeLeaveSetup.

        Initial annual leave balance. The balance at their last anniversary, less any leave taken since then and excluding accrued annual leave.  # noqa: E501

        :param annual_leave_opening_balance: The annual_leave_opening_balance of this EmployeeLeaveSetup.  # noqa: E501
        :type: float
        """

        self._annual_leave_opening_balance = annual_leave_opening_balance

    @property
    def negative_annual_leave_balance_paid_amount(self):
        """Gets the negative_annual_leave_balance_paid_amount of this EmployeeLeaveSetup.  # noqa: E501

        The dollar value of annual leave opening balance if negative.  # noqa: E501

        :return: The negative_annual_leave_balance_paid_amount of this EmployeeLeaveSetup.  # noqa: E501
        :rtype: float
        """
        return self._negative_annual_leave_balance_paid_amount

    @negative_annual_leave_balance_paid_amount.setter
    def negative_annual_leave_balance_paid_amount(
        self, negative_annual_leave_balance_paid_amount
    ):
        """Sets the negative_annual_leave_balance_paid_amount of this EmployeeLeaveSetup.

        The dollar value of annual leave opening balance if negative.  # noqa: E501

        :param negative_annual_leave_balance_paid_amount: The negative_annual_leave_balance_paid_amount of this EmployeeLeaveSetup.  # noqa: E501
        :type: float
        """

        self._negative_annual_leave_balance_paid_amount = (
            negative_annual_leave_balance_paid_amount
        )

    @property
    def sick_leave_hours_to_accrue_annually(self):
        """Gets the sick_leave_hours_to_accrue_annually of this EmployeeLeaveSetup.  # noqa: E501

        Number of hours accrued annually for sick leave. Multiply the number of days they're entitled to by the hours worked per day  # noqa: E501

        :return: The sick_leave_hours_to_accrue_annually of this EmployeeLeaveSetup.  # noqa: E501
        :rtype: float
        """
        return self._sick_leave_hours_to_accrue_annually

    @sick_leave_hours_to_accrue_annually.setter
    def sick_leave_hours_to_accrue_annually(self, sick_leave_hours_to_accrue_annually):
        """Sets the sick_leave_hours_to_accrue_annually of this EmployeeLeaveSetup.

        Number of hours accrued annually for sick leave. Multiply the number of days they're entitled to by the hours worked per day  # noqa: E501

        :param sick_leave_hours_to_accrue_annually: The sick_leave_hours_to_accrue_annually of this EmployeeLeaveSetup.  # noqa: E501
        :type: float
        """

        self._sick_leave_hours_to_accrue_annually = sick_leave_hours_to_accrue_annually

    @property
    def sick_leave_maximum_hours_to_accrue(self):
        """Gets the sick_leave_maximum_hours_to_accrue of this EmployeeLeaveSetup.  # noqa: E501

        Maximum number of hours accrued annually for sick leave. Multiply the maximum days they can accrue by the hours worked per day  # noqa: E501

        :return: The sick_leave_maximum_hours_to_accrue of this EmployeeLeaveSetup.  # noqa: E501
        :rtype: float
        """
        return self._sick_leave_maximum_hours_to_accrue

    @sick_leave_maximum_hours_to_accrue.setter
    def sick_leave_maximum_hours_to_accrue(self, sick_leave_maximum_hours_to_accrue):
        """Sets the sick_leave_maximum_hours_to_accrue of this EmployeeLeaveSetup.

        Maximum number of hours accrued annually for sick leave. Multiply the maximum days they can accrue by the hours worked per day  # noqa: E501

        :param sick_leave_maximum_hours_to_accrue: The sick_leave_maximum_hours_to_accrue of this EmployeeLeaveSetup.  # noqa: E501
        :type: float
        """

        self._sick_leave_maximum_hours_to_accrue = sick_leave_maximum_hours_to_accrue

    @property
    def sick_leave_opening_balance(self):
        """Gets the sick_leave_opening_balance of this EmployeeLeaveSetup.  # noqa: E501

        Initial sick leave balance. This will be positive unless they've taken sick leave in advance  # noqa: E501

        :return: The sick_leave_opening_balance of this EmployeeLeaveSetup.  # noqa: E501
        :rtype: float
        """
        return self._sick_leave_opening_balance

    @sick_leave_opening_balance.setter
    def sick_leave_opening_balance(self, sick_leave_opening_balance):
        """Sets the sick_leave_opening_balance of this EmployeeLeaveSetup.

        Initial sick leave balance. This will be positive unless they've taken sick leave in advance  # noqa: E501

        :param sick_leave_opening_balance: The sick_leave_opening_balance of this EmployeeLeaveSetup.  # noqa: E501
        :type: float
        """

        self._sick_leave_opening_balance = sick_leave_opening_balance
