# Example Python Commands using the YellowDog Python SDK

## Overview

This is a set of command line Python scripts for interacting with the YellowDog Platform, providing examples of usage of the [YellowDog Python SDK](https://docs.yellowdog.co/api/python/index.html).

The command scripts support:

- **Provisioning** Worker Pools with the **`yd-provision`** command
- **Submitting** Work Requirements with the **`yd-submit`** command
- **Uploading** files to the YellowDog Object Store with the **`yd-upload`** command
- **Instantiating** Compute Requirements with the **`yd-instantiate`** command
- **Downloading** Results from the YellowDog Object Store with the **`yd-download`** command
- **Aborting** running Tasks with the **`yd-abort`** command
- **Cancelling** Work Requirements with the **`yd-cancel`** command
- **Shutting Down** Worker Pools with the **`yd-shutdown`** command
- **Terminating** Compute Requirements with the **`yd-terminate`** command
- **Deleting** objects in the YellowDog Object Store with the **`yd-delete`** command
- **Listing** YellowDog items using the **`yd-list`** command
- **Resizing** Worker Pools and Compute Requirements
- **Creating, Updating and Removing** Source Templates, Compute Templates, Keyrings, Credentials, Namespace Storage Configurations, Image Families, and Configured Worker Pools

Please see the [GitHub repository](https://github.com/yellowdog/python-examples) for more details.
