from __future__ import annotations
import typing
from solana.publickey import PublicKey
from solana.transaction import TransactionInstruction, AccountMeta
import borsh_construct as borsh
from .. import types
from ..program_id import PROGRAM_ID


class VrfProveAndVerifyArgs(typing.TypedDict):
    params: types.vrf_prove_and_verify_params.VrfProveAndVerifyParams


layout = borsh.CStruct(
    "params" / types.vrf_prove_and_verify_params.VrfProveAndVerifyParams.layout
)


class VrfProveAndVerifyAccounts(typing.TypedDict):
    vrf: PublicKey
    callback_pid: PublicKey
    token_program: PublicKey
    escrow: PublicKey
    program_state: PublicKey
    oracle: PublicKey
    oracle_authority: PublicKey
    oracle_wallet: PublicKey
    instructions_sysvar: PublicKey


def vrf_prove_and_verify(
    args: VrfProveAndVerifyArgs, accounts: VrfProveAndVerifyAccounts
) -> TransactionInstruction:
    keys: list[AccountMeta] = [
        AccountMeta(pubkey=accounts["vrf"], is_signer=False, is_writable=True),
        AccountMeta(
            pubkey=accounts["callback_pid"], is_signer=False, is_writable=False
        ),
        AccountMeta(
            pubkey=accounts["token_program"], is_signer=False, is_writable=False
        ),
        AccountMeta(pubkey=accounts["escrow"], is_signer=False, is_writable=True),
        AccountMeta(
            pubkey=accounts["program_state"], is_signer=False, is_writable=False
        ),
        AccountMeta(pubkey=accounts["oracle"], is_signer=False, is_writable=False),
        AccountMeta(
            pubkey=accounts["oracle_authority"], is_signer=True, is_writable=False
        ),
        AccountMeta(
            pubkey=accounts["oracle_wallet"], is_signer=False, is_writable=True
        ),
        AccountMeta(
            pubkey=accounts["instructions_sysvar"], is_signer=False, is_writable=False
        ),
    ]
    identifier = b'\x85\xbe\xba0\xd0\xa4\xcd"'
    encoded_args = layout.build(
        {
            "params": args["params"].to_encodable(),
        }
    )
    data = identifier + encoded_args
    return TransactionInstruction(keys, PROGRAM_ID, data)
